/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner;

import java.net.URL;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.model.DefaultDisplayable;
import oracle.ide.model.Displayable;
import oracle.ide.model.Node;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFileSystem;
import oracle.ide.runner.AbstractStarterFactory;
import oracle.ide.runner.RunProcess;
import oracle.ide.runner.Starter;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.runner.JRunProcess;
import oracle.jdeveloper.runner.JStarter;
import oracle.jdeveloper.runner.JStarterFactory;
import oracle.jdevimpl.runner.RunMgrArb;

final class JarStarterFactory
extends AbstractStarterFactory
implements JStarterFactory {
    JarStarterFactory() {
    }

    public String getName() {
        return RunMgrArb.getString(36);
    }

    public Object canStart(RunProcess runProcess, Node node, List errors) {
        String[] target;
        if (runProcess instanceof JRunProcess && (target = JarStarterFactory.isJarTarget(node, errors)) != null && runProcess.canRun("Java", null, node, errors)) {
            return target;
        }
        return null;
    }

    public Starter createStarter(RunProcess runProcess, Node node, Object o) {
        String[] target = (String[])o;
        return new JarStarter((JRunProcess)runProcess, target);
    }

    public Displayable getDisplayable(RunProcess runProcess, Context context, Node node, Object o) {
        return new 1();
    }

    private static String[] isJarTarget(Node node, List errors) {
        try {
            URL url = node.getURL();
            if (url.getProtocol().equalsIgnoreCase("file")) {
                if (URLFileSystem.getSuffix((URL)url).toUpperCase().equals(".JAR")) {
                    String mainClass = JarUtil.getMainClass((URL)url);
                    if (mainClass != null && mainClass.length() > 0) {
                        String[] stringArray = JarStarterFactory.makeTargetStrings(URLFileSystem.getPlatformPathName((URL)url));
                        return stringArray;
                    }
                    String error = RunMgrArb.format(15, node.getShortLabel());
                    errors.add(error);
                } else {
                    String error = RunMgrArb.format(49, node.getShortLabel());
                    errors.add(error);
                }
            } else if (JarUtil.isJarURL((URL)url)) {
                String error = RunMgrArb.format(11, node.getShortLabel());
                errors.add(error);
            } else {
                String error = RunMgrArb.format(102, node.getShortLabel());
                errors.add(error);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    private static String[] makeTargetStrings(String jarName) {
        String[] s = new String[]{"-jar", jarName};
        return s;
    }

    final class 1
    extends DefaultDisplayable {
        public String getShortLabel() {
            return RunMgrArb.getString(6);
        }

        public Icon getIcon() {
            return OracleIcons.getIcon((String)"archivefile.png");
        }
    }

    class JarStarter
    extends JStarter {
        JarStarter(JRunProcess jrunProcess, String[] target) {
            super(jrunProcess, target);
        }
    }
}

