/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunConfigurationEditorUtil;
import oracle.jdevimpl.runner.RunMgrArb;

class RunConfigurationToolPanel
extends DefaultTraversablePanel {
    private JCheckBox compileBeforeRunCheckBox;
    private JCheckBox runAntBeforeRunCheckBox;
    private JCheckBox clearLogBeforeRunCheckBox;
    private JCheckBox saveAllBeforeRunCheckBox;
    private JCheckBox logCommandCheckBox;
    private JCheckBox logOutputCheckBox;
    private JCheckBox logErrorCheckBox;
    private JCheckBox logExitCheckBox;
    private JCheckBox useProxyCheckBox;
    private JCheckBox allowInputCheckBox;

    RunConfigurationToolPanel() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_run_projset_runneroptionspanel_html");
        JLabel beforeRunLabel = new JLabel(RunMgrArb.getString(23));
        this.compileBeforeRunCheckBox = new JCheckBox();
        this.runAntBeforeRunCheckBox = new JCheckBox();
        this.clearLogBeforeRunCheckBox = new JCheckBox();
        this.saveAllBeforeRunCheckBox = new JCheckBox();
        JLabel logEventsLabel = new JLabel(RunMgrArb.getString(44));
        this.logCommandCheckBox = new JCheckBox();
        this.logOutputCheckBox = new JCheckBox();
        this.logErrorCheckBox = new JCheckBox();
        this.logExitCheckBox = new JCheckBox();
        JLabel additionalLabel = new JLabel(RunMgrArb.getString(77));
        this.useProxyCheckBox = new JCheckBox();
        this.allowInputCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.compileBeforeRunCheckBox, (String)RunMgrArb.getString(80));
        ResourceUtils.resButton((AbstractButton)this.runAntBeforeRunCheckBox, (String)RunMgrArb.getString(68));
        ResourceUtils.resButton((AbstractButton)this.clearLogBeforeRunCheckBox, (String)RunMgrArb.getString(20));
        ResourceUtils.resButton((AbstractButton)this.saveAllBeforeRunCheckBox, (String)RunMgrArb.getString(64));
        ResourceUtils.resButton((AbstractButton)this.logCommandCheckBox, (String)RunMgrArb.getString(26));
        ResourceUtils.resButton((AbstractButton)this.logOutputCheckBox, (String)RunMgrArb.getString(38));
        ResourceUtils.resButton((AbstractButton)this.logErrorCheckBox, (String)RunMgrArb.getString(54));
        ResourceUtils.resButton((AbstractButton)this.logExitCheckBox, (String)RunMgrArb.getString(42));
        ResourceUtils.resButton((AbstractButton)this.useProxyCheckBox, (String)RunMgrArb.getString(22));
        ResourceUtils.resButton((AbstractButton)this.allowInputCheckBox, (String)RunMgrArb.getString(12));
        this.setLayout(new GridBagLayout());
        int y = 0;
        Insets labelI = new Insets(0, 0, 5, 0);
        Insets newLabelI = new Insets(10, 0, 5, 0);
        Insets defaultI = new Insets(0, 8, 2, 0);
        this.add(beforeRunLabel, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 0, labelI, 1, 0));
        this.add(this.compileBeforeRunCheckBox, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 0, defaultI, 1, 0));
        this.add(this.runAntBeforeRunCheckBox, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 0, defaultI, 1, 0));
        this.add(this.clearLogBeforeRunCheckBox, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 0, defaultI, 1, 0));
        this.add(this.saveAllBeforeRunCheckBox, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 0, defaultI, 1, 0));
        this.add(logEventsLabel, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 0, newLabelI, 1, 0));
        this.add(this.logCommandCheckBox, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 0, defaultI, 1, 0));
        this.add(this.logOutputCheckBox, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 0, defaultI, 1, 0));
        this.add(this.logErrorCheckBox, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 0, defaultI, 1, 0));
        this.add(this.logExitCheckBox, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 0, defaultI, 1, 0));
        this.add(additionalLabel, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 0, newLabelI, 1, 0));
        this.add(this.useProxyCheckBox, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 0, defaultI, 1, 0));
        this.add(this.allowInputCheckBox, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 0, defaultI, 1, 0));
        this.add(new JLabel(), new GridBagConstraints(0, y, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void onEntry(TraversableContext tc) {
        RunConfiguration runConfiguration = RunConfigurationEditorUtil.getRunConfiguration((Namespace)tc);
        this.loadFrom(runConfiguration);
    }

    public void onExit(TraversableContext tc) {
        RunConfiguration runConfiguration = RunConfigurationEditorUtil.getRunConfiguration((Namespace)tc);
        this.commitTo(runConfiguration);
    }

    private void loadFrom(RunConfiguration runConfiguration) {
        this.compileBeforeRunCheckBox.setSelected(runConfiguration.isCompileBeforeRun());
        this.runAntBeforeRunCheckBox.setSelected(runConfiguration.isRunAntBeforeRun());
        this.clearLogBeforeRunCheckBox.setSelected(runConfiguration.isClearLogBeforeRun());
        this.saveAllBeforeRunCheckBox.setSelected(runConfiguration.isSaveAllBeforeRun());
        this.logCommandCheckBox.setSelected(runConfiguration.isLogCommand());
        this.logOutputCheckBox.setSelected(runConfiguration.isLogOutput());
        this.logErrorCheckBox.setSelected(runConfiguration.isLogError());
        this.logExitCheckBox.setSelected(runConfiguration.isLogExit());
        this.useProxyCheckBox.setSelected(runConfiguration.isUseProxy());
        this.allowInputCheckBox.setSelected(runConfiguration.isAllowInput());
    }

    private void commitTo(RunConfiguration runConfiguration) {
        runConfiguration.setCompileBeforeRun(this.compileBeforeRunCheckBox.isSelected());
        runConfiguration.setRunAntBeforeRun(this.runAntBeforeRunCheckBox.isSelected());
        runConfiguration.setClearLogBeforeRun(this.clearLogBeforeRunCheckBox.isSelected());
        runConfiguration.setSaveAllBeforeRun(this.saveAllBeforeRunCheckBox.isSelected());
        runConfiguration.setLogCommand(this.logCommandCheckBox.isSelected());
        runConfiguration.setLogOutput(this.logOutputCheckBox.isSelected());
        runConfiguration.setLogError(this.logErrorCheckBox.isSelected());
        runConfiguration.setLogExit(this.logExitCheckBox.isSelected());
        runConfiguration.setUseProxy(this.useProxyCheckBox.isSelected());
        runConfiguration.setAllowInput(this.allowInputCheckBox.isSelected());
    }
}

