/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Project;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunConfigurations;
import oracle.jdevimpl.runner.RunConfigurationEditor;
import oracle.jdevimpl.runner.RunMgrArb;

public class RunConfigurationsPanel
extends ProjectSettingsTraversablePanel
implements ActionListener {
    private DefaultListModel profilesModel;
    private List profilesNames;
    private JList profilesList;
    private JButton editButton;
    private JButton newButton;
    private JButton deleteButton;
    private JButton restoreButton;
    private Project project;
    private boolean editingCustomProperties;
    private Map definedRunConfigurations;
    private static final String[] PROPERTY_KEYS = new String[]{"runConfigurationDefinitions", "runConfigurationList"};

    public RunConfigurationsPanel() {
        JLabel profilesLabel = new JLabel();
        this.profilesModel = new DefaultListModel();
        this.profilesNames = new ArrayList();
        this.profilesList = new JList(this.profilesModel);
        this.profilesList.setSelectionMode(0);
        JScrollPane profilesScrollPane = new JScrollPane(this.profilesList);
        this.editButton = new JButton();
        this.newButton = new JButton();
        this.deleteButton = new JButton();
        this.restoreButton = new JButton();
        ResourceUtils.resLabel((JLabel)profilesLabel, (Component)this.profilesList, (String)RunMgrArb.getString(28));
        ResourceUtils.resButton((AbstractButton)this.editButton, (String)RunMgrArb.getString(60));
        ResourceUtils.resButton((AbstractButton)this.newButton, (String)RunMgrArb.getString(85));
        ResourceUtils.resButton((AbstractButton)this.deleteButton, (String)RunMgrArb.getString(59));
        ResourceUtils.resButton((AbstractButton)this.restoreButton, (String)RunMgrArb.getString(97));
        this.profilesList.addListSelectionListener(new 1());
        this.profilesList.addMouseListener(new 2());
        this.editButton.addActionListener(this);
        this.newButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        this.restoreButton.addActionListener(this);
        this.setLayout(new GridBagLayout());
        this.add(profilesLabel, new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 2, 0), 0, 0));
        this.add(profilesScrollPane, new GridBagConstraints(0, 1, 1, 0, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.editButton, new GridBagConstraints(1, 1, 0, 1, 0.0, 0.0, 18, 2, new Insets(0, 12, 5, 0), 0, 0));
        this.add(this.newButton, new GridBagConstraints(1, 2, 0, 1, 0.0, 0.0, 18, 2, new Insets(0, 12, 5, 0), 0, 0));
        this.add(this.deleteButton, new GridBagConstraints(1, 3, 0, 1, 0.0, 0.0, 18, 2, new Insets(0, 12, 5, 0), 0, 0));
        this.add(this.restoreButton, new GridBagConstraints(1, 4, 0, 1, 0.0, 0.0, 18, 2, new Insets(0, 12, 5, 0), 0, 0));
    }

    public String getDataKey() {
        return RunConfigurations.DATA_KEY;
    }

    public String[] getPropertyKeys() {
        return PROPERTY_KEYS;
    }

    public void onProjectPanelEntry(TraversableContext tc) {
        if (RunConfigurationsPanel.isDefaultProject((Namespace)tc)) {
            this.setHelpID("f1_run_ppdefault_rundebug_html");
        } else if (RunConfigurationsPanel.editingUserProperties((Namespace)tc)) {
            this.setHelpID("f1_run_ppcustom_rundebug_html");
        } else {
            this.setHelpID("f1_run_pp_rundebug_html");
        }
        RunConfigurations runConfigurations = RunConfigurationsPanel.getRunConfigurations(tc);
        this.project = ProjectSettingsTraversablePanel.getProject((Namespace)tc);
        this.editingCustomProperties = ProjectSettingsTraversablePanel.editingUserProperties((Namespace)tc);
        this.loadFrom(runConfigurations);
    }

    public void onExit(TraversableContext tc) {
        RunConfigurations runConfigurations = RunConfigurationsPanel.getRunConfigurations(tc);
        this.commitTo(runConfigurations);
    }

    private static RunConfigurations getRunConfigurations(TraversableContext tc) {
        return RunConfigurations.getInstance(RunConfigurationsPanel.getPropertyData((Namespace)tc));
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.editButton) {
            this.editRunConfiguration();
        } else if (source == this.newButton) {
            this.newRunConfiguration();
        } else if (source == this.deleteButton) {
            this.deleteRunConfiguration();
        } else if (source == this.restoreButton) {
            this.restoreRunConfiguration();
        }
    }

    private void loadFrom(RunConfigurations runConfigurations) {
        this.definedRunConfigurations = runConfigurations.getDefinedRunConfigurations();
        this.profilesModel.clear();
        this.profilesNames.clear();
        RunConfiguration[] runConfigs = runConfigurations.getVisibleRunConfigurations();
        int runConfigsLength = runConfigs.length;
        int i = 0;
        while (i < runConfigsLength) {
            this.profilesModel.addElement(runConfigs[i]);
            this.profilesNames.add(runConfigs[i].getName());
            ++i;
        }
        int index = -1;
        String activeName = RunConfigurations.getActiveName(this.project);
        if (activeName != null) {
            index = this.profilesNames.indexOf(activeName);
        }
        if (index == -1) {
            index = 0;
        }
        if (index < this.profilesNames.size()) {
            this.profilesList.setSelectedIndex(index);
        }
        this.updateButtons();
    }

    private void commitTo(RunConfigurations runConfigurations) {
        int size = this.profilesModel.size();
        RunConfiguration[] runConfigs = new RunConfiguration[size];
        int i = 0;
        while (i < size) {
            runConfigs[i] = (RunConfiguration)((Object)this.profilesModel.get(i));
            ++i;
        }
        runConfigurations.setRunConfigurations(runConfigs, this.editingCustomProperties);
        int index = this.profilesList.getSelectedIndex();
        if (index >= 0 && index < this.profilesModel.size()) {
            RunConfiguration runConfiguration = (RunConfiguration)((Object)this.profilesModel.get(index));
            RunConfigurations.setActiveRunConfiguration(this.project, runConfiguration);
        }
    }

    private void updateButtons() {
        RunConfiguration runConfiguration = (RunConfiguration)((Object)this.profilesList.getSelectedValue());
        boolean runConfigurationSelected = runConfiguration != null;
        this.editButton.setEnabled(runConfigurationSelected);
        if (this.editingCustomProperties && runConfigurationSelected && !runConfiguration.isCustom()) {
            ResourceUtils.resButton((AbstractButton)this.editButton, (String)RunMgrArb.getString(37));
        } else {
            ResourceUtils.resButton((AbstractButton)this.editButton, (String)RunMgrArb.getString(60));
        }
        this.deleteButton.setEnabled(runConfigurationSelected && this.profilesModel.size() > 1);
        if (this.editingCustomProperties) {
            ResourceUtils.resButton((AbstractButton)this.restoreButton, (String)RunMgrArb.getString(97));
            boolean foundOne = false;
            for (String name : this.definedRunConfigurations.keySet()) {
                RunConfiguration runConfig = (RunConfiguration)((Object)this.definedRunConfigurations.get(name));
                if (runConfig.isCustom() || this.profilesNames.contains(name)) continue;
                foundOne = true;
                break;
            }
            this.restoreButton.setEnabled(foundOne);
        } else {
            ResourceUtils.resButton((AbstractButton)this.restoreButton, (String)RunMgrArb.getString(78));
            if (runConfigurationSelected && runConfiguration.getName().equals(RunConfiguration.getDefaultName())) {
                this.restoreButton.setEnabled(true);
            } else {
                this.restoreButton.setEnabled(false);
            }
        }
    }

    private void editRunConfiguration() {
        RunConfiguration runConfiguration = (RunConfiguration)((Object)this.profilesList.getSelectedValue());
        if (runConfiguration != null) {
            this.editRunConfiguration(runConfiguration);
        }
    }

    private void editRunConfiguration(int index) {
        RunConfiguration runConfiguration = (RunConfiguration)((Object)this.profilesModel.get(index));
        this.editRunConfiguration(runConfiguration);
    }

    private void editRunConfiguration(RunConfiguration runConfiguration) {
        boolean allowEdit = !this.editingCustomProperties || runConfiguration.isCustom();
        RunConfigurationEditor runConfigurationEditor = new RunConfigurationEditor(runConfiguration, allowEdit);
        runConfigurationEditor.showDialog();
    }

    private void newRunConfiguration() {
        TreeSet<Object> usedNames = new TreeSet<Object>();
        usedNames.addAll(this.definedRunConfigurations.keySet());
        int i = this.profilesNames.size() - 1;
        while (i >= 0) {
            usedNames.add(this.profilesNames.get(i));
            --i;
        }
        RunConfiguration runConfiguration = (RunConfiguration)((Object)this.profilesList.getSelectedValue());
        String name = runConfiguration != null ? runConfiguration.getName() : null;
        NewDialog newDialog = new NewDialog(name, usedNames);
        if ((name = newDialog.showDialog()) != null) {
            RunConfiguration copyFrom = NewDialog.mav$getCopyFrom(newDialog);
            RunConfiguration newRunConfiguration = new RunConfiguration(copyFrom, name, this.editingCustomProperties);
            int index = this.profilesList.getSelectedIndex() + 1;
            this.profilesModel.add(index, newRunConfiguration);
            this.profilesNames.add(index, newRunConfiguration.getName());
            this.profilesList.setSelectedIndex(index);
        }
    }

    private void deleteRunConfiguration() {
        int index = this.profilesList.getSelectedIndex();
        if (index != -1) {
            this.profilesModel.remove(index);
            this.profilesNames.remove(index);
            if (index < this.profilesModel.size()) {
                this.profilesList.setSelectedIndex(index);
            } else if (index - 1 >= 0) {
                this.profilesList.setSelectedIndex(index - 1);
            }
            this.updateButtons();
        }
    }

    private void restoreRunConfiguration() {
        if (this.editingCustomProperties) {
            Set keySet = this.definedRunConfigurations.keySet();
            TreeSet set = new TreeSet();
            set.addAll(keySet);
            for (String name : keySet) {
                RunConfiguration runConfig = (RunConfiguration)((Object)this.definedRunConfigurations.get(name));
                if (!runConfig.isCustom() && !this.profilesNames.contains(name)) continue;
                set.remove(name);
            }
            RestoreDialog restoreDialog = new RestoreDialog(set);
            String[] names = restoreDialog.showDialog();
            if (names != null) {
                int namesLength = names.length;
                int i = 0;
                while (i < namesLength) {
                    RunConfiguration runConfig = (RunConfiguration)((Object)this.definedRunConfigurations.get(names[i]));
                    this.profilesModel.addElement(runConfig);
                    this.profilesNames.add(names[i]);
                    ++i;
                }
                this.updateButtons();
            }
        } else {
            RunConfiguration runConfiguration = (RunConfiguration)((Object)this.profilesList.getSelectedValue());
            if (runConfiguration != null) {
                runConfiguration.restoreDefaults();
            }
        }
    }

    static DefaultListModel ra$profilesModel(RunConfigurationsPanel runConfigurationsPanel) {
        return runConfigurationsPanel.profilesModel;
    }

    static List ra$profilesNames(RunConfigurationsPanel runConfigurationsPanel) {
        return runConfigurationsPanel.profilesNames;
    }

    static void mav$updateButtons(RunConfigurationsPanel runConfigurationsPanel) {
        runConfigurationsPanel.updateButtons();
    }

    static JList ra$profilesList(RunConfigurationsPanel runConfigurationsPanel) {
        return runConfigurationsPanel.profilesList;
    }

    static void mav$editRunConfiguration(RunConfigurationsPanel runConfigurationsPanel, int n) {
        runConfigurationsPanel.editRunConfiguration(n);
    }

    final class 1
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent e) {
            RunConfigurationsPanel.mav$updateButtons(RunConfigurationsPanel.this);
        }
    }

    final class 2
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            if ((e.getModifiers() & 0x10) != 0 && e.getClickCount() == 2) {
                Rectangle rect;
                Point point = e.getPoint();
                int index = RunConfigurationsPanel.ra$profilesList(RunConfigurationsPanel.this).locationToIndex(point);
                if (index != -1 && (rect = RunConfigurationsPanel.ra$profilesList(RunConfigurationsPanel.this).getCellBounds(index, index)).contains(point)) {
                    RunConfigurationsPanel.mav$editRunConfiguration(RunConfigurationsPanel.this, index);
                }
            }
        }
    }

    class NewDialog
    extends JPanel
    implements DocumentListener {
        private JTextField nameTextField;
        private JComboBox copyFromComboBox;
        private JEWTDialog dlg;
        private Set usedNames;

        NewDialog(String name, Set usedNames) {
            super(new GridBagLayout());
            this.usedNames = usedNames;
            JLabel nameLabel = new JLabel();
            String suggestedName = name != null ? RunMgrArb.format(43, name) : "";
            this.nameTextField = new JTextField(suggestedName);
            JLabel copyFromLabel = new JLabel();
            int length = RunConfigurationsPanel.ra$profilesNames(RunConfigurationsPanel.this).size() + 1;
            Object[] copyFromArray = new Object[length];
            copyFromArray[0] = RunMgrArb.getString(40);
            int i = 1;
            while (i < length) {
                copyFromArray[i] = RunConfigurationsPanel.ra$profilesNames(RunConfigurationsPanel.this).get(i - 1);
                ++i;
            }
            this.copyFromComboBox = new JComboBox(new NonNullableComboBoxModel(copyFromArray));
            this.copyFromComboBox.setSelectedItem(name);
            ResourceUtils.resLabel((JLabel)nameLabel, (Component)this.nameTextField, (String)RunMgrArb.getString(34));
            ResourceUtils.resLabel((JLabel)copyFromLabel, (Component)this.copyFromComboBox, (String)RunMgrArb.getString(72));
            this.nameTextField.getDocument().addDocumentListener(this);
            int y = 0;
            this.add((Component)nameLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.nameTextField, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 0, 5), 0, 0));
            this.add((Component)copyFromLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
            this.add((Component)this.copyFromComboBox, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 0, 5), 0, 0));
            this.add((Component)new JLabel(), new GridBagConstraints(0, y, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }

        String showDialog() {
            String title = RunMgrArb.getString(75);
            JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)this, (Component)this.nameTextField, (String)title);
            this.setJEWTDialog(dlg);
            dlg.setOKButtonEnabled(this.canOk());
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_run_copyrunconfig_html");
            if (WizardLauncher.runDialog((JDialog)dlg)) {
                return this.getNewName();
            }
            return null;
        }

        private void setJEWTDialog(JEWTDialog dlg) {
            this.dlg = dlg;
            dlg.addVetoableChangeListener((VetoableChangeListener)new 1());
        }

        public void changedUpdate(DocumentEvent e) {
            this.processChange();
        }

        public void insertUpdate(DocumentEvent e) {
            this.processChange();
        }

        public void removeUpdate(DocumentEvent e) {
            this.processChange();
        }

        private void processChange() {
            this.dlg.setOKButtonEnabled(this.canOk());
        }

        private boolean canOk() {
            return this.nameTextField.getText().length() > 0;
        }

        private boolean veto() {
            String name = this.nameTextField.getText();
            if (this.usedNames.contains(name)) {
                MessageDialog.error((Component)this, (Object)RunMgrArb.format(50, name), (String)RunMgrArb.format(52, this.dlg.getTitle()), null);
                return true;
            }
            return false;
        }

        private String getNewName() {
            return this.nameTextField.getText();
        }

        private RunConfiguration getCopyFrom() {
            int index = this.copyFromComboBox.getSelectedIndex();
            if (index <= 0) {
                return null;
            }
            return (RunConfiguration)((Object)RunConfigurationsPanel.ra$profilesModel(RunConfigurationsPanel.this).get(index - 1));
        }

        static RunConfiguration mav$getCopyFrom(NewDialog newDialog) {
            return newDialog.getCopyFrom();
        }

        static boolean mav$veto(NewDialog newDialog) {
            return newDialog.veto();
        }

        final class 1
        implements VetoableChangeListener {
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt) && NewDialog.mav$veto(NewDialog.this)) {
                    throw new PropertyVetoException("no", evt);
                }
            }
        }
    }

    class RestoreDialog
    extends JPanel
    implements ListSelectionListener {
        private JList list;
        private JEWTDialog dlg;

        RestoreDialog(Set set) {
            super(new GridBagLayout());
            JLabel listLabel = new JLabel();
            DefaultListModel model = new DefaultListModel();
            Iterator it = set.iterator();
            while (it.hasNext()) {
                model.addElement(it.next());
            }
            this.list = new JList(model);
            this.list.setSelectionMode(2);
            JScrollPane listScrollPane = new JScrollPane(this.list);
            ResourceUtils.resLabel((JLabel)listLabel, (Component)this.list, (String)RunMgrArb.getString(3));
            this.list.addListSelectionListener(this);
            int y = 0;
            this.add((Component)listLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)listScrollPane, new GridBagConstraints(0, y, 0, 1, 1.0, 1.0, 17, 1, new Insets(2, 5, 0, 5), 0, 0));
        }

        String[] showDialog() {
            String title = RunMgrArb.getString(103);
            JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)this, (Component)this.list, (String)title);
            this.setJEWTDialog(dlg);
            dlg.setOKButtonEnabled(this.canOk());
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_run_restorerunconfig_html");
            if (WizardLauncher.runDialog((JDialog)dlg)) {
                return this.getItems();
            }
            return null;
        }

        private void setJEWTDialog(JEWTDialog dlg) {
            this.dlg = dlg;
        }

        public void valueChanged(ListSelectionEvent e) {
            this.dlg.setOKButtonEnabled(this.canOk());
        }

        private boolean canOk() {
            return this.list.getSelectedIndex() != -1;
        }

        private String[] getItems() {
            Object[] values = this.list.getSelectedValues();
            int length = values.length;
            String[] names = new String[length];
            System.arraycopy(values, 0, names, 0, length);
            return names;
        }
    }
}

