/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.cmd.RenameMessage;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.migration.NodeMigrator;
import oracle.ide.migration.NodeMigratorHelper;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.ProjectMigrator;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.model.panels.ProjectPropertiesDialog;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.Navigable;
import oracle.ide.runner.Runner;
import oracle.ide.runner.StarterFactory;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.Assert;
import oracle.ideri.util.Product;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.cmd.NewEmptyProjectCommand;
import oracle.jdeveloper.model.JavaNode;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunConfigurations;
import oracle.jdevimpl.jar.JarNode;
import oracle.jdevimpl.runner.AddinStarterFactory;
import oracle.jdevimpl.runner.ApplicationStarterFactory;
import oracle.jdevimpl.runner.JarStarterFactory;
import oracle.jdevimpl.runner.RunConfigurationsMigrator;
import oracle.jdevimpl.runner.RunConfigurationsPanel;
import oracle.jdevimpl.runner.RunMgrArb;

public final class RunManager
implements Addin,
Controller,
IdeListener,
Observer {
    private Project activeProject;
    private static JMenu menuRunConfigurationList;
    private static final String ACTIVATE_RUN_CONFIGURATION_CMD_PREFIX = "ActivateRunConfiguration";
    private static IdeAction actionEmpty;
    private static int[] activateRunConfigurationCmdIds;
    private static final int MANAGE_RUN_CONFIGURATIONS_CMD_ID;
    private static IdeAction actionManageRunConfigurations;

    public void initialize() {
        this.makeActionsAndMenus();
        this.registerProjectInitializerAndMigrator();
        RunManager.registerDefaultStarterFactories();
        RunManager.registerProjectSettingsPanels();
        Project.addProjectChangeListener((String)"", (ProjectChangeListener)new 1());
        Ide.addIdeListener((IdeListener)this);
    }

    public void shutdown() {
    }

    public boolean canShutdown() {
        return true;
    }

    public void addinsLoaded(IdeEvent e) {
    }

    public void mainWindowOpened(IdeEvent e) {
        Ide.removeIdeListener((IdeListener)this);
        this.activeProjectChanged();
        Ide.getSystem().attach((Observer)this);
        Project.addProjectChangeListener((String)"", (ProjectChangeListener)new 2());
    }

    public void mainWindowClosing(IdeEvent e) {
        Ide.getSystem().detach((Observer)this);
    }

    public void update(Object observed, UpdateMessage change) {
        int messageID = change.getMessageID();
        if (observed == Ide.getSystem()) {
            if (messageID == IdeConstants.ACTIVE_PROJECT_CHANGED) {
                this.activeProjectChanged();
            }
        } else if (observed instanceof Project) {
            if (messageID == UpdateMessage.CHILD_REMOVED) {
                RunManager.projectFilesRemoved((Project)observed, change.getRemoveObjects());
            } else if (messageID == UpdateMessage.CHILD_RENAMED) {
                RunManager.projectFileRenamed((Project)observed, change);
            }
        }
    }

    public boolean handleEvent(IdeAction action, Context context) {
        Assert.check((boolean)action.isEnabled());
        int cmdId = action.getCommandId();
        if (RunManager.arrayContains(activateRunConfigurationCmdIds, cmdId)) {
            RunConfiguration runConfiguration = (RunConfiguration)((Object)action.getValue("UserData"));
            RunConfigurations.setActiveRunConfiguration(this.activeProject, runConfiguration);
            return true;
        }
        if (cmdId == MANAGE_RUN_CONFIGURATIONS_CMD_ID) {
            this.manageRunConfigurations(context);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (RunManager.arrayContains(activateRunConfigurationCmdIds, cmdId)) {
            RunConfiguration runConfiguration = (RunConfiguration)((Object)action.getValue("UserData"));
            boolean isActive = RunConfigurations.isActiveRunConfiguration(this.activeProject, runConfiguration);
            action.setState(isActive);
            return true;
        }
        if (cmdId == MANAGE_RUN_CONFIGURATIONS_CMD_ID) {
            action.setEnabled(this.canManageRunConfigurations(context));
            return true;
        }
        return false;
    }

    private void makeActionsAndMenus() {
        JMenu runMenu = Runner.getRunner().getRunMenu();
        String category = runMenu.getText();
        Menubar menubar = Ide.getMenubar();
        int EMPTY_RUN_CONFIGURATION_CMD_ID = Ide.findOrCreateCmdID((String)"ActivateRunConfigurationEmpty");
        actionEmpty = IdeAction.get((int)EMPTY_RUN_CONFIGURATION_CMD_ID, null, (String)RunMgrArb.getString(33), (String)category, null, null, null, (boolean)false);
        menuRunConfigurationList = menubar.createSubMenu(RunMgrArb.getString(67), RunMgrArb.getInteger(27), 1.0f);
        if (!Product.isRaptor()) {
            menubar.add((Component)menuRunConfigurationList, runMenu, 1.0f);
        }
        actionManageRunConfigurations = IdeAction.get((int)MANAGE_RUN_CONFIGURATIONS_CMD_ID, null, (String)RunMgrArb.getString(104), (String)category, (Integer)RunMgrArb.getInteger(88), (ArrayResourceBundle)RunMgrArb.getInstance(), (int)56, null, (boolean)false);
        actionManageRunConfigurations.addController((Controller)this);
    }

    private void registerProjectInitializerAndMigrator() {
        NewEmptyProjectCommand.registerProjectInitializer(new 3());
        NodeMigrator migrator = NodeMigrator.getNodeMigrator((String)ProjectMigrator.MIGRATOR_NAME);
        if (migrator != null) {
            migrator.addHelper((NodeMigratorHelper)new RunConfigurationsMigrator());
        }
    }

    private static void registerDefaultStarterFactories() {
        Runner runner = Runner.getRunner();
        runner.registerStarterFactory(TextNode.class, (StarterFactory)new AddinStarterFactory(true));
        JarStarterFactory jarStarterFactory = new JarStarterFactory();
        runner.registerStarterFactory(JarNode.class, (StarterFactory)jarStarterFactory);
        ApplicationStarterFactory applicationStarterFactory = new ApplicationStarterFactory();
        runner.registerStarterFactory(JavaNode.class, (StarterFactory)applicationStarterFactory);
    }

    private static void registerProjectSettingsPanels() {
        Navigable navigable = new Navigable(RunMgrArb.getString(53), RunConfigurationsPanel.class);
        ProjectPropertiesDialog.addPanel((Navigable)navigable);
        Runner.getRunner().setProjectSettingsRunnerNavigable(navigable);
    }

    private void activeProjectChanged() {
        if (this.activeProject != null) {
            this.activeProject.detach((Observer)this);
        }
        this.activeProject = Ide.getActiveProject();
        if (this.activeProject != null) {
            this.activeProject.attach((Observer)this);
        }
        this.updateRunConfigurationList();
    }

    private static void projectFilesRemoved(Project jproject, List removed) {
        try {
            RunConfiguration rc = RunConfiguration.getInstance((PropertyStorage)jproject);
            URL targetURL = rc.getTargetURL();
            if (targetURL != null) {
                for (Object o : removed) {
                    if (!(o instanceof Locatable) || !((Locatable)o).getURL().equals(targetURL)) continue;
                    rc.setTargetURL(null);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private static void projectFileRenamed(Project jproject, UpdateMessage change) {
        try {
            Node newNode;
            URL oldURL;
            RunConfiguration rc = RunConfiguration.getInstance((PropertyStorage)jproject);
            URL targetURL = rc.getTargetURL();
            if (targetURL != null && (oldURL = RenameMessage.getOldURL((UpdateMessage)change)) != null && URLFileSystem.equals((URL)oldURL, (URL)targetURL) && (newNode = RenameMessage.getRenamedNode((UpdateMessage)change)) != null) {
                rc.setTargetURL(newNode.getURL());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void updateRunConfigurationList() {
        RunConfigurations runConfigurations;
        RunConfiguration[] runConfigs;
        int runConfigsLength;
        IdeAction[] actions = null;
        if (this.activeProject != null && this.activeProject.isOpen() && (runConfigsLength = (runConfigs = (runConfigurations = RunConfigurations.getInstance((PropertyStorage)this.activeProject)).getVisibleRunConfigurations()).length) > 0) {
            activateRunConfigurationCmdIds = new int[runConfigsLength];
            actions = new IdeAction[runConfigsLength];
            String category = Runner.getRunner().getRunMenu().getText();
            int i = 0;
            while (i < runConfigsLength) {
                RunConfiguration runConfiguration = runConfigs[i];
                String name = runConfiguration.getName();
                int cmdId = Ide.findOrCreateCmdID((String)(ACTIVATE_RUN_CONFIGURATION_CMD_PREFIX + i));
                IdeAction action = IdeAction.get((int)cmdId, null, (String)name, (String)category, null, null, (Object)((Object)runConfiguration), (boolean)true);
                action.putValue("Name", (Object)name);
                action.putValue("UserData", (Object)runConfiguration);
                action.putValue("Radio", (Object)Boolean.TRUE);
                action.addController((Controller)this);
                RunManager.activateRunConfigurationCmdIds[i] = cmdId;
                actions[i] = action;
                ++i;
            }
        }
        if (actions == null) {
            activateRunConfigurationCmdIds = new int[0];
            actions = new IdeAction[]{actionEmpty};
        }
        Menubar menubar = Ide.getMenubar();
        menuRunConfigurationList.removeAll();
        int actionsLength = actions.length;
        int i = 0;
        while (i < actionsLength) {
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actions[i]), menuRunConfigurationList, 1.0f);
            ++i;
        }
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionManageRunConfigurations), menuRunConfigurationList, JDeveloperMenuConstants.SECTION_BOTTOM);
    }

    public static IdeAction getManageRunConfigurationsAction() {
        Context context;
        if (Ide.getMainWindow().getLastActiveView() != null && (context = Ide.getMainWindow().getLastActiveView().getContext()) != null) {
            actionManageRunConfigurations.updateAction(context);
        }
        return actionManageRunConfigurations;
    }

    public static boolean arrayContains(int[] array, int n) {
        int i = array.length - 1;
        while (i >= 0) {
            if (array[i] == n) {
                return true;
            }
            --i;
        }
        return false;
    }

    private boolean canManageRunConfigurations(Context context) {
        Project project = context.getProject();
        return project != null;
    }

    private void manageRunConfigurations(Context context) {
        Project project = context.getProject();
        if (project != null) {
            String[] path = new String[]{RunMgrArb.getString(53)};
            ProjectPropertiesDialog.showDialog((Context)context, (Frame)Ide.getMainWindow(), (Project)project, (String[])path);
        }
    }

    static {
        activateRunConfigurationCmdIds = new int[0];
        MANAGE_RUN_CONFIGURATIONS_CMD_ID = Ide.findOrCreateCmdID((String)"ManageRunConfigurations");
    }

    static Project ra$activeProject(RunManager runManager) {
        return runManager.activeProject;
    }

    static void mav$updateRunConfigurationList(RunManager runManager) {
        runManager.updateRunConfigurationList();
    }

    final class 1
    extends ProjectChangeListener {
        public void projectOpened(Project project) {
            RunConfigurations.projectCheck(project);
        }
    }

    final class 2
    extends ProjectChangeListener {
        public void projectPropertiesChanged(ProjectChangeEvent e) {
            if (e.getProject() == RunManager.ra$activeProject(RunManager.this)) {
                1 runnable = new 1();
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                } else {
                    SwingUtilities.invokeLater(runnable);
                }
            }
        }

        final class 1
        implements Runnable {
            public void run() {
                RunManager.mav$updateRunConfigurationList(RunManager.this);
            }
        }
    }

    final class 3
    implements NewEmptyProjectCommand.ProjectInitializer {
        public void initializeProject(Project project, Workspace workspace) {
            RunConfigurations.projectCreated(project);
        }
    }
}

