/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.cmd.RenameMessage;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.Assert;
import oracle.ide.util.FastStringBuffer;
import oracle.ideri.util.Product;
import oracle.javatools.editor.gutter.GutterColumnListener;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.refactoring.criteria.MoveClassesCriteria;
import oracle.jdeveloper.refactoring.criteria.RenameFieldCriteria;
import oracle.jdeveloper.refactoring.criteria.RenameMethodCriteria;
import oracle.jdeveloper.refactoring.model.MethodDescription;
import oracle.jdeveloper.refactoring.model.ProgressIndicator;
import oracle.jdeveloper.refactoring.model.SearchCriteria;
import oracle.jdeveloper.refactoring.model.SearchOperation;
import oracle.jdeveloper.refactoring.model.URLRefactoringHandler;
import oracle.jdeveloper.refactoring.model.UsageModel;
import oracle.jdeveloper.runner.Source;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxBreakpoint;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointClass;
import oracle.jdevimpl.debugger.support.DebugBreakpointCondition;
import oracle.jdevimpl.debugger.support.DebugBreakpointException;
import oracle.jdevimpl.debugger.support.DebugBreakpointMethod;
import oracle.jdevimpl.debugger.support.DebugBreakpointMethodBytecode;
import oracle.jdevimpl.debugger.support.DebugBreakpointPackageFileLine;
import oracle.jdevimpl.debugger.support.DebugBreakpointWatchpoint;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.BaseElement;
import oracle.jdevimpl.runner.debug.BreakpointSettings;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.Evaluator;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.RunWhilePaused;
import oracle.jdevimpl.runner.debug.SavedBreakpoints;
import oracle.jdevimpl.runner.debug.SourceIcon;
import oracle.jdevimpl.runner.xslt.XSLTRunnerAddin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Breakpoint
extends BaseElement
implements DebugBreakpointCondition,
GutterColumnListener {
    private BreakpointSettings breakpointSettings;
    private SourceIcon sourceIcon;
    private boolean shallow;
    private Map debugBreakpointForDebuggingProcess;
    private Map debuggingProcessForDebugBreakpoint;
    static final int STATUS_DISABLED = 0;
    static final int STATUS_ENABLED = 1;
    static final int STATUS_UNVERIFIED = 2;
    static final int STATUS_VERIFIED = 3;
    private static final Object GlobalBreakpointsKey = "217";
    private static SavedBreakpoints savedBreakpoints;
    private static Map allBreakpoints;
    private static final String REFACTORING_OPERATION = "DebuggerRefactoringOperation";

    private Breakpoint(BreakpointSettings breakpointSettings) {
        this.breakpointSettings = breakpointSettings;
        this.init();
    }

    Breakpoint(URL ownerURL, int type, String pkg, String file, int line) {
        if (type != 0) {
            throw new Error("bad type");
        }
        this.breakpointSettings = new BreakpointSettings();
        this.breakpointSettings.setOwnerURL(ownerURL);
        this.breakpointSettings.setType(type);
        this.breakpointSettings.setPkg(pkg);
        this.breakpointSettings.setFile(file);
        this.breakpointSettings.setLine(line);
        this.breakpointSettings.setActions();
        this.init();
    }

    Breakpoint(URL ownerURL, int type, String methodOrClassName) {
        if (type != 1 && type != 4) {
            throw new Error("bad type");
        }
        this.breakpointSettings = new BreakpointSettings();
        this.breakpointSettings.setOwnerURL(ownerURL);
        this.breakpointSettings.setType(type);
        if (type == 1) {
            this.breakpointSettings.setMethod(methodOrClassName);
        } else {
            this.breakpointSettings.setClassName(methodOrClassName);
        }
        this.breakpointSettings.setActions();
        this.init();
    }

    Breakpoint(URL ownerURL, int type, String methodName, int offset) {
        if (type != 7) {
            throw new Error("bad type");
        }
        this.breakpointSettings = new BreakpointSettings();
        this.breakpointSettings.setOwnerURL(ownerURL);
        this.breakpointSettings.setType(type);
        this.breakpointSettings.setMethod(methodName);
        this.breakpointSettings.setOffset(offset);
        this.breakpointSettings.setActions();
        this.init();
    }

    Breakpoint(URL ownerURL, int type, String exception, boolean caught, boolean uncaught) {
        if (type != 2) {
            throw new Error("bad type");
        }
        this.breakpointSettings = new BreakpointSettings();
        this.breakpointSettings.setOwnerURL(ownerURL);
        this.breakpointSettings.setType(type);
        this.breakpointSettings.setException(exception);
        this.breakpointSettings.setCaught(caught);
        this.breakpointSettings.setUncaught(uncaught);
        this.breakpointSettings.setActions();
        this.init();
    }

    Breakpoint(URL ownerURL, int type) {
        if (type != 3) {
            throw new Error("bad type");
        }
        this.breakpointSettings = new BreakpointSettings();
        this.breakpointSettings.setOwnerURL(ownerURL);
        this.breakpointSettings.setType(type);
        this.breakpointSettings.setActions();
        this.init();
    }

    Breakpoint(URL ownerURL, int type, URL url, int line) {
        if (type != 5) {
            throw new Error("bad type");
        }
        this.breakpointSettings = new BreakpointSettings();
        this.breakpointSettings.setOwnerURL(ownerURL);
        this.breakpointSettings.setType(type);
        this.breakpointSettings.setURL(url);
        this.breakpointSettings.setLine(line);
        this.breakpointSettings.setActions();
        this.init();
    }

    Breakpoint(URL ownerURL, int type, String className, String fieldName, boolean access, boolean modify) {
        if (type != 6) {
            throw new Error("bad type");
        }
        this.breakpointSettings = new BreakpointSettings();
        this.breakpointSettings.setOwnerURL(ownerURL);
        this.breakpointSettings.setType(type);
        this.breakpointSettings.setClassName(className);
        this.breakpointSettings.setFieldName(fieldName);
        this.breakpointSettings.setAccess(access);
        this.breakpointSettings.setModify(modify);
        this.breakpointSettings.setActions();
        this.init();
    }

    private void init() {
        this.debugBreakpointForDebuggingProcess = new HashMap();
        this.debuggingProcessForDebugBreakpoint = new HashMap();
    }

    DebugBreakpoint getDebugBreakpoint(DebuggingProcess debuggingProcess) {
        return (DebugBreakpoint)this.debugBreakpointForDebuggingProcess.get(debuggingProcess);
    }

    URL getOwnerURL() {
        return this.breakpointSettings.getOwnerURL();
    }

    void setOwnerURL(URL ownerURL) {
        boolean iconWasShowing = this.hideBreakpointIcon();
        this.breakpointSettings.setOwnerURL(ownerURL);
        if (iconWasShowing) {
            this.showBreakpointIcon();
        }
    }

    boolean isPersistent() {
        return this.breakpointSettings.isPersistent();
    }

    int getType() {
        return this.breakpointSettings.getType();
    }

    String getPackage() {
        return this.breakpointSettings.getPkg();
    }

    String getFile() {
        return this.breakpointSettings.getFile();
    }

    int getLine() {
        return this.breakpointSettings.getLine();
    }

    void setPackageFileLine(String pkgArg, String fileArg, int lineArg) {
        this.setPackageFileLine(pkgArg, fileArg, lineArg, true);
    }

    private void setPackageFileLine(String pkgArg, String fileArg, int lineArg, boolean adjustIcon) {
        if (this.breakpointSettings.getType() != 0) {
            throw new Error("bad type");
        }
        boolean iconWasShowing = adjustIcon ? this.hideBreakpointIcon() : false;
        this.breakpointSettings.setPkg(pkgArg);
        this.breakpointSettings.setFile(fileArg);
        this.breakpointSettings.setLine(lineArg);
        if (adjustIcon && iconWasShowing) {
            this.showBreakpointIcon();
        }
        if (!this.shallow) {
            1 runWhilePaused = new 1(this, pkgArg, fileArg, lineArg);
            2 runOnceLater = new 2();
            this.pauseAndInvoke(runWhilePaused, runOnceLater);
        }
    }

    public void markMoved(GutterMark gutterMark, int oldLine, int newLine) {
        int bpType = this.breakpointSettings.getType();
        if (bpType == 0) {
            String pkg = this.breakpointSettings.getPkg();
            String file = this.breakpointSettings.getFile();
            this.setPackageFileLine(pkg, file, newLine, false);
            JDebugger.getInstance().updateBreakpointsWindow();
        } else if (bpType == 5) {
            URL url = this.breakpointSettings.getURL();
            this.setURLLine(url, newLine, false);
            JDebugger.getInstance().updateBreakpointsWindow();
        } else if (bpType == 6 && this.hideBreakpointIcon()) {
            this.showBreakpointIcon();
        }
    }

    public void markRemoved(GutterMark gutterMark, int deletedLine) {
        this.removeBreakpoint();
        JDebugger.getInstance().updateBreakpointsWindow();
    }

    public void markClicked(GutterMark gutterMark, int clickedLine, MouseEvent event) {
        this.removeBreakpoint();
        JDebugger.getInstance().updateBreakpointsWindow();
    }

    public String getMarkToolTip(GutterMark gutterMark, MouseEvent event) {
        return this.getShortLabel();
    }

    String getMethod() {
        return this.breakpointSettings.getMethod();
    }

    void setMethod(String methodArg) {
        if (this.breakpointSettings.getType() != 1) {
            throw new Error("bad type");
        }
        this.breakpointSettings.setMethod(methodArg);
        if (!this.shallow) {
            3 runWhilePaused = new 3(this, methodArg);
            this.pauseAndInvoke(runWhilePaused, null);
        }
    }

    int getOffset() {
        return this.breakpointSettings.getOffset();
    }

    void setMethodOffset(String methodArg, int offsetArg) {
        this.setMethodOffset(methodArg, offsetArg, true);
    }

    void setMethodOffset(String methodArg, int offsetArg, boolean adjustIcon) {
        if (this.breakpointSettings.getType() != 7) {
            throw new Error("bad type");
        }
        boolean iconWasShowing = adjustIcon ? this.hideBreakpointIcon() : false;
        this.breakpointSettings.setMethod(methodArg);
        this.breakpointSettings.setOffset(offsetArg);
        if (adjustIcon && iconWasShowing) {
            this.showBreakpointIcon();
        }
        if (!this.shallow) {
            4 runWhilePaused = new 4(this, methodArg, offsetArg);
            5 runOnceLater = new 5();
            this.pauseAndInvoke(runWhilePaused, runOnceLater);
        }
    }

    String getException() {
        return this.breakpointSettings.getException();
    }

    boolean isCaught() {
        return this.breakpointSettings.isCaught();
    }

    boolean isUncaught() {
        return this.breakpointSettings.isUncaught();
    }

    void setException(String exceptionArg, boolean caughtArg, boolean uncaughtArg) {
        if (this.breakpointSettings.getType() != 2) {
            throw new Error("bad type");
        }
        this.breakpointSettings.setException(exceptionArg);
        this.breakpointSettings.setCaught(caughtArg);
        this.breakpointSettings.setUncaught(uncaughtArg);
        if (!this.shallow) {
            6 runWhilePaused = new 6(this, exceptionArg, caughtArg, uncaughtArg);
            this.pauseAndInvoke(runWhilePaused, null);
        }
    }

    String getClassName() {
        return this.breakpointSettings.getClassName();
    }

    void setClassName(String classNameArg) {
        if (this.breakpointSettings.getType() != 4) {
            throw new Error("bad type");
        }
        this.breakpointSettings.setClassName(classNameArg);
        if (!this.shallow) {
            7 runWhilePaused = new 7(this, classNameArg);
            this.pauseAndInvoke(runWhilePaused, null);
        }
    }

    URL getURL() {
        return this.breakpointSettings.getURL();
    }

    void setURLLine(URL urlArg, int lineArg) {
        this.setURLLine(urlArg, lineArg, true);
    }

    private void setURLLine(URL urlArg, int lineArg, boolean adjustIcon) {
        if (this.breakpointSettings.getType() != 5) {
            throw new Error("bad type");
        }
        boolean iconWasShowing = adjustIcon ? this.hideBreakpointIcon() : false;
        this.breakpointSettings.setURL(urlArg);
        this.breakpointSettings.setLine(lineArg);
        if (adjustIcon && iconWasShowing) {
            this.showBreakpointIcon();
        }
        if (!this.shallow) {
            8 runWhilePaused = new 8(this, urlArg, lineArg);
            9 runOnceLater = new 9();
            this.pauseAndInvoke(runWhilePaused, runOnceLater);
        }
    }

    String getFieldName() {
        return this.breakpointSettings.getFieldName();
    }

    boolean isAccess() {
        return this.breakpointSettings.isAccess();
    }

    boolean isModify() {
        return this.breakpointSettings.isModify();
    }

    void setWatchpoint(String classNameArg, String fieldNameArg, boolean accessArg, boolean modifyArg) {
        if (this.breakpointSettings.getType() != 6) {
            throw new Error("bad type");
        }
        boolean iconWasShowing = this.hideBreakpointIcon();
        this.breakpointSettings.setClassName(classNameArg);
        this.breakpointSettings.setFieldName(fieldNameArg);
        this.breakpointSettings.setAccess(accessArg);
        this.breakpointSettings.setModify(modifyArg);
        if (iconWasShowing) {
            this.showBreakpointIcon();
        }
        if (!this.shallow) {
            10 runWhilePaused = new 10(this, classNameArg, fieldNameArg, accessArg, modifyArg);
            11 runOnceLater = new 11();
            this.pauseAndInvoke(runWhilePaused, runOnceLater);
        }
    }

    boolean isEnabled() {
        return this.breakpointSettings.isEnabled();
    }

    boolean isEnabledNow() {
        DebugBreakpoint dbp;
        DebuggingProcess debuggingProcess = JDebugger.getInstance().getActiveDebuggingProcess();
        if (debuggingProcess != null && (dbp = this.getDebugBreakpoint(debuggingProcess)) != null) {
            return dbp.getEnabled();
        }
        return this.breakpointSettings.isEnabled();
    }

    void setEnabled(boolean enabledArg) {
        this.breakpointSettings.setEnabled(enabledArg);
        if (!this.shallow) {
            12 runWhilePaused = new 12(this, enabledArg);
            13 runOnceLater = new 13();
            this.pauseAndInvoke(runWhilePaused, runOnceLater);
        }
    }

    String getGroupName() {
        return this.breakpointSettings.getGroupName();
    }

    void setGroupName(String groupNameArg) {
        if (groupNameArg == null) {
            groupNameArg = "";
        }
        this.breakpointSettings.setGroupName(groupNameArg);
        String groupName = groupNameArg;
        if (!this.shallow) {
            14 runWhilePaused = new 14(this, groupName);
            this.pauseAndInvoke(runWhilePaused, null);
        }
    }

    boolean canEditGroupName() {
        return this.breakpointSettings.canEditGroupName();
    }

    void setCanEditGroupName(boolean canEditGroupName) {
        this.breakpointSettings.setCanEditGroupName(canEditGroupName);
    }

    String getCondition() {
        return this.breakpointSettings.getCondition();
    }

    void setCondition(String conditionArg) {
        Breakpoint bpCondition;
        if (conditionArg == null) {
            conditionArg = "";
        }
        this.breakpointSettings.setCondition(conditionArg);
        Breakpoint breakpoint = bpCondition = conditionArg.length() > 0 ? this : null;
        if (!this.shallow) {
            15 runWhilePaused = new 15(this, bpCondition);
            this.pauseAndInvoke(runWhilePaused, null);
        }
    }

    boolean canEditCondition() {
        return this.breakpointSettings.canEditCondition();
    }

    void setCanEditCondition(boolean canEditCondition) {
        this.breakpointSettings.setCanEditCondition(canEditCondition);
    }

    @Override
    public boolean checkBreakpointCondition(DebugBreakpoint dbp, DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo[] stack) {
        block8: {
            try {
                if (stack.length > 0) {
                    String condition = this.breakpointSettings.getCondition();
                    Evaluator evaluator = new Evaluator(true);
                    evaluator.setDebugContext(vm, thread, stack[0]);
                    int result = evaluator.evaluateCondition(condition);
                    switch (result) {
                        default: {
                            String msg = DbgArb.format(753, condition);
                            DebuggingProcess debuggingProcess = (DebuggingProcess)this.debuggingProcessForDebugBreakpoint.get(dbp);
                            debuggingProcess.addMessage(msg);
                            boolean bl = true;
                            return bl;
                        }
                        case -1: {
                            String msg = DbgArb.format(596, condition);
                            DebuggingProcess debuggingProcess = (DebuggingProcess)this.debuggingProcessForDebugBreakpoint.get(dbp);
                            debuggingProcess.addMessage(msg);
                            boolean bl = true;
                            return bl;
                        }
                        case 0: {
                            boolean bl = false;
                            return bl;
                        }
                        case 1: 
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Throwable e) {
                if (!(e instanceof ThreadDeath)) break block8;
                throw (ThreadDeath)e;
            }
        }
        return false;
    }

    @Override
    public String getConditionText() {
        return this.breakpointSettings.getCondition();
    }

    String getThreadName() {
        return this.breakpointSettings.getThreadName();
    }

    void setThreadName(String threadNameArg) {
        if (threadNameArg == null) {
            threadNameArg = "";
        }
        this.breakpointSettings.setThreadName(threadNameArg);
        String threadName = threadNameArg;
        if (!this.shallow) {
            16 runWhilePaused = new 16(this, threadName);
            this.pauseAndInvoke(runWhilePaused, null);
        }
    }

    String getThreadNameNot() {
        return this.breakpointSettings.getThreadNameNot();
    }

    void setThreadNameNot(String threadNameNotArg) {
        if (threadNameNotArg == null) {
            threadNameNotArg = "";
        }
        this.breakpointSettings.setThreadNameNot(threadNameNotArg);
        String threadNameNot = threadNameNotArg;
        if (!this.shallow) {
            17 runWhilePaused = new 17(this, threadNameNot);
            this.pauseAndInvoke(runWhilePaused, null);
        }
    }

    boolean canEditBreakForThreads() {
        return this.breakpointSettings.canEditBreakForThreads();
    }

    void setCanEditBreakForThreads(boolean canEditBreakForThreads) {
        this.breakpointSettings.setCanEditBreakForThreads(canEditBreakForThreads);
    }

    int getPassCount() {
        return this.breakpointSettings.getPassCount();
    }

    void setPassCount(int passCountArg) {
        this.breakpointSettings.setPassCount(passCountArg);
        if (!this.shallow) {
            18 runWhilePaused = new 18(this, passCountArg);
            this.pauseAndInvoke(runWhilePaused, null);
        }
    }

    boolean canEditPassCount() {
        return this.breakpointSettings.canEditPassCount();
    }

    void setCanEditPassCount(boolean canEditPassCount) {
        this.breakpointSettings.setCanEditPassCount(canEditPassCount);
    }

    String getPassCountInfo() {
        int activePassCount;
        DebugBreakpoint dbp;
        int passCount = this.breakpointSettings.getPassCount();
        String s = Integer.toString(passCount);
        DebuggingProcess debuggingProcess = JDebugger.getInstance().getActiveDebuggingProcess();
        if (debuggingProcess != null && (dbp = this.getDebugBreakpoint(debuggingProcess)) != null && (activePassCount = dbp.getPassCount()) != passCount) {
            s = s + " " + DbgArb.format(219, Integer.toString(activePassCount));
        }
        return s;
    }

    private long[] getInstanceFiltersArray(DebuggingProcess debuggingProcess) {
        DebugBreakpoint dbp = this.getDebugBreakpoint(debuggingProcess);
        if (dbp != null) {
            return dbp.getInstanceFilters();
        }
        return null;
    }

    String getInstanceFilters() {
        int instanceFiltersLength;
        long[] instanceFilters;
        DebuggingProcess debuggingProcess = JDebugger.getInstance().getActiveDebuggingProcess();
        if (debuggingProcess != null && (instanceFilters = this.getInstanceFiltersArray(debuggingProcess)) != null && (instanceFiltersLength = instanceFilters.length) > 0) {
            FastStringBuffer fsb = new FastStringBuffer();
            int i = 0;
            while (i < instanceFiltersLength) {
                fsb.append(Long.toString(instanceFilters[i]));
                if (i < instanceFiltersLength - 1) {
                    fsb.append(", ");
                }
                ++i;
            }
            return DbgArb.format(185, fsb.toString());
        }
        return "";
    }

    boolean isActionHalt() {
        return this.breakpointSettings.isActionHalt();
    }

    void setActionHalt(boolean actionHaltArg) {
        this.breakpointSettings.setActionHalt(actionHaltArg);
        if (!this.shallow) {
            19 runWhilePaused = new 19(this, actionHaltArg);
            this.pauseAndInvoke(runWhilePaused, null);
        }
    }

    boolean isActionBeep() {
        return this.breakpointSettings.isActionBeep();
    }

    void setActionBeep(boolean actionBeepArg) {
        this.breakpointSettings.setActionBeep(actionBeepArg);
        if (!this.shallow) {
            20 runWhilePaused = new 20();
            this.pauseAndInvoke(runWhilePaused, null);
        }
    }

    boolean isActionLog() {
        return this.breakpointSettings.isActionLog();
    }

    void setActionLog(boolean actionLogArg) {
        this.breakpointSettings.setActionLog(actionLogArg);
        if (!this.shallow) {
            21 runWhilePaused = new 21();
            this.pauseAndInvoke(runWhilePaused, null);
        }
    }

    String getActionLogTag() {
        return this.breakpointSettings.getActionLogTag();
    }

    void setActionLogTag(String actionLogTagArg) {
        if (actionLogTagArg == null) {
            actionLogTagArg = "";
        }
        this.breakpointSettings.setActionLogTag(actionLogTagArg);
    }

    String getActionLogExpression() {
        return this.breakpointSettings.getActionLogExpr();
    }

    void setActionLogExpression(String actionLogExprArg) {
        if (actionLogExprArg == null) {
            actionLogExprArg = "";
        }
        this.breakpointSettings.setActionLogExpr(actionLogExprArg);
    }

    boolean isActionLogStack() {
        return this.breakpointSettings.isActionLogStack();
    }

    void setActionLogStack(boolean actionLogStackArg) {
        this.breakpointSettings.setActionLogStack(actionLogStackArg);
    }

    String getAction() {
        String actionDisableOther;
        String actionEnableOther;
        String action = "";
        String delimiter = "";
        if (this.breakpointSettings.isActionHalt()) {
            action = action + delimiter + DbgArb.getString(871);
            delimiter = ", ";
        }
        if (this.breakpointSettings.isActionBeep()) {
            action = action + delimiter + DbgArb.getString(947);
            delimiter = ", ";
        }
        if (this.breakpointSettings.isActionLog()) {
            action = action + delimiter + DbgArb.getString(440);
            delimiter = ", ";
        }
        if ((actionEnableOther = this.breakpointSettings.getActionEnableOther()).length() > 0) {
            action = action + delimiter + DbgArb.getString(526) + actionEnableOther;
            delimiter = ", ";
        }
        if ((actionDisableOther = this.breakpointSettings.getActionDisableOther()).length() > 0) {
            action = action + delimiter + DbgArb.getString(689) + actionDisableOther;
        }
        return action;
    }

    String logBreakpoint(DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo[] stack) {
        return this.prepareLog(vm, thread, stack, null, null);
    }

    String logException(DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo[] stack, String classname, String detail) {
        return this.prepareLog(vm, thread, stack, classname, detail);
    }

    String logDeadlock(DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo[] stack) {
        return this.prepareLog(vm, thread, stack, null, null);
    }

    String logWatchpoint(DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo[] stack, DebugFieldInfo field, DebugDataInfo futureValue) {
        String sFutureValue;
        String msg1 = futureValue == null ? DbgArb.format(317, this.getFieldName()) : DbgArb.format(187, this.getFieldName());
        DebugDataInfo currentValue = field.getDataInfo();
        String sCurrentValue = DataPanel.makeDataValue(field, currentValue);
        if ((sCurrentValue == null || sCurrentValue.length() == 0) && currentValue instanceof DebugDataCompositeInfo) {
            sCurrentValue = Breakpoint.makeStupidValue(vm, (DebugDataCompositeInfo)currentValue);
        }
        if (sCurrentValue != null && sCurrentValue.length() > 0) {
            msg1 = msg1 + " " + DbgArb.format(474, sCurrentValue);
        }
        if (((sFutureValue = DataPanel.makeDataValue(field, futureValue)) == null || sFutureValue.length() == 0) && futureValue instanceof DebugDataCompositeInfo) {
            sFutureValue = Breakpoint.makeStupidValue(vm, (DebugDataCompositeInfo)futureValue);
        }
        if (sFutureValue != null && sFutureValue.length() > 0) {
            msg1 = msg1 + " " + DbgArb.format(784, sFutureValue);
        }
        return this.prepareLog(vm, thread, stack, msg1, null);
    }

    private static String makeStupidValue(DebugVirtualMachine vm, DebugDataCompositeInfo data) {
        long number = JDebugger.getObjectNumber(data);
        return "@" + Long.toHexString(number).toUpperCase();
    }

    private String prepareLog(DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo[] stack, String extra1, String extra2) {
        if (this.breakpointSettings.isActionBeep()) {
            Toolkit.getDefaultToolkit().beep();
        }
        if (this.breakpointSettings.isActionLog()) {
            String stackMsg;
            String exprMsg;
            String expr;
            String msg = this.getMessage(stack, extra1, extra2);
            String tag = this.breakpointSettings.getActionLogTag();
            if (tag != null && tag.length() > 0) {
                msg = msg + tag + "\n";
            }
            if ((expr = this.breakpointSettings.getActionLogExpr()) != null && expr.length() > 0 && (exprMsg = this.evaluateLogExpression(vm, thread, stack, expr)) != null && exprMsg.length() > 0) {
                msg = msg + exprMsg;
            }
            if (this.breakpointSettings.isActionLogStack() && (stackMsg = this.getLogStack(stack)) != null && stackMsg.length() > 0) {
                msg = msg + stackMsg;
            }
            return msg;
        }
        return null;
    }

    private String evaluateLogExpression(DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo[] stack, String actionLogExpr) {
        String evaluation;
        block5: {
            evaluation = "?";
            try {
                if (stack.length > 0) {
                    Evaluator evaluator = new Evaluator(true);
                    evaluator.setDebugContext(vm, thread, stack[0]);
                    Object info = evaluator.evaluate(actionLogExpr);
                    if (info != null) {
                        DebugDataInfo data = Evaluator.getDataInfo(info);
                        evaluation = DataPanel.makeDataValue(info, data);
                        String type = DataPanel.makeType(data, true);
                        if (type != null && type.length() > 0) {
                            evaluation = evaluation + " (" + type + ")";
                        }
                    }
                }
            }
            catch (Throwable e) {
                if (!(e instanceof ThreadDeath)) break block5;
                throw (ThreadDeath)e;
            }
        }
        String msg = DbgArb.format(771, actionLogExpr, evaluation);
        return msg;
    }

    private String getLogStack(DebugStackFrameInfo[] stack) {
        int stackLength = stack.length;
        if (stackLength > 0) {
            FastStringBuffer sb = new FastStringBuffer();
            int i = 0;
            while (i < stackLength) {
                DebugMethodInfo method;
                DebugStackFrameInfo frame = stack[i];
                DebugLocation location = frame.getLocation();
                if (location != null && (method = location.getMethod()) != null) {
                    String methodName = DebugShared.makeCourtesyMethodName(method, true, false, frame);
                    String filename = location.getFilename();
                    int line = location.getLine();
                    sb.append('\t');
                    sb.append("at ");
                    sb.append(methodName);
                    if ((method.getAccess() & 0x100) != 0) {
                        sb.append("(Native Method)");
                    } else if (filename != null) {
                        sb.append('(');
                        sb.append(filename);
                        if (line > 0) {
                            sb.append(':');
                            sb.append(Integer.toString(line));
                        }
                        sb.append(')');
                    }
                    sb.append("\n");
                }
                ++i;
            }
            return sb.toString();
        }
        return null;
    }

    private String getMessage(DebugStackFrameInfo[] stack, String extra1, String extra2) {
        int msgId;
        boolean logFileLine = false;
        boolean logMethodName = false;
        switch (this.breakpointSettings.getType()) {
            default: {
                msgId = 196;
                logFileLine = true;
                break;
            }
            case 1: {
                msgId = 169;
                logMethodName = true;
                logFileLine = true;
                break;
            }
            case 7: {
                msgId = 766;
                logMethodName = true;
                logFileLine = false;
                break;
            }
            case 2: {
                msgId = 803;
                logFileLine = true;
                break;
            }
            case 3: {
                msgId = 404;
                logFileLine = true;
                break;
            }
            case 4: {
                msgId = 489;
                logMethodName = true;
                logFileLine = true;
                break;
            }
            case 5: {
                msgId = 794;
                logMethodName = true;
                logFileLine = true;
                break;
            }
            case 6: {
                msgId = 292;
                logMethodName = true;
                logFileLine = true;
                break;
            }
        }
        String locationInfo = "";
        DebugLocation location = DebuggingProcess.getNonNativeLocation(stack);
        if (location != null) {
            DebugMethodInfo method = location.getMethod();
            if (logFileLine) {
                String filename = location.getFilename();
                int line = location.getLine();
                if (logMethodName && method != null) {
                    DebugClassInfo clazz = method.getClassInfo();
                    int index = clazz != null && clazz.getLanguage() == 8 ? 315 : (XSLTRunnerAddin.isXSLTStylesheet(clazz) ? 819 : 352);
                    String methodName = DebugShared.makeCourtesyMethodName(method, true, true, null);
                    locationInfo = DbgArb.format(index, Integer.toString(line), filename, methodName);
                } else {
                    locationInfo = DbgArb.format(585, Integer.toString(line), filename);
                }
            } else if (logMethodName && method != null) {
                String methodName = DebugShared.makeCourtesyMethodName(method, true, true, null);
                int offset = location.getBytecodeOffset();
                locationInfo = DbgArb.format(929, Integer.toString(offset), methodName);
            }
        }
        Object[] params = new String[]{locationInfo, extra1 != null ? extra1 : "", extra2 != null ? extra2 : ""};
        return DbgArb.format(msgId, params);
    }

    String getActionEnableOther() {
        return this.breakpointSettings.getActionEnableOther();
    }

    void setActionEnableOther(String actionEnableOtherArg) {
        if (actionEnableOtherArg == null) {
            actionEnableOtherArg = "";
        }
        this.breakpointSettings.setActionEnableOther(actionEnableOtherArg);
        String actionEnableOther = actionEnableOtherArg;
        if (!this.shallow) {
            22 runWhilePaused = new 22(this, actionEnableOther);
            this.pauseAndInvoke(runWhilePaused, null);
        }
    }

    String getActionDisableOther() {
        return this.breakpointSettings.getActionDisableOther();
    }

    void setActionDisableOther(String actionDisableOtherArg) {
        if (actionDisableOtherArg == null) {
            actionDisableOtherArg = "";
        }
        this.breakpointSettings.setActionDisableOther(actionDisableOtherArg);
        String actionDisableOther = actionDisableOtherArg;
        if (!this.shallow) {
            23 runWhilePaused = new 23(this, actionDisableOther);
            this.pauseAndInvoke(runWhilePaused, null);
        }
    }

    boolean canEditBreakpointHitActions() {
        return this.breakpointSettings.canEditBreakpointHitActions();
    }

    void setCanEditBreakpointHitActions(boolean canEditBreakpointHitActions) {
        this.breakpointSettings.setCanEditBreakpointHitActions(canEditBreakpointHitActions);
    }

    Map<String, String> getProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        String[] keys = this.breakpointSettings.getPropertyKeys();
        String[] values = this.breakpointSettings.getPropertyValues();
        if (keys != null && values != null && keys.length == values.length) {
            int x = 0;
            while (x < keys.length) {
                properties.put(keys[x], values[x]);
                ++x;
            }
        }
        return properties;
    }

    void setProperties(Map<String, String> newProperties) {
        if (newProperties != null && !newProperties.isEmpty()) {
            String[] keys = newProperties.keySet().toArray(new String[newProperties.size()]);
            String[] values = newProperties.values().toArray(new String[newProperties.size()]);
            this.breakpointSettings.setPropertyKeys(keys);
            this.breakpointSettings.setPropertyValues(values);
        } else {
            this.breakpointSettings.setPropertyKeys(null);
            this.breakpointSettings.setPropertyValues(null);
        }
    }

    String getTypeStringOverride() {
        return this.breakpointSettings.getTypeStringOverride();
    }

    void setTypeStringOverride(String typeStringOverride) {
        this.breakpointSettings.setTypeStringOverride(typeStringOverride);
    }

    boolean isCustomBreakpoint() {
        return this.getTypeStringOverride() != null;
    }

    String getDebuggerExtenderID() {
        return this.breakpointSettings.getDebuggerExtenderID();
    }

    void setDebuggerExtenderID(String debuggerExtenderID) {
        this.breakpointSettings.setDebuggerExtenderID(debuggerExtenderID);
    }

    void pauseAndApplyChanges(Runnable runOnceLater) {
        24 runWhilePaused = new 24();
        25 runOnceLaterWrapper = null;
        if (runOnceLater != null) {
            runOnceLaterWrapper = new 25(this, runOnceLater);
        }
        this.pauseAndInvoke(runWhilePaused, runOnceLaterWrapper);
    }

    void putBreakpoint(DebuggingProcess debuggingProcess) {
        try {
            DebugBreakpoint dbp = null;
            String error = null;
            int bpType = this.breakpointSettings.getType();
            switch (bpType) {
                case 0: {
                    if ((debuggingProcess.getVM().getLanguages() & 0x10) != 0) {
                        return;
                    }
                    String pkg = this.breakpointSettings.getPkg();
                    String file = this.breakpointSettings.getFile();
                    int line = this.breakpointSettings.getLine();
                    dbp = debuggingProcess.getVM().putBreakpointPackageFileLine(pkg, file, line);
                    break;
                }
                case 1: {
                    if ((debuggingProcess.getVM().getLanguages() & 0x10) != 0) {
                        return;
                    }
                    String method = this.breakpointSettings.getMethod();
                    dbp = debuggingProcess.getVM().putBreakpointMethod(method);
                    break;
                }
                case 7: {
                    if ((debuggingProcess.getVM().getLanguages() & 0x10) != 0) {
                        return;
                    }
                    String method = this.breakpointSettings.getMethod();
                    int offset = this.breakpointSettings.getOffset();
                    dbp = debuggingProcess.getVM().putBreakpointMethodBytecode(method, offset);
                    break;
                }
                case 2: {
                    if ((debuggingProcess.getVM().getLanguages() & 0x10) != 0) {
                        return;
                    }
                    String exception = this.breakpointSettings.getException();
                    boolean caught = this.breakpointSettings.isCaught();
                    boolean uncaught = this.breakpointSettings.isUncaught();
                    dbp = debuggingProcess.getVM().putBreakpointException(exception, caught, uncaught);
                    break;
                }
                case 3: {
                    if ((debuggingProcess.getVM().getLanguages() & 0x10) != 0) {
                        return;
                    }
                    dbp = debuggingProcess.getVM().putBreakpointDeadlock();
                    break;
                }
                case 4: {
                    if ((debuggingProcess.getVM().getLanguages() & 0x10) != 0) {
                        return;
                    }
                    String className = this.breakpointSettings.getClassName();
                    dbp = debuggingProcess.getVM().putBreakpointClass(className);
                    break;
                }
                case 5: {
                    if ((debuggingProcess.getVM().getLanguages() & 0x10) != 0) {
                        dbp = debuggingProcess.getVM().putBreakpointFileLine(this.breakpointSettings.getURL().toString(), this.breakpointSettings.getLine());
                        break;
                    }
                    String[] packageAndFile = debuggingProcess.url_to_packageAndFile(this.breakpointSettings.getURL());
                    if (packageAndFile != null && packageAndFile.length == 2) {
                        int line = this.breakpointSettings.getLine();
                        dbp = debuggingProcess.getVM().putBreakpointPackageFileLine(packageAndFile[0], packageAndFile[1], line);
                        break;
                    }
                    error = DbgArb.format(533, this.getDescription());
                    break;
                }
                case 6: {
                    if ((debuggingProcess.getVM().getLanguages() & 0x10) != 0) {
                        return;
                    }
                    String className = this.breakpointSettings.getClassName();
                    String fieldName = this.breakpointSettings.getFieldName();
                    boolean access = this.breakpointSettings.isAccess();
                    boolean modify = this.breakpointSettings.isModify();
                    dbp = debuggingProcess.getVM().putBreakpointWatchpoint(className, fieldName, access, modify);
                    break;
                }
            }
            if (dbp != null) {
                String actionDisableOther;
                String condition;
                String groupName;
                this.debugBreakpointForDebuggingProcess.put(debuggingProcess, dbp);
                this.debuggingProcessForDebugBreakpoint.put(dbp, debuggingProcess);
                JDebugger.getInstance().breakpointHasBeenPut(this, dbp);
                if (!this.breakpointSettings.isEnabled()) {
                    dbp.setEnabled(false);
                }
                if ((groupName = this.breakpointSettings.getGroupName()).length() > 0) {
                    dbp.setName(groupName);
                }
                if ((condition = this.breakpointSettings.getCondition()).length() > 0) {
                    dbp.setCondition(this);
                }
                String threadName = this.breakpointSettings.getThreadName();
                String threadNameNot = this.breakpointSettings.getThreadNameNot();
                if (threadName.length() > 0) {
                    dbp.setThreadname(threadName);
                } else if (threadNameNot.length() > 0) {
                    dbp.setThreadnameNot(threadNameNot);
                }
                dbp.setPassCount(this.breakpointSettings.getPassCount());
                dbp.setStop(this.breakpointSettings.isActionHalt());
                dbp.setLog(this.breakpointSettings.isActionBeep() || this.breakpointSettings.isActionLog());
                String actionEnableOther = this.breakpointSettings.getActionEnableOther();
                if (actionEnableOther.length() > 0) {
                    dbp.setEnableOtherBPs(actionEnableOther);
                }
                if ((actionDisableOther = this.breakpointSettings.getActionDisableOther()).length() > 0) {
                    dbp.setDisableOtherBPs(actionDisableOther);
                }
                this.changed(dbp, debuggingProcess);
            } else if (this.breakpointSettings.isEnabled()) {
                String msg = null;
                if (error != null) {
                    msg = error;
                } else if (bpType == 3) {
                    if ((debuggingProcess.getVM().getLanguages() & 1) != 0) {
                        msg = DbgArb.getString(391);
                    }
                } else {
                    msg = bpType == 6 ? DbgArb.format(853, this.getDescription()) : DbgArb.format(178, this.getDescription());
                }
                if (msg != null) {
                    debuggingProcess.log(msg);
                }
            }
            dbp.setBreakpoint();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    void putBreakpoint(Runnable runOnceLater) {
        26 runWhilePaused = new 26();
        this.pauseAndInvoke(runWhilePaused, runOnceLater);
    }

    void removeBreakpoint() {
        if (!this.breakpointSettings.isPersistent()) {
            this.hideBreakpointIcon();
            JDebugger.getInstance().breakpointHasBeenRemoved(this);
            27 runWhilePaused = new 27();
            28 runOnceLater = new 28();
            this.pauseAndInvoke(runWhilePaused, runOnceLater);
            Breakpoint.removeBreakpointFromOwner(this);
        }
    }

    void setShallow(boolean shallow) {
        this.shallow = shallow;
    }

    private void pauseAndInvoke(RunWhilePaused runWhilePaused, Runnable runOnceLater) {
        DebuggingProcess[] processes = JDebugger.getInstance().getDebuggingProcessesForBreakpoint(this);
        JDebugger.pauseAndInvoke(processes, runWhilePaused, runOnceLater);
    }

    void changed(DebugBreakpoint dbp, DebuggingProcess debuggingProcess) {
        if (JDebugger.getInstance().isActiveDebuggingProcess(debuggingProcess)) {
            this.updateBreakpointIcon();
        }
    }

    void processFinished(DebuggingProcess debuggingProcess) {
        DebugBreakpoint dbp = this.getDebugBreakpoint(debuggingProcess);
        if (dbp != null) {
            JDebugger.getInstance().breakpointHasBeenRemoved(dbp);
            this.debuggingProcessForDebugBreakpoint.remove(dbp);
        }
        this.debugBreakpointForDebuggingProcess.remove(debuggingProcess);
    }

    String getTypeString() {
        if (this.breakpointSettings.getTypeStringOverride() != null) {
            return this.breakpointSettings.getTypeStringOverride();
        }
        switch (this.breakpointSettings.getType()) {
            case 0: {
                return DbgArb.getString(622);
            }
            case 1: {
                return DbgArb.getString(933);
            }
            case 7: {
                return DbgArb.getString(371);
            }
            case 2: {
                return DbgArb.getString(546);
            }
            case 3: {
                return DbgArb.getString(422);
            }
            case 4: {
                return DbgArb.getString(736);
            }
            case 5: {
                return DbgArb.getString(52);
            }
            case 6: {
                return DbgArb.getString(629);
            }
        }
        return "";
    }

    int getActiveStatus() {
        return this.getActiveStatus(null);
    }

    int getActiveStatus(DebuggingProcess debuggingProcess) {
        if (debuggingProcess == null) {
            debuggingProcess = JDebugger.getInstance().getActiveDebuggingProcess();
        }
        if (debuggingProcess != null) {
            DebugBreakpoint dbp = this.getDebugBreakpoint(debuggingProcess);
            if (dbp != null) {
                if (!dbp.getEnabled()) {
                    return 0;
                }
                if (dbp instanceof DebugBreakpointClass || dbp instanceof DebugBreakpointMethod || dbp instanceof DebugBreakpointMethodBytecode || dbp instanceof DebugBreakpointPackageFileLine) {
                    if (dbp instanceof DebugMozillaFireFoxBreakpoint) {
                        return ((DebugMozillaFireFoxBreakpoint)dbp).isSet() ? 3 : 2;
                    }
                    DebugLocation[] locations = dbp.getLocations();
                    return locations.length > 0 ? 3 : 2;
                }
                if (dbp instanceof DebugMozillaFireFoxBreakpoint) {
                    return ((DebugMozillaFireFoxBreakpoint)dbp).isSet() ? 3 : 2;
                }
            } else {
                return this.breakpointSettings.isEnabled() ? 2 : 0;
            }
        }
        return this.breakpointSettings.isEnabled() ? 1 : 0;
    }

    private int getIconKey() {
        if (this.breakpointSettings.getType() == 6) {
            if (this.isEnabledNow()) {
                return 580;
            }
            return 447;
        }
        switch (this.getActiveStatus()) {
            case 0: {
                return 284;
            }
            case 1: 
            case 2: {
                return 606;
            }
            case 3: {
                return 524;
            }
        }
        return -1;
    }

    @Override
    public String getShortLabel() {
        return DbgArb.format(224, this.getTypeString(), this.getDescription());
    }

    @Override
    public Icon getIcon() {
        int iconKey = this.getIconKey();
        if (iconKey != -1) {
            return DbgArb.getIcon(iconKey);
        }
        return null;
    }

    HighlightStyle getHighlightStyle() {
        switch (this.getActiveStatus()) {
            case 0: {
                return SourceIcon.disabledBPStyle;
            }
            case 1: 
            case 2: 
            case 3: {
                return SourceIcon.enabledBPStyle;
            }
        }
        return null;
    }

    private void makeSourceIcon(String pkg, String file, int line) {
        URL ownerURL = this.breakpointSettings.getOwnerURL();
        ArrayResourceBundle arb = DbgArb.getInstance();
        int iconKey = this.getIconKey();
        if (ownerURL == null) {
            this.sourceIcon = new SourceIcon(null, null, pkg, file, line, null, arb, iconKey, this.getHighlightStyle(), 0, this);
        } else {
            String ext = URLFileSystem.getSuffix((URL)ownerURL).toLowerCase();
            if (ext.equals(".jpr")) {
                this.sourceIcon = new SourceIcon(null, ownerURL, pkg, file, line, null, arb, iconKey, this.getHighlightStyle(), 0, this);
            } else if (ext.equals(".jws")) {
                this.sourceIcon = new SourceIcon(ownerURL, null, pkg, file, line, null, arb, iconKey, this.getHighlightStyle(), 0, this);
            }
        }
    }

    private void makeSourceIcon(URL url, int line) {
        URL ownerURL = this.breakpointSettings.getOwnerURL();
        ArrayResourceBundle arb = DbgArb.getInstance();
        int iconKey = this.getIconKey();
        if (ownerURL == null) {
            this.sourceIcon = new SourceIcon((URL)null, (URL)null, url, line, null, arb, iconKey, this.getHighlightStyle(), 0, this);
        } else {
            String ext = URLFileSystem.getSuffix((URL)ownerURL).toLowerCase();
            if (ext.equals(".jpr")) {
                this.sourceIcon = new SourceIcon((URL)null, ownerURL, url, line, null, arb, iconKey, this.getHighlightStyle(), 0, this);
            } else if (ext.equals(".jws")) {
                this.sourceIcon = new SourceIcon(ownerURL, (URL)null, url, line, null, arb, iconKey, this.getHighlightStyle(), 0, this);
            }
        }
    }

    private void makeSourceIcon(String className, String fieldName) {
        URL ownerURL = this.breakpointSettings.getOwnerURL();
        ArrayResourceBundle arb = DbgArb.getInstance();
        int iconKey = this.getIconKey();
        if (ownerURL == null) {
            this.sourceIcon = new SourceIcon((URL)null, (URL)null, className, fieldName, null, arb, iconKey, this.getHighlightStyle(), 1, this);
        } else {
            String ext = URLFileSystem.getSuffix((URL)ownerURL).toLowerCase();
            if (ext.equals(".jpr")) {
                this.sourceIcon = new SourceIcon((URL)null, ownerURL, className, fieldName, null, arb, iconKey, this.getHighlightStyle(), 1, this);
            } else if (ext.equals(".jws")) {
                this.sourceIcon = new SourceIcon(ownerURL, (URL)null, className, fieldName, null, arb, iconKey, this.getHighlightStyle(), 1, this);
            }
        }
    }

    private void makeSourceIcon(String fqMethod, int offset) {
        URL ownerURL = this.breakpointSettings.getOwnerURL();
        ArrayResourceBundle arb = DbgArb.getInstance();
        int iconKey = this.getIconKey();
        if (ownerURL == null) {
            this.sourceIcon = new SourceIcon((URL)null, (URL)null, fqMethod, offset, null, arb, iconKey, this.getHighlightStyle(), 0, this);
        } else {
            String ext = URLFileSystem.getSuffix((URL)ownerURL).toLowerCase();
            if (ext.equals(".jpr")) {
                this.sourceIcon = new SourceIcon((URL)null, ownerURL, fqMethod, offset, null, arb, iconKey, this.getHighlightStyle(), 0, this);
            } else if (ext.equals(".jws")) {
                this.sourceIcon = new SourceIcon(ownerURL, (URL)null, fqMethod, offset, null, arb, iconKey, this.getHighlightStyle(), 0, this);
            }
        }
    }

    private void showBreakpointIcon() {
        int bpType = this.breakpointSettings.getType();
        switch (bpType) {
            case 0: {
                String pkg = this.breakpointSettings.getPkg();
                String file = this.breakpointSettings.getFile();
                int line = this.breakpointSettings.getLine();
                this.makeSourceIcon(pkg, file, line);
                break;
            }
            case 5: {
                URL url = this.breakpointSettings.getURL();
                int line = this.breakpointSettings.getLine();
                this.makeSourceIcon(url, line);
                break;
            }
            case 6: {
                String className = this.breakpointSettings.getClassName();
                String fieldName = this.breakpointSettings.getFieldName();
                this.makeSourceIcon(className, fieldName);
                break;
            }
            case 7: {
                String fqMethodName = this.breakpointSettings.getMethod();
                int offset = this.breakpointSettings.getOffset();
                this.makeSourceIcon(fqMethodName, offset);
                break;
            }
        }
    }

    boolean matchesIconLocation(CodeEditor codeEditor, int line) {
        if (this.sourceIcon != null) {
            return this.sourceIcon.matchesIconLocation(codeEditor, line);
        }
        return false;
    }

    private boolean hideBreakpointIcon() {
        if (this.sourceIcon != null) {
            this.sourceIcon.hide();
            this.sourceIcon = null;
            return true;
        }
        return false;
    }

    private void updateBreakpointIcon() {
        if (this.sourceIcon != null) {
            this.sourceIcon.changeIcon(DbgArb.getInstance(), this.getIconKey(), this.getHighlightStyle());
        }
    }

    String getDescription() {
        String desc = "";
        switch (this.breakpointSettings.getType()) {
            case 0: {
                String pkg = this.breakpointSettings.getPkg();
                String file = this.breakpointSettings.getFile();
                if (Product.isRaptor() && file.endsWith(".pls")) {
                    file = file.substring(0, file.length() - 4);
                }
                int line = this.breakpointSettings.getLine();
                desc = pkg + " " + file + " " + line;
                break;
            }
            case 1: {
                String method;
                desc = method = this.breakpointSettings.getMethod();
                break;
            }
            case 7: {
                String method = this.breakpointSettings.getMethod();
                int offset = this.breakpointSettings.getOffset();
                desc = method + " " + offset;
                break;
            }
            case 2: {
                String exception = this.breakpointSettings.getException();
                if (Product.isRaptor() && this.breakpointSettings.isPersistent() && exception.equals("java.lang.Exception")) {
                    desc = DbgArb.getString(950);
                    break;
                }
                boolean caught = this.breakpointSettings.isCaught();
                boolean uncaught = this.breakpointSettings.isUncaught();
                if (caught) {
                    if (uncaught) {
                        desc = DbgArb.format(938, exception);
                        break;
                    }
                    desc = DbgArb.format(777, exception);
                    break;
                }
                if (uncaught) {
                    desc = DbgArb.format(49, exception);
                    break;
                }
                desc = exception;
                break;
            }
            case 3: {
                desc = DbgArb.getString(223);
                break;
            }
            case 4: {
                String className;
                desc = className = this.breakpointSettings.getClassName();
                break;
            }
            case 5: {
                URL url = this.breakpointSettings.getURL();
                int line = this.breakpointSettings.getLine();
                desc = URLFileSystem.getPlatformPathName((URL)url) + " " + line;
                break;
            }
            case 6: {
                String classNameFieldName = this.breakpointSettings.getClassName() + " " + this.breakpointSettings.getFieldName();
                boolean access = this.breakpointSettings.isAccess();
                boolean modify = this.breakpointSettings.isModify();
                if (access) {
                    if (modify) {
                        desc = DbgArb.format(599, classNameFieldName);
                        break;
                    }
                    desc = DbgArb.format(696, classNameFieldName);
                    break;
                }
                if (modify) {
                    desc = DbgArb.format(758, classNameFieldName);
                    break;
                }
                desc = classNameFieldName;
                break;
            }
        }
        if (this.breakpointSettings.isPersistent()) {
            desc = DbgArb.format(7, desc);
        }
        return desc;
    }

    String getStatusInfo() {
        String s = this.breakpointSettings.isEnabled() ? DbgArb.getString(336) : DbgArb.getString(490);
        DebuggingProcess debuggingProcess = JDebugger.getInstance().getActiveDebuggingProcess();
        if (debuggingProcess != null) {
            String activeStatus = null;
            switch (this.getActiveStatus()) {
                case 0: {
                    activeStatus = DbgArb.getString(490);
                    break;
                }
                case 1: {
                    activeStatus = DbgArb.getString(336);
                    break;
                }
                case 2: {
                    activeStatus = DbgArb.getString(805);
                    break;
                }
                case 3: {
                    activeStatus = DbgArb.getString(745);
                    break;
                }
            }
            if (activeStatus != null && !activeStatus.equals(s)) {
                s = s + " " + DbgArb.format(263, activeStatus);
            }
        }
        return s;
    }

    static void loadBreakpoints() {
        savedBreakpoints = new SavedBreakpoints();
        savedBreakpoints.load();
        ArrayList breakpoints = savedBreakpoints.getBreakpoints();
        int count = breakpoints.size();
        if (count == 0) {
            Breakpoint.createPersistentBreakpoints();
        } else {
            int i = 0;
            while (i < count) {
                BreakpointSettings breakpointSettings = (BreakpointSettings)breakpoints.get(i);
                Breakpoint bp = new Breakpoint(breakpointSettings);
                List keyBreakpoints = Breakpoint.getBreakpoints(bp.getOwnerURL());
                keyBreakpoints.add(bp);
                ++i;
            }
        }
    }

    private static void createPersistentBreakpoints() {
        Breakpoint bpUncaughtException = new Breakpoint((URL)null, 2, "java.lang.Exception", false, true);
        Breakpoint.initializePersistentOptions(bpUncaughtException);
        Breakpoint.addBreakpointToOwner(bpUncaughtException);
        if (!Product.isRaptor()) {
            String osNameLower = System.getProperty("os.name").toLowerCase();
            if (osNameLower.indexOf("linux") != -1) {
                bpUncaughtException.setEnabled(false);
            }
            Breakpoint bpAssertionError = new Breakpoint((URL)null, 2, "java.lang.AssertionError", false, true);
            Breakpoint.initializePersistentOptions(bpAssertionError);
            Breakpoint.addBreakpointToOwner(bpAssertionError);
            Breakpoint bpDeadlock = new Breakpoint(null, 3);
            Breakpoint.initializePersistentOptions(bpDeadlock);
            Breakpoint.addBreakpointToOwner(bpDeadlock);
            if (osNameLower.indexOf("sunos") != -1) {
                bpDeadlock.setEnabled(false);
            }
        }
    }

    private static void initializePersistentOptions(Breakpoint bp) {
        bp.breakpointSettings.setPersistent(true);
        bp.breakpointSettings.setActionHalt(true);
        bp.breakpointSettings.setActionLog(true);
        bp.breakpointSettings.setActionLogTag("");
        bp.breakpointSettings.setActionLogExpr("");
        bp.breakpointSettings.setActionLogStack(false);
        bp.breakpointSettings.setActionEnableOther("");
        bp.breakpointSettings.setActionDisableOther("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void saveBreakpoints() {
        ArrayList breakpoints = savedBreakpoints.getBreakpoints();
        breakpoints.clear();
        Map map = allBreakpoints;
        synchronized (map) {
            for (Object key : allBreakpoints.keySet()) {
                URL ownerURL;
                boolean saveKeyBreakpoints = true;
                if (key instanceof URL && !URLFileSystem.exists((URL)(ownerURL = (URL)key))) {
                    saveKeyBreakpoints = false;
                }
                if (!saveKeyBreakpoints) continue;
                List keyBreakpoints = (List)allBreakpoints.get(key);
                for (Breakpoint bp : keyBreakpoints) {
                    BreakpointSettings breakpointSettings = bp.breakpointSettings;
                    breakpoints.add(breakpointSettings);
                }
            }
        }
        savedBreakpoints.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List getBreakpoints(URL ownerURL) {
        ArrayList breakpoints;
        Object key = ownerURL == null ? GlobalBreakpointsKey : ownerURL;
        Map map = allBreakpoints;
        synchronized (map) {
            breakpoints = (ArrayList)allBreakpoints.get(key);
            if (breakpoints == null) {
                breakpoints = new ArrayList();
                allBreakpoints.put(key, breakpoints);
            }
        }
        return breakpoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void breakpointOwnerRenamed(UpdateMessage rename) {
        URL oldKey = RenameMessage.getOldURL((UpdateMessage)rename);
        Node renamedNode = RenameMessage.getRenamedNode((UpdateMessage)rename);
        if (renamedNode != null) {
            URL newKey = renamedNode.getURL();
            Map map = allBreakpoints;
            synchronized (map) {
                List breakpoints = (List)allBreakpoints.remove(oldKey);
                if (breakpoints != null) {
                    for (Breakpoint bp : breakpoints) {
                        bp.setOwnerURL(newKey);
                    }
                    allBreakpoints.put(newKey, breakpoints);
                }
            }
        }
    }

    static List[] getBreakpoints(Workspace workspace, Project project) {
        ArrayList<List> breakpoints = new ArrayList<List>();
        breakpoints.add(Breakpoint.getBreakpoints(null));
        if (workspace != null && workspace != Ide.getDefaultWorkspace()) {
            breakpoints.add(Breakpoint.getBreakpoints(workspace.getURL()));
        }
        if (project != null && project != Ide.getDefaultProject()) {
            breakpoints.add(Breakpoint.getBreakpoints(project.getURL()));
        }
        return breakpoints.toArray(new List[breakpoints.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<Breakpoint> getExtenderBreakpoints(String debuggerExtenderID) {
        ArrayList<Breakpoint> breakpoints = new ArrayList<Breakpoint>();
        Map map = allBreakpoints;
        synchronized (map) {
            for (Object key : allBreakpoints.keySet()) {
                List keyBreakpoints = (List)allBreakpoints.get(key);
                for (Breakpoint bp : keyBreakpoints) {
                    if (!debuggerExtenderID.equals(bp.getDebuggerExtenderID())) continue;
                    breakpoints.add(bp);
                }
            }
        }
        return breakpoints;
    }

    static void removeBreakpointFromOwner(Breakpoint bp) {
        URL ownerURL = bp.getOwnerURL();
        List breakpoints = Breakpoint.getBreakpoints(ownerURL);
        breakpoints.remove(bp);
    }

    static void addBreakpointToOwner(Breakpoint bp) {
        Breakpoint.addBreakpointToOwner(bp, false);
    }

    static void addBreakpointToOwner(Breakpoint bp, boolean showBreakpointIcon) {
        URL ownerURL = bp.getOwnerURL();
        List breakpoints = Breakpoint.getBreakpoints(ownerURL);
        breakpoints.add(bp);
        if (showBreakpointIcon) {
            bp.showBreakpointIcon();
        }
    }

    static void showBreakpointIcons(List[] breakpoints) {
        int length = breakpoints.length;
        int i = 0;
        while (i < length) {
            for (Breakpoint bp : breakpoints[i]) {
                bp.showBreakpointIcon();
            }
            ++i;
        }
    }

    static void hideBreakpointIcons(List[] breakpoints) {
        int length = breakpoints.length;
        int i = 0;
        while (i < length) {
            for (Breakpoint bp : breakpoints[i]) {
                bp.hideBreakpointIcon();
            }
            ++i;
        }
    }

    static void updateBreakpointIcons(List[] breakpoints) {
        int length = breakpoints.length;
        int i = 0;
        while (i < length) {
            for (Breakpoint bp : breakpoints[i]) {
                bp.updateBreakpointIcon();
            }
            ++i;
        }
    }

    static RefactoringHandler getRefactoringHandler() {
        return new RefactoringHandler();
    }

    static {
        allBreakpoints = new HashMap();
    }

    static Map ra$allBreakpoints() {
        return allBreakpoints;
    }

    static Object ra$GlobalBreakpointsKey() {
        return GlobalBreakpointsKey;
    }

    static Map ra$debuggingProcessForDebugBreakpoint(Breakpoint breakpoint) {
        return breakpoint.debuggingProcessForDebugBreakpoint;
    }

    static Map ra$debugBreakpointForDebuggingProcess(Breakpoint breakpoint) {
        return breakpoint.debugBreakpointForDebuggingProcess;
    }

    static BreakpointSettings ra$breakpointSettings(Breakpoint breakpoint) {
        return breakpoint.breakpointSettings;
    }

    static void mav$updateBreakpointIcon(Breakpoint breakpoint) {
        breakpoint.updateBreakpointIcon();
    }

    final class 1
    implements RunWhilePaused {
        private final /* synthetic */ String v$pkgArg;
        private final /* synthetic */ String v$fileArg;
        private final /* synthetic */ int v$lineArg;
        final /* synthetic */ Breakpoint this$0;

        public void run(DebuggingProcess debuggingProcess, boolean live) {
            if (debuggingProcess != null && live) {
                DebugBreakpointPackageFileLine dbp = (DebugBreakpointPackageFileLine)this.this$0.getDebugBreakpoint(debuggingProcess);
                if (dbp != null) {
                    dbp.setPackageFileLine(this.v$pkgArg, this.v$fileArg, this.v$lineArg);
                } else {
                    Assert.println((String)"Breakpoint.setPackageFileLine - could not get DebugBreakpoint for DebuggingProcess");
                }
            }
        }

        public 1(Breakpoint breakpoint, String string, String string2, int n) {
            this.v$lineArg = n;
            this.v$fileArg = string2;
            this.v$pkgArg = string;
            this.this$0 = breakpoint;
        }
    }

    final class 2
    implements Runnable {
        public void run() {
            Breakpoint.mav$updateBreakpointIcon(Breakpoint.this);
        }
    }

    final class 3
    implements RunWhilePaused {
        private final /* synthetic */ String v$methodArg;
        final /* synthetic */ Breakpoint this$0;

        public void run(DebuggingProcess debuggingProcess, boolean live) {
            if (debuggingProcess != null && live) {
                DebugBreakpointMethod dbp = (DebugBreakpointMethod)this.this$0.getDebugBreakpoint(debuggingProcess);
                if (dbp != null) {
                    dbp.setMethod(this.v$methodArg);
                } else {
                    Assert.println((String)"Breakpoint.setMethod - could not get DebugBreakpoint for DebuggingProcess");
                }
            }
        }

        public 3(Breakpoint breakpoint, String string) {
            this.v$methodArg = string;
            this.this$0 = breakpoint;
        }
    }

    final class 4
    implements RunWhilePaused {
        private final /* synthetic */ String v$methodArg;
        private final /* synthetic */ int v$offsetArg;
        final /* synthetic */ Breakpoint this$0;

        public void run(DebuggingProcess debuggingProcess, boolean live) {
            if (debuggingProcess != null && live) {
                DebugBreakpointMethodBytecode dbp = (DebugBreakpointMethodBytecode)this.this$0.getDebugBreakpoint(debuggingProcess);
                if (dbp != null) {
                    dbp.setMethodBytecodeOffset(this.v$methodArg, this.v$offsetArg);
                } else {
                    Assert.println((String)"Breakpoint.setMethodOffset - could not get DebugBreakpoint for DebuggingProcess");
                }
            }
        }

        public 4(Breakpoint breakpoint, String string, int n) {
            this.v$offsetArg = n;
            this.v$methodArg = string;
            this.this$0 = breakpoint;
        }
    }

    final class 5
    implements Runnable {
        public void run() {
            Breakpoint.mav$updateBreakpointIcon(Breakpoint.this);
        }
    }

    final class 6
    implements RunWhilePaused {
        private final /* synthetic */ String v$exceptionArg;
        private final /* synthetic */ boolean v$caughtArg;
        private final /* synthetic */ boolean v$uncaughtArg;
        final /* synthetic */ Breakpoint this$0;

        public void run(DebuggingProcess debuggingProcess, boolean live) {
            if (debuggingProcess != null && live) {
                DebugBreakpointException dbp = (DebugBreakpointException)this.this$0.getDebugBreakpoint(debuggingProcess);
                if (dbp != null) {
                    dbp.setExceptionClassname(this.v$exceptionArg, this.v$caughtArg, this.v$uncaughtArg);
                } else {
                    Assert.println((String)"Breakpoint.setException - could not get DebugBreakpoint for DebuggingProcess");
                }
            }
        }

        public 6(Breakpoint breakpoint, String string, boolean bl, boolean bl2) {
            this.v$uncaughtArg = bl2;
            this.v$caughtArg = bl;
            this.v$exceptionArg = string;
            this.this$0 = breakpoint;
        }
    }

    final class 7
    implements RunWhilePaused {
        private final /* synthetic */ String v$classNameArg;
        final /* synthetic */ Breakpoint this$0;

        public void run(DebuggingProcess debuggingProcess, boolean live) {
            if (debuggingProcess != null && live) {
                DebugBreakpointClass dbp = (DebugBreakpointClass)this.this$0.getDebugBreakpoint(debuggingProcess);
                if (dbp != null) {
                    dbp.setClassname(this.v$classNameArg);
                } else {
                    Assert.println((String)"Breakpoint.setClassName - could not get DebugBreakpoint for DebuggingProcess");
                }
            }
        }

        public 7(Breakpoint breakpoint, String string) {
            this.v$classNameArg = string;
            this.this$0 = breakpoint;
        }
    }

    final class 8
    implements RunWhilePaused {
        private final /* synthetic */ URL v$urlArg;
        private final /* synthetic */ int v$lineArg;
        final /* synthetic */ Breakpoint this$0;

        public void run(DebuggingProcess debuggingProcess, boolean live) {
            if (debuggingProcess != null && live) {
                DebugBreakpointPackageFileLine dbp = (DebugBreakpointPackageFileLine)this.this$0.getDebugBreakpoint(debuggingProcess);
                if (dbp != null) {
                    String[] packageAndFile = debuggingProcess.url_to_packageAndFile(this.v$urlArg);
                    if (packageAndFile != null && packageAndFile.length == 2) {
                        dbp.setPackageFileLine(packageAndFile[0], packageAndFile[1], this.v$lineArg);
                    }
                } else {
                    Assert.println((String)"Breakpoint.setPackageFileLine - could not get DebugBreakpoint for DebuggingProcess");
                }
            }
        }

        public 8(Breakpoint breakpoint, URL uRL, int n) {
            this.v$lineArg = n;
            this.v$urlArg = uRL;
            this.this$0 = breakpoint;
        }
    }

    final class 9
    implements Runnable {
        public void run() {
            Breakpoint.mav$updateBreakpointIcon(Breakpoint.this);
        }
    }

    final class 10
    implements RunWhilePaused {
        private final /* synthetic */ String v$classNameArg;
        private final /* synthetic */ String v$fieldNameArg;
        private final /* synthetic */ boolean v$accessArg;
        private final /* synthetic */ boolean v$modifyArg;
        final /* synthetic */ Breakpoint this$0;

        public void run(DebuggingProcess debuggingProcess, boolean live) {
            if (debuggingProcess != null && live) {
                DebugBreakpointWatchpoint dbp = (DebugBreakpointWatchpoint)this.this$0.getDebugBreakpoint(debuggingProcess);
                if (dbp != null) {
                    dbp.setWatchpoint(this.v$classNameArg, this.v$fieldNameArg, this.v$accessArg, this.v$modifyArg);
                } else {
                    Assert.println((String)"Breakpoint.setWatchpoint - could not get DebugBreakpoint for DebuggingProcess");
                }
            }
        }

        public 10(Breakpoint breakpoint, String string, String string2, boolean bl, boolean bl2) {
            this.v$modifyArg = bl2;
            this.v$accessArg = bl;
            this.v$fieldNameArg = string2;
            this.v$classNameArg = string;
            this.this$0 = breakpoint;
        }
    }

    final class 11
    implements Runnable {
        public void run() {
            Breakpoint.mav$updateBreakpointIcon(Breakpoint.this);
        }
    }

    final class 12
    implements RunWhilePaused {
        private final /* synthetic */ boolean v$enabledArg;
        final /* synthetic */ Breakpoint this$0;

        public void run(DebuggingProcess debuggingProcess, boolean live) {
            if (debuggingProcess != null && live) {
                DebugBreakpoint dbp = this.this$0.getDebugBreakpoint(debuggingProcess);
                if (dbp != null) {
                    dbp.setEnabled(this.v$enabledArg);
                } else {
                    Assert.println((String)"Breakpoint.setEnabled - could not get DebugBreakpoint for DebuggingProcess");
                }
            }
        }

        public 12(Breakpoint breakpoint, boolean bl) {
            this.v$enabledArg = bl;
            this.this$0 = breakpoint;
        }
    }

    final class 13
    implements Runnable {
        public void run() {
            Breakpoint.mav$updateBreakpointIcon(Breakpoint.this);
            JDebugger.getInstance().updateBreakpointsWindowStatus();
        }
    }

    final class 14
    implements RunWhilePaused {
        private final /* synthetic */ String v$groupName;
        final /* synthetic */ Breakpoint this$0;

        public void run(DebuggingProcess debuggingProcess, boolean live) {
            if (debuggingProcess != null && live) {
                DebugBreakpoint dbp = this.this$0.getDebugBreakpoint(debuggingProcess);
                if (dbp != null) {
                    dbp.setName(this.v$groupName);
                } else {
                    Assert.println((String)"Breakpoint.setGroupName - could not get DebugBreakpoint for DebuggingProcess");
                }
            }
        }

        public 14(Breakpoint breakpoint, String string) {
            this.v$groupName = string;
            this.this$0 = breakpoint;
        }
    }

    final class 15
    implements RunWhilePaused {
        private final /* synthetic */ DebugBreakpointCondition v$bpCondition;
        final /* synthetic */ Breakpoint this$0;

        public void run(DebuggingProcess debuggingProcess, boolean live) {
            if (debuggingProcess != null && live) {
                DebugBreakpoint dbp = this.this$0.getDebugBreakpoint(debuggingProcess);
                if (dbp != null) {
                    dbp.setCondition(this.v$bpCondition);
                } else {
                    Assert.println((String)"Breakpoint.setCondition - could not get DebugBreakpoint for DebuggingProcess");
                }
            }
        }

        public 15(Breakpoint breakpoint, DebugBreakpointCondition debugBreakpointCondition) {
            this.v$bpCondition = debugBreakpointCondition;
            this.this$0 = breakpoint;
        }
    }

    final class 16
    implements RunWhilePaused {
        private final /* synthetic */ String v$threadName;
        final /* synthetic */ Breakpoint this$0;

        public void run(DebuggingProcess debuggingProcess, boolean live) {
            if (debuggingProcess != null && live) {
                DebugBreakpoint dbp = this.this$0.getDebugBreakpoint(debuggingProcess);
                if (dbp != null) {
                    dbp.setThreadname(this.v$threadName);
                } else {
                    Assert.println((String)"Breakpoint.setThreadName - could not get DebugBreakpoint for DebuggingProcess");
                }
            }
        }

        public 16(Breakpoint breakpoint, String string) {
            this.v$threadName = string;
            this.this$0 = breakpoint;
        }
    }

    final class 17
    implements RunWhilePaused {
        private final /* synthetic */ String v$threadNameNot;
        final /* synthetic */ Breakpoint this$0;

        public void run(DebuggingProcess debuggingProcess, boolean live) {
            if (debuggingProcess != null && live) {
                DebugBreakpoint dbp = this.this$0.getDebugBreakpoint(debuggingProcess);
                if (dbp != null) {
                    dbp.setThreadnameNot(this.v$threadNameNot);
                } else {
                    Assert.println((String)"Breakpoint.setThreadNameNot - could not get DebugBreakpoint for DebuggingProcess");
                }
            }
        }

        public 17(Breakpoint breakpoint, String string) {
            this.v$threadNameNot = string;
            this.this$0 = breakpoint;
        }
    }

    final class 18
    implements RunWhilePaused {
        private final /* synthetic */ int v$passCountArg;
        final /* synthetic */ Breakpoint this$0;

        public void run(DebuggingProcess debuggingProcess, boolean live) {
            if (debuggingProcess != null && live) {
                DebugBreakpoint dbp = this.this$0.getDebugBreakpoint(debuggingProcess);
                if (dbp != null) {
                    dbp.setPassCount(this.v$passCountArg);
                } else {
                    Assert.println((String)"Breakpoint.setPassCount - could not get DebugBreakpoint for DebuggingProcess");
                }
            }
        }

        public 18(Breakpoint breakpoint, int n) {
            this.v$passCountArg = n;
            this.this$0 = breakpoint;
        }
    }

    final class 19
    implements RunWhilePaused {
        private final /* synthetic */ boolean v$actionHaltArg;
        final /* synthetic */ Breakpoint this$0;

        public void run(DebuggingProcess debuggingProcess, boolean live) {
            if (debuggingProcess != null && live) {
                DebugBreakpoint dbp = this.this$0.getDebugBreakpoint(debuggingProcess);
                if (dbp != null) {
                    dbp.setStop(this.v$actionHaltArg);
                } else {
                    Assert.println((String)"Breakpoint.setActionHalt - could not get DebugBreakpoint for DebuggingProcess");
                }
            }
        }

        public 19(Breakpoint breakpoint, boolean bl) {
            this.v$actionHaltArg = bl;
            this.this$0 = breakpoint;
        }
    }

    final class 20
    implements RunWhilePaused {
        public void run(DebuggingProcess debuggingProcess, boolean live) {
            if (debuggingProcess != null && live) {
                DebugBreakpoint dbp = Breakpoint.this.getDebugBreakpoint(debuggingProcess);
                if (dbp != null) {
                    dbp.setLog(Breakpoint.ra$breakpointSettings(Breakpoint.this).isActionBeep() || Breakpoint.ra$breakpointSettings(Breakpoint.this).isActionLog());
                } else {
                    Assert.println((String)"Breakpoint.setActionBeep - could not get DebugBreakpoint for DebuggingProcess");
                }
            }
        }
    }

    final class 21
    implements RunWhilePaused {
        public void run(DebuggingProcess debuggingProcess, boolean live) {
            if (debuggingProcess != null && live) {
                DebugBreakpoint dbp = Breakpoint.this.getDebugBreakpoint(debuggingProcess);
                if (dbp != null) {
                    dbp.setLog(Breakpoint.ra$breakpointSettings(Breakpoint.this).isActionBeep() || Breakpoint.ra$breakpointSettings(Breakpoint.this).isActionLog());
                } else {
                    Assert.println((String)"Breakpoint.setActionLog - could not get DebugBreakpoint for DebuggingProcess");
                }
            }
        }
    }

    final class 22
    implements RunWhilePaused {
        private final /* synthetic */ String v$actionEnableOther;
        final /* synthetic */ Breakpoint this$0;

        public void run(DebuggingProcess debuggingProcess, boolean live) {
            if (debuggingProcess != null && live) {
                DebugBreakpoint dbp = this.this$0.getDebugBreakpoint(debuggingProcess);
                if (dbp != null) {
                    dbp.setEnableOtherBPs(this.v$actionEnableOther);
                } else {
                    Assert.println((String)"Breakpoint.setActionEnableOther - could not get DebugBreakpoint for DebuggingProcess");
                }
            }
        }

        public 22(Breakpoint breakpoint, String string) {
            this.v$actionEnableOther = string;
            this.this$0 = breakpoint;
        }
    }

    final class 23
    implements RunWhilePaused {
        private final /* synthetic */ String v$actionDisableOther;
        final /* synthetic */ Breakpoint this$0;

        public void run(DebuggingProcess debuggingProcess, boolean live) {
            if (debuggingProcess != null && live) {
                DebugBreakpoint dbp = this.this$0.getDebugBreakpoint(debuggingProcess);
                if (dbp != null) {
                    dbp.setDisableOtherBPs(this.v$actionDisableOther);
                } else {
                    Assert.println((String)"Breakpoint.setActionDisableOther - could not get DebugBreakpoint for DebuggingProcess");
                }
            }
        }

        public 23(Breakpoint breakpoint, String string) {
            this.v$actionDisableOther = string;
            this.this$0 = breakpoint;
        }
    }

    final class 24
    implements RunWhilePaused {
        public void run(DebuggingProcess debuggingProcess, boolean live) {
            if (debuggingProcess != null && live) {
                try {
                    DebugBreakpoint dbp = Breakpoint.this.getDebugBreakpoint(debuggingProcess);
                    if (dbp != null) {
                        switch (Breakpoint.ra$breakpointSettings(Breakpoint.this).getType()) {
                            case 0: {
                                String pkg = Breakpoint.ra$breakpointSettings(Breakpoint.this).getPkg();
                                String file = Breakpoint.ra$breakpointSettings(Breakpoint.this).getFile();
                                int line = Breakpoint.ra$breakpointSettings(Breakpoint.this).getLine();
                                ((DebugBreakpointPackageFileLine)dbp).setPackageFileLine(pkg, file, line);
                                break;
                            }
                            case 1: {
                                String method = Breakpoint.ra$breakpointSettings(Breakpoint.this).getMethod();
                                ((DebugBreakpointMethod)dbp).setMethod(method);
                                break;
                            }
                            case 7: {
                                String method = Breakpoint.ra$breakpointSettings(Breakpoint.this).getMethod();
                                int offset = Breakpoint.ra$breakpointSettings(Breakpoint.this).getOffset();
                                ((DebugBreakpointMethodBytecode)dbp).setMethodBytecodeOffset(method, offset);
                                break;
                            }
                            case 2: {
                                String exception = Breakpoint.ra$breakpointSettings(Breakpoint.this).getException();
                                boolean caught = Breakpoint.ra$breakpointSettings(Breakpoint.this).isCaught();
                                boolean uncaught = Breakpoint.ra$breakpointSettings(Breakpoint.this).isUncaught();
                                ((DebugBreakpointException)dbp).setExceptionClassname(exception, caught, uncaught);
                                break;
                            }
                            case 4: {
                                String className = Breakpoint.ra$breakpointSettings(Breakpoint.this).getClassName();
                                ((DebugBreakpointClass)dbp).setClassname(className);
                                break;
                            }
                            case 5: {
                                if ((debuggingProcess.getVM().getLanguages() & 0x10) != 0) {
                                    ((DebugBreakpointPackageFileLine)dbp).setPackageFileLine(null, Breakpoint.ra$breakpointSettings(Breakpoint.this).getURL().toString(), Breakpoint.ra$breakpointSettings(Breakpoint.this).getLine());
                                    break;
                                }
                                String[] packageAndFile = debuggingProcess.url_to_packageAndFile(Breakpoint.ra$breakpointSettings(Breakpoint.this).getURL());
                                if (packageAndFile == null || packageAndFile.length != 2) break;
                                int line = Breakpoint.ra$breakpointSettings(Breakpoint.this).getLine();
                                ((DebugBreakpointPackageFileLine)dbp).setPackageFileLine(packageAndFile[0], packageAndFile[1], line);
                                break;
                            }
                            case 6: {
                                String className = Breakpoint.ra$breakpointSettings(Breakpoint.this).getClassName();
                                String fieldName = Breakpoint.ra$breakpointSettings(Breakpoint.this).getFieldName();
                                boolean access = Breakpoint.ra$breakpointSettings(Breakpoint.this).isAccess();
                                boolean modify = Breakpoint.ra$breakpointSettings(Breakpoint.this).isModify();
                                ((DebugBreakpointWatchpoint)dbp).setWatchpoint(className, fieldName, access, modify);
                                break;
                            }
                        }
                        dbp.setEnabled(Breakpoint.ra$breakpointSettings(Breakpoint.this).isEnabled());
                        dbp.setName(Breakpoint.ra$breakpointSettings(Breakpoint.this).getGroupName());
                        Breakpoint bpCondition = Breakpoint.ra$breakpointSettings(Breakpoint.this).getCondition().length() > 0 ? Breakpoint.this : null;
                        dbp.setCondition(bpCondition);
                        dbp.setThreadname(Breakpoint.ra$breakpointSettings(Breakpoint.this).getThreadName());
                        dbp.setThreadnameNot(Breakpoint.ra$breakpointSettings(Breakpoint.this).getThreadNameNot());
                        dbp.setPassCount(Breakpoint.ra$breakpointSettings(Breakpoint.this).getPassCount());
                        dbp.setStop(Breakpoint.ra$breakpointSettings(Breakpoint.this).isActionHalt());
                        dbp.setLog(Breakpoint.ra$breakpointSettings(Breakpoint.this).isActionBeep() || Breakpoint.ra$breakpointSettings(Breakpoint.this).isActionLog());
                        dbp.setEnableOtherBPs(Breakpoint.ra$breakpointSettings(Breakpoint.this).getActionEnableOther());
                        dbp.setDisableOtherBPs(Breakpoint.ra$breakpointSettings(Breakpoint.this).getActionDisableOther());
                        dbp.changeBreakpoint();
                    } else {
                        Assert.println((String)"Breakpoint.pauseAndApplyChanges - could not get DebugBreakpoint for DebuggingProcess");
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    final class 25
    implements Runnable {
        private final /* synthetic */ Runnable v$runOnceLater;
        final /* synthetic */ Breakpoint this$0;

        public void run() {
            Breakpoint.mav$updateBreakpointIcon(this.this$0);
            this.v$runOnceLater.run();
        }

        public 25(Breakpoint breakpoint, Runnable runnable) {
            this.v$runOnceLater = runnable;
            this.this$0 = breakpoint;
        }
    }

    final class 26
    implements RunWhilePaused {
        public void run(DebuggingProcess debuggingProcess, boolean live) {
            if (debuggingProcess != null && live) {
                Breakpoint.this.putBreakpoint(debuggingProcess);
            }
        }
    }

    final class 27
    implements RunWhilePaused {
        public void run(DebuggingProcess debuggingProcess, boolean live) {
            if (debuggingProcess != null && live) {
                DebugBreakpoint dbp = Breakpoint.this.getDebugBreakpoint(debuggingProcess);
                if (dbp != null) {
                    JDebugger.getInstance().breakpointHasBeenRemoved(dbp);
                    dbp.remove();
                } else {
                    Assert.println((String)"Breakpoint.removeBreakpoint - could not get DebugBreakpoint for DebuggingProcess");
                }
            }
        }
    }

    final class 28
    implements Runnable {
        public void run() {
            Breakpoint.ra$debuggingProcessForDebugBreakpoint(Breakpoint.this).clear();
            Breakpoint.ra$debugBreakpointForDebuggingProcess(Breakpoint.this).clear();
        }
    }

    static class RefactoringHandler
    extends URLRefactoringHandler {
        RefactoringHandler() {
        }

        public HashSet chooseURLs(SearchOperation so, Project project, ProgressIndicator progressIndicator) {
            RefactoringOperation ro = (RefactoringOperation)so.getProperty(Breakpoint.REFACTORING_OPERATION);
            if (ro == null) {
                ro = new RefactoringOperation();
                so.setProperty(Breakpoint.REFACTORING_OPERATION, ro);
            }
            SearchCriteria sc = so.getCriteria();
            boolean result = false;
            switch (sc.getSearchType()) {
                case -2147483546: {
                    result = ro.refactorRenameMethod_chooseUrls(project, (RenameMethodCriteria)sc);
                    break;
                }
                case -2147483545: {
                    result = ro.refactorRenameField_chooseUrls(project, (RenameFieldCriteria)sc);
                    break;
                }
                case -2147483535: {
                    result = ro.refactorMoveClasses_chooseUrls(project, (MoveClassesCriteria)sc);
                    break;
                }
                default: {
                    result = false;
                    break;
                }
            }
            if (result) {
                HashSet<URL> hashSet = new HashSet<URL>();
                hashSet.add(SavedBreakpoints.getXMLURL());
                return hashSet;
            }
            return null;
        }

        public UsageModel findUsages(SearchOperation so, Project project, URL[] urls, ProgressIndicator progressIndicator) {
            return null;
        }

        public boolean doChanges(SearchOperation so, UsageModel usageModel, Project project) {
            RefactoringOperation ro = (RefactoringOperation)so.getProperty(Breakpoint.REFACTORING_OPERATION);
            SearchCriteria sc = so.getCriteria();
            switch (sc.getSearchType()) {
                case -2147483546: {
                    return ro.refactorRenameMethod_doChanges(project, (RenameMethodCriteria)sc);
                }
                case -2147483545: {
                    return ro.refactorRenameField_doChanges(project, (RenameFieldCriteria)sc);
                }
                case -2147483535: {
                    return ro.refactorMoveClasses_doChanges(project, (MoveClassesCriteria)sc);
                }
            }
            return false;
        }
    }

    static class RefactoringOperation {
        private Map projectToAffectedBreakpoints;
        private String className;
        private String oldMethodName;
        private String oldFullMethodName;
        private String oldGetterName;
        private String oldFullGetterName;
        private String oldSetterName;
        private String oldFullSetterName;
        private String oldFieldName;
        private Map bpToUrl;
        private final String REFACTOR_BREAKPOINT_CMD_PREFIX;
        private int countRefactorBreakpointCommands;

        RefactoringOperation() {
            this.$init$();
            this.projectToAffectedBreakpoints = new HashMap();
            this.bpToUrl = new HashMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set getRefactorableBreakpoints(Project project) {
            HashSet refactorableBreakpoints = new HashSet();
            Map map = Breakpoint.ra$allBreakpoints();
            synchronized (map) {
                Workspace activeWorkspace;
                if (project != null) {
                    URL urlProject = project.getURL();
                    List projectBreakpoints = (List)Breakpoint.ra$allBreakpoints().get(urlProject);
                    if (projectBreakpoints != null) {
                        refactorableBreakpoints.addAll(projectBreakpoints);
                    }
                }
                if (project == Ide.getActiveProject() && (activeWorkspace = Ide.getActiveWorkspace()) != null) {
                    List globalBreakpoints;
                    URL urlActiveWorkspace = activeWorkspace.getURL();
                    List workspaceBreakpoints = (List)Breakpoint.ra$allBreakpoints().get(urlActiveWorkspace);
                    if (workspaceBreakpoints != null) {
                        refactorableBreakpoints.addAll(workspaceBreakpoints);
                    }
                    if ((globalBreakpoints = (List)Breakpoint.ra$allBreakpoints().get(Breakpoint.ra$GlobalBreakpointsKey())) != null) {
                        refactorableBreakpoints.addAll(globalBreakpoints);
                    }
                }
            }
            return refactorableBreakpoints;
        }

        private String getFullMethodName(JavaMethod jm, String oldClassDotMethod) {
            String fullMethodName = jm.getReturnType().getRawName() + " " + oldClassDotMethod + "(";
            JavaType[] args = jm.getParameterTypes();
            int i = 0;
            while (i < args.length) {
                fullMethodName = fullMethodName + args[i].getRawName();
                if (i + 1 < args.length) {
                    fullMethodName = fullMethodName + ", ";
                }
                ++i;
            }
            fullMethodName = fullMethodName + ")";
            return fullMethodName;
        }

        boolean refactorRenameMethod_chooseUrls(Project project, RenameMethodCriteria crit) {
            HashSet<Breakpoint> affectedBreakpoints = new HashSet<Breakpoint>();
            this.projectToAffectedBreakpoints.put(project, affectedBreakpoints);
            Set breakpoints = this.getRefactorableBreakpoints(project);
            JavaMethod jm = crit.getMethodDescription().getJavaMethod((JavaProvider)JavaManager.getJavaManager((Project)project));
            this.className = jm.getOwningClass().getQualifiedName();
            this.oldMethodName = jm.getName();
            String oldClassDotMethod = this.className + '.' + this.oldMethodName;
            this.oldFullMethodName = this.getFullMethodName(jm, oldClassDotMethod);
            for (Breakpoint bp : breakpoints) {
                switch (bp.getType()) {
                    case 1: {
                        String bpClassDotMethod = bp.getMethod();
                        if (!bpClassDotMethod.equals(oldClassDotMethod)) break;
                        affectedBreakpoints.add(bp);
                        break;
                    }
                    case 7: {
                        String bpFullMethodName = bp.getMethod();
                        if (!bpFullMethodName.equals(this.oldFullMethodName)) break;
                        affectedBreakpoints.add(bp);
                        break;
                    }
                }
            }
            return affectedBreakpoints.isEmpty() ^ true;
        }

        boolean refactorRenameField_chooseUrls(Project project, RenameFieldCriteria crit) {
            HashSet<Breakpoint> affectedBreakpoints = new HashSet<Breakpoint>();
            this.projectToAffectedBreakpoints.put(project, affectedBreakpoints);
            Set breakpoints = this.getRefactorableBreakpoints(project);
            JavaField jf = crit.getFieldDescription().getJavaField((JavaProvider)JavaManager.getJavaManager((Project)project));
            this.className = jf.getOwningClass().getQualifiedName();
            this.oldFieldName = jf.getName();
            String oldClassDotGetter = null;
            MethodDescription getterDescription = crit.getGetterDescription();
            if (getterDescription != null) {
                JavaMethod jm = getterDescription.getJavaMethod((JavaProvider)JavaManager.getJavaManager((Project)project));
                this.oldGetterName = jm.getName();
                oldClassDotGetter = this.className + '.' + this.oldGetterName;
                this.oldFullGetterName = this.getFullMethodName(jm, oldClassDotGetter);
            }
            String oldClassDotSetter = null;
            MethodDescription setterDescription = crit.getSetterDescription();
            if (setterDescription != null) {
                JavaMethod jm = setterDescription.getJavaMethod((JavaProvider)JavaManager.getJavaManager((Project)project));
                this.oldSetterName = jm.getName();
                oldClassDotSetter = this.className + '.' + this.oldSetterName;
                this.oldFullSetterName = this.getFullMethodName(jm, oldClassDotSetter);
            }
            block5: for (Breakpoint bp : breakpoints) {
                switch (bp.getType()) {
                    case 6: {
                        String bpClassName = bp.getClassName();
                        String bpFieldName = bp.getFieldName();
                        if (!bpClassName.equals(this.className) || !bpFieldName.equals(this.oldFieldName)) continue block5;
                        affectedBreakpoints.add(bp);
                        break;
                    }
                    case 1: {
                        String bpClassDotMethod = bp.getMethod();
                        if (this.oldGetterName != null && bpClassDotMethod.equals(oldClassDotGetter)) {
                            affectedBreakpoints.add(bp);
                            break;
                        }
                        if (this.oldSetterName == null || !bpClassDotMethod.equals(oldClassDotSetter)) continue block5;
                        affectedBreakpoints.add(bp);
                        break;
                    }
                    case 7: {
                        String bpFullMethodName = bp.getMethod();
                        if (this.oldGetterName != null && bpFullMethodName.equals(this.oldFullGetterName)) {
                            affectedBreakpoints.add(bp);
                            break;
                        }
                        if (this.oldSetterName == null || !bpFullMethodName.equals(this.oldFullSetterName)) continue block5;
                        affectedBreakpoints.add(bp);
                        break;
                    }
                }
            }
            return affectedBreakpoints.isEmpty() ^ true;
        }

        boolean refactorMoveClasses_chooseUrls(Project project, MoveClassesCriteria crit) {
            HashSet<Breakpoint> affectedBreakpoints = new HashSet<Breakpoint>();
            this.projectToAffectedBreakpoints.put(project, affectedBreakpoints);
            Set breakpoints = this.getRefactorableBreakpoints(project);
            List<URL> oldUrls = Arrays.asList(crit.getOldUrls());
            Workspace workspace = Ide.getActiveWorkspace();
            block9: for (Breakpoint bp : breakpoints) {
                switch (bp.getType()) {
                    case 0: {
                        String bpPackage = bp.getPackage();
                        String bpFile = bp.getFile();
                        URL bpUrl = Source.findSourceFile(workspace, project, bpPackage, bpFile);
                        if (bpUrl == null || !oldUrls.contains(bpUrl)) continue block9;
                        affectedBreakpoints.add(bp);
                        this.bpToUrl.put(bp, bpUrl);
                        break;
                    }
                    case 1: {
                        String bpClassName;
                        String bpClassDotMethod = bp.getMethod();
                        int iLastDot = bpClassDotMethod.lastIndexOf(46);
                        if (iLastDot == -1 || !crit.isMovedClass(bpClassName = bpClassDotMethod.substring(0, iLastDot))) continue block9;
                        affectedBreakpoints.add(bp);
                        break;
                    }
                    case 7: {
                        String bpClassName;
                        int iDot;
                        int iClass;
                        String bpFullMethodName = bp.getMethod();
                        int iSignature = bpFullMethodName.indexOf("(");
                        if (iSignature == -1 || (iClass = bpFullMethodName.lastIndexOf(" ", iSignature) + 1) == -1 || (iDot = bpFullMethodName.lastIndexOf(".", iSignature)) == -1 || !crit.isMovedClass(bpClassName = bpFullMethodName.substring(iClass, iDot))) continue block9;
                        affectedBreakpoints.add(bp);
                        break;
                    }
                    case 2: {
                        String bpExceptionClassName = bp.getException();
                        if (!crit.isMovedClass(bpExceptionClassName)) break;
                        affectedBreakpoints.add(bp);
                        break;
                    }
                    case 4: {
                        String bpClassName = bp.getClassName();
                        if (!crit.isMovedClass(bpClassName)) break;
                        affectedBreakpoints.add(bp);
                        break;
                    }
                    case 5: {
                        URL bpUrl = bp.getURL();
                        if (!oldUrls.contains(bpUrl)) break;
                        affectedBreakpoints.add(bp);
                        break;
                    }
                    case 6: {
                        String bpClassName = bp.getClassName();
                        if (!crit.isMovedClass(bpClassName)) break;
                        affectedBreakpoints.add(bp);
                        break;
                    }
                }
            }
            return affectedBreakpoints.isEmpty() ^ true;
        }

        private void $init$() {
            this.REFACTOR_BREAKPOINT_CMD_PREFIX = "DebugRefactorBreakpoint";
        }

        boolean refactorRenameMethod_doChanges(Project project, RenameMethodCriteria crit) {
            Set affectedBreakpoints = (Set)this.projectToAffectedBreakpoints.get(project);
            String oldClassDotMethod = this.className + '.' + this.oldMethodName;
            String newMethodName = crit.getMemberNameAfter();
            String newClassDotMethod = this.className + '.' + newMethodName;
            int iSignature = this.oldFullMethodName.indexOf("(");
            int iMethod = this.oldFullMethodName.lastIndexOf(".", iSignature) + 1;
            String newFullMethodName = this.oldFullMethodName.substring(0, iMethod) + newMethodName + this.oldFullMethodName.substring(iSignature);
            for (Breakpoint bp : affectedBreakpoints) {
                1 command = new 1(this, this, bp, oldClassDotMethod, newClassDotMethod, newFullMethodName);
                try {
                    CommandProcessor.getInstance().invoke((Command)command);
                }
                catch (Exception e) {
                    Assert.printStackTrace((Throwable)e);
                }
            }
            return true;
        }

        boolean refactorRenameField_doChanges(Project project, RenameFieldCriteria crit) {
            Set affectedBreakpoints = (Set)this.projectToAffectedBreakpoints.get(project);
            String newFieldName = crit.getMemberNameAfter();
            String oldClassDotGetter = this.className + '.' + this.oldGetterName;
            String newGetterName = crit.getGetterNameAfter();
            String newClassDotGetter = this.className + '.' + newGetterName;
            int iSignatureG = this.oldFullGetterName.indexOf("(");
            int iMethodG = this.oldFullGetterName.lastIndexOf(".", iSignatureG) + 1;
            String newFullGetterName = this.oldFullGetterName.substring(0, iMethodG) + newGetterName + this.oldFullGetterName.substring(iSignatureG);
            String oldClassDotSetter = this.className + '.' + this.oldSetterName;
            String newSetterName = crit.getSetterNameAfter();
            String newClassDotSetter = this.className + '.' + newSetterName;
            int iSignatureS = this.oldFullSetterName.indexOf("(");
            int iMethodS = this.oldFullSetterName.lastIndexOf(".", iSignatureS) + 1;
            String newFullSetterName = this.oldFullSetterName.substring(0, iMethodS) + newSetterName + this.oldFullSetterName.substring(iSignatureS);
            for (Breakpoint bp : affectedBreakpoints) {
                2 command = new 2(this, this, bp, newFieldName, oldClassDotGetter, newClassDotGetter, oldClassDotSetter, newClassDotSetter, newFullGetterName, newFullSetterName);
                try {
                    CommandProcessor.getInstance().invoke((Command)command);
                }
                catch (Exception e) {
                    Assert.printStackTrace((Throwable)e);
                }
            }
            return true;
        }

        boolean refactorMoveClasses_doChanges(Project project, MoveClassesCriteria crit) {
            Set affectedBreakpoints = (Set)this.projectToAffectedBreakpoints.get(project);
            List<URL> oldUrls = Arrays.asList(crit.getOldUrls());
            List<URL> newUrls = Arrays.asList(crit.getNewUrls());
            List<String> oldPackages = Arrays.asList(crit.getOldPackageNames());
            List<String> newPackages = Arrays.asList(crit.getNewPackageNames());
            List<String> oldClassNames = Arrays.asList(crit.getFqOldClassesNames());
            List<String> newClassNames = Arrays.asList(crit.getFqNewClassesNames());
            Workspace workspace = Ide.getActiveWorkspace();
            for (Breakpoint bp : affectedBreakpoints) {
                3 command = new 3(this, this, bp, oldUrls, newUrls, project, oldClassNames, newClassNames);
                try {
                    CommandProcessor.getInstance().invoke((Command)command);
                }
                catch (Exception e) {
                    Assert.printStackTrace((Throwable)e);
                }
            }
            return true;
        }

        static int ra$countRefactorBreakpointCommands(RefactoringOperation refactoringOperation) {
            return refactoringOperation.countRefactorBreakpointCommands;
        }

        static void wa$countRefactorBreakpointCommands(RefactoringOperation refactoringOperation, int n) {
            refactoringOperation.countRefactorBreakpointCommands = n;
        }

        static Map ra$bpToUrl(RefactoringOperation refactoringOperation) {
            return refactoringOperation.bpToUrl;
        }

        static String ra$className(RefactoringOperation refactoringOperation) {
            return refactoringOperation.className;
        }

        static String ra$oldFieldName(RefactoringOperation refactoringOperation) {
            return refactoringOperation.oldFieldName;
        }

        static String ra$oldGetterName(RefactoringOperation refactoringOperation) {
            return refactoringOperation.oldGetterName;
        }

        static String ra$oldSetterName(RefactoringOperation refactoringOperation) {
            return refactoringOperation.oldSetterName;
        }

        static String ra$oldFullGetterName(RefactoringOperation refactoringOperation) {
            return refactoringOperation.oldFullGetterName;
        }

        static String ra$oldFullSetterName(RefactoringOperation refactoringOperation) {
            return refactoringOperation.oldFullSetterName;
        }

        static String ra$oldFullMethodName(RefactoringOperation refactoringOperation) {
            return refactoringOperation.oldFullMethodName;
        }

        abstract class RefactorBreakpointCommand
        extends Command {
            protected Breakpoint _bp;

            private RefactorBreakpointCommand(Breakpoint bp) {
                StringBuilder stringBuilder = new StringBuilder().append("DebugRefactorBreakpoint");
                RefactoringOperation refactoringOperation2 = RefactoringOperation.this;
                int n = RefactoringOperation.ra$countRefactorBreakpointCommands(refactoringOperation2);
                RefactoringOperation.wa$countRefactorBreakpointCommands(refactoringOperation2, n + 1);
                super(Ide.findOrCreateCmdID((String)stringBuilder.append(n).toString()), 3, DbgArb.getString(795));
                this._bp = bp;
                this.setContext(Context.newIdeContext());
            }

            RefactorBreakpointCommand(Breakpoint breakpoint, 3 var3_3) {
                this(breakpoint);
            }

            RefactorBreakpointCommand(Breakpoint breakpoint, 2 var3_3) {
                this(breakpoint);
            }

            RefactorBreakpointCommand(Breakpoint breakpoint, 1 var3_3) {
                this(breakpoint);
            }
        }

        final class 1
        extends RefactorBreakpointCommand {
            private final /* synthetic */ String v$oldClassDotMethod;
            private final /* synthetic */ String v$newClassDotMethod;
            private final /* synthetic */ String v$newFullMethodName;
            final /* synthetic */ RefactoringOperation this$0;

            public int doit() throws Exception {
                switch (this._bp.getType()) {
                    case 1: {
                        String bpClassDotMethod = this._bp.getMethod();
                        if (!bpClassDotMethod.equals(this.v$oldClassDotMethod)) break;
                        this._bp.setMethod(this.v$newClassDotMethod);
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        break;
                    }
                    case 7: {
                        String bpFullMethodName = this._bp.getMethod();
                        if (!bpFullMethodName.equals(RefactoringOperation.ra$oldFullMethodName(this.this$0))) break;
                        this._bp.setMethodOffset(this.v$newFullMethodName, this._bp.getOffset());
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        break;
                    }
                }
                return 0;
            }

            public int undo() throws Exception {
                switch (this._bp.getType()) {
                    case 1: {
                        String bpClassDotMethod = this._bp.getMethod();
                        if (!bpClassDotMethod.equals(this.v$newClassDotMethod)) break;
                        this._bp.setMethod(this.v$oldClassDotMethod);
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        break;
                    }
                    case 7: {
                        String bpFullMethodName = this._bp.getMethod();
                        if (!bpFullMethodName.equals(this.v$newFullMethodName)) break;
                        this._bp.setMethodOffset(RefactoringOperation.ra$oldFullMethodName(this.this$0), this._bp.getOffset());
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        break;
                    }
                }
                return 0;
            }

            public 1(RefactoringOperation refactoringOperation, RefactoringOperation refactoringOperation2, Breakpoint breakpoint, String string, String string2, String string3) {
                this.v$newFullMethodName = string3;
                this.v$newClassDotMethod = string2;
                this.v$oldClassDotMethod = string;
                this.this$0 = refactoringOperation;
                super(breakpoint, (1)null);
            }
        }

        final class 2
        extends RefactorBreakpointCommand {
            private final /* synthetic */ String v$newFieldName;
            private final /* synthetic */ String v$oldClassDotGetter;
            private final /* synthetic */ String v$newClassDotGetter;
            private final /* synthetic */ String v$oldClassDotSetter;
            private final /* synthetic */ String v$newClassDotSetter;
            private final /* synthetic */ String v$newFullGetterName;
            private final /* synthetic */ String v$newFullSetterName;
            final /* synthetic */ RefactoringOperation this$0;

            public int doit() throws Exception {
                switch (this._bp.getType()) {
                    case 6: {
                        String bpClassName = this._bp.getClassName();
                        String bpFieldName = this._bp.getFieldName();
                        if (!bpClassName.equals(RefactoringOperation.ra$className(this.this$0)) || !bpFieldName.equals(RefactoringOperation.ra$oldFieldName(this.this$0))) break;
                        this._bp.setWatchpoint(bpClassName, this.v$newFieldName, this._bp.isAccess(), this._bp.isModify());
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        break;
                    }
                    case 1: {
                        String bpClassDotMethod = this._bp.getMethod();
                        if (RefactoringOperation.ra$oldGetterName(this.this$0) != null && bpClassDotMethod.equals(this.v$oldClassDotGetter)) {
                            this._bp.setMethod(this.v$newClassDotGetter);
                            JDebugger.getInstance().updateBreakpointsWindowStatus();
                            break;
                        }
                        if (RefactoringOperation.ra$oldSetterName(this.this$0) == null || !bpClassDotMethod.equals(this.v$oldClassDotSetter)) break;
                        this._bp.setMethod(this.v$newClassDotSetter);
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        break;
                    }
                    case 7: {
                        String bpFullMethodName = this._bp.getMethod();
                        if (RefactoringOperation.ra$oldGetterName(this.this$0) != null && bpFullMethodName.equals(RefactoringOperation.ra$oldFullGetterName(this.this$0))) {
                            this._bp.setMethodOffset(this.v$newFullGetterName, this._bp.getOffset());
                            JDebugger.getInstance().updateBreakpointsWindowStatus();
                            break;
                        }
                        if (RefactoringOperation.ra$oldSetterName(this.this$0) == null || !bpFullMethodName.equals(RefactoringOperation.ra$oldFullSetterName(this.this$0))) break;
                        this._bp.setMethodOffset(this.v$newFullSetterName, this._bp.getOffset());
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        break;
                    }
                }
                return 0;
            }

            public int undo() throws Exception {
                switch (this._bp.getType()) {
                    case 6: {
                        String bpClassName = this._bp.getClassName();
                        String bpFieldName = this._bp.getFieldName();
                        if (!bpClassName.equals(RefactoringOperation.ra$className(this.this$0)) || !bpFieldName.equals(this.v$newFieldName)) break;
                        this._bp.setWatchpoint(bpClassName, RefactoringOperation.ra$oldFieldName(this.this$0), this._bp.isAccess(), this._bp.isModify());
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        break;
                    }
                    case 1: {
                        String bpClassDotMethod = this._bp.getMethod();
                        if (RefactoringOperation.ra$oldGetterName(this.this$0) != null && bpClassDotMethod.equals(this.v$newClassDotGetter)) {
                            this._bp.setMethod(this.v$oldClassDotGetter);
                            JDebugger.getInstance().updateBreakpointsWindowStatus();
                            break;
                        }
                        if (RefactoringOperation.ra$oldSetterName(this.this$0) == null || !bpClassDotMethod.equals(this.v$newClassDotSetter)) break;
                        this._bp.setMethod(this.v$oldClassDotSetter);
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        break;
                    }
                    case 7: {
                        String bpFullMethodName = this._bp.getMethod();
                        if (RefactoringOperation.ra$oldGetterName(this.this$0) != null && bpFullMethodName.equals(this.v$newFullGetterName)) {
                            this._bp.setMethodOffset(RefactoringOperation.ra$oldFullGetterName(this.this$0), this._bp.getOffset());
                            JDebugger.getInstance().updateBreakpointsWindowStatus();
                            break;
                        }
                        if (RefactoringOperation.ra$oldSetterName(this.this$0) == null || !bpFullMethodName.equals(this.v$newFullSetterName)) break;
                        this._bp.setMethodOffset(RefactoringOperation.ra$oldFullSetterName(this.this$0), this._bp.getOffset());
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        break;
                    }
                }
                return 0;
            }

            public 2(RefactoringOperation refactoringOperation, RefactoringOperation refactoringOperation2, Breakpoint breakpoint, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
                this.v$newFullSetterName = string7;
                this.v$newFullGetterName = string6;
                this.v$newClassDotSetter = string5;
                this.v$oldClassDotSetter = string4;
                this.v$newClassDotGetter = string3;
                this.v$oldClassDotGetter = string2;
                this.v$newFieldName = string;
                this.this$0 = refactoringOperation;
                super(breakpoint, (2)null);
            }
        }

        final class 3
        extends RefactorBreakpointCommand {
            String savedOldPackage;
            String savedOldFile;
            String savedNewPackage;
            String savedNewFile;
            private final /* synthetic */ List v$oldUrls;
            private final /* synthetic */ List v$newUrls;
            private final /* synthetic */ Project v$project;
            private final /* synthetic */ List v$oldClassNames;
            private final /* synthetic */ List v$newClassNames;
            final /* synthetic */ RefactoringOperation this$0;

            public int doit() throws Exception {
                switch (this._bp.getType()) {
                    case 0: {
                        int index;
                        String bpPackage = this._bp.getPackage();
                        String bpFile = this._bp.getFile();
                        URL bpUrl = (URL)RefactoringOperation.ra$bpToUrl(this.this$0).get(this._bp);
                        if (bpUrl == null || (index = this.v$oldUrls.indexOf(bpUrl)) == -1) break;
                        URL newUrl = (URL)this.v$newUrls.get(index);
                        URL newParentUrl = URLFileSystem.getParent((URL)newUrl);
                        URLPath sourcePath = PathsConfiguration.getInstance((Project)this.v$project).getProjectSourcePath();
                        String relativePath = sourcePath.toRelativePath(newParentUrl);
                        if (relativePath == null) break;
                        String newPackage = relativePath.replace('/', '.');
                        if (newPackage.endsWith(".")) {
                            newPackage = newPackage.substring(0, newPackage.length() - 1);
                        }
                        String newFile = URLFileSystem.getFileName((URL)newUrl);
                        this._bp.setPackageFileLine(newPackage, newFile, this._bp.getLine());
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        this.savedOldPackage = bpPackage;
                        this.savedOldFile = bpFile;
                        this.savedNewPackage = newPackage;
                        this.savedNewFile = newFile;
                        break;
                    }
                    case 1: {
                        String bpClassName;
                        int index;
                        String bpClassDotMethod = this._bp.getMethod();
                        int iLastDot = bpClassDotMethod.lastIndexOf(46);
                        if (iLastDot == -1 || (index = this.v$oldClassNames.indexOf(bpClassName = bpClassDotMethod.substring(0, iLastDot))) == -1) break;
                        String newClassName = (String)this.v$newClassNames.get(index);
                        String newClassDotMethod = newClassName + '.' + bpClassDotMethod.substring(iLastDot + 1);
                        this._bp.setMethod(newClassDotMethod);
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        break;
                    }
                    case 7: {
                        String bpFullMethodName = this._bp.getMethod();
                        int iSignature = bpFullMethodName.indexOf("(");
                        int iClass = bpFullMethodName.lastIndexOf(" ", iSignature) + 1;
                        int iDot = bpFullMethodName.lastIndexOf(".", iSignature);
                        String bpClassName = bpFullMethodName.substring(iClass, iDot);
                        int index = this.v$oldClassNames.indexOf(bpClassName);
                        if (index == -1) break;
                        String newClassName = (String)this.v$newClassNames.get(index);
                        String newFullMethodName = bpFullMethodName.substring(0, iClass) + newClassName + bpFullMethodName.substring(iDot);
                        this._bp.setMethodOffset(newFullMethodName, this._bp.getOffset());
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        break;
                    }
                    case 2: {
                        String bpExceptionClassName = this._bp.getException();
                        int index = this.v$oldClassNames.indexOf(bpExceptionClassName);
                        if (index == -1) break;
                        String newClassName = (String)this.v$newClassNames.get(index);
                        this._bp.setException(newClassName, this._bp.isCaught(), this._bp.isUncaught());
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        break;
                    }
                    case 4: {
                        String bpClassName = this._bp.getClassName();
                        int index = this.v$oldClassNames.indexOf(bpClassName);
                        if (index == -1) break;
                        String newClassName = (String)this.v$newClassNames.get(index);
                        this._bp.setClassName(newClassName);
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        break;
                    }
                    case 5: {
                        URL bpUrl = this._bp.getURL();
                        int index = this.v$oldUrls.indexOf(bpUrl);
                        if (index == -1) break;
                        URL newUrl = (URL)this.v$newUrls.get(index);
                        this._bp.setURLLine(newUrl, this._bp.getLine());
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        break;
                    }
                    case 6: {
                        String bpClassName = this._bp.getClassName();
                        int index = this.v$oldClassNames.indexOf(bpClassName);
                        if (index == -1) break;
                        String newClassName = (String)this.v$newClassNames.get(index);
                        this._bp.setWatchpoint(newClassName, this._bp.getFieldName(), this._bp.isAccess(), this._bp.isModify());
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        break;
                    }
                }
                return 0;
            }

            public int undo() throws Exception {
                switch (this._bp.getType()) {
                    case 0: {
                        String bpPackage = this._bp.getPackage();
                        String bpFile = this._bp.getFile();
                        if (bpPackage != this.savedNewPackage || bpFile != this.savedNewFile) break;
                        this._bp.setPackageFileLine(this.savedOldPackage, this.savedOldFile, this._bp.getLine());
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        break;
                    }
                    case 1: {
                        String bpClassName;
                        int index;
                        String bpClassDotMethod = this._bp.getMethod();
                        int iLastDot = bpClassDotMethod.lastIndexOf(46);
                        if (iLastDot == -1 || (index = this.v$newClassNames.indexOf(bpClassName = bpClassDotMethod.substring(0, iLastDot))) == -1) break;
                        String oldClassName = (String)this.v$oldClassNames.get(index);
                        String oldClassDotMethod = oldClassName + '.' + bpClassDotMethod.substring(iLastDot + 1);
                        this._bp.setMethod(oldClassDotMethod);
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        break;
                    }
                    case 7: {
                        String bpFullMethodName = this._bp.getMethod();
                        int iSignature = bpFullMethodName.indexOf("(");
                        int iClass = bpFullMethodName.lastIndexOf(" ", iSignature) + 1;
                        int iDot = bpFullMethodName.lastIndexOf(".", iSignature);
                        String bpClassName = bpFullMethodName.substring(iClass, iDot);
                        int index = this.v$newClassNames.indexOf(bpClassName);
                        if (index == -1) break;
                        String oldClassName = (String)this.v$oldClassNames.get(index);
                        String oldFullMethodName = bpFullMethodName.substring(0, iClass) + oldClassName + bpFullMethodName.substring(iDot);
                        this._bp.setMethodOffset(oldFullMethodName, this._bp.getOffset());
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        break;
                    }
                    case 2: {
                        String bpExceptionClassName = this._bp.getException();
                        int index = this.v$newClassNames.indexOf(bpExceptionClassName);
                        if (index == -1) break;
                        String oldClassName = (String)this.v$oldClassNames.get(index);
                        this._bp.setException(oldClassName, this._bp.isCaught(), this._bp.isUncaught());
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        break;
                    }
                    case 4: {
                        String bpClassName = this._bp.getClassName();
                        int index = this.v$newClassNames.indexOf(bpClassName);
                        if (index == -1) break;
                        String oldClassName = (String)this.v$oldClassNames.get(index);
                        this._bp.setClassName(oldClassName);
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        break;
                    }
                    case 5: {
                        URL bpUrl = this._bp.getURL();
                        int index = this.v$newUrls.indexOf(bpUrl);
                        if (index == -1) break;
                        URL oldUrl = (URL)this.v$oldUrls.get(index);
                        this._bp.setURLLine(oldUrl, this._bp.getLine());
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        break;
                    }
                    case 6: {
                        String bpClassName = this._bp.getClassName();
                        int index = this.v$newClassNames.indexOf(bpClassName);
                        if (index == -1) break;
                        String oldClassName = (String)this.v$oldClassNames.get(index);
                        this._bp.setWatchpoint(oldClassName, this._bp.getFieldName(), this._bp.isAccess(), this._bp.isModify());
                        JDebugger.getInstance().updateBreakpointsWindowStatus();
                        break;
                    }
                }
                return 0;
            }

            public 3(RefactoringOperation refactoringOperation, RefactoringOperation refactoringOperation2, Breakpoint breakpoint, List list, List list2, Project project, List list3, List list4) {
                this.v$newClassNames = list4;
                this.v$oldClassNames = list3;
                this.v$project = project;
                this.v$newUrls = list2;
                this.v$oldUrls = list;
                this.this$0 = refactoringOperation;
                super(breakpoint, (3)null);
            }
        }
    }
}

