/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.Ide;
import oracle.ide.util.HistoryList;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.runner.debug.Breakpoint;
import oracle.jdevimpl.runner.debug.BreakpointOptionsDialog;
import oracle.jdevimpl.runner.debug.BreakpointsWindowSettings;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.Evaluator;

final class BreakpointActionsPanel
extends JPanel
implements ActionListener,
ItemListener,
DocumentListener {
    private BreakpointOptionsDialog bpDialog;
    private JCheckBox haltCheckBox;
    private JCheckBox beepCheckBox;
    private JCheckBox logCheckBox;
    private JLabel logTagLabel;
    private HistoryList logTagHistoryList;
    private JComboBox logTagComboBox;
    private JTextField logTagEditor;
    private JLabel logExprLabel;
    private HistoryList logExprHistoryList;
    private JComboBox logExprComboBox;
    private JTextField logExprEditor;
    private JCheckBox logStackCheckBox;
    private JCheckBox enableOtherCheckBox;
    private JComboBox enableOtherComboBox;
    private JTextField enableOtherEditor;
    private JCheckBox disableOtherCheckBox;
    private JComboBox disableOtherComboBox;
    private JTextField disableOtherEditor;
    private JCheckBox saveActionsCheckBox;
    private static final String logTagHistoryName = "DebugBreakpointLogTag";
    private static final String logExprHistoryName = "DebugBreakpointLogExpr";

    BreakpointActionsPanel(String[] groupNames, boolean allowSave, BreakpointOptionsDialog bpDialog) {
        super(new GridBagLayout());
        this.bpDialog = bpDialog;
        this.haltCheckBox = new JCheckBox();
        this.beepCheckBox = new JCheckBox();
        this.logCheckBox = new JCheckBox();
        this.logTagLabel = new JLabel();
        this.logTagHistoryList = Ide.loadHistoryList((String)logTagHistoryName);
        this.logTagComboBox = new JComboBox<String>(this.logTagHistoryList.getHistory());
        this.logTagComboBox.setEditable(true);
        this.logTagEditor = (JTextField)this.logTagComboBox.getEditor().getEditorComponent();
        this.logExprLabel = new JLabel();
        this.logExprHistoryList = Ide.loadHistoryList((String)logExprHistoryName);
        this.logExprComboBox = new JComboBox<String>(this.logExprHistoryList.getHistory());
        this.logExprComboBox.setEditable(true);
        this.logExprEditor = (JTextField)this.logExprComboBox.getEditor().getEditorComponent();
        this.logStackCheckBox = new JCheckBox();
        this.enableOtherCheckBox = new JCheckBox();
        if (groupNames != null) {
            this.enableOtherComboBox = new JComboBox<String>(groupNames);
            this.enableOtherComboBox.setEditable(true);
            this.enableOtherEditor = (JTextField)this.enableOtherComboBox.getEditor().getEditorComponent();
        } else {
            this.enableOtherEditor = new JTextField();
        }
        this.disableOtherCheckBox = new JCheckBox();
        if (groupNames != null) {
            this.disableOtherComboBox = new JComboBox<String>(groupNames);
            this.disableOtherComboBox.setEditable(true);
            this.disableOtherEditor = (JTextField)this.disableOtherComboBox.getEditor().getEditorComponent();
        } else {
            this.disableOtherEditor = new JTextField();
        }
        this.saveActionsCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.haltCheckBox, (String)DbgArb.getString(227));
        ResourceUtils.resButton((AbstractButton)this.beepCheckBox, (String)DbgArb.getString(316));
        ResourceUtils.resButton((AbstractButton)this.logCheckBox, (String)DbgArb.getString(77));
        ResourceUtils.resLabel((JLabel)this.logTagLabel, (Component)this.logTagEditor, (String)DbgArb.getString(35));
        ResourceUtils.resLabel((JLabel)this.logExprLabel, (Component)this.logExprEditor, (String)DbgArb.getString(122));
        ResourceUtils.resButton((AbstractButton)this.logStackCheckBox, (String)DbgArb.getString(797));
        ResourceUtils.resButton((AbstractButton)this.enableOtherCheckBox, (String)DbgArb.getString(620));
        this.enableOtherEditor.getAccessibleContext().setAccessibleName(this.enableOtherCheckBox.getText());
        ResourceUtils.resButton((AbstractButton)this.disableOtherCheckBox, (String)DbgArb.getString(260));
        this.disableOtherEditor.getAccessibleContext().setAccessibleName(this.disableOtherCheckBox.getText());
        ResourceUtils.resButton((AbstractButton)this.saveActionsCheckBox, (String)DbgArb.getString(521));
        int y = 0;
        this.add((Component)this.haltCheckBox, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.beepCheckBox, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.logCheckBox, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.logTagLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 25, 0, 0), 0, 0));
        this.add((Component)this.logTagComboBox, new GridBagConstraints(1, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.logExprLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 25, 0, 0), 0, 0));
        this.add((Component)this.logExprComboBox, new GridBagConstraints(1, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.logStackCheckBox, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 25, 0, 5), 0, 0));
        this.add((Component)this.enableOtherCheckBox, new GridBagConstraints(0, y, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        if (this.enableOtherComboBox != null) {
            this.add((Component)this.enableOtherComboBox, new GridBagConstraints(2, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        } else {
            this.add((Component)this.enableOtherEditor, new GridBagConstraints(2, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        }
        this.add((Component)this.disableOtherCheckBox, new GridBagConstraints(0, y, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        if (this.disableOtherComboBox != null) {
            this.add((Component)this.disableOtherComboBox, new GridBagConstraints(2, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        } else {
            this.add((Component)this.disableOtherEditor, new GridBagConstraints(2, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        }
        if (allowSave) {
            this.add((Component)this.saveActionsCheckBox, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        }
        this.add((Component)new JLabel(), new GridBagConstraints(0, y, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.logCheckBox.addItemListener(this);
        this.logTagComboBox.addActionListener(this);
        IdeUtil.addComboBoxDocumentListener((JComboBox)this.logTagComboBox, (DocumentListener)this);
        this.logExprComboBox.addActionListener(this);
        IdeUtil.addComboBoxDocumentListener((JComboBox)this.logExprComboBox, (DocumentListener)this);
        this.enableOtherCheckBox.addItemListener(this);
        if (this.enableOtherComboBox != null) {
            this.enableOtherComboBox.addActionListener(this);
            IdeUtil.addComboBoxDocumentListener((JComboBox)this.enableOtherComboBox, (DocumentListener)this);
        }
        this.disableOtherCheckBox.addItemListener(this);
        if (this.disableOtherComboBox != null) {
            this.disableOtherComboBox.addActionListener(this);
            IdeUtil.addComboBoxDocumentListener((JComboBox)this.disableOtherComboBox, (DocumentListener)this);
        }
    }

    void loadFrom(Breakpoint bp, BreakpointsWindowSettings bpSettings) {
        String disableOther;
        String enableOther;
        boolean logStack;
        String logExpr;
        String logTag;
        boolean log;
        boolean beep;
        boolean halt;
        if (bp != null) {
            halt = bp.isActionHalt();
            beep = bp.isActionBeep();
            log = bp.isActionLog();
            logTag = bp.getActionLogTag();
            logExpr = bp.getActionLogExpression();
            logStack = bp.isActionLogStack();
            enableOther = bp.getActionEnableOther();
            disableOther = bp.getActionDisableOther();
        } else {
            halt = bpSettings.getDefaultActionHalt();
            beep = bpSettings.getDefaultActionBeep();
            log = bpSettings.getDefaultActionLog();
            logTag = bpSettings.getDefaultActionLogTag();
            logExpr = bpSettings.getDefaultActionLogExpr();
            logStack = bpSettings.getDefaultActionLogStack();
            enableOther = bpSettings.getDefaultActionEnableOther();
            disableOther = bpSettings.getDefaultActionDisableOther();
        }
        this.haltCheckBox.setSelected(halt);
        this.beepCheckBox.setSelected(beep);
        this.logCheckBox.setSelected(log);
        this.logTagLabel.setEnabled(log);
        IdeUtil.comboBoxSelectItem((JComboBox)this.logTagComboBox, (Object)logTag);
        this.logTagComboBox.setEnabled(log);
        this.logExprLabel.setEnabled(log);
        IdeUtil.comboBoxSelectItem((JComboBox)this.logExprComboBox, (Object)logExpr);
        this.logExprComboBox.setEnabled(log);
        this.logStackCheckBox.setEnabled(log);
        this.logStackCheckBox.setSelected(logStack);
        this.enableOtherCheckBox.setSelected(enableOther.length() > 0);
        if (this.enableOtherComboBox != null) {
            IdeUtil.comboBoxSelectItem((JComboBox)this.enableOtherComboBox, (Object)enableOther);
            this.enableOtherComboBox.setEnabled(this.enableOtherCheckBox.isSelected());
        } else {
            this.enableOtherEditor.setText(enableOther);
            this.enableOtherEditor.setEnabled(this.enableOtherCheckBox.isSelected());
        }
        this.disableOtherCheckBox.setSelected(disableOther.length() > 0);
        if (this.disableOtherComboBox != null) {
            IdeUtil.comboBoxSelectItem((JComboBox)this.disableOtherComboBox, (Object)disableOther);
            this.disableOtherComboBox.setEnabled(this.disableOtherCheckBox.isSelected());
        } else {
            this.disableOtherEditor.setText(disableOther);
            this.disableOtherEditor.setEnabled(this.disableOtherCheckBox.isSelected());
        }
        if (bp != null && !bp.canEditBreakpointHitActions()) {
            this.haltCheckBox.setEnabled(false);
            this.beepCheckBox.setEnabled(false);
            this.logCheckBox.setEnabled(false);
            this.logTagComboBox.setEnabled(false);
            this.logExprComboBox.setEnabled(false);
            this.logStackCheckBox.setEnabled(false);
            this.enableOtherCheckBox.setEnabled(false);
            this.enableOtherComboBox.setEnabled(false);
            this.enableOtherComboBox.setEditable(false);
            this.enableOtherEditor.setEnabled(false);
            this.disableOtherCheckBox.setEnabled(false);
            this.disableOtherComboBox.setEnabled(false);
            this.disableOtherComboBox.setEditable(false);
            this.disableOtherEditor.setEnabled(false);
        }
    }

    void setLog(boolean log) {
        this.logCheckBox.setSelected(log);
    }

    String anythingInvalid() {
        String exp = this.logExprEditor.getText();
        if (exp.length() > 0 && !Evaluator.validate(exp)) {
            return DbgArb.getString(128);
        }
        if (this.enableOtherCheckBox.isSelected() && this.enableOtherEditor.getText().length() == 0) {
            return DbgArb.getString(717);
        }
        if (this.disableOtherCheckBox.isSelected() && this.disableOtherEditor.getText().length() == 0) {
            return DbgArb.getString(119);
        }
        return null;
    }

    void commitTo(Breakpoint bp, BreakpointsWindowSettings bpSettings) {
        boolean halt = this.haltCheckBox.isSelected();
        boolean beep = this.beepCheckBox.isSelected();
        boolean log = this.logCheckBox.isSelected();
        String logTag = "";
        String logExpr = "";
        boolean logStack = false;
        if (log) {
            logTag = this.logTagHistoryList.comboBoxGetSelectedItem(this.logTagEditor);
            logExpr = this.logExprHistoryList.comboBoxGetSelectedItem(this.logExprEditor);
            logStack = this.logStackCheckBox.isSelected();
        }
        String enableOther = "";
        if (this.enableOtherCheckBox.isSelected()) {
            enableOther = this.enableOtherEditor.getText();
        }
        String disableOther = "";
        if (this.disableOtherCheckBox.isSelected()) {
            disableOther = this.disableOtherEditor.getText();
        }
        if (bp != null) {
            bp.setActionHalt(halt);
            bp.setActionBeep(beep);
            bp.setActionLog(log);
            bp.setActionLogTag(logTag);
            bp.setActionLogExpression(logExpr);
            bp.setActionLogStack(logStack);
            bp.setActionEnableOther(enableOther);
            bp.setActionDisableOther(disableOther);
        }
        if (bp == null || this.saveActionsCheckBox.isSelected()) {
            bpSettings.setDefaultActionHalt(halt);
            bpSettings.setDefaultActionBeep(beep);
            bpSettings.setDefaultActionLog(log);
            bpSettings.setDefaultActionLogTag(logTag);
            bpSettings.setDefaultActionLogExpr(logExpr);
            bpSettings.setDefaultActionLogStack(logStack);
            bpSettings.setDefaultActionEnableOther(enableOther);
            bpSettings.setDefaultActionDisableOther(disableOther);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.logTagComboBox) {
            this.logTagEditor.setText((String)this.logTagComboBox.getSelectedItem());
        } else if (source == this.logExprComboBox) {
            this.logExprEditor.setText((String)this.logExprComboBox.getSelectedItem());
        } else if (source == this.enableOtherComboBox && this.enableOtherComboBox != null) {
            this.enableOtherEditor.setText((String)this.enableOtherComboBox.getSelectedItem());
        } else if (source == this.disableOtherComboBox && this.disableOtherComboBox != null) {
            this.disableOtherEditor.setText((String)this.disableOtherComboBox.getSelectedItem());
        }
    }

    public void changedUpdate(DocumentEvent e) {
        if (this.bpDialog != null) {
            this.bpDialog.enableOk();
        }
    }

    public void insertUpdate(DocumentEvent e) {
        if (this.bpDialog != null) {
            this.bpDialog.enableOk();
        }
    }

    public void removeUpdate(DocumentEvent e) {
        if (this.bpDialog != null) {
            this.bpDialog.enableOk();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.logCheckBox) {
            boolean enabled = this.logCheckBox.isSelected();
            this.logTagLabel.setEnabled(enabled);
            this.logTagComboBox.setEnabled(enabled);
            this.logExprLabel.setEnabled(enabled);
            this.logExprComboBox.setEnabled(enabled);
            this.logStackCheckBox.setEnabled(enabled);
        } else if (source == this.enableOtherCheckBox) {
            if (this.enableOtherComboBox != null) {
                this.enableOtherComboBox.setEnabled(this.enableOtherCheckBox.isSelected());
            } else {
                this.enableOtherEditor.setEnabled(this.enableOtherCheckBox.isSelected());
            }
        } else if (source == this.disableOtherCheckBox) {
            if (this.disableOtherComboBox != null) {
                this.disableOtherComboBox.setEnabled(this.disableOtherCheckBox.isSelected());
            } else {
                this.disableOtherEditor.setEnabled(this.disableOtherCheckBox.isSelected());
            }
        }
        if (this.bpDialog != null) {
            this.bpDialog.enableOk();
        }
    }
}

