/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.ewt.spinBox.SpinBuddy;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLTextField;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.util.HistoryList;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.ideri.util.Product;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.jdeveloper.controls.classpick.ClassPickerFactory;
import oracle.jdeveloper.dialogs.ClassPackageBrowserFilterV2;
import oracle.jdeveloper.dialogs.ClassPackageBrowserV2;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxJavaScript;
import oracle.jdevimpl.runner.debug.Breakpoint;
import oracle.jdevimpl.runner.debug.BreakpointActionsPanel;
import oracle.jdevimpl.runner.debug.BreakpointsWindowSettings;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.Evaluator;
import oracle.jdevimpl.runner.xslt.XSLTRunnerAddin;

final class BreakpointOptionsDialog
extends JPanel
implements ActionListener,
ItemListener,
DocumentListener,
ChangeListener {
    private static int lastType = 2;
    private Project jproject;
    private JEWTDialog dlg;
    private URL ownerURL;
    private Breakpoint bp;
    private Breakpoint[] group;
    private Breakpoint[] breakpoints;
    private String[] groupNames;
    private JTabbedPane tabbedPane;
    private JPanel definitionPane;
    private JPanel conditionsPane;
    private JPanel actionsPane;
    private int currentType;
    private BreakpointTypeItem[] types;
    private JComboBox typeComboBox;
    private CardPanel definitionCardPanel;
    private HistoryList packageHistoryList;
    private JComboBox packageComboBox;
    private JTextField packageEditor;
    private HistoryList fileHistoryList;
    private JComboBox fileComboBox;
    private JTextField fileEditor;
    private JTextField lineTextField;
    private HistoryList methodHistoryList;
    private JComboBox methodComboBox;
    private JTextField methodEditor;
    private HistoryList exceptionHistoryList;
    private JComboBox exceptionComboBox;
    private JTextField exceptionEditor;
    private JButton exceptionBrowseButton;
    private JCheckBox caughtCheckBox;
    private JCheckBox uncaughtCheckBox;
    private HistoryList classHistoryList;
    private JComboBox classComboBox;
    private JTextField classEditor;
    private JButton classBrowseButton;
    private URLTextField urlTextField;
    private JButton urlBrowseButton;
    private JTextField lineTextField2;
    private HistoryList watchpointClassHistoryList;
    private JComboBox watchpointClassComboBox;
    private JTextField watchpointClassEditor;
    private JButton watchpointClassBrowseButton;
    private HistoryList watchpointFieldHistoryList;
    private JComboBox watchpointFieldComboBox;
    private JTextField watchpointFieldEditor;
    private JCheckBox accessCheckBox;
    private JCheckBox modifyCheckBox;
    private JLabel groupNameLabel;
    private HistoryList groupNameHistoryList;
    private JComboBox groupNameComboBox;
    private JTextField groupNameEditor;
    private JCheckBox groupNameCheckBox;
    private JTextField groupNameTextField;
    private HistoryList conditionHistoryList;
    private JComboBox conditionComboBox;
    private JTextField conditionEditor;
    private JRadioButton radioAllThreads;
    private JRadioButton radioOneThread;
    private HistoryList threadHistoryList;
    private JComboBox threadComboBox;
    private JTextField threadEditor;
    private JRadioButton radioNotThread;
    private HistoryList notThreadHistoryList;
    private JComboBox notThreadComboBox;
    private JTextField notThreadEditor;
    private NumericSpinBox passCountBox;
    private BreakpointActionsPanel bpActionsPanel;
    private static final String packageHistoryName = "DebugBreakpointPackage";
    private static final String fileHistoryName = "DebugBreakpointFile";
    private static final String methodHistoryName = "DebugBreakpointMethod";
    private static final String exceptionHistoryName = "DebugBreakpointException";
    private static final String classHistoryName = "DebugBreakpointClass";
    private static final String watchpointClassHistoryName = "DebugBreakpointWatchpointClass";
    private static final String watchpointFieldHistoryName = "DebugBreakpointWatchpointField";
    private static final String groupNameHistoryName = "DebugBreakpointGroupName";
    private static final String conditionHistoryName = "DebugBreakpointCondition";
    private static final String threadHistoryName = "DebugBreakpointThread";
    private static final String notThreadHistoryName = "DebugBreakpointThreadNot";
    static final int INITIAL_FOCUS_DONT_CARE = 0;
    static final int INITIAL_FOCUS_DEFINITIONS = 1;
    static final int INITIAL_FOCUS_CONDITIONS = 2;
    static final int INITIAL_FOCUS_ACTIONS = 3;
    static final int INITIAL_FOCUS_GROUPS = 4;
    private int initialFocus;

    static BreakpointOptionsDialog showBreakpointOptionsDialog(URL ownerURL, Breakpoint bp, String[] groupNames, int initialFocus) {
        BreakpointOptionsDialog panel = new BreakpointOptionsDialog(ownerURL, bp, groupNames, initialFocus);
        String title = bp == null ? DbgArb.getString(854) : DbgArb.getString(137);
        JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, (Component)panel.getInitialFocus(), (String)title);
        panel.setJEWTDialog(dlg);
        dlg.setOKButtonEnabled(panel.canOk());
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_deb_new_edit_breakptdialog_html");
        if (WizardLauncher.runDialog((JDialog)dlg)) {
            return panel;
        }
        return null;
    }

    static BreakpointOptionsDialog showBreakpointOptionsDialog(Breakpoint[] breakpoints, boolean group, String[] groupNames, int initialFocus) {
        BreakpointOptionsDialog panel = new BreakpointOptionsDialog(breakpoints, group, groupNames, initialFocus);
        String title = group ? DbgArb.getString(556) : DbgArb.getString(660);
        JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, (Component)panel.getInitialFocus(), (String)title);
        panel.setJEWTDialog(dlg);
        dlg.setOKButtonEnabled(panel.canOk());
        if (WizardLauncher.runDialog((JDialog)dlg)) {
            return panel;
        }
        return null;
    }

    private BreakpointOptionsDialog(URL ownerURL, Breakpoint bp, String[] groupNames, int initialFocus) {
        super(new BorderLayout());
        this.ownerURL = ownerURL;
        this.bp = bp;
        this.groupNames = groupNames;
        this.initialFocus = initialFocus;
        this.jproject = Ide.getActiveProject();
        HashMap<Integer, BreakpointTypeItem> types = new HashMap<Integer, BreakpointTypeItem>();
        this.currentType = bp != null ? bp.getType() : lastType;
        types.put(0, new BreakpointTypeItem(0));
        types.put(2, new BreakpointTypeItem(2));
        types.put(1, new BreakpointTypeItem(1));
        types.put(4, new BreakpointTypeItem(4));
        types.put(5, new BreakpointTypeItem(5));
        types.put(6, new BreakpointTypeItem(6));
        if (bp != null && bp.isCustomBreakpoint()) {
            types.put(bp.getType(), new BreakpointTypeItem(bp.getType(), bp.getTypeStringOverride()));
        } else if (bp != null && !types.containsKey(bp.getType())) {
            types.put(bp.getType(), new BreakpointTypeItem(bp.getType()));
        }
        this.types = types.values().toArray(new BreakpointTypeItem[types.size()]);
        this.init();
    }

    private BreakpointOptionsDialog(Breakpoint[] breakpoints, boolean group, String[] groupNames, int initialFocus) {
        super(new BorderLayout());
        this.bp = breakpoints[0];
        if (group) {
            this.group = breakpoints;
        } else {
            this.breakpoints = breakpoints;
        }
        this.groupNames = groupNames;
        this.initialFocus = initialFocus;
        this.init();
    }

    private void init() {
        this.tabbedPane = new JTabbedPane();
        this.definitionPane = this.makeDefinitionPane();
        this.conditionsPane = this.makeConditionsPane();
        this.actionsPane = this.makeActionsPane(this.groupNames);
        this.tabbedPane.addTab(DbgArb.getString(476), this.definitionPane);
        this.tabbedPane.addTab(DbgArb.getString(24), this.conditionsPane);
        this.tabbedPane.addTab(DbgArb.getString(870), this.actionsPane);
        this.add((Component)this.tabbedPane, "Center");
        switch (this.initialFocus) {
            case 1: 
            case 4: {
                this.tabbedPane.setSelectedComponent(this.definitionPane);
                break;
            }
            case 2: {
                this.tabbedPane.setSelectedComponent(this.conditionsPane);
                break;
            }
            case 3: {
                this.tabbedPane.setSelectedComponent(this.actionsPane);
                break;
            }
        }
        this.addListeners();
    }

    private void addListeners() {
        this.tabbedPane.addChangeListener(this);
        if (this.group != null) {
            this.groupNameTextField.getDocument().addDocumentListener(this);
        } else if (this.breakpoints != null) {
            this.groupNameCheckBox.addItemListener(this);
            this.groupNameComboBox.addActionListener(this);
            IdeUtil.addComboBoxDocumentListener((JComboBox)this.groupNameComboBox, (DocumentListener)this);
        } else {
            this.typeComboBox.addItemListener(this);
            this.packageComboBox.addActionListener(this);
            this.fileComboBox.addActionListener(this);
            IdeUtil.addComboBoxDocumentListener((JComboBox)this.fileComboBox, (DocumentListener)this);
            this.lineTextField.getDocument().addDocumentListener(this);
            this.methodComboBox.addActionListener(this);
            IdeUtil.addComboBoxDocumentListener((JComboBox)this.methodComboBox, (DocumentListener)this);
            this.exceptionComboBox.addActionListener(this);
            IdeUtil.addComboBoxDocumentListener((JComboBox)this.exceptionComboBox, (DocumentListener)this);
            this.exceptionBrowseButton.addActionListener(this);
            this.classComboBox.addActionListener(this);
            IdeUtil.addComboBoxDocumentListener((JComboBox)this.classComboBox, (DocumentListener)this);
            this.classBrowseButton.addActionListener(this);
            this.urlTextField.getDocument().addDocumentListener(this);
            this.urlBrowseButton.addActionListener((ActionListener)this.urlTextField);
            this.lineTextField2.getDocument().addDocumentListener(this);
            this.watchpointClassComboBox.addActionListener(this);
            IdeUtil.addComboBoxDocumentListener((JComboBox)this.watchpointClassComboBox, (DocumentListener)this);
            this.watchpointClassBrowseButton.addActionListener(this);
            this.watchpointFieldComboBox.addActionListener(this);
            IdeUtil.addComboBoxDocumentListener((JComboBox)this.watchpointFieldComboBox, (DocumentListener)this);
            this.groupNameComboBox.addActionListener(this);
        }
        this.conditionComboBox.addActionListener(this);
        IdeUtil.addComboBoxDocumentListener((JComboBox)this.conditionComboBox, (DocumentListener)this);
        this.radioAllThreads.addActionListener(this);
        this.radioAllThreads.addItemListener(this);
        this.radioOneThread.addActionListener(this);
        this.radioOneThread.addItemListener(this);
        this.radioNotThread.addActionListener(this);
        this.radioNotThread.addItemListener(this);
        this.threadComboBox.addActionListener(this);
        IdeUtil.addComboBoxDocumentListener((JComboBox)this.threadComboBox, (DocumentListener)this);
        this.notThreadComboBox.addActionListener(this);
        IdeUtil.addComboBoxDocumentListener((JComboBox)this.notThreadComboBox, (DocumentListener)this);
    }

    private void setJEWTDialog(JEWTDialog dlg) {
        this.dlg = dlg;
        dlg.addVetoableChangeListener((VetoableChangeListener)new 1());
    }

    private boolean showXSLTMessage(int bpType) {
        BreakpointTypeItem bpTypeItem = this.getBreakpointTypeItem(bpType);
        String[] messages = new String[]{DbgArb.format(690, bpTypeItem.toString()), DbgArb.getString(686)};
        int answer = JOptionPane.showConfirmDialog(this, messages, DbgArb.format(838, this.dlg.getTitle()), 0);
        return answer == 0;
    }

    private boolean findClass(String className) {
        JavaManager javaManager;
        return this.jproject != null && (javaManager = JavaManager.getJavaManager((Project)this.jproject)).getClass(className) != null;
    }

    private boolean showClassNotFoundMessage(String className) {
        String[] messages = new String[]{DbgArb.format(515, className), DbgArb.getString(514)};
        int answer = JOptionPane.showConfirmDialog(this, messages, DbgArb.format(725, this.dlg.getTitle()), 0);
        return answer == 0;
    }

    private boolean findMethod(String bpMethodName) {
        int lastDot;
        boolean found = false;
        if (this.jproject != null && (lastDot = bpMethodName.lastIndexOf(46)) != -1) {
            String className = bpMethodName.substring(0, lastDot);
            String methodName = bpMethodName.substring(lastDot + 1);
            JavaManager javaManager = JavaManager.getJavaManager((Project)this.jproject);
            JavaClass javaClass = javaManager.getClass(className);
            if (javaClass != null) {
                Collection c;
                Collection c2;
                if (methodName.equals("<clinit>")) {
                    if (javaClass.getClinitMethod() != null) {
                        found = true;
                    } else {
                        List l;
                        SourceClass sourceClass = (SourceClass)javaClass.getSourceElement();
                        if (sourceClass != null && (l = sourceClass.getSourceInitializers()) != null && l.size() > 0) {
                            found = true;
                        }
                    }
                } else if (methodName.equals("<init>") && (c2 = javaClass.getDeclaredConstructors()) != null && c2.size() > 0) {
                    found = true;
                }
                if (!found && (c = javaClass.getDeclaredMethods()) != null && c.size() > 0) {
                    for (JavaMethod method : c) {
                        if (!method.getName().equals(methodName)) continue;
                        found = true;
                        break;
                    }
                }
            }
        }
        return found;
    }

    private boolean showMethodNotFoundMessage(String bpMethodName) {
        String[] messages = new String[]{DbgArb.format(67, bpMethodName), DbgArb.getString(64)};
        int answer = JOptionPane.showConfirmDialog(this, messages, DbgArb.format(328, this.dlg.getTitle()), 0);
        return answer == 0;
    }

    private boolean findField(String className, String fieldName) {
        JavaManager javaManager;
        JavaClass javaClass;
        return this.jproject != null && (javaClass = (javaManager = JavaManager.getJavaManager((Project)this.jproject)).getClass(className)) != null && javaClass.getDeclaredField(fieldName) != null;
    }

    private boolean showFieldNotFoundMessage(String className, String fieldName) {
        String[] messages = new String[]{DbgArb.format(621, fieldName, className), DbgArb.getString(619)};
        int answer = JOptionPane.showConfirmDialog(this, messages, DbgArb.format(177, this.dlg.getTitle()), 0);
        return answer == 0;
    }

    private Component getInitialFocus() {
        switch (this.initialFocus) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                return this.group == null ? this.groupNameComboBox : this.groupNameTextField;
            }
        }
        if (this.group != null) {
            return this.groupNameTextField;
        }
        if (this.breakpoints != null) {
            return this.groupNameCheckBox;
        }
        switch (this.currentType) {
            default: {
                return this.packageEditor;
            }
            case 1: {
                return this.methodEditor;
            }
            case 7: {
                return this.groupNameEditor;
            }
            case 2: {
                return this.exceptionEditor;
            }
            case 3: {
                return this.groupNameEditor;
            }
            case 4: {
                return this.classEditor;
            }
            case 5: {
                return this.urlTextField;
            }
            case 6: 
        }
        return this.watchpointClassEditor;
    }

    private JPanel makeDefinitionPane() {
        JPanel panel = new JPanel(new GridBagLayout());
        int y = 0;
        if (this.group != null) {
            JLabel groupLabel = new JLabel(DbgArb.getString(635));
            this.groupNameLabel = new JLabel();
            this.groupNameTextField = new JTextField();
            this.groupNameTextField.setText(this.bp.getGroupName());
            ResourceUtils.resLabel((JLabel)this.groupNameLabel, (Component)this.groupNameTextField, (String)DbgArb.getString(278));
            panel.add((Component)groupLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            FastStringBuffer fsb = new FastStringBuffer();
            int i = 0;
            while (i < this.group.length) {
                fsb.append(this.group[i].getDescription());
                fsb.append("\n");
                ++i;
            }
            MultiLineLabel label = new MultiLineLabel(fsb.toString());
            JScrollPane scrollPane = new JScrollPane((Component)label);
            panel.add((Component)scrollPane, new GridBagConstraints(0, y++, 0, 1, 1.0, 1.0, 17, 1, new Insets(0, 25, 0, 5), 0, 0));
            panel.add((Component)this.groupNameLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)this.groupNameTextField, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        } else if (this.breakpoints != null) {
            JLabel groupLabel = new JLabel(DbgArb.getString(140));
            this.groupNameCheckBox = new JCheckBox();
            ResourceUtils.resButton((AbstractButton)this.groupNameCheckBox, (String)DbgArb.getString(608));
            this.groupNameLabel = new JLabel();
            this.groupNameHistoryList = Ide.loadHistoryList((String)groupNameHistoryName);
            this.groupNameComboBox = new JComboBox<String>(this.groupNameHistoryList.getHistory());
            this.groupNameEditor = (JTextField)this.groupNameComboBox.getEditor().getEditorComponent();
            ResourceUtils.resLabel((JLabel)this.groupNameLabel, (Component)this.groupNameEditor, (String)DbgArb.getString(278));
            this.groupNameComboBox.setEditable(true);
            String groupName = this.bp.getGroupName();
            IdeUtil.comboBoxSelectItem((JComboBox)this.groupNameComboBox, (Object)groupName);
            ResourceUtils.resLabel((JLabel)this.groupNameLabel, (Component)this.groupNameTextField, (String)DbgArb.getString(278));
            this.groupNameCheckBox.setSelected(false);
            this.groupNameLabel.setEnabled(false);
            this.groupNameComboBox.setEnabled(false);
            panel.add((Component)groupLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            FastStringBuffer fsb = new FastStringBuffer();
            int i = 0;
            while (i < this.breakpoints.length) {
                fsb.append(this.breakpoints[i].getDescription());
                fsb.append("\n");
                ++i;
            }
            MultiLineLabel label = new MultiLineLabel(fsb.toString());
            JScrollPane scrollPane = new JScrollPane((Component)label);
            panel.add((Component)scrollPane, new GridBagConstraints(0, y++, 0, 1, 1.0, 1.0, 17, 1, new Insets(0, 25, 0, 5), 0, 0));
            panel.add((Component)this.groupNameCheckBox, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)this.groupNameLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)this.groupNameComboBox, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        } else {
            this.groupNameLabel = new JLabel();
            this.groupNameHistoryList = Ide.loadHistoryList((String)groupNameHistoryName);
            this.groupNameComboBox = new JComboBox<String>(this.groupNameHistoryList.getHistory());
            this.groupNameEditor = (JTextField)this.groupNameComboBox.getEditor().getEditorComponent();
            ResourceUtils.resLabel((JLabel)this.groupNameLabel, (Component)this.groupNameEditor, (String)DbgArb.getString(278));
            this.groupNameComboBox.setEditable(true);
            String groupName = this.bp == null ? "" : this.bp.getGroupName();
            IdeUtil.comboBoxSelectItem((JComboBox)this.groupNameComboBox, (Object)groupName);
            if (this.bp != null && !this.bp.canEditGroupName()) {
                this.groupNameComboBox.setEditable(false);
                this.groupNameComboBox.setEnabled(false);
            }
            panel.add((Component)this.makeTypePanel(), new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)this.makeCardPanel(), new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)new JLabel(), new GridBagConstraints(0, y++, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.groupNameLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)this.groupNameComboBox, new GridBagConstraints(0, y, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        }
        return panel;
    }

    private BreakpointTypeItem getBreakpointTypeItem(int bpType) {
        int i = this.types.length - 1;
        while (i >= 0) {
            if (this.types[i].breakpointType == bpType) {
                return this.types[i];
            }
            --i;
        }
        return null;
    }

    private JPanel makeTypePanel() {
        JLabel typeLabel = new JLabel();
        this.typeComboBox = new JComboBox();
        ResourceUtils.resLabel((JLabel)typeLabel, (Component)this.typeComboBox, (String)DbgArb.getString(304));
        this.typeComboBox.setModel(new NonNullableComboBoxModel((Object[])this.types));
        BreakpointTypeItem item = this.getBreakpointTypeItem(this.currentType);
        if (item != null) {
            this.typeComboBox.setSelectedItem(item);
        }
        if (this.bp != null) {
            this.typeComboBox.setEnabled(false);
        }
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)typeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.typeComboBox, new GridBagConstraints(1, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    private CardPanel makeCardPanel() {
        this.definitionCardPanel = new CardPanel();
        int typesLength = this.types.length;
        int i = 0;
        while (i < typesLength) {
            this.definitionCardPanel.add((Component)this.types[i].panel, Integer.toString(this.types[i].breakpointType));
            ++i;
        }
        this.definitionCardPanel.showCard(Integer.toString(this.currentType));
        return this.definitionCardPanel;
    }

    private JPanel makePackageFileLineCard() {
        String line;
        String file;
        String pkg;
        if (this.bp != null && this.currentType == 0) {
            pkg = this.bp.getPackage();
            file = this.bp.getFile();
            line = Integer.toString(this.bp.getLine());
        } else {
            line = "";
            file = "";
            pkg = "";
        }
        JLabel packageLabel = new JLabel();
        this.packageHistoryList = Ide.loadHistoryList((String)packageHistoryName);
        this.packageComboBox = new JComboBox<String>(this.packageHistoryList.getHistory());
        this.packageComboBox.setEditable(true);
        this.packageEditor = (JTextField)this.packageComboBox.getEditor().getEditorComponent();
        ResourceUtils.resLabel((JLabel)packageLabel, (Component)this.packageEditor, (String)DbgArb.getString(467));
        if (this.jproject != null) {
            Context context = Context.newIdeContext();
            context.setProject(this.jproject);
            ClassPickerFactory.attach(this.packageEditor, context, 3);
        }
        IdeUtil.comboBoxSelectItem((JComboBox)this.packageComboBox, (Object)pkg);
        JLabel fileLabel = new JLabel();
        this.fileHistoryList = Ide.loadHistoryList((String)fileHistoryName);
        this.fileComboBox = new JComboBox<String>(this.fileHistoryList.getHistory());
        this.fileComboBox.setEditable(true);
        this.fileEditor = (JTextField)this.fileComboBox.getEditor().getEditorComponent();
        ResourceUtils.resLabel((JLabel)fileLabel, (Component)this.fileEditor, (String)DbgArb.getString(20));
        IdeUtil.comboBoxSelectItem((JComboBox)this.fileComboBox, (Object)file);
        JLabel lineLabel = new JLabel();
        this.lineTextField = new JTextField(line, 6);
        this.lineTextField.setHorizontalAlignment(4);
        ResourceUtils.resLabel((JLabel)lineLabel, (Component)this.lineTextField, (String)DbgArb.getString(459));
        if (this.bp != null && this.bp.isCustomBreakpoint()) {
            this.packageComboBox.setEnabled(false);
            this.packageComboBox.setEditable(false);
            this.fileComboBox.setEnabled(false);
            this.fileComboBox.setEditable(false);
            this.lineTextField.setEnabled(false);
        }
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel titleLabel = new JLabel(DbgArb.getString(644));
        int y = 0;
        panel.add((Component)titleLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)packageLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 0, 0), 0, 0));
        panel.add((Component)this.packageComboBox, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)fileLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 0, 0), 0, 0));
        panel.add((Component)lineLabel, new GridBagConstraints(1, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.fileComboBox, new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 15, 5, 0), 0, 0));
        panel.add((Component)this.lineTextField, new GridBagConstraints(1, y, 0, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        return panel;
    }

    private JPanel makeMethodCard() {
        String method = this.bp != null && this.currentType == 1 ? this.bp.getMethod() : "";
        JLabel methodLabel = new JLabel();
        this.methodHistoryList = Ide.loadHistoryList((String)methodHistoryName);
        this.methodComboBox = new JComboBox<String>(this.methodHistoryList.getHistory());
        this.methodComboBox.setEditable(true);
        this.methodEditor = (JTextField)this.methodComboBox.getEditor().getEditorComponent();
        ResourceUtils.resLabel((JLabel)methodLabel, (Component)this.methodEditor, (String)DbgArb.getString(593));
        JLabel example1 = new JLabel(DbgArb.getString(426));
        JLabel example2 = new JLabel(DbgArb.getString(693));
        JLabel example3 = new JLabel(DbgArb.getString(203));
        IdeUtil.comboBoxSelectItem((JComboBox)this.methodComboBox, (Object)method);
        if (this.bp != null && this.bp.isCustomBreakpoint()) {
            this.methodComboBox.setEnabled(false);
            this.methodComboBox.setEditable(false);
        }
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel titleLabel = new JLabel(DbgArb.getString(626));
        int y = 0;
        panel.add((Component)titleLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)methodLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 0, 0), 0, 0));
        panel.add((Component)this.methodComboBox, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)example1, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)example2, new GridBagConstraints(1, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)example3, new GridBagConstraints(1, y, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        return panel;
    }

    private JPanel makeMethodOffsetCard() {
        JLabel fqMethodLabel = new JLabel();
        JTextField fqMethodTextField = new JTextField(this.bp.getMethod());
        fqMethodTextField.setEditable(false);
        ResourceUtils.resLabel((JLabel)fqMethodLabel, (Component)fqMethodTextField, (String)DbgArb.getString(37));
        JLabel offsetLabel = new JLabel();
        JTextField offsetTextField = new JTextField(Integer.toString(this.bp.getOffset()), 6);
        offsetTextField.setEditable(false);
        offsetTextField.setHorizontalAlignment(4);
        ResourceUtils.resLabel((JLabel)offsetLabel, (Component)offsetTextField, (String)DbgArb.getString(881));
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel titleLabel = new JLabel(DbgArb.getString(258));
        int y = 0;
        panel.add((Component)titleLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)fqMethodLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 0, 0), 0, 0));
        panel.add((Component)fqMethodTextField, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)offsetLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 0, 0), 0, 0));
        panel.add((Component)offsetTextField, new GridBagConstraints(1, y, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        return panel;
    }

    private JPanel makeExceptionCard() {
        boolean uncaught;
        boolean caught;
        String exception;
        if (this.bp != null && this.currentType == 2) {
            exception = this.bp.getException();
            caught = this.bp.isCaught();
            uncaught = this.bp.isUncaught();
        } else {
            exception = "";
            caught = true;
            uncaught = true;
        }
        JLabel exceptionLabel = new JLabel();
        this.exceptionHistoryList = Ide.loadHistoryList((String)exceptionHistoryName);
        if (this.exceptionHistoryList.getSize() == 0) {
            String[] x = new String[]{"java.lang.NullPointerException", "java.lang.ArrayIndexOutOfBoundsException", "java.lang.ArrayStoreException", "java.lang.ClassCastException", "java.lang.Exception", "java.lang.IllegalAccessException", "java.lang.IllegalArgumentException", "java.lang.IllegalStateException", "java.lang.IndexOutOfBoundsException", "java.lang.NumberFormatException", "java.lang.RuntimeException", "java.lang.SecurityException", "java.lang.StringIndexOutOfBoundsException", "java.lang.UnsupportedOperationException", "java.lang.Error", "java.lang.Throwable", "oracle.jbo.JboException", "$Oracle.EXCEPTION_ORA_6502"};
            this.exceptionHistoryList.fill(x);
        }
        this.exceptionComboBox = new JComboBox<String>(this.exceptionHistoryList.getHistory());
        this.exceptionComboBox.setEditable(true);
        this.exceptionEditor = (JTextField)this.exceptionComboBox.getEditor().getEditorComponent();
        ResourceUtils.resLabel((JLabel)exceptionLabel, (Component)this.exceptionEditor, (String)DbgArb.getString(583));
        JLabel example1 = new JLabel(DbgArb.getString(719));
        JLabel example2 = new JLabel(DbgArb.getString(677));
        IdeUtil.comboBoxSelectItem((JComboBox)this.exceptionComboBox, (Object)exception);
        this.exceptionBrowseButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.exceptionBrowseButton, (String)DbgArb.getString(732));
        this.caughtCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.caughtCheckBox, (String)DbgArb.getString(81));
        this.caughtCheckBox.setSelected(caught);
        this.uncaughtCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.uncaughtCheckBox, (String)DbgArb.getString(680));
        this.uncaughtCheckBox.setSelected(uncaught);
        if (this.bp != null && this.bp.isCustomBreakpoint()) {
            this.exceptionComboBox.setEnabled(false);
            this.exceptionComboBox.setEditable(false);
            this.exceptionBrowseButton.setEnabled(false);
            this.caughtCheckBox.setEnabled(false);
            this.uncaughtCheckBox.setEnabled(false);
        }
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel titleLabel = new JLabel(DbgArb.getString(338));
        int y = 0;
        panel.add((Component)titleLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)exceptionLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 0, 0), 0, 0));
        panel.add((Component)this.exceptionComboBox, new GridBagConstraints(0, y, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 15, 0, 0), 0, 0));
        if (!Product.isRaptor()) {
            panel.add((Component)this.exceptionBrowseButton, new GridBagConstraints(2, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        }
        panel.add((Component)example1, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)example2, new GridBagConstraints(1, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)this.caughtCheckBox, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 0, 0), 0, 0));
        panel.add((Component)this.uncaughtCheckBox, new GridBagConstraints(0, y, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        return panel;
    }

    private JPanel makeDeadlockCard() {
        JPanel panel = new JPanel();
        return panel;
    }

    private JPanel makeClassCard() {
        String className = this.bp != null && this.currentType == 4 ? this.bp.getClassName() : "";
        JLabel classLabel = new JLabel();
        this.classHistoryList = Ide.loadHistoryList((String)classHistoryName);
        this.classComboBox = new JComboBox<String>(this.classHistoryList.getHistory());
        this.classComboBox.setEditable(true);
        this.classEditor = (JTextField)this.classComboBox.getEditor().getEditorComponent();
        ResourceUtils.resLabel((JLabel)classLabel, (Component)this.classEditor, (String)DbgArb.getString(878));
        if (this.jproject != null) {
            Context context = Context.newIdeContext();
            context.setProject(this.jproject);
            ClassPickerFactory.attach(this.classEditor, context, 11);
        }
        JLabel example1 = new JLabel(DbgArb.getString(719));
        JLabel example2 = new JLabel(DbgArb.getString(952));
        IdeUtil.comboBoxSelectItem((JComboBox)this.classComboBox, (Object)className);
        this.classBrowseButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.classBrowseButton, (String)DbgArb.getString(726));
        if (this.bp != null && this.bp.isCustomBreakpoint()) {
            this.classComboBox.setEnabled(false);
            this.classComboBox.setEditable(false);
            this.classBrowseButton.setEnabled(false);
        }
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel titleLabel = new JLabel(DbgArb.getString(479));
        int y = 0;
        panel.add((Component)titleLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)classLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 0, 0), 0, 0));
        panel.add((Component)this.classComboBox, new GridBagConstraints(0, y, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)this.classBrowseButton, new GridBagConstraints(2, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)example1, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)example2, new GridBagConstraints(1, y, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    private JPanel makeURLLineCard() {
        String line;
        URL url;
        if (this.bp != null && this.currentType == 5) {
            url = this.bp.getURL();
            line = Integer.toString(this.bp.getLine());
        } else {
            url = null;
            line = "";
        }
        JLabel urlLabel = new JLabel();
        this.urlTextField = new URLTextField(url, false, false);
        ResourceUtils.resLabel((JLabel)urlLabel, (Component)this.urlTextField, (String)DbgArb.getString(150));
        this.urlBrowseButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.urlBrowseButton, (String)DbgArb.getString(411));
        JLabel lineLabel = new JLabel();
        this.lineTextField2 = new JTextField(line, 6);
        this.lineTextField2.setHorizontalAlignment(4);
        ResourceUtils.resLabel((JLabel)lineLabel, (Component)this.lineTextField2, (String)DbgArb.getString(459));
        if (this.bp != null && this.bp.isCustomBreakpoint()) {
            this.urlTextField.setEnabled(false);
            this.urlBrowseButton.setEnabled(false);
            this.lineTextField2.setEnabled(false);
        }
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel titleLabel = new JLabel(DbgArb.getString(833));
        int y = 0;
        panel.add((Component)titleLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)urlLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 0, 0), 0, 0));
        panel.add((Component)this.urlTextField, new GridBagConstraints(0, y, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)this.urlBrowseButton, new GridBagConstraints(2, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)lineLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 0, 0), 0, 0));
        panel.add((Component)this.lineTextField2, new GridBagConstraints(1, y, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        return panel;
    }

    private JPanel makeWatchpointCard() {
        boolean modify;
        boolean access;
        String fieldName;
        String className;
        if (this.bp != null && this.currentType == 6) {
            className = this.bp.getClassName();
            fieldName = this.bp.getFieldName();
            access = this.bp.isAccess();
            modify = this.bp.isModify();
        } else {
            className = "";
            fieldName = "";
            access = false;
            modify = true;
        }
        JLabel watchpointClassLabel = new JLabel();
        this.watchpointClassHistoryList = Ide.loadHistoryList((String)watchpointClassHistoryName);
        this.watchpointClassComboBox = new JComboBox<String>(this.watchpointClassHistoryList.getHistory());
        this.watchpointClassComboBox.setEditable(true);
        this.watchpointClassEditor = (JTextField)this.watchpointClassComboBox.getEditor().getEditorComponent();
        ResourceUtils.resLabel((JLabel)watchpointClassLabel, (Component)this.watchpointClassEditor, (String)DbgArb.getString(889));
        if (this.jproject != null) {
            Context context = Context.newIdeContext();
            context.setProject(this.jproject);
            ClassPickerFactory.attach(this.watchpointClassEditor, context, 11);
        }
        JLabel example1 = new JLabel(DbgArb.getString(719));
        JLabel example2 = new JLabel(DbgArb.getString(723));
        IdeUtil.comboBoxSelectItem((JComboBox)this.watchpointClassComboBox, (Object)className);
        this.watchpointClassBrowseButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.watchpointClassBrowseButton, (String)DbgArb.getString(887));
        JLabel watchpointFieldLabel = new JLabel();
        this.watchpointFieldHistoryList = Ide.loadHistoryList((String)watchpointFieldHistoryName);
        this.watchpointFieldComboBox = new JComboBox<String>(this.watchpointFieldHistoryList.getHistory());
        this.watchpointFieldComboBox.setEditable(true);
        this.watchpointFieldEditor = (JTextField)this.watchpointFieldComboBox.getEditor().getEditorComponent();
        ResourceUtils.resLabel((JLabel)watchpointFieldLabel, (Component)this.watchpointFieldEditor, (String)DbgArb.getString(530));
        IdeUtil.comboBoxSelectItem((JComboBox)this.watchpointFieldComboBox, (Object)fieldName);
        this.accessCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.accessCheckBox, (String)DbgArb.getString(80));
        this.accessCheckBox.setSelected(access);
        this.modifyCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.modifyCheckBox, (String)DbgArb.getString(735));
        this.modifyCheckBox.setSelected(modify);
        if (this.bp != null && this.bp.isCustomBreakpoint()) {
            this.watchpointClassComboBox.setEnabled(false);
            this.watchpointClassComboBox.setEditable(false);
            this.watchpointClassBrowseButton.setEnabled(false);
            this.watchpointFieldComboBox.setEnabled(false);
            this.watchpointFieldComboBox.setEditable(false);
            this.accessCheckBox.setEnabled(false);
            this.modifyCheckBox.setEnabled(false);
        }
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel titleLabel = new JLabel(DbgArb.getString(501));
        int y = 0;
        panel.add((Component)titleLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)watchpointClassLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 0, 0), 0, 0));
        panel.add((Component)this.watchpointClassComboBox, new GridBagConstraints(0, y, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)this.watchpointClassBrowseButton, new GridBagConstraints(2, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)example1, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)example2, new GridBagConstraints(1, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)watchpointFieldLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 0, 0), 0, 0));
        panel.add((Component)this.watchpointFieldComboBox, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)this.accessCheckBox, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 0, 0), 0, 0));
        panel.add((Component)this.modifyCheckBox, new GridBagConstraints(0, y, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        return panel;
    }

    private JPanel makeConditionsPane() {
        int passCount;
        String condition;
        if (this.bp != null) {
            condition = this.bp.getCondition();
            passCount = this.bp.getPassCount();
        } else {
            condition = "";
            passCount = 1;
        }
        JLabel conditionLabel = new JLabel();
        this.conditionHistoryList = Ide.loadHistoryList((String)conditionHistoryName);
        this.conditionComboBox = new JComboBox<String>(this.conditionHistoryList.getHistory());
        if (this.bp != null && !this.bp.canEditCondition()) {
            this.conditionComboBox.setEditable(false);
            this.conditionComboBox.setEnabled(false);
        } else {
            this.conditionComboBox.setEditable(true);
        }
        this.conditionEditor = (JTextField)this.conditionComboBox.getEditor().getEditorComponent();
        ResourceUtils.resLabel((JLabel)conditionLabel, (Component)this.conditionEditor, (String)DbgArb.getString(616));
        IdeUtil.comboBoxSelectItem((JComboBox)this.conditionComboBox, (Object)condition);
        JPanel threadPanel = this.makeThreadPanel();
        JLabel passCountLabel = new JLabel();
        this.passCountBox = new NumericSpinBox(0, Integer.MAX_VALUE);
        this.passCountBox.setIntValue(passCount);
        SpinBuddy buddy = this.passCountBox.getSpinBuddy();
        if (buddy instanceof JTextField) {
            ((JTextField)buddy).setHorizontalAlignment(4);
        }
        ResourceUtils.resLabel((JLabel)passCountLabel, (Component)this.passCountBox, (String)DbgArb.getString(189));
        if (this.bp != null && !this.bp.canEditPassCount()) {
            this.passCountBox.setEnabled(false);
        }
        JPanel panel = new JPanel(new GridBagLayout());
        int y = 0;
        panel.add((Component)conditionLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)this.conditionComboBox, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)threadPanel, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 5), 0, 0));
        panel.add((Component)passCountLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        panel.add((Component)this.passCountBox, new GridBagConstraints(1, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 5, 5), 0, 0));
        panel.add((Component)new JLabel(), new GridBagConstraints(0, y, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel makeThreadPanel() {
        String notThreadName;
        String threadName;
        if (this.bp != null) {
            threadName = this.bp.getThreadName();
            notThreadName = this.bp.getThreadNameNot();
        } else {
            threadName = "";
            notThreadName = "";
        }
        this.radioAllThreads = new JRadioButton();
        this.radioOneThread = new JRadioButton();
        this.radioNotThread = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this.radioAllThreads, (String)DbgArb.getString(228));
        ResourceUtils.resButton((AbstractButton)this.radioOneThread, (String)DbgArb.getString(415));
        ResourceUtils.resButton((AbstractButton)this.radioNotThread, (String)DbgArb.getString(18));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.radioAllThreads);
        buttonGroup.add(this.radioOneThread);
        buttonGroup.add(this.radioNotThread);
        this.threadHistoryList = Ide.loadHistoryList((String)threadHistoryName);
        this.threadComboBox = new JComboBox<String>(this.threadHistoryList.getHistory());
        this.threadComboBox.setEditable(true);
        this.threadEditor = (JTextField)this.threadComboBox.getEditor().getEditorComponent();
        this.threadEditor.getAccessibleContext().setAccessibleName(this.radioOneThread.getText());
        IdeUtil.comboBoxSelectItem((JComboBox)this.threadComboBox, (Object)threadName);
        this.notThreadHistoryList = Ide.loadHistoryList((String)notThreadHistoryName);
        this.notThreadComboBox = new JComboBox<String>(this.notThreadHistoryList.getHistory());
        this.notThreadComboBox.setEditable(true);
        this.notThreadEditor = (JTextField)this.notThreadComboBox.getEditor().getEditorComponent();
        this.notThreadEditor.getAccessibleContext().setAccessibleName(this.radioNotThread.getText());
        IdeUtil.comboBoxSelectItem((JComboBox)this.notThreadComboBox, (Object)notThreadName);
        if (threadName.length() > 0) {
            this.radioOneThread.setSelected(true);
        } else if (notThreadName.length() > 0) {
            this.radioNotThread.setSelected(true);
        } else {
            this.radioAllThreads.setSelected(true);
        }
        this.threadComboBox.setEnabled(this.radioOneThread.isSelected());
        this.notThreadComboBox.setEnabled(this.radioNotThread.isSelected());
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel titleLabel = new JLabel(DbgArb.getString(602));
        int y = 0;
        panel.add((Component)titleLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.radioAllThreads, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)this.radioOneThread, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)this.threadComboBox, new GridBagConstraints(1, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.radioNotThread, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)this.notThreadComboBox, new GridBagConstraints(1, y, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        boolean enableThreadOptions = true;
        if (this.bp != null && this.bp.getURL() != null) {
            Node node = null;
            try {
                node = NodeFactory.findOrCreate((URL)this.bp.getURL());
            }
            catch (IllegalAccessException e) {
            }
            catch (InstantiationException e) {
                // empty catch block
            }
            if (node != null) {
                enableThreadOptions = DebugMozillaFireFoxJavaScript.supportsThreadBreakpoints(node);
            }
        }
        if (!enableThreadOptions) {
            panel.setEnabled(false);
            titleLabel.setEnabled(false);
            this.radioAllThreads.setEnabled(false);
            this.radioOneThread.setEnabled(false);
            this.radioNotThread.setEnabled(false);
            this.radioAllThreads.setSelected(true);
        } else {
            panel.setEnabled(true);
            titleLabel.setEnabled(true);
            this.radioAllThreads.setEnabled(true);
            this.radioOneThread.setEnabled(true);
            this.radioNotThread.setEnabled(true);
        }
        if (this.bp != null && !this.bp.canEditBreakForThreads()) {
            this.radioAllThreads.setEnabled(false);
            this.radioNotThread.setEnabled(false);
            this.radioOneThread.setEnabled(false);
            this.threadComboBox.setEnabled(false);
            this.threadComboBox.setEditable(false);
            this.notThreadComboBox.setEnabled(false);
            this.notThreadComboBox.setEditable(false);
        }
        return panel;
    }

    private JPanel makeActionsPane(String[] groupNames) {
        this.bpActionsPanel = new BreakpointActionsPanel(groupNames, true, this);
        this.bpActionsPanel.loadFrom(this.bp, BreakpointsWindowSettings.getInstance());
        return this.bpActionsPanel;
    }

    void typeChanged() {
        switch (this.currentType) {
            case 0: 
            case 5: {
                this.bpActionsPanel.setLog(false);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                this.bpActionsPanel.setLog(true);
                break;
            }
        }
    }

    void enableOk() {
        if (this.dlg != null) {
            this.dlg.setOKButtonEnabled(this.canOk());
        }
    }

    private boolean canOk() {
        String msg = this.anythingInvalidInDefinition();
        if (msg != null) {
            return false;
        }
        msg = this.anythingInvalidInConditions();
        if (msg != null) {
            return false;
        }
        msg = this.anythingInvalidInActions();
        return msg == null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String anythingInvalidInDefinition() {
        if (this.group != null) {
            String s = this.groupNameTextField.getText();
            if (s.length() == 0) {
                return DbgArb.getString(879);
            }
            if (s.equals(this.bp.getGroupName())) return null;
            int length = this.groupNames.length;
            int i = 0;
            while (i < length) {
                if (s.equals(this.groupNames[i])) {
                    return DbgArb.getString(633);
                }
                ++i;
            }
            return null;
        } else {
            if (this.breakpoints != null) {
                if (!this.groupNameCheckBox.isSelected()) return null;
                if (this.groupNameEditor.getText().length() != 0) return null;
                return DbgArb.getString(879);
            }
            switch (this.currentType) {
                case 0: {
                    if (this.fileEditor.getText().length() == 0) {
                        return DbgArb.getString(396);
                    }
                    try {
                        int line = Integer.parseInt(this.lineTextField.getText());
                        if (line >= 1) return null;
                        return DbgArb.getString(470);
                    }
                    catch (Exception e) {
                        return DbgArb.getString(470);
                    }
                }
                case 1: {
                    if (this.methodEditor.getText().length() != 0) return null;
                    return DbgArb.getString(577);
                }
                case 4: {
                    if (this.classEditor.getText().length() != 0) return null;
                    return DbgArb.getString(800);
                }
                case 5: {
                    if (this.urlTextField.getURL() == null) {
                        return DbgArb.getString(592);
                    }
                    try {
                        int line = Integer.parseInt(this.lineTextField2.getText());
                        if (line >= 1) return null;
                        return DbgArb.getString(470);
                    }
                    catch (Exception e) {
                        return DbgArb.getString(470);
                    }
                }
                case 6: {
                    if (this.watchpointClassEditor.getText().length() == 0) {
                        return DbgArb.getString(800);
                    }
                    if (this.watchpointFieldEditor.getText().length() != 0) return null;
                    return DbgArb.getString(601);
                }
            }
        }
        return null;
    }

    private String anythingInvalidInConditions() {
        String condition = this.conditionEditor.getText();
        if (condition.length() > 0 && !Evaluator.validate(condition)) {
            return DbgArb.getString(813);
        }
        if (this.radioOneThread.isSelected() && this.threadEditor.getText().length() == 0) {
            return DbgArb.getString(757);
        }
        if (this.radioNotThread.isSelected() && this.notThreadEditor.getText().length() == 0) {
            return DbgArb.getString(378);
        }
        return null;
    }

    private String anythingInvalidInActions() {
        return this.bpActionsPanel.anythingInvalid();
    }

    Breakpoint getBreakpoint() {
        return this.bp;
    }

    private void doOk() {
        if (this.group != null) {
            int length = this.group.length;
            int i = 0;
            while (i < length) {
                Breakpoint bpInGroup = this.group[i];
                bpInGroup.setShallow(true);
                this.doOkForDefinition(bpInGroup);
                this.doOkForConditions(bpInGroup);
                this.doOkForActions(bpInGroup);
                bpInGroup.setShallow(false);
                ++i;
            }
        } else if (this.breakpoints != null) {
            int length = this.breakpoints.length;
            int i = 0;
            while (i < length) {
                Breakpoint bpInMulti = this.breakpoints[i];
                bpInMulti.setShallow(true);
                this.doOkForDefinition(bpInMulti);
                this.doOkForConditions(bpInMulti);
                this.doOkForActions(bpInMulti);
                bpInMulti.setShallow(false);
                ++i;
            }
        } else {
            this.bp = this.doOkForDefinition(this.bp);
            this.doOkForConditions(this.bp);
            this.doOkForActions(this.bp);
            this.bp.setShallow(false);
        }
    }

    private boolean veto() {
        RunConfiguration rc;
        if (XSLTRunnerAddin.isXSLTDebuggingSupported() && this.bp == null && this.currentType != 5 && this.jproject != null && (rc = RunConfiguration.getInstance((PropertyStorage)this.jproject)) != null) {
            URL target = rc.getTargetURL();
            try {
                Node node = NodeFactory.findOrCreate((URL)target);
                if (node instanceof XMLSourceNode && XSLTRunnerAddin.isXSLT((XMLSourceNode)node)) {
                    boolean bl = this.showXSLTMessage(this.currentType) ^ true;
                    return bl;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        switch (this.currentType) {
            case 2: {
                String jlException;
                String exception = this.exceptionEditor.getText();
                if (exception.length() <= 0 || exception.startsWith("$Oracle.") || this.findClass(exception)) break;
                if (exception.indexOf(46) == -1 && this.findClass(jlException = "java.lang." + exception)) {
                    this.exceptionEditor.setText(jlException);
                    return false;
                }
                return this.showClassNotFoundMessage(exception) ^ true;
            }
            case 4: {
                String className = this.classEditor.getText();
                if (className.length() <= 0 || this.findClass(className)) break;
                return this.showClassNotFoundMessage(className) ^ true;
            }
            case 1: {
                String bpMethodName = this.methodEditor.getText();
                if (bpMethodName.length() <= 0 || this.findMethod(bpMethodName)) break;
                return this.showMethodNotFoundMessage(bpMethodName) ^ true;
            }
            case 6: {
                String className = this.watchpointClassEditor.getText();
                if (className.length() > 0 && !this.findClass(className)) {
                    return this.showClassNotFoundMessage(className) ^ true;
                }
                String fieldName = this.watchpointFieldEditor.getText();
                if (fieldName.length() <= 0 || this.findField(className, fieldName)) break;
                return this.showFieldNotFoundMessage(className, fieldName) ^ true;
            }
        }
        return false;
    }

    private Breakpoint doOkForDefinition(Breakpoint bp) {
        if (this.group != null) {
            bp.setGroupName(this.groupNameTextField.getText());
        } else if (this.breakpoints != null) {
            if (this.groupNameCheckBox.isSelected()) {
                bp.setGroupName(this.groupNameHistoryList.comboBoxGetSelectedItem(this.groupNameEditor));
            }
        } else {
            if (bp != null) {
                bp.setShallow(true);
                switch (this.currentType) {
                    case 0: {
                        bp.setPackageFileLine(this.packageHistoryList.comboBoxGetSelectedItem(this.packageEditor), this.fileHistoryList.comboBoxGetSelectedItem(this.fileEditor), Integer.parseInt(this.lineTextField.getText()));
                        break;
                    }
                    case 1: {
                        bp.setMethod(this.methodHistoryList.comboBoxGetSelectedItem(this.methodEditor));
                        break;
                    }
                    case 2: {
                        if (this.exceptionEditor.getText().length() == 0) {
                            this.exceptionEditor.setText("java.lang.Throwable");
                        }
                        bp.setException(this.exceptionHistoryList.comboBoxGetSelectedItem(this.exceptionEditor), this.caughtCheckBox.isSelected(), this.uncaughtCheckBox.isSelected());
                        break;
                    }
                    case 4: {
                        bp.setClassName(this.classHistoryList.comboBoxGetSelectedItem(this.classEditor));
                        break;
                    }
                    case 5: {
                        bp.setURLLine(this.urlTextField.getURL(), Integer.parseInt(this.lineTextField2.getText()));
                        break;
                    }
                    case 6: {
                        bp.setWatchpoint(this.watchpointClassHistoryList.comboBoxGetSelectedItem(this.watchpointClassEditor), this.watchpointFieldHistoryList.comboBoxGetSelectedItem(this.watchpointFieldEditor), this.accessCheckBox.isSelected(), this.modifyCheckBox.isSelected());
                        break;
                    }
                }
            } else {
                lastType = this.currentType;
                switch (this.currentType) {
                    case 0: {
                        bp = new Breakpoint(this.ownerURL, this.currentType, this.packageHistoryList.comboBoxGetSelectedItem(this.packageEditor), this.fileHistoryList.comboBoxGetSelectedItem(this.fileEditor), Integer.parseInt(this.lineTextField.getText()));
                        break;
                    }
                    case 1: {
                        bp = new Breakpoint(this.ownerURL, this.currentType, this.methodHistoryList.comboBoxGetSelectedItem(this.methodEditor));
                        break;
                    }
                    case 2: {
                        if (this.exceptionEditor.getText().length() == 0) {
                            this.exceptionEditor.setText("java.lang.Throwable");
                        }
                        bp = new Breakpoint(this.ownerURL, this.currentType, this.exceptionHistoryList.comboBoxGetSelectedItem(this.exceptionEditor), this.caughtCheckBox.isSelected(), this.uncaughtCheckBox.isSelected());
                        break;
                    }
                    case 4: {
                        bp = new Breakpoint(this.ownerURL, this.currentType, this.classHistoryList.comboBoxGetSelectedItem(this.classEditor));
                        break;
                    }
                    case 5: {
                        bp = new Breakpoint(this.ownerURL, this.currentType, this.urlTextField.getURL(), Integer.parseInt(this.lineTextField2.getText()));
                        break;
                    }
                    case 6: {
                        bp = new Breakpoint(this.ownerURL, this.currentType, this.watchpointClassHistoryList.comboBoxGetSelectedItem(this.watchpointClassEditor), this.watchpointFieldHistoryList.comboBoxGetSelectedItem(this.watchpointFieldEditor), this.accessCheckBox.isSelected(), this.modifyCheckBox.isSelected());
                    }
                }
                bp.setShallow(true);
            }
            bp.setGroupName(this.groupNameHistoryList.comboBoxGetSelectedItem(this.groupNameEditor));
        }
        return bp;
    }

    private void doOkForConditions(Breakpoint bp) {
        bp.setCondition(this.conditionHistoryList.comboBoxGetSelectedItem(this.conditionEditor));
        if (this.radioOneThread.isSelected()) {
            bp.setThreadName(this.threadHistoryList.comboBoxGetSelectedItem(this.threadEditor));
        } else {
            bp.setThreadName(null);
        }
        if (this.radioNotThread.isSelected()) {
            bp.setThreadNameNot(this.notThreadHistoryList.comboBoxGetSelectedItem(this.notThreadEditor));
        } else {
            bp.setThreadNameNot(null);
        }
        bp.setPassCount(this.passCountBox.getIntValue());
    }

    private void doOkForActions(Breakpoint bp) {
        this.bpActionsPanel.commitTo(bp, BreakpointsWindowSettings.getInstance());
    }

    public void cancel() {
        this.setVisible(false);
    }

    public void stateChanged(ChangeEvent e) {
        Component comp = this.tabbedPane.getSelectedComponent();
        String topic = comp == this.definitionPane ? "f1_deb_new_edit_breakptdialog_html" : (comp == this.conditionsPane ? "f1_deb_new_edit_breakpt_conditions_html" : (comp == this.actionsPane ? "f1_deb_new_edit_breakpt_actions_html" : "f1_deb_new_edit_breakptdialog_html"));
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, topic);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.radioAllThreads) {
            this.threadComboBox.setEnabled(false);
            this.notThreadComboBox.setEnabled(false);
        } else if (source == this.radioOneThread) {
            this.threadComboBox.setEnabled(true);
            this.notThreadComboBox.setEnabled(false);
        } else if (source == this.radioNotThread) {
            this.threadComboBox.setEnabled(false);
            this.notThreadComboBox.setEnabled(true);
        } else if (source == this.exceptionBrowseButton) {
            JavaManager javaManager = JavaManager.getJavaManager((Project)this.jproject);
            JavaClass throwableClass = javaManager.getClass("java.lang.Throwable");
            2 filter = new 2(this, throwableClass);
            String s = ClassPackageBrowserV2.browseClassOrPackage((Component)this, this.jproject, 2, filter);
            if (s != null) {
                this.exceptionEditor.setText(s);
            }
        } else if (source == this.classBrowseButton) {
            String s = ClassPackageBrowserV2.browseClassOrPackage(this, this.jproject, 2);
            if (s != null) {
                this.classEditor.setText(s);
            }
        } else if (source == this.watchpointClassBrowseButton) {
            String s = ClassPackageBrowserV2.browseClassOrPackage(this, this.jproject, 2);
            if (s != null) {
                this.watchpointClassEditor.setText(s);
            }
        } else if (source == this.groupNameComboBox) {
            this.groupNameEditor.setText((String)this.groupNameComboBox.getSelectedItem());
        } else if (source == this.packageComboBox) {
            this.packageEditor.setText((String)this.packageComboBox.getSelectedItem());
        } else if (source == this.fileComboBox) {
            this.fileEditor.setText((String)this.fileComboBox.getSelectedItem());
        } else if (source == this.methodComboBox) {
            this.methodEditor.setText((String)this.methodComboBox.getSelectedItem());
        } else if (source == this.exceptionComboBox) {
            this.exceptionEditor.setText((String)this.exceptionComboBox.getSelectedItem());
        } else if (source == this.classComboBox) {
            this.classEditor.setText((String)this.classComboBox.getSelectedItem());
        } else if (source == this.groupNameComboBox) {
            this.groupNameEditor.setText((String)this.groupNameComboBox.getSelectedItem());
        } else if (source == this.conditionComboBox) {
            this.conditionEditor.setText((String)this.conditionComboBox.getSelectedItem());
        } else if (source == this.threadComboBox) {
            this.threadEditor.setText((String)this.threadComboBox.getSelectedItem());
        } else if (source == this.notThreadComboBox) {
            this.notThreadEditor.setText((String)this.notThreadComboBox.getSelectedItem());
        }
    }

    public void changedUpdate(DocumentEvent e) {
        this.enableOk();
    }

    public void insertUpdate(DocumentEvent e) {
        this.enableOk();
    }

    public void removeUpdate(DocumentEvent e) {
        this.enableOk();
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.typeComboBox) {
            BreakpointTypeItem item = (BreakpointTypeItem)this.typeComboBox.getSelectedItem();
            this.currentType = item.breakpointType;
            this.definitionCardPanel.showCard(Integer.toString(this.currentType));
            this.typeChanged();
            this.enableOk();
        } else if (source == this.groupNameCheckBox) {
            boolean enabled = this.groupNameCheckBox.isSelected();
            this.groupNameLabel.setEnabled(enabled);
            this.groupNameComboBox.setEnabled(enabled);
            this.enableOk();
        } else if (source == this.radioAllThreads || source == this.radioOneThread || source == this.radioNotThread) {
            this.enableOk();
        }
    }

    static JPanel mav$makePackageFileLineCard(BreakpointOptionsDialog breakpointOptionsDialog) {
        return breakpointOptionsDialog.makePackageFileLineCard();
    }

    static JPanel mav$makeExceptionCard(BreakpointOptionsDialog breakpointOptionsDialog) {
        return breakpointOptionsDialog.makeExceptionCard();
    }

    static JPanel mav$makeMethodCard(BreakpointOptionsDialog breakpointOptionsDialog) {
        return breakpointOptionsDialog.makeMethodCard();
    }

    static JPanel mav$makeMethodOffsetCard(BreakpointOptionsDialog breakpointOptionsDialog) {
        return breakpointOptionsDialog.makeMethodOffsetCard();
    }

    static JPanel mav$makeClassCard(BreakpointOptionsDialog breakpointOptionsDialog) {
        return breakpointOptionsDialog.makeClassCard();
    }

    static JPanel mav$makeURLLineCard(BreakpointOptionsDialog breakpointOptionsDialog) {
        return breakpointOptionsDialog.makeURLLineCard();
    }

    static JPanel mav$makeDeadlockCard(BreakpointOptionsDialog breakpointOptionsDialog) {
        return breakpointOptionsDialog.makeDeadlockCard();
    }

    static JPanel mav$makeWatchpointCard(BreakpointOptionsDialog breakpointOptionsDialog) {
        return breakpointOptionsDialog.makeWatchpointCard();
    }

    static boolean mav$veto(BreakpointOptionsDialog breakpointOptionsDialog) {
        return breakpointOptionsDialog.veto();
    }

    static void mav$doOk(BreakpointOptionsDialog breakpointOptionsDialog) {
        breakpointOptionsDialog.doOk();
    }

    final class 1
    implements VetoableChangeListener {
        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                if (BreakpointOptionsDialog.mav$veto(BreakpointOptionsDialog.this)) {
                    throw new PropertyVetoException("no", evt);
                }
                BreakpointOptionsDialog.mav$doOk(BreakpointOptionsDialog.this);
            }
        }
    }

    private class BreakpointTypeItem {
        final int breakpointType;
        String name;
        final JPanel panel;

        BreakpointTypeItem(int breakpointType) {
            this(breakpointType, null);
        }

        BreakpointTypeItem(int breakpointType, String typeStringOverride) {
            this.breakpointType = breakpointType;
            switch (breakpointType) {
                default: {
                    this.name = DbgArb.getString(135);
                    this.panel = BreakpointOptionsDialog.mav$makePackageFileLineCard(BreakpointOptionsDialog.this);
                    break;
                }
                case 2: {
                    this.name = DbgArb.getString(481);
                    this.panel = BreakpointOptionsDialog.mav$makeExceptionCard(BreakpointOptionsDialog.this);
                    break;
                }
                case 1: {
                    this.name = DbgArb.getString(155);
                    this.panel = BreakpointOptionsDialog.mav$makeMethodCard(BreakpointOptionsDialog.this);
                    break;
                }
                case 7: {
                    this.name = DbgArb.getString(314);
                    this.panel = BreakpointOptionsDialog.mav$makeMethodOffsetCard(BreakpointOptionsDialog.this);
                    break;
                }
                case 4: {
                    this.name = DbgArb.getString(383);
                    this.panel = BreakpointOptionsDialog.mav$makeClassCard(BreakpointOptionsDialog.this);
                    break;
                }
                case 5: {
                    this.name = DbgArb.getString(815);
                    this.panel = BreakpointOptionsDialog.mav$makeURLLineCard(BreakpointOptionsDialog.this);
                    break;
                }
                case 3: {
                    this.name = DbgArb.getString(917);
                    this.panel = BreakpointOptionsDialog.mav$makeDeadlockCard(BreakpointOptionsDialog.this);
                    break;
                }
                case 6: {
                    this.name = DbgArb.getString(108);
                    this.panel = BreakpointOptionsDialog.mav$makeWatchpointCard(BreakpointOptionsDialog.this);
                    break;
                }
            }
            if (typeStringOverride != null) {
                this.name = typeStringOverride;
            }
        }

        public String toString() {
            return this.name;
        }
    }

    final class 2
    implements ClassPackageBrowserFilterV2 {
        private final /* synthetic */ JavaClass v$throwableClass;
        final /* synthetic */ BreakpointOptionsDialog this$0;

        public boolean acceptPackage(String pkg) {
            return true;
        }

        public boolean acceptClass(JavaClass cls) {
            if (this.v$throwableClass != null) {
                return this.v$throwableClass.isAssignableFrom((JavaType)cls);
            }
            return true;
        }

        public 2(BreakpointOptionsDialog breakpointOptionsDialog, JavaClass javaClass) {
            this.v$throwableClass = javaClass;
            this.this$0 = breakpointOptionsDialog;
        }
    }

    private final class CardPanel
    extends JPanel
    implements LayoutManager {
        public CardPanel() {
            this.setLayout(this);
        }

        public void addLayoutComponent(String name, Component child) {
            if (name != null) {
                child.setName(name);
            }
            child.setVisible(child.getParent().getComponentCount() == 1);
        }

        public void removeLayoutComponent(Component child) {
            Container parent;
            if (child.isVisible() && (parent = child.getParent()).getComponentCount() > 0) {
                parent.getComponent(0).setVisible(true);
            }
        }

        public Dimension preferredLayoutSize(Container parent) {
            int nChildren = parent.getComponentCount();
            Insets insets = parent.getInsets();
            int width = insets.left + insets.right;
            int height = insets.top + insets.bottom;
            int i = 0;
            while (i < nChildren) {
                Dimension d = parent.getComponent(i).getPreferredSize();
                if (d.width + insets.left + insets.right > width) {
                    width = d.width + insets.left + insets.right;
                }
                if (d.height + insets.top + insets.bottom > height) {
                    height = d.height + insets.top + insets.bottom;
                }
                ++i;
            }
            return new Dimension(width, height);
        }

        public Dimension minimumLayoutSize(Container parent) {
            int nChildren = parent.getComponentCount();
            Insets insets = parent.getInsets();
            int width = insets.left + insets.right;
            int height = insets.top + insets.bottom;
            int i = 0;
            while (i < nChildren) {
                Dimension d = parent.getComponent(i).getMinimumSize();
                if (d.width + insets.left + insets.right > width) {
                    width = d.width + insets.left + insets.right;
                }
                if (d.height + insets.top + insets.bottom > height) {
                    height = d.height + insets.top + insets.bottom;
                }
                ++i;
            }
            return new Dimension(width, height);
        }

        public void layoutContainer(Container parent) {
            int nChildren = parent.getComponentCount();
            Insets insets = parent.getInsets();
            int i = 0;
            while (i < nChildren) {
                Component child = parent.getComponent(i);
                if (child.isVisible()) {
                    Rectangle r = parent.getBounds();
                    int width = r.width - insets.left + insets.right;
                    int height = r.height - insets.top + insets.bottom;
                    Dimension d = child.getPreferredSize();
                    if (d.height < height) {
                        height = d.height;
                    }
                    child.setBounds(insets.left, insets.top, width, height);
                    break;
                }
                ++i;
            }
        }

        public void showCard(String name) {
            int nChildren = this.getComponentCount();
            int i = 0;
            while (i < nChildren) {
                Component child = this.getComponent(i);
                if (child.getName().equals(name)) {
                    child.setVisible(true);
                } else if (child.isVisible()) {
                    child.setVisible(false);
                }
                ++i;
            }
            this.revalidate();
            this.repaint();
        }
    }
}

