/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.AbstractTreeTableModel;
import oracle.ide.controls.JFastTreeTable;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.TreeTableModel;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableWindow;
import oracle.ide.help.HelpInfo;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.layout.Layout;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.peek.CodePeek;
import oracle.ide.peek.Peek;
import oracle.ide.peek.Peekable;
import oracle.ide.runner.DebuggerWindowProvider;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.View;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.runner.Source;
import oracle.jdevimpl.debugger.support.DebugBreakpoint;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.java.Context2ParserHelper;
import oracle.jdevimpl.java.util.JavaCodePeek;
import oracle.jdevimpl.runner.Helpers;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.BaseElement;
import oracle.jdevimpl.runner.debug.Breakpoint;
import oracle.jdevimpl.runner.debug.BreakpointOptionsDialog;
import oracle.jdevimpl.runner.debug.BreakpointsWindowSettings;
import oracle.jdevimpl.runner.debug.ClassesWindow;
import oracle.jdevimpl.runner.debug.ColumnMenuListener;
import oracle.jdevimpl.runner.debug.ContextBuilder;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugDockableFactory;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.DebuggerWindow;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.RunWhilePaused;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BreakpointsWindow
extends DebuggerWindow
implements TreeExpansionListener,
TreeSelectionListener,
DragGestureListener,
DragSourceListener,
DropTargetListener,
Controller,
ContextMenuListener,
ColumnMenuListener {
    private BreakpointTreeTableModel model;
    private JFastTreeTable treeTable;
    private TreeSelectionModel treeSelectionModel;
    private JScrollPane scrollPane;
    private String title;
    private Workspace workspace;
    private Project project;
    private List[] breakpoints;
    private Object lastHighlight;
    private BreakpointsWindowSettings bpSettings;
    private int preferredVisibleRowCount;
    private static final String REMOVE_INSTANCE_FILTER_CMD_PREFIX = "DebugBreakpointsRemoveInstanceFilter";
    private List removeInstanceFilterActions;
    private static IdeAction actionAdd;
    private static IdeAction actionOptions;
    private static IdeAction actionEnable;
    private static IdeAction actionDisable;
    private static IdeAction actionRemove;
    private static IdeAction actionChangeScopeGlobal;
    private static IdeAction actionChangeScopeWorkspace;
    private static IdeAction actionChangeScopeProject;
    private static IdeAction actionGoTo;
    private static IdeAction actionEnableAll;
    private static IdeAction actionDisableAll;
    private static IdeAction actionRemoveAll;
    private static IdeAction actionExpandAll;
    private static IdeAction actionCollapseAll;
    private static IdeAction actionSave;
    private static IdeAction actionSettings;
    private static JMenuItem menuitemAdd;
    private static JMenuItem menuitemOptions;
    private static JMenuItem menuitemEnable;
    private static JMenuItem menuitemDisable;
    private static JMenuItem menuitemRemove;
    private static JMenu subMenuChangeScope;
    private static JMenuItem menuitemChangeScopeGlobal;
    private static JMenuItem menuitemChangeScopeWorkspace;
    private static JMenuItem menuitemChangeScopeProject;
    private static JMenuItem menuitemGoTo;
    private static JMenuItem menuitemEnableAll;
    private static JMenuItem menuitemDisableAll;
    private static JMenuItem menuitemRemoveAll;
    private static JMenuItem menuitemExpandAll;
    private static JMenuItem menuitemCollapseAll;
    private static JMenuItem menuitemSave;
    private static JMenuItem menuitemSettings;
    private static final int ADD_CMD_ID;
    private static final int OPTIONS_CMD_ID;
    private static final int ENABLE_CMD_ID;
    private static final int DISABLE_CMD_ID;
    private static final int REMOVE_CMD_ID;
    private static final int CHANGE_SCOPE_GLOBAL_CMD_ID;
    private static final int CHANGE_SCOPE_WORKSPACE_CMD_ID;
    private static final int CHANGE_SCOPE_PROJECT_CMD_ID;
    private static final int GOTO_CMD_ID;
    private static final int ENABLE_ALL_CMD_ID;
    private static final int DISABLE_ALL_CMD_ID;
    private static final int REMOVE_ALL_CMD_ID;
    private static final int EXPAND_ALL_CMD_ID;
    private static final int COLLAPSE_ALL_CMD_ID;
    private static final int SAVE_CMD_ID;
    private static final int SETTINGS_CMD_ID;
    static final int COLUMN_DESCRIPTION = 0;
    static final int COLUMN_TYPE = 1;
    static final int COLUMN_STATUS = 2;
    static final int COLUMN_SCOPE = 3;
    static final int COLUMN_GROUP = 4;
    static final int COLUMN_CONDITION = 5;
    static final int COLUMN_THREAD = 6;
    static final int COLUMN_PASSCOUNT = 7;
    static final int COLUMN_ACTION = 8;
    static final int COLUMN_INSTANCE_FILTERS = 9;
    static final int NUMBER_OF_COLUMNS = 10;
    private static final String SELECTED_COLUMN = "BreakpointsWindow.ColumnSelected";
    private TableColumn[] column;
    private int[] columnDefaultWidth;
    private boolean[] columnShowing;
    private static DataFlavor breakpointFlavor;
    private static DataFlavor[] transferFlavors;
    static final String BREAKPOINTS_WINDOW_ID = "Debugger.BreakpointsWindow";
    private static Icon breakpointsTabIcon;
    private boolean adjustColumnsAlreadyDone;

    private void $init$() {
        this.preferredVisibleRowCount = 6;
        this.column = new TableColumn[10];
        this.columnDefaultWidth = new int[10];
        this.columnShowing = new boolean[10];
        this.adjustColumnsAlreadyDone = false;
    }

    BreakpointsWindow(Workspace workspace, Project project, List[] breakpoints) {
        super(BREAKPOINTS_WINDOW_ID);
        this.$init$();
        this.workspace = workspace;
        this.project = project;
        this.breakpoints = breakpoints;
        this.title = DbgArb.getString(386);
        JDebugger.getInstance().getContextMenu().addContextMenuListener((ContextMenuListener)this);
        this.removeInstanceFilterActions = new ArrayList();
        BreakpointsWindow.makeActions();
        this.setControllerForActions();
    }

    @Override
    public DebuggerWindowProvider.DebuggerWindowPosition getPosition() {
        return DebuggerWindowProvider.DebuggerWindowPosition.SOUTH;
    }

    @Override
    public void refresh() {
        this.everythingChanged();
    }

    public boolean installByDefault() {
        return true;
    }

    public void shutDown() {
        this.saveSettings();
    }

    private void loadSettings() {
        Assert.precondition((this.treeTable != null ? 1 : 0) != 0, (String)"BreakpointsWindow GUI is null");
        int i = 0;
        while (i < 10) {
            int width = this.bpSettings.getColumnWidth(i);
            if (width != 0) {
                this.adjustColumnsAlreadyDone = true;
                this.column[i].setPreferredWidth(width);
            }
            ++i;
        }
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        String order = this.bpSettings.getColumnOrder();
        if (order != null) {
            int i2 = 0;
            while (i2 < 10) {
                String identifier;
                int comma = order.indexOf(44);
                if (comma != -1) {
                    identifier = order.substring(0, comma);
                    order = order.substring(comma + 1);
                } else {
                    identifier = order;
                }
                if (identifier.length() == 0) break;
                try {
                    int from = tableColumnModel.getColumnIndex(identifier);
                    if (from != i2) {
                        this.treeTable.moveColumn(from, i2);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                ++i2;
            }
        }
    }

    private void breakpointsWindowSettingsChanged(boolean changed) {
        if (this.treeTable == null) {
            return;
        }
        int i = 1;
        while (i < 10) {
            boolean columnVisible = this.bpSettings.getColumnVisible(i);
            if (this.columnShowing[i] != columnVisible) {
                this.columnShowing[i] = columnVisible;
                if (columnVisible) {
                    this.treeTable.addColumn(this.column[i]);
                } else {
                    this.treeTable.removeColumn(this.column[i]);
                }
            }
            ++i;
        }
        if (changed) {
            SwingUtilities.invokeLater(new 1());
        }
        Dimension d = this.treeTable.getPreferredSize();
        d.height = this.treeTable.getTableHeader().getPreferredSize().height + this.preferredVisibleRowCount * this.treeTable.getRowHeight() + this.scrollPane.getHorizontalScrollBar().getPreferredSize().height;
        this.scrollPane.setPreferredSize(d);
    }

    private void saveSettings() {
        if (this.treeTable == null) {
            return;
        }
        int i = 0;
        while (i < 10) {
            this.bpSettings.setColumnWidth(i, this.column[i].getWidth());
            ++i;
        }
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        String order = "";
        Enumeration<TableColumn> e = tableColumnModel.getColumns();
        while (e.hasMoreElements()) {
            TableColumn column = e.nextElement();
            order = order + column.getIdentifier() + ",";
        }
        this.bpSettings.setColumnOrder(order);
    }

    static void addContextMenuToMainMenu(Menubar menubar, JMenu subMenu) {
        BreakpointsWindow.makeActions();
        float section = 1.0f;
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionAdd), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionOptions), subMenu, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionEnable), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDisable), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionRemove), subMenu, section);
        JMenu subMenuChangeScope = menubar.createSubMenu(DbgArb.getString(916), DbgArb.getInteger(519));
        JMenuItem menuItemChangeScopeGlobal = menubar.createMenuItem((ToggleAction)actionChangeScopeGlobal);
        JMenuItem menuItemChangeScopeWorkspace = menubar.createMenuItem((ToggleAction)actionChangeScopeWorkspace);
        JMenuItem menuItemChangeScopeProject = menubar.createMenuItem((ToggleAction)actionChangeScopeProject);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(menuItemChangeScopeGlobal);
        buttonGroup.add(menuItemChangeScopeWorkspace);
        buttonGroup.add(menuItemChangeScopeProject);
        subMenuChangeScope.add(menuItemChangeScopeGlobal);
        subMenuChangeScope.add(menuItemChangeScopeWorkspace);
        subMenuChangeScope.add(menuItemChangeScopeProject);
        menubar.add((Component)subMenuChangeScope, subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGoTo), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionEnableAll), subMenu, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDisableAll), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionRemoveAll), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionExpandAll), subMenu, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionCollapseAll), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSave), subMenu, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSettings), subMenu, section);
    }

    public Component getGUI() {
        if (this.scrollPane == null) {
            this.bpSettings = BreakpointsWindowSettings.getInstance();
            this.createGUI();
            this.loadSettings();
            this.breakpointsWindowSettingsChanged(false);
            DebugDockableFactory.updateSiteGeometry((Dockable)this);
            this.everythingChanged();
            this.bpSettings.addStructureChangeListener(new 2());
        }
        return this.scrollPane;
    }

    public ContextMenu getContextMenu() {
        return JDebugger.getInstance().getContextMenu();
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_deb_breakpointwindow_html");
    }

    public Controller getController() {
        return this;
    }

    public Context getContext(EventObject event) {
        BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model != null ? this.model.getSelectedBreakpointItem() : null;
        return ContextBuilder.buildContext((Element)breakpointItem, (View)this, event, this.workspace, this.project);
    }

    public int getDefaultVisibility(Layout layout) {
        if (JDebugger.isDebuggingLayout(layout)) {
            return 1;
        }
        return 0;
    }

    public String getTabName() {
        return this.title;
    }

    public Icon getTabIcon() {
        if (breakpointsTabIcon == null) {
            breakpointsTabIcon = DbgArb.getIcon(903);
        }
        return breakpointsTabIcon;
    }

    public String getTitleName() {
        return this.title;
    }

    public DropTargetListener getTabDropListener() {
        return this;
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        Assert.precondition((this.model != null ? 1 : 0) != 0, (String)"BreakpointsWindow GUI is null");
        this.model.branchExpanded(event.getPath());
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        Assert.precondition((this.model != null ? 1 : 0) != 0, (String)"BreakpointsWindow GUI is null");
        this.model.branchCollapsed(event.getPath());
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        Assert.precondition((this.treeTable != null ? 1 : 0) != 0, (String)"BreakpointsWindow GUI is null");
        TreePath treePath = this.treeSelectionModel.getLeadSelectionPath();
        this.lastHighlight = treePath != null ? this.model.getInfoFromTreePath(treePath) : null;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        Point pt;
        BreakpointTreeTableModel.BreakpointItem breakpointItem;
        Assert.precondition((this.model != null ? 1 : 0) != 0, (String)"BreakpointsWindow GUI is null");
        if (e.getDragAction() == 2 && (breakpointItem = this.model.getBreakpointItemForDrag(pt = e.getDragOrigin())) != null) {
            try {
                BufferedImage dragImage = new BufferedImage(1, 1, 6);
                dragImage.setRGB(0, 0, -16777216);
                Point imageOffset = new Point(0, 0);
                e.startDrag(null, dragImage, imageOffset, breakpointItem, this);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent e) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent e) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent e) {
    }

    @Override
    public void dragExit(DragSourceEvent e) {
    }

    @Override
    public void dragOver(DragSourceDragEvent e) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        this.checkDrag(e);
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        this.checkDrag(e);
    }

    @Override
    public void dragExit(DropTargetEvent e) {
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        this.checkDrop(e);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    private void checkDrag(DropTargetDragEvent e) {
        Assert.precondition((this.treeTable != null ? 1 : 0) != 0, (String)"BreakpointsWindow GUI is null");
        if (e.isDataFlavorSupported(BreakpointsWindow.getBreakpointFlavor())) {
            e.acceptDrag(2);
            return;
        }
        if (e.isDataFlavorSupported(ClassesWindow.getClassFlavor())) {
            e.acceptDrag(1);
            return;
        }
        if (e.isDataFlavorSupported(DataPanel.getHeapObjectFlavor())) {
            try {
                DebuggingProcess debuggingProcess = JDebugger.getInstance().getActiveDebuggingProcess();
                if (debuggingProcess != null) {
                    DebugBreakpoint dbp;
                    BreakpointTreeTableModel.BreakpointItem breakpointItem;
                    Point pt = null;
                    if (e.getDropTargetContext().getDropTarget().getComponent() == this.treeTable) {
                        pt = e.getLocation();
                    }
                    if (this.model.getColumnAtPoint(pt) == 9 && (breakpointItem = this.model.getBreakpointItemAtPoint(pt)) != null && breakpointItem.isBreakpoint() && (dbp = breakpointItem.getBreakpoint().getDebugBreakpoint(debuggingProcess)) != null) {
                        e.acceptDrag(1);
                        return;
                    }
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        e.rejectDrag();
    }

    private void checkDrop(DropTargetDropEvent e) {
        Assert.precondition((this.treeTable != null ? 1 : 0) != 0, (String)"BreakpointsWindow GUI is null");
        if (e.isLocalTransfer()) {
            if (e.isDataFlavorSupported(BreakpointsWindow.getBreakpointFlavor())) {
                try {
                    Point pt = null;
                    if (e.getDropTargetContext().getDropTarget().getComponent() == this.treeTable) {
                        pt = e.getLocation();
                    }
                    String groupName = this.model.getGroupNameAtPoint(pt);
                    Transferable t = e.getTransferable();
                    BreakpointTreeTableModel.BreakpointItem breakpointItem = (BreakpointTreeTableModel.BreakpointItem)t.getTransferData(BreakpointsWindow.getBreakpointFlavor());
                    if (breakpointItem.isMulti()) {
                        List list = breakpointItem.getBreakpoints(null);
                        int i = list.size() - 1;
                        while (i >= 0) {
                            Breakpoint bp = (Breakpoint)list.get(i);
                            bp.setGroupName(groupName);
                            --i;
                        }
                    } else {
                        Breakpoint bp = breakpointItem.getBreakpoint();
                        bp.setGroupName(groupName);
                    }
                    this.everythingChanged();
                    e.acceptDrop(2);
                    e.getDropTargetContext().dropComplete(true);
                    return;
                }
                catch (Exception ex) {}
            } else if (e.isDataFlavorSupported(ClassesWindow.getClassFlavor())) {
                try {
                    String groupName;
                    Transferable t = e.getTransferable();
                    ClassesWindow.ClassFlavorData data = (ClassesWindow.ClassFlavorData)t.getTransferData(ClassesWindow.getClassFlavor());
                    String className = data.getName();
                    URL ownerURL = JDebugger.getNewBreakpointOwnerURL(this.workspace, this.project);
                    Breakpoint bp = new Breakpoint(ownerURL, 4, className);
                    Point pt = null;
                    if (e.getDropTargetContext().getDropTarget().getComponent() == this.treeTable) {
                        pt = e.getLocation();
                    }
                    if ((groupName = this.model.getGroupNameAtPoint(pt)) != null) {
                        bp.setGroupName(groupName);
                    }
                    this.addNewBreakpoint(bp);
                    JDebugger.getInstance().viewBreakpoints();
                    e.acceptDrop(1);
                    e.getDropTargetContext().dropComplete(true);
                    return;
                }
                catch (Exception ex) {}
            } else if (e.isDataFlavorSupported(DataPanel.getHeapObjectFlavor())) {
                try {
                    DebuggingProcess debuggingProcess = JDebugger.getInstance().getActiveDebuggingProcess();
                    if (debuggingProcess != null) {
                        HashSet classNames;
                        DebugDataObjectInfo dataObject;
                        Transferable t;
                        Object o;
                        DebugBreakpoint dbp;
                        BreakpointTreeTableModel.BreakpointItem breakpointItem;
                        Point pt = null;
                        if (e.getDropTargetContext().getDropTarget().getComponent() == this.treeTable) {
                            pt = e.getLocation();
                        }
                        if (this.model.getColumnAtPoint(pt) == 9 && (breakpointItem = this.model.getBreakpointItemAtPoint(pt)) != null && breakpointItem.isBreakpoint() && (dbp = breakpointItem.getBreakpoint().getDebugBreakpoint(debuggingProcess)) != null && (o = (t = e.getTransferable()).getTransferData(DataPanel.getHeapObjectFlavor())) instanceof DebugDataObjectInfo && dbp.isInstanceFilterAppropriate(dataObject = (DebugDataObjectInfo)o, classNames = new HashSet()) && !dbp.isInstanceFilterSet(dataObject)) {
                            dbp.addInstanceFilter(dataObject);
                            this.updateColumn(9);
                            e.acceptDrop(1);
                            e.getDropTargetContext().dropComplete(true);
                            return;
                        }
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        e.rejectDrop();
    }

    public boolean handleEvent(IdeAction action, Context context) {
        Long uniqueID;
        Assert.precondition((this.treeTable != null ? 1 : 0) != 0, (String)"BreakpointsWindow GUI is null");
        int cmdId = action.getCommandId();
        if (cmdId == GOTO_CMD_ID) {
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            if (breakpointItem != null) {
                breakpointItem.showInSource();
            }
            return true;
        }
        if (cmdId == DISABLE_CMD_ID) {
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            if (breakpointItem != null) {
                breakpointItem.disable();
                this.updateColumn(2);
            }
            return true;
        }
        if (cmdId == ENABLE_CMD_ID) {
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            if (breakpointItem != null) {
                breakpointItem.enable();
                this.updateColumn(2);
            }
            return true;
        }
        if (cmdId == REMOVE_CMD_ID) {
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            if (breakpointItem != null) {
                JTree tree = this.treeTable.getTree();
                int row = tree.getRowForPath(this.treeSelectionModel.getLeadSelectionPath());
                breakpointItem.remove();
                this.everythingChanged(null);
                int count = tree.getRowCount();
                if (row < count) {
                    this.model.highlightRow(row);
                } else if (0 <= --row && row < count) {
                    this.model.highlightRow(row);
                }
            }
            return true;
        }
        if (cmdId == OPTIONS_CMD_ID) {
            int selectedColumn = 0;
            if (context != null) {
                selectedColumn = context.getInt(SELECTED_COLUMN);
            }
            this.editBreakpointDialog(selectedColumn);
            return true;
        }
        if (cmdId == CHANGE_SCOPE_GLOBAL_CMD_ID || cmdId == CHANGE_SCOPE_WORKSPACE_CMD_ID || cmdId == CHANGE_SCOPE_PROJECT_CMD_ID) {
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            if (breakpointItem != null) {
                breakpointItem.changeScope(cmdId);
                this.updateColumn(3);
            }
            return true;
        }
        if (cmdId == ADD_CMD_ID) {
            this.addBreakpointDialog();
            return true;
        }
        if (cmdId == DISABLE_ALL_CMD_ID) {
            this.disableAll();
            this.updateColumn(2);
            return true;
        }
        if (cmdId == ENABLE_ALL_CMD_ID) {
            this.enableAll();
            this.updateColumn(2);
            return true;
        }
        if (cmdId == REMOVE_ALL_CMD_ID) {
            this.removeAll();
            this.everythingChanged();
            return true;
        }
        if (cmdId == SETTINGS_CMD_ID) {
            String[] path = new String[]{DbgArb.getString(16), DbgArb.getString(554)};
            Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), path);
            return true;
        }
        if (cmdId == EXPAND_ALL_CMD_ID) {
            if (this.anyBreakpoints()) {
                BreakpointTreeTableModel.mav$expandAll(this.model);
            }
            return true;
        }
        if (cmdId == COLLAPSE_ALL_CMD_ID) {
            if (this.anyBreakpoints()) {
                BreakpointTreeTableModel.mav$collapseAll(this.model);
            }
            return true;
        }
        if (cmdId == SAVE_CMD_ID) {
            this.saveToFile();
            return true;
        }
        if (cmdId == 18) {
            Object o;
            int column;
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            if (breakpointItem != null && (column = this.treeTable.getSelectedColumn()) != -1 && (o = this.model.getValueAt(breakpointItem, column)) != null) {
                IdeUtil.copyToClipboard((String)o.toString());
            }
            return true;
        }
        if (this.removeInstanceFilterActions.contains(action) && (uniqueID = (Long)action.getValue("UserData")) != null) {
            BreakpointTreeTableModel.BreakpointItem breakpointItem;
            DebuggingProcess debuggingProcess = JDebugger.getInstance().getActiveDebuggingProcess();
            if (debuggingProcess != null && (breakpointItem = this.model.getSelectedBreakpointItem()) != null && breakpointItem.isBreakpoint()) {
                Breakpoint bp = breakpointItem.getBreakpoint();
                long id = uniqueID;
                debuggingProcess.runWhilePaused(new 3(this, bp, id));
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        Long uniqueID;
        if (!(action.getValue("Debugger.actionOwner") != this || this.treeTable != null && this.isVisible())) {
            action.setEnabled(false);
            return true;
        }
        Assert.precondition((this.treeTable != null ? 1 : 0) != 0, (String)"BreakpointsWindow GUI is null");
        int cmdId = action.getCommandId();
        if (cmdId == GOTO_CMD_ID) {
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            if (breakpointItem != null) {
                action.setEnabled(breakpointItem.canShowInSource());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == DISABLE_CMD_ID) {
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            if (breakpointItem != null) {
                if (breakpointItem.isGroup()) {
                    action.putValue("Name", (Object)DbgArb.getString(770));
                } else {
                    action.putValue("Name", (Object)DbgArb.getString(243));
                }
                action.setEnabled(breakpointItem.canDisable());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == ENABLE_CMD_ID) {
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            if (breakpointItem != null) {
                if (breakpointItem.isGroup()) {
                    action.putValue("Name", (Object)DbgArb.getString(115));
                } else {
                    action.putValue("Name", (Object)DbgArb.getString(862));
                }
                action.setEnabled(breakpointItem.canEnable());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == REMOVE_CMD_ID) {
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            if (breakpointItem != null) {
                if (breakpointItem.isGroup()) {
                    action.putValue("Name", (Object)DbgArb.getString(590));
                } else {
                    action.putValue("Name", (Object)DbgArb.getString(688));
                }
                action.setEnabled(breakpointItem.canRemove());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == OPTIONS_CMD_ID) {
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            if (breakpointItem != null) {
                if (breakpointItem.isGroup()) {
                    action.putValue("Name", (Object)DbgArb.getString(461));
                } else {
                    action.putValue("Name", (Object)DbgArb.getString(126));
                }
                action.setEnabled(breakpointItem.canEditOptions());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == CHANGE_SCOPE_GLOBAL_CMD_ID || cmdId == CHANGE_SCOPE_WORKSPACE_CMD_ID || cmdId == CHANGE_SCOPE_PROJECT_CMD_ID) {
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            if (breakpointItem != null) {
                action.setState(breakpointItem.isScope(cmdId));
                action.setEnabled(breakpointItem.canChangeScope(cmdId));
            } else {
                action.setState(false);
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == ADD_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        if (cmdId == DISABLE_ALL_CMD_ID || cmdId == ENABLE_ALL_CMD_ID || cmdId == REMOVE_ALL_CMD_ID) {
            action.setEnabled(this.anyBreakpoints());
            return true;
        }
        if (cmdId == SETTINGS_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        if (cmdId == EXPAND_ALL_CMD_ID || cmdId == COLLAPSE_ALL_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        if (cmdId == SAVE_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        if (cmdId == 18) {
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            int column = this.treeTable.getSelectedColumn();
            action.setEnabled(breakpointItem != null && column != -1);
            return true;
        }
        if (this.removeInstanceFilterActions.contains(action) && (uniqueID = (Long)action.getValue("UserData")) != null) {
            DebugBreakpoint dbp;
            BreakpointTreeTableModel.BreakpointItem breakpointItem;
            DebuggingProcess debuggingProcess = JDebugger.getInstance().getActiveDebuggingProcess();
            if (debuggingProcess != null && (breakpointItem = this.model.getSelectedBreakpointItem()) != null && breakpointItem.isBreakpoint() && (dbp = breakpointItem.getBreakpoint().getDebugBreakpoint(debuggingProcess)) != null) {
                action.setEnabled(true);
            }
            return true;
        }
        return false;
    }

    public void menuWillShow(ContextMenu popup) {
        Context context = popup.getContext();
        if (this.treeTable != null && (Helpers.contextMatchesSource(context, this.treeTable) || Helpers.contextMatchesSource(context, this.scrollPane))) {
            this.addPopupMenuItemsForNew(popup, context);
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            if (breakpointItem != null) {
                this.addPopupMenuItemsForBreakpointItem(popup, context);
            }
            this.addPopupMenuItemsForBreakpoints(popup, context);
            this.addPopupMenuItemsForTreeTable(popup, context);
            this.addPopupMenuItemsForCommon(popup, context);
        }
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    @Override
    public void showColumn(int index) {
        if (index != 0) {
            this.columnShowing[index] = true;
            if (this.bpSettings != null) {
                this.bpSettings.setColumnVisible(index, true);
            }
            this.treeTable.addColumn(this.column[index]);
        }
    }

    @Override
    public void hideColumn(int index) {
        if (index != 0) {
            this.columnShowing[index] = false;
            if (this.bpSettings != null) {
                this.bpSettings.setColumnVisible(index, false);
            }
            this.treeTable.removeColumn(this.column[index]);
        }
    }

    private void createGUI() {
        List modelRoot = Collections.synchronizedList(new ArrayList());
        this.model = new BreakpointTreeTableModel(modelRoot);
        this.treeTable = new PeekableTreeTable(this.model);
        this.treeTable.setKeySearchNavigable(true);
        this.treeTable.getAccessibleContext().setAccessibleName(this.getTitleName());
        this.treeTable.setAutoResizeMode(DebugWindowSettings.getInstance().getTableResizeMode());
        Set emptySet = Collections.emptySet();
        this.treeTable.setFocusTraversalKeys(0, emptySet);
        this.treeTable.setFocusTraversalKeys(1, emptySet);
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        int i = 0;
        while (i < 10) {
            this.column[i] = tableColumnModel.getColumn(i);
            this.columnDefaultWidth[i] = this.column[i].getPreferredWidth();
            this.columnShowing[i] = true;
            ++i;
        }
        boolean[] showColumnInMenu = new boolean[10];
        Arrays.fill(showColumnInMenu, true);
        showColumnInMenu[0] = false;
        JDebugger.addColumnsMenu((JTable)this.treeTable, this, showColumnInMenu);
        this.column[7].setCellEditor(new PassCountEditor());
        this.treeTable.getSelectionModel().setSelectionMode(2);
        JTree tree = this.treeTable.getTree();
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        this.treeSelectionModel = tree.getSelectionModel();
        this.treeSelectionModel.setSelectionMode(4);
        tree.addTreeExpansionListener(this);
        tree.addTreeSelectionListener(this);
        tree.setCellRenderer(new 4());
        this.treeTable.setDefaultRenderer(String.class, (TableCellRenderer)new 5());
        JTableHeader tableHeader = this.treeTable.getTableHeader();
        TableCellRenderer headerRenderer = tableHeader.getDefaultRenderer();
        tableHeader.setDefaultRenderer(new 6(this, headerRenderer));
        this.treeTable.addMouseListener((MouseListener)new 7());
        this.treeTable.addKeyListener((KeyListener)new 8());
        KeyStroke[] keyStrokes = new KeyStroke[]{KeyStroke.getKeyStroke(27, 0)};
        KeyUtil.removeKeyStrokesFromInputMaps((JComponent)this.treeTable, (KeyStroke[])keyStrokes);
        this.scrollPane = new JScrollPane((Component)this.treeTable);
        Color background = this.treeTable.getBackground();
        this.scrollPane.setBackground(background);
        this.scrollPane.getViewport().setBackground(background);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.addMouseListener(new 9());
        this.scrollPane.addComponentListener(new 10());
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer((Component)this.treeTable, 2, this);
        new DropTarget((Component)this.treeTable, 3, this);
        new DropTarget(this.scrollPane.getViewport(), 3, this);
        new DropTarget(this.scrollPane, 3, this);
    }

    private void adjustColumnsAfterResize() {
        Assert.precondition((this.treeTable != null ? 1 : 0) != 0, (String)"BreakpointsWindow GUI is null");
        if (this.adjustColumnsAlreadyDone) {
            return;
        }
        this.adjustColumnsAlreadyDone = true;
        JDebugger.adjustColumnsAfterResize(this.scrollPane, (JTable)this.treeTable);
    }

    private static void makeActions() {
        if (actionGoTo == null) {
            actionGoTo = IdeAction.get((int)GOTO_CMD_ID, null, (String)DbgArb.getString(448), null, (Integer)DbgArb.getInteger(821), null, (int)-1, null, (boolean)false);
            actionGoTo.setEnabled(false);
            actionDisable = IdeAction.get((int)DISABLE_CMD_ID, null, (String)DbgArb.getString(243), null, (Integer)DbgArb.getInteger(366), null, (int)-1, null, (boolean)false);
            actionDisable.setEnabled(false);
            actionEnable = IdeAction.get((int)ENABLE_CMD_ID, null, (String)DbgArb.getString(862), null, (Integer)DbgArb.getInteger(600), null, (int)-1, null, (boolean)false);
            actionEnable.setEnabled(false);
            actionRemove = IdeAction.get((int)REMOVE_CMD_ID, null, (String)DbgArb.getString(688), null, (Integer)DbgArb.getInteger(869), null, (int)-1, null, (boolean)false);
            actionRemove.setEnabled(false);
            actionOptions = IdeAction.get((int)OPTIONS_CMD_ID, null, (String)DbgArb.getString(126), null, (Integer)DbgArb.getInteger(164), null, (int)-1, null, (boolean)false);
            actionOptions.setEnabled(false);
            actionChangeScopeGlobal = IdeAction.get((int)CHANGE_SCOPE_GLOBAL_CMD_ID, null, (String)DbgArb.getString(539), null, (Integer)DbgArb.getInteger(15), null, (int)-1, null, (boolean)false);
            actionChangeScopeGlobal.putValue("Radio", (Object)Boolean.TRUE);
            actionChangeScopeGlobal.setEnabled(false);
            actionChangeScopeWorkspace = IdeAction.get((int)CHANGE_SCOPE_WORKSPACE_CMD_ID, null, (String)DbgArb.getString(733), null, (Integer)DbgArb.getInteger(567), null, (int)-1, null, (boolean)false);
            actionChangeScopeWorkspace.putValue("Radio", (Object)Boolean.TRUE);
            actionChangeScopeWorkspace.setEnabled(false);
            actionChangeScopeProject = IdeAction.get((int)CHANGE_SCOPE_PROJECT_CMD_ID, null, (String)DbgArb.getString(517), null, (Integer)DbgArb.getInteger(19), null, (int)-1, null, (boolean)false);
            actionChangeScopeProject.putValue("Radio", (Object)Boolean.TRUE);
            actionChangeScopeProject.setEnabled(false);
            actionAdd = IdeAction.get((int)ADD_CMD_ID, null, (String)DbgArb.getString(182), null, (Integer)DbgArb.getInteger(380), null, (int)-1, null, (boolean)false);
            actionAdd.setEnabled(false);
            actionDisableAll = IdeAction.get((int)DISABLE_ALL_CMD_ID, null, (String)DbgArb.getString(542), null, (Integer)DbgArb.getInteger(117), null, (int)-1, null, (boolean)false);
            actionDisableAll.setEnabled(false);
            actionEnableAll = IdeAction.get((int)ENABLE_ALL_CMD_ID, null, (String)DbgArb.getString(883), null, (Integer)DbgArb.getInteger(759), null, (int)-1, null, (boolean)false);
            actionEnableAll.setEnabled(false);
            actionRemoveAll = IdeAction.get((int)REMOVE_ALL_CMD_ID, null, (String)DbgArb.getString(56), null, (Integer)DbgArb.getInteger(631), null, (int)-1, null, (boolean)false);
            actionRemoveAll.setEnabled(false);
            actionSettings = IdeAction.get((int)SETTINGS_CMD_ID, null, (String)RunMgrArb.getString(87), null, (Integer)RunMgrArb.getInteger(99), null, (int)-1, null, (boolean)false);
            actionSettings.setEnabled(false);
            actionExpandAll = IdeAction.get((int)EXPAND_ALL_CMD_ID, null, (String)RunMgrArb.getString(76), null, (Integer)RunMgrArb.getInteger(24), null, (int)-1, null, (boolean)false);
            actionExpandAll.setEnabled(false);
            actionCollapseAll = IdeAction.get((int)COLLAPSE_ALL_CMD_ID, null, (String)RunMgrArb.getString(0), null, (Integer)RunMgrArb.getInteger(7), null, (int)-1, null, (boolean)false);
            actionCollapseAll.setEnabled(false);
            actionSave = IdeAction.get((int)SAVE_CMD_ID, null, (String)RunMgrArb.getString(65), null, (Integer)RunMgrArb.getInteger(101), null, (int)-1, null, (boolean)false);
            actionSave.setEnabled(false);
        }
    }

    private void setControllerForActions() {
        IdeAction[] actions = new IdeAction[]{actionGoTo, actionDisable, actionEnable, actionRemove, actionOptions, actionChangeScopeGlobal, actionChangeScopeWorkspace, actionChangeScopeProject, actionAdd, actionDisableAll, actionEnableAll, actionRemoveAll, actionSettings, actionExpandAll, actionCollapseAll, actionSave};
        JDebugger.setControllerForActions(actions, this);
    }

    private void showPopup(MouseEvent e) {
        Assert.precondition((this.treeTable != null ? 1 : 0) != 0, (String)"BreakpointsWindow GUI is null");
        JDebugger.getInstance().showContextMenu(e, (DockableWindow)this, this.treeTable);
    }

    private void addPopupMenuItemsForNew(ContextMenu popup, Context context) {
        this.update(actionAdd, context);
        if (actionAdd.isEnabled()) {
            if (menuitemAdd == null) {
                menuitemAdd = popup.createMenuItem((ToggleAction)actionAdd);
            }
            popup.add((Component)menuitemAdd, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_NEW_ITEM_CTXT_MENU);
        }
    }

    private void addPopupMenuItemsForBreakpointItem(ContextMenu popup, Context context) {
        BreakpointTreeTableModel.BreakpointItem breakpointItem;
        Assert.precondition((this.model != null ? 1 : 0) != 0, (String)"BreakpointsWindow GUI is null");
        this.update(actionOptions, context);
        if (actionOptions.isEnabled()) {
            if (menuitemOptions == null) {
                menuitemOptions = popup.createMenuItem((ToggleAction)actionOptions);
            }
            popup.add((Component)menuitemOptions, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(actionEnable, context);
        if (actionEnable.isEnabled()) {
            if (menuitemEnable == null) {
                menuitemEnable = popup.createMenuItem((ToggleAction)actionEnable);
            }
            popup.add((Component)menuitemEnable, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(actionDisable, context);
        if (actionDisable.isEnabled()) {
            if (menuitemDisable == null) {
                menuitemDisable = popup.createMenuItem((ToggleAction)actionDisable);
            }
            popup.add((Component)menuitemDisable, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(actionRemove, context);
        if (actionRemove.isEnabled()) {
            if (menuitemRemove == null) {
                menuitemRemove = popup.createMenuItem((ToggleAction)actionRemove);
            }
            popup.add((Component)menuitemRemove, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        if ((breakpointItem = this.model.getSelectedBreakpointItem()) != null && !breakpointItem.isGroup()) {
            if (subMenuChangeScope == null) {
                subMenuChangeScope = popup.createSubMenu(DbgArb.getString(916), DbgArb.getInteger(519));
                if (menuitemChangeScopeGlobal == null) {
                    menuitemChangeScopeGlobal = popup.createMenuItem((ToggleAction)actionChangeScopeGlobal);
                }
                if (menuitemChangeScopeWorkspace == null) {
                    menuitemChangeScopeWorkspace = popup.createMenuItem((ToggleAction)actionChangeScopeWorkspace);
                }
                if (menuitemChangeScopeProject == null) {
                    menuitemChangeScopeProject = popup.createMenuItem((ToggleAction)actionChangeScopeProject);
                }
                ButtonGroup buttonGroup = new ButtonGroup();
                buttonGroup.add(menuitemChangeScopeGlobal);
                buttonGroup.add(menuitemChangeScopeWorkspace);
                buttonGroup.add(menuitemChangeScopeProject);
                subMenuChangeScope.add(menuitemChangeScopeGlobal);
                subMenuChangeScope.add(menuitemChangeScopeWorkspace);
                subMenuChangeScope.add(menuitemChangeScopeProject);
            }
            this.update(actionChangeScopeGlobal, context);
            this.update(actionChangeScopeWorkspace, context);
            this.update(actionChangeScopeProject, context);
            popup.add((Component)subMenuChangeScope, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(actionGoTo, context);
        if (actionGoTo.isEnabled()) {
            if (menuitemGoTo == null) {
                menuitemGoTo = popup.createMenuItem((ToggleAction)actionGoTo);
            }
            popup.add((Component)menuitemGoTo, JDeveloperMenuConstants.SECTION_NAVIGATE_CTXT_MENU);
        }
        this.addRemoveInstanceFilterActions(popup, context);
    }

    private void addRemoveInstanceFilterActions(ContextMenu popup, Context context) {
        int length;
        long[] instanceFilters;
        DebugBreakpoint dbp;
        BreakpointTreeTableModel.BreakpointItem breakpointItem;
        this.removeInstanceFilterActions.clear();
        DebuggingProcess debuggingProcess = JDebugger.getInstance().getActiveDebuggingProcess();
        if (debuggingProcess != null && (breakpointItem = this.model.getSelectedBreakpointItem()) != null && breakpointItem.isBreakpoint() && (dbp = breakpointItem.getBreakpoint().getDebugBreakpoint(debuggingProcess)) != null && (instanceFilters = dbp.getInstanceFilters()) != null && (length = instanceFilters.length) > 0) {
            JMenu subMenu = popup.createSubMenu(DbgArb.getString(924), DbgArb.getInteger(845));
            int count = 0;
            int i = 0;
            while (i < length) {
                Long uniqueID = new Long(instanceFilters[i]);
                String label = DbgArb.format(414, Long.toString(instanceFilters[i]));
                int cmdId = Ide.findOrCreateCmdID((String)(REMOVE_INSTANCE_FILTER_CMD_PREFIX + count++));
                IdeAction action = IdeAction.get((int)cmdId, null, (String)label, null, null, null, (int)-1, (Object)uniqueID, (boolean)true);
                action.putValue("Name", (Object)label);
                action.putValue("UserData", (Object)uniqueID);
                action.addController((Controller)this);
                this.removeInstanceFilterActions.add(action);
                JMenuItem menuitem = popup.createMenuItem((ToggleAction)action);
                subMenu.add(menuitem);
                ++i;
            }
            popup.add((Component)subMenu, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
    }

    private void addPopupMenuItemsForBreakpoints(ContextMenu popup, Context context) {
        this.update(actionEnableAll, context);
        if (actionEnableAll.isEnabled()) {
            if (menuitemEnableAll == null) {
                menuitemEnableAll = popup.createMenuItem((ToggleAction)actionEnableAll);
            }
            popup.add((Component)menuitemEnableAll, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_SPECIFIC_CTXT_MENU);
        }
        this.update(actionDisableAll, context);
        if (actionDisableAll.isEnabled()) {
            if (menuitemDisableAll == null) {
                menuitemDisableAll = popup.createMenuItem((ToggleAction)actionDisableAll);
            }
            popup.add((Component)menuitemDisableAll, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_SPECIFIC_CTXT_MENU);
        }
        this.update(actionRemoveAll, context);
        if (actionRemoveAll.isEnabled()) {
            if (menuitemRemoveAll == null) {
                menuitemRemoveAll = popup.createMenuItem((ToggleAction)actionRemoveAll);
            }
            popup.add((Component)menuitemRemoveAll, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_SPECIFIC_CTXT_MENU);
        }
    }

    private void addPopupMenuItemsForTreeTable(ContextMenu popup, Context context) {
        this.update(actionExpandAll, context);
        if (actionExpandAll.isEnabled()) {
            if (menuitemExpandAll == null) {
                menuitemExpandAll = popup.createMenuItem((ToggleAction)actionExpandAll);
            }
            popup.add((Component)menuitemExpandAll, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_TREE_CTXT_MENU);
        }
        this.update(actionCollapseAll, context);
        if (actionCollapseAll.isEnabled()) {
            if (menuitemCollapseAll == null) {
                menuitemCollapseAll = popup.createMenuItem((ToggleAction)actionCollapseAll);
            }
            popup.add((Component)menuitemCollapseAll, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_TREE_CTXT_MENU);
        }
    }

    private void addPopupMenuItemsForCommon(ContextMenu popup, Context context) {
        this.update(actionSave, context);
        if (actionSave.isEnabled()) {
            if (menuitemSave == null) {
                menuitemSave = popup.createMenuItem((ToggleAction)actionSave);
            }
            popup.add((Component)menuitemSave, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
        }
        this.update(actionSettings, context);
        if (actionSettings.isEnabled()) {
            if (menuitemSettings == null) {
                menuitemSettings = popup.createMenuItem((ToggleAction)actionSettings);
            }
            popup.add((Component)menuitemSettings, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
        }
    }

    private void saveToFile() {
        URL url;
        Assert.precondition((this.model != null ? 1 : 0) != 0, (String)"BreakpointsWindow GUI is null");
        String dlgTitle = RunMgrArb.format(19, this.getTitleName());
        URLChooser chooser = DialogUtil.newURLChooser((Context)this.getContext());
        if (JDebugger.lastSavedFile != null) {
            chooser.setSelectedURL(JDebugger.lastSavedFile);
        }
        if (chooser.showSaveDialog((Component)Ide.getMainWindow(), dlgTitle) == 0 && (url = chooser.getSelectedURL()) != null) {
            JDebugger.lastSavedFile = url;
            WaitCursor wc = Ide.getWaitCursor();
            wc.show();
            Exception exceptionOccurred = null;
            try {
                PrintWriter out;
                String suffixUpper = URLFileSystem.getSuffix((URL)url).toUpperCase();
                boolean html = suffixUpper.equals(".HTML") || suffixUpper.equals(".HTM");
                PrintWriter printWriter = out = html ? JDebugger.printHtmlHeader(url, this.getTitleName()) : new PrintWriter(new BufferedOutputStream(URLFileSystem.openOutputStream((URL)url)));
                if (this.anyBreakpoints()) {
                    BreakpointTreeTableModel.mav$save(this.model, out, html);
                }
                if (html) {
                    JDebugger.printHtmlFooter(out);
                }
                out.flush();
                out.close();
            }
            catch (Exception e) {
                exceptionOccurred = e;
            }
            wc.hide();
            if (exceptionOccurred != null) {
                String message = DbgArb.format(341, this.getTitleName(), URLFileSystem.getPlatformPathName((URL)url));
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exceptionOccurred, (String)dlgTitle, (String)message, null);
            }
        }
    }

    void everythingChanged() {
        this.everythingChanged(this.lastHighlight);
    }

    private void everythingChanged(Object highlightInfo) {
        if (this.model != null) {
            this.model.updateBreakpoints(highlightInfo);
        }
    }

    void setBreakpoints(Workspace workspace, Project project, List[] breakpoints) {
        this.workspace = workspace;
        this.project = project;
        this.breakpoints = breakpoints;
        this.everythingChanged();
    }

    private TreePath getPathForLocation(Point p) {
        if (this.treeTable != null && this.treeTable.isEnabled()) {
            JTree tree = this.treeTable.getTree();
            int row = this.treeTable.rowAtPoint(p);
            return tree.getPathForRow(row);
        }
        return null;
    }

    private CodePeek peekAtLocation(Point location) {
        BreakpointTreeTableModel.BreakpointItem bpi;
        SwingUtilities.convertPointFromScreen(location, (Component)this.treeTable);
        TreePath tp = this.getPathForLocation(location);
        if (tp == null) {
            return null;
        }
        if (!this.treeTable.getTree().getPathBounds(tp).contains(location)) {
            return null;
        }
        Object o = tp.getLastPathComponent();
        if (o instanceof BreakpointTreeTableModel.BreakpointItem && (bpi = (BreakpointTreeTableModel.BreakpointItem)o).canShowInSource() && bpi.getInfo() instanceof Breakpoint) {
            Breakpoint bp = (Breakpoint)bpi.getInfo();
            int bpType = bp.getType();
            if (bpType == 0) {
                String pkg = bp.getPackage();
                String filename = bp.getFile();
                int line = bp.getLine();
                URL url = Source.findSourceFile(this.workspace, this.project, pkg, filename);
                if (url == null) {
                    Project proj = Context2ParserHelper.getProject(this.getContext());
                    JavaManager javaManager = JavaManager.getJavaManager((Project)proj);
                    try {
                        int dot = filename.indexOf(46);
                        if (dot != -1) {
                            filename = filename.substring(0, dot);
                        }
                        String fqName = pkg != null && pkg.length() > 0 ? pkg + "." + filename : filename;
                        JavaClass javaClass = javaManager.getClass(fqName);
                        url = javaClass.getURL();
                    }
                    catch (NullPointerException npe) {
                        // empty catch block
                    }
                }
                if (url != null) {
                    return this.peekAtLocation(url, line, bp.getDescription(), this.treeTable.getTree().getRowBounds(this.treeTable.rowAtPoint(location)));
                }
            } else if (bpType == 5) {
                URL url = bp.getURL();
                int line = bp.getLine();
                return this.peekAtLocation(url, line, bp.getDescription(), this.treeTable.getTree().getRowBounds(this.treeTable.rowAtPoint(location)));
            }
        }
        return null;
    }

    private CodePeek peekAtLocation(URL url, int line, String labelText, Rectangle rect) {
        CodePeek peek = JavaCodePeek.createCodePeek(this.project, url, line, labelText, (JComponent)this.treeTable, rect, "enabled-breakpoint");
        peek.showPeek();
        this.treeTable.getTree().setToolTipText(null);
        return peek;
    }

    private void updateColumn(int column) {
        Assert.precondition((this.treeTable != null ? 1 : 0) != 0, (String)"BreakpointsWindow GUI is null");
        TableModel tableModel = this.treeTable.getModel();
        TableModelEvent event = new TableModelEvent(tableModel, 0, tableModel.getRowCount() - 1, column);
        if (tableModel instanceof AbstractTableModel) {
            ((AbstractTableModel)tableModel).fireTableChanged(event);
        }
        if (column == 2) {
            this.updateIcons();
        } else if (column == 0) {
            this.model.fireChanged(this.lastHighlight);
        }
    }

    private void updateIcons() {
        Assert.precondition((this.treeTable != null ? 1 : 0) != 0, (String)"BreakpointsWindow GUI is null");
        TableModel tableModel = this.treeTable.getModel();
        TableModelEvent event = new TableModelEvent(tableModel, 0, tableModel.getRowCount() - 1, 0);
        if (tableModel instanceof AbstractTableModel) {
            ((AbstractTableModel)tableModel).fireTableChanged(event);
        }
        this.model.fireChanged(this.lastHighlight);
    }

    void processSelectionChanged() {
        if (this.treeTable == null) {
            return;
        }
        this.updateColumn(2);
        this.updateColumn(7);
        this.updateColumn(9);
    }

    void breakpointDescriptionChanged() {
        if (this.treeTable != null) {
            this.updateColumn(0);
        }
    }

    void breakpointStatusChanged() {
        if (this.treeTable != null) {
            this.updateColumn(2);
        }
    }

    void breakpointInstanceFiltersChanged() {
        if (this.treeTable != null) {
            this.updateColumn(9);
        }
    }

    private void editBreakpointDialog(int selectedColumn) {
        Assert.precondition((this.model != null ? 1 : 0) != 0, (String)"BreakpointsWindow GUI is null");
        int initialFocus = 0;
        switch (selectedColumn) {
            case 4: {
                initialFocus = 4;
                break;
            }
            case 8: {
                initialFocus = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                initialFocus = 2;
                break;
            }
        }
        BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
        if (breakpointItem != null) {
            if (breakpointItem.isMulti()) {
                this.editBreakpointDialog(breakpointItem.getBreakpoints(null), false, initialFocus);
            } else if (breakpointItem.isGroup()) {
                this.editBreakpointDialog(breakpointItem.getBreakpoints(null), true, initialFocus);
            } else {
                this.editBreakpointDialog(breakpointItem.getBreakpoint(), true, initialFocus);
            }
        }
    }

    private void editBreakpointDialog(List list, boolean group, int initialFocus) {
        String[] groupNames;
        Breakpoint[] breakpoints;
        BreakpointOptionsDialog bpDialog;
        if (list.size() > 0 && (bpDialog = BreakpointOptionsDialog.showBreakpointOptionsDialog(breakpoints = list.toArray(new Breakpoint[list.size()]), group, groupNames = this.getGroupNames(true), initialFocus)) != null) {
            11 runAfter = new 11();
            int length = breakpoints.length;
            int i = 0;
            while (i < length) {
                breakpoints[i].pauseAndApplyChanges(runAfter);
                ++i;
            }
        }
    }

    private void editBreakpointDialog(Breakpoint bp, boolean highlightBP, int initialFocus) {
        String[] groupNames;
        URL ownerURL = bp.getOwnerURL();
        BreakpointOptionsDialog bpDialog = BreakpointOptionsDialog.showBreakpointOptionsDialog(ownerURL, bp, groupNames = this.getGroupNames(true), initialFocus);
        if (bpDialog != null) {
            12 runAfter = new 12(this, highlightBP, bp);
            bp.pauseAndApplyChanges(runAfter);
        }
    }

    private void addBreakpointDialog() {
        String[] groupNames;
        URL ownerURL = JDebugger.getNewBreakpointOwnerURL(this.workspace, this.project);
        BreakpointOptionsDialog bpDialog = BreakpointOptionsDialog.showBreakpointOptionsDialog(ownerURL, null, groupNames = this.getGroupNames(true), 0);
        if (bpDialog != null) {
            Breakpoint bp = bpDialog.getBreakpoint();
            this.addNewBreakpoint(bp);
        }
    }

    private String[] getGroupNames(boolean addBlank) {
        ArrayList<String> groupNames = new ArrayList<String>();
        if (addBlank) {
            groupNames.add("");
        }
        this.getGroupNames(groupNames);
        Collections.sort(groupNames);
        int size = groupNames.size();
        return groupNames.toArray(new String[size]);
    }

    private void getGroupNames(List<String> groupNames) {
        int length = this.breakpoints.length;
        int i = 0;
        while (i < length) {
            for (Breakpoint bp : this.breakpoints[i]) {
                String groupName = bp.getGroupName();
                if (groupName.length() <= 0 || groupNames.contains(groupName)) continue;
                groupNames.add(groupName);
            }
            ++i;
        }
    }

    private List getBreakpointsForGroup(String groupName) {
        ArrayList<Breakpoint> list = new ArrayList<Breakpoint>();
        int length = this.breakpoints.length;
        int i = 0;
        while (i < length) {
            for (Breakpoint bp : this.breakpoints[i]) {
                if (!bp.getGroupName().equals(groupName)) continue;
                list.add(bp);
            }
            ++i;
        }
        return list;
    }

    void highlightBreakpoint(Breakpoint bp) {
        Assert.precondition((this.model != null ? 1 : 0) != 0, (String)"BreakpointsWindow GUI is null");
        this.model.highlightBreakpoint(bp);
    }

    void editBreakpoint(Breakpoint bp) {
        this.editBreakpointDialog(bp, false, 0);
    }

    void addNewBreakpoint(Breakpoint bp) {
        13 runAfter = new 13(this, bp);
        JDebugger.getInstance().addBreakpoint(bp, runAfter);
    }

    private void disableAll() {
        int length = this.breakpoints.length;
        int i = 0;
        while (i < length) {
            for (Breakpoint bp : this.breakpoints[i]) {
                bp.setEnabled(false);
            }
            ++i;
        }
    }

    private void enableAll() {
        int length = this.breakpoints.length;
        int i = 0;
        while (i < length) {
            for (Breakpoint bp : this.breakpoints[i]) {
                bp.setEnabled(true);
            }
            ++i;
        }
    }

    private void removeAll() {
        ArrayList remove = new ArrayList();
        int length = this.breakpoints.length;
        int i = 0;
        while (i < length) {
            remove.addAll(this.breakpoints[i]);
            ++i;
        }
        for (Breakpoint bp : remove) {
            bp.removeBreakpoint();
        }
    }

    private boolean anyBreakpoints() {
        int length = this.breakpoints.length;
        int i = 0;
        while (i < length) {
            if (this.breakpoints[i].size() > 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static DataFlavor getBreakpointFlavor() {
        if (breakpointFlavor == null) {
            breakpointFlavor = new DataFlavor(BreakpointTreeTableModel.BreakpointItem.class, "Breakpoint");
        }
        return breakpointFlavor;
    }

    static {
        ADD_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsAdd");
        OPTIONS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsOptions");
        ENABLE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsEnable");
        DISABLE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsDisable");
        REMOVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsRemove");
        CHANGE_SCOPE_GLOBAL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsChangeScopeGlobal");
        CHANGE_SCOPE_WORKSPACE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsChangeScopeWorkspace");
        CHANGE_SCOPE_PROJECT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsChangeScopeProject");
        GOTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsGoTo");
        ENABLE_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsEnableAll");
        DISABLE_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsDisableAll");
        REMOVE_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsRemoveAll");
        EXPAND_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsExpandAll");
        COLLAPSE_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsCollapseAll");
        SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsSave");
        SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsSettings");
        breakpointFlavor = null;
        transferFlavors = null;
        breakpointsTabIcon = null;
    }

    static JFastTreeTable ra$treeTable(BreakpointsWindow breakpointsWindow) {
        return breakpointsWindow.treeTable;
    }

    static void wa$lastHighlight(BreakpointsWindow breakpointsWindow, Object object) {
        breakpointsWindow.lastHighlight = object;
    }

    static List[] ra$breakpoints(BreakpointsWindow breakpointsWindow) {
        return breakpointsWindow.breakpoints;
    }

    static String[] mav$getGroupNames(BreakpointsWindow breakpointsWindow, boolean bl) {
        return breakpointsWindow.getGroupNames(bl);
    }

    static List mav$getBreakpointsForGroup(BreakpointsWindow breakpointsWindow, String string) {
        return breakpointsWindow.getBreakpointsForGroup(string);
    }

    static DataFlavor maS$getBreakpointFlavor() {
        return BreakpointsWindow.getBreakpointFlavor();
    }

    static DataFlavor[] ra$transferFlavors() {
        return transferFlavors;
    }

    static void wa$transferFlavors(DataFlavor[] dataFlavorArray) {
        transferFlavors = dataFlavorArray;
    }

    static int ra$CHANGE_SCOPE_GLOBAL_CMD_ID() {
        return CHANGE_SCOPE_GLOBAL_CMD_ID;
    }

    static int ra$CHANGE_SCOPE_WORKSPACE_CMD_ID() {
        return CHANGE_SCOPE_WORKSPACE_CMD_ID;
    }

    static Workspace ra$workspace(BreakpointsWindow breakpointsWindow) {
        return breakpointsWindow.workspace;
    }

    static int ra$CHANGE_SCOPE_PROJECT_CMD_ID() {
        return CHANGE_SCOPE_PROJECT_CMD_ID;
    }

    static Project ra$project(BreakpointsWindow breakpointsWindow) {
        return breakpointsWindow.project;
    }

    static BreakpointTreeTableModel ra$model(BreakpointsWindow breakpointsWindow) {
        return breakpointsWindow.model;
    }

    static CodePeek mav$peekAtLocation(BreakpointsWindow breakpointsWindow, Point point) {
        return breakpointsWindow.peekAtLocation(point);
    }

    static void mav$everythingChanged(BreakpointsWindow breakpointsWindow, Object object) {
        breakpointsWindow.everythingChanged(object);
    }

    static IdeAction ra$actionGoTo() {
        return actionGoTo;
    }

    static IdeAction ra$actionDisable() {
        return actionDisable;
    }

    static IdeAction ra$actionEnable() {
        return actionEnable;
    }

    static IdeAction ra$actionOptions() {
        return actionOptions;
    }

    static void mav$showPopup(BreakpointsWindow breakpointsWindow, MouseEvent mouseEvent) {
        breakpointsWindow.showPopup(mouseEvent);
    }

    static IdeAction ra$actionRemove() {
        return actionRemove;
    }

    static void mav$adjustColumnsAfterResize(BreakpointsWindow breakpointsWindow) {
        breakpointsWindow.adjustColumnsAfterResize();
    }

    static void mav$updateColumn(BreakpointsWindow breakpointsWindow, int n) {
        breakpointsWindow.updateColumn(n);
    }

    static void mav$breakpointsWindowSettingsChanged(BreakpointsWindow breakpointsWindow, boolean bl) {
        breakpointsWindow.breakpointsWindowSettingsChanged(bl);
    }

    final class 1
    implements Runnable {
        public void run() {
            BreakpointsWindow.this.everythingChanged();
        }
    }

    final class 2
    extends StructureChangeListener {
        public void structureValuesChanged(StructureChangeEvent e) {
            BreakpointsWindow.mav$breakpointsWindowSettingsChanged(BreakpointsWindow.this, true);
        }
    }

    final class 3
    implements RunWhilePaused {
        private final /* synthetic */ Breakpoint v$bp;
        private final /* synthetic */ long v$id;
        final /* synthetic */ BreakpointsWindow this$0;

        public void run(DebuggingProcess debuggingProcess, boolean live) {
            DebugBreakpoint dbp;
            if (live && (dbp = this.v$bp.getDebugBreakpoint(debuggingProcess)) != null) {
                dbp.removeInstanceFilter(this.v$id);
                BreakpointsWindow.mav$updateColumn(this.this$0, 9);
            }
        }

        public 3(BreakpointsWindow breakpointsWindow, Breakpoint breakpoint, long l) {
            this.v$id = l;
            this.v$bp = breakpoint;
            this.this$0 = breakpointsWindow;
        }
    }

    final class 4
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof BreakpointTreeTableModel.BreakpointItem) {
                String accessibleDescription;
                BreakpointTreeTableModel.BreakpointItem breakpointItem = (BreakpointTreeTableModel.BreakpointItem)value;
                this.setIcon(breakpointItem.getIcon());
                String tooltip = breakpointItem.getDescriptionColumnValue();
                this.setToolTipText(tooltip);
                AccessibleContext ac = this.getAccessibleContext();
                String accessibleName = BreakpointTreeTableModel.mav$getAccessibleNameAt(BreakpointsWindow.ra$model(BreakpointsWindow.this), breakpointItem, 0);
                if (breakpointItem.mayHaveChildren()) {
                    accessibleName = JDebugger.fixTreeCellAccessibleName(accessibleName, expanded);
                }
                if (accessibleName != null) {
                    ac.setAccessibleName(accessibleName);
                }
                if ((accessibleDescription = tooltip) != null) {
                    ac.setAccessibleDescription(accessibleDescription);
                }
            } else {
                this.setIcon(null);
                this.setToolTipText(null);
            }
            return this;
        }
    }

    final class 5
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String accessibleDescription;
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String tooltip = value instanceof String ? (String)value : null;
            this.setToolTipText(tooltip);
            BreakpointTreeTableModel.BreakpointItem breakpointItem = BreakpointsWindow.ra$model(BreakpointsWindow.this).getBreakpointItemForTreePath(BreakpointsWindow.ra$treeTable(BreakpointsWindow.this).getTree().getPathForRow(row));
            int modelColumn = table.convertColumnIndexToModel(column);
            AccessibleContext ac = this.getAccessibleContext();
            String accessibleName = BreakpointTreeTableModel.mav$getAccessibleNameAt(BreakpointsWindow.ra$model(BreakpointsWindow.this), breakpointItem, modelColumn);
            if (accessibleName != null) {
                ac.setAccessibleName(accessibleName);
            }
            if ((accessibleDescription = tooltip) != null) {
                ac.setAccessibleDescription(accessibleDescription);
            }
            return this;
        }
    }

    final class 6
    extends DefaultTableCellRenderer {
        private final /* synthetic */ TableCellRenderer v$headerRenderer;
        final /* synthetic */ BreakpointsWindow this$0;

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (this.v$headerRenderer instanceof DefaultTableCellRenderer) {
                DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)this.v$headerRenderer;
                defaultTableCellRenderer.setHorizontalAlignment(2);
            }
            return this.v$headerRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }

        public 6(BreakpointsWindow breakpointsWindow, TableCellRenderer tableCellRenderer) {
            this.v$headerRenderer = tableCellRenderer;
            this.this$0 = breakpointsWindow;
        }
    }

    final class 7
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                BreakpointsWindow.mav$showPopup(BreakpointsWindow.this, e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                BreakpointsWindow.mav$showPopup(BreakpointsWindow.this, e);
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (JDebugger.isDoubleClickInTreeTable(BreakpointsWindow.ra$treeTable(BreakpointsWindow.this), e)) {
                Context context = BreakpointsWindow.this.getContext(e);
                IdeAction action = BreakpointsWindow.ra$actionGoTo();
                int columnAtX = BreakpointsWindow.ra$treeTable(BreakpointsWindow.this).getColumnModel().getColumnIndexAtX(e.getX());
                int modelColumn = BreakpointsWindow.ra$treeTable(BreakpointsWindow.this).convertColumnIndexToModel(columnAtX);
                if (modelColumn == 2) {
                    BreakpointTreeTableModel.BreakpointItem breakpointItem = BreakpointsWindow.ra$model(BreakpointsWindow.this).getSelectedBreakpointItem();
                    if (breakpointItem != null) {
                        if (breakpointItem.canDisable()) {
                            action = BreakpointsWindow.ra$actionDisable();
                        } else if (breakpointItem.canEnable()) {
                            action = BreakpointsWindow.ra$actionEnable();
                        }
                    }
                } else if (modelColumn == 8 || modelColumn == 6 || modelColumn == 4 || modelColumn == 1 || modelColumn == 3 || modelColumn == 9) {
                    action = BreakpointsWindow.ra$actionOptions();
                    context.setInt(BreakpointsWindow.SELECTED_COLUMN, modelColumn);
                }
                BreakpointsWindow.this.update(action, context);
                if (action.isEnabled()) {
                    BreakpointsWindow.this.handleEvent(action, context);
                }
            }
        }
    }

    final class 8
    extends KeyAdapter {
        public void keyPressed(KeyEvent e) {
            int key = e.getKeyCode();
            switch (key) {
                case 127: {
                    Context context = BreakpointsWindow.this.getContext(e);
                    BreakpointsWindow.this.update(BreakpointsWindow.ra$actionRemove(), context);
                    if (!BreakpointsWindow.ra$actionRemove().isEnabled()) break;
                    BreakpointsWindow.this.handleEvent(BreakpointsWindow.ra$actionRemove(), context);
                    e.consume();
                    break;
                }
                case 10: {
                    Context context = BreakpointsWindow.this.getContext(e);
                    BreakpointsWindow.this.update(BreakpointsWindow.ra$actionGoTo(), context);
                    if (!BreakpointsWindow.ra$actionGoTo().isEnabled()) break;
                    BreakpointsWindow.this.handleEvent(BreakpointsWindow.ra$actionGoTo(), context);
                    e.consume();
                    break;
                }
            }
        }
    }

    final class 9
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                BreakpointsWindow.mav$showPopup(BreakpointsWindow.this, e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                BreakpointsWindow.mav$showPopup(BreakpointsWindow.this, e);
            }
        }
    }

    final class 10
    extends ComponentAdapter {
        public void componentResized(ComponentEvent e) {
            BreakpointsWindow.mav$adjustColumnsAfterResize(BreakpointsWindow.this);
        }
    }

    final class 11
    implements Runnable {
        public void run() {
            BreakpointsWindow.mav$everythingChanged(BreakpointsWindow.this, null);
        }
    }

    final class 12
    implements Runnable {
        private final /* synthetic */ boolean v$highlightBP;
        private final /* synthetic */ Breakpoint v$bp;
        final /* synthetic */ BreakpointsWindow this$0;

        public void run() {
            if (this.v$highlightBP) {
                BreakpointsWindow.mav$everythingChanged(this.this$0, this.v$bp);
            } else {
                this.this$0.everythingChanged();
            }
        }

        public 12(BreakpointsWindow breakpointsWindow, boolean bl, Breakpoint breakpoint) {
            this.v$bp = breakpoint;
            this.v$highlightBP = bl;
            this.this$0 = breakpointsWindow;
        }
    }

    final class 13
    implements Runnable {
        private final /* synthetic */ Breakpoint v$bp;
        final /* synthetic */ BreakpointsWindow this$0;

        public void run() {
            this.this$0.everythingChanged();
            if (BreakpointsWindow.ra$treeTable(this.this$0) != null) {
                this.this$0.highlightBreakpoint(this.v$bp);
            }
        }

        public 13(BreakpointsWindow breakpointsWindow, Breakpoint breakpoint) {
            this.v$bp = breakpoint;
            this.this$0 = breakpointsWindow;
        }
    }

    private final class BreakpointTreeTableModel
    extends AbstractTreeTableModel {
        private List root;
        private List collapsed;

        BreakpointTreeTableModel(List root) {
            super((Object)root);
            this.root = root;
            this.collapsed = Collections.synchronizedList(new ArrayList());
        }

        void updateBreakpoints(Object highlight) {
            this.root.clear();
            int breakpointsLength = BreakpointsWindow.ra$breakpoints(BreakpointsWindow.this).length;
            int i = 0;
            while (i < breakpointsLength) {
                for (Breakpoint bp : BreakpointsWindow.ra$breakpoints(BreakpointsWindow.this)[i]) {
                    String groupName = bp.getGroupName();
                    if (groupName.length() != 0) continue;
                    this.root.add(new BreakpointItem(bp));
                }
                ++i;
            }
            String[] groupNames = BreakpointsWindow.mav$getGroupNames(BreakpointsWindow.this, false);
            int groupNamesLength = groupNames.length;
            int i2 = 0;
            while (i2 < groupNamesLength) {
                String groupName = groupNames[i2];
                this.root.add(new BreakpointItem(groupName));
                ++i2;
            }
            this.fireChanged(highlight);
        }

        void fireChanged(Object highlight) {
            TreePath rootTreePath = new TreePath(this.root);
            this.fireTreeStructureChanged((Object)this, rootTreePath.getPath(), null, null);
            this.expandBranches();
            this.restoreHighlight(highlight);
        }

        void highlightRow(int row) {
            Assert.precondition((BreakpointsWindow.ra$treeTable(BreakpointsWindow.this) != null ? 1 : 0) != 0, (String)"BreakpointsWindow GUI is null");
            TreePath treePath = BreakpointsWindow.ra$treeTable(BreakpointsWindow.this).getTree().getPathForRow(row);
            Object highlight = this.getInfoFromTreePath(treePath);
            this.restoreHighlight(highlight);
        }

        void highlightBreakpoint(Breakpoint bp) {
            this.restoreHighlight(bp, true);
        }

        private void restoreHighlight(Object highlight) {
            this.restoreHighlight(highlight, false);
        }

        private void restoreHighlight(Object highlight, boolean scrollToVisible) {
            Assert.precondition((BreakpointsWindow.ra$treeTable(BreakpointsWindow.this) != null ? 1 : 0) != 0, (String)"BreakpointsWindow GUI is null");
            if (highlight != null) {
                BreakpointsWindow.wa$lastHighlight(BreakpointsWindow.this, highlight);
                TreePath treePath = this.makeVisible(highlight);
                JDebugger.getInstance().selectTreeTablePath(BreakpointsWindow.ra$treeTable(BreakpointsWindow.this), treePath, scrollToVisible);
            }
        }

        void expandBranches() {
            this.expandBranch(new TreePath(this.root));
        }

        private void expandBranch(TreePath treePath) {
            Assert.precondition((BreakpointsWindow.ra$treeTable(BreakpointsWindow.this) != null ? 1 : 0) != 0, (String)"BreakpointsWindow GUI is null");
            Object node = treePath.getLastPathComponent();
            if (!this.collapsed.contains(node)) {
                BreakpointsWindow.ra$treeTable(BreakpointsWindow.this).getTree().expandPath(treePath);
            }
            int count = this.getChildCount(node);
            int i = 0;
            while (i < count) {
                Object child = this.getChild(node, i);
                this.expandBranch(treePath.pathByAddingChild(child));
                ++i;
            }
        }

        TreePath makeVisible(Object info) {
            return this.makeVisible(new TreePath(this.root), info);
        }

        private TreePath makeVisible(TreePath treePath, Object info) {
            BreakpointItem breakpointItem;
            Assert.precondition((BreakpointsWindow.ra$treeTable(BreakpointsWindow.this) != null ? 1 : 0) != 0, (String)"BreakpointsWindow GUI is null");
            Object node = treePath.getLastPathComponent();
            if (node instanceof BreakpointItem && info.equals((breakpointItem = (BreakpointItem)node).getInfo())) {
                BreakpointsWindow.ra$treeTable(BreakpointsWindow.this).getTree().makeVisible(treePath);
                return treePath;
            }
            int count = this.getChildCount(node);
            int i = 0;
            while (i < count) {
                Object child = this.getChild(node, i);
                TreePath result = this.makeVisible(treePath.pathByAddingChild(child), info);
                if (result != null) {
                    return result;
                }
                ++i;
            }
            return null;
        }

        void branchExpanded(TreePath treePath) {
            Object node = treePath.getLastPathComponent();
            this.collapsed.remove(node);
        }

        void branchCollapsed(TreePath treePath) {
            Object node = treePath.getLastPathComponent();
            int i = this.collapsed.indexOf(node);
            if (i != -1) {
                this.collapsed.remove(i);
            }
            this.collapsed.add(0, node);
        }

        BreakpointItem getBreakpointItemForTreePath(TreePath treePath) {
            Object node;
            if (treePath != null && (node = treePath.getLastPathComponent()) instanceof BreakpointItem) {
                return (BreakpointItem)node;
            }
            return null;
        }

        BreakpointItem getSelectedBreakpointItem() {
            Assert.precondition((BreakpointsWindow.ra$treeTable(BreakpointsWindow.this) != null ? 1 : 0) != 0, (String)"BreakpointsWindow GUI is null");
            TreePath[] treePaths = BreakpointsWindow.ra$treeTable(BreakpointsWindow.this).getTree().getSelectionPaths();
            if (treePaths == null) {
                return null;
            }
            int length = treePaths.length;
            if (length == 0) {
                return null;
            }
            if (length == 1) {
                return this.getBreakpointItemForTreePath(treePaths[0]);
            }
            ArrayList<BreakpointItem> list = new ArrayList<BreakpointItem>();
            int i = 0;
            while (i < length) {
                list.add(this.getBreakpointItemForTreePath(treePaths[i]));
                ++i;
            }
            return new BreakpointItem(list);
        }

        BreakpointItem getBreakpointItemForDrag(Point pt) {
            Assert.precondition((BreakpointsWindow.ra$treeTable(BreakpointsWindow.this) != null ? 1 : 0) != 0, (String)"BreakpointsWindow GUI is null");
            int row = BreakpointsWindow.ra$treeTable(BreakpointsWindow.this).rowAtPoint(pt);
            if (BreakpointsWindow.ra$treeTable(BreakpointsWindow.this).isRowSelected(row)) {
                BreakpointItem breakpointItem = this.getSelectedBreakpointItem();
                if (breakpointItem != null) {
                    if (breakpointItem.isMulti()) {
                        Iterator it = breakpointItem.getMultiBreakpointItems();
                        while (it.hasNext()) {
                            BreakpointItem bpItem = (BreakpointItem)it.next();
                            if (!bpItem.isGroup()) continue;
                            return null;
                        }
                    } else if (breakpointItem.getBreakpoint() == null) {
                        return null;
                    }
                }
                return breakpointItem;
            }
            return this.getBreakpointItemForTreePath(BreakpointsWindow.ra$treeTable(BreakpointsWindow.this).getTree().getPathForRow(row));
        }

        int getColumnAtPoint(Point pt) {
            int col;
            if (pt != null && (col = BreakpointsWindow.ra$treeTable(BreakpointsWindow.this).columnAtPoint(pt)) != -1) {
                return BreakpointsWindow.ra$treeTable(BreakpointsWindow.this).convertColumnIndexToModel(col);
            }
            return -1;
        }

        BreakpointItem getBreakpointItemAtPoint(Point pt) {
            Assert.precondition((BreakpointsWindow.ra$treeTable(BreakpointsWindow.this) != null ? 1 : 0) != 0, (String)"BreakpointsWindow GUI is null");
            int row = BreakpointsWindow.ra$treeTable(BreakpointsWindow.this).rowAtPoint(pt);
            return this.getBreakpointItemForTreePath(BreakpointsWindow.ra$treeTable(BreakpointsWindow.this).getTree().getPathForRow(row));
        }

        String getGroupNameAtPoint(Point pt) {
            BreakpointItem breakpointItem;
            if (pt != null && (breakpointItem = this.getBreakpointItemAtPoint(pt)) != null) {
                return breakpointItem.getGroupName();
            }
            return null;
        }

        Object getInfoFromTreePath(TreePath treePath) {
            Object node = treePath.getLastPathComponent();
            if (node instanceof BreakpointItem) {
                BreakpointItem breakpointItem = (BreakpointItem)node;
                return breakpointItem.getInfo();
            }
            return null;
        }

        private void expandAll() {
            Assert.precondition((BreakpointsWindow.ra$treeTable(BreakpointsWindow.this) != null ? 1 : 0) != 0, (String)"BreakpointsWindow GUI is null");
            WaitCursor wc = Ide.getWaitCursor();
            wc.show();
            this.expandAll(BreakpointsWindow.ra$treeTable(BreakpointsWindow.this).getTree(), new TreePath(this.root));
            wc.hide();
        }

        private void expandAll(JTree tree, TreePath treePath) {
            Object node = treePath.getLastPathComponent();
            tree.expandPath(treePath);
            int count = this.getChildCount(node);
            int i = 0;
            while (i < count) {
                Object child = this.getChild(node, i);
                this.expandAll(tree, treePath.pathByAddingChild(child));
                ++i;
            }
        }

        private void collapseAll() {
            Assert.precondition((BreakpointsWindow.ra$treeTable(BreakpointsWindow.this) != null ? 1 : 0) != 0, (String)"BreakpointsWindow GUI is null");
            WaitCursor wc = Ide.getWaitCursor();
            wc.show();
            this.collapseAll(BreakpointsWindow.ra$treeTable(BreakpointsWindow.this).getTree(), new TreePath(this.root));
            wc.hide();
        }

        private void collapseAll(JTree tree, TreePath treePath) {
            Object node = treePath.getLastPathComponent();
            int count = this.getChildCount(node);
            int i = 0;
            while (i < count) {
                Object child = this.getChild(node, i);
                this.collapseAll(tree, treePath.pathByAddingChild(child));
                ++i;
            }
            if (!node.equals(this.root)) {
                tree.collapsePath(treePath);
            }
        }

        private void save(PrintWriter out, boolean html) {
            Assert.precondition((BreakpointsWindow.ra$treeTable(BreakpointsWindow.this) != null ? 1 : 0) != 0, (String)"BreakpointsWindow GUI is null");
            if (html) {
                out.println("<table border=\"1\">");
            }
            this.saveHeader(out, html);
            this.save(BreakpointsWindow.ra$treeTable(BreakpointsWindow.this).getTree(), new TreePath(this.root), out, html, "");
            if (html) {
                out.println("</table>");
            }
        }

        private void saveHeader(PrintWriter out, boolean html) {
            Assert.precondition((BreakpointsWindow.ra$treeTable(BreakpointsWindow.this) != null ? 1 : 0) != 0, (String)"BreakpointsWindow GUI is null");
            StringBuffer sb = new StringBuffer();
            StringBuffer sb2 = new StringBuffer();
            if (html) {
                sb.append("<tr>");
            }
            TableColumnModel tableColumnModel = BreakpointsWindow.ra$treeTable(BreakpointsWindow.this).getColumnModel();
            Enumeration<TableColumn> e = tableColumnModel.getColumns();
            while (e.hasMoreElements()) {
                TableColumn column = e.nextElement();
                int i = column.getModelIndex();
                String columnName = this.getColumnName(i);
                if (html) {
                    sb.append("<th>");
                    columnName = IdeUtil.replaceHTMLReservedCharacters((String)columnName.toString());
                    sb.append(columnName);
                    sb.append("</th>");
                    continue;
                }
                sb.append(columnName);
                int ii = columnName.length();
                while (ii >= 0) {
                    sb2.append('-');
                    --ii;
                }
                if (!e.hasMoreElements()) continue;
                sb.append('\t');
                sb2.append('\t');
            }
            if (html) {
                sb.append("</tr>");
            }
            out.println(sb.toString());
            if (!html) {
                out.println(sb2.toString());
            }
        }

        private void save(JTree tree, TreePath treePath, PrintWriter out, boolean html, String indent) {
            Assert.precondition((BreakpointsWindow.ra$treeTable(BreakpointsWindow.this) != null ? 1 : 0) != 0, (String)"BreakpointsWindow GUI is null");
            if (tree.isVisible(treePath)) {
                Object node = treePath.getLastPathComponent();
                if (node instanceof BreakpointItem) {
                    BreakpointItem breakpointItem = (BreakpointItem)node;
                    StringBuffer sb = new StringBuffer();
                    if (html) {
                        sb.append("<tr>");
                    }
                    TableColumnModel tableColumnModel = BreakpointsWindow.ra$treeTable(BreakpointsWindow.this).getColumnModel();
                    Enumeration<TableColumn> e = tableColumnModel.getColumns();
                    while (e.hasMoreElements()) {
                        TableColumn column = e.nextElement();
                        int i = column.getModelIndex();
                        Object columnValue = this.getValueAt(node, i);
                        if (html) {
                            String columnValueString;
                            sb.append("<td>");
                            if (i == 0) {
                                sb.append("<tt>");
                                if (indent != null) {
                                    sb.append(indent);
                                }
                                if (tree.isExpanded(treePath)) {
                                    sb.append("-&nbsp;");
                                } else if (breakpointItem.mayHaveChildren()) {
                                    sb.append("+&nbsp;");
                                } else {
                                    sb.append("&nbsp;&nbsp;");
                                }
                                sb.append("</tt>");
                            }
                            if ((columnValueString = IdeUtil.replaceHTMLReservedCharacters((String)columnValue.toString())).length() > 0) {
                                sb.append(columnValueString);
                            } else {
                                sb.append("&nbsp;");
                            }
                            sb.append("</td>");
                            continue;
                        }
                        if (i == 0) {
                            if (indent != null) {
                                sb.append(indent);
                            }
                            if (tree.isExpanded(treePath)) {
                                sb.append("- ");
                            } else if (breakpointItem.mayHaveChildren()) {
                                sb.append("+ ");
                            } else {
                                sb.append("  ");
                            }
                        }
                        sb.append(columnValue);
                        if (!e.hasMoreElements()) continue;
                        sb.append('\t');
                    }
                    if (html) {
                        sb.append("</tr>");
                    }
                    out.println(sb.toString());
                }
                if (node != this.root) {
                    indent = html ? indent + "&nbsp;&nbsp;&nbsp;&nbsp;" : indent + "    ";
                }
                int count = this.getChildCount(node);
                int i = 0;
                while (i < count) {
                    Object child = this.getChild(node, i);
                    this.save(tree, treePath.pathByAddingChild(child), out, html, indent);
                    ++i;
                }
            }
        }

        public boolean isLeaf(Object node) {
            try {
                if (node instanceof List) {
                    boolean bl = false;
                    return bl;
                }
                BreakpointItem breakpointItem = (BreakpointItem)node;
                boolean bl = breakpointItem.mayHaveChildren() ^ true;
                return bl;
            }
            catch (Exception e) {
                e.printStackTrace();
                return true;
            }
        }

        public Class getColumnClass(int column) {
            if (column == 0) {
                return TreeTableModel.class;
            }
            return String.class;
        }

        public Object getChild(Object parent, int index) {
            try {
                if (parent instanceof List) {
                    Object e = ((List)parent).get(index);
                    return e;
                }
                BreakpointItem breakpointItem = (BreakpointItem)parent;
                BreakpointItem breakpointItem2 = breakpointItem.getChildNodes()[index];
                return breakpointItem2;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public int getChildCount(Object parent) {
            try {
                if (parent instanceof List) {
                    int n = ((List)parent).size();
                    return n;
                }
                BreakpointItem breakpointItem = (BreakpointItem)parent;
                int n = breakpointItem.countChildNodes();
                return n;
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        }

        public int getColumnCount() {
            return 10;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return DbgArb.getString(375);
                }
                case 3: {
                    return DbgArb.getString(904);
                }
                case 1: {
                    return DbgArb.getString(262);
                }
                case 2: {
                    return DbgArb.getString(355);
                }
                case 4: {
                    return DbgArb.getString(407);
                }
                case 5: {
                    return DbgArb.getString(300);
                }
                case 6: {
                    return DbgArb.getString(13);
                }
                case 7: {
                    return DbgArb.getString(60);
                }
                case 8: {
                    return DbgArb.getString(930);
                }
                case 9: {
                    return DbgArb.getString(741);
                }
            }
            return "";
        }

        public Object getValueAt(Object node, int column) {
            try {
                if (node instanceof List) {
                    switch (column) {
                        case 0: {
                            String string = "root";
                            return string;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: {
                            String string = "";
                            return string;
                        }
                    }
                    Object var7_5 = null;
                    return var7_5;
                }
                BreakpointItem breakpointItem = (BreakpointItem)node;
                switch (column) {
                    case 0: {
                        String string = breakpointItem.getDescriptionColumnValue();
                        return string;
                    }
                    case 3: {
                        String string = breakpointItem.getScopeColumnValue();
                        return string;
                    }
                    case 1: {
                        String string = breakpointItem.getTypeColumnValue();
                        return string;
                    }
                    case 2: {
                        String string = breakpointItem.getStatusColumnValue();
                        return string;
                    }
                    case 4: {
                        String string = breakpointItem.getGroupColumnValue();
                        return string;
                    }
                    case 5: {
                        String string = breakpointItem.getConditionColumnValue();
                        return string;
                    }
                    case 6: {
                        String string = breakpointItem.getThreadColumnValue();
                        return string;
                    }
                    case 7: {
                        String string = breakpointItem.getPassCountColumnValue();
                        return string;
                    }
                    case 8: {
                        String string = breakpointItem.getActionColumnValue();
                        return string;
                    }
                    case 9: {
                        String string = breakpointItem.getInstanceFiltersColumnValue();
                        return string;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        public void setValueAt(Object aValue, Object node, int column) {
            if (column == 5) {
                if (node instanceof BreakpointItem) {
                    BreakpointItem breakpointItem = (BreakpointItem)node;
                    breakpointItem.setConditionColumnValue(aValue.toString());
                    return;
                }
            } else if (column == 7 && node instanceof BreakpointItem) {
                String value = aValue.toString().trim();
                if (value.length() == 0) {
                    value = "0";
                }
                BreakpointItem breakpointItem = (BreakpointItem)node;
                try {
                    breakpointItem.setPassCount(Integer.parseInt(aValue.toString()));
                }
                catch (NumberFormatException nfe) {
                    breakpointItem.setPassCount(0);
                }
                return;
            }
            super.setValueAt(aValue, node, column);
        }

        public boolean isCellEditable(Object node, int column) {
            if (column == 7 || column == 5) {
                return true;
            }
            return super.isCellEditable(node, column);
        }

        private String getAccessibleNameAt(BreakpointItem breakpointItem, int column) {
            int id;
            if (breakpointItem.isBreakpoint()) {
                id = 658;
            } else if (breakpointItem.isGroup()) {
                id = 832;
            } else {
                return null;
            }
            String columnName = this.getColumnName(column);
            String value = (String)this.getValueAt(breakpointItem, column);
            if (value == null || value.length() == 0) {
                value = DbgArb.getString(32);
            }
            return DbgArb.format(id, columnName, value);
        }

        static void mav$save(BreakpointTreeTableModel breakpointTreeTableModel, PrintWriter printWriter, boolean bl) {
            breakpointTreeTableModel.save(printWriter, bl);
        }

        static void mav$expandAll(BreakpointTreeTableModel breakpointTreeTableModel) {
            breakpointTreeTableModel.expandAll();
        }

        static void mav$collapseAll(BreakpointTreeTableModel breakpointTreeTableModel) {
            breakpointTreeTableModel.collapseAll();
        }

        static String mav$getAccessibleNameAt(BreakpointTreeTableModel breakpointTreeTableModel, BreakpointItem breakpointItem, int n) {
            return breakpointTreeTableModel.getAccessibleNameAt(breakpointItem, n);
        }

        private final class BreakpointItem
        extends BaseElement
        implements Transferable {
            private Object info;
            private BreakpointItem[] children;
            private boolean removed;

            BreakpointItem(Object info) {
                this.info = info;
            }

            URL getOwnerURL() {
                if (this.info instanceof Breakpoint) {
                    return ((Breakpoint)this.info).getOwnerURL();
                }
                return null;
            }

            Object getInfo() {
                return this.info;
            }

            boolean isBreakpoint() {
                return this.info instanceof Breakpoint;
            }

            boolean isGroup() {
                return this.info instanceof String;
            }

            boolean isMulti() {
                return this.info instanceof List;
            }

            Iterator getMultiBreakpointItems() {
                if (this.info instanceof List) {
                    return ((List)this.info).iterator();
                }
                return null;
            }

            List getBreakpoints(List breakpoints) {
                block7: {
                    block6: {
                        if (breakpoints == null) {
                            breakpoints = new ArrayList<Object>();
                        }
                        if (!(this.info instanceof Breakpoint)) break block6;
                        if (breakpoints.contains(this.info)) break block7;
                        breakpoints.add(this.info);
                        break block7;
                    }
                    if (this.info instanceof String) {
                        BreakpointItem[] breakpointItems = this.getChildNodes();
                        int length = breakpointItems.length;
                        int i = 0;
                        while (i < length) {
                            breakpointItems[i].getBreakpoints(breakpoints);
                            ++i;
                        }
                    } else if (this.info instanceof List) {
                        List list = (List)this.info;
                        int size = list.size();
                        int i = 0;
                        while (i < size) {
                            BreakpointItem breakpointItem = (BreakpointItem)list.get(i);
                            breakpointItem.getBreakpoints(breakpoints);
                            ++i;
                        }
                    }
                }
                return breakpoints;
            }

            Breakpoint getBreakpoint() {
                if (this.info instanceof Breakpoint) {
                    return (Breakpoint)this.info;
                }
                return null;
            }

            String getGroupName() {
                if (this.info instanceof Breakpoint) {
                    Breakpoint bp = (Breakpoint)this.info;
                    return bp.getGroupName();
                }
                if (this.info instanceof String) {
                    return (String)this.info;
                }
                return null;
            }

            boolean canShowInSource() {
                if (this.info instanceof Breakpoint) {
                    Breakpoint bp = (Breakpoint)this.info;
                    if (JDebugger.getInstance().canShowBreakpointLocation(bp)) {
                        return true;
                    }
                    int bpType = bp.getType();
                    if (bpType == 0) {
                        return true;
                    }
                    if (bpType == 5) {
                        return true;
                    }
                }
                return false;
            }

            void showInSource() {
                if (this.info instanceof Breakpoint) {
                    Breakpoint bp = (Breakpoint)this.info;
                    if (JDebugger.getInstance().showBreakpointLocation(bp)) {
                        return;
                    }
                    int bpType = bp.getType();
                    if (bpType == 0) {
                        String pkg = bp.getPackage();
                        String filename = bp.getFile();
                        int line = bp.getLine();
                        Source.showSourceFile(BreakpointsWindow.ra$workspace(BreakpointsWindow.this), BreakpointsWindow.ra$project(BreakpointsWindow.this), pkg, null, filename, line, false);
                    } else if (bpType == 5) {
                        URL url = bp.getURL();
                        int line = bp.getLine();
                        Source.showSourceFile(BreakpointsWindow.ra$workspace(BreakpointsWindow.this), BreakpointsWindow.ra$project(BreakpointsWindow.this), url, line, false);
                    }
                }
            }

            boolean isScope(int cmdId) {
                if (this.info instanceof Breakpoint) {
                    URL ownerURL = this.getOwnerURL();
                    if (cmdId == BreakpointsWindow.ra$CHANGE_SCOPE_GLOBAL_CMD_ID()) {
                        return ownerURL == null;
                    }
                    if (cmdId == BreakpointsWindow.ra$CHANGE_SCOPE_WORKSPACE_CMD_ID()) {
                        return BreakpointsWindow.ra$workspace(BreakpointsWindow.this) != null && BreakpointsWindow.ra$workspace(BreakpointsWindow.this).getURL().equals(ownerURL);
                    }
                    if (cmdId == BreakpointsWindow.ra$CHANGE_SCOPE_PROJECT_CMD_ID()) {
                        return BreakpointsWindow.ra$project(BreakpointsWindow.this) != null && BreakpointsWindow.ra$project(BreakpointsWindow.this).getURL().equals(ownerURL);
                    }
                }
                return false;
            }

            boolean canChangeScope(int cmdId) {
                if (this.info instanceof Breakpoint && !((Breakpoint)this.info).isPersistent()) {
                    if (cmdId == BreakpointsWindow.ra$CHANGE_SCOPE_GLOBAL_CMD_ID()) {
                        return true;
                    }
                    if (cmdId == BreakpointsWindow.ra$CHANGE_SCOPE_WORKSPACE_CMD_ID()) {
                        return BreakpointsWindow.ra$workspace(BreakpointsWindow.this) != null;
                    }
                    if (cmdId == BreakpointsWindow.ra$CHANGE_SCOPE_PROJECT_CMD_ID()) {
                        return BreakpointsWindow.ra$project(BreakpointsWindow.this) != null;
                    }
                }
                return false;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            void changeScope(int cmdId) {
                URL newOwnerURL;
                if (!(this.info instanceof Breakpoint)) return;
                URL oldOwnerURL = this.getOwnerURL();
                if (cmdId == BreakpointsWindow.ra$CHANGE_SCOPE_GLOBAL_CMD_ID()) {
                    newOwnerURL = null;
                } else if (cmdId == BreakpointsWindow.ra$CHANGE_SCOPE_WORKSPACE_CMD_ID()) {
                    if (BreakpointsWindow.ra$workspace(BreakpointsWindow.this) == null || BreakpointsWindow.ra$workspace(BreakpointsWindow.this) == Ide.getDefaultWorkspace()) return;
                    newOwnerURL = BreakpointsWindow.ra$workspace(BreakpointsWindow.this).getURL();
                } else {
                    if (cmdId != BreakpointsWindow.ra$CHANGE_SCOPE_PROJECT_CMD_ID()) return;
                    if (BreakpointsWindow.ra$project(BreakpointsWindow.this) == null || BreakpointsWindow.ra$project(BreakpointsWindow.this) == Ide.getDefaultProject()) return;
                    newOwnerURL = BreakpointsWindow.ra$project(BreakpointsWindow.this).getURL();
                }
                if (oldOwnerURL == newOwnerURL) return;
                Breakpoint bp = (Breakpoint)this.info;
                Breakpoint.removeBreakpointFromOwner(bp);
                bp.setOwnerURL(newOwnerURL);
                Breakpoint.addBreakpointToOwner(bp);
            }

            boolean canDisable() {
                block6: {
                    block5: {
                        if (this.info instanceof Breakpoint) {
                            Breakpoint bp = (Breakpoint)this.info;
                            return bp.isEnabledNow();
                        }
                        if (!(this.info instanceof String)) break block5;
                        BreakpointItem[] breakpointItems = this.getChildNodes();
                        int i = breakpointItems.length - 1;
                        while (i >= 0) {
                            if (breakpointItems[i].canDisable()) {
                                return true;
                            }
                            --i;
                        }
                        break block6;
                    }
                    if (!(this.info instanceof List)) break block6;
                    List list = (List)this.info;
                    int i = list.size() - 1;
                    while (i >= 0) {
                        BreakpointItem breakpointItem = (BreakpointItem)list.get(i);
                        if (breakpointItem.canDisable()) {
                            return true;
                        }
                        --i;
                    }
                }
                return false;
            }

            void disable() {
                block6: {
                    block5: {
                        if (!(this.info instanceof Breakpoint)) break block5;
                        Breakpoint bp = (Breakpoint)this.info;
                        if (!bp.isEnabledNow()) break block6;
                        bp.setEnabled(false);
                        break block6;
                    }
                    if (this.info instanceof String) {
                        BreakpointItem[] breakpointItems = this.getChildNodes();
                        int i = breakpointItems.length - 1;
                        while (i >= 0) {
                            breakpointItems[i].disable();
                            --i;
                        }
                    } else if (this.info instanceof List) {
                        List list = (List)this.info;
                        int i = list.size() - 1;
                        while (i >= 0) {
                            BreakpointItem breakpointItem = (BreakpointItem)list.get(i);
                            breakpointItem.disable();
                            --i;
                        }
                    }
                }
            }

            boolean canEnable() {
                block6: {
                    block5: {
                        if (this.info instanceof Breakpoint) {
                            Breakpoint bp = (Breakpoint)this.info;
                            return bp.isEnabledNow() ^ true;
                        }
                        if (!(this.info instanceof String)) break block5;
                        BreakpointItem[] breakpointItems = this.getChildNodes();
                        int i = breakpointItems.length - 1;
                        while (i >= 0) {
                            if (breakpointItems[i].canEnable()) {
                                return true;
                            }
                            --i;
                        }
                        break block6;
                    }
                    if (!(this.info instanceof List)) break block6;
                    List list = (List)this.info;
                    int i = list.size() - 1;
                    while (i >= 0) {
                        BreakpointItem breakpointItem = (BreakpointItem)list.get(i);
                        if (breakpointItem.canEnable()) {
                            return true;
                        }
                        --i;
                    }
                }
                return false;
            }

            void enable() {
                block6: {
                    block5: {
                        if (!(this.info instanceof Breakpoint)) break block5;
                        Breakpoint bp = (Breakpoint)this.info;
                        if (bp.isEnabledNow()) break block6;
                        bp.setEnabled(true);
                        break block6;
                    }
                    if (this.info instanceof String) {
                        BreakpointItem[] breakpointItems = this.getChildNodes();
                        int i = breakpointItems.length - 1;
                        while (i >= 0) {
                            breakpointItems[i].enable();
                            --i;
                        }
                    } else if (this.info instanceof List) {
                        List list = (List)this.info;
                        int i = list.size() - 1;
                        while (i >= 0) {
                            BreakpointItem breakpointItem = (BreakpointItem)list.get(i);
                            breakpointItem.enable();
                            --i;
                        }
                    }
                }
            }

            boolean canRemove() {
                block6: {
                    block7: {
                        block5: {
                            if (!(this.info instanceof Breakpoint)) break block5;
                            Breakpoint bp = (Breakpoint)this.info;
                            if (!bp.isPersistent()) {
                                return true;
                            }
                            break block6;
                        }
                        if (!(this.info instanceof String)) break block7;
                        BreakpointItem[] breakpointItems = this.getChildNodes();
                        int i = breakpointItems.length - 1;
                        while (i >= 0) {
                            if (breakpointItems[i].canRemove()) {
                                return true;
                            }
                            --i;
                        }
                        break block6;
                    }
                    if (!(this.info instanceof List)) break block6;
                    List list = (List)this.info;
                    int i = list.size() - 1;
                    while (i >= 0) {
                        BreakpointItem breakpointItem = (BreakpointItem)list.get(i);
                        if (breakpointItem.canRemove()) {
                            return true;
                        }
                        --i;
                    }
                }
                return false;
            }

            void remove() {
                if (!this.removed) {
                    if (this.info instanceof Breakpoint) {
                        Breakpoint bp = (Breakpoint)this.info;
                        if (!bp.isPersistent()) {
                            bp.removeBreakpoint();
                        }
                    } else if (this.info instanceof String) {
                        BreakpointItem[] breakpointItems = this.getChildNodes();
                        int i = breakpointItems.length - 1;
                        while (i >= 0) {
                            breakpointItems[i].remove();
                            --i;
                        }
                    } else if (this.info instanceof List) {
                        List list = (List)this.info;
                        int i = list.size() - 1;
                        while (i >= 0) {
                            BreakpointItem breakpointItem = (BreakpointItem)list.get(i);
                            breakpointItem.remove();
                            --i;
                        }
                    }
                }
                this.removed = true;
            }

            boolean canEditOptions() {
                return true;
            }

            public String getShortLabel() {
                return this.getDescriptionColumnValue();
            }

            public Icon getIcon() {
                if (this.info instanceof Breakpoint) {
                    return ((Breakpoint)this.info).getIcon();
                }
                return null;
            }

            public Object getData() {
                return this;
            }

            public boolean mayHaveChildren() {
                return this.info instanceof String;
            }

            public Iterator getChildren() {
                return Arrays.asList(this.getChildNodes()).iterator();
            }

            public DataFlavor[] getTransferDataFlavors() {
                if (BreakpointsWindow.ra$transferFlavors() == null) {
                    BreakpointsWindow.wa$transferFlavors(new DataFlavor[2]);
                    BreakpointsWindow.ra$transferFlavors()[0] = BreakpointsWindow.maS$getBreakpointFlavor();
                    BreakpointsWindow.ra$transferFlavors()[1] = DataFlavor.stringFlavor;
                }
                return BreakpointsWindow.ra$transferFlavors();
            }

            public boolean isDataFlavorSupported(DataFlavor flavor) {
                if (flavor.equals(BreakpointsWindow.maS$getBreakpointFlavor())) {
                    return true;
                }
                return flavor.equals(DataFlavor.stringFlavor);
            }

            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
                if (flavor.equals(BreakpointsWindow.maS$getBreakpointFlavor())) {
                    return this;
                }
                if (flavor.equals(DataFlavor.stringFlavor)) {
                    return this.getShortLabel();
                }
                throw new UnsupportedFlavorException(flavor);
            }

            String getDescriptionColumnValue() {
                if (this.info instanceof Breakpoint) {
                    Breakpoint bp = (Breakpoint)this.info;
                    return bp.getDescription();
                }
                if (this.info instanceof String) {
                    String groupName = (String)this.info;
                    return groupName;
                }
                return "";
            }

            String getScopeColumnValue() {
                if (this.info instanceof Breakpoint) {
                    URL ownerURL = this.getOwnerURL();
                    if (ownerURL == null) {
                        return DbgArb.getString(516);
                    }
                    return URLFileSystem.getFileName((URL)ownerURL);
                }
                return "";
            }

            String getTypeColumnValue() {
                if (this.info instanceof Breakpoint) {
                    Breakpoint bp = (Breakpoint)this.info;
                    return bp.getTypeString();
                }
                return "";
            }

            String getStatusColumnValue() {
                if (this.info instanceof Breakpoint) {
                    Breakpoint bp = (Breakpoint)this.info;
                    return bp.getStatusInfo();
                }
                return "";
            }

            String getGroupColumnValue() {
                if (this.info instanceof Breakpoint) {
                    Breakpoint bp = (Breakpoint)this.info;
                    return bp.getGroupName();
                }
                return "";
            }

            String getConditionColumnValue() {
                if (this.info instanceof Breakpoint) {
                    Breakpoint bp = (Breakpoint)this.info;
                    return bp.getCondition();
                }
                return "";
            }

            void setConditionColumnValue(String condition) {
                List list = this.getBreakpoints(null);
                int i = list.size() - 1;
                while (i >= 0) {
                    Breakpoint bp = (Breakpoint)list.get(i);
                    bp.setCondition(condition);
                    --i;
                }
            }

            String getThreadColumnValue() {
                if (this.info instanceof Breakpoint) {
                    Breakpoint bp = (Breakpoint)this.info;
                    String threadName = bp.getThreadName();
                    if (threadName.length() > 0) {
                        return threadName;
                    }
                    String threadNameNot = bp.getThreadNameNot();
                    if (threadNameNot.length() > 0) {
                        return DbgArb.format(578, threadNameNot);
                    }
                }
                return "";
            }

            String getPassCountColumnValue() {
                if (this.info instanceof Breakpoint) {
                    Breakpoint bp = (Breakpoint)this.info;
                    return bp.getPassCountInfo();
                }
                return "";
            }

            void setPassCount(int passCount) {
                List list = this.getBreakpoints(null);
                int i = list.size() - 1;
                while (i >= 0) {
                    Breakpoint bp = (Breakpoint)list.get(i);
                    bp.setPassCount(passCount);
                    --i;
                }
            }

            int getPassCount() {
                if (this.info instanceof Breakpoint) {
                    Breakpoint bp = (Breakpoint)this.info;
                    return bp.getPassCount();
                }
                return 0;
            }

            String getActionColumnValue() {
                if (this.info instanceof Breakpoint) {
                    Breakpoint bp = (Breakpoint)this.info;
                    return bp.getAction();
                }
                return "";
            }

            String getInstanceFiltersColumnValue() {
                if (this.info instanceof Breakpoint) {
                    Breakpoint bp = (Breakpoint)this.info;
                    return bp.getInstanceFilters();
                }
                return "";
            }

            int countChildNodes() {
                if (this.info instanceof String) {
                    return this.getChildNodes().length;
                }
                return 0;
            }

            BreakpointItem[] getChildNodes() {
                if (this.info instanceof String) {
                    if (this.children == null) {
                        String groupName = (String)this.info;
                        List groupBreakpoints = BreakpointsWindow.mav$getBreakpointsForGroup(BreakpointsWindow.this, groupName);
                        int size = groupBreakpoints.size();
                        this.children = new BreakpointItem[size];
                        int i = 0;
                        while (i < size) {
                            Breakpoint bp = (Breakpoint)groupBreakpoints.get(i);
                            this.children[i] = new BreakpointItem(bp);
                            ++i;
                        }
                    }
                    return this.children;
                }
                return new BreakpointItem[0];
            }

            public int hashCode() {
                return this.info.hashCode();
            }

            public boolean equals(Object o) {
                if (o instanceof BreakpointItem) {
                    BreakpointItem other = (BreakpointItem)o;
                    return this.info.equals(other.info);
                }
                return false;
            }
        }
    }

    private final class PassCountEditor
    extends DefaultCellEditor {
        PassCountEditor() {
            super(new 1());
            JTextField textField = (JTextField)this.getComponent();
            textField.addKeyListener(new 2());
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            int passCount = 0;
            BreakpointTreeTableModel.BreakpointItem breakpointItem = BreakpointsWindow.ra$model(BreakpointsWindow.this).getBreakpointItemForTreePath(BreakpointsWindow.ra$treeTable(BreakpointsWindow.this).getTree().getPathForRow(row));
            if (breakpointItem != null) {
                passCount = breakpointItem.getPassCount();
            }
            return super.getTableCellEditorComponent(table, new Integer(passCount), isSelected, row, column);
        }

        final class 1
        extends JTextField {
            public void paste() {
            }
        }

        final class 2
        extends KeyAdapter {
            public void keyTyped(KeyEvent e) {
                char c = e.getKeyChar();
                if ((c < '0' || c > '9') && c != '\b' && c != '\u007f' && c != '%' && c != '\'' && c != '$' && c != '#') {
                    e.consume();
                }
            }
        }
    }

    private class PeekableTreeTable
    extends JFastTreeTable
    implements Peekable {
        public PeekableTreeTable(BreakpointTreeTableModel model) {
            super((TreeTableModel)model);
        }

        public Peek peek(Point p) {
            return BreakpointsWindow.mav$peekAtLocation(BreakpointsWindow.this, p);
        }
    }
}

