/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.BreakpointsWindowSettings;
import oracle.jdevimpl.runner.debug.DbgArb;

public final class BreakpointsWindowSettingsPanel
extends DefaultTraversablePanel {
    private JCheckBox showColumnDescriptionCheckBox;
    private JCheckBox showColumnTypeCheckBox;
    private JCheckBox showColumnStatusCheckBox;
    private JCheckBox showColumnScopeCheckBox;
    private JCheckBox showColumnGroupCheckBox;
    private JCheckBox showColumnConditionCheckBox;
    private JCheckBox showColumnThreadCheckBox;
    private JCheckBox showColumnPasscountCheckBox;
    private JCheckBox showColumnInstanceFiltersCheckBox;
    private JCheckBox showColumnActionCheckBox;
    private JRadioButton bpScopeGlobalRadio;
    private JRadioButton bpScopeWorkspaceRadio;
    private JRadioButton bpScopeProjectRadio;

    public BreakpointsWindowSettingsPanel() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_deb_breakpointswinsetpanel_html");
        this.showColumnDescriptionCheckBox = new JCheckBox();
        this.showColumnTypeCheckBox = new JCheckBox();
        this.showColumnStatusCheckBox = new JCheckBox();
        this.showColumnScopeCheckBox = new JCheckBox();
        this.showColumnGroupCheckBox = new JCheckBox();
        this.showColumnConditionCheckBox = new JCheckBox();
        this.showColumnThreadCheckBox = new JCheckBox();
        this.showColumnPasscountCheckBox = new JCheckBox();
        this.showColumnInstanceFiltersCheckBox = new JCheckBox();
        this.showColumnActionCheckBox = new JCheckBox();
        this.bpScopeGlobalRadio = new JRadioButton();
        this.bpScopeWorkspaceRadio = new JRadioButton();
        this.bpScopeProjectRadio = new JRadioButton();
        ButtonGroup group = new ButtonGroup();
        group.add(this.bpScopeGlobalRadio);
        group.add(this.bpScopeWorkspaceRadio);
        group.add(this.bpScopeProjectRadio);
        ResourceUtils.resButton((AbstractButton)this.showColumnDescriptionCheckBox, (String)DbgArb.getString(104));
        ResourceUtils.resButton((AbstractButton)this.showColumnTypeCheckBox, (String)DbgArb.getString(6));
        ResourceUtils.resButton((AbstractButton)this.showColumnStatusCheckBox, (String)DbgArb.getString(623));
        ResourceUtils.resButton((AbstractButton)this.showColumnScopeCheckBox, (String)DbgArb.getString(820));
        ResourceUtils.resButton((AbstractButton)this.showColumnGroupCheckBox, (String)DbgArb.getString(471));
        ResourceUtils.resButton((AbstractButton)this.showColumnConditionCheckBox, (String)DbgArb.getString(707));
        ResourceUtils.resButton((AbstractButton)this.showColumnThreadCheckBox, (String)DbgArb.getString(776));
        ResourceUtils.resButton((AbstractButton)this.showColumnPasscountCheckBox, (String)DbgArb.getString(151));
        ResourceUtils.resButton((AbstractButton)this.showColumnInstanceFiltersCheckBox, (String)DbgArb.getString(335));
        ResourceUtils.resButton((AbstractButton)this.showColumnActionCheckBox, (String)DbgArb.getString(69));
        ResourceUtils.resButton((AbstractButton)this.bpScopeGlobalRadio, (String)DbgArb.getString(899));
        ResourceUtils.resButton((AbstractButton)this.bpScopeWorkspaceRadio, (String)DbgArb.getString(710));
        ResourceUtils.resButton((AbstractButton)this.bpScopeProjectRadio, (String)DbgArb.getString(478));
        this.setLayout(new GridBagLayout());
        int y = 0;
        this.add(this.makeChooseColumnsPanel(), new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.add(this.makeBPScopePanel(), new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 5), 0, 0));
        this.add(new JLabel(), new GridBagConstraints(0, y++, 0, 1, 1.0, 1.0, 17, 2, new Insets(10, 5, 0, 5), 0, 0));
    }

    private JPanel makeChooseColumnsPanel() {
        JPanel panel = new JPanel(new GridLayout(0, 2, 0, 0));
        panel.setBorder(BorderFactory.createTitledBorder(RunMgrArb.getString(70)));
        panel.add(this.showColumnDescriptionCheckBox);
        panel.add(this.showColumnTypeCheckBox);
        panel.add(this.showColumnStatusCheckBox);
        panel.add(this.showColumnScopeCheckBox);
        panel.add(this.showColumnGroupCheckBox);
        panel.add(this.showColumnConditionCheckBox);
        panel.add(this.showColumnThreadCheckBox);
        panel.add(this.showColumnPasscountCheckBox);
        panel.add(this.showColumnInstanceFiltersCheckBox);
        panel.add(this.showColumnActionCheckBox);
        return panel;
    }

    private JPanel makeBPScopePanel() {
        JPanel bpScopePanel = new JPanel(new GridLayout(3, 0, 0, 0));
        bpScopePanel.setBorder(BorderFactory.createTitledBorder(DbgArb.getString(248)));
        bpScopePanel.add(this.bpScopeGlobalRadio);
        bpScopePanel.add(this.bpScopeWorkspaceRadio);
        bpScopePanel.add(this.bpScopeProjectRadio);
        return bpScopePanel;
    }

    private BreakpointsWindowSettings getSettings(TraversableContext tc) {
        return BreakpointsWindowSettings.getInstance(tc.getPropertyStorage());
    }

    public void onEntry(TraversableContext tc) {
        BreakpointsWindowSettings settings = this.getSettings(tc);
        this.showColumnDescriptionCheckBox.setSelected(true);
        this.showColumnDescriptionCheckBox.setEnabled(false);
        this.showColumnTypeCheckBox.setSelected(settings.getColumnVisible(1));
        this.showColumnStatusCheckBox.setSelected(settings.getColumnVisible(2));
        this.showColumnScopeCheckBox.setSelected(settings.getColumnVisible(3));
        this.showColumnGroupCheckBox.setSelected(settings.getColumnVisible(4));
        this.showColumnConditionCheckBox.setSelected(settings.getColumnVisible(5));
        this.showColumnThreadCheckBox.setSelected(settings.getColumnVisible(6));
        this.showColumnPasscountCheckBox.setSelected(settings.getColumnVisible(7));
        this.showColumnInstanceFiltersCheckBox.setSelected(settings.getColumnVisible(9));
        this.showColumnActionCheckBox.setSelected(settings.getColumnVisible(8));
        this.bpScopeGlobalRadio.setSelected(false);
        this.bpScopeWorkspaceRadio.setSelected(false);
        this.bpScopeProjectRadio.setSelected(false);
        String bpScope = settings.getBreakpointScope();
        if (bpScope.equals("global")) {
            this.bpScopeGlobalRadio.setSelected(true);
        } else if (bpScope.equals("project")) {
            this.bpScopeProjectRadio.setSelected(true);
        } else {
            this.bpScopeWorkspaceRadio.setSelected(true);
        }
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        BreakpointsWindowSettings settings = this.getSettings(tc);
        settings.setColumnVisible(0, true);
        settings.setColumnVisible(1, this.showColumnTypeCheckBox.isSelected());
        settings.setColumnVisible(2, this.showColumnStatusCheckBox.isSelected());
        settings.setColumnVisible(3, this.showColumnScopeCheckBox.isSelected());
        settings.setColumnVisible(4, this.showColumnGroupCheckBox.isSelected());
        settings.setColumnVisible(5, this.showColumnConditionCheckBox.isSelected());
        settings.setColumnVisible(6, this.showColumnThreadCheckBox.isSelected());
        settings.setColumnVisible(7, this.showColumnPasscountCheckBox.isSelected());
        settings.setColumnVisible(9, this.showColumnInstanceFiltersCheckBox.isSelected());
        settings.setColumnVisible(8, this.showColumnActionCheckBox.isSelected());
        String bpScope = this.bpScopeGlobalRadio.isSelected() ? "global" : (this.bpScopeProjectRadio.isSelected() ? "project" : "workspace");
        settings.setBreakpointScope(bpScope);
    }
}

