/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.runner.debug.ClassesWindow;
import oracle.jdevimpl.runner.debug.DbgArb;

abstract class ClassesPanel
extends JPanel {
    private final JComboBox classComboBox = new JComboBox();
    private DefaultTreeModel classComboBoxTreeModel;
    private DebugClassInfo currentClass;

    protected ClassesPanel() {
    }

    protected final void createPanel(DebugClassInfo clazz) {
        JLabel classLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)classLabel, (Component)this.classComboBox, (String)DbgArb.getString(743));
        NonNullableComboBoxModel classModel = new NonNullableComboBoxModel();
        DefaultMutableTreeNode treeRoot = new DefaultMutableTreeNode();
        this.addToModel(classModel, treeRoot, clazz);
        this.setSelectedClass((ComboBoxModel)classModel);
        this.classComboBox.setModel(classModel);
        this.classComboBoxTreeModel = new DefaultTreeModel(treeRoot);
        this.classComboBox.setRenderer(new ClassComboBoxRenderer(this.classComboBoxTreeModel, this.classComboBox, null));
        JPanel body = this.createBody();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(this.getAppropriateSize());
        int y = 0;
        this.add((Component)classLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.classComboBox, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)body, new GridBagConstraints(0, y, 0, 1, 1.0, 1.0, 17, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.classComboBox.addItemListener(new 1());
        this.update();
    }

    private void addToModel(NonNullableComboBoxModel classModel, DefaultMutableTreeNode treeNode, DebugClassInfo clazz) {
        if (clazz != null) {
            ClassComboBoxItem classComboBoxItem = this.createClassComboBoxItem(clazz, classModel.getSize());
            classModel.addElement((Object)classComboBoxItem);
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(classComboBoxItem);
            treeNode.add(childNode);
            this.addToModel(classModel, childNode, clazz.getSuperClass(1));
            DebugClassInfo[] interfaces = clazz.getInterfaces();
            if (interfaces != null) {
                Arrays.sort(interfaces, new 2());
                int length = interfaces.length;
                int i = 0;
                while (i < length) {
                    classComboBoxItem = this.createClassComboBoxItem(interfaces[i], classModel.getSize());
                    classModel.addElement((Object)classComboBoxItem);
                    childNode.add(new DefaultMutableTreeNode(classComboBoxItem));
                    ++i;
                }
            }
        }
    }

    private void update() {
        if (this.currentClass != null) {
            this.saveBody(this.currentClass);
        }
        this.clearBody();
        this.currentClass = ClassComboBoxItem.ra$clazz((ClassComboBoxItem)this.classComboBox.getSelectedItem());
        this.loadBody(this.currentClass);
        this.updateNodes(this.classComboBoxTreeModel.getRoot());
    }

    private void updateNodes(Object object) {
        if (object instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)object;
            Object userObject = node.getUserObject();
            if (userObject instanceof ClassComboBoxItem) {
                ClassComboBoxItem classComboBoxItem = (ClassComboBoxItem)userObject;
                if (classComboBoxItem.isSpecial()) {
                    if (!ClassComboBoxItem.ra$isBold(classComboBoxItem)) {
                        ClassComboBoxItem.wa$isBold(classComboBoxItem, true);
                        this.classComboBoxTreeModel.nodeChanged(node);
                    }
                } else if (ClassComboBoxItem.ra$isBold(classComboBoxItem)) {
                    ClassComboBoxItem.wa$isBold(classComboBoxItem, false);
                    this.classComboBoxTreeModel.nodeChanged(node);
                }
            }
            int x = 0;
            while (x < node.getChildCount()) {
                this.updateNodes(node.getChildAt(x));
                ++x;
            }
        }
    }

    protected Component getInitialFocus() {
        return this.classComboBox;
    }

    protected final DebugClassInfo getCurrentClass() {
        return this.currentClass;
    }

    protected ClassComboBoxItem createClassComboBoxItem(DebugClassInfo clazz, int row) {
        return new ClassComboBoxItem(clazz, row);
    }

    protected void setSelectedClass(ComboBoxModel classModel) {
        classModel.setSelectedItem(classModel.getElementAt(0));
    }

    abstract JPanel createBody();

    abstract Dimension getAppropriateSize();

    abstract void saveBody(DebugClassInfo var1);

    abstract void clearBody();

    abstract void loadBody(DebugClassInfo var1);

    static void mav$update(ClassesPanel classesPanel) {
        classesPanel.update();
    }

    final class 1
    implements ItemListener {
        public void itemStateChanged(ItemEvent e) {
            ClassesPanel.mav$update(ClassesPanel.this);
        }
    }

    final class 2
    implements Comparator {
        public int compare(Object o1, Object o2) {
            String name1 = ((DebugClassInfo)o1).getName();
            String name2 = ((DebugClassInfo)o2).getName();
            return name1.compareToIgnoreCase(name2);
        }
    }

    protected class ClassComboBoxItem {
        private final DebugClassInfo clazz;
        private final int row;
        private final String toString;
        private boolean isBold;

        private void $init$() {
            this.isBold = false;
        }

        protected ClassComboBoxItem(DebugClassInfo clazz, int row) {
            this.$init$();
            this.clazz = clazz;
            this.row = row;
            this.toString = clazz.getName();
        }

        Icon getIcon() {
            if (this.clazz.isInterface()) {
                return ClassesWindow.getInterfaceIcon();
            }
            return ClassesWindow.getClassIcon();
        }

        protected boolean isSpecial() {
            return false;
        }

        public String toString() {
            return this.toString;
        }

        static boolean ra$isBold(ClassComboBoxItem classComboBoxItem) {
            return classComboBoxItem.isBold;
        }

        static void wa$isBold(ClassComboBoxItem classComboBoxItem, boolean bl) {
            classComboBoxItem.isBold = bl;
        }

        static DebugClassInfo ra$clazz(ClassComboBoxItem classComboBoxItem) {
            return classComboBoxItem.clazz;
        }

        static int ra$row(ClassComboBoxItem classComboBoxItem) {
            return classComboBoxItem.row;
        }
    }

    private class ClassComboBoxRenderer
    extends JTree
    implements ListCellRenderer {
        private final int preferredHeight;
        private final ClassTreeCellRenderer classTreeCellRenderer;
        private ClassComboBoxItem classComboBoxItem;
        private int row;
        private boolean overrideBackground;

        private ClassComboBoxRenderer(TreeModel treeModel, JComboBox comboBox) {
            super(treeModel);
            this.preferredHeight = comboBox.getPreferredSize().height;
            this.setRowHeight(this.preferredHeight);
            this.setOpaque(false);
            this.setFocusable(false);
            this.setRootVisible(false);
            this.setShowsRootHandles(false);
            int i = 0;
            while (i < this.getRowCount()) {
                this.expandRow(i);
                ++i;
            }
            TreeUI treeUI = this.getUI();
            if (treeUI instanceof BasicTreeUI) {
                BasicTreeUI basicTreeUI = (BasicTreeUI)treeUI;
                basicTreeUI.setCollapsedIcon(null);
                basicTreeUI.setExpandedIcon(null);
            }
            this.classTreeCellRenderer = new ClassTreeCellRenderer(null);
            this.setCellRenderer(this.classTreeCellRenderer);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.classComboBoxItem = (ClassComboBoxItem)value;
            this.row = ClassComboBoxItem.ra$row(this.classComboBoxItem);
            if (index == -1) {
                this.overrideBackground = true;
                ClassTreeCellRenderer.wa$overrideBackground(this.classTreeCellRenderer, true);
            } else {
                this.overrideBackground = false;
                ClassTreeCellRenderer.wa$overrideBackground(this.classTreeCellRenderer, false);
            }
            if (isSelected) {
                this.setSelectionRow(this.row);
            } else {
                this.clearSelection();
            }
            return this;
        }

        public Color getBackground() {
            if (this.overrideBackground) {
                return null;
            }
            return super.getBackground();
        }

        public void paint(Graphics g) {
            g.translate(0, -this.row * this.getRowHeight());
            super.paint(g);
        }

        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            d.height = this.preferredHeight;
            return d;
        }

        ClassComboBoxRenderer(TreeModel treeModel, JComboBox jComboBox, 1 var4_4) {
            this(treeModel, jComboBox);
        }

        class ClassTreeCellRenderer
        extends DefaultTreeCellRenderer {
            private boolean overrideBackground;

            private ClassTreeCellRenderer() {
                this.setOpaque(false);
            }

            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                DefaultMutableTreeNode node;
                Object userObject;
                Font font = tree.getFont();
                Icon icon = null;
                if (value instanceof DefaultMutableTreeNode && (userObject = (node = (DefaultMutableTreeNode)value).getUserObject()) instanceof ClassComboBoxItem) {
                    ClassComboBoxItem classComboBoxItem = (ClassComboBoxItem)userObject;
                    if (classComboBoxItem.isSpecial() && font != null) {
                        font = font.deriveFont(1);
                    }
                    icon = classComboBoxItem.getIcon();
                }
                this.setFont(font);
                this.setIcon(icon);
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                return this;
            }

            public Color getBackground() {
                if (this.overrideBackground) {
                    return null;
                }
                return super.getBackground();
            }

            public Color getBackgroundNonSelectionColor() {
                if (this.overrideBackground) {
                    return null;
                }
                return super.getBackgroundNonSelectionColor();
            }

            static void wa$overrideBackground(ClassTreeCellRenderer classTreeCellRenderer, boolean bl) {
                classTreeCellRenderer.overrideBackground = bl;
            }

            ClassTreeCellRenderer(1 var2_2) {
                this();
            }

            public final class 1 {
            }
        }

        public final class 1 {
        }
    }
}

