/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.AbstractTreeTableModel;
import oracle.ide.controls.JFastTreeTable;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.TreeTableModel;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableWindow;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.ide.model.Element;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.runner.DebuggerWindowProvider;
import oracle.ide.util.IdeProfile;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ModelUtil;
import oracle.ide.view.View;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugAnnotationInfo;
import oracle.jdevimpl.debugger.support.DebugCapabilities;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugHasAnnotations;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.debugger.support.JDIInformationProvider;
import oracle.jdevimpl.runner.Helpers;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.BaseElement;
import oracle.jdevimpl.runner.debug.ClassesWindowSettings;
import oracle.jdevimpl.runner.debug.ColumnMenuListener;
import oracle.jdevimpl.runner.debug.ContextBuilder;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugConfiguration;
import oracle.jdevimpl.runner.debug.DebugDockableFactory;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.DebuggerWindow;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.EvaluatorItem;
import oracle.jdevimpl.runner.debug.HeapWindow;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.ProfilingEvents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ClassesWindow
extends DebuggerWindow
implements TreeExpansionListener,
DragGestureListener,
DragSourceListener,
Controller,
ContextMenuListener,
ColumnMenuListener {
    private ClassTreeTableModel model;
    private JFastTreeTable treeTable;
    private JScrollPane scrollPane;
    private String title;
    private boolean skippedUpdate;
    private DebuggingProcess debuggingProcess;
    private DebugVirtualMachine vm;
    private DebugClassLoaderInfo[] allClassLoaders;
    private PackageInfo[] allPackages;
    private DebugClassInfo[] allClasses;
    private boolean canCountObjects;
    private boolean canCountMemory;
    private List tracingIncludeList;
    private List tracingExcludeList;
    private ClassesWindowSettings classesSettings;
    private int preferredVisibleRowCount;
    private static IdeAction actionGoTo;
    private static IdeAction actionViewAnnotations;
    private static IdeAction actionShowInHeap;
    private static IdeAction actionWatchClassLoader;
    private static IdeAction actionInspectClassLoader;
    private static IdeAction actionFind;
    private static IdeAction actionFindNext;
    private static IdeAction actionExpandAll;
    private static IdeAction actionCollapseAll;
    private static IdeAction actionSave;
    private static IdeAction actionSettings;
    private static JMenuItem menuitemGoTo;
    private static JMenuItem menuitemViewAnnotations;
    private static JMenuItem menuitemShowInHeap;
    private static JMenuItem menuitemWatchClassLoader;
    private static JMenuItem menuitemInspectClassLoader;
    private static JMenuItem menuitemFind;
    private static JMenuItem menuitemFindNext;
    private static JMenuItem menuitemExpandAll;
    private static JMenuItem menuitemCollapseAll;
    private static JMenuItem menuitemSave;
    private static JMenuItem menuitemSettings;
    private static final int GOTO_CMD_ID;
    private static final int VIEW_ANNOTATIONS_CMD_ID;
    private static final int SHOW_IN_HEAP_CMD_ID;
    private static final int WATCH_CLASSLOADER_CMD_ID;
    private static final int INSPECT_CLASSLOADER_CMD_ID;
    private static final int FIND_CMD_ID;
    private static final int FIND_NEXT_CMD_ID;
    private static final int EXPAND_ALL_CMD_ID;
    private static final int COLLAPSE_ALL_CMD_ID;
    private static final int SAVE_CMD_ID;
    private static final int SETTINGS_CMD_ID;
    static final int COLUMN_NAME = 0;
    static final int COLUMN_COUNT = 1;
    static final int COLUMN_MEMORY = 2;
    static final int COLUMN_FILENAME = 3;
    static final int NUMBER_OF_COLUMNS = 4;
    private TableColumn[] column;
    private int[] columnDefaultWidth;
    private boolean[] columnShowing;
    private static DataFlavor classFlavor;
    private static DataFlavor interfaceFlavor;
    private static DataFlavor arrayFlavor;
    static final String CLASSES_WINDOW_ID = "Debugger.ClassesWindow";
    private static Icon packageIconGray;
    private static Icon classIconGray;
    private static Icon classObfuscatedIcon;
    private static Icon interfaceIconGray;
    private static Icon arrayIcon;
    private static Icon arrayIconGray;
    private static Icon classLoaderIcon;
    private static Icon arrowUpIcon;
    private static Icon arrowDownIcon;
    private static final String NOT_AVAILABLE = "";
    private boolean adjustColumnsAlreadyDone;

    private void $init$() {
        this.skippedUpdate = true;
        this.preferredVisibleRowCount = 10;
        this.column = new TableColumn[4];
        this.columnDefaultWidth = new int[4];
        this.columnShowing = new boolean[4];
        this.adjustColumnsAlreadyDone = false;
    }

    ClassesWindow() {
        super(CLASSES_WINDOW_ID);
        this.$init$();
        this.title = DbgArb.getString(752);
        JDebugger.getInstance().getContextMenu().addContextMenuListener((ContextMenuListener)this);
        ClassesWindow.makeActions();
        this.setControllerForActions();
    }

    @Override
    public DebuggerWindowProvider.DebuggerWindowPosition getPosition() {
        return DebuggerWindowProvider.DebuggerWindowPosition.EAST;
    }

    @Override
    public void refresh() {
        this.everythingChanged();
    }

    public boolean installByDefault() {
        return true;
    }

    public void shutDown() {
        this.saveSettings();
    }

    private void loadSettings() {
        int i = 0;
        while (i < 4) {
            int width = this.classesSettings.getColumnWidth(i);
            if (width != 0) {
                this.adjustColumnsAlreadyDone = true;
                this.column[i].setPreferredWidth(width);
            }
            ++i;
        }
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        String order = this.classesSettings.getColumnOrder();
        if (order != null) {
            int i2 = 0;
            while (i2 < 4) {
                String identifier;
                int comma = order.indexOf(44);
                if (comma != -1) {
                    identifier = order.substring(0, comma);
                    order = order.substring(comma + 1);
                } else {
                    identifier = order;
                }
                if (identifier.length() == 0) break;
                try {
                    int from = tableColumnModel.getColumnIndex(identifier);
                    if (from != i2) {
                        this.treeTable.moveColumn(from, i2);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                ++i2;
            }
        }
    }

    private boolean hasTreeStructure() {
        return this.classesSettings.isShowClassLoaders() || this.classesSettings.isShowPackages();
    }

    private void classesWindowSettingsChanged(boolean changed) {
        if (this.treeTable == null) {
            return;
        }
        this.treeTable.getTree().setShowsRootHandles(this.hasTreeStructure());
        int i = 0;
        while (i < 4) {
            boolean show = this.classesSettings.getColumnVisible(i);
            if (this.columnShowing[i] != show) {
                this.columnShowing[i] = show;
                if (show) {
                    this.treeTable.addColumn(this.column[i]);
                } else {
                    this.treeTable.removeColumn(this.column[i]);
                }
            }
            ++i;
        }
        if (changed && this.treeTable.isEnabled()) {
            SwingUtilities.invokeLater(new 1());
        }
        Dimension d = this.treeTable.getPreferredSize();
        d.height = this.treeTable.getTableHeader().getPreferredSize().height + this.preferredVisibleRowCount * this.treeTable.getRowHeight() + this.scrollPane.getHorizontalScrollBar().getPreferredSize().height;
        this.scrollPane.setPreferredSize(d);
    }

    private void saveSettings() {
        if (this.treeTable == null) {
            return;
        }
        int i = 0;
        while (i < 4) {
            this.classesSettings.setColumnWidth(i, this.column[i].getWidth());
            ++i;
        }
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        String order = NOT_AVAILABLE;
        Enumeration<TableColumn> e = tableColumnModel.getColumns();
        while (e.hasMoreElements()) {
            TableColumn column = e.nextElement();
            order = order + column.getIdentifier() + ",";
        }
        this.classesSettings.setColumnOrder(order);
    }

    void tracingChanged() {
        if (this.debuggingProcess != null) {
            DebugConfiguration debugConfiguration = this.debuggingProcess.getDebugConfiguration();
            this.tracingIncludeList = debugConfiguration.getTracingIncludeList();
            this.tracingExcludeList = debugConfiguration.getTracingExcludeList();
            if (this.model != null) {
                ClassTreeTableModel.mav$resetIcons(this.model);
            }
        }
    }

    static void addContextMenuToMainMenu(Menubar menubar, JMenu subMenu) {
        ClassesWindow.makeActions();
        float section = 1.0f;
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGoTo), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionViewAnnotations), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionShowInHeap), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionWatchClassLoader), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionInspectClassLoader), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionFind), subMenu, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionFindNext), subMenu, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionExpandAll), subMenu, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionCollapseAll), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSave), subMenu, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSettings), subMenu, section);
    }

    public Component getGUI() {
        if (this.scrollPane == null) {
            this.classesSettings = ClassesWindowSettings.getInstance();
            this.createGUI();
            this.loadSettings();
            this.tracingChanged();
            this.classesWindowSettingsChanged(false);
            DebugDockableFactory.updateSiteGeometry((Dockable)this);
            this.everythingChanged();
            this.classesSettings.addStructureChangeListener(new 2());
        }
        return this.scrollPane;
    }

    public ContextMenu getContextMenu() {
        return JDebugger.getInstance().getContextMenu();
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_deb_classwindow_html");
    }

    public Controller getController() {
        return this;
    }

    public Context getContext(EventObject event) {
        Object info;
        ClassTreeTableModel.ClassItem classItem = this.model != null ? this.model.getSelectedClassItem() : null;
        JDIInformationProvider jdiInformationProvider = null;
        if (classItem != null && (info = classItem.getInfo()) instanceof JDIInformationProvider) {
            jdiInformationProvider = (JDIInformationProvider)info;
        }
        return ContextBuilder.buildContext((Element)classItem, (View)this, event, this.debuggingProcess, jdiInformationProvider);
    }

    public int getDefaultVisibility(Layout layout) {
        boolean visible = JDebugger.getInstance().canShowDebuggingWindows(layout);
        int ret = visible ? 3 : 0;
        return ret;
    }

    public String getTabName() {
        return this.title;
    }

    public Icon getTabIcon() {
        return OracleIcons.getIcon((String)"class.png");
    }

    public String getTitleName() {
        return this.title;
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        ClassTreeTableModel.mav$branchExpanded(this.model, event.getPath());
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        ClassTreeTableModel.mav$branchCollapsed(this.model, event.getPath());
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        Point pt;
        ClassTreeTableModel.ClassItem classItem;
        if (e.getDragAction() == 1 && (classItem = this.model.getClassItemAtPoint(pt = e.getDragOrigin())).canDrag()) {
            try {
                BufferedImage dragImage = new BufferedImage(1, 1, 6);
                dragImage.setRGB(0, 0, -16777216);
                Point imageOffset = new Point(0, 0);
                e.startDrag(null, dragImage, imageOffset, classItem, this);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent e) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent e) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent e) {
    }

    @Override
    public void dragExit(DragSourceEvent e) {
    }

    @Override
    public void dragOver(DragSourceDragEvent e) {
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == GOTO_CMD_ID) {
            ClassTreeTableModel.ClassItem classItem = this.model.getSelectedClassItem();
            if (classItem != null) {
                classItem.showSource();
            }
            return true;
        }
        if (cmdId == VIEW_ANNOTATIONS_CMD_ID) {
            ClassTreeTableModel.ClassItem classItem = this.model.getSelectedClassItem();
            if (classItem != null) {
                classItem.viewAnnotations();
            }
            return true;
        }
        if (cmdId == SHOW_IN_HEAP_CMD_ID) {
            ClassTreeTableModel.ClassItem classItem = this.model.getSelectedClassItem();
            if (classItem != null) {
                classItem.showInHeap();
            }
            return true;
        }
        if (cmdId == WATCH_CLASSLOADER_CMD_ID) {
            ClassTreeTableModel.ClassItem classItem = this.model.getSelectedClassItem();
            if (classItem != null) {
                classItem.watchClassLoader();
            }
            return true;
        }
        if (cmdId == INSPECT_CLASSLOADER_CMD_ID) {
            ClassTreeTableModel.ClassItem classItem = this.model.getSelectedClassItem();
            if (classItem != null) {
                classItem.inspectClassLoader();
            }
            return true;
        }
        if (cmdId == FIND_CMD_ID) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), "Not Implemented Yet", "Find", 1);
            return true;
        }
        if (cmdId == FIND_NEXT_CMD_ID) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), "Not Implemented Yet", "Find Next", 1);
            return true;
        }
        if (cmdId == SETTINGS_CMD_ID) {
            String[] path = new String[]{DbgArb.getString(16), DbgArb.getString(255)};
            Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), path);
            return true;
        }
        if (cmdId == EXPAND_ALL_CMD_ID) {
            ClassTreeTableModel.mav$expandAll(this.model);
            return true;
        }
        if (cmdId == COLLAPSE_ALL_CMD_ID) {
            ClassTreeTableModel.mav$collapseAll(this.model);
            return true;
        }
        if (cmdId == SAVE_CMD_ID) {
            this.saveToFile();
            return true;
        }
        if (cmdId == 18) {
            Object o;
            int column;
            ClassTreeTableModel.ClassItem classItem = this.model.getSelectedClassItem();
            if (classItem != null && (column = this.treeTable.getSelectedColumn()) != -1 && (o = this.model.getValueAt(classItem, column)) != null) {
                IdeUtil.copyToClipboard((String)o.toString());
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (action.getValue("Debugger.actionOwner") == this) {
            if (this.treeTable == null || !this.isVisible()) {
                action.setEnabled(false);
                return true;
            }
            if (!(this.treeTable.isEnabled() && this.debuggingProcess != null && this.vm != null || cmdId == SETTINGS_CMD_ID)) {
                action.setEnabled(false);
                return true;
            }
        }
        if (cmdId == GOTO_CMD_ID) {
            ClassTreeTableModel.ClassItem classItem = this.model.getSelectedClassItem();
            if (classItem != null) {
                action.setEnabled(classItem.canShowSource());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == VIEW_ANNOTATIONS_CMD_ID) {
            ClassTreeTableModel.ClassItem classItem = this.model.getSelectedClassItem();
            if (classItem != null) {
                action.setEnabled(classItem.canViewAnnotations());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == SHOW_IN_HEAP_CMD_ID) {
            ClassTreeTableModel.ClassItem classItem = this.model.getSelectedClassItem();
            if (classItem != null) {
                action.setEnabled(classItem.canShowInHeap());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == WATCH_CLASSLOADER_CMD_ID) {
            ClassTreeTableModel.ClassItem classItem = this.model.getSelectedClassItem();
            if (classItem != null) {
                action.setEnabled(classItem.canWatchInspectClassLoader());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == INSPECT_CLASSLOADER_CMD_ID) {
            ClassTreeTableModel.ClassItem classItem = this.model.getSelectedClassItem();
            if (classItem != null) {
                action.setEnabled(classItem.canWatchInspectClassLoader());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == FIND_CMD_ID) {
            action.setEnabled(false);
            return true;
        }
        if (cmdId == FIND_NEXT_CMD_ID) {
            action.setEnabled(false);
            return true;
        }
        if (cmdId == SETTINGS_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        if (cmdId == EXPAND_ALL_CMD_ID || cmdId == COLLAPSE_ALL_CMD_ID) {
            action.setEnabled(this.hasTreeStructure());
            return true;
        }
        if (cmdId == SAVE_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        if (cmdId == 18) {
            ClassTreeTableModel.ClassItem classItem = this.model.getSelectedClassItem();
            int column = this.treeTable.getSelectedColumn();
            action.setEnabled(classItem != null && column != -1);
            return true;
        }
        return false;
    }

    public void menuWillShow(ContextMenu popup) {
        Context context = popup.getContext();
        if (this.treeTable != null && (Helpers.contextMatchesSource(context, this.treeTable) || Helpers.contextMatchesSource(context, this.scrollPane))) {
            ClassTreeTableModel.ClassItem classItem = this.model.getSelectedClassItem();
            if (classItem != null) {
                this.addPopupMenuItemsForClassItem(popup, context);
            }
            this.addPopupMenuItemsForClasses(popup, context);
            this.addPopupMenuItemsForTreeTable(popup, context);
            this.addPopupMenuItemsForCommon(popup, context);
        }
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private Comparator<DebugClassLoaderInfo> getComparatorForClassLoaders() {
        return new 3();
    }

    private Comparator<PackageInfo> getComparatorForPackages() {
        return new 4();
    }

    private Comparator<DebugClassInfo> getComparatorForClasses() {
        return new 5();
    }

    @Override
    public void showColumn(int index) {
        if (index != 0) {
            this.columnShowing[index] = true;
            if (this.classesSettings != null) {
                this.classesSettings.setColumnVisible(index, true);
            }
            this.treeTable.addColumn(this.column[index]);
        }
    }

    @Override
    public void hideColumn(int index) {
        if (index != 0) {
            this.columnShowing[index] = false;
            if (this.classesSettings != null) {
                this.classesSettings.setColumnVisible(index, false);
            }
            this.treeTable.removeColumn(this.column[index]);
        }
    }

    private void createGUI() {
        List<ClassTreeTableModel.ClassItem> modelRoot = Collections.synchronizedList(new ArrayList());
        this.model = new ClassTreeTableModel(modelRoot);
        this.treeTable = new JFastTreeTable((TreeTableModel)this.model);
        this.treeTable.setKeySearchNavigable(true);
        this.treeTable.getAccessibleContext().setAccessibleName(this.getTitleName());
        this.treeTable.setAutoResizeMode(DebugWindowSettings.getInstance().getTableResizeMode());
        Set emptySet = Collections.emptySet();
        this.treeTable.setFocusTraversalKeys(0, emptySet);
        this.treeTable.setFocusTraversalKeys(1, emptySet);
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        int i = 0;
        while (i < 4) {
            this.column[i] = tableColumnModel.getColumn(i);
            this.columnDefaultWidth[i] = this.column[i].getPreferredWidth();
            this.columnShowing[i] = true;
            ++i;
        }
        boolean[] showColumnInMenu = new boolean[4];
        Arrays.fill(showColumnInMenu, true);
        showColumnInMenu[0] = false;
        JDebugger.addColumnsMenu((JTable)this.treeTable, this, showColumnInMenu);
        ListSelectionModel listSelectionModel = this.treeTable.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        JTree tree = this.treeTable.getTree();
        tree.setRootVisible(false);
        TreeSelectionModel treeSelectionModel = tree.getSelectionModel();
        treeSelectionModel.setSelectionMode(1);
        tree.addTreeExpansionListener(this);
        tree.setCellRenderer(new 6());
        this.treeTable.setDefaultRenderer(String.class, (TableCellRenderer)new 7());
        JTableHeader tableHeader = this.treeTable.getTableHeader();
        TableCellRenderer headerRenderer = tableHeader.getDefaultRenderer();
        tableHeader.setDefaultRenderer(new 8(this, headerRenderer));
        this.treeTable.addMouseListener((MouseListener)new 9());
        this.treeTable.addKeyListener((KeyListener)new 10());
        this.scrollPane = new JScrollPane((Component)this.treeTable);
        Color background = this.treeTable.getBackground();
        this.scrollPane.setBackground(background);
        this.scrollPane.getViewport().setBackground(background);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.addMouseListener(new 11());
        this.scrollPane.addComponentListener(new 12());
        this.treeTable.addHierarchyListener((HierarchyListener)new 13());
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer((Component)this.treeTable, 1, this);
        tableHeader.addMouseListener(new 14());
    }

    private void adjustColumnsAfterResize() {
        if (this.adjustColumnsAlreadyDone) {
            return;
        }
        this.adjustColumnsAlreadyDone = true;
        JDebugger.adjustColumnsAfterResize(this.scrollPane, (JTable)this.treeTable);
    }

    private static void makeActions() {
        if (actionGoTo == null) {
            actionGoTo = IdeAction.get((int)GOTO_CMD_ID, null, (String)DbgArb.getString(147), null, (Integer)DbgArb.getInteger(146), null, (int)-1, null, (boolean)false);
            actionGoTo.setEnabled(false);
            actionViewAnnotations = IdeAction.get((int)VIEW_ANNOTATIONS_CMD_ID, null, (String)DbgArb.getString(207), null, (Integer)DbgArb.getInteger(692), null, (int)-1, null, (boolean)false);
            actionViewAnnotations.setEnabled(false);
            actionShowInHeap = IdeAction.get((int)SHOW_IN_HEAP_CMD_ID, null, (String)DbgArb.getString(106), null, (Integer)DbgArb.getInteger(124), null, (int)-1, null, (boolean)false);
            actionShowInHeap.setEnabled(false);
            actionWatchClassLoader = IdeAction.get((int)WATCH_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(890), null, (Integer)DbgArb.getInteger(944), null, (int)-1, null, (boolean)false);
            actionWatchClassLoader.setEnabled(false);
            actionInspectClassLoader = IdeAction.get((int)INSPECT_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(641), null, (Integer)DbgArb.getInteger(234), null, (int)-1, null, (boolean)false);
            actionInspectClassLoader.setEnabled(false);
            actionFind = IdeAction.get((int)FIND_CMD_ID, null, (String)DbgArb.getString(427), null, (Integer)DbgArb.getInteger(639), null, (int)-1, null, (boolean)false);
            actionFind.setEnabled(false);
            actionFindNext = IdeAction.get((int)FIND_NEXT_CMD_ID, null, (String)DbgArb.getString(125), null, (Integer)DbgArb.getInteger(282), null, (int)-1, null, (boolean)false);
            actionFindNext.setEnabled(false);
            actionSettings = IdeAction.get((int)SETTINGS_CMD_ID, null, (String)RunMgrArb.getString(87), null, (Integer)RunMgrArb.getInteger(99), null, (int)-1, null, (boolean)false);
            actionSettings.setEnabled(false);
            actionExpandAll = IdeAction.get((int)EXPAND_ALL_CMD_ID, null, (String)RunMgrArb.getString(76), null, (Integer)RunMgrArb.getInteger(24), null, (int)-1, null, (boolean)false);
            actionExpandAll.setEnabled(false);
            actionCollapseAll = IdeAction.get((int)COLLAPSE_ALL_CMD_ID, null, (String)RunMgrArb.getString(0), null, (Integer)RunMgrArb.getInteger(7), null, (int)-1, null, (boolean)false);
            actionCollapseAll.setEnabled(false);
            actionSave = IdeAction.get((int)SAVE_CMD_ID, null, (String)RunMgrArb.getString(65), null, (Integer)RunMgrArb.getInteger(101), null, (int)-1, null, (boolean)false);
            actionSave.setEnabled(false);
        }
    }

    private void setControllerForActions() {
        IdeAction[] actions = new IdeAction[]{actionGoTo, actionViewAnnotations, actionShowInHeap, actionWatchClassLoader, actionInspectClassLoader, actionFind, actionFindNext, actionSettings, actionExpandAll, actionCollapseAll, actionSave};
        JDebugger.setControllerForActions(actions, this);
    }

    private void addPopupMenuItemsForClassItem(ContextMenu popup, Context context) {
        this.update(actionGoTo, context);
        if (actionGoTo.isEnabled()) {
            if (menuitemGoTo == null) {
                menuitemGoTo = popup.createMenuItem((ToggleAction)actionGoTo);
            }
            popup.add((Component)menuitemGoTo, JDeveloperMenuConstants.SECTION_NAVIGATE_CTXT_MENU);
        }
        this.update(actionViewAnnotations, context);
        if (actionViewAnnotations.isEnabled()) {
            if (menuitemViewAnnotations == null) {
                menuitemViewAnnotations = popup.createMenuItem((ToggleAction)actionViewAnnotations);
            }
            popup.add((Component)menuitemViewAnnotations, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(actionShowInHeap, context);
        if (actionShowInHeap.isEnabled()) {
            if (menuitemShowInHeap == null) {
                menuitemShowInHeap = popup.createMenuItem((ToggleAction)actionShowInHeap);
            }
            popup.add((Component)menuitemShowInHeap, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(actionWatchClassLoader, context);
        if (actionWatchClassLoader.isEnabled()) {
            if (menuitemWatchClassLoader == null) {
                menuitemWatchClassLoader = popup.createMenuItem((ToggleAction)actionWatchClassLoader);
            }
            popup.add((Component)menuitemWatchClassLoader, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(actionInspectClassLoader, context);
        if (actionInspectClassLoader.isEnabled()) {
            if (menuitemInspectClassLoader == null) {
                menuitemInspectClassLoader = popup.createMenuItem((ToggleAction)actionInspectClassLoader);
            }
            popup.add((Component)menuitemInspectClassLoader, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
    }

    private void addPopupMenuItemsForClasses(ContextMenu popup, Context context) {
        this.update(actionFind, context);
        if (actionFind.isEnabled()) {
            if (menuitemFind == null) {
                menuitemFind = popup.createMenuItem((ToggleAction)actionFind);
            }
            popup.add((Component)menuitemFind, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_SPECIFIC_CTXT_MENU);
        }
        this.update(actionFindNext, context);
        if (actionFindNext.isEnabled()) {
            if (menuitemFindNext == null) {
                menuitemFindNext = popup.createMenuItem((ToggleAction)actionFindNext);
            }
            popup.add((Component)menuitemFindNext, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_SPECIFIC_CTXT_MENU);
        }
    }

    private void addPopupMenuItemsForTreeTable(ContextMenu popup, Context context) {
        this.update(actionExpandAll, context);
        if (actionExpandAll.isEnabled()) {
            if (menuitemExpandAll == null) {
                menuitemExpandAll = popup.createMenuItem((ToggleAction)actionExpandAll);
            }
            popup.add((Component)menuitemExpandAll, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_TREE_CTXT_MENU);
        }
        this.update(actionCollapseAll, context);
        if (actionCollapseAll.isEnabled()) {
            if (menuitemCollapseAll == null) {
                menuitemCollapseAll = popup.createMenuItem((ToggleAction)actionCollapseAll);
            }
            popup.add((Component)menuitemCollapseAll, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_TREE_CTXT_MENU);
        }
    }

    private void addPopupMenuItemsForCommon(ContextMenu popup, Context context) {
        this.update(actionSave, context);
        if (actionSave.isEnabled()) {
            if (menuitemSave == null) {
                menuitemSave = popup.createMenuItem((ToggleAction)actionSave);
            }
            popup.add((Component)menuitemSave, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
        }
        this.update(actionSettings, context);
        if (actionSettings.isEnabled()) {
            if (menuitemSettings == null) {
                menuitemSettings = popup.createMenuItem((ToggleAction)actionSettings);
            }
            popup.add((Component)menuitemSettings, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
        }
    }

    void showPopup(MouseEvent e) {
        JDebugger.getInstance().showContextMenu(e, (DockableWindow)this, this.treeTable);
    }

    private void saveToFile() {
        URL url;
        String dlgTitle = RunMgrArb.format(19, this.getTitleName());
        URLChooser chooser = DialogUtil.newURLChooser((Context)this.getContext());
        if (JDebugger.lastSavedFile != null) {
            chooser.setSelectedURL(JDebugger.lastSavedFile);
        }
        if (chooser.showSaveDialog((Component)Ide.getMainWindow(), dlgTitle) == 0 && (url = chooser.getSelectedURL()) != null) {
            JDebugger.lastSavedFile = url;
            WaitCursor wc = Ide.getWaitCursor();
            wc.show();
            Exception exceptionOccurred = null;
            try {
                String suffixUpper = URLFileSystem.getSuffix((URL)url).toUpperCase();
                boolean html = suffixUpper.equals(".HTML") || suffixUpper.equals(".HTM");
                PrintWriter out = html ? JDebugger.printHtmlHeader(url, this.getTitleName()) : new PrintWriter(new BufferedOutputStream(URLFileSystem.openOutputStream((URL)url)));
                ClassTreeTableModel.mav$save(this.model, out, html);
                if (html) {
                    JDebugger.printHtmlFooter(out);
                }
                out.flush();
                out.close();
            }
            catch (Exception e) {
                exceptionOccurred = e;
            }
            wc.hide();
            if (exceptionOccurred != null) {
                String message = DbgArb.format(341, this.getTitleName(), URLFileSystem.getPlatformPathName((URL)url));
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exceptionOccurred, (String)dlgTitle, (String)message, null);
            }
        }
    }

    void nowShown() {
        if (this.skippedUpdate && this.treeTable.isEnabled()) {
            this.everythingChanged();
        }
    }

    void everythingChanged() {
        if (this.model != null) {
            this.model.updateClasses();
        }
    }

    void updateClasses(DebuggingProcess debuggingProcess, DebugVirtualMachine vm) {
        int handle = -1;
        if (ProfilingEvents.eventOn[5]) {
            handle = IdeProfile.startEvent((int)ProfilingEvents.eventId[5]);
        }
        this.debuggingProcess = debuggingProcess;
        DebugConfiguration debugConfiguration = debuggingProcess.getDebugConfiguration();
        this.tracingIncludeList = debugConfiguration.getTracingIncludeList();
        this.tracingExcludeList = debugConfiguration.getTracingExcludeList();
        this.vm = vm;
        if (vm != null) {
            DebugCapabilities capabilities = vm.getCapabilities();
            this.canCountObjects = capabilities.canCountObjectsOfClass();
            this.canCountMemory = capabilities.canCountMemoryOfClass();
        } else {
            this.canCountObjects = false;
            this.canCountMemory = false;
        }
        if (this.treeTable != null) {
            this.treeTable.setEnabled(true);
            this.everythingChanged();
        }
        if (ProfilingEvents.eventOn[5]) {
            IdeProfile.endEvent((int)handle);
        }
    }

    static long getCount(DebugClassInfo clazz) {
        if (clazz.isInterface()) {
            return -1;
        }
        return clazz.countObjectsOfClass();
    }

    static int getMemory(DebugClassInfo clazz) {
        if (clazz.isInterface()) {
            return -1;
        }
        return clazz.countMemoryOfClass();
    }

    static String makeClassLoaderName(DebugClassLoaderInfo classLoader) {
        String clName = classLoader.getClassName();
        clName = clName != null ? DbgArb.format(648, clName, Integer.toString(classLoader.getId())) : DbgArb.getString(750);
        return clName;
    }

    void clearClasses() {
        if (this.treeTable == null) {
            return;
        }
        int handle = -1;
        if (ProfilingEvents.eventOn[10]) {
            handle = IdeProfile.startEvent((int)ProfilingEvents.eventId[10]);
        }
        this.treeTable.setEnabled(false);
        this.model.clearClasses();
        this.vm = null;
        this.allClassLoaders = null;
        this.allPackages = null;
        this.allClasses = null;
        if (ProfilingEvents.eventOn[10]) {
            IdeProfile.endEvent((int)handle);
        }
    }

    void processFinished(DebuggingProcess debuggingProcess) {
        if (this.model != null) {
            this.model.processFinished(debuggingProcess);
        }
        if (this.debuggingProcess == debuggingProcess) {
            this.debuggingProcess = null;
            this.vm = null;
            this.allClassLoaders = null;
            this.allPackages = null;
            this.allClasses = null;
            if (this.treeTable != null) {
                this.treeTable.setEnabled(true);
                this.everythingChanged();
            }
        }
    }

    private static Icon getClassLoaderIcon() {
        if (classLoaderIcon == null) {
            classLoaderIcon = DbgArb.getIcon(403);
        }
        return classLoaderIcon;
    }

    private static Icon getPackageIcon() {
        return OracleIcons.getIcon((String)"package.png");
    }

    private static Icon getPackageIconGray() {
        if (packageIconGray == null) {
            packageIconGray = IdeUtil.grayIcon((Icon)ClassesWindow.getPackageIcon());
        }
        return packageIconGray;
    }

    static Icon getClassIcon() {
        return OracleIcons.getIcon((String)"class.png");
    }

    private static Icon getClassIconGray() {
        if (classIconGray == null) {
            classIconGray = IdeUtil.grayIcon((Icon)ClassesWindow.getClassIcon());
        }
        return classIconGray;
    }

    private static Icon getClassObfuscatedIcon() {
        if (classObfuscatedIcon == null) {
            classObfuscatedIcon = DbgArb.getIcon(198);
        }
        return classObfuscatedIcon;
    }

    static Icon getInterfaceIcon() {
        return OracleIcons.getIcon((String)"interface.png");
    }

    private static Icon getInterfaceIconGray() {
        if (interfaceIconGray == null) {
            interfaceIconGray = IdeUtil.grayIcon((Icon)ClassesWindow.getInterfaceIcon());
        }
        return interfaceIconGray;
    }

    private static Icon getArrayIcon() {
        if (arrayIcon == null) {
            arrayIcon = DbgArb.getIcon(742);
        }
        return arrayIcon;
    }

    private static Icon getArrayIconGray() {
        if (arrayIconGray == null) {
            arrayIconGray = IdeUtil.grayIcon((Icon)ClassesWindow.getArrayIcon());
        }
        return arrayIconGray;
    }

    private static Icon getArrowUpIcon() {
        if (arrowUpIcon == null) {
            arrowUpIcon = Helpers.getUpArrowIcon();
        }
        return arrowUpIcon;
    }

    private static Icon getArrowDownIcon() {
        if (arrowDownIcon == null) {
            arrowDownIcon = Helpers.getDownArrowIcon();
        }
        return arrowDownIcon;
    }

    static DataFlavor getClassFlavor() {
        if (classFlavor == null) {
            classFlavor = new DataFlavor(ClassFlavorData.class, "ClassFlavor");
        }
        return classFlavor;
    }

    static DataFlavor getInterfaceFlavor() {
        if (interfaceFlavor == null) {
            interfaceFlavor = new DataFlavor(InterfaceFlavorData.class, "InterfaceFlavor");
        }
        return interfaceFlavor;
    }

    static DataFlavor getArrayFlavor() {
        if (arrayFlavor == null) {
            arrayFlavor = new DataFlavor(ArrayFlavorData.class, "ArrayFlavor");
        }
        return arrayFlavor;
    }

    static {
        GOTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugClassesGoTo");
        VIEW_ANNOTATIONS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugClassesViewAnnotations");
        SHOW_IN_HEAP_CMD_ID = Ide.findOrCreateCmdID((String)"DebugClassesShowInHeap");
        WATCH_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugClassesWatchClassLoader");
        INSPECT_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugClassesInspectClassLoader");
        FIND_CMD_ID = Ide.findOrCreateCmdID((String)"DebugClassesFind");
        FIND_NEXT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugClassesFindNext");
        EXPAND_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugClassesExpandAll");
        COLLAPSE_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugClassesCollapseAll");
        SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugClassesSave");
        SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugClassesSettings");
        classFlavor = null;
        interfaceFlavor = null;
        arrayFlavor = null;
        packageIconGray = null;
        classIconGray = null;
        classObfuscatedIcon = null;
        interfaceIconGray = null;
        arrayIcon = null;
        arrayIconGray = null;
        classLoaderIcon = null;
        arrowUpIcon = null;
        arrowDownIcon = null;
    }

    static JFastTreeTable ra$treeTable(ClassesWindow classesWindow) {
        return classesWindow.treeTable;
    }

    static DebuggingProcess ra$debuggingProcess(ClassesWindow classesWindow) {
        return classesWindow.debuggingProcess;
    }

    static ClassesWindowSettings ra$classesSettings(ClassesWindow classesWindow) {
        return classesWindow.classesSettings;
    }

    static boolean ra$canCountObjects(ClassesWindow classesWindow) {
        return classesWindow.canCountObjects;
    }

    static boolean ra$canCountMemory(ClassesWindow classesWindow) {
        return classesWindow.canCountMemory;
    }

    static Comparator mav$getComparatorForClassLoaders(ClassesWindow classesWindow) {
        return classesWindow.getComparatorForClassLoaders();
    }

    static Comparator mav$getComparatorForPackages(ClassesWindow classesWindow) {
        return classesWindow.getComparatorForPackages();
    }

    static Comparator mav$getComparatorForClasses(ClassesWindow classesWindow) {
        return classesWindow.getComparatorForClasses();
    }

    static DebugClassInfo[] ra$allClasses(ClassesWindow classesWindow) {
        return classesWindow.allClasses;
    }

    static PackageInfo[] ra$allPackages(ClassesWindow classesWindow) {
        return classesWindow.allPackages;
    }

    static DebugClassLoaderInfo[] ra$allClassLoaders(ClassesWindow classesWindow) {
        return classesWindow.allClassLoaders;
    }

    static DebugVirtualMachine ra$vm(ClassesWindow classesWindow) {
        return classesWindow.vm;
    }

    static void wa$allClassLoaders(ClassesWindow classesWindow, DebugClassLoaderInfo[] debugClassLoaderInfoArray) {
        classesWindow.allClassLoaders = debugClassLoaderInfoArray;
    }

    static void wa$allClasses(ClassesWindow classesWindow, DebugClassInfo[] debugClassInfoArray) {
        classesWindow.allClasses = debugClassInfoArray;
    }

    static void wa$allPackages(ClassesWindow classesWindow, PackageInfo[] packageInfoArray) {
        classesWindow.allPackages = packageInfoArray;
    }

    static void wa$skippedUpdate(ClassesWindow classesWindow, boolean bl) {
        classesWindow.skippedUpdate = bl;
    }

    static Icon maS$getClassLoaderIcon() {
        return ClassesWindow.getClassLoaderIcon();
    }

    static Icon maS$getPackageIcon() {
        return ClassesWindow.getPackageIcon();
    }

    static Icon maS$getPackageIconGray() {
        return ClassesWindow.getPackageIconGray();
    }

    static Icon maS$getClassIconGray() {
        return ClassesWindow.getClassIconGray();
    }

    static Icon maS$getClassObfuscatedIcon() {
        return ClassesWindow.getClassObfuscatedIcon();
    }

    static Icon maS$getInterfaceIconGray() {
        return ClassesWindow.getInterfaceIconGray();
    }

    static Icon maS$getArrayIcon() {
        return ClassesWindow.getArrayIcon();
    }

    static Icon maS$getArrayIconGray() {
        return ClassesWindow.getArrayIconGray();
    }

    static List ra$tracingIncludeList(ClassesWindow classesWindow) {
        return classesWindow.tracingIncludeList;
    }

    static List ra$tracingExcludeList(ClassesWindow classesWindow) {
        return classesWindow.tracingExcludeList;
    }

    static ClassTreeTableModel ra$model(ClassesWindow classesWindow) {
        return classesWindow.model;
    }

    static Icon maS$getArrowUpIcon() {
        return ClassesWindow.getArrowUpIcon();
    }

    static Icon maS$getArrowDownIcon() {
        return ClassesWindow.getArrowDownIcon();
    }

    static IdeAction ra$actionGoTo() {
        return actionGoTo;
    }

    static void mav$adjustColumnsAfterResize(ClassesWindow classesWindow) {
        classesWindow.adjustColumnsAfterResize();
    }

    static void mav$classesWindowSettingsChanged(ClassesWindow classesWindow, boolean bl) {
        classesWindow.classesWindowSettingsChanged(bl);
    }

    final class 1
    implements Runnable {
        public void run() {
            ClassesWindow.this.everythingChanged();
        }
    }

    final class 2
    extends StructureChangeListener {
        public void structureValuesChanged(StructureChangeEvent e) {
            ClassesWindow.mav$classesWindowSettingsChanged(ClassesWindow.this, true);
        }
    }

    final class 3
    implements Comparator {
        public int compare(DebugClassLoaderInfo classLoader1, DebugClassLoaderInfo classLoader2) {
            int sortColumn = ClassesWindow.ra$classesSettings(ClassesWindow.this).getSortColumn();
            boolean sortAscending = ClassesWindow.ra$classesSettings(ClassesWindow.this).isSortAscending();
            if (ModelUtil.areEqual((Object)classLoader1.getClassName(), (Object)classLoader2.getClassName())) {
                int id1 = classLoader1.getId();
                int id2 = classLoader2.getId();
                if (sortColumn != 0 || sortAscending) {
                    return id1 - id2;
                }
                return id2 - id1;
            }
            String name1 = ClassesWindow.makeClassLoaderName(classLoader1);
            String name2 = ClassesWindow.makeClassLoaderName(classLoader2);
            if (sortColumn != 0 || sortAscending) {
                return name1.compareToIgnoreCase(name2);
            }
            return name2.compareToIgnoreCase(name1);
        }
    }

    final class 4
    implements Comparator {
        public int compare(PackageInfo pi1, PackageInfo pi2) {
            int sortColumn = ClassesWindow.ra$classesSettings(ClassesWindow.this).getSortColumn();
            boolean sortAscending = ClassesWindow.ra$classesSettings(ClassesWindow.this).isSortAscending();
            String name1 = pi1.pkg;
            String name2 = pi2.pkg;
            if (sortColumn != 0 || sortAscending) {
                return name1.compareToIgnoreCase(name2);
            }
            return name2.compareToIgnoreCase(name1);
        }
    }

    final class 5
    implements Comparator {
        public int compare(DebugClassInfo class1, DebugClassInfo class2) {
            int sortColumn = ClassesWindow.ra$classesSettings(ClassesWindow.this).getSortColumn();
            boolean sortAscending = ClassesWindow.ra$classesSettings(ClassesWindow.this).isSortAscending();
            switch (sortColumn) {
                default: {
                    String name1 = DebugShared.makeCourtesyClassName(class1, true);
                    String name2 = DebugShared.makeCourtesyClassName(class2, true);
                    if (sortAscending) {
                        return name1.compareToIgnoreCase(name2);
                    }
                    return name2.compareToIgnoreCase(name1);
                }
                case 1: {
                    if (sortAscending) {
                        return new Long(ClassesWindow.getCount(class1) - ClassesWindow.getCount(class2)).intValue();
                    }
                    return new Long(ClassesWindow.getCount(class2) - ClassesWindow.getCount(class1)).intValue();
                }
                case 2: {
                    if (sortAscending) {
                        return ClassesWindow.getMemory(class1) - ClassesWindow.getMemory(class2);
                    }
                    return ClassesWindow.getMemory(class2) - ClassesWindow.getMemory(class1);
                }
                case 3: 
            }
            if (sortAscending) {
                return class1.getPrimarySourceFilename().compareToIgnoreCase(class2.getPrimarySourceFilename());
            }
            return class2.getPrimarySourceFilename().compareToIgnoreCase(class1.getPrimarySourceFilename());
        }
    }

    final class 6
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof ClassTreeTableModel.ClassItem) {
                String accessibleDescription;
                ClassTreeTableModel.ClassItem classItem = (ClassTreeTableModel.ClassItem)value;
                this.setIcon(classItem.getIcon());
                String tooltip = classItem.getNameToolTip();
                if (tooltip != null) {
                    this.setToolTipText(tooltip);
                }
                AccessibleContext ac = this.getAccessibleContext();
                String accessibleName = ClassTreeTableModel.mav$getAccessibleNameAt(ClassesWindow.ra$model(ClassesWindow.this), classItem, 0);
                if (classItem.mayHaveChildren()) {
                    accessibleName = JDebugger.fixTreeCellAccessibleName(accessibleName, expanded);
                }
                if (accessibleName != null) {
                    ac.setAccessibleName(accessibleName);
                }
                if ((accessibleDescription = tooltip) != null) {
                    ac.setAccessibleDescription(accessibleDescription);
                }
            } else {
                this.setIcon(null);
                this.setToolTipText(null);
            }
            return this;
        }
    }

    final class 7
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String accessibleDescription;
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int modelColumn = table.convertColumnIndexToModel(column);
            int horizontalAlignment = 2;
            if (modelColumn == 1 || modelColumn == 2) {
                horizontalAlignment = 4;
            }
            this.setHorizontalAlignment(horizontalAlignment);
            String tooltip = value instanceof String ? (String)value : null;
            this.setToolTipText(tooltip);
            ClassTreeTableModel.ClassItem classItem = ClassesWindow.ra$model(ClassesWindow.this).getClassItemForTreePath(ClassesWindow.ra$treeTable(ClassesWindow.this).getTree().getPathForRow(row));
            AccessibleContext ac = this.getAccessibleContext();
            String accessibleName = ClassTreeTableModel.mav$getAccessibleNameAt(ClassesWindow.ra$model(ClassesWindow.this), classItem, modelColumn);
            if (accessibleName != null) {
                ac.setAccessibleName(accessibleName);
            }
            if ((accessibleDescription = tooltip) != null) {
                ac.setAccessibleDescription(accessibleDescription);
            }
            return this;
        }
    }

    final class 8
    extends DefaultTableCellRenderer {
        private final /* synthetic */ TableCellRenderer v$headerRenderer;
        final /* synthetic */ ClassesWindow this$0;

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (this.v$headerRenderer instanceof DefaultTableCellRenderer) {
                DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)this.v$headerRenderer;
                int modelColumn = table.convertColumnIndexToModel(column);
                int horizontalAlignment = 2;
                if (modelColumn == 1 || modelColumn == 2) {
                    horizontalAlignment = 4;
                }
                defaultTableCellRenderer.setHorizontalAlignment(horizontalAlignment);
                Icon icon = null;
                if (modelColumn == ClassesWindow.ra$classesSettings(this.this$0).getSortColumn()) {
                    icon = ClassesWindow.ra$classesSettings(this.this$0).isSortAscending() ? ClassesWindow.maS$getArrowUpIcon() : ClassesWindow.maS$getArrowDownIcon();
                }
                defaultTableCellRenderer.setIcon(icon);
            }
            return this.v$headerRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }

        public 8(ClassesWindow classesWindow, TableCellRenderer tableCellRenderer) {
            this.v$headerRenderer = tableCellRenderer;
            this.this$0 = classesWindow;
        }
    }

    final class 9
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                ClassesWindow.this.showPopup(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                ClassesWindow.this.showPopup(e);
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (ClassesWindow.ra$debuggingProcess(ClassesWindow.this) == null || !ClassesWindow.ra$debuggingProcess(ClassesWindow.this).isStopped()) {
                Toolkit.getDefaultToolkit().beep();
                DebuggingProcess.showStatus(DbgArb.format(253, ClassesWindow.this.getTitleName()));
            }
            if (JDebugger.isDoubleClickInTreeTable(ClassesWindow.ra$treeTable(ClassesWindow.this), e)) {
                Context context = ClassesWindow.this.getContext(e);
                ClassesWindow.this.update(ClassesWindow.ra$actionGoTo(), context);
                if (ClassesWindow.ra$actionGoTo().isEnabled()) {
                    ClassesWindow.this.handleEvent(ClassesWindow.ra$actionGoTo(), context);
                }
            }
        }
    }

    final class 10
    extends KeyAdapter {
        public void keyPressed(KeyEvent e) {
            int key = e.getKeyCode();
            switch (key) {
                case 10: {
                    Context context = ClassesWindow.this.getContext(e);
                    ClassesWindow.this.update(ClassesWindow.ra$actionGoTo(), context);
                    if (!ClassesWindow.ra$actionGoTo().isEnabled()) break;
                    ClassesWindow.this.handleEvent(ClassesWindow.ra$actionGoTo(), context);
                    e.consume();
                    break;
                }
            }
        }
    }

    final class 11
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                ClassesWindow.this.showPopup(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                ClassesWindow.this.showPopup(e);
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (ClassesWindow.ra$debuggingProcess(ClassesWindow.this) == null || !ClassesWindow.ra$debuggingProcess(ClassesWindow.this).isStopped()) {
                Toolkit.getDefaultToolkit().beep();
                DebuggingProcess.showStatus(DbgArb.format(253, ClassesWindow.this.getTitleName()));
            }
        }
    }

    final class 12
    extends ComponentAdapter {
        public void componentResized(ComponentEvent e) {
            ClassesWindow.mav$adjustColumnsAfterResize(ClassesWindow.this);
        }
    }

    final class 13
    implements HierarchyListener {
        public void hierarchyChanged(HierarchyEvent e) {
            if ((e.getChangeFlags() & (long)4) != 0L && ClassesWindow.ra$treeTable(ClassesWindow.this).isShowing()) {
                ClassesWindow.this.nowShown();
            }
        }
    }

    final class 14
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            if (ClassesWindow.ra$debuggingProcess(ClassesWindow.this) == null || !ClassesWindow.ra$debuggingProcess(ClassesWindow.this).isStopped()) {
                Toolkit.getDefaultToolkit().beep();
                DebuggingProcess.showStatus(DbgArb.format(253, ClassesWindow.this.getTitleName()));
            }
            if ((e.getModifiers() & 0x10) != 0 && e.getClickCount() == 1) {
                int columnAtX = ClassesWindow.ra$treeTable(ClassesWindow.this).getColumnModel().getColumnIndexAtX(e.getX());
                int column = ClassesWindow.ra$treeTable(ClassesWindow.this).convertColumnIndexToModel(columnAtX);
                if (column != -1) {
                    if (ClassesWindow.ra$classesSettings(ClassesWindow.this).getSortColumn() == column) {
                        ClassesWindow.ra$classesSettings(ClassesWindow.this).toggleSortAscending();
                    } else {
                        ClassesWindow.ra$classesSettings(ClassesWindow.this).setSortColumn(column);
                        if (column == 0) {
                            ClassesWindow.ra$classesSettings(ClassesWindow.this).setSortAscending(true);
                        } else {
                            ClassesWindow.ra$classesSettings(ClassesWindow.this).setSortAscending(false);
                        }
                    }
                    WaitCursor wc = Ide.getWaitCursor();
                    wc.show();
                    ClassesWindow.this.everythingChanged();
                    wc.hide();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ClassTreeTableModel
    extends AbstractTreeTableModel {
        private List<ClassItem> root;
        private List<ClassInfoPath> expanded;
        private ClassInfoPath savedHighlight;

        ClassTreeTableModel(List<ClassItem> root) {
            super(root);
            this.root = root;
            this.expanded = Collections.synchronizedList(new ArrayList());
        }

        void updateClasses() {
            this.saveHighlight();
            ClassesWindow.wa$allClassLoaders(ClassesWindow.this, null);
            ClassesWindow.wa$allPackages(ClassesWindow.this, null);
            ClassesWindow.wa$allClasses(ClassesWindow.this, null);
            this.root.clear();
            if (ClassesWindow.ra$treeTable(ClassesWindow.this) != null && ClassesWindow.ra$treeTable(ClassesWindow.this).isShowing()) {
                ClassesWindow.wa$skippedUpdate(ClassesWindow.this, false);
                if (ClassesWindow.ra$debuggingProcess(ClassesWindow.this) != null && ClassesWindow.ra$vm(ClassesWindow.this) != null) {
                    this.addClassItems();
                }
            } else {
                ClassesWindow.wa$skippedUpdate(ClassesWindow.this, true);
            }
            this.fireChanged();
            this.restoreHighlight(true);
        }

        private DebugClassLoaderInfo[] makeClassLoadersArray(DebugClassLoaderInfo[] classLoaders) {
            ArrayList<DebugClassLoaderInfo> list = new ArrayList<DebugClassLoaderInfo>();
            int i = 0;
            while (i < classLoaders.length) {
                DebugClassLoaderInfo classLoader = classLoaders[i];
                String clName = classLoader.getClassName();
                if (clName == null || !clName.equals("sun.reflect.DelegatingClassLoader")) {
                    list.add(classLoader);
                }
                ++i;
            }
            return list.toArray(new DebugClassLoaderInfo[list.size()]);
        }

        private DebugClassInfo[] makeClassesArray(DebugClassInfo[] classes) {
            ArrayList<DebugClassInfo> list = new ArrayList<DebugClassInfo>();
            int i = 0;
            while (i < classes.length) {
                DebugClassLoaderInfo classLoader;
                String clName;
                DebugClassInfo clazz = classes[i];
                if (!(clazz.isPrimitive() && ClassesWindow.ra$vm(ClassesWindow.this).getLanguages() != 16 || (clName = (classLoader = clazz.getClassLoader()).getClassName()) != null && clName.equals("sun.reflect.DelegatingClassLoader"))) {
                    list.add(clazz);
                }
                ++i;
            }
            return list.toArray(new DebugClassInfo[list.size()]);
        }

        private PackageInfo[] makePackagesArray(DebugClassInfo[] classes) {
            ArrayList<PackageInfo> list = new ArrayList<PackageInfo>();
            if (ClassesWindow.ra$classesSettings(ClassesWindow.this).isShowPackages()) {
                boolean showClassLoaders = ClassesWindow.ra$classesSettings(ClassesWindow.this).isShowClassLoaders();
                boolean asTree = ClassesWindow.ra$classesSettings(ClassesWindow.this).isShowPackagesAsTree();
                int i = 0;
                while (i < classes.length) {
                    DebugClassInfo clazz = classes[i];
                    PackageInfo pi = new PackageInfo(clazz);
                    if (!showClassLoaders) {
                        pi = new PackageInfo(pi.pkg, null);
                    }
                    if (pi.pkg.length() != 0 && !list.contains(pi)) {
                        list.add(pi);
                        if (asTree) {
                            int lastDot;
                            String pkg = pi.pkg;
                            DebugClassLoaderInfo classLoader = pi.classLoader;
                            while ((lastDot = pkg.lastIndexOf(46)) != -1 && !list.contains(pi = new PackageInfo(pkg = pkg.substring(0, lastDot), classLoader))) {
                                list.add(pi);
                            }
                        }
                    }
                    ++i;
                }
            }
            return list.toArray(new PackageInfo[list.size()]);
        }

        void addClassItems() {
            ClassesWindow.wa$allClassLoaders(ClassesWindow.this, this.makeClassLoadersArray(ClassesWindow.ra$vm(ClassesWindow.this).listClassLoaders()));
            ClassesWindow.wa$allClasses(ClassesWindow.this, this.makeClassesArray(ClassesWindow.ra$vm(ClassesWindow.this).listClasses()));
            ClassesWindow.wa$allPackages(ClassesWindow.this, this.makePackagesArray(ClassesWindow.ra$allClasses(ClassesWindow.this)));
            this.fixSort();
            if (ClassesWindow.ra$classesSettings(ClassesWindow.this).isShowClassLoaders()) {
                ArrayList<DebugClassLoaderInfo> classLoaders = new ArrayList<DebugClassLoaderInfo>();
                this.addClassLoaders(null, classLoaders);
                this.root.addAll(this.makeChildNodes(classLoaders, null, null));
            } else if (ClassesWindow.ra$classesSettings(ClassesWindow.this).isShowPackages()) {
                ArrayList<PackageInfo> packages = new ArrayList<PackageInfo>();
                this.addPackages(null, null, packages);
                ArrayList<DebugClassInfo> classes = new ArrayList<DebugClassInfo>();
                this.addClasses(null, ClassesWindow.NOT_AVAILABLE, classes);
                this.root.addAll(this.makeChildNodes(null, packages, classes));
            } else {
                ArrayList<DebugClassInfo> classes = new ArrayList<DebugClassInfo>();
                this.addClasses(null, null, classes);
                this.root.addAll(this.makeChildNodes(null, null, classes));
            }
        }

        private void addClassLoaders(DebugClassLoaderInfo parentClassLoader, List<DebugClassLoaderInfo> classLoaders) {
            boolean asTree = ClassesWindow.ra$classesSettings(ClassesWindow.this).isShowClassLoadersAsTree();
            if (!asTree && parentClassLoader != null) {
                return;
            }
            int i = 0;
            while (i < ClassesWindow.ra$allClassLoaders(ClassesWindow.this).length) {
                DebugClassLoaderInfo classLoader = ClassesWindow.ra$allClassLoaders(ClassesWindow.this)[i];
                boolean add = false;
                if (!asTree) {
                    add = true;
                } else if (parentClassLoader == classLoader.getParent()) {
                    add = true;
                }
                if (add) {
                    classLoaders.add(classLoader);
                }
                ++i;
            }
        }

        private void addPackages(DebugClassLoaderInfo parentClassLoader, String parentPackage, List<PackageInfo> packages) {
            boolean asTree = ClassesWindow.ra$classesSettings(ClassesWindow.this).isShowPackagesAsTree();
            if (!asTree && parentPackage != null) {
                return;
            }
            String pkgDot = null;
            int pkgDotLength = 0;
            if (parentPackage != null) {
                pkgDot = parentPackage + ".";
                pkgDotLength = pkgDot.length();
            }
            int i = 0;
            while (i < ClassesWindow.ra$allPackages(ClassesWindow.this).length) {
                PackageInfo pi = ClassesWindow.ra$allPackages(ClassesWindow.this)[i];
                if (parentClassLoader == null || parentClassLoader == pi.classLoader) {
                    boolean add = false;
                    if (!asTree) {
                        add = true;
                    } else if ((pkgDot == null || pi.pkg.startsWith(pkgDot)) && pi.pkg.indexOf(46, pkgDotLength) == -1) {
                        add = true;
                    }
                    if (add) {
                        packages.add(pi);
                    }
                }
                ++i;
            }
        }

        private void addClasses(DebugClassLoaderInfo parentClassLoader, String parentPackage, List<DebugClassInfo> classes) {
            int i = 0;
            while (i < ClassesWindow.ra$allClasses(ClassesWindow.this).length) {
                DebugClassInfo clazz = ClassesWindow.ra$allClasses(ClassesWindow.this)[i];
                if (!(parentClassLoader != null && parentClassLoader != clazz.getClassLoader() || parentPackage != null && !parentPackage.equals(DebugShared.makeCourtesyPackage(clazz)))) {
                    classes.add(clazz);
                }
                ++i;
            }
        }

        private List<ClassItem> makeChildNodes(List<DebugClassLoaderInfo> classLoaders, List<PackageInfo> packages, List<DebugClassInfo> classes) {
            ArrayList<ClassItem> list = new ArrayList<ClassItem>();
            if (classLoaders != null) {
                Collections.sort(classLoaders, ClassesWindow.mav$getComparatorForClassLoaders(ClassesWindow.this));
                for (DebugClassLoaderInfo classLoader : classLoaders) {
                    list.add(new ClassItem(classLoader));
                }
            }
            if (packages != null) {
                Collections.sort(packages, ClassesWindow.mav$getComparatorForPackages(ClassesWindow.this));
                for (PackageInfo pi : packages) {
                    list.add(new ClassItem(pi));
                }
            }
            if (classes != null) {
                Collections.sort(classes, ClassesWindow.mav$getComparatorForClasses(ClassesWindow.this));
                for (DebugClassInfo clazz : classes) {
                    list.add(new ClassItem(clazz));
                }
            }
            return list;
        }

        private void fixSort() {
            if (ClassesWindow.ra$classesSettings(ClassesWindow.this).getSortColumn() == 1 && !ClassesWindow.ra$canCountObjects(ClassesWindow.this) || ClassesWindow.ra$classesSettings(ClassesWindow.this).getSortColumn() == 2 && !ClassesWindow.ra$canCountMemory(ClassesWindow.this)) {
                ClassesWindow.ra$classesSettings(ClassesWindow.this).setSortColumn(0);
                ClassesWindow.ra$classesSettings(ClassesWindow.this).setSortAscending(true);
            }
        }

        void fireChanged() {
            TreePath rootTreePath = new TreePath(this.root);
            this.fireTreeStructureChanged((Object)this, rootTreePath.getPath(), null, null);
            this.restoreExpanded(rootTreePath);
        }

        void clearClasses() {
            this.saveHighlight();
            this.clearAll();
        }

        void processFinished(DebuggingProcess debuggingProcess) {
            ArrayList<ClassInfoPath> remove = new ArrayList<ClassInfoPath>();
            for (ClassInfoPath classInfoPath : this.expanded) {
                if (classInfoPath.getDebuggingProcess() != debuggingProcess) continue;
                remove.add(classInfoPath);
            }
            for (ClassInfoPath classInfoPath : remove) {
                this.expanded.remove(classInfoPath);
            }
            if (this.savedHighlight != null && this.savedHighlight.getDebuggingProcess() == debuggingProcess) {
                this.savedHighlight = null;
            }
        }

        private void clearAll() {
            this.clearAll(ClassesWindow.ra$treeTable(ClassesWindow.this).getTree(), new TreePath(this.root));
        }

        private void clearAll(JTree tree, TreePath treePath) {
            Object node = treePath.getLastPathComponent();
            if (node instanceof ClassItem) {
                ((ClassItem)node).clearClass();
            }
            int count = this.getChildCountLazy(node);
            int i = 0;
            while (i < count) {
                Object child = this.getChildLazy(node, i);
                if (child != null) {
                    this.clearAll(tree, treePath.pathByAddingChild(child));
                }
                ++i;
            }
        }

        private void restoreExpanded(TreePath treePath) {
            JTree tree = ClassesWindow.ra$treeTable(ClassesWindow.this).getTree();
            if (tree.isExpanded(treePath)) {
                Object node = treePath.getLastPathComponent();
                Iterator itChildren = this.getChildren(node);
                while (itChildren.hasNext()) {
                    Object child = itChildren.next();
                    TreePath childTreePath = treePath.pathByAddingChild(child);
                    ClassInfoPath classInfoPath = this.convertTreePathToClassInfoPath(childTreePath);
                    if (!this.expanded.contains(classInfoPath)) continue;
                    tree.expandPath(childTreePath);
                }
            }
        }

        private void branchExpanded(TreePath treePath) {
            ClassInfoPath classInfoPath = this.convertTreePathToClassInfoPath(treePath);
            if (classInfoPath != null) {
                int i = this.expanded.indexOf(classInfoPath);
                if (i != -1) {
                    this.expanded.remove(i);
                }
                this.expanded.add(classInfoPath);
                this.restoreExpanded(treePath);
            }
        }

        private void branchCollapsed(TreePath treePath) {
            ClassInfoPath classInfoPath = this.convertTreePathToClassInfoPath(treePath);
            if (classInfoPath != null) {
                this.expanded.remove(classInfoPath);
            }
        }

        private void saveHighlight() {
            ClassInfoPath savedHighlight = this.getCurrentHighlight();
            if (savedHighlight != null) {
                this.savedHighlight = savedHighlight;
            }
        }

        private void restoreHighlight(boolean scrollToVisible) {
            if (this.savedHighlight != null) {
                this.savedHighlight = this.savedHighlight.updateClassInfoPath();
                TreePath treePath = this.makeVisible(this.savedHighlight);
                JDebugger.getInstance().selectTreeTablePath(ClassesWindow.ra$treeTable(ClassesWindow.this), treePath, scrollToVisible);
            }
        }

        TreePath makeVisible(ClassInfoPath classInfoPath) {
            TreePath treePath = this.convertClassInfoPathToTreePath(classInfoPath);
            if (treePath != null) {
                ClassesWindow.ra$treeTable(ClassesWindow.this).getTree().makeVisible(treePath);
            }
            return treePath;
        }

        ClassInfoPath getCurrentHighlight() {
            TreePath treePath = ClassesWindow.ra$treeTable(ClassesWindow.this).getTree().getSelectionPath();
            if (treePath != null) {
                return this.convertTreePathToClassInfoPath(treePath);
            }
            return null;
        }

        ClassItem getClassItemAtPoint(Point pt) {
            int row = ClassesWindow.ra$treeTable(ClassesWindow.this).rowAtPoint(pt);
            TreePath treePath = ClassesWindow.ra$treeTable(ClassesWindow.this).getTree().getPathForRow(row);
            return this.getClassItemForTreePath(treePath);
        }

        ClassItem getClassItemForTreePath(TreePath treePath) {
            Object node;
            if (treePath != null && (node = treePath.getLastPathComponent()) instanceof ClassItem) {
                return (ClassItem)node;
            }
            return null;
        }

        ClassInfoPath convertTreePathToClassInfoPath(TreePath treePath) {
            boolean foundOneClassInfo = false;
            Object[] path = treePath.getPath();
            int length = path.length;
            Object[] classInfoArray = new Object[length];
            int i = 0;
            while (i < length) {
                Object node = path[i];
                if (node instanceof ClassItem) {
                    classInfoArray[i] = ((ClassItem)node).getInfo();
                    if (classInfoArray[i] != null) {
                        foundOneClassInfo = true;
                    }
                }
                ++i;
            }
            if (foundOneClassInfo) {
                return new ClassInfoPath(ClassesWindow.ra$debuggingProcess(ClassesWindow.this), classInfoArray);
            }
            return null;
        }

        TreePath convertClassInfoPathToTreePath(ClassInfoPath classInfoPath) {
            int classInfoPathSize = classInfoPath.size();
            if (classInfoPathSize == 0) {
                return null;
            }
            List<ClassItem> node = this.root;
            TreePath treePath = new TreePath(node);
            int i = 1;
            while (i < classInfoPathSize) {
                Object classInfo = classInfoPath.getClassInfo(i);
                Object nextNode = null;
                Iterator itChildren = this.getChildren(node);
                while (itChildren.hasNext()) {
                    Object nextClassInfo;
                    Object child = itChildren.next();
                    if (!(child instanceof ClassItem) || !((nextClassInfo = ((ClassItem)child).getInfo()) == null ? classInfo == null : nextClassInfo.equals(classInfo))) continue;
                    nextNode = child;
                    break;
                }
                if (nextNode == null) {
                    return null;
                }
                node = nextNode;
                treePath = treePath.pathByAddingChild(node);
                ++i;
            }
            return treePath;
        }

        ClassItem getSelectedClassItem() {
            TreePath treePath = ClassesWindow.ra$treeTable(ClassesWindow.this).getTree().getSelectionPath();
            return this.getClassItemForTreePath(treePath);
        }

        private void resetIcons() {
            this.resetIconsRecurse(new TreePath(this.root));
            ClassesWindow.ra$treeTable(ClassesWindow.this).repaint(ClassesWindow.ra$treeTable(ClassesWindow.this).getVisibleRect());
        }

        private void resetIcons(TreePath treePath) {
            this.resetIconsRecurse(treePath);
            ClassesWindow.ra$treeTable(ClassesWindow.this).repaint(ClassesWindow.ra$treeTable(ClassesWindow.this).getVisibleRect());
        }

        private void resetIconsRecurse(TreePath treePath) {
            Object node = treePath.getLastPathComponent();
            if (node instanceof ClassItem) {
                ClassItem.mav$setIconAppropriately((ClassItem)node);
            }
            int count = this.getChildCountLazy(node);
            int i = 0;
            while (i < count) {
                Object child = this.getChildLazy(node, i);
                if (child != null) {
                    this.resetIconsRecurse(treePath.pathByAddingChild(child));
                }
                ++i;
            }
        }

        private void expandAll() {
            WaitCursor wc = Ide.getWaitCursor();
            wc.show();
            this.expandAll(ClassesWindow.ra$treeTable(ClassesWindow.this).getTree(), new TreePath(this.root));
            wc.hide();
        }

        private void expandAll(JTree tree, TreePath treePath) {
            Object node = treePath.getLastPathComponent();
            tree.expandPath(treePath);
            int count = this.getChildCount(node);
            int i = 0;
            while (i < count) {
                Object child = this.getChild(node, i);
                this.expandAll(tree, treePath.pathByAddingChild(child));
                ++i;
            }
        }

        private void collapseAll() {
            WaitCursor wc = Ide.getWaitCursor();
            wc.show();
            this.collapseAll(ClassesWindow.ra$treeTable(ClassesWindow.this).getTree(), new TreePath(this.root));
            wc.hide();
            this.expanded.clear();
        }

        private void collapseAll(JTree tree, TreePath treePath) {
            Object node = treePath.getLastPathComponent();
            int count = this.getChildCountLazy(node);
            int i = 0;
            while (i < count) {
                Object child = this.getChildLazy(node, i);
                if (child != null) {
                    this.collapseAll(tree, treePath.pathByAddingChild(child));
                }
                ++i;
            }
            if (!node.equals(this.root)) {
                tree.collapsePath(treePath);
            }
        }

        private void save(PrintWriter out, boolean html) {
            if (html) {
                out.println("<table border=\"1\">");
            }
            this.saveHeader(out, html);
            this.save(ClassesWindow.ra$treeTable(ClassesWindow.this).getTree(), new TreePath(this.root), out, html, ClassesWindow.NOT_AVAILABLE);
            if (html) {
                out.println("</table>");
            }
        }

        private void saveHeader(PrintWriter out, boolean html) {
            StringBuffer sb = new StringBuffer();
            StringBuffer sb2 = new StringBuffer();
            if (html) {
                sb.append("<tr>");
            }
            TableColumnModel tableColumnModel = ClassesWindow.ra$treeTable(ClassesWindow.this).getColumnModel();
            Enumeration<TableColumn> e = tableColumnModel.getColumns();
            while (e.hasMoreElements()) {
                TableColumn column = e.nextElement();
                int i = column.getModelIndex();
                String columnName = this.getColumnName(i);
                if (html) {
                    sb.append("<th>");
                    columnName = IdeUtil.replaceHTMLReservedCharacters((String)columnName.toString());
                    sb.append(columnName);
                    sb.append("</th>");
                    continue;
                }
                sb.append(columnName);
                int ii = columnName.length();
                while (ii >= 0) {
                    sb2.append('-');
                    --ii;
                }
                if (!e.hasMoreElements()) continue;
                sb.append('\t');
                sb2.append('\t');
            }
            if (html) {
                sb.append("</tr>");
            }
            out.println(sb.toString());
            if (!html) {
                out.println(sb2.toString());
            }
        }

        private void save(JTree tree, TreePath treePath, PrintWriter out, boolean html, String indent) {
            if (tree.isVisible(treePath)) {
                Object node = treePath.getLastPathComponent();
                if (node instanceof ClassItem) {
                    ClassItem classItem = (ClassItem)node;
                    StringBuffer sb = new StringBuffer();
                    if (html) {
                        sb.append("<tr>");
                    }
                    TableColumnModel tableColumnModel = ClassesWindow.ra$treeTable(ClassesWindow.this).getColumnModel();
                    Enumeration<TableColumn> e = tableColumnModel.getColumns();
                    while (e.hasMoreElements()) {
                        String iconLabel;
                        TableColumn column = e.nextElement();
                        int i = column.getModelIndex();
                        Object columnValue = this.getValueAt(node, i);
                        if (html) {
                            String iconLabel2;
                            String columnValueString;
                            sb.append("<td>");
                            if (i == 0) {
                                sb.append("<tt>");
                                if (indent != null) {
                                    sb.append(indent);
                                }
                                if (tree.isExpanded(treePath)) {
                                    sb.append("-&nbsp;");
                                } else if (classItem.mayHaveChildren()) {
                                    sb.append("+&nbsp;");
                                } else {
                                    sb.append("&nbsp;&nbsp;");
                                }
                                sb.append("</tt>");
                            }
                            if ((columnValueString = IdeUtil.replaceHTMLReservedCharacters((String)columnValue.toString())).length() > 0) {
                                sb.append(columnValueString);
                            } else {
                                sb.append("&nbsp;");
                            }
                            if (i == 0 && (iconLabel2 = classItem.getIconLabel(" (", ")")) != null && iconLabel2.length() > 0) {
                                sb.append(iconLabel2);
                            }
                            sb.append("</td>");
                            continue;
                        }
                        if (i == 0) {
                            if (indent != null) {
                                sb.append(indent);
                            }
                            if (tree.isExpanded(treePath)) {
                                sb.append("- ");
                            } else if (classItem.mayHaveChildren()) {
                                sb.append("+ ");
                            } else {
                                sb.append("  ");
                            }
                        }
                        sb.append(columnValue);
                        if (i == 0 && (iconLabel = classItem.getIconLabel(" (", ")")) != null && iconLabel.length() > 0) {
                            sb.append(iconLabel);
                        }
                        if (!e.hasMoreElements()) continue;
                        sb.append('\t');
                    }
                    if (html) {
                        sb.append("</tr>");
                    }
                    out.println(sb.toString());
                }
                if (node != this.root) {
                    indent = html ? indent + "&nbsp;&nbsp;&nbsp;&nbsp;" : indent + "    ";
                }
                int count = this.getChildCountLazy(node);
                int i = 0;
                while (i < count) {
                    Object child = this.getChildLazy(node, i);
                    if (child != null) {
                        this.save(tree, treePath.pathByAddingChild(child), out, html, indent);
                    }
                    ++i;
                }
            }
        }

        public boolean isLeaf(Object node) {
            try {
                if (node == this.root) {
                    boolean bl = false;
                    return bl;
                }
                ClassItem classItem = (ClassItem)node;
                boolean bl = classItem.mayHaveChildren() ^ true;
                return bl;
            }
            catch (Exception e) {
                e.printStackTrace();
                return true;
            }
        }

        Iterator getChildren(Object parent) {
            if (parent == this.root) {
                return this.root.iterator();
            }
            ClassItem classItem = (ClassItem)parent;
            return classItem.getChildren();
        }

        private int getChildCountLazy(Object parent) {
            if (parent instanceof List) {
                return ((List)parent).size();
            }
            ClassItem classItem = (ClassItem)parent;
            if (ClassItem.ra$children(classItem) != null) {
                return ClassItem.ra$children(classItem).size();
            }
            return 0;
        }

        private Object getChildLazy(Object parent, int index) {
            if (parent instanceof List) {
                return ((List)parent).get(index);
            }
            ClassItem classItem = (ClassItem)parent;
            if (ClassItem.ra$children(classItem) != null) {
                return (ClassItem)ClassItem.ra$children(classItem).get(index);
            }
            return null;
        }

        public Object getChild(Object parent, int index) {
            try {
                if (parent instanceof List) {
                    Object e = ((List)parent).get(index);
                    return e;
                }
                ClassItem classItem = (ClassItem)parent;
                ClassItem classItem2 = classItem.getChildNodes().get(index);
                return classItem2;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public int getChildCount(Object parent) {
            try {
                if (parent instanceof List) {
                    int n = ((List)parent).size();
                    return n;
                }
                ClassItem classItem = (ClassItem)parent;
                int n = classItem.countChildNodes();
                return n;
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return DbgArb.getString(231);
                }
                case 1: {
                    return DbgArb.getString(145);
                }
                case 2: {
                    return DbgArb.getString(763);
                }
                case 3: {
                    return DbgArb.getString(38);
                }
            }
            return ClassesWindow.NOT_AVAILABLE;
        }

        public Class getColumnClass(int column) {
            if (column == 0) {
                return TreeTableModel.class;
            }
            return String.class;
        }

        public Object getValueAt(Object node, int column) {
            try {
                if (node instanceof List) {
                    switch (column) {
                        case 0: {
                            String string = "root";
                            return string;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            String string = ClassesWindow.NOT_AVAILABLE;
                            return string;
                        }
                    }
                    Object var7_5 = null;
                    return var7_5;
                }
                ClassItem classItem = (ClassItem)node;
                switch (column) {
                    case 0: {
                        String string = classItem.getName();
                        return string;
                    }
                    case 1: {
                        String string = classItem.getCount();
                        return string;
                    }
                    case 2: {
                        String string = classItem.getMemory();
                        return string;
                    }
                    case 3: {
                        String string = classItem.getFilename();
                        return string;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        private String getAccessibleNameAt(ClassItem classItem, int column) {
            int id;
            if (classItem.isPackage()) {
                id = 469;
            } else if (classItem.isClass()) {
                id = 129;
            } else if (classItem.isInterface()) {
                id = 218;
            } else if (classItem.isArrayClass()) {
                id = 661;
            } else {
                return null;
            }
            String columnName = this.getColumnName(column);
            String value = (String)this.getValueAt(classItem, column);
            if (value.length() == 0) {
                value = DbgArb.getString(32);
            }
            return DbgArb.format(id, columnName, value);
        }

        static void mav$save(ClassTreeTableModel classTreeTableModel, PrintWriter printWriter, boolean bl) {
            classTreeTableModel.save(printWriter, bl);
        }

        static void mav$expandAll(ClassTreeTableModel classTreeTableModel) {
            classTreeTableModel.expandAll();
        }

        static void mav$collapseAll(ClassTreeTableModel classTreeTableModel) {
            classTreeTableModel.collapseAll();
        }

        static void mav$branchCollapsed(ClassTreeTableModel classTreeTableModel, TreePath treePath) {
            classTreeTableModel.branchCollapsed(treePath);
        }

        static void mav$branchExpanded(ClassTreeTableModel classTreeTableModel, TreePath treePath) {
            classTreeTableModel.branchExpanded(treePath);
        }

        static void mav$resetIcons(ClassTreeTableModel classTreeTableModel) {
            classTreeTableModel.resetIcons();
        }

        static void mav$addClassLoaders(ClassTreeTableModel classTreeTableModel, DebugClassLoaderInfo debugClassLoaderInfo, List list) {
            classTreeTableModel.addClassLoaders(debugClassLoaderInfo, list);
        }

        static void mav$addPackages(ClassTreeTableModel classTreeTableModel, DebugClassLoaderInfo debugClassLoaderInfo, String string, List list) {
            classTreeTableModel.addPackages(debugClassLoaderInfo, string, list);
        }

        static void mav$addClasses(ClassTreeTableModel classTreeTableModel, DebugClassLoaderInfo debugClassLoaderInfo, String string, List list) {
            classTreeTableModel.addClasses(debugClassLoaderInfo, string, list);
        }

        static List mav$makeChildNodes(ClassTreeTableModel classTreeTableModel, List list, List list2, List list3) {
            return classTreeTableModel.makeChildNodes(list, list2, list3);
        }

        static String mav$getAccessibleNameAt(ClassTreeTableModel classTreeTableModel, ClassItem classItem, int n) {
            return classTreeTableModel.getAccessibleNameAt(classItem, n);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class ClassItem
        extends BaseElement
        implements Transferable {
            private Object info;
            private DebugClassLoaderInfo classLoader;
            private DataFlavor dragFlavor;
            private List<ClassItem> children;
            private Boolean cachedMayHaveChildren;
            private String cachedName;
            private String cachedCount;
            private String cachedMemory;
            private String cachedFilename;

            ClassItem(DebugClassLoaderInfo classLoader) {
                this.classLoader = classLoader;
                this.init(classLoader);
            }

            ClassItem(PackageInfo pi) {
                this.classLoader = pi.classLoader;
                this.init(pi);
            }

            ClassItem(DebugClassInfo clazz) {
                this.classLoader = clazz.getClassLoader();
                this.init(clazz);
            }

            private void init(Object info) {
                this.info = info;
                this.setDragFlavorAppropriately();
                this.setIconAppropriately();
            }

            private void setDragFlavorAppropriately() {
                if (this.info instanceof DebugClassInfo) {
                    DebugClassInfo clazz = (DebugClassInfo)this.info;
                    if (clazz.isObject()) {
                        this.dragFlavor = ClassesWindow.getClassFlavor();
                    } else if (clazz.isInterface()) {
                        this.dragFlavor = ClassesWindow.getInterfaceFlavor();
                    } else if (clazz.isArray()) {
                        this.dragFlavor = ClassesWindow.getArrayFlavor();
                    }
                }
            }

            private void setIconAppropriately() {
                if (this.info instanceof DebugClassLoaderInfo) {
                    this.setIcon(ClassesWindow.maS$getClassLoaderIcon());
                } else {
                    Icon icon = null;
                    Icon iconGray = null;
                    if (this.info instanceof PackageInfo) {
                        icon = ClassesWindow.maS$getPackageIcon();
                        iconGray = ClassesWindow.maS$getPackageIconGray();
                    } else if (this.info instanceof DebugClassInfo) {
                        DebugClassInfo clazz = (DebugClassInfo)this.info;
                        if (clazz.isArray()) {
                            icon = ClassesWindow.maS$getArrayIcon();
                            iconGray = ClassesWindow.maS$getArrayIconGray();
                        } else if (clazz.isInterface()) {
                            icon = ClassesWindow.getInterfaceIcon();
                            iconGray = ClassesWindow.maS$getInterfaceIconGray();
                        } else {
                            if (clazz.isDebuggable()) {
                                if (clazz.isObfuscated()) {
                                    this.setIcon(ClassesWindow.maS$getClassObfuscatedIcon());
                                } else {
                                    this.setIcon(ClassesWindow.getClassIcon());
                                }
                            } else {
                                this.setIcon(ClassesWindow.maS$getClassIconGray());
                            }
                            return;
                        }
                    }
                    if (icon != null && iconGray != null) {
                        String name = this.getRealName();
                        if (DebugShared.isClassOrPackageDebuggable(name, ClassesWindow.ra$tracingIncludeList(ClassesWindow.this), ClassesWindow.ra$tracingExcludeList(ClassesWindow.this))) {
                            this.setIcon(icon);
                        } else {
                            this.setIcon(iconGray);
                        }
                    }
                }
            }

            String getIconLabel(String pre, String post) {
                int key = -1;
                Icon icon = this.getIcon();
                if (icon == ClassesWindow.maS$getClassLoaderIcon()) {
                    key = 280;
                } else if (icon == ClassesWindow.maS$getPackageIcon()) {
                    key = 464;
                } else if (icon == ClassesWindow.maS$getPackageIconGray()) {
                    key = 814;
                } else if (icon == ClassesWindow.getClassIcon()) {
                    key = 259;
                } else if (icon == ClassesWindow.maS$getClassIconGray()) {
                    key = 866;
                } else if (icon == ClassesWindow.maS$getClassObfuscatedIcon()) {
                    key = 55;
                } else if (icon == ClassesWindow.getInterfaceIcon()) {
                    key = 792;
                } else if (icon == ClassesWindow.maS$getInterfaceIconGray()) {
                    key = 239;
                } else if (icon == ClassesWindow.maS$getArrayIcon()) {
                    key = 393;
                } else if (icon == ClassesWindow.maS$getArrayIconGray()) {
                    key = 902;
                }
                if (key != -1) {
                    return pre + DbgArb.getString(key) + post;
                }
                return null;
            }

            String getNameToolTip() {
                StringBuffer toolTip = new StringBuffer();
                if (this.info instanceof DebugClassLoaderInfo) {
                    toolTip.append(ClassesWindow.makeClassLoaderName(this.classLoader));
                } else if (this.info instanceof PackageInfo) {
                    toolTip.append(((PackageInfo)this.info).pkg);
                } else if (this.info instanceof DebugClassInfo) {
                    toolTip.append(DebugShared.makeCourtesyClassName((DebugClassInfo)this.info, true));
                } else {
                    return null;
                }
                String iconLabel = this.getIconLabel(" (", ")");
                if (iconLabel != null && iconLabel.length() > 0) {
                    toolTip.append(iconLabel);
                }
                return toolTip.toString();
            }

            boolean isClassLoader() {
                return this.info instanceof DebugClassLoaderInfo;
            }

            boolean isPackage() {
                return this.info instanceof PackageInfo;
            }

            boolean isClass() {
                return this.info instanceof DebugClassInfo && ((DebugClassInfo)this.info).isObject();
            }

            boolean isInterface() {
                return this.info instanceof DebugClassInfo && ((DebugClassInfo)this.info).isInterface();
            }

            boolean isArrayClass() {
                return this.info instanceof DebugClassInfo && ((DebugClassInfo)this.info).isArray();
            }

            void clearClass() {
                this.info = null;
            }

            Object getInfo() {
                return this.info;
            }

            @Override
            public String getShortLabel() {
                return this.getName();
            }

            @Override
            public Object getData() {
                return this;
            }

            @Override
            public boolean mayHaveChildren() {
                if (this.cachedMayHaveChildren == null && ClassesWindow.ra$treeTable(ClassesWindow.this).isEnabled()) {
                    this.cachedMayHaveChildren = this.info instanceof DebugClassLoaderInfo ? Boolean.TRUE : (this.info instanceof PackageInfo ? Boolean.TRUE : Boolean.FALSE);
                }
                if (this.cachedMayHaveChildren != null) {
                    return this.cachedMayHaveChildren;
                }
                return false;
            }

            @Override
            public Iterator getChildren() {
                return this.getChildNodes().iterator();
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                DataFlavor[] transferFlavors = this.dragFlavor != null ? new DataFlavor[]{this.dragFlavor, DataFlavor.stringFlavor} : new DataFlavor[]{DataFlavor.stringFlavor};
                return transferFlavors;
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                if (this.dragFlavor != null && flavor.equals(this.dragFlavor)) {
                    return true;
                }
                return flavor.equals(DataFlavor.stringFlavor);
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
                if (this.dragFlavor != null && flavor.equals(this.dragFlavor)) {
                    ClassFlavorData data = null;
                    if (this.dragFlavor == ClassesWindow.getClassFlavor()) {
                        data = new ClassFlavorData(this.info, null);
                    } else if (this.dragFlavor == ClassesWindow.getInterfaceFlavor()) {
                        data = new InterfaceFlavorData(this.info, null);
                    } else if (this.dragFlavor == ClassesWindow.getArrayFlavor()) {
                        data = new ArrayFlavorData(this.info, null);
                    }
                    return data;
                }
                if (flavor.equals(DataFlavor.stringFlavor)) {
                    return this.getShortLabel();
                }
                throw new UnsupportedFlavorException(flavor);
            }

            public String getName() {
                if (this.cachedName == null && ClassesWindow.ra$treeTable(ClassesWindow.this).isEnabled()) {
                    if (this.info instanceof DebugClassLoaderInfo) {
                        this.cachedName = ClassesWindow.makeClassLoaderName(this.classLoader);
                    } else if (this.info instanceof PackageInfo) {
                        if (ClassesWindow.ra$classesSettings(ClassesWindow.this).isShowPackagesAsTree()) {
                            String s = ((PackageInfo)this.info).pkg;
                            int i = s.lastIndexOf(46);
                            if (i != -1) {
                                s = s.substring(i + 1);
                            }
                            this.cachedName = s;
                        } else {
                            this.cachedName = ((PackageInfo)this.info).pkg;
                        }
                    } else if (this.info instanceof DebugClassInfo) {
                        this.cachedName = ClassesWindow.ra$classesSettings(ClassesWindow.this).isShowPackages() ? DebugShared.makeCourtesyClassName((DebugClassInfo)this.info, false) : DebugShared.makeCourtesyClassName((DebugClassInfo)this.info, true);
                    }
                }
                if (this.cachedName != null) {
                    return this.cachedName;
                }
                return ClassesWindow.NOT_AVAILABLE;
            }

            public String getCount() {
                if (this.cachedCount == null && ClassesWindow.ra$treeTable(ClassesWindow.this).isEnabled()) {
                    long count;
                    this.cachedCount = ClassesWindow.ra$canCountObjects(ClassesWindow.this) && this.info instanceof DebugClassInfo ? ((count = ClassesWindow.getCount((DebugClassInfo)this.info)) >= 0L ? Long.toString(count) : ClassesWindow.NOT_AVAILABLE) : ClassesWindow.NOT_AVAILABLE;
                }
                if (this.cachedCount != null) {
                    return this.cachedCount;
                }
                return ClassesWindow.NOT_AVAILABLE;
            }

            public String getMemory() {
                if (this.cachedMemory == null && ClassesWindow.ra$treeTable(ClassesWindow.this).isEnabled()) {
                    int memory;
                    this.cachedMemory = ClassesWindow.ra$canCountMemory(ClassesWindow.this) && this.info instanceof DebugClassInfo ? ((memory = ClassesWindow.getMemory((DebugClassInfo)this.info)) >= 0 ? Integer.toString(memory) : ClassesWindow.NOT_AVAILABLE) : ClassesWindow.NOT_AVAILABLE;
                }
                if (this.cachedMemory != null) {
                    return this.cachedMemory;
                }
                return ClassesWindow.NOT_AVAILABLE;
            }

            public String getFilename() {
                if (this.cachedFilename == null && ClassesWindow.ra$treeTable(ClassesWindow.this).isEnabled()) {
                    this.cachedFilename = this.info instanceof DebugClassInfo ? ((DebugClassInfo)this.info).getPrimarySourceFilename() : ClassesWindow.NOT_AVAILABLE;
                }
                if (this.cachedFilename != null) {
                    return this.cachedFilename;
                }
                return ClassesWindow.NOT_AVAILABLE;
            }

            private List<ClassItem> makeChildren() {
                ArrayList classes;
                ArrayList packages;
                ArrayList classLoaders;
                block3: {
                    block2: {
                        classLoaders = new ArrayList();
                        packages = new ArrayList();
                        classes = new ArrayList();
                        if (!(this.info instanceof DebugClassLoaderInfo)) break block2;
                        ClassTreeTableModel.mav$addClassLoaders(ClassTreeTableModel.this, this.classLoader, classLoaders);
                        if (ClassesWindow.ra$classesSettings(ClassesWindow.this).isShowPackages()) {
                            ClassTreeTableModel.mav$addPackages(ClassTreeTableModel.this, this.classLoader, null, packages);
                            ClassTreeTableModel.mav$addClasses(ClassTreeTableModel.this, this.classLoader, ClassesWindow.NOT_AVAILABLE, classes);
                        } else {
                            ClassTreeTableModel.mav$addClasses(ClassTreeTableModel.this, this.classLoader, null, classes);
                        }
                        break block3;
                    }
                    if (!(this.info instanceof PackageInfo)) break block3;
                    String parentPackage = ((PackageInfo)this.info).pkg;
                    ClassTreeTableModel.mav$addPackages(ClassTreeTableModel.this, this.classLoader, parentPackage, packages);
                    ClassTreeTableModel.mav$addClasses(ClassTreeTableModel.this, this.classLoader, parentPackage, classes);
                }
                return ClassTreeTableModel.mav$makeChildNodes(ClassTreeTableModel.this, classLoaders, packages, classes);
            }

            int countChildNodes() {
                if (this.children == null) {
                    this.children = this.makeChildren();
                }
                if (this.children != null) {
                    return this.children.size();
                }
                return 0;
            }

            List<ClassItem> getChildNodes() {
                if (this.children == null) {
                    this.children = this.makeChildren();
                }
                return this.children;
            }

            String getRealName() {
                if (this.info instanceof DebugClassLoaderInfo) {
                    return null;
                }
                if (this.info instanceof PackageInfo) {
                    return ((PackageInfo)this.info).pkg;
                }
                if (this.info instanceof DebugClassInfo) {
                    DebugClassInfo clazz = (DebugClassInfo)this.info;
                    return clazz.getName();
                }
                return null;
            }

            boolean canShowSource() {
                if (this.info instanceof DebugClassInfo) {
                    String sourceFilename = ((DebugClassInfo)this.info).getPrimarySourceFilename();
                    return sourceFilename != null && sourceFilename.length() > 0;
                }
                return false;
            }

            void showSource() {
                if (this.info instanceof DebugClassInfo) {
                    DebugClassInfo clazz = (DebugClassInfo)this.info;
                    ClassesWindow.ra$debuggingProcess(ClassesWindow.this).showSourceFile(clazz);
                }
            }

            boolean canViewAnnotations() {
                return this.info instanceof DebugClassInfo && this.info instanceof DebugHasAnnotations && ((DebugHasAnnotations)this.info).countAnnotations() > 0;
            }

            void viewAnnotations() {
                if (this.info instanceof DebugClassInfo && this.info instanceof DebugHasAnnotations) {
                    DebugAnnotationInfo[] annotations = ((DebugHasAnnotations)this.info).getAnnotations();
                    String className = ((DebugClassInfo)this.info).getName();
                    String dlgTitle = DbgArb.format(184, className);
                    DataPanel.showAnnotationsDialog(dlgTitle, null, ClassesWindow.ra$debuggingProcess(ClassesWindow.this), ClassesWindow.ra$vm(ClassesWindow.this), null, null, annotations);
                }
            }

            boolean canDrag() {
                return this.dragFlavor != null;
            }

            boolean canShowInHeap() {
                if (JDebugger.getInstance().canShowHeapWindow() && this.info instanceof DebugClassInfo) {
                    DebugClassInfo clazz = (DebugClassInfo)this.info;
                    return clazz.isObject() || clazz.isArray();
                }
                return false;
            }

            void showInHeap() {
                DebugClassInfo clazz;
                if (JDebugger.getInstance().canShowHeapWindow() && this.info instanceof DebugClassInfo && ((clazz = (DebugClassInfo)this.info).isObject() || clazz.isArray())) {
                    String className = clazz.getName();
                    JDebugger jdebugger = JDebugger.getInstance();
                    jdebugger.viewHeap();
                    HeapWindow heapWindow = jdebugger.getHeapWindow(true);
                    heapWindow.addHeapClass(className);
                }
            }

            boolean canWatchInspectClassLoader() {
                DebugDataObjectInfo classLoaderObject;
                return !(this.info instanceof PackageInfo) && this.classLoader != null && (classLoaderObject = this.classLoader.getClassLoaderObject()) != null && !classLoaderObject.isNull();
            }

            void watchClassLoader() {
                DebugDataObjectInfo classLoaderObject;
                if (!(this.info instanceof PackageInfo) && this.classLoader != null && (classLoaderObject = this.classLoader.getClassLoaderObject()) != null && !classLoaderObject.isNull()) {
                    String name = ClassesWindow.makeClassLoaderName(this.classLoader);
                    EvaluatorItem ei = ClassesWindow.ra$debuggingProcess(ClassesWindow.this).makeTemporaryEvaluatorItem(name, classLoaderObject);
                    JDebugger.getInstance().addWatch(ei);
                }
            }

            void inspectClassLoader() {
                DebugDataObjectInfo classLoaderObject;
                if (!(this.info instanceof PackageInfo) && this.classLoader != null && (classLoaderObject = this.classLoader.getClassLoaderObject()) != null && !classLoaderObject.isNull()) {
                    String name = ClassesWindow.makeClassLoaderName(this.classLoader);
                    EvaluatorItem ei = ClassesWindow.ra$debuggingProcess(ClassesWindow.this).makeTemporaryEvaluatorItem(name, classLoaderObject);
                    JDebugger.getInstance().inspect(ei);
                }
            }

            static List ra$children(ClassItem classItem) {
                return classItem.children;
            }

            static void mav$setIconAppropriately(ClassItem classItem) {
                classItem.setIconAppropriately();
            }
        }
    }

    private final class ClassInfoPath {
        private final DebuggingProcess debuggingProcess;
        private final Object[] classInfoArray;

        ClassInfoPath(DebuggingProcess debuggingProcess, Object[] classInfoArray) {
            this.debuggingProcess = debuggingProcess;
            this.classInfoArray = classInfoArray;
        }

        DebuggingProcess getDebuggingProcess() {
            return this.debuggingProcess;
        }

        int size() {
            return this.classInfoArray.length;
        }

        Object getClassInfo(int index) {
            return this.classInfoArray[index];
        }

        ClassInfoPath updateClassInfoPath() {
            ArrayList<Object> temp = new ArrayList<Object>();
            int size = this.classInfoArray.length;
            if (size > 0) {
                boolean showClassLoaders = ClassesWindow.ra$classesSettings(ClassesWindow.this).isShowClassLoaders();
                boolean showClassLoadersAsTree = ClassesWindow.ra$classesSettings(ClassesWindow.this).isShowClassLoadersAsTree();
                boolean showPackages = ClassesWindow.ra$classesSettings(ClassesWindow.this).isShowPackages();
                boolean showPackagesAsTree = ClassesWindow.ra$classesSettings(ClassesWindow.this).isShowPackagesAsTree();
                Object info = this.classInfoArray[size - 1];
                while (info != null) {
                    if (info instanceof DebugClassLoaderInfo && showClassLoaders || info instanceof PackageInfo && showPackages || info instanceof DebugClassInfo) {
                        temp.add(0, info);
                    }
                    Object parent = null;
                    if (info instanceof DebugClassLoaderInfo) {
                        parent = showClassLoadersAsTree ? ((DebugClassLoaderInfo)info).getParent() : null;
                    } else if (info instanceof PackageInfo) {
                        if (showPackagesAsTree) {
                            PackageInfo piParent = ((PackageInfo)info).getParentPackageInfo();
                            if (piParent != null) {
                                parent = piParent;
                            } else if (showClassLoaders) {
                                parent = ((PackageInfo)info).classLoader;
                            }
                        } else if (showClassLoaders) {
                            parent = ((PackageInfo)info).classLoader;
                        }
                    } else if (info instanceof DebugClassInfo) {
                        if (showPackages) {
                            PackageInfo piParent = new PackageInfo((DebugClassInfo)info);
                            if (piParent.pkg.length() != 0) {
                                parent = piParent;
                            } else if (showClassLoaders) {
                                parent = ((DebugClassInfo)info).getClassLoader();
                            }
                        } else if (showClassLoaders) {
                            parent = ((DebugClassInfo)info).getClassLoader();
                        }
                    }
                    info = parent;
                }
            }
            temp.add(0, null);
            Object[] array = temp.toArray(new Object[temp.size()]);
            return new ClassInfoPath(this.debuggingProcess, array);
        }

        public int hashCode() {
            return this.debuggingProcess.hashCode() + this.classInfoArray.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof ClassInfoPath) {
                ClassInfoPath other = (ClassInfoPath)o;
                return this.debuggingProcess == other.debuggingProcess && Arrays.equals(this.classInfoArray, other.classInfoArray);
            }
            return false;
        }
    }

    static class ClassFlavorData {
        private String name;

        private ClassFlavorData(Object info) {
            this.name = info instanceof DebugClassInfo ? ((DebugClassInfo)info).getName() : info.toString();
        }

        String getName() {
            return this.name;
        }

        ClassFlavorData(Object object, 1 var2_2) {
            this(object);
        }

        public final class 1 {
        }
    }

    private static class InterfaceFlavorData
    extends ClassFlavorData {
        private InterfaceFlavorData(Object info) {
            super(info, null);
        }

        InterfaceFlavorData(Object object, 1 var2_2) {
            this(object);
        }

        public final class 1 {
        }
    }

    private static class ArrayFlavorData
    extends ClassFlavorData {
        private ArrayFlavorData(Object info) {
            super(info, null);
        }

        ArrayFlavorData(Object object, 1 var2_2) {
            this(object);
        }

        public final class 1 {
        }
    }

    static class PackageInfo {
        final String pkg;
        final DebugClassLoaderInfo classLoader;
        private int hashCode;

        PackageInfo(DebugClassInfo clazz) {
            this(DebugShared.makeCourtesyPackage(clazz), clazz.getClassLoader());
        }

        PackageInfo(String pkg, DebugClassLoaderInfo classLoader) {
            this.pkg = pkg;
            this.classLoader = classLoader;
        }

        PackageInfo getParentPackageInfo() {
            int lastDot = this.pkg.lastIndexOf(46);
            if (lastDot != -1) {
                String parentPkg = this.pkg.substring(0, lastDot);
                return new PackageInfo(parentPkg, this.classLoader);
            }
            return null;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode += this.pkg.hashCode();
                if (this.classLoader != null) {
                    this.hashCode += this.classLoader.hashCode();
                }
            }
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (o instanceof PackageInfo) {
                PackageInfo other = (PackageInfo)o;
                return this.pkg.equals(other.pkg) && this.classLoader == other.classLoader;
            }
            return false;
        }
    }
}

