/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import oracle.javatools.data.HashStructure;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DataPanelSettings;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.ObjectPreferencesPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CustomDataProvider
extends DataPanel {
    CustomDataProvider() {
        super("", DataPanelSettings.getInstance(HashStructure.newInstance()));
    }

    void updateContext(DebuggingProcess debuggingProcess, DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo stackFrame) {
        this.debuggingProcess = debuggingProcess;
        this.vm = vm;
        this.thread = thread;
        this.frame = stackFrame;
    }

    DataPanel.DataItem makeDataItem(Object info, String expressionOverride) {
        return new DataPanel.DataItem(this, info, null, expressionOverride);
    }

    Object getDataInfo(DataPanel.DataItem dataItem) {
        return dataItem.getDataInfo();
    }

    @Override
    protected void addDataItems() {
    }

    boolean mayHaveChildren(DataPanel.DataItem dataItem) {
        return dataItem.mayHaveChildren();
    }

    Iterator<DataPanel.DataItem> getChildren(DataPanel.DataItem dataItem) {
        dataItem.isExpanded = true;
        return dataItem.getChildren();
    }

    String getName(DataPanel.DataItem dataItem) {
        return dataItem.getDisplayName();
    }

    String getValue(DataPanel.DataItem dataItem) {
        return dataItem.getValue();
    }

    Icon getIcon(DataPanel.DataItem dataItem) {
        return dataItem.getIcon();
    }

    String getActualType(DataPanel.DataItem dataItem) {
        return dataItem.getActualType();
    }

    String getFullyQualifiedActualType(DataPanel.DataItem dataItem) {
        return dataItem.getFullyQualifiedActualType();
    }

    String getDeclaredType(DataPanel.DataItem dataItem) {
        return dataItem.getDeclaredType();
    }

    String getFullyQualifiedDeclaredType(DataPanel.DataItem dataItem) {
        return dataItem.getFullyQualifiedDeclaredType();
    }

    String getHexValue(DataPanel.DataItem dataItem) {
        return dataItem.getHexValue();
    }

    String getAddress(DataPanel.DataItem dataItem) {
        return dataItem.getAddress();
    }

    void inspect(TreePath treePath, DataPanel.DataItem dataItem) {
        dataItem.inspect(treePath, dataItem.getDisplayName());
    }

    boolean canInspect(TreePath treePath, DataPanel.DataItem dataItem) {
        return dataItem.canWatchAndInspect(treePath);
    }

    void watch(TreePath treePath, DataPanel.DataItem dataItem) {
        dataItem.watch(treePath, dataItem.getDisplayName());
    }

    boolean canWatch(TreePath treePath, DataPanel.DataItem dataItem) {
        return dataItem.canWatchAndInspect(treePath);
    }

    void inspectClassLoader(DataPanel.DataItem dataItem) {
        dataItem.inspectClassLoader();
    }

    boolean canInspectClassLoader(DataPanel.DataItem dataItem) {
        return dataItem.canWatchInspectClassLoader();
    }

    void watchClassLoader(DataPanel.DataItem dataItem) {
        dataItem.watchClassLoader();
    }

    boolean canWatchClassLoader(DataPanel.DataItem dataItem) {
        return dataItem.canWatchInspectClassLoader();
    }

    void viewWholeValue(DataPanel.DataItem dataItem) {
        dataItem.viewWhole();
    }

    boolean canViewWholeValue(DataPanel.DataItem dataItem) {
        return dataItem.canViewWhole();
    }

    void gotoDeclaredType(DataPanel.DataItem dataItem) {
        dataItem.showSource(this._GOTO_DECLARED_CMD_ID);
    }

    String canGotoDeclaredType(DataPanel.DataItem dataItem) {
        return dataItem.canShowSource(this._GOTO_DECLARED_CMD_ID);
    }

    void gotoActualType(DataPanel.DataItem dataItem) {
        dataItem.showSource(this._GOTO_CMD_ID);
    }

    String canGotoActualType(DataPanel.DataItem dataItem) {
        return dataItem.canShowSource(this._GOTO_CMD_ID);
    }

    void gotoField(DataPanel.DataItem dataItem) {
        dataItem.showSource(this._GOTO_FIELD_CMD_ID);
    }

    String canGotoField(DataPanel.DataItem dataItem) {
        return dataItem.canShowSource(this._GOTO_FIELD_CMD_ID);
    }

    void adjustRange(TreePath treePath, DataPanel.DataItem dataItem) {
        dataItem.adjustRange(treePath);
    }

    boolean canAdjustRange(DataPanel.DataItem dataItem) {
        return dataItem.canAdjustRange();
    }

    void showObjectPreferences(DataPanel.DataItem dataItem) {
        if (dataItem.data instanceof DebugDataObjectInfo && dataItem.actualClassInfo != null) {
            ObjectPreferencesPanel.showObjectPreferencesDialog(dataItem.actualClassInfo, this.dataPanelSettings.isSortFieldsByName());
        }
    }

    boolean canShowObjectPreferences(DataPanel.DataItem dataItem) {
        return dataItem.data instanceof DebugDataObjectInfo && dataItem.actualClassInfo != null;
    }

    void toggleValue(DataPanel.DataItem dataItem) {
        dataItem.toggleValue();
    }

    boolean canToggleValue(DataPanel.DataItem dataItem) {
        return dataItem.canToggleValue();
    }

    void viewAnnotations(DataPanel.DataItem dataItem) {
        dataItem.viewAnnotations();
    }

    String canViewAnnotations(DataPanel.DataItem dataItem) {
        return dataItem.canViewAnnotations();
    }

    void viewAnnotationsForClass(DataPanel.DataItem dataItem) {
        dataItem.viewAnnotationsForClass();
    }

    boolean canViewAnnotationsForClass(DataPanel.DataItem dataItem) {
        return dataItem.canViewAnnotationsForClass();
    }

    void modifyValue(DataPanel.DataItem dataItem) {
        dataItem.modifyValue();
    }

    boolean canModifyValue(DataPanel.DataItem dataItem) {
        return dataItem.canModifyValue();
    }

    void setDisplayShowPackages(boolean setting) {
        this.dataPanelSettings.setShowPackages(setting);
    }

    void setDisplaySortFieldsByName(boolean setting) {
        this.dataPanelSettings.setSortFieldsByName(setting);
    }

    void setDisplayHideStaticFields(boolean setting) {
        this.dataPanelSettings.setHideStaticFields(setting);
    }

    void setDisplayHideFinalFields(boolean setting) {
        this.dataPanelSettings.setHideFinalFields(setting);
    }

    void setDisplayHideSyntheticFields(boolean setting) {
        this.dataPanelSettings.setHideSyntheticFields(setting);
    }

    void setDisplayHideNullArrayElements(boolean setting) {
        this.dataPanelSettings.setHideNullArrayElements(setting);
    }

    List<DataPanel.DataItem> getFields(DataPanel.DataItem dataItem) {
        dataItem.isExpanded = true;
        return dataItem.getFields();
    }

    List<DataPanel.DataItem> getDeclaredFields(DataPanel.DataItem dataItem) {
        dataItem.isExpanded = true;
        return dataItem.getFields();
    }

    DataPanel.DataItem getField(DataPanel.DataItem dataItem, String fieldName) {
        dataItem.isExpanded = true;
        return dataItem.getField(fieldName);
    }
}

