/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.bali.inspector.swing.AbstractTableCellEditor;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.AbstractTreeTableModel;
import oracle.ide.controls.JFastTreeTable;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.TreeTableModel;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.docking.DockableWindow;
import oracle.ide.model.Element;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.ide.util.Encodings;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.util.IdeProfile;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.View;
import oracle.ideri.util.Product;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.shared.GenericSignature;
import oracle.jdevimpl.debugger.support.DataExpiredException;
import oracle.jdevimpl.debugger.support.DebugAnnotationInfo;
import oracle.jdevimpl.debugger.support.DebugArrayElementInfo;
import oracle.jdevimpl.debugger.support.DebugBreakpoint;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugDataArrayInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugDataPrimitiveInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugHasAnnotations;
import oracle.jdevimpl.debugger.support.DebugHasExpired;
import oracle.jdevimpl.debugger.support.DebugHeapAncestor;
import oracle.jdevimpl.debugger.support.DebugHeapAncestorInPinTable;
import oracle.jdevimpl.debugger.support.DebugHeapAncestorInRegister;
import oracle.jdevimpl.debugger.support.DebugHeapAncestorInStack;
import oracle.jdevimpl.debugger.support.DebugHeapAncestorInStatic;
import oracle.jdevimpl.debugger.support.DebugHeapAncestorInsideHeap;
import oracle.jdevimpl.debugger.support.DebugHeapAncestorOutsideHeap;
import oracle.jdevimpl.debugger.support.DebugHeapInfo;
import oracle.jdevimpl.debugger.support.DebugHeapObjectInfo;
import oracle.jdevimpl.debugger.support.DebugHeapSubset;
import oracle.jdevimpl.debugger.support.DebugHeapSubsetAncestors;
import oracle.jdevimpl.debugger.support.DebugHeapSubsetClasses;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugMonitorInfo;
import oracle.jdevimpl.debugger.support.DebugRegisterInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugStackSlotInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.debugger.support.JDIInformationProvider;
import oracle.jdevimpl.runner.Helpers;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.AdjustRangeDialog;
import oracle.jdevimpl.runner.debug.BaseElement;
import oracle.jdevimpl.runner.debug.Breakpoint;
import oracle.jdevimpl.runner.debug.ClassesWindow;
import oracle.jdevimpl.runner.debug.ColumnMenuListener;
import oracle.jdevimpl.runner.debug.ContextBuilder;
import oracle.jdevimpl.runner.debug.DataPanelSettings;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.EvaluationInfo;
import oracle.jdevimpl.runner.debug.Evaluator;
import oracle.jdevimpl.runner.debug.EvaluatorItem;
import oracle.jdevimpl.runner.debug.Expression;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.LocalsWindowSettings;
import oracle.jdevimpl.runner.debug.MemoViewDialog;
import oracle.jdevimpl.runner.debug.ModifyValueDialog;
import oracle.jdevimpl.runner.debug.ObjectPreferences;
import oracle.jdevimpl.runner.debug.ObjectPreferencesPanel;
import oracle.jdevimpl.runner.debug.ProfilingEvents;
import oracle.jdevimpl.runner.debug.UpdateableDataWindow;
import oracle.jdevimpl.runner.xslt.XSLTRunnerAddin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class DataPanel
implements TreeExpansionListener,
TreeSelectionListener,
DragGestureListener,
DragSourceListener,
DropTargetListener,
Controller,
ContextMenuListener,
ColumnMenuListener,
UpdateableDataWindow {
    protected DockableWindow dockableWindow;
    protected String title;
    protected DataTreeTableModel model;
    protected JFastTreeTable treeTable;
    private JScrollPane scrollPane;
    private DataTreeCellRenderer dataTreeCellRenderer;
    private DataTableCellRenderer dataTableCellRenderer;
    private boolean skippedUpdate;
    protected DebuggingProcess debuggingProcess;
    protected DebugVirtualMachine vm;
    protected DebugThreadInfo thread;
    protected DebugStackFrameInfo frame;
    private boolean useFilters;
    private ObjectPreferences objectPreferences;
    private static final String BREAKPOINT_INSTANCE_FILTER_CMD_PREFIX = "DebugDataInstanceFilter";
    private Map breakpointInstanceFilterActions;
    private Map arrayRanges;
    protected boolean selectFirstRowIfNoPreviousSelection;
    protected DataPanelSettings dataPanelSettings;
    protected int preferredVisibleRowCount;
    protected Font ancestorDepthZeroFont;
    protected Font heapAncestorOutsideHeapFont;
    protected IdeAction _actionViewWhole;
    protected IdeAction _actionViewAnnotations;
    protected IdeAction _actionViewAnnotationsForClass;
    protected IdeAction _actionAdjustRange;
    protected IdeAction _actionToggleValue;
    protected IdeAction _actionModifyValue;
    protected IdeAction _actionDiagram;
    protected IdeAction _actionWatch;
    protected IdeAction _actionInspect;
    protected IdeAction _actionWatchClassLoader;
    protected IdeAction _actionInspectClassLoader;
    protected IdeAction _actionGoto;
    protected IdeAction _actionGotoDeclared;
    protected IdeAction _actionGotoField;
    protected IdeAction _actionUseFilters;
    protected IdeAction _actionObjectPreferences;
    protected IdeAction _actionCollapseAll;
    protected IdeAction _actionSave;
    protected JMenuItem _menuitemViewWhole;
    protected JMenuItem _menuitemViewAnnotations;
    protected JMenuItem _menuitemViewAnnotationsForClass;
    protected JMenuItem _menuitemAdjustRange;
    protected JMenuItem _menuitemToggleValue;
    protected JMenuItem _menuitemModifyValue;
    protected JMenuItem _menuitemDiagram;
    protected JMenuItem _menuitemWatch;
    protected JMenuItem _menuitemInspect;
    protected JMenuItem _menuitemWatchClassLoader;
    protected JMenuItem _menuitemInspectClassLoader;
    protected JMenuItem _menuitemGoto;
    protected JMenuItem _menuitemGotoDeclared;
    protected JMenuItem _menuitemGotoField;
    protected JMenuItem _menuitemUseFilters;
    protected JMenuItem _menuitemObjectPreferences;
    protected JMenuItem _menuitemCollapseAll;
    protected JMenuItem _menuitemSave;
    protected int _VIEW_WHOLE_CMD_ID;
    protected int _VIEW_ANNOTATIONS_CMD_ID;
    protected int _VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID;
    protected int _ADJUST_RANGE_CMD_ID;
    protected int _TOGGLE_VALUE_CMD_ID;
    protected int _MODIFY_VALUE_CMD_ID;
    protected int _DIAGRAM_CMD_ID;
    protected int _WATCH_CMD_ID;
    protected int _INSPECT_CMD_ID;
    protected int _WATCH_CLASSLOADER_CMD_ID;
    protected int _INSPECT_CLASSLOADER_CMD_ID;
    protected int _GOTO_CMD_ID;
    protected int _GOTO_DECLARED_CMD_ID;
    protected int _GOTO_FIELD_CMD_ID;
    protected int _USE_FILTERS_CMD_ID;
    protected int _OBJECT_PREFERENCES_CMD_ID;
    protected int _COLLAPSE_ALL_CMD_ID;
    protected int _SAVE_CMD_ID;
    static final int COLUMN_NAME = 0;
    static final int COLUMN_VALUE = 1;
    static final int COLUMN_ACTUAL_TYPE = 2;
    static final int COLUMN_DECLARED_TYPE = 3;
    static final int COLUMN_HEX_VALUE = 4;
    static final int COLUMN_ADDRESS = 5;
    static final int COLUMN_ID = 6;
    static final int NUMBER_OF_COLUMNS = 7;
    protected TableColumn[] column;
    protected int[] columnDefaultWidth;
    private boolean[] columnShowing;
    private static DataFlavor expressionFlavor = null;
    private static DataFlavor heapObjectFlavor = null;
    private static DataFlavor[] transferFlavors;
    private static Icon primitiveIconGray;
    private static Icon objectIconGray;
    private static Icon arrayIcon;
    private static Icon arrayIconGray;
    private static Icon staticFolderIcon;
    private static Icon heapFolderIcon;
    private static final String NOT_AVAILABLE = "";
    private static int defaultArrayRangeMax;
    private Object modelUpdateLock;
    private static final ExecutorService UPDATE_SCHEDULER;
    private boolean canUpdateData;
    private boolean adjustColumnsAlreadyDone;
    private Font normalFont;
    private Font boldFont;
    private Font boldItalicFont;

    private void $init$() {
        this.skippedUpdate = true;
        this.preferredVisibleRowCount = 6;
        this.ancestorDepthZeroFont = null;
        this.heapAncestorOutsideHeapFont = null;
        this.column = new TableColumn[7];
        this.columnDefaultWidth = new int[7];
        this.columnShowing = new boolean[7];
        this.modelUpdateLock = new Object();
        this.canUpdateData = true;
        this.adjustColumnsAlreadyDone = false;
    }

    static void showAnnotationsDialog(String title, DataPanelSettings dataPanelSettings, DebuggingProcess debuggingProcess, DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo frame, DebugAnnotationInfo[] annotations) {
        TreePath treePath;
        if (dataPanelSettings == null) {
            dataPanelSettings = LocalsWindowSettings.getInstance().getDataPanelSettings();
        }
        1 dataPanel = new 1(title, dataPanelSettings, annotations);
        Component dataPanelGUI = dataPanel.getGUI();
        dataPanel.loadSettings();
        dataPanel.debugWindowSettingsChanged(DebugWindowSettings.getInstance());
        dataPanel.dataPanelSettingsChanged(false);
        dataPanel.updateData(debuggingProcess, vm, thread, frame);
        if (annotations.length == 1 && dataPanel.treeTable.getModel().getRowCount() > 0 && (treePath = dataPanel.treeTable.getTree().getPathForRow(0)) != null) {
            dataPanel.treeTable.getTree().expandPath(treePath);
        }
        OnePageWizardDialogFactory.runDialog((Component)dataPanelGUI, (Component)dataPanel.treeTable, (String)title, (int)1);
    }

    DataPanel(String title, DataPanelSettings dataPanelSettings) {
        this(dataPanelSettings);
        this.title = title;
    }

    DataPanel(DockableWindow dockableWindow, DataPanelSettings dataPanelSettings) {
        this(dataPanelSettings);
        this.dockableWindow = dockableWindow;
        this.title = dockableWindow.getTitleName();
    }

    private DataPanel(DataPanelSettings dataPanelSettings) {
        this.$init$();
        this.dataPanelSettings = dataPanelSettings;
        JDebugger jdebugger = JDebugger.getInstance();
        this.objectPreferences = jdebugger.getObjectPreferences();
        this.breakpointInstanceFilterActions = new HashMap(10);
        this.arrayRanges = new HashMap();
        jdebugger.getContextMenu().addContextMenuListener((ContextMenuListener)this);
        dataPanelSettings.addStructureChangeListener(new 2());
    }

    private boolean isParentVisible() {
        if (this.dockableWindow != null) {
            return this.dockableWindow.isVisible();
        }
        return this.scrollPane != null;
    }

    @Override
    public void showColumn(int index) {
        if (index != 0) {
            this.columnShowing[index] = true;
            if (this.dataPanelSettings != null) {
                this.dataPanelSettings.setColumnVisible(index, true);
            }
            this.treeTable.addColumn(this.column[index]);
        }
    }

    @Override
    public void hideColumn(int index) {
        if (index != 0) {
            this.columnShowing[index] = false;
            if (this.dataPanelSettings != null) {
                this.dataPanelSettings.setColumnVisible(index, false);
            }
            this.treeTable.removeColumn(this.column[index]);
        }
    }

    private void createGUI() {
        List modelRoot = Collections.synchronizedList(new ArrayList());
        this.model = new DataTreeTableModel(modelRoot);
        this.treeTable = new JFastTreeTable((TreeTableModel)this.model);
        this.treeTable.setKeySearchNavigable(true);
        this.treeTable.getAccessibleContext().setAccessibleName(this.title);
        this.treeTable.setAutoResizeMode(DebugWindowSettings.getInstance().getTableResizeMode());
        Set emptySet = Collections.emptySet();
        this.treeTable.setFocusTraversalKeys(0, emptySet);
        this.treeTable.setFocusTraversalKeys(1, emptySet);
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        int i = 0;
        while (i < 7) {
            this.column[i] = tableColumnModel.getColumn(i);
            this.columnDefaultWidth[i] = this.column[i].getPreferredWidth();
            this.columnShowing[i] = true;
            ++i;
        }
        boolean[] showColumnInMenu = new boolean[7];
        Arrays.fill(showColumnInMenu, true);
        showColumnInMenu[0] = false;
        JDebugger.addColumnsMenu((JTable)this.treeTable, this, showColumnInMenu);
        this.columnDefaultWidth[0] = this.columnDefaultWidth[0] * 2;
        this.column[0].setPreferredWidth(this.columnDefaultWidth[0]);
        this.columnDefaultWidth[1] = this.columnDefaultWidth[1] * 2;
        this.column[1].setPreferredWidth(this.columnDefaultWidth[1]);
        ListSelectionModel listSelectionModel = this.treeTable.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        JTree tree = this.treeTable.getTree();
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        TreeSelectionModel treeSelectionModel = tree.getSelectionModel();
        treeSelectionModel.setSelectionMode(1);
        tree.addTreeExpansionListener(this);
        tree.addTreeSelectionListener(this);
        this.dataTreeCellRenderer = new DataTreeCellRenderer();
        tree.setCellRenderer(this.dataTreeCellRenderer);
        this.dataTableCellRenderer = new DataTableCellRenderer();
        this.treeTable.setDefaultRenderer(String.class, (TableCellRenderer)this.dataTableCellRenderer);
        this.column[1].setCellEditor((TableCellEditor)((Object)new ValueCellEditor()));
        JTableHeader tableHeader = this.treeTable.getTableHeader();
        TableCellRenderer headerRenderer = tableHeader.getDefaultRenderer();
        tableHeader.setDefaultRenderer(new 3(this, headerRenderer));
        this.treeTable.addMouseListener((MouseListener)new 4());
        tableHeader.addMouseListener(new 5());
        this.treeTable.addKeyListener((KeyListener)new 6());
        this.scrollPane = new JScrollPane((Component)this.treeTable);
        Color background = this.treeTable.getBackground();
        this.scrollPane.setBackground(background);
        this.scrollPane.getViewport().setBackground(background);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.addMouseListener(new 7());
        this.scrollPane.addComponentListener(new 8());
        this.treeTable.addHierarchyListener((HierarchyListener)new 9());
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer((Component)this.treeTable, 1, this);
        new DropTarget((Component)this.treeTable, 1, this);
        new DropTarget(this.scrollPane.getViewport(), 1, this);
        new DropTarget(this.scrollPane, 1, this);
        this.adjustGUI();
    }

    protected void adjustGUI() {
    }

    private boolean handleDoubleClickOrEnter(EventObject e, int column) {
        IdeAction action = null;
        switch (column) {
            case 0: {
                action = this._actionGotoField;
                break;
            }
            case 2: {
                action = this._actionGoto;
                break;
            }
            case 3: {
                action = this._actionGotoDeclared;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                action = this._actionModifyValue;
                break;
            }
        }
        if (action != null) {
            Context context = this.getContext(e);
            this.update(action, context);
            if (action.isEnabled()) {
                this.handleEvent(action, context);
                return true;
            }
        }
        return false;
    }

    private void adjustColumnsAfterResize() {
        if (this.adjustColumnsAlreadyDone) {
            return;
        }
        this.adjustColumnsAlreadyDone = true;
        JDebugger.adjustColumnsAfterResize(this.scrollPane, (JTable)this.treeTable);
    }

    protected Font getNormalFont() {
        if (this.normalFont == null) {
            this.normalFont = this.treeTable.getTree().getFont();
        }
        return this.normalFont;
    }

    protected Font getBoldFont() {
        if (this.boldFont == null) {
            this.boldFont = this.getNormalFont().deriveFont(1);
        }
        return this.boldFont;
    }

    protected Font getBoldItalicFont() {
        if (this.boldItalicFont == null) {
            this.boldItalicFont = this.getNormalFont().deriveFont(3);
        }
        return this.boldItalicFont;
    }

    Component getGUI() {
        if (this.scrollPane == null) {
            this.createGUI();
        }
        return this.scrollPane;
    }

    void loadSettings() {
        int i = 0;
        while (i < 7) {
            int width = this.dataPanelSettings.getColumnWidth(i);
            if (width != 0) {
                this.adjustColumnsAlreadyDone = true;
                this.column[i].setPreferredWidth(width);
            }
            ++i;
        }
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        String order = this.dataPanelSettings.getColumnOrder();
        if (order != null) {
            int i2 = 0;
            while (i2 < 7) {
                String identifier;
                int comma = order.indexOf(44);
                if (comma != -1) {
                    identifier = order.substring(0, comma);
                    order = order.substring(comma + 1);
                } else {
                    identifier = order;
                }
                if (identifier.length() == 0) break;
                try {
                    int from = tableColumnModel.getColumnIndex(identifier);
                    if (from != i2) {
                        this.treeTable.moveColumn(from, i2);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                ++i2;
            }
        }
    }

    void debugWindowSettingsChanged(DebugWindowSettings dbgSettings) {
        if (this.treeTable == null) {
            return;
        }
        this.useFilters = dbgSettings.isUseFilters();
    }

    void dataPanelSettingsChanged(boolean changed) {
        if (this.treeTable == null) {
            return;
        }
        int i = 0;
        while (i < 7) {
            boolean show = this.dataPanelSettings.getColumnVisible(i);
            if (this.columnShowing[i] != show) {
                this.columnShowing[i] = show;
                if (show) {
                    this.treeTable.addColumn(this.column[i]);
                } else {
                    this.treeTable.removeColumn(this.column[i]);
                }
            }
            ++i;
        }
        if (changed && this.treeTable.isEnabled()) {
            SwingUtilities.invokeLater(new 10());
        }
        Dimension d = this.treeTable.getPreferredSize();
        d.height = this.treeTable.getTableHeader().getPreferredSize().height + this.preferredVisibleRowCount * this.treeTable.getRowHeight() + this.scrollPane.getHorizontalScrollBar().getPreferredSize().height;
        this.scrollPane.setPreferredSize(d);
    }

    void saveSettings() {
        if (this.treeTable == null) {
            return;
        }
        int i = 0;
        while (i < 7) {
            this.dataPanelSettings.setColumnWidth(i, this.column[i].getWidth());
            ++i;
        }
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        String order = NOT_AVAILABLE;
        Enumeration<TableColumn> e = tableColumnModel.getColumns();
        while (e.hasMoreElements()) {
            TableColumn column = e.nextElement();
            order = order + column.getIdentifier() + ",";
        }
        this.dataPanelSettings.setColumnOrder(order);
    }

    Context getContext() {
        return this.getContext(null);
    }

    Context getContext(EventObject event) {
        Object info;
        DebugDataInfo dataInfo;
        DataItem dataItem = this.getSelectedDataItem();
        JDIInformationProvider jdiInformationProvider = null;
        if (dataItem != null && (dataInfo = dataItem.getDataInfo()) instanceof JDIInformationProvider) {
            jdiInformationProvider = (JDIInformationProvider)((Object)dataInfo);
        }
        Context context = ContextBuilder.buildContext((Element)dataItem, (View)this.dockableWindow, event, this.debuggingProcess, jdiInformationProvider);
        if (this.frame instanceof JDIInformationProvider) {
            ContextBuilder.addJDIInformation(context, (JDIInformationProvider)((Object)this.frame));
        }
        if (dataItem != null && (info = dataItem.getInfo()) instanceof JDIInformationProvider) {
            ContextBuilder.addJDIInformation(context, (JDIInformationProvider)info);
        }
        return context;
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        DataTreeTableModel.mav$branchExpanded(this.model, event.getPath());
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        DataTreeTableModel.mav$branchCollapsed(this.model, event.getPath());
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        Point pt;
        TreePath treePath;
        DataItem dataItem;
        if (e.getDragAction() == 1 && (transferFlavors = (dataItem = this.model.getDataItemForTreePath(treePath = this.model.getTreePathAtPoint(pt = e.getDragOrigin()))).canDrag(treePath)) != null) {
            try {
                BufferedImage dragImage = new BufferedImage(1, 1, 6);
                dragImage.setRGB(0, 0, -16777216);
                Point imageOffset = new Point(0, 0);
                e.startDrag(null, dragImage, imageOffset, dataItem, this);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent e) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent e) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent e) {
    }

    @Override
    public void dragExit(DragSourceEvent e) {
    }

    @Override
    public void dragOver(DragSourceDragEvent e) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        this.checkDrag(e);
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        this.checkDrag(e);
    }

    @Override
    public void dragExit(DropTargetEvent e) {
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        this.checkDrop(e);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    protected void checkDrag(DropTargetDragEvent e) {
        e.rejectDrag();
    }

    protected void checkDrop(DropTargetDropEvent e) {
        e.rejectDrop();
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == this._VIEW_WHOLE_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                dataItem.viewWhole();
            }
            return true;
        }
        if (cmdId == this._VIEW_ANNOTATIONS_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                dataItem.viewAnnotations();
            }
            return true;
        }
        if (cmdId == this._VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                dataItem.viewAnnotationsForClass();
            }
            return true;
        }
        if (cmdId == this._ADJUST_RANGE_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            TreePath treePath = this.getSelectedTreePath();
            if (dataItem != null && treePath != null) {
                dataItem.adjustRange(treePath);
            }
            return true;
        }
        if (cmdId == this._TOGGLE_VALUE_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                dataItem.toggleValue();
            }
            return true;
        }
        if (cmdId == this._MODIFY_VALUE_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                dataItem.modifyValue();
            }
            return true;
        }
        if (cmdId == this._WATCH_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            TreePath treePath = this.getSelectedTreePath();
            if (dataItem != null && treePath != null) {
                dataItem.watch(treePath);
            }
            return true;
        }
        if (cmdId == this._INSPECT_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            TreePath treePath = this.getSelectedTreePath();
            if (dataItem != null && treePath != null) {
                dataItem.inspect(treePath);
            }
            return true;
        }
        if (cmdId == this._WATCH_CLASSLOADER_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                dataItem.watchClassLoader();
            }
            return true;
        }
        if (cmdId == this._INSPECT_CLASSLOADER_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                dataItem.inspectClassLoader();
            }
            return true;
        }
        if (cmdId == this._GOTO_CMD_ID || cmdId == this._GOTO_DECLARED_CMD_ID || cmdId == this._GOTO_FIELD_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                dataItem.showSource(cmdId);
            }
            return true;
        }
        if (cmdId == this._USE_FILTERS_CMD_ID) {
            JDebugger.getInstance().setUseFilters(action.getState());
            return true;
        }
        if (cmdId == this._OBJECT_PREFERENCES_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null && dataItem.data instanceof DebugDataObjectInfo && dataItem.actualClassInfo != null) {
                ObjectPreferencesPanel.showObjectPreferencesDialog(dataItem.actualClassInfo, this.dataPanelSettings.isSortFieldsByName());
            }
            return true;
        }
        if (cmdId == this._COLLAPSE_ALL_CMD_ID) {
            DataTreeTableModel.mav$collapseAll(this.model);
            return true;
        }
        if (cmdId == this._SAVE_CMD_ID) {
            this.saveToFile();
            return true;
        }
        if (cmdId == 18) {
            Object o;
            int column;
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null && (column = this.treeTable.getSelectedColumn()) != -1 && (o = dataItem.getValueOfColumn(column)) != null) {
                IdeUtil.copyToClipboard((String)o.toString());
            }
            return true;
        }
        DebugBreakpoint dbp = (DebugBreakpoint)this.breakpointInstanceFilterActions.get(action);
        if (dbp != null) {
            DebugDataInfo ddi;
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null && (ddi = dataItem.getDataInfo()) instanceof DebugDataObjectInfo) {
                DebugDataObjectInfo data = (DebugDataObjectInfo)ddi;
                Boolean isInstanceFilterSet = (Boolean)action.getValue("UserData");
                if (isInstanceFilterSet.booleanValue()) {
                    dbp.removeInstanceFilter(data);
                } else {
                    dbp.addInstanceFilter(data);
                }
                JDebugger.getInstance().updateBreakpointsWindowInstanceFilters();
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (action.getValue("Debugger.actionOwner") == this) {
            if (this.treeTable == null || !this.isParentVisible()) {
                action.setEnabled(false);
                return true;
            }
            if (!this.treeTable.isEnabled() || this.debuggingProcess == null || this.vm == null) {
                action.setEnabled(false);
                return true;
            }
        }
        if (cmdId == this._VIEW_WHOLE_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                action.setEnabled(dataItem.canViewWhole());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == this._VIEW_ANNOTATIONS_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                String name = dataItem.canViewAnnotations();
                if (name != null) {
                    action.setEnabled(true);
                    action.putValue("Name", (Object)name);
                } else {
                    action.setEnabled(false);
                    action.putValue("Name", action.getValue("NoCtxName"));
                }
            } else {
                action.setEnabled(false);
                action.putValue("Name", action.getValue("NoCtxName"));
            }
            return true;
        }
        if (cmdId == this._VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                action.setEnabled(dataItem.canViewAnnotationsForClass());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == this._ADJUST_RANGE_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                action.setEnabled(dataItem.canAdjustRange());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == this._TOGGLE_VALUE_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                action.setEnabled(dataItem.canToggleValue());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == this._MODIFY_VALUE_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                action.setEnabled(dataItem.canModifyValue());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == this._DIAGRAM_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            TreePath treePath = this.getSelectedTreePath();
            if (dataItem != null && treePath != null) {
                action.setEnabled(dataItem.canDiagram(treePath));
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == this._WATCH_CMD_ID || cmdId == this._INSPECT_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            TreePath treePath = this.getSelectedTreePath();
            if (dataItem != null && treePath != null) {
                action.setEnabled(dataItem.canWatchAndInspect(treePath));
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == this._WATCH_CLASSLOADER_CMD_ID || cmdId == this._INSPECT_CLASSLOADER_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                action.setEnabled(dataItem.canWatchInspectClassLoader());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == this._GOTO_CMD_ID || cmdId == this._GOTO_DECLARED_CMD_ID || cmdId == this._GOTO_FIELD_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                String name = dataItem.canShowSource(cmdId);
                if (name != null) {
                    action.setEnabled(true);
                    action.putValue("Name", (Object)name);
                } else {
                    action.setEnabled(false);
                    action.putValue("Name", action.getValue("NoCtxName"));
                }
            } else {
                action.setEnabled(false);
                action.putValue("Name", action.getValue("NoCtxName"));
            }
            return true;
        }
        if (cmdId == this._USE_FILTERS_CMD_ID) {
            action.setState(this.useFilters);
            action.setEnabled(this.objectPreferences.isHiddenFieldsEmpty() ^ true);
            return true;
        }
        if (cmdId == this._OBJECT_PREFERENCES_CMD_ID) {
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null && dataItem.data instanceof DebugDataObjectInfo && dataItem.actualClassInfo != null) {
                action.setEnabled(true);
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == this._COLLAPSE_ALL_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        if (cmdId == this._SAVE_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        if (cmdId == 18) {
            DataItem dataItem = this.getSelectedDataItem();
            int column = this.treeTable.getSelectedColumn();
            action.setEnabled(dataItem != null && column != -1);
            return true;
        }
        DebugBreakpoint dbp = (DebugBreakpoint)this.breakpointInstanceFilterActions.get(action);
        if (dbp != null) {
            DebugDataInfo ddi;
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null && (ddi = dataItem.getDataInfo()) instanceof DebugDataObjectInfo) {
                action.setEnabled(true);
            }
            return true;
        }
        return false;
    }

    public void menuWillShow(ContextMenu popup) {
        Context context = popup.getContext();
        if (this.treeTable != null && context.getView() == this.dockableWindow && (Helpers.contextMatchesSource(context, this.treeTable) || Helpers.contextMatchesSource(context, this.scrollPane))) {
            this.addPopupMenuItemsForNew(popup, context);
            DataItem dataItem = this.getSelectedDataItem();
            if (dataItem != null) {
                this.addPopupMenuItemsForDataItem(popup, context);
            }
            this.addPopupMenuItemsForData(popup, context);
            this.addPopupMenuItemsForTreeTable(popup, context);
            this.addPopupMenuItemsForCommon(popup, context);
        }
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    protected void addPopupMenuItemsForNew(ContextMenu popup, Context context) {
    }

    protected void addPopupMenuItemsForDataItem(ContextMenu popup, Context context) {
        this.update(this._actionViewWhole, context);
        if (this._actionViewWhole.isEnabled()) {
            if (this._menuitemViewWhole == null) {
                this._menuitemViewWhole = popup.createMenuItem((ToggleAction)this._actionViewWhole);
            }
            popup.add((Component)this._menuitemViewWhole, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(this._actionViewAnnotations, context);
        if (this._actionViewAnnotations.isEnabled()) {
            if (this._menuitemViewAnnotations == null) {
                this._menuitemViewAnnotations = popup.createMenuItem((ToggleAction)this._actionViewAnnotations);
            }
            popup.add((Component)this._menuitemViewAnnotations, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(this._actionViewAnnotationsForClass, context);
        if (this._actionViewAnnotationsForClass.isEnabled()) {
            if (this._menuitemViewAnnotationsForClass == null) {
                this._menuitemViewAnnotationsForClass = popup.createMenuItem((ToggleAction)this._actionViewAnnotationsForClass);
            }
            popup.add((Component)this._menuitemViewAnnotationsForClass, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(this._actionAdjustRange, context);
        if (this._actionAdjustRange.isEnabled()) {
            if (this._menuitemAdjustRange == null) {
                this._menuitemAdjustRange = popup.createMenuItem((ToggleAction)this._actionAdjustRange);
            }
            popup.add((Component)this._menuitemAdjustRange, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(this._actionToggleValue, context);
        if (this._actionToggleValue.isEnabled()) {
            if (this._menuitemToggleValue == null) {
                this._menuitemToggleValue = popup.createMenuItem((ToggleAction)this._actionToggleValue);
            }
            popup.add((Component)this._menuitemToggleValue, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(this._actionModifyValue, context);
        if (this._actionModifyValue.isEnabled()) {
            if (this._menuitemModifyValue == null) {
                this._menuitemModifyValue = popup.createMenuItem((ToggleAction)this._actionModifyValue);
            }
            popup.add((Component)this._menuitemModifyValue, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        if (this._actionDiagram != null) {
            this.update(this._actionDiagram, context);
            if (this._actionDiagram.isEnabled()) {
                if (this._menuitemDiagram == null) {
                    this._menuitemDiagram = popup.createMenuItem((ToggleAction)this._actionDiagram);
                }
                popup.add((Component)this._menuitemDiagram, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
        }
        if (this._actionWatch != null) {
            this.update(this._actionWatch, context);
            if (this._actionWatch.isEnabled()) {
                if (this._menuitemWatch == null) {
                    this._menuitemWatch = popup.createMenuItem((ToggleAction)this._actionWatch);
                }
                popup.add((Component)this._menuitemWatch, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
        }
        if (this._actionInspect != null) {
            this.update(this._actionInspect, context);
            if (this._actionInspect.isEnabled()) {
                if (this._menuitemInspect == null) {
                    this._menuitemInspect = popup.createMenuItem((ToggleAction)this._actionInspect);
                }
                popup.add((Component)this._menuitemInspect, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
        }
        this.update(this._actionWatchClassLoader, context);
        if (this._actionWatchClassLoader.isEnabled()) {
            if (this._menuitemWatchClassLoader == null) {
                this._menuitemWatchClassLoader = popup.createMenuItem((ToggleAction)this._actionWatchClassLoader);
            }
            popup.add((Component)this._menuitemWatchClassLoader, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(this._actionInspectClassLoader, context);
        if (this._actionInspectClassLoader.isEnabled()) {
            if (this._menuitemInspectClassLoader == null) {
                this._menuitemInspectClassLoader = popup.createMenuItem((ToggleAction)this._actionInspectClassLoader);
            }
            popup.add((Component)this._menuitemInspectClassLoader, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(this._actionGoto, context);
        if (this._actionGoto.isEnabled()) {
            if (this._menuitemGoto == null) {
                this._menuitemGoto = popup.createMenuItem((ToggleAction)this._actionGoto);
            }
            popup.add((Component)this._menuitemGoto, JDeveloperMenuConstants.SECTION_NAVIGATE_CTXT_MENU);
        }
        this.update(this._actionGotoDeclared, context);
        if (this._actionGotoDeclared.isEnabled()) {
            if (this._menuitemGotoDeclared == null) {
                this._menuitemGotoDeclared = popup.createMenuItem((ToggleAction)this._actionGotoDeclared);
            }
            popup.add((Component)this._menuitemGotoDeclared, JDeveloperMenuConstants.SECTION_NAVIGATE_CTXT_MENU);
        }
        this.update(this._actionGotoField, context);
        if (this._actionGotoField.isEnabled()) {
            if (this._menuitemGotoField == null) {
                this._menuitemGotoField = popup.createMenuItem((ToggleAction)this._actionGotoField);
            }
            popup.add((Component)this._menuitemGotoField, JDeveloperMenuConstants.SECTION_NAVIGATE_CTXT_MENU);
        }
        this.addBreakpointInstanceFilterActions(popup, context);
    }

    private void addBreakpointInstanceFilterActions(ContextMenu popup, Context context) {
        DebugDataInfo data;
        this.breakpointInstanceFilterActions.clear();
        DataItem dataItem = this.getSelectedDataItem();
        if (dataItem != null && (data = dataItem.getDataInfo()) instanceof DebugDataObjectInfo) {
            DebugDataObjectInfo dataObject = (DebugDataObjectInfo)data;
            HashSet classNames = new HashSet();
            HashMap<Breakpoint, Boolean> appropriate = new HashMap<Breakpoint, Boolean>();
            List[] breakpoints = Breakpoint.getBreakpoints(context.getWorkspace(), context.getProject());
            int length = breakpoints.length;
            int i = 0;
            while (i < length) {
                for (Breakpoint bp : breakpoints[i]) {
                    DebugBreakpoint dbp = bp.getDebugBreakpoint(this.debuggingProcess);
                    if (dbp == null || !dbp.isInstanceFilterAppropriate(dataObject, classNames)) continue;
                    Boolean isInstanceFilterSet = dbp.isInstanceFilterSet(dataObject) ? Boolean.TRUE : Boolean.FALSE;
                    appropriate.put(bp, isInstanceFilterSet);
                }
                ++i;
            }
            if (!appropriate.isEmpty()) {
                JMenu subMenu = popup.createSubMenu(DbgArb.getString(856), DbgArb.getInteger(738));
                int count = 0;
                for (Breakpoint bp : appropriate.keySet()) {
                    Boolean isInstanceFilterSet = (Boolean)appropriate.get(bp);
                    String label = DbgArb.format(367, bp.getTypeString(), bp.getDescription());
                    int cmdId = Ide.findOrCreateCmdID((String)(BREAKPOINT_INSTANCE_FILTER_CMD_PREFIX + count++));
                    IdeAction action = IdeAction.get((int)cmdId, null, (String)label, null, null, null, (int)-1, (Object)isInstanceFilterSet, (boolean)true);
                    action.putValue("Name", (Object)label);
                    action.putValue("UserData", (Object)isInstanceFilterSet);
                    action.putValue("Check", (Object)Boolean.TRUE);
                    action.setState(isInstanceFilterSet.booleanValue());
                    action.addController((Controller)this);
                    this.breakpointInstanceFilterActions.put(action, bp.getDebugBreakpoint(this.debuggingProcess));
                    JMenuItem menuitem = popup.createMenuItem((ToggleAction)action);
                    subMenu.add(menuitem);
                }
                popup.add((Component)subMenu, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
        }
    }

    protected void addPopupMenuItemsForData(ContextMenu popup, Context context) {
        this.update(this._actionUseFilters, context);
        if (this._actionUseFilters.isEnabled()) {
            if (this._menuitemUseFilters == null) {
                this._menuitemUseFilters = popup.createMenuItem((ToggleAction)this._actionUseFilters);
            }
            popup.add((Component)this._menuitemUseFilters, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_SPECIFIC_CTXT_MENU);
        }
        this.update(this._actionObjectPreferences, context);
        if (this._actionObjectPreferences.isEnabled()) {
            if (this._menuitemObjectPreferences == null) {
                this._menuitemObjectPreferences = popup.createMenuItem((ToggleAction)this._actionObjectPreferences);
            }
            popup.add((Component)this._menuitemObjectPreferences, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_SPECIFIC_CTXT_MENU);
        }
    }

    protected void addPopupMenuItemsForTreeTable(ContextMenu popup, Context context) {
        this.update(this._actionCollapseAll, context);
        if (this._actionCollapseAll.isEnabled()) {
            if (this._menuitemCollapseAll == null) {
                this._menuitemCollapseAll = popup.createMenuItem((ToggleAction)this._actionCollapseAll);
            }
            popup.add((Component)this._menuitemCollapseAll, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_TREE_CTXT_MENU);
        }
    }

    protected void addPopupMenuItemsForCommon(ContextMenu popup, Context context) {
        this.update(this._actionSave, context);
        if (this._actionSave.isEnabled()) {
            if (this._menuitemSave == null) {
                this._menuitemSave = popup.createMenuItem((ToggleAction)this._actionSave);
            }
            popup.add((Component)this._menuitemSave, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
        }
    }

    void showPopup(MouseEvent e) {
        JDebugger.getInstance().showContextMenu(e, this.dockableWindow, this.treeTable);
    }

    private void saveToFile() {
        URL url;
        String dlgTitle = RunMgrArb.format(19, this.title);
        URLChooser chooser = DialogUtil.newURLChooser((Context)this.getContext());
        if (JDebugger.lastSavedFile != null) {
            chooser.setSelectedURL(JDebugger.lastSavedFile);
        }
        if (chooser.showSaveDialog((Component)Ide.getMainWindow(), dlgTitle) == 0 && (url = chooser.getSelectedURL()) != null) {
            JDebugger.lastSavedFile = url;
            WaitCursor wc = Ide.getWaitCursor();
            wc.show();
            Exception exceptionOccurred = null;
            try {
                String suffixUpper = URLFileSystem.getSuffix((URL)url).toUpperCase();
                boolean html = suffixUpper.equals(".HTML") || suffixUpper.equals(".HTM");
                PrintWriter out = html ? JDebugger.printHtmlHeader(url, this.title) : new PrintWriter(new BufferedOutputStream(URLFileSystem.openOutputStream((URL)url)));
                DataTreeTableModel.mav$save(this.model, out, html);
                if (html) {
                    JDebugger.printHtmlFooter(out);
                }
                out.flush();
                out.close();
            }
            catch (Exception e) {
                exceptionOccurred = e;
            }
            wc.hide();
            if (exceptionOccurred != null) {
                String message = DbgArb.format(341, this.title, URLFileSystem.getPlatformPathName((URL)url));
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exceptionOccurred, (String)dlgTitle, (String)message, null);
            }
        }
    }

    void nowShown() {
        if (this.skippedUpdate && this.treeTable.isEnabled()) {
            this.everythingChanged();
        }
    }

    void everythingChanged() {
        this.everythingChanged(false);
    }

    void everythingChanged(boolean offThread) {
        if (this.model != null) {
            this.model.updateDataForModel(offThread);
        }
    }

    private void updateColumn(int column) {
        DataTreeTableModel.mav$clearCacheForColumn(this.model, column);
        TableModel tableModel = this.treeTable.getModel();
        TableModelEvent event = new TableModelEvent(tableModel, 0, tableModel.getRowCount() - 1, column);
        if (tableModel instanceof AbstractTableModel) {
            ((AbstractTableModel)tableModel).fireTableChanged(event);
        }
        if (column == 0) {
            this.model.saveHighlight();
            this.model.fireChanged();
            this.model.restoreHighlight(false);
        }
    }

    void setUseFilters(boolean useFilters) {
        this.useFilters = useFilters;
        this.everythingChanged();
    }

    protected void debugContextChanged() {
    }

    @Override
    public void updateData(DebuggingProcess debuggingProcess, DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo frame) {
        int handle = -1;
        if (ProfilingEvents.eventOn[4]) {
            handle = IdeProfile.startEvent((int)ProfilingEvents.eventId[4], (String)this.title);
        }
        this.debuggingProcess = debuggingProcess;
        this.vm = vm;
        this.thread = thread;
        this.frame = frame;
        this.debugContextChanged();
        this.canUpdateData = true;
        if (this.treeTable != null) {
            this.treeTable.setEnabled(true);
            this.everythingChanged();
        }
        if (ProfilingEvents.eventOn[4]) {
            IdeProfile.endEvent((int)handle);
        }
    }

    @Override
    public void clearData() {
        this.canUpdateData = false;
        if (this.treeTable == null) {
            return;
        }
        int handle = -1;
        if (ProfilingEvents.eventOn[9]) {
            handle = IdeProfile.startEvent((int)ProfilingEvents.eventId[9], (String)this.title);
        }
        this.treeTable.setEnabled(false);
        this.model.clearDataForModel();
        this.vm = null;
        this.thread = null;
        this.frame = null;
        this.debugContextChanged();
        if (ProfilingEvents.eventOn[9]) {
            IdeProfile.endEvent((int)handle);
        }
    }

    protected abstract void addDataItems();

    void processFinished(DebuggingProcess debuggingProcess) {
        if (this.model != null) {
            this.model.processFinished(debuggingProcess);
        }
        if (this.debuggingProcess == debuggingProcess) {
            this.debuggingProcess = null;
            this.vm = null;
            this.thread = null;
            this.frame = null;
            this.debugContextChanged();
            this.canUpdateData = true;
            if (this.treeTable != null) {
                this.treeTable.setEnabled(true);
                this.everythingChanged();
            }
        }
    }

    private DataArrayRange getArrayRange(DebugDataArrayInfo array) {
        DataArrayRange arrayRange = (DataArrayRange)this.arrayRanges.get(array);
        if (arrayRange != null) {
            this.arrayRanges.remove(array);
            this.arrayRanges.put(array, arrayRange);
        } else {
            arrayRange = new DataArrayRange(this.debuggingProcess, array);
        }
        return arrayRange;
    }

    static Comparator<DebugFieldInfo> getComparatorForFields() {
        return new 11();
    }

    private DataItem[] makeDataItemsForObject(DataItem parent, DebugDataObjectInfo dataObject) {
        ArrayList<DataItem> dataItems = new ArrayList<DataItem>();
        if (parent.ancestorHeapInfo != null) {
            DebugHeapInfo heap = parent.ancestorHeapInfo;
            DebugFieldInfo[] fields = dataObject.getFields(-1, false, true);
            if (this.dataPanelSettings.isSortFieldsByName()) {
                Arrays.sort(fields, DataPanel.getComparatorForFields());
            }
            int length = fields.length;
            int[] depths = new int[length];
            Arrays.fill(depths, -1);
            int shortestDepth = -1;
            int i = 0;
            while (i < length) {
                int depth;
                DebugFieldInfo field = fields[i];
                DebugDataInfo data = field.getDataInfo();
                if (data instanceof DebugDataCompositeInfo && 0 <= (depth = (depths[i] = heap.getDepth((DebugDataCompositeInfo)data))) && (shortestDepth == -1 || depth < shortestDepth)) {
                    shortestDepth = depth;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < length) {
                int depth = depths[i2];
                if (!this.dataPanelSettings.isHideUnrelated() || depth >= 0) {
                    dataItems.add(new DataItem(fields[i2], null, heap, depth, depth == shortestDepth));
                }
                ++i2;
            }
        } else {
            List dataItemsForFields;
            boolean hideAllFields;
            List dataItemsForExpandExpression;
            String expression;
            if (this.derivedFromThrowable(dataObject)) {
                Evaluator evaluator = new Evaluator(true);
                evaluator.setDebugContext(dataObject);
                evaluator.evaluate("getStackTrace()");
            }
            if ((expression = this.objectPreferences.getExpandExpression(dataObject)) != null && (dataItemsForExpandExpression = this.makeDataItemsForObjectExpandExpression(dataObject, expression)) != null) {
                dataItems.addAll(dataItemsForExpandExpression);
            }
            if (!(hideAllFields = this.objectPreferences.getHideAllFields(dataObject)) && (dataItemsForFields = this.makeDataItemsForObjectFields(dataObject)) != null) {
                dataItems.addAll(dataItemsForFields);
            }
        }
        return dataItems.toArray(new DataItem[dataItems.size()]);
    }

    private boolean derivedFromThrowable(DebugDataObjectInfo dataObject) {
        DebugClassInfo clazz = dataObject.getClassInfo();
        while (clazz != null) {
            if ("java.lang.Exception".equals(clazz.getName()) || "java.lang.Throwable".equals(clazz.getName())) {
                return true;
            }
            clazz = clazz.getSuperClass(1);
        }
        return false;
    }

    private List makeDataItemsForObjectExpandExpression(DebugDataObjectInfo dataObject, String expression) {
        try {
            ArrayList<DataItem> dataItems = new ArrayList<DataItem>();
            Evaluator evaluator = new Evaluator(true);
            evaluator.setDebugContext(dataObject);
            String[] tokens = ObjectPreferences.tokenizeExpandExpression(expression);
            int tokensLength = tokens.length;
            int itoken = 0;
            while (itoken < tokensLength) {
                String token = tokens[itoken];
                DebugDataInfo data = Evaluator.getDataInfo(evaluator.evaluate(token));
                if (data != null) {
                    String expressionPartOverride = token.startsWith(".") ? token : (token.startsWith("this.") ? token.substring(4) : "." + token);
                    if (data instanceof DebugDataArrayInfo && itoken == 0 && tokensLength == 1) {
                        DebugArrayElementInfo[] arrayElements = ((DebugDataArrayInfo)data).getArrayElements();
                        int arrayElementsLength = arrayElements.length;
                        int i = 0;
                        while (i < arrayElementsLength) {
                            DebugArrayElementInfo arrayElement = arrayElements[i];
                            String displayNameOverride = "[" + i + "]";
                            DataItem dataItem = new DataItem(arrayElement, displayNameOverride, expressionPartOverride + "[" + i + "]");
                            dataItems.add(dataItem);
                            ++i;
                        }
                    } else {
                        String displayNameOverride = token;
                        dataItems.add(new DataItem(data, displayNameOverride, expressionPartOverride));
                    }
                }
                ++itoken;
            }
            ArrayList<DataItem> arrayList = dataItems;
            return arrayList;
        }
        catch (Exception e) {
            return null;
        }
    }

    private List makeDataItemsForObjectFields(DebugDataObjectInfo dataObject) {
        ArrayList<DataItem> dataItems = new ArrayList<DataItem>();
        DebugFieldInfo[] fields = dataObject.getFields(-1, this.dataPanelSettings.isHideFinalFields(), this.dataPanelSettings.isHideStaticFields());
        if (this.dataPanelSettings.isSortFieldsByName()) {
            Arrays.sort(fields, DataPanel.getComparatorForFields());
        }
        int fieldsLength = fields.length;
        int i = 0;
        while (i < fieldsLength) {
            String fieldName;
            String className;
            List hiddenFields;
            DebugFieldInfo field = fields[i];
            if (!(this.useFilters && (hiddenFields = this.objectPreferences.getHiddenFields(className = field.getDeclaringClassInfo().getName())) != null && hiddenFields.contains(fieldName = field.getName()) || this.shouldSkipField(field))) {
                dataItems.add(new DataItem(field));
            }
            ++i;
        }
        return dataItems;
    }

    private DataItem[] makeDataItemsForArray(DataItem parent, DebugDataArrayInfo array, DataArrayRange arrayRange) {
        DebugClassInfo clazz;
        if (parent.ancestorHeapInfo != null) {
            DebugClassInfo clazz2;
            DebugHeapInfo heap = parent.ancestorHeapInfo;
            boolean nonNullOnly = false;
            if (this.dataPanelSettings.isHideUnrelated()) {
                nonNullOnly = true;
            } else if (this.dataPanelSettings.isHideNullArrayElements() && (clazz2 = array.getArrayElementClassInfo()) != null && !clazz2.isPrimitive()) {
                nonNullOnly = true;
            }
            DebugArrayElementInfo[] arrayElements = array.getArrayElements(array.getArrayStart(), -1, nonNullOnly);
            int length = arrayElements.length;
            int[] depths = new int[length];
            Arrays.fill(depths, -1);
            int shortestDepth = -1;
            int i = 0;
            while (i < length) {
                int depth;
                DebugArrayElementInfo arrayElement = arrayElements[i];
                DebugDataInfo data = arrayElement.getDataInfo();
                if (data instanceof DebugDataCompositeInfo && 0 <= (depth = (depths[i] = heap.getDepth((DebugDataCompositeInfo)data))) && (shortestDepth == -1 || depth < shortestDepth)) {
                    shortestDepth = depth;
                }
                ++i;
            }
            ArrayList<DataItem> dataItems = new ArrayList<DataItem>();
            int i2 = 0;
            while (i2 < length) {
                int depth = depths[i2];
                if (!this.dataPanelSettings.isHideUnrelated() || depth >= 0) {
                    dataItems.add(new DataItem(arrayElements[i2], null, heap, depth, depth == shortestDepth));
                }
                ++i2;
            }
            return dataItems.toArray(new DataItem[dataItems.size()]);
        }
        boolean nonNullOnly = false;
        if (this.dataPanelSettings.isHideNullArrayElements() && (clazz = array.getArrayElementClassInfo()) != null && !clazz.isPrimitive()) {
            nonNullOnly = true;
        }
        DebugArrayElementInfo[] arrayElements = array.getArrayElements(arrayRange.getStart(), arrayRange.getCount(), nonNullOnly);
        int length = arrayElements.length;
        DataItem[] dataItems = new DataItem[length];
        int i = 0;
        while (i < length) {
            dataItems[i] = new DataItem(arrayElements[i]);
            ++i;
        }
        return dataItems;
    }

    private DataItem[] makeDataItemsForClass(DataItem parent, DebugClassInfo clazz) {
        DebugFieldInfo[] fields = clazz.getStaticFields(-1, this.dataPanelSettings.isHideFinalFields());
        if (this.dataPanelSettings.isSortFieldsByName()) {
            Arrays.sort(fields, DataPanel.getComparatorForFields());
        }
        ArrayList<DataItem> dataItems = new ArrayList<DataItem>();
        int fieldsLength = fields.length;
        int i = 0;
        while (i < fieldsLength) {
            DebugFieldInfo field = fields[i];
            if (!this.shouldSkipField(field)) {
                dataItems.add(new DataItem(fields[i]));
            }
            ++i;
        }
        return dataItems.toArray(new DataItem[dataItems.size()]);
    }

    boolean shouldSkipField(DebugFieldInfo field) {
        int access = field.getAccess();
        if ((access & 0x1000) != 0) {
            String name = field.getName();
            if (!(name.startsWith("this$") || name.startsWith("val$") || name.startsWith("v$"))) {
                return true;
            }
            return this.dataPanelSettings.isHideSyntheticFields();
        }
        return false;
    }

    private DataItem[] makeDataItemsForHeapInfo(DataItem parent, DebugHeapInfo heap) {
        DebugHeapSubset subset = heap.getHeapSubset();
        if (subset instanceof DebugHeapSubsetClasses) {
            DebugHeapObjectInfo[] objects = heap.getHeapObjects(0, heap.countHeapObjects());
            int objectsLength = objects.length;
            DataItem[] dataItems = new DataItem[objectsLength];
            int i = 0;
            while (i < objectsLength) {
                DebugDataCompositeInfo info = objects[i].getDataInfo();
                long address = info.getAddressOfObject();
                if (address != 0L) {
                    String name = "@" + Long.toHexString(address).toUpperCase();
                    dataItems[i] = new DataItem(info, name, null);
                } else {
                    dataItems[i] = new DataItem(info);
                }
                ++i;
            }
            return dataItems;
        }
        if (subset instanceof DebugHeapSubsetAncestors) {
            DebugHeapAncestor[] insideHeap = this.dataPanelSettings.isShowOnlyRootAncestors() ? new DebugHeapAncestor[]{} : heap.getAncestorsInsideHeap();
            DebugHeapAncestorOutsideHeap[] outsideHeap = heap.getAncestorsOutsideHeap();
            int length = insideHeap.length + outsideHeap.length;
            DebugHeapAncestor[] ancestors = new DebugHeapAncestor[length];
            System.arraycopy(insideHeap, 0, ancestors, 0, insideHeap.length);
            System.arraycopy(outsideHeap, 0, ancestors, insideHeap.length, outsideHeap.length);
            if (length > 0) {
                Arrays.sort(ancestors, new 12());
                DataItem[] dataItems = new DataItem[length];
                int i = 0;
                while (i < length) {
                    DebugHeapAncestor ancestor = ancestors[i];
                    int depth = ancestor.getDepth();
                    dataItems[i] = new DataItem(ancestor, null, heap, depth, true);
                    ++i;
                }
                return dataItems;
            }
        }
        return new DataItem[0];
    }

    private DataItem[] makeDataItemsForHeapAncestor(DataItem parent, DebugHeapAncestor ancestor) {
        DebugHeapInfo heap = parent.ancestorHeapInfo;
        DebugDataCompositeInfo data = ancestor.getDataInfo();
        if (data != null) {
            DebugHeapAncestorInStatic ancestorInStatic;
            DebugFieldInfo field;
            long address = data.getAddressOfObject();
            String name = "@" + Long.toHexString(address).toUpperCase();
            if (ancestor instanceof DebugHeapAncestorInStack) {
                DebugHeapAncestorInStack ancestorInStack = (DebugHeapAncestorInStack)ancestor;
                DebugVariableInfo var = ancestorInStack.getVariableInfo();
                if (var != null) {
                    name = var.getName();
                }
            } else if (ancestor instanceof DebugHeapAncestorInStatic && (field = (ancestorInStatic = (DebugHeapAncestorInStatic)ancestor).getFieldInfo()) != null) {
                name = field.getName();
            }
            int depth = heap.getDepth(data);
            DataItem[] dataItems = new DataItem[]{new DataItem(data, name, heap, depth, true)};
            return dataItems;
        }
        return new DataItem[0];
    }

    private DataItem[] makeDataItemsForAnnotation(DataItem parent, DebugAnnotationInfo annotation) {
        ArrayList<DataItem> dataItems = new ArrayList<DataItem>();
        Map<String, DebugDataInfo> properties = annotation.getProperties();
        for (Map.Entry<String, DebugDataInfo> entry : properties.entrySet()) {
            String name = entry.getKey();
            DebugDataInfo propertyData = entry.getValue();
            dataItems.add(new DataItem(propertyData, name, null));
        }
        return dataItems.toArray(new DataItem[dataItems.size()]);
    }

    protected int getNumberOfColumns() {
        return 7;
    }

    protected String getNameOfColumn(int column) {
        switch (column) {
            case 0: {
                return DbgArb.getString(159);
            }
            case 2: {
                return DbgArb.getString(746);
            }
            case 3: {
                return DbgArb.getString(275);
            }
            case 1: {
                return DbgArb.getString(656);
            }
            case 4: {
                return DbgArb.getString(687);
            }
            case 5: {
                return DbgArb.getString(112);
            }
            case 6: {
                return DbgArb.getString(276);
            }
        }
        return NOT_AVAILABLE;
    }

    protected List getRoot() {
        return (List)this.model.getRoot();
    }

    protected void addTopDataItem(DataItem dataItem) {
        this.model.addTopDataItem(dataItem);
    }

    protected void addTopDataItem(DataItem dataItem, boolean highlight) {
        this.model.addTopDataItem(dataItem, highlight);
    }

    protected void removeTopDataItem(int i) {
        this.model.removeTopDataItem(i);
    }

    protected void selectTopDataItem(int i) {
        this.model.selectTopDataItem(i);
    }

    TreePath getSelectedTreePath() {
        return this.treeTable.getTree().getSelectionPath();
    }

    DataItem getSelectedDataItem() {
        if (this.treeTable != null) {
            TreePath treePath = this.treeTable.getTree().getSelectionPath();
            return this.model.getDataItemForTreePath(treePath);
        }
        return null;
    }

    private static synchronized int getDefaultArrayRangeMax() {
        if (defaultArrayRangeMax == 0) {
            defaultArrayRangeMax = 100;
            String max = Ide.getProperty((String)"DebuggerDefaultArrayRangeMax");
            if (max != null) {
                try {
                    defaultArrayRangeMax = Integer.parseInt(max);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return defaultArrayRangeMax;
    }

    private String prepareDisplayName(Object info, String override, String def) {
        String courtesyName = DebugShared.makeCourtesyName(info);
        if (courtesyName != null) {
            return courtesyName;
        }
        if (override != null) {
            return override;
        }
        return def;
    }

    static String makeDisplayName(Object info, boolean showPackage) {
        if (info instanceof DebugClassInfo) {
            DebugClassInfo clazz = (DebugClassInfo)info;
            String fullClassName = clazz.getName();
            int index = 356;
            if (fullClassName.startsWith("$Oracle.")) {
                if (fullClassName.startsWith("$Oracle.Package.")) {
                    index = 666;
                } else if (fullClassName.startsWith("$Oracle.PackageBody.")) {
                    index = 662;
                } else if (fullClassName.startsWith("$Oracle.Type.")) {
                    index = 662;
                } else if (fullClassName.startsWith("$Oracle.TypeBody.")) {
                    index = 662;
                }
            } else if (fullClassName.startsWith(XSLTRunnerAddin.getXSLTPackage())) {
                index = 529;
            }
            String c = DebugShared.makeCourtesyClassName(clazz, showPackage);
            return DbgArb.format(index, c);
        }
        return NOT_AVAILABLE;
    }

    static String makeType(DebugDataInfo data, boolean showPackage) {
        return DataPanel.makeType(data, data.getClassInfo(), showPackage, null);
    }

    static String makeType(DebugDataInfo data, DebugClassInfo clazz, boolean showPackage) {
        return DataPanel.makeType(data, clazz, showPackage, null, null);
    }

    static String makeType(DebugDataInfo data, DebugClassInfo clazz, boolean showPackage, Object fieldOrVariable) {
        return DataPanel.makeType(data, clazz, showPackage, fieldOrVariable, null);
    }

    static String makeType(DebugDataInfo data, boolean showPackage, String typeParams) {
        return DataPanel.makeType(data, data.getClassInfo(), showPackage, typeParams);
    }

    static String makeType(DebugDataInfo data, DebugClassInfo clazz, boolean showPackage, String typeParams) {
        return DataPanel.makeType(data, clazz, showPackage, null, typeParams);
    }

    static String makeType(DebugDataInfo data, DebugClassInfo clazz, boolean showPackage, Object fieldOrVariable, String typeParams) {
        String t;
        if (clazz != null && (t = DebugShared.makeCourtesyType(data, clazz, showPackage, fieldOrVariable, typeParams)) != null) {
            return t;
        }
        return NOT_AVAILABLE;
    }

    private static String evaluateDataValue(DebugDataObjectInfo dataObject, Set setOfEvaluatedDataObjects, String[] expressionUsed) {
        ObjectPreferences objectPreferences;
        String expression;
        if (setOfEvaluatedDataObjects.add(dataObject) && (expression = (objectPreferences = JDebugger.getInstance().getObjectPreferences()).getValueExpression(dataObject)) != null) {
            Evaluator evaluator = new Evaluator(true);
            evaluator.setDebugContext(dataObject);
            Object info = evaluator.evaluate(expression);
            if (info != null) {
                String actualClassName;
                DebugDataInfo data = Evaluator.getDataInfo(info);
                String s = DataPanel.makeDataValue(info, data, setOfEvaluatedDataObjects);
                if (s != null && s.startsWith("\"") && s.endsWith("\"") && !(actualClassName = dataObject.getClassInfo().getName()).equals("java.lang.String") && !actualClassName.equals("java.lang.StringBuffer")) {
                    s = s.substring(1, s.length() - 1);
                }
                if (expressionUsed != null && expressionUsed.length == 1) {
                    expressionUsed[0] = expression;
                }
                return s;
            }
        }
        return null;
    }

    static String makeDataValue(DebugDataInfo data) {
        return DataPanel.makeDataValue(null, data);
    }

    static String makeDataValue(Object info, DebugDataInfo data) {
        return DataPanel.makeDataValue(info, data, new HashSet(), null);
    }

    static String makeDataValue(Object info, DebugDataInfo data, Set setOfEvaluatedDataObjects) {
        return DataPanel.makeDataValue(info, data, setOfEvaluatedDataObjects, null);
    }

    static String makeDataValue(Object info, DebugDataInfo data, String[] expressionUsed) {
        return DataPanel.makeDataValue(info, data, new HashSet(), expressionUsed, true);
    }

    static String makeDataValue(Object info, DebugDataInfo data, Set setOfEvaluatedDataObjects, String[] expressionUsed) {
        return DataPanel.makeDataValue(info, data, setOfEvaluatedDataObjects, expressionUsed, true);
    }

    static String makeDataValue(Object info, DebugDataInfo data, String[] expressionUsed, boolean getExtendedValue) {
        return DataPanel.makeDataValue(info, data, new HashSet(), expressionUsed, getExtendedValue);
    }

    static String makeDataValue(Object info, DebugDataInfo data, Set setOfEvaluatedDataObjects, String[] expressionUsed, boolean getExtendedValue) {
        if (data != null) {
            String v = null;
            if (data instanceof DebugDataCompositeInfo) {
                if (data instanceof DebugDataObjectInfo) {
                    v = DataPanel.evaluateDataValue((DebugDataObjectInfo)data, setOfEvaluatedDataObjects, expressionUsed);
                }
                if (v == null) {
                    v = DebugShared.makeCourtesyValue((DebugDataCompositeInfo)data, true, false);
                }
                if (v == null) {
                    v = data.getValue();
                }
            } else {
                v = data.getValue();
                if (data instanceof DebugDataPrimitiveInfo && getExtendedValue && getExtendedValue) {
                    try {
                        DebugClassInfo ci = data.getClassInfo();
                        if (ci != null) {
                            byte[] b;
                            String s;
                            String hex;
                            String className = ci.getName();
                            if (className.equals("char")) {
                                String hex2 = data.getHexValue();
                                if (hex2 != null && hex2.length() > 0) {
                                    int num = Integer.parseInt(hex2, 16);
                                    v = v + "    " + num;
                                }
                            } else if (className.equals("byte") && (hex = data.getHexValue()) != null && hex.length() > 0 && (s = new String(b = new byte[]{Byte.parseByte(hex, 16)}, Encodings.getDefaultEncoding())).length() == 1) {
                                FastStringBuffer fsb = new FastStringBuffer(v);
                                fsb.append(' ');
                                int i = v.length() + 1;
                                while (i < 7) {
                                    fsb.append(' ');
                                    ++i;
                                }
                                fsb.append('\'');
                                fsb.append(s);
                                fsb.append('\'');
                                v = fsb.toString();
                            }
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            if (v != null) {
                return v;
            }
        } else {
            if (info instanceof EvaluationInfo) {
                return ((EvaluationInfo)info).getValue();
            }
            if (info instanceof DebugVariableInfo) {
                return DbgArb.getString(925);
            }
            if (info instanceof DebugStackSlotInfo) {
                return ((DebugStackSlotInfo)info).getValue();
            }
        }
        return NOT_AVAILABLE;
    }

    static String makeHexValue(Object info, DebugDataInfo data) {
        if (data != null) {
            String hex = data.getHexValue();
            if (hex != null && hex.length() > 0) {
                return "0x" + hex.toUpperCase();
            }
        } else {
            if (info instanceof EvaluationInfo) {
                return "0x" + ((EvaluationInfo)info).getHexValue().toUpperCase();
            }
            if (info instanceof DebugVariableInfo) {
                return DbgArb.getString(925);
            }
            if (info instanceof DebugStackSlotInfo) {
                return "0x" + ((DebugStackSlotInfo)info).getHexValue().toUpperCase();
            }
        }
        return NOT_AVAILABLE;
    }

    static Icon getPrimitiveIcon() {
        return OracleIcons.getIcon((String)"field.png");
    }

    private static Icon getPrimitiveIconGray() {
        if (primitiveIconGray == null) {
            primitiveIconGray = IdeUtil.grayIcon((Icon)DataPanel.getPrimitiveIcon());
        }
        return primitiveIconGray;
    }

    static Icon getObjectIcon() {
        return OracleIcons.getIcon((String)"class.png");
    }

    private static Icon getObjectIconGray() {
        if (objectIconGray == null) {
            objectIconGray = IdeUtil.grayIcon((Icon)DataPanel.getObjectIcon());
        }
        return objectIconGray;
    }

    static Icon getArrayIcon() {
        if (arrayIcon == null) {
            arrayIcon = DbgArb.getIcon(487);
        }
        return arrayIcon;
    }

    private static Icon getArrayIconGray() {
        if (arrayIconGray == null) {
            arrayIconGray = IdeUtil.grayIcon((Icon)DataPanel.getArrayIcon());
        }
        return arrayIconGray;
    }

    private static Icon getStaticFolderIcon() {
        if (staticFolderIcon == null) {
            staticFolderIcon = DbgArb.getIcon(226);
        }
        return staticFolderIcon;
    }

    private static Icon getHeapFolderIcon() {
        if (heapFolderIcon == null) {
            heapFolderIcon = DbgArb.getIcon(708);
        }
        return heapFolderIcon;
    }

    private static Icon getEvaluationIcon() {
        return OracleIcons.getIcon((String)"edit.png");
    }

    protected static DataFlavor getExpressionFlavor() {
        if (expressionFlavor == null) {
            expressionFlavor = new DataFlavor(Expression.class, "Expression");
        }
        return expressionFlavor;
    }

    protected static DataFlavor getHeapObjectFlavor() {
        if (heapObjectFlavor == null) {
            heapObjectFlavor = new DataFlavor(DebugDataCompositeInfo.class, "HeapObject");
        }
        return heapObjectFlavor;
    }

    static {
        primitiveIconGray = null;
        objectIconGray = null;
        arrayIcon = null;
        arrayIconGray = null;
        staticFolderIcon = null;
        heapFolderIcon = null;
        defaultArrayRangeMax = 0;
        UPDATE_SCHEDULER = Executors.newSingleThreadExecutor(new WorkerThreadFactory(null));
    }

    static Icon maS$getEvaluationIcon() {
        return DataPanel.getEvaluationIcon();
    }

    static Map ra$arrayRanges(DataPanel dataPanel) {
        return dataPanel.arrayRanges;
    }

    static ExecutorService ra$UPDATE_SCHEDULER() {
        return UPDATE_SCHEDULER;
    }

    static Object ra$modelUpdateLock(DataPanel dataPanel) {
        return dataPanel.modelUpdateLock;
    }

    static void wa$skippedUpdate(DataPanel dataPanel, boolean bl) {
        dataPanel.skippedUpdate = bl;
    }

    static boolean[] ra$columnShowing(DataPanel dataPanel) {
        return dataPanel.columnShowing;
    }

    static DataItem[] mav$makeDataItemsForObject(DataPanel dataPanel, DataItem dataItem, DebugDataObjectInfo debugDataObjectInfo) {
        return dataPanel.makeDataItemsForObject(dataItem, debugDataObjectInfo);
    }

    static DataItem[] mav$makeDataItemsForArray(DataPanel dataPanel, DataItem dataItem, DebugDataArrayInfo debugDataArrayInfo, DataArrayRange dataArrayRange) {
        return dataPanel.makeDataItemsForArray(dataItem, debugDataArrayInfo, dataArrayRange);
    }

    static DataItem[] mav$makeDataItemsForClass(DataPanel dataPanel, DataItem dataItem, DebugClassInfo debugClassInfo) {
        return dataPanel.makeDataItemsForClass(dataItem, debugClassInfo);
    }

    static DataItem[] mav$makeDataItemsForHeapInfo(DataPanel dataPanel, DataItem dataItem, DebugHeapInfo debugHeapInfo) {
        return dataPanel.makeDataItemsForHeapInfo(dataItem, debugHeapInfo);
    }

    static DataItem[] mav$makeDataItemsForHeapAncestor(DataPanel dataPanel, DataItem dataItem, DebugHeapAncestor debugHeapAncestor) {
        return dataPanel.makeDataItemsForHeapAncestor(dataItem, debugHeapAncestor);
    }

    static DataItem[] mav$makeDataItemsForAnnotation(DataPanel dataPanel, DataItem dataItem, DebugAnnotationInfo debugAnnotationInfo) {
        return dataPanel.makeDataItemsForAnnotation(dataItem, debugAnnotationInfo);
    }

    static boolean ra$canUpdateData(DataPanel dataPanel) {
        return dataPanel.canUpdateData;
    }

    static DataFlavor[] ra$transferFlavors() {
        return transferFlavors;
    }

    static String mav$prepareDisplayName(DataPanel dataPanel, Object object, String string, String string2) {
        return dataPanel.prepareDisplayName(object, string, string2);
    }

    static Icon maS$getStaticFolderIcon() {
        return DataPanel.getStaticFolderIcon();
    }

    static Icon maS$getHeapFolderIcon() {
        return DataPanel.getHeapFolderIcon();
    }

    static Icon maS$getPrimitiveIconGray() {
        return DataPanel.getPrimitiveIconGray();
    }

    static Icon maS$getArrayIconGray() {
        return DataPanel.getArrayIconGray();
    }

    static Icon maS$getObjectIconGray() {
        return DataPanel.getObjectIconGray();
    }

    static ObjectPreferences ra$objectPreferences(DataPanel dataPanel) {
        return dataPanel.objectPreferences;
    }

    static DataArrayRange mav$getArrayRange(DataPanel dataPanel, DebugDataArrayInfo debugDataArrayInfo) {
        return dataPanel.getArrayRange(debugDataArrayInfo);
    }

    static int maS$getDefaultArrayRangeMax() {
        return DataPanel.getDefaultArrayRangeMax();
    }

    static boolean mav$handleDoubleClickOrEnter(DataPanel dataPanel, EventObject eventObject, int n) {
        return dataPanel.handleDoubleClickOrEnter(eventObject, n);
    }

    static void mav$adjustColumnsAfterResize(DataPanel dataPanel) {
        dataPanel.adjustColumnsAfterResize();
    }

    static DataTreeCellRenderer ra$dataTreeCellRenderer(DataPanel dataPanel) {
        return dataPanel.dataTreeCellRenderer;
    }

    static DataTableCellRenderer ra$dataTableCellRenderer(DataPanel dataPanel) {
        return dataPanel.dataTableCellRenderer;
    }

    static final class 1
    extends DataPanel {
        private final /* synthetic */ DebugAnnotationInfo[] v$annotations;

        protected void addDataItems() {
            List root = this.getRoot();
            int i = 0;
            DebugAnnotationInfo[] debugAnnotationInfoArray = this.v$annotations;
            int n = 0;
            while (n < debugAnnotationInfoArray.length) {
                DebugAnnotationInfo annotation = debugAnnotationInfoArray[n];
                DebugClassInfo annotationType = annotation.getClassInfo();
                String displayName = "@" + 1.makeType(null, annotationType, false);
                root.add(new DataItem(annotation, displayName, null));
                ++i;
                ++n;
            }
        }

        public 1(String string, DataPanelSettings dataPanelSettings, DebugAnnotationInfo[] debugAnnotationInfoArray) {
            this.v$annotations = debugAnnotationInfoArray;
            super(string, dataPanelSettings);
        }
    }

    final class 2
    extends StructureChangeListener {
        public void structureValuesChanged(StructureChangeEvent e) {
            DataPanel.this.dataPanelSettingsChanged(true);
        }
    }

    final class 3
    extends DefaultTableCellRenderer {
        private final /* synthetic */ TableCellRenderer v$headerRenderer;
        final /* synthetic */ DataPanel this$0;

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (this.v$headerRenderer instanceof DefaultTableCellRenderer) {
                DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)this.v$headerRenderer;
                defaultTableCellRenderer.setHorizontalAlignment(2);
            }
            return this.v$headerRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }

        public 3(DataPanel dataPanel, TableCellRenderer tableCellRenderer) {
            this.v$headerRenderer = tableCellRenderer;
            this.this$0 = dataPanel;
        }
    }

    final class 4
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                DataPanel.this.showPopup(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                DataPanel.this.showPopup(e);
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (DataPanel.this.debuggingProcess == null || !DataPanel.this.debuggingProcess.isStopped()) {
                Toolkit.getDefaultToolkit().beep();
                DebuggingProcess.showStatus(DbgArb.format(253, DataPanel.this.title));
            }
            if (JDebugger.isDoubleClickInTreeTable(DataPanel.this.treeTable, e)) {
                int columnAtX = DataPanel.this.treeTable.getColumnModel().getColumnIndexAtX(e.getX());
                int column = DataPanel.this.treeTable.convertColumnIndexToModel(columnAtX);
                DataPanel.mav$handleDoubleClickOrEnter(DataPanel.this, e, column);
            }
        }
    }

    final class 5
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            if (DataPanel.this.debuggingProcess == null || !DataPanel.this.debuggingProcess.isStopped()) {
                Toolkit.getDefaultToolkit().beep();
                DebuggingProcess.showStatus(DbgArb.format(253, DataPanel.this.title));
            }
        }
    }

    final class 6
    extends KeyAdapter {
        public void keyPressed(KeyEvent e) {
            int key = e.getKeyCode();
            switch (key) {
                case 10: {
                    int column;
                    int selectedColumn = DataPanel.this.treeTable.getSelectedColumn();
                    if (selectedColumn == -1 || !DataPanel.mav$handleDoubleClickOrEnter(DataPanel.this, e, column = DataPanel.this.treeTable.convertColumnIndexToModel(selectedColumn))) break;
                    e.consume();
                    break;
                }
            }
        }
    }

    final class 7
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                DataPanel.this.showPopup(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                DataPanel.this.showPopup(e);
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (DataPanel.this.debuggingProcess == null || !DataPanel.this.debuggingProcess.isStopped()) {
                Toolkit.getDefaultToolkit().beep();
                DebuggingProcess.showStatus(DbgArb.format(253, DataPanel.this.title));
            }
        }
    }

    final class 8
    extends ComponentAdapter {
        public void componentResized(ComponentEvent e) {
            DataPanel.mav$adjustColumnsAfterResize(DataPanel.this);
        }
    }

    final class 9
    implements HierarchyListener {
        public void hierarchyChanged(HierarchyEvent e) {
            if ((e.getChangeFlags() & (long)4) != 0L && (DataPanel.this.treeTable.isShowing() || DataPanel.this.dockableWindow == null)) {
                DataPanel.this.nowShown();
            }
        }
    }

    class DataTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private TreePath treePath;
        private DataItem dataItem;

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof DataItem) {
                this.dataItem = (DataItem)value;
                this.treePath = DataPanel.this.treeTable.getTree().getPathForRow(row);
                this.setIcon(this.dataItem.getIcon());
                this.setFont(this.dataItem.getFont(0));
                this.setEnabled(DataItem.mav$isUnrelated(this.dataItem) ^ true);
                try {
                    AccessibleContext ac = this.getAccessibleContext();
                    String accessibleName = DataTreeTableModel.mav$getAccessibleNameAt(DataPanel.this.model, this.dataItem, 0);
                    if (this.dataItem.mayHaveChildren()) {
                        accessibleName = JDebugger.fixTreeCellAccessibleName(accessibleName, expanded);
                    }
                    if (accessibleName != null) {
                        ac.setAccessibleName(accessibleName);
                    }
                }
                catch (DataExpiredException e) {}
            } else {
                this.dataItem = null;
                this.setIcon(null);
                this.setFont(DataPanel.this.getNormalFont());
                this.setEnabled(true);
                this.setToolTipText(null);
            }
            return this;
        }

        public String getToolTipText(MouseEvent event) {
            if (this.dataItem != null && this.treePath != null) {
                return this.dataItem.getToolTip(0, this.treePath);
            }
            return null;
        }

        void clear() {
            this.treePath = null;
            this.dataItem = null;
        }

        DataTreeCellRenderer() {
        }
    }

    class DataTableCellRenderer
    extends DefaultTableCellRenderer {
        private TreePath treePath;
        private DataItem dataItem;
        private int modelColumn;
        private JPanel panel;

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.treePath = DataPanel.this.treeTable.getTree().getPathForRow(row);
            this.dataItem = DataPanel.this.model.getDataItemForTreePath(this.treePath);
            this.modelColumn = table.convertColumnIndexToModel(column);
            if (this.dataItem != null) {
                this.setFont(this.dataItem.getFont(this.modelColumn));
            }
            if (this.dataItem != null) {
                AccessibleContext ac = this.getAccessibleContext();
                String accessibleName = DataTreeTableModel.mav$getAccessibleNameAt(DataPanel.this.model, this.dataItem, this.modelColumn);
                if (accessibleName != null) {
                    ac.setAccessibleName(accessibleName);
                }
            }
            if (this.modelColumn == 1 && this.dataItem != null && this.dataItem.getValueExpressionUsed() != null) {
                if (this.panel == null) {
                    this.makePanel();
                }
                this.panel.add((Component)this, "Center");
                return this.panel;
            }
            Container parent = this.getParent();
            if (parent != null) {
                parent.remove(this);
            }
            return this;
        }

        public String getToolTipText(MouseEvent event) {
            if (this.dataItem != null && this.treePath != null) {
                return this.dataItem.getToolTip(this.modelColumn, this.treePath);
            }
            return null;
        }

        void clear() {
            this.treePath = null;
            this.dataItem = null;
        }

        private void makePanel() {
            this.panel = new 1(new BorderLayout(0, 0));
            JButton iconButton = new JButton(DataPanel.maS$getEvaluationIcon());
            iconButton.setMargin(new Insets(2, 2, 2, 2));
            this.panel.add((Component)iconButton, "East");
        }

        DataTableCellRenderer() {
        }

        final class 1
        extends JPanel {
            public String getToolTipText(MouseEvent event) {
                return DataTableCellRenderer.this.getToolTipText(event);
            }

            public 1(LayoutManager layoutManager) {
                super(layoutManager);
            }
        }
    }

    class ValueCellEditor
    extends AbstractTableCellEditor {
        private JPanel panel = new JPanel(new BorderLayout(0, 0));
        private JLabel label = new JLabel();

        ValueCellEditor() {
            this.label.setOpaque(true);
            this.label.setBorder(new EmptyBorder(1, 1, 1, 1));
            this.panel.add((Component)this.label, "Center");
            JButton iconButton = new JButton(DataPanel.maS$getEvaluationIcon());
            iconButton.setMargin(new Insets(2, 2, 2, 2));
            iconButton.addActionListener(new 1());
            this.panel.add((Component)iconButton, "East");
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.label.setForeground(table.getSelectionForeground());
            this.label.setBackground(table.getSelectionBackground());
            this.label.setFont(table.getFont());
            this.label.setText(value == null ? DataPanel.NOT_AVAILABLE : value.toString());
            return this.panel;
        }

        public Object getCellEditorValue() {
            return null;
        }

        public boolean isCellEditable(EventObject anEvent) {
            return anEvent instanceof MouseEvent;
        }

        final class 1
        implements ActionListener {
            public void actionPerformed(ActionEvent e) {
                ValueCellEditor.this.cancelCellEditing();
                Context context = DataPanel.this.getContext(e);
                DataPanel.this.update(DataPanel.this._actionObjectPreferences, context);
                if (DataPanel.this._actionObjectPreferences.isEnabled()) {
                    DataPanel.this.handleEvent(DataPanel.this._actionObjectPreferences, context);
                }
            }
        }
    }

    final class 10
    implements Runnable {
        public void run() {
            DataPanel.this.everythingChanged();
        }
    }

    static final class 11
    implements Comparator {
        public int compare(DebugFieldInfo field1, DebugFieldInfo field2) {
            return field1.getName().compareToIgnoreCase(field2.getName());
        }
    }

    final class 12
    implements Comparator {
        public int compare(DebugHeapAncestor a1, DebugHeapAncestor a2) {
            return a1.getDepth() - a2.getDepth();
        }
    }

    final class DataTreeTableModel
    extends AbstractTreeTableModel {
        private List root;
        private List expanded;
        private DataInfoPath highlight;

        DataTreeTableModel(List root) {
            super((Object)root);
            this.root = root;
            this.expanded = Collections.synchronizedList(new ArrayList());
        }

        void updateDataForModel() {
            this.updateDataForModel(false);
        }

        void updateDataForModel(boolean offThread) {
            DataPopulationWorker worker = new DataPopulationWorker(null);
            if (offThread) {
                DataPanel.ra$UPDATE_SCHEDULER().submit(worker);
            } else {
                worker.run();
            }
        }

        void fireChanged() {
            TreePath rootTreePath = new TreePath(this.root);
            this.fireTreeStructureChanged((Object)this, rootTreePath.getPath(), null, null);
            this.restoreExpanded(rootTreePath);
        }

        void fireChanged(TreePath path) {
            this.fireTreeStructureChanged((Object)this, path.getPath(), null, null);
        }

        void clearDataForModel() {
            this.saveHighlight();
            this.clearAll();
        }

        void addTopDataItem(DataItem dataItem) {
            this.addTopDataItem(dataItem, true);
        }

        void addTopDataItem(DataItem dataItem, boolean highlight) {
            if (!highlight) {
                this.saveHighlight();
            }
            int i = this.root.size();
            this.root.add(dataItem);
            this.fireChanged();
            if (highlight) {
                this.selectTopDataItem(i);
            } else {
                this.restoreHighlight(false);
            }
        }

        void removeTopDataItem(int i) {
            this.saveHighlight();
            this.root.remove(i);
            this.fireChanged();
            this.restoreHighlight(false);
        }

        void selectTopDataItem(int i) {
            Object[] path = new Object[]{this.root, this.root.get(i)};
            TreePath treePath = new TreePath(path);
            JDebugger.getInstance().selectTreeTablePath(DataPanel.this.treeTable, treePath, true);
        }

        void processFinished(DebuggingProcess debuggingProcess) {
            ArrayList<DataInfoPath> remove = new ArrayList<DataInfoPath>();
            for (DataInfoPath dataInfoPath : this.expanded) {
                if (dataInfoPath.getDebuggingProcess() != debuggingProcess) continue;
                remove.add(dataInfoPath);
            }
            for (Object e : remove) {
                this.expanded.remove(e);
            }
            this.highlight = null;
            ArrayList needToRemove = new ArrayList();
            for (Object key : DataPanel.ra$arrayRanges(DataPanel.this).keySet()) {
                DataArrayRange arrayRange = (DataArrayRange)DataPanel.ra$arrayRanges(DataPanel.this).get(key);
                if (arrayRange.getDebuggingProcess() != debuggingProcess) continue;
                needToRemove.add(key);
            }
            int i = needToRemove.size() - 1;
            while (i >= 0) {
                DataPanel.ra$arrayRanges(DataPanel.this).remove(needToRemove.get(i));
                --i;
            }
        }

        private void clearAll() {
            this.clearAll(DataPanel.this.treeTable.getTree(), new TreePath(this.root));
        }

        private void clearAll(JTree tree, TreePath treePath) {
            Object node = treePath.getLastPathComponent();
            if (node instanceof DataItem) {
                ((DataItem)node).clearDataForItem();
            }
            Iterator children = this.getLazyChildren(node);
            while (children.hasNext()) {
                Object child = children.next();
                this.clearAll(tree, treePath.pathByAddingChild(child));
            }
        }

        private void clearCacheForColumn(int column) {
            this.clearCacheForColumn(DataPanel.this.treeTable.getTree(), new TreePath(this.root), column);
        }

        private void clearCacheForColumn(JTree tree, TreePath treePath, int column) {
            Object node = treePath.getLastPathComponent();
            if (node instanceof DataItem) {
                ((DataItem)node).clearCacheForColumn(column);
            }
            Iterator children = this.getLazyChildren(node);
            while (children.hasNext()) {
                Object child = children.next();
                this.clearCacheForColumn(tree, treePath.pathByAddingChild(child), column);
            }
        }

        private void restoreExpanded(TreePath treePath) {
            JTree tree = DataPanel.this.treeTable.getTree();
            if (tree.isExpanded(treePath)) {
                Object node = treePath.getLastPathComponent();
                Iterator children = this.getChildren(node);
                while (children.hasNext()) {
                    Object child = children.next();
                    TreePath childTreePath = treePath.pathByAddingChild(child);
                    DataInfoPath dataInfoPath = this.convertTreePathToDataInfoPath(childTreePath);
                    if (!this.expanded.contains(dataInfoPath)) continue;
                    tree.expandPath(childTreePath);
                }
            }
        }

        private void branchExpanded(TreePath treePath) {
            DataInfoPath dataInfoPath;
            DataItem dataItem = this.getDataItemForTreePath(treePath);
            if (dataItem != null) {
                dataItem.isExpanded = true;
            }
            if ((dataInfoPath = this.convertTreePathToDataInfoPath(treePath)) != null) {
                int i = this.expanded.indexOf(dataInfoPath);
                if (i != -1) {
                    this.expanded.remove(i);
                }
                this.expanded.add(dataInfoPath);
                this.restoreExpanded(treePath);
            }
        }

        private void branchCollapsed(TreePath treePath) {
            DataInfoPath dataInfoPath;
            DataItem dataItem = this.getDataItemForTreePath(treePath);
            if (dataItem != null) {
                dataItem.isExpanded = false;
            }
            if ((dataInfoPath = this.convertTreePathToDataInfoPath(treePath)) != null) {
                this.expanded.remove(dataInfoPath);
            }
        }

        void saveHighlight() {
            DataInfoPath highlight = this.getCurrentHighlight();
            if (highlight != null) {
                this.highlight = highlight;
            }
        }

        void restoreHighlight(boolean scrollToVisible) {
            TreePath treePath = null;
            if (this.highlight != null) {
                treePath = this.makeVisible(this.highlight);
            }
            if (treePath == null && DataPanel.this.selectFirstRowIfNoPreviousSelection) {
                treePath = DataPanel.this.treeTable.getTree().getPathForRow(0);
            }
            if (treePath != null) {
                JDebugger.getInstance().selectTreeTablePath(DataPanel.this.treeTable, treePath, scrollToVisible);
            }
        }

        TreePath makeVisible(DataInfoPath dataInfoPath) {
            TreePath treePath = this.convertDataInfoPathToTreePath(dataInfoPath);
            if (treePath != null) {
                DataPanel.this.treeTable.getTree().makeVisible(treePath);
            }
            return treePath;
        }

        DataInfoPath getCurrentHighlight() {
            TreePath treePath = DataPanel.this.treeTable.getTree().getSelectionPath();
            if (treePath != null) {
                return this.convertTreePathToDataInfoPath(treePath);
            }
            return null;
        }

        TreePath getTreePathAtPoint(Point pt) {
            int row = DataPanel.this.treeTable.rowAtPoint(pt);
            return DataPanel.this.treeTable.getTree().getPathForRow(row);
        }

        DataItem getDataItemForTreePath(TreePath treePath) {
            Object node;
            if (treePath != null && (node = treePath.getLastPathComponent()) instanceof DataItem) {
                return (DataItem)node;
            }
            return null;
        }

        DataInfoPath convertTreePathToDataInfoPath(TreePath treePath) {
            boolean foundOneDataInfo = false;
            Object[] path = treePath.getPath();
            int pathLength = path.length;
            Object[] dataInfoArray = new Object[pathLength];
            int i = 0;
            while (i < pathLength) {
                Object node = path[i];
                if (node instanceof DataItem) {
                    dataInfoArray[i] = ((DataItem)node).getInfo();
                    if (dataInfoArray[i] != null) {
                        foundOneDataInfo = true;
                    }
                }
                ++i;
            }
            if (foundOneDataInfo) {
                return new DataInfoPath(DataPanel.this.debuggingProcess, dataInfoArray);
            }
            return null;
        }

        TreePath convertDataInfoPathToTreePath(DataInfoPath dataInfoPath) {
            int dataInfoPathSize = dataInfoPath.size();
            if (dataInfoPathSize == 0) {
                return null;
            }
            List node = this.root;
            TreePath treePath = new TreePath(node);
            int i = 1;
            while (i < dataInfoPathSize) {
                Object dataInfo = dataInfoPath.getDataInfo(i);
                Object nextNode = null;
                Iterator iChild = this.getChildren(node);
                while (iChild.hasNext()) {
                    Object nextDataInfo;
                    Object child = iChild.next();
                    if (!(child instanceof DataItem) || !((nextDataInfo = ((DataItem)child).getInfo()) == null ? dataInfo == null : nextDataInfo.equals(dataInfo))) continue;
                    nextNode = child;
                    break;
                }
                if (nextNode == null) {
                    return null;
                }
                node = nextNode;
                treePath = treePath.pathByAddingChild(node);
                ++i;
            }
            return treePath;
        }

        private void collapseAll() {
            WaitCursor wc = Ide.getWaitCursor();
            wc.show();
            this.collapseAll(DataPanel.this.treeTable.getTree(), new TreePath(this.root));
            wc.hide();
        }

        private void collapseAll(JTree tree, TreePath treePath) {
            Object node = treePath.getLastPathComponent();
            Iterator children = this.getLazyChildren(node);
            while (children.hasNext()) {
                Object child = children.next();
                this.collapseAll(tree, treePath.pathByAddingChild(child));
            }
            if (!node.equals(this.root)) {
                tree.collapsePath(treePath);
            }
        }

        private void save(PrintWriter out, boolean html) {
            if (html) {
                out.println("<table border=\"1\">");
            }
            this.saveHeader(out, html);
            this.save(DataPanel.this.treeTable.getTree(), new TreePath(this.root), out, html, DataPanel.NOT_AVAILABLE);
            if (html) {
                out.println("</table>");
            }
        }

        private void saveHeader(PrintWriter out, boolean html) {
            StringBuffer sb = new StringBuffer();
            StringBuffer sb2 = new StringBuffer();
            if (html) {
                sb.append("<tr>");
            }
            TableColumnModel tableColumnModel = DataPanel.this.treeTable.getColumnModel();
            Enumeration<TableColumn> e = tableColumnModel.getColumns();
            while (e.hasMoreElements()) {
                TableColumn column = e.nextElement();
                int i = column.getModelIndex();
                String columnName = this.getColumnName(i);
                if (html) {
                    sb.append("<th>");
                    columnName = IdeUtil.replaceHTMLReservedCharacters((String)columnName.toString());
                    sb.append(columnName);
                    sb.append("</th>");
                    continue;
                }
                sb.append(columnName);
                int ii = columnName.length();
                while (ii >= 0) {
                    sb2.append('-');
                    --ii;
                }
                if (!e.hasMoreElements()) continue;
                sb.append('\t');
                sb2.append('\t');
            }
            if (html) {
                sb.append("</tr>");
            }
            out.println(sb.toString());
            if (!html) {
                out.println(sb2.toString());
            }
        }

        private void save(JTree tree, TreePath treePath, PrintWriter out, boolean html, String indent) {
            if (tree.isVisible(treePath)) {
                Object node = treePath.getLastPathComponent();
                if (node instanceof DataItem) {
                    DataItem dataItem = (DataItem)node;
                    StringBuffer sb = new StringBuffer();
                    if (html) {
                        sb.append("<tr>");
                    }
                    TableColumnModel tableColumnModel = DataPanel.this.treeTable.getColumnModel();
                    Enumeration<TableColumn> e = tableColumnModel.getColumns();
                    while (e.hasMoreElements()) {
                        TableColumn column = e.nextElement();
                        int i = column.getModelIndex();
                        Object columnValue = this.getValueAt(node, i);
                        if (html) {
                            String columnValueString;
                            sb.append("<td>");
                            if (i == 0) {
                                sb.append("<tt>");
                                if (indent != null) {
                                    sb.append(indent);
                                }
                                if (tree.isExpanded(treePath)) {
                                    sb.append("-&nbsp;");
                                } else if (dataItem.mayHaveChildren()) {
                                    sb.append("+&nbsp;");
                                } else {
                                    sb.append("&nbsp;&nbsp;");
                                }
                                sb.append("</tt>");
                            }
                            if ((columnValueString = IdeUtil.replaceHTMLReservedCharacters((String)columnValue.toString())).length() > 0) {
                                sb.append(columnValueString);
                            } else {
                                sb.append("&nbsp;");
                            }
                            sb.append("</td>");
                            continue;
                        }
                        if (i == 0) {
                            if (indent != null) {
                                sb.append(indent);
                            }
                            if (tree.isExpanded(treePath)) {
                                sb.append("- ");
                            } else if (dataItem.mayHaveChildren()) {
                                sb.append("+ ");
                            } else {
                                sb.append("  ");
                            }
                        }
                        sb.append(columnValue);
                        if (!e.hasMoreElements()) continue;
                        sb.append('\t');
                    }
                    if (html) {
                        sb.append("</tr>");
                    }
                    out.println(sb.toString());
                }
                if (node != this.root) {
                    indent = html ? indent + "&nbsp;&nbsp;&nbsp;&nbsp;" : indent + "    ";
                }
                Iterator children = this.getLazyChildren(node);
                while (children.hasNext()) {
                    Object child = children.next();
                    this.save(tree, treePath.pathByAddingChild(child), out, html, indent);
                }
            }
        }

        public boolean isLeaf(Object node) {
            try {
                if (node == this.root) {
                    boolean bl = false;
                    return bl;
                }
                DataItem dataItem = (DataItem)node;
                boolean bl = dataItem.mayHaveChildren() ^ true;
                return bl;
            }
            catch (Exception e) {
                e.printStackTrace();
                return true;
            }
        }

        Iterator getChildren(Object parent) {
            if (parent == this.root) {
                return this.root.iterator();
            }
            DataItem dataItem = (DataItem)parent;
            return dataItem.getChildren();
        }

        Iterator getLazyChildren(Object parent) {
            if (parent == this.root) {
                return this.root.iterator();
            }
            DataItem dataItem = (DataItem)parent;
            return dataItem.getLazyChildren();
        }

        public Object getChild(Object parent, int index) {
            try {
                if (parent == this.root) {
                    Object e = this.root.get(index);
                    return e;
                }
                DataItem dataItem = (DataItem)parent;
                DataItem dataItem2 = dataItem.getChildNodes()[index];
                return dataItem2;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public int getChildCount(Object parent) {
            try {
                if (parent == this.root) {
                    int n = this.root.size();
                    return n;
                }
                DataItem dataItem = (DataItem)parent;
                int n = dataItem.countChildNodes();
                return n;
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        }

        public int getColumnCount() {
            return DataPanel.this.getNumberOfColumns();
        }

        public String getColumnName(int column) {
            return DataPanel.this.getNameOfColumn(column);
        }

        public Class getColumnClass(int column) {
            if (column == 0) {
                return TreeTableModel.class;
            }
            return String.class;
        }

        public boolean isCellEditable(Object node, int column) {
            try {
                DataItem dataItem;
                if (column == 1 && node != this.root && (dataItem = (DataItem)node).getValueExpressionUsed() != null) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return super.isCellEditable(node, column);
        }

        public Object getValueAt(Object node, int column) {
            try {
                if (node == this.root) {
                    String string = DataPanel.NOT_AVAILABLE;
                    return string;
                }
                DataItem item = (DataItem)node;
                Object object = item.getValueOfColumn(column);
                return object;
            }
            catch (DataExpiredException e) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        private String getAccessibleNameAt(DataItem dataItem, int column) {
            int id = 537;
            String columnName = this.getColumnName(column);
            String value = (String)this.getValueAt(dataItem, column);
            if (value == null || value.length() == 0) {
                value = DbgArb.getString(32);
            }
            return DbgArb.format(id, columnName, value);
        }

        static void mav$clearCacheForColumn(DataTreeTableModel dataTreeTableModel, int n) {
            dataTreeTableModel.clearCacheForColumn(n);
        }

        static void mav$save(DataTreeTableModel dataTreeTableModel, PrintWriter printWriter, boolean bl) {
            dataTreeTableModel.save(printWriter, bl);
        }

        static void mav$collapseAll(DataTreeTableModel dataTreeTableModel) {
            dataTreeTableModel.collapseAll();
        }

        static void mav$branchCollapsed(DataTreeTableModel dataTreeTableModel, TreePath treePath) {
            dataTreeTableModel.branchCollapsed(treePath);
        }

        static void mav$branchExpanded(DataTreeTableModel dataTreeTableModel, TreePath treePath) {
            dataTreeTableModel.branchExpanded(treePath);
        }

        static String mav$getAccessibleNameAt(DataTreeTableModel dataTreeTableModel, DataItem dataItem, int n) {
            return dataTreeTableModel.getAccessibleNameAt(dataItem, n);
        }

        static List ra$root(DataTreeTableModel dataTreeTableModel) {
            return dataTreeTableModel.root;
        }
    }

    private static class WorkerThreadFactory
    implements ThreadFactory {
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "DataPopulation Thread");
            t.setDaemon(true);
            return t;
        }

        private WorkerThreadFactory() {
        }

        WorkerThreadFactory(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private class DataPopulationWorker
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Object object = DataPanel.ra$modelUpdateLock(DataPanel.this);
                synchronized (object) {
                    DataPanel.this.model.saveHighlight();
                    DataTreeTableModel.ra$root(DataPanel.this.model).clear();
                    if (DataPanel.this.treeTable.isShowing() || DataPanel.this.dockableWindow == null) {
                        DataPanel.wa$skippedUpdate(DataPanel.this, false);
                        if (DataPanel.this.debuggingProcess != null && DataPanel.this.vm != null) {
                            DataPanel.this.addDataItems();
                        }
                    } else {
                        DataPanel.wa$skippedUpdate(DataPanel.this, true);
                    }
                }
                1 r = new 1();
                if (SwingUtilities.isEventDispatchThread()) {
                    r.run();
                } else {
                    SwingUtilities.invokeLater(r);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private DataPopulationWorker() {
        }

        DataPopulationWorker(1 var2_2) {
            this();
        }

        final class 1
        implements Runnable {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                DataPanel.ra$dataTreeCellRenderer(DataPanel.this).clear();
                DataPanel.ra$dataTableCellRenderer(DataPanel.this).clear();
                try {
                    Object object = DataPanel.ra$modelUpdateLock(DataPanel.this);
                    synchronized (object) {
                        DataPanel.this.model.fireChanged();
                        DataPanel.this.model.restoreHighlight(false);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DataItem
    extends BaseElement
    implements Transferable {
        protected Object info;
        private boolean isDebugHeapAncestor;
        private boolean isDebugHeapAncestorOutsideHeap;
        protected DebugDataInfo data;
        protected DebugClassInfo actualClassInfo;
        private DebugClassInfo declaredClassInfo;
        protected DebugHeapInfo ancestorHeapInfo;
        protected int ancestorDepth;
        protected boolean ancestorShortestDepth;
        protected boolean displayNameOverridden;
        protected String displayName;
        protected String expressionPart;
        protected String displayType;
        protected String displayValue;
        private DataItem[] children;
        private DataArrayRange arrayRange;
        private Expression expressionSaved;
        private Boolean cachedMayHaveChildren;
        private String cachedDisplayName;
        private String cachedActualType;
        private String cachedFullyQualifiedActualType;
        private String cachedDeclaredType;
        private String cachedFullyQualifiedDeclaredType;
        private String cachedValue;
        private String cachedValueExpressionUsed;
        private String cachedHexValue;
        private String cachedAddress;
        private String cachedID;
        private List<DataItem> cachedFields;
        private List<DataItem> cachedDeclaredFields;
        private DataItem parentDataItem;
        protected boolean isExpanded;

        DataItem(Object info) {
            this(info, null, null);
        }

        DataItem(Object info, String displayNameOverride, String expressionPartOverride) {
            this.ancestorHeapInfo = null;
            this.ancestorDepth = -1;
            this.ancestorShortestDepth = false;
            this.setInfo(info, displayNameOverride, expressionPartOverride);
        }

        DataItem(Object info, String displayNameOverride, DebugHeapInfo ancestorHeapInfo, int ancestorDepth, boolean ancestorShortestDepth) {
            this.ancestorHeapInfo = ancestorHeapInfo;
            this.ancestorDepth = ancestorDepth;
            this.ancestorShortestDepth = ancestorShortestDepth;
            this.setInfo(info, displayNameOverride, null);
        }

        void modifyInfo(Object info, String displayNameOverride, String expressionPartOverride, TreePath treePath) {
            boolean expanded = DataPanel.this.treeTable.getTree().isExpanded(treePath);
            if (expanded) {
                DataTreeTableModel.mav$branchCollapsed(DataPanel.this.model, treePath);
            }
            this.setInfo(info, displayNameOverride, expressionPartOverride);
            this.clearChildren(treePath);
            if (expanded) {
                DataTreeTableModel.mav$branchExpanded(DataPanel.this.model, treePath);
            }
        }

        private void setInfo(Object info, String displayNameOverride, String expressionPartOverride) {
            this.clearCacheForColumn(-1);
            this.setIcon(null);
            this.info = info;
            this.isDebugHeapAncestor = info instanceof DebugHeapAncestor;
            this.isDebugHeapAncestorOutsideHeap = info instanceof DebugHeapAncestorOutsideHeap;
            this.displayNameOverridden = displayNameOverride != null;
            this.children = null;
            this.arrayRange = null;
            this.expressionSaved = null;
            if (info instanceof DebugVariableInfo) {
                DebugVariableInfo var = (DebugVariableInfo)info;
                this.data = var.getDataInfo();
                this.declaredClassInfo = var.getClassInfo();
                this.actualClassInfo = this.data != null ? this.data.getClassInfo() : this.declaredClassInfo;
                String name = var.getName();
                String string = this.expressionPart = expressionPartOverride != null ? expressionPartOverride : name;
                this.displayName = var.isReturned() && name != null && name.length() > 0 ? DbgArb.format(532, name) : DataPanel.mav$prepareDisplayName(DataPanel.this, info, displayNameOverride, this.expressionPart);
            } else if (info instanceof DebugStackSlotInfo) {
                DebugStackSlotInfo slot = (DebugStackSlotInfo)info;
                this.data = slot.getDataInfo();
                this.declaredClassInfo = null;
                this.actualClassInfo = this.data != null ? this.data.getClassInfo() : null;
                this.expressionPart = expressionPartOverride;
                this.displayName = displayNameOverride;
            } else if (info instanceof DebugFieldInfo) {
                DebugFieldInfo field = (DebugFieldInfo)info;
                this.data = field.getDataInfo();
                this.declaredClassInfo = field.getClassInfo();
                this.actualClassInfo = this.data != null ? this.data.getClassInfo() : this.declaredClassInfo;
                this.expressionPart = expressionPartOverride != null ? expressionPartOverride : field.getName();
                this.displayName = DataPanel.mav$prepareDisplayName(DataPanel.this, info, displayNameOverride, this.expressionPart);
            } else if (info instanceof DebugArrayElementInfo) {
                DebugArrayElementInfo arrayElement = (DebugArrayElementInfo)info;
                this.data = arrayElement.getDataInfo();
                this.declaredClassInfo = arrayElement.getClassInfo();
                this.actualClassInfo = this.data != null ? this.data.getClassInfo() : this.declaredClassInfo;
                this.expressionPart = expressionPartOverride != null ? expressionPartOverride : arrayElement.getName();
                this.displayName = DataPanel.mav$prepareDisplayName(DataPanel.this, info, displayNameOverride, this.expressionPart);
            } else if (info instanceof DebugDataInfo) {
                this.data = (DebugDataInfo)info;
                this.declaredClassInfo = null;
                this.actualClassInfo = this.data.getClassInfo();
                this.expressionPart = expressionPartOverride;
                this.displayName = DataPanel.mav$prepareDisplayName(DataPanel.this, info, displayNameOverride, this.expressionPart);
            } else if (info instanceof DebugClassInfo) {
                this.data = null;
                this.declaredClassInfo = null;
                this.actualClassInfo = null;
                this.expressionPart = ((DebugClassInfo)info).getName();
                this.displayName = null;
                this.setIcon(DataPanel.maS$getStaticFolderIcon());
            } else if (info instanceof DebugHeapSubset) {
                this.data = null;
                this.declaredClassInfo = null;
                this.actualClassInfo = null;
                this.expressionPart = expressionPartOverride;
                this.displayName = ((DebugHeapSubset)info).getName();
                this.setIcon(DataPanel.maS$getHeapFolderIcon());
            } else if (info instanceof DebugHeapInfo) {
                DebugHeapInfo heap = (DebugHeapInfo)info;
                DebugHeapSubset subset = heap.getHeapSubset();
                this.data = null;
                this.declaredClassInfo = null;
                this.actualClassInfo = null;
                this.expressionPart = expressionPartOverride;
                if (subset instanceof DebugHeapSubsetClasses) {
                    this.displayName = subset.getName() + " " + heap.countHeapObjects();
                } else if (subset instanceof DebugHeapSubsetAncestors) {
                    DebugHeapObjectInfo heapObject;
                    long address = ((DebugHeapSubsetAncestors)subset).getAddress();
                    if (address != 0L && (heapObject = DataPanel.this.vm.getHeapObjectAtAddress(address)) != null) {
                        this.actualClassInfo = heapObject.getClassInfo();
                    }
                    this.displayName = subset.getName();
                }
                this.setIcon(DataPanel.maS$getHeapFolderIcon());
            } else if (info instanceof EvaluationInfo) {
                EvaluationInfo eval = (EvaluationInfo)info;
                this.data = null;
                this.declaredClassInfo = null;
                this.actualClassInfo = eval.getClassInfo();
                this.expressionPart = expressionPartOverride;
                this.displayName = DataPanel.mav$prepareDisplayName(DataPanel.this, info, displayNameOverride, this.expressionPart);
            } else if (info instanceof EvaluatorItem) {
                this.declaredClassInfo = null;
                this.actualClassInfo = null;
                this.data = null;
                this.expressionPart = expressionPartOverride;
                this.displayName = DataPanel.mav$prepareDisplayName(DataPanel.this, info, displayNameOverride, this.expressionPart);
                this.cachedMayHaveChildren = Boolean.FALSE;
                this.cachedActualType = "?";
                this.cachedDeclaredType = "?";
                this.cachedValue = "?";
                this.cachedHexValue = "?";
                this.cachedAddress = DataPanel.NOT_AVAILABLE;
                this.cachedID = DataPanel.NOT_AVAILABLE;
            } else if (info instanceof DebugMonitorInfo) {
                DebugMonitorInfo monitor = (DebugMonitorInfo)info;
                this.data = monitor.getAssociatedObject();
                this.declaredClassInfo = null;
                this.actualClassInfo = this.data.getClassInfo();
                this.expressionPart = expressionPartOverride;
                String name = null;
                long number = JDebugger.getObjectNumber((DebugDataCompositeInfo)this.data);
                name = "@" + Long.toHexString(number).toUpperCase();
                this.displayName = DataPanel.mav$prepareDisplayName(DataPanel.this, info, displayNameOverride, name);
            } else if (info instanceof DebugHeapAncestor) {
                this.data = null;
                this.declaredClassInfo = null;
                this.actualClassInfo = null;
                this.expressionPart = expressionPartOverride;
                int depth = ((DebugHeapAncestor)info).getDepth();
                this.displayValue = DbgArb.format(246, Integer.toString(depth));
                if (info instanceof DebugHeapAncestorInsideHeap) {
                    DebugHeapAncestorInsideHeap ancestorInsideHeap = (DebugHeapAncestorInsideHeap)info;
                    this.data = ancestorInsideHeap.getDataInfo();
                    this.declaredClassInfo = null;
                    this.actualClassInfo = this.data.getClassInfo();
                    long address = ancestorInsideHeap.getAddress();
                    this.displayName = this.actualClassInfo.isArray() ? DbgArb.format(957, "@" + Long.toHexString(address).toUpperCase()) : DbgArb.format(306, "@" + Long.toHexString(address).toUpperCase());
                } else if (info instanceof DebugHeapAncestorInPinTable) {
                    DebugHeapAncestorInPinTable ancestorInPinTable = (DebugHeapAncestorInPinTable)info;
                    DebugDataCompositeInfo d = ancestorInPinTable.getDataInfo();
                    DebugClassInfo c = d.getClassInfo();
                    long pinnedAddress = ancestorInPinTable.getPinnedAddress();
                    this.displayName = c.isArray() ? DbgArb.format(27, "@" + Long.toHexString(pinnedAddress).toUpperCase()) : DbgArb.format(790, "@" + Long.toHexString(pinnedAddress).toUpperCase());
                    this.displayType = DataPanel.makeType((DebugDataInfo)d, c, DataPanel.this.dataPanelSettings.isShowPackages());
                } else if (info instanceof DebugHeapAncestorInRegister) {
                    DebugHeapAncestorInRegister ancestorInRegister = (DebugHeapAncestorInRegister)info;
                    DebugRegisterInfo regInfo = ancestorInRegister.getRegister();
                    DebugThreadInfo thread = ancestorInRegister.getThread();
                    this.displayName = DbgArb.format(503, regInfo.getName());
                    this.displayType = DbgArb.format(502, thread.getName());
                } else if (info instanceof DebugHeapAncestorInStack) {
                    DebugHeapAncestorInStack ancestorInStack = (DebugHeapAncestorInStack)info;
                    if (ancestorInStack.getVariableInfo() != null) {
                        DebugMethodInfo method = ancestorInStack.getStackFrame().getLocation().getMethod();
                        this.displayName = DbgArb.getString(829);
                        this.displayType = DbgArb.format(828, DebugShared.makeCourtesyMethodName(method, true, false, null));
                    } else {
                        DebugThreadInfo thread = ancestorInStack.getThread();
                        this.displayName = DbgArb.getString(269);
                        this.displayType = DbgArb.format(268, thread.getName());
                    }
                } else if (info instanceof DebugHeapAncestorInStatic) {
                    DebugHeapAncestorInStatic ancestorInStatic = (DebugHeapAncestorInStatic)info;
                    DebugClassInfo clazz = ancestorInStatic.getClassInfo();
                    this.displayName = DbgArb.getString(221);
                    this.displayType = DbgArb.format(220, DebugShared.makeCourtesyClassName(clazz, true));
                }
            } else if (info instanceof DebugAnnotationInfo) {
                DebugAnnotationInfo annotation = (DebugAnnotationInfo)info;
                this.declaredClassInfo = this.actualClassInfo = annotation.getClassInfo();
                this.data = null;
                this.expressionPart = expressionPartOverride;
                this.displayName = DataPanel.mav$prepareDisplayName(DataPanel.this, info, displayNameOverride, this.expressionPart);
            } else if (info == null) {
                Assert.println((String)"DataPanel$DataItem.setInfo: info is null");
            } else {
                Assert.println((String)("DataPanel$DataItem.setInfo: info is not recognized: " + info.getClass().getName()));
            }
            if (this.actualClassInfo != null && this.actualClassInfo.isEnum()) {
                this.displayValue = this.getEnumValueDisplayName(this.data);
            }
            if (this.getIcon() == null) {
                if (this.data == null && info instanceof DebugVariableInfo) {
                    if (this.declaredClassInfo != null) {
                        if (this.declaredClassInfo.isPrimitive()) {
                            this.setIcon(DataPanel.maS$getPrimitiveIconGray());
                        } else if (this.declaredClassInfo.isArray()) {
                            this.setIcon(DataPanel.maS$getArrayIconGray());
                        } else {
                            this.setIcon(DataPanel.maS$getObjectIconGray());
                        }
                    } else {
                        this.setIcon(DataPanel.maS$getObjectIconGray());
                    }
                } else if (this.actualClassInfo != null && !(info instanceof DebugHeapAncestor)) {
                    if (this.actualClassInfo.isPrimitive()) {
                        this.setIcon(DataPanel.getPrimitiveIcon());
                    } else if (this.actualClassInfo.isArray()) {
                        this.setIcon(DataPanel.getArrayIcon());
                    } else {
                        Icon objectIcon = DataPanel.ra$objectPreferences(DataPanel.this).getIcon(this.actualClassInfo.getName());
                        if (objectIcon != null) {
                            this.setIcon(objectIcon);
                        } else {
                            this.setIcon(DataPanel.getObjectIcon());
                        }
                    }
                }
            }
            if (this.data instanceof DebugDataArrayInfo) {
                this.arrayRange = DataPanel.mav$getArrayRange(DataPanel.this, (DebugDataArrayInfo)this.data);
            }
        }

        void clearDataForItem() {
            this.info = null;
            this.data = null;
            this.declaredClassInfo = null;
            this.actualClassInfo = null;
            this.ancestorHeapInfo = null;
            this.arrayRange = null;
        }

        void clearCacheForColumn(int column) {
            switch (column) {
                case -1: {
                    this.cachedMayHaveChildren = null;
                    this.cachedDisplayName = null;
                    this.cachedActualType = null;
                    this.cachedDeclaredType = null;
                    this.cachedValue = null;
                    this.cachedHexValue = null;
                    this.cachedAddress = null;
                    this.cachedID = null;
                    break;
                }
                case 0: {
                    this.cachedMayHaveChildren = null;
                    this.cachedDisplayName = null;
                    break;
                }
                case 2: {
                    this.cachedActualType = null;
                    break;
                }
                case 3: {
                    this.cachedDeclaredType = null;
                    break;
                }
                case 1: {
                    this.cachedValue = null;
                    break;
                }
                case 4: {
                    this.cachedHexValue = null;
                    break;
                }
                case 5: {
                    this.cachedAddress = null;
                    break;
                }
                case 6: {
                    this.cachedID = null;
                    break;
                }
            }
        }

        public Object getInfo() {
            return this.info;
        }

        public DebugDataInfo getDataInfo() {
            return this.data;
        }

        protected Font getFont(int column) {
            if (column == 0) {
                if (DataPanel.this.ancestorDepthZeroFont != null && this.ancestorDepth == 0 && !this.isDebugHeapAncestor) {
                    return DataPanel.this.ancestorDepthZeroFont;
                }
                if (DataPanel.this.heapAncestorOutsideHeapFont != null && this.isDebugHeapAncestorOutsideHeap) {
                    return DataPanel.this.heapAncestorOutsideHeapFont;
                }
            }
            return DataPanel.this.getNormalFont();
        }

        private boolean isUnrelated() {
            return this.ancestorHeapInfo != null && this.ancestorDepth == -1;
        }

        String getToolTip(int column, TreePath treePath) {
            String tooltip = null;
            switch (column) {
                default: {
                    tooltip = (String)this.getValueOfColumn(column);
                    break;
                }
                case 0: {
                    tooltip = this.makeNameToolTip(treePath);
                    if (tooltip != null && tooltip.length() != 0) break;
                    tooltip = this.displayName;
                    break;
                }
                case 1: {
                    tooltip = (String)this.getValueOfColumn(column);
                    String valueExpressionUsed = this.getValueExpressionUsed();
                    if (valueExpressionUsed == null) break;
                    tooltip = DbgArb.format(57, valueExpressionUsed, tooltip);
                    break;
                }
                case 2: {
                    tooltip = this.getActualType(true, true);
                    break;
                }
                case 3: {
                    if (this.declaredClassInfo == null) break;
                    tooltip = DataPanel.makeType(null, this.declaredClassInfo, true, this.info);
                    break;
                }
            }
            if (tooltip != null && tooltip.length() > 0) {
                return tooltip;
            }
            return null;
        }

        @Override
        public String getShortLabel() {
            return this.getDisplayName();
        }

        @Override
        public Object getData() {
            return this;
        }

        private boolean hasExpired() {
            if (this.data != null) {
                return this.data.hasExpired();
            }
            if (this.info instanceof DebugHasExpired) {
                return ((DebugHasExpired)this.info).hasExpired();
            }
            return false;
        }

        @Override
        public boolean mayHaveChildren() {
            if (this.hasExpired()) {
                return false;
            }
            if (this.cachedMayHaveChildren == null && DataPanel.ra$canUpdateData(DataPanel.this)) {
                this.cachedMayHaveChildren = this.ancestorDepth == 0 && !(this.info instanceof DebugHeapAncestor) && DataPanel.this.dataPanelSettings.isHideUnrelated() ? Boolean.FALSE : (this.data instanceof DebugDataCompositeInfo ? (((DebugDataCompositeInfo)this.data).isNull() ? Boolean.FALSE : (Product.isRaptor() && this.actualClassInfo != null && this.actualClassInfo.getName().startsWith("$Oracle.Builtin.") ? Boolean.FALSE : Boolean.TRUE)) : (this.info instanceof DebugClassInfo ? Boolean.TRUE : (this.info instanceof DebugHeapSubset ? Boolean.FALSE : (this.info instanceof DebugHeapInfo ? Boolean.TRUE : (this.info instanceof DebugHeapAncestor ? Boolean.TRUE : (this.info instanceof DebugAnnotationInfo ? Boolean.TRUE : Boolean.FALSE))))));
            }
            if (this.cachedMayHaveChildren != null) {
                return this.cachedMayHaveChildren;
            }
            return false;
        }

        @Override
        public Iterator getChildren() {
            return Arrays.asList(this.getChildNodes()).iterator();
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return DataPanel.ra$transferFlavors();
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            int length = DataPanel.ra$transferFlavors().length;
            int i = 0;
            while (i < length) {
                if (flavor.equals(DataPanel.ra$transferFlavors()[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (flavor.equals(DataPanel.getExpressionFlavor())) {
                Expression expression = this.makeExpression(null);
                if (expression != null) {
                    return expression;
                }
            } else if (flavor.equals(DataPanel.getHeapObjectFlavor()) && this.getAddressOfObject() != 0L) {
                return this.data;
            }
            if (flavor.equals(DataFlavor.stringFlavor)) {
                return this.getShortLabel();
            }
            throw new UnsupportedFlavorException(flavor);
        }

        protected Object getValueOfColumn(int column) {
            switch (column) {
                case 0: {
                    return this.getDisplayName();
                }
                case 2: {
                    return this.getActualType();
                }
                case 3: {
                    return this.getDeclaredType();
                }
                case 1: {
                    return this.getValue();
                }
                case 4: {
                    return this.getHexValue();
                }
                case 5: {
                    return this.getAddress();
                }
                case 6: {
                    return this.getID();
                }
            }
            return DataPanel.NOT_AVAILABLE;
        }

        String getExpressionPart() {
            return this.expressionPart;
        }

        String getDisplayName() {
            if (this.cachedDisplayName == null && DataPanel.ra$canUpdateData(DataPanel.this)) {
                this.cachedDisplayName = this.displayName != null ? this.displayName : DataPanel.makeDisplayName(this.info, DataPanel.this.dataPanelSettings.isShowPackages());
            }
            if (this.cachedDisplayName != null) {
                return this.cachedDisplayName;
            }
            return DataPanel.NOT_AVAILABLE;
        }

        void setDisplayName(String displayName) {
            this.displayName = displayName;
            this.cachedDisplayName = null;
        }

        String getActualType() {
            return this.getActualType(false, false);
        }

        String getActualType(boolean ignoreCached, boolean showPackage) {
            if (ignoreCached) {
                return this.getTheActualType(showPackage);
            }
            if (this.cachedActualType == null && DataPanel.ra$canUpdateData(DataPanel.this)) {
                this.cachedActualType = this.displayType != null ? this.displayType : this.getTheActualType(showPackage);
            }
            if (this.cachedActualType != null) {
                return this.cachedActualType;
            }
            return DataPanel.NOT_AVAILABLE;
        }

        String getFullyQualifiedActualType() {
            if (this.cachedFullyQualifiedActualType == null && DataPanel.ra$canUpdateData(DataPanel.this)) {
                this.cachedFullyQualifiedActualType = this.getTheActualType(true);
            }
            if (this.cachedFullyQualifiedActualType != null) {
                return this.cachedFullyQualifiedActualType;
            }
            return DataPanel.NOT_AVAILABLE;
        }

        private String getTheActualType(boolean showPackage) {
            String fullType;
            String actualType = null;
            if (this.info != null && this.info instanceof DebugVariableInfo && ((DebugVariableInfo)this.info).getGenericSignature() != null) {
                String fullType2 = GenericSignature.processGenericSignature(((DebugVariableInfo)this.info).getGenericSignature(), true);
                if (fullType2 != null) {
                    String typeParams = null;
                    int lessIndex = fullType2.indexOf(60);
                    if (lessIndex != -1) {
                        typeParams = fullType2.substring(lessIndex);
                    }
                    actualType = DataPanel.makeType(((DebugVariableInfo)this.info).getDataInfo(), this.actualClassInfo, showPackage || DataPanel.this.dataPanelSettings.isShowPackages(), typeParams);
                }
            } else if (this.info != null && this.info instanceof DebugFieldInfo && ((DebugFieldInfo)this.info).getGenericSignature() != null && (fullType = GenericSignature.processGenericSignature(((DebugFieldInfo)this.info).getGenericSignature(), showPackage || DataPanel.this.dataPanelSettings.isShowPackages())) != null) {
                String typeParams = null;
                int lessIndex = fullType.indexOf(60);
                if (lessIndex != -1) {
                    typeParams = fullType.substring(lessIndex);
                }
                actualType = DataPanel.makeType(((DebugFieldInfo)this.info).getDataInfo(), this.actualClassInfo, showPackage || DataPanel.this.dataPanelSettings.isShowPackages(), typeParams);
            }
            if (actualType == null) {
                actualType = DataPanel.makeType(this.data, this.actualClassInfo, showPackage || DataPanel.this.dataPanelSettings.isShowPackages());
            }
            return actualType;
        }

        String getDeclaredType() {
            if (this.cachedDeclaredType == null && DataPanel.ra$canUpdateData(DataPanel.this)) {
                this.cachedDeclaredType = DataPanel.makeType(null, this.declaredClassInfo, DataPanel.this.dataPanelSettings.isShowPackages(), this.info);
            }
            if (this.cachedDeclaredType != null) {
                return this.cachedDeclaredType;
            }
            return DataPanel.NOT_AVAILABLE;
        }

        String getFullyQualifiedDeclaredType() {
            if (this.cachedFullyQualifiedDeclaredType == null && DataPanel.ra$canUpdateData(DataPanel.this)) {
                this.cachedFullyQualifiedDeclaredType = DataPanel.makeType(null, this.declaredClassInfo, true, this.info);
            }
            if (this.cachedFullyQualifiedDeclaredType != null) {
                return this.cachedFullyQualifiedDeclaredType;
            }
            return DataPanel.NOT_AVAILABLE;
        }

        String getValue() {
            return this.getValue(true, true);
        }

        String getValue(boolean useCached, boolean getExtendedValue) {
            if (!useCached) {
                String[] expressionUsed = new String[1];
                return DataPanel.makeDataValue(this.info, this.data, expressionUsed, getExtendedValue);
            }
            if (this.cachedValue == null && DataPanel.ra$canUpdateData(DataPanel.this)) {
                this.cachedValueExpressionUsed = null;
                if (this.displayValue != null) {
                    this.cachedValue = this.displayValue;
                } else {
                    String[] expressionUsed = new String[1];
                    this.cachedValue = DataPanel.makeDataValue(this.info, this.data, expressionUsed, getExtendedValue);
                    if (expressionUsed[0] != null) {
                        this.cachedValueExpressionUsed = expressionUsed[0];
                    }
                }
            }
            if (this.cachedValue != null) {
                return this.cachedValue;
            }
            return DataPanel.NOT_AVAILABLE;
        }

        String getValueExpressionUsed() {
            return this.cachedValueExpressionUsed;
        }

        String getHexValue() {
            if (this.cachedHexValue == null && DataPanel.ra$canUpdateData(DataPanel.this)) {
                this.cachedHexValue = DataPanel.makeHexValue(this.info, this.data);
            }
            if (this.cachedHexValue != null) {
                return this.cachedHexValue;
            }
            return DataPanel.NOT_AVAILABLE;
        }

        String getAddress() {
            if (this.cachedAddress == null && DataPanel.ra$canUpdateData(DataPanel.this)) {
                this.cachedAddress = DataPanel.NOT_AVAILABLE;
                long address = this.getAddressOfObject();
                if (address != 0L) {
                    this.cachedAddress = "0x" + Long.toHexString(address).toUpperCase();
                }
            }
            if (this.cachedAddress != null) {
                return this.cachedAddress;
            }
            return DataPanel.NOT_AVAILABLE;
        }

        String getID() {
            if (this.cachedID == null && DataPanel.ra$canUpdateData(DataPanel.this)) {
                long id;
                this.cachedID = DataPanel.NOT_AVAILABLE;
                if (this.data instanceof DebugDataCompositeInfo && (id = ((DebugDataCompositeInfo)this.data).getUniqueID()) != 0L) {
                    this.cachedID = Long.toString(id);
                }
            }
            if (this.cachedID != null) {
                return this.cachedID;
            }
            return DataPanel.NOT_AVAILABLE;
        }

        public Iterator getLazyChildren() {
            if (this.children != null) {
                return Arrays.asList(this.children).iterator();
            }
            return Arrays.asList(new Object[0]).iterator();
        }

        int countChildNodes() {
            return this.getChildNodes().length;
        }

        DataItem[] getChildNodes() {
            if (this.hasExpired()) {
                return new DataItem[0];
            }
            if (this.children == null) {
                if (this.parentDataItem != null && !this.parentDataItem.isExpanded) {
                    return new DataItem[0];
                }
                if (this.data instanceof DebugDataObjectInfo) {
                    this.children = DataPanel.mav$makeDataItemsForObject(DataPanel.this, this, (DebugDataObjectInfo)this.data);
                } else if (this.data instanceof DebugDataArrayInfo) {
                    this.children = DataPanel.mav$makeDataItemsForArray(DataPanel.this, this, (DebugDataArrayInfo)this.data, this.arrayRange);
                } else if (this.info instanceof DebugClassInfo) {
                    this.children = DataPanel.mav$makeDataItemsForClass(DataPanel.this, this, (DebugClassInfo)this.info);
                } else if (this.info instanceof DebugHeapSubset) {
                    this.children = new DataItem[0];
                } else if (this.info instanceof DebugHeapInfo) {
                    this.children = DataPanel.mav$makeDataItemsForHeapInfo(DataPanel.this, this, (DebugHeapInfo)this.info);
                } else if (this.info instanceof DebugHeapAncestor) {
                    this.children = DataPanel.mav$makeDataItemsForHeapAncestor(DataPanel.this, this, (DebugHeapAncestor)this.info);
                } else if (this.info instanceof DebugAnnotationInfo) {
                    this.children = DataPanel.mav$makeDataItemsForAnnotation(DataPanel.this, this, (DebugAnnotationInfo)this.info);
                }
                if (this.children == null) {
                    this.children = new DataItem[0];
                }
                int i = 0;
                while (i < this.children.length) {
                    this.children[i].parentDataItem = this;
                    ++i;
                }
            }
            return this.children;
        }

        DataItem getField(String name) {
            DebugFieldInfo field;
            if (this.data instanceof DebugDataObjectInfo && (field = ((DebugDataObjectInfo)this.data).getField(name)) != null) {
                return new DataItem(field);
            }
            return null;
        }

        List<DataItem> getFields() {
            if (this.cachedFields == null) {
                this.cachedFields = this.getFields(-1);
            }
            return this.cachedFields;
        }

        List<DataItem> getDeclaredFields() {
            if (this.cachedDeclaredFields == null) {
                this.cachedDeclaredFields = this.getFields(0);
            }
            return this.cachedDeclaredFields;
        }

        private List<DataItem> getFields(int level) {
            if (this.data instanceof DebugDataObjectInfo) {
                DebugFieldInfo[] fields = ((DebugDataObjectInfo)this.data).getFields(level);
                ArrayList<DataItem> list = new ArrayList<DataItem>(fields.length);
                int i = 0;
                while (i < fields.length) {
                    list.add(new DataItem(fields[i]));
                    ++i;
                }
                return list;
            }
            return null;
        }

        void clearChildren(TreePath treePath) {
            if (DataPanel.this.model != null) {
                DataPanel.this.model.saveHighlight();
                this.children = null;
                DataPanel.this.model.fireChanged(treePath);
                DataPanel.this.model.restoreHighlight(false);
            } else {
                this.children = null;
            }
        }

        boolean canViewWhole() {
            return this.data instanceof DebugDataCompositeInfo && ((DebugDataCompositeInfo)this.data).canGetWholeThing();
        }

        void viewWhole() {
            if (this.data instanceof DebugDataCompositeInfo) {
                DebugDataCompositeInfo dci = (DebugDataCompositeInfo)this.data;
                String dlgTitle = DbgArb.getString(326);
                MemoViewDialog.showMemoViewDialog(dlgTitle, this.getActualType(), this.getDisplayName(), dci);
            }
        }

        String canViewAnnotations() {
            if (this.info instanceof DebugHasAnnotations && ((DebugHasAnnotations)this.info).countAnnotations() > 0) {
                if (this.info instanceof DebugFieldInfo) {
                    return DbgArb.getString(114);
                }
                if (this.info instanceof DebugVariableInfo) {
                    return DbgArb.getString(307);
                }
            }
            return null;
        }

        void viewAnnotations() {
            if ((this.info instanceof DebugFieldInfo || this.info instanceof DebugVariableInfo) && this.info instanceof DebugHasAnnotations) {
                DebugAnnotationInfo[] annotations = ((DebugHasAnnotations)this.info).getAnnotations();
                String type = this.getDeclaredType();
                String name = this.getDisplayName();
                String dlgTitle = this.info instanceof DebugFieldInfo ? DbgArb.format(793, type, name) : DbgArb.format(392, type, name);
                DataPanel.showAnnotationsDialog(dlgTitle, DataPanel.this.dataPanelSettings, DataPanel.this.debuggingProcess, DataPanel.this.vm, DataPanel.this.thread, DataPanel.this.frame, annotations);
            }
        }

        boolean canViewAnnotationsForClass() {
            return this.actualClassInfo instanceof DebugHasAnnotations && ((DebugHasAnnotations)((Object)this.actualClassInfo)).countAnnotations() > 0;
        }

        void viewAnnotationsForClass() {
            if (this.actualClassInfo instanceof DebugHasAnnotations) {
                DebugAnnotationInfo[] annotations = ((DebugHasAnnotations)((Object)this.actualClassInfo)).getAnnotations();
                String className = this.actualClassInfo.getName();
                String dlgTitle = DbgArb.format(184, className);
                DataPanel.showAnnotationsDialog(dlgTitle, DataPanel.this.dataPanelSettings, DataPanel.this.debuggingProcess, DataPanel.this.vm, DataPanel.this.thread, DataPanel.this.frame, annotations);
            }
        }

        boolean canAdjustRange() {
            return this.ancestorHeapInfo == null && this.data instanceof DebugDataArrayInfo;
        }

        void adjustRange(TreePath treePath) {
            DebugDataArrayInfo array = (DebugDataArrayInfo)this.data;
            int start = array.getArrayStart();
            int count = array.getArrayCount();
            AdjustRangeDialog dialog = AdjustRangeDialog.showAdjustRangeDialog(this.getActualType(), this.getDisplayName(), start, count, this.arrayRange.getStart(), this.arrayRange.getCount());
            if (dialog != null) {
                this.arrayRange.setStart(dialog.getStart());
                this.arrayRange.setCount(dialog.getCount());
                DataPanel.ra$arrayRanges(DataPanel.this).put(array, this.arrayRange);
                this.clearChildren(treePath);
            }
        }

        boolean canToggleValue() {
            return this.data != null && this.actualClassInfo.isPrimitive() && this.actualClassInfo.getName().equals("boolean") && this.data.canModifyDataWithString();
        }

        void toggleValue() {
            String currentValue = this.getValue();
            String newValue = new Boolean(Boolean.valueOf(currentValue) ^ true).toString();
            if (ModifyValueDialog.toggleValue(this.data, newValue)) {
                JDebugger.getInstance().dataHasBeenModified();
            }
        }

        boolean canModifyValue() {
            if (!this.canToggleValue() && this.data != null) {
                boolean canModifyDataWithString = this.data.canModifyDataWithString();
                boolean canSetAddressOfObject = false;
                boolean canSetAddressOfObjectToNull = false;
                if (this.data instanceof DebugDataCompositeInfo) {
                    DebugDataCompositeInfo dci = (DebugDataCompositeInfo)this.data;
                    canSetAddressOfObject = dci.canSetAddressOfObject();
                    canSetAddressOfObjectToNull = dci.canSetAddressOfObjectToNull();
                }
                if (canModifyDataWithString || canSetAddressOfObject || canSetAddressOfObjectToNull) {
                    return true;
                }
            }
            return false;
        }

        void modifyValue() {
            if (this.data != null) {
                boolean canModifyDataWithString = this.data.canModifyDataWithString();
                boolean canSetAddressOfObject = false;
                boolean canSetAddressOfObjectToNull = false;
                if (this.data instanceof DebugDataCompositeInfo) {
                    DebugDataCompositeInfo dci = (DebugDataCompositeInfo)this.data;
                    canSetAddressOfObject = dci.canSetAddressOfObject();
                    canSetAddressOfObjectToNull = dci.canSetAddressOfObjectToNull();
                }
                if (canModifyDataWithString || canSetAddressOfObject || canSetAddressOfObjectToNull) {
                    boolean ok;
                    String hex;
                    String currentValue = this.getValue(false, false);
                    if (currentValue.startsWith("\"") && currentValue.endsWith("\"")) {
                        currentValue = currentValue.substring(1, currentValue.length() - 1);
                    }
                    if (DataPanel.ra$columnShowing(DataPanel.this)[4] && (hex = this.getHexValue()) != null && hex.length() > 0) {
                        currentValue = currentValue + "    " + hex;
                    }
                    String currentAddress = null;
                    if (DataPanel.this.vm != null && DataPanel.this.vm.getCapabilities().canGetAddresses()) {
                        currentAddress = this.getAddress();
                    }
                    if (ok = ModifyValueDialog.showModifyValueDialog(this.getDeclaredType(), this.getDisplayName(), currentValue, currentAddress, this.actualClassInfo, this.data, canModifyDataWithString, canSetAddressOfObject, canSetAddressOfObjectToNull)) {
                        JDebugger.getInstance().dataHasBeenModified();
                    }
                }
            }
        }

        DataFlavor[] canDrag(TreePath treePath) {
            ArrayList<DataFlavor> temp = new ArrayList<DataFlavor>();
            if (this.canWatchAndInspect(treePath)) {
                temp.add(DataPanel.getExpressionFlavor());
            }
            if (this.getAddressOfObject() != 0L) {
                temp.add(DataPanel.getHeapObjectFlavor());
            }
            if (temp.size() > 0) {
                temp.add(DataFlavor.stringFlavor);
                return temp.toArray(new DataFlavor[temp.size()]);
            }
            return null;
        }

        boolean canDiagram(TreePath treePath) {
            return this.data instanceof DebugDataCompositeInfo;
        }

        boolean canWatchAndInspect(TreePath treePath) {
            if (this.data == null && this.info instanceof DebugVariableInfo) {
                return false;
            }
            return this.makeExpression(treePath) != null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String makeNameToolTip(TreePath treePath) {
            if (treePath == null) return null;
            String expression = DataPanel.NOT_AVAILABLE;
            Object[] path = treePath.getPath();
            int pathLength = path.length;
            int i = 0;
            while (i < pathLength) {
                Object node = path[i];
                if (node instanceof DataItem) {
                    DataItem dataItem = (DataItem)node;
                    Object dataItemInfo = dataItem.getInfo();
                    if (dataItemInfo instanceof DebugVariableInfo || dataItemInfo instanceof DebugStackSlotInfo) {
                        expression = expression + dataItem.getExpressionPart();
                    } else if (dataItemInfo instanceof DebugClassInfo) {
                        expression = expression + DebugShared.makeCourtesyClassName((DebugClassInfo)dataItemInfo, true);
                    } else if (dataItemInfo instanceof DebugArrayElementInfo) {
                        expression = this.displayNameOverridden ? expression + dataItem.getDisplayName() : expression + dataItem.getExpressionPart();
                    } else if (dataItemInfo instanceof DebugFieldInfo) {
                        if (expression.length() > 0) {
                            expression = expression + ".";
                        }
                        expression = this.displayNameOverridden ? expression + dataItem.getDisplayName() : expression + dataItem.getExpressionPart();
                    } else if (dataItemInfo instanceof DebugDataInfo) {
                        String s = dataItem.getExpressionPart();
                        if (s == null) return null;
                        expression = expression + s;
                    } else {
                        if (!(dataItemInfo instanceof EvaluationInfo)) return null;
                        if (pathLength == 2 && i == 1) {
                            expression = dataItem.getExpressionPart();
                        }
                    }
                }
                ++i;
            }
            if (expression == null || expression.length() <= 0) return null;
            return expression;
        }

        private Expression makeExpression(TreePath treePath) {
            if (this.expressionSaved == null && treePath != null) {
                Expression expression = new Expression(DataPanel.NOT_AVAILABLE);
                Object[] path = treePath.getPath();
                int pathLength = path.length;
                int i = 0;
                while (i < pathLength) {
                    DataItem dataItem;
                    Object node = path[i];
                    if (node instanceof DataItem && !(dataItem = (DataItem)node).prepareExpression(path, i, expression)) {
                        return null;
                    }
                    ++i;
                }
                if (expression != null && expression.getExpression().length() > 0) {
                    this.expressionSaved = expression;
                }
            }
            return this.expressionSaved;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected boolean prepareExpression(Object[] path, int i, Expression expression) {
            String exp = expression.getExpression();
            String name = expression.getName();
            String add = null;
            String addName = null;
            if (this.info instanceof DebugVariableInfo || this.info instanceof DebugStackSlotInfo || this.info instanceof DebugArrayElementInfo) {
                add = this.getExpressionPart();
            } else if (this.info instanceof DebugClassInfo) {
                add = this.getExpressionPart();
                addName = DebugShared.makeCourtesyClassName((DebugClassInfo)this.info, true);
            } else if (this.info instanceof DebugDataInfo) {
                String s = this.getExpressionPart();
                if (s == null) return false;
                add = s;
            } else if (this.info instanceof DebugFieldInfo) {
                add = exp.length() > 0 ? "." + this.getExpressionPart() : this.getExpressionPart();
            } else {
                if (!(this.info instanceof EvaluationInfo) && !(this.info instanceof EvaluatorItem)) return false;
                if (path.length == 2 && i == 1) {
                    add = this.getExpressionPart();
                }
            }
            if (add == null) return true;
            expression.setExpression(exp + add);
            if (name != null) {
                if (addName != null) {
                    expression.setName(name + addName);
                    return true;
                } else {
                    expression.setName(name + add);
                }
                return true;
            } else {
                if (addName == null) return true;
                expression.setName(addName);
            }
            return true;
        }

        void watch(TreePath treePath) {
            this.watch(treePath, null);
        }

        void watch(TreePath treePath, String displayName) {
            Expression expression = this.makeExpression(treePath);
            if (expression != null) {
                if (displayName != null) {
                    expression.setName(displayName);
                }
                EvaluatorItem ei = new EvaluatorItem(expression);
                JDebugger.getInstance().addWatch(ei);
            }
        }

        void inspect(TreePath treePath) {
            this.inspect(treePath, null);
        }

        void inspect(TreePath treePath, String displayName) {
            Expression expression = this.makeExpression(treePath);
            if (expression != null) {
                if (displayName != null) {
                    expression.setName(displayName);
                }
                EvaluatorItem ei = new EvaluatorItem(expression);
                JDebugger.getInstance().inspect(ei);
            }
        }

        boolean canWatchInspectClassLoader() {
            DebugDataObjectInfo classLoaderObject;
            DebugClassLoaderInfo classLoader;
            return this.actualClassInfo != null && (classLoader = this.actualClassInfo.getClassLoader()) != null && (classLoaderObject = classLoader.getClassLoaderObject()) != null && !classLoaderObject.isNull();
        }

        void watchClassLoader() {
            DebugDataObjectInfo classLoaderObject;
            DebugClassLoaderInfo classLoader;
            if (this.actualClassInfo != null && (classLoader = this.actualClassInfo.getClassLoader()) != null && (classLoaderObject = classLoader.getClassLoaderObject()) != null && !classLoaderObject.isNull()) {
                String name = ClassesWindow.makeClassLoaderName(classLoader);
                EvaluatorItem ei = DataPanel.this.debuggingProcess.makeTemporaryEvaluatorItem(name, classLoaderObject);
                JDebugger.getInstance().addWatch(ei);
            }
        }

        void inspectClassLoader() {
            DebugDataObjectInfo classLoaderObject;
            DebugClassLoaderInfo classLoader;
            if (this.actualClassInfo != null && (classLoader = this.actualClassInfo.getClassLoader()) != null && (classLoaderObject = classLoader.getClassLoaderObject()) != null && !classLoaderObject.isNull()) {
                String name = ClassesWindow.makeClassLoaderName(classLoader);
                EvaluatorItem ei = DataPanel.this.debuggingProcess.makeTemporaryEvaluatorItem(name, classLoaderObject);
                JDebugger.getInstance().inspect(ei);
            }
        }

        String canShowSource(int cmdId) {
            String sourceFilename;
            DebugClassInfo clazz = null;
            String name = null;
            if (cmdId == DataPanel.this._GOTO_CMD_ID) {
                if (this.actualClassInfo != null) {
                    clazz = this.actualClassInfo;
                    name = DbgArb.format(388, this.getActualType());
                }
            } else if (cmdId == DataPanel.this._GOTO_DECLARED_CMD_ID) {
                if (DataPanel.ra$columnShowing(DataPanel.this)[3] && this.declaredClassInfo != null && this.declaredClassInfo != this.actualClassInfo) {
                    clazz = this.declaredClassInfo;
                    name = DbgArb.format(850, this.getDeclaredType());
                }
            } else if (cmdId == DataPanel.this._GOTO_FIELD_CMD_ID) {
                DebugFieldInfo field = null;
                if (this.info instanceof DebugFieldInfo) {
                    field = (DebugFieldInfo)this.info;
                } else if (this.info instanceof DebugHeapAncestorInStatic) {
                    field = ((DebugHeapAncestorInStatic)this.info).getFieldInfo();
                }
                if (field != null) {
                    clazz = field.getDeclaringClassInfo();
                    String className = DataPanel.makeType(null, clazz, DataPanel.this.dataPanelSettings.isShowPackages());
                    name = DbgArb.format(615, className + "." + field.getName());
                }
            }
            if (clazz != null && (sourceFilename = clazz.getPrimarySourceFilename()) != null && sourceFilename.length() > 0) {
                return name;
            }
            return null;
        }

        void showSource(int cmdId) {
            if (cmdId == DataPanel.this._GOTO_CMD_ID || cmdId == DataPanel.this._GOTO_DECLARED_CMD_ID) {
                DebugClassInfo clazz = null;
                if (cmdId == DataPanel.this._GOTO_CMD_ID) {
                    clazz = this.actualClassInfo;
                } else if (cmdId == DataPanel.this._GOTO_DECLARED_CMD_ID) {
                    clazz = this.declaredClassInfo;
                }
                if (clazz != null) {
                    DataPanel.this.debuggingProcess.showSourceFile(clazz);
                }
            } else if (cmdId == DataPanel.this._GOTO_FIELD_CMD_ID) {
                DebugFieldInfo field = null;
                if (this.info instanceof DebugFieldInfo) {
                    field = (DebugFieldInfo)this.info;
                } else if (this.info instanceof DebugHeapAncestorInStatic) {
                    field = ((DebugHeapAncestorInStatic)this.info).getFieldInfo();
                }
                if (field != null) {
                    DataPanel.this.debuggingProcess.showSourceFile(field);
                }
            }
        }

        long getAddressOfObject() {
            if (this.data instanceof DebugDataCompositeInfo) {
                DebugDataCompositeInfo dci = (DebugDataCompositeInfo)this.data;
                return dci.getAddressOfObject();
            }
            return 0L;
        }

        private String getEnumValueDisplayName(DebugDataInfo data) {
            if (data == null) {
                return this.displayValue;
            }
            DebugFieldInfo[] fields = this.actualClassInfo.getEnumConstants();
            if (fields != null) {
                int i = 0;
                while (i < fields.length) {
                    DebugDataInfo ddi;
                    if (fields[i] != null && (ddi = fields[i].getDataInfo()) != null && ddi.hashCode() == data.hashCode()) {
                        return fields[i].getName();
                    }
                    ++i;
                }
            }
            return this.displayValue;
        }

        static boolean mav$isUnrelated(DataItem dataItem) {
            return dataItem.isUnrelated();
        }
    }

    private final class DataInfoPath {
        private DebuggingProcess debuggingProcess;
        private List list;

        DataInfoPath(DebuggingProcess debuggingProcess, Object[] dataInfoArray) {
            this.debuggingProcess = debuggingProcess;
            this.list = Arrays.asList(dataInfoArray);
        }

        DebuggingProcess getDebuggingProcess() {
            return this.debuggingProcess;
        }

        int size() {
            return this.list.size();
        }

        Object getDataInfo(int index) {
            return this.list.get(index);
        }

        public int hashCode() {
            return this.debuggingProcess.hashCode() + this.list.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof DataInfoPath) {
                DataInfoPath other = (DataInfoPath)o;
                return this.debuggingProcess == other.debuggingProcess && this.list.equals(other.list);
            }
            return false;
        }
    }

    private final class DataArrayRange {
        private DebuggingProcess debuggingProcess;
        private int start;
        private int count;

        DataArrayRange(DebuggingProcess debuggingProcess, DebugDataArrayInfo array) {
            this.debuggingProcess = debuggingProcess;
            this.start = array.getArrayStart();
            this.count = array.getArrayCount();
            int max = DataPanel.maS$getDefaultArrayRangeMax();
            if (this.count == -1 || this.count > max) {
                this.count = max;
            }
        }

        DebuggingProcess getDebuggingProcess() {
            return this.debuggingProcess;
        }

        int getStart() {
            return this.start;
        }

        void setStart(int start) {
            this.start = start;
        }

        int getCount() {
            return this.count;
        }

        void setCount(int count) {
            this.count = count;
        }
    }
}

