/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Copyable;

public final class DataPanelSettings
extends HashStructureAdapter
implements Copyable {
    public static final String KEY_SETTINGS = "DataPanelOptions";
    private static final String SORT_FIELDS_BY_NAME = "sortFieldsByName";
    private static final String HIDE_STATIC_FIELDS = "hideStaticFields";
    private static final String HIDE_FINAL_FIELDS = "hideFinalFields";
    private static final String HIDE_NULL_ARRAY_ELEMENTS = "hideNullArrayElements";
    private final String SHOW_PACKAGES;
    private static final String COLUMN_VISIBLE = "columnVisible";
    private static final String COLUMN_WIDTH = "columnWidth";
    private static final String COLUMN_ORDER = "columnOrder";
    private static final String HIDE_UNRELATED = "hideUnrelated";
    private static final String SHOW_ONLY_ROOT_ANCESTORS = "showOnlyRootAncestors";
    private static final String HIDE_SYNTHETIC_FIELDS = "hideSyntheticFields";

    private DataPanelSettings(HashStructure hs) {
        super(hs);
        this.$init$();
    }

    public static DataPanelSettings getInstance(PropertyStorage ps) {
        return new DataPanelSettings(DataPanelSettings.findOrCreate((PropertyStorage)ps, (String)KEY_SETTINGS));
    }

    public static DataPanelSettings getInstance(HashStructure hs) {
        return new DataPanelSettings(hs);
    }

    public boolean isSortFieldsByName() {
        return this._hash.getBoolean(SORT_FIELDS_BY_NAME, false);
    }

    public void setSortFieldsByName(boolean sortFieldsByName) {
        this._hash.putBoolean(SORT_FIELDS_BY_NAME, sortFieldsByName);
    }

    public boolean isHideStaticFields() {
        return this._hash.getBoolean(HIDE_STATIC_FIELDS, true);
    }

    public void setHideStaticFields(boolean hideStaticFields) {
        this._hash.putBoolean(HIDE_STATIC_FIELDS, hideStaticFields);
    }

    public boolean isHideFinalFields() {
        return this._hash.getBoolean(HIDE_FINAL_FIELDS, false);
    }

    public void setHideFinalFields(boolean hideFinalFields) {
        this._hash.putBoolean(HIDE_FINAL_FIELDS, hideFinalFields);
    }

    public boolean isHideNullArrayElements() {
        return this._hash.getBoolean(HIDE_NULL_ARRAY_ELEMENTS, true);
    }

    public void setHideNullArrayElements(boolean hideNullArrayElements) {
        this._hash.putBoolean(HIDE_NULL_ARRAY_ELEMENTS, hideNullArrayElements);
    }

    private void $init$() {
        this.SHOW_PACKAGES = "showPackages";
    }

    public boolean isShowPackages() {
        return this._hash.getBoolean("showPackages", false);
    }

    public void setShowPackages(boolean showPackages) {
        this._hash.putBoolean("showPackages", showPackages);
    }

    boolean getColumnVisible(int columnIndex) {
        boolean defaultValue = columnIndex == 0 || columnIndex == 2 || columnIndex == 1;
        return this._hash.getBoolean(COLUMN_VISIBLE + columnIndex, defaultValue);
    }

    void setColumnVisible(int columnIndex, boolean columnVisible) {
        this._hash.putBoolean(COLUMN_VISIBLE + columnIndex, columnVisible);
    }

    int getColumnWidth(int columnIndex) {
        return this._hash.getInt(COLUMN_WIDTH + columnIndex, 0);
    }

    void setColumnWidth(int columnIndex, int columnWidth) {
        this._hash.putInt(COLUMN_WIDTH + columnIndex, columnWidth);
    }

    public String getColumnOrder() {
        return this._hash.getString(COLUMN_ORDER);
    }

    public void setColumnOrder(String columnOrder) {
        this._hash.putString(COLUMN_ORDER, columnOrder);
    }

    public boolean isHideUnrelated() {
        return this._hash.getBoolean(HIDE_UNRELATED, true);
    }

    public void setHideUnrelated(boolean hideUnrelated) {
        this._hash.putBoolean(HIDE_UNRELATED, hideUnrelated);
    }

    public boolean isShowOnlyRootAncestors() {
        return this._hash.getBoolean(SHOW_ONLY_ROOT_ANCESTORS, true);
    }

    public void setShowOnlyRootAncestors(boolean showOnlyRootAncestors) {
        this._hash.putBoolean(SHOW_ONLY_ROOT_ANCESTORS, showOnlyRootAncestors);
    }

    public boolean isHideSyntheticFields() {
        return this._hash.getBoolean(HIDE_SYNTHETIC_FIELDS, true);
    }

    public void setHideSyntheticFields(boolean hideSyntheticFields) {
        this._hash.putBoolean(HIDE_SYNTHETIC_FIELDS, hideSyntheticFields);
    }
}

