/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.DataPanelSettings;
import oracle.jdevimpl.runner.debug.DbgArb;

final class DataPanelSettingsPanel {
    private JCheckBox showColumnNameCheckBox;
    private JCheckBox showColumnValueCheckBox;
    private JCheckBox showColumnActualTypeCheckBox;
    private JCheckBox showColumnDeclaredTypeCheckBox;
    private JCheckBox showColumnHexValueCheckBox;
    private JCheckBox showColumnAddressCheckBox;
    private JCheckBox showColumnIDCheckBox;
    private JCheckBox sortFieldsByNameCheckBox;
    private JCheckBox showPackagesCheckBox;
    private JCheckBox hideStaticFieldsCheckBox;
    private JCheckBox hideFinalFieldsCheckBox;
    private JCheckBox hideNullArrayElementsCheckBox;
    private JCheckBox hideSyntheticFieldsCheckBox;

    private void $init$() {
        this.showColumnNameCheckBox = new JCheckBox();
        this.showColumnValueCheckBox = new JCheckBox();
        this.showColumnActualTypeCheckBox = new JCheckBox();
        this.showColumnDeclaredTypeCheckBox = new JCheckBox();
        this.showColumnHexValueCheckBox = new JCheckBox();
        this.showColumnAddressCheckBox = new JCheckBox();
        this.showColumnIDCheckBox = new JCheckBox();
        this.sortFieldsByNameCheckBox = new JCheckBox();
        this.showPackagesCheckBox = new JCheckBox();
        this.hideStaticFieldsCheckBox = new JCheckBox();
        this.hideFinalFieldsCheckBox = new JCheckBox();
        this.hideNullArrayElementsCheckBox = new JCheckBox();
        this.hideSyntheticFieldsCheckBox = new JCheckBox();
    }

    public DataPanelSettingsPanel() {
        this.$init$();
        ResourceUtils.resButton((AbstractButton)this.showColumnNameCheckBox, (String)DbgArb.getString(361));
        ResourceUtils.resButton((AbstractButton)this.showColumnValueCheckBox, (String)DbgArb.getString(72));
        ResourceUtils.resButton((AbstractButton)this.showColumnActualTypeCheckBox, (String)DbgArb.getString(751));
        ResourceUtils.resButton((AbstractButton)this.showColumnDeclaredTypeCheckBox, (String)DbgArb.getString(486));
        ResourceUtils.resButton((AbstractButton)this.showColumnHexValueCheckBox, (String)DbgArb.getString(456));
        ResourceUtils.resButton((AbstractButton)this.showColumnAddressCheckBox, (String)DbgArb.getString(500));
        ResourceUtils.resButton((AbstractButton)this.showColumnIDCheckBox, (String)DbgArb.getString(573));
        ResourceUtils.resButton((AbstractButton)this.sortFieldsByNameCheckBox, (String)DbgArb.getString(377));
        ResourceUtils.resButton((AbstractButton)this.showPackagesCheckBox, (String)DbgArb.getString(10));
        ResourceUtils.resButton((AbstractButton)this.hideStaticFieldsCheckBox, (String)DbgArb.getString(148));
        ResourceUtils.resButton((AbstractButton)this.hideFinalFieldsCheckBox, (String)DbgArb.getString(433));
        ResourceUtils.resButton((AbstractButton)this.hideNullArrayElementsCheckBox, (String)DbgArb.getString(946));
        ResourceUtils.resButton((AbstractButton)this.hideSyntheticFieldsCheckBox, (String)DbgArb.getString(807));
    }

    JPanel makeChooseColumnsPanel(Insets borderInsets) {
        JPanel panel = new JPanel(new GridLayout(0, 2, 0, 0));
        TitledBorder border = BorderFactory.createTitledBorder(RunMgrArb.getString(70));
        panel.setBorder(border);
        if (borderInsets != null) {
            Insets temp = border.getBorderInsets(panel);
            borderInsets.top = temp.top;
            borderInsets.left = temp.left;
            borderInsets.bottom = temp.bottom;
            borderInsets.right = temp.right;
        }
        panel.add(this.showColumnNameCheckBox);
        panel.add(new JLabel());
        panel.add(this.showColumnValueCheckBox);
        panel.add(this.showColumnHexValueCheckBox);
        panel.add(this.showColumnActualTypeCheckBox);
        panel.add(this.showColumnDeclaredTypeCheckBox);
        panel.add(this.showColumnAddressCheckBox);
        panel.add(this.showColumnIDCheckBox);
        return panel;
    }

    JPanel makeSortPanel(JCheckBox otherCheckBox) {
        JPanel panel = new JPanel(new GridLayout(0, 2, 0, 0));
        panel.setBorder(BorderFactory.createTitledBorder(DbgArb.getString(299)));
        panel.add(this.sortFieldsByNameCheckBox);
        if (otherCheckBox != null) {
            panel.add(otherCheckBox);
        }
        return panel;
    }

    JPanel makeShowPanel(JCheckBox otherCheckBox) {
        JPanel panel = new JPanel(new GridLayout(0, 2, 0, 0));
        panel.setBorder(BorderFactory.createTitledBorder(DbgArb.getString(715)));
        panel.add(this.showPackagesCheckBox);
        if (otherCheckBox != null) {
            panel.add(otherCheckBox);
        }
        return panel;
    }

    JPanel makeHidePanel(JCheckBox otherCheckBox) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(DbgArb.getString(802)));
        int y = 0;
        this.hideStaticFieldsCheckBox.setPreferredSize(new Dimension(0, this.hideStaticFieldsCheckBox.getPreferredSize().height));
        panel.add((Component)this.hideStaticFieldsCheckBox, new GridBagConstraints(0, y, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.hideFinalFieldsCheckBox.setPreferredSize(new Dimension(0, this.hideStaticFieldsCheckBox.getPreferredSize().height));
        panel.add((Component)this.hideFinalFieldsCheckBox, new GridBagConstraints(1, y++, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.hideNullArrayElementsCheckBox.setPreferredSize(new Dimension(0, this.hideStaticFieldsCheckBox.getPreferredSize().height));
        panel.add((Component)this.hideNullArrayElementsCheckBox, new GridBagConstraints(0, y, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.hideSyntheticFieldsCheckBox.setPreferredSize(new Dimension(0, this.hideStaticFieldsCheckBox.getPreferredSize().height));
        panel.add((Component)this.hideSyntheticFieldsCheckBox, new GridBagConstraints(1, y, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (otherCheckBox != null) {
            otherCheckBox.setPreferredSize(new Dimension(0, this.hideStaticFieldsCheckBox.getPreferredSize().height));
            panel.add((Component)otherCheckBox, new GridBagConstraints(0, ++y, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        return panel;
    }

    void onEntry(DataPanelSettings dataPanelSettings) {
        this.showColumnNameCheckBox.setSelected(true);
        this.showColumnNameCheckBox.setEnabled(false);
        this.showColumnValueCheckBox.setSelected(dataPanelSettings.getColumnVisible(1));
        this.showColumnActualTypeCheckBox.setSelected(dataPanelSettings.getColumnVisible(2));
        this.showColumnDeclaredTypeCheckBox.setSelected(dataPanelSettings.getColumnVisible(3));
        this.showColumnHexValueCheckBox.setSelected(dataPanelSettings.getColumnVisible(4));
        this.showColumnAddressCheckBox.setSelected(dataPanelSettings.getColumnVisible(5));
        this.showColumnIDCheckBox.setSelected(dataPanelSettings.getColumnVisible(6));
        this.sortFieldsByNameCheckBox.setSelected(dataPanelSettings.isSortFieldsByName());
        this.showPackagesCheckBox.setSelected(dataPanelSettings.isShowPackages());
        this.hideStaticFieldsCheckBox.setSelected(dataPanelSettings.isHideStaticFields());
        this.hideFinalFieldsCheckBox.setSelected(dataPanelSettings.isHideFinalFields());
        this.hideNullArrayElementsCheckBox.setSelected(dataPanelSettings.isHideNullArrayElements());
        this.hideSyntheticFieldsCheckBox.setSelected(dataPanelSettings.isHideSyntheticFields());
    }

    void onExit(DataPanelSettings dataPanelSettings) throws TraversalException {
        dataPanelSettings.setColumnVisible(0, true);
        dataPanelSettings.setColumnVisible(1, this.showColumnValueCheckBox.isSelected());
        dataPanelSettings.setColumnVisible(2, this.showColumnActualTypeCheckBox.isSelected());
        dataPanelSettings.setColumnVisible(3, this.showColumnDeclaredTypeCheckBox.isSelected());
        dataPanelSettings.setColumnVisible(4, this.showColumnHexValueCheckBox.isSelected());
        dataPanelSettings.setColumnVisible(5, this.showColumnAddressCheckBox.isSelected());
        dataPanelSettings.setColumnVisible(6, this.showColumnIDCheckBox.isSelected());
        dataPanelSettings.setSortFieldsByName(this.sortFieldsByNameCheckBox.isSelected());
        dataPanelSettings.setShowPackages(this.showPackagesCheckBox.isSelected());
        dataPanelSettings.setHideStaticFields(this.hideStaticFieldsCheckBox.isSelected());
        dataPanelSettings.setHideFinalFields(this.hideFinalFieldsCheckBox.isSelected());
        dataPanelSettings.setHideNullArrayElements(this.hideNullArrayElementsCheckBox.isSelected());
        dataPanelSettings.setHideSyntheticFields(this.hideSyntheticFieldsCheckBox.isSelected());
    }
}

