/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.dnd.DropTargetListener;
import java.util.EventObject;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.docking.Dockable;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DebugDockableFactory;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.DebuggerWindow;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.UpdateableDataWindow;

abstract class DataWindow
extends DebuggerWindow
implements UpdateableDataWindow {
    protected String title;
    protected String helpId;
    protected DataPanel dataPanel;
    private Component gui;

    DataWindow(String windowId, String title, String helpId) {
        super(windowId);
        this.title = title;
        this.helpId = helpId;
    }

    protected void setDataPanel(DataPanel dataPanel) {
        this.dataPanel = dataPanel;
    }

    void saveSettings() {
        this.dataPanel.saveSettings();
    }

    private void debugWindowSettingsChanged(DebugWindowSettings dbgSettings) {
        this.dataPanel.debugWindowSettingsChanged(dbgSettings);
    }

    void setUseFilters(boolean useFilters) {
        this.dataPanel.setUseFilters(useFilters);
    }

    public Component getGUI() {
        if (this.gui == null) {
            DebugWindowSettings dbgSettings = DebugWindowSettings.getInstance();
            this.gui = this.dataPanel.getGUI();
            this.dataPanel.loadSettings();
            this.debugWindowSettingsChanged(dbgSettings);
            this.dataPanel.dataPanelSettingsChanged(false);
            DebugDockableFactory.updateSiteGeometry((Dockable)this);
            this.everythingChanged();
            dbgSettings.addStructureChangeListener(new 1(this, dbgSettings));
        }
        return this.gui;
    }

    public ContextMenu getContextMenu() {
        return JDebugger.getInstance().getContextMenu();
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo(this.helpId);
    }

    public Controller getController() {
        return this.dataPanel;
    }

    public Context getContext(EventObject event) {
        return this.dataPanel.getContext(event);
    }

    public int getDefaultVisibility(Layout layout) {
        boolean visible = JDebugger.getInstance().canShowDebuggingWindows(layout);
        int ret = visible ? 1 : 0;
        return ret;
    }

    public String getTabName() {
        return this.title;
    }

    public String getTitleName() {
        return this.title;
    }

    public DropTargetListener getTabDropListener() {
        return this.dataPanel;
    }

    public void refresh() {
        this.everythingChanged();
    }

    public void shutDown() {
        this.saveSettings();
    }

    void everythingChanged() {
        this.dataPanel.everythingChanged();
    }

    public void updateData(DebuggingProcess debuggingProcess, DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo frame) {
        this.dataPanel.updateData(debuggingProcess, vm, thread, frame);
    }

    public void clearData() {
        this.dataPanel.clearData();
    }

    void processFinished(DebuggingProcess debuggingProcess) {
        this.dataPanel.processFinished(debuggingProcess);
    }

    static void mav$debugWindowSettingsChanged(DataWindow dataWindow, DebugWindowSettings debugWindowSettings) {
        dataWindow.debugWindowSettingsChanged(debugWindowSettings);
    }

    final class 1
    extends StructureChangeListener {
        private final /* synthetic */ DebugWindowSettings v$dbgSettings;
        final /* synthetic */ DataWindow this$0;

        public void structureValuesChanged(StructureChangeEvent e) {
            DataWindow.mav$debugWindowSettingsChanged(this.this$0, this.v$dbgSettings);
        }

        public 1(DataWindow dataWindow, DebugWindowSettings debugWindowSettings) {
            this.v$dbgSettings = debugWindowSettings;
            this.this$0 = dataWindow;
        }
    }
}

