/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.JComponent;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockableWindow;
import oracle.ide.docking.DockingParam;
import oracle.ide.docking.Site;
import oracle.ide.layout.ViewId;
import oracle.jdevimpl.runner.debug.JDebugger;

final class DebugDockableFactory
implements DockableFactory {
    private JDebugger jdebugger;

    public DebugDockableFactory(JDebugger jdebugger) {
        this.jdebugger = jdebugger;
        DockStation ds = DockStation.getDockStation();
        ds.registerDockableFactory("Debugger", (DockableFactory)this);
    }

    public void install() {
        this.jdebugger.installWindows();
    }

    public Dockable getDockable(ViewId viewId) {
        String strId = viewId.getId();
        return this.jdebugger.getOrCreateDebuggerWindow(strId);
    }

    void installWindow(DockableWindow dw, Dockable tabbedWith, int position) {
        switch (position) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                DockStation ds = DockStation.getDockStation();
                DockingParam dockingParam = new DockingParam();
                if (tabbedWith != null) {
                    dockingParam.setTabbedWith(tabbedWith);
                } else {
                    dockingParam.setPosition(position);
                }
                ds.dock((Dockable)dw, dockingParam);
                break;
            }
        }
    }

    void floatWindow(DockableWindow dw, Rectangle floatingPosition) {
        DockStation ds = DockStation.getDockStation();
        Point centerOfScreen = DebugDockableFactory.getCenterOfScreen((Dockable)dw);
        if (floatingPosition == null) {
            floatingPosition = new Rectangle(centerOfScreen.x, centerOfScreen.y, 400, 300);
        }
        DockingParam dockingParam = new DockingParam();
        dockingParam.setFloatingPosition(floatingPosition);
        ds.dock((Dockable)dw, dockingParam);
        ds.setDockableVisible((Dockable)dw, true);
        ds.activateDockable((Dockable)dw);
    }

    static void updateSiteGeometry(Dockable dockable) {
        JComponent component = dockable.getHostedComponent();
        if (component != null) {
            Dimension d = component.getPreferredSize();
            Site site = dockable.getSite();
            site.geometry.width = d.width;
            site.geometry.height = d.height;
        }
    }

    static Point getCenterOfScreen(Dockable dockable) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension d = toolkit.getScreenSize();
        Point pt = new Point(d.width / 2, d.height / 2);
        Site site = dockable.getSite();
        pt.x -= site.geometry.width / 2;
        pt.y -= site.geometry.height / 2;
        return pt;
    }
}

