/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.runner.Runner;
import oracle.ide.util.Assert;
import oracle.ide.view.View;
import oracle.ideri.util.Product;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.runner.RemoteConnectDialog;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugConnectArg;
import oracle.jdevimpl.debugger.support.DebugConnectionListener;
import oracle.jdevimpl.debugger.support.DebugConnector;
import oracle.jdevimpl.debugger.support.DebugFactory;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.BaseElement;
import oracle.jdevimpl.runner.debug.ContextBuilder;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugConfiguration;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.JDebugger;

final class DebuggingListener
extends BaseElement
implements DebugConnectionListener {
    private DebuggingProcess debuggingProcess;
    private boolean keepListening;
    private Workspace workspace;
    private Project project;
    private RunConfiguration runConfiguration;
    private DebugConfiguration debugConfiguration;
    private DebugConnector connector;
    private DebugConnectArg[] connectArgs;
    private String connectArgsLabel;

    DebuggingListener(DebuggingProcess debuggingProcess, boolean keepListening) {
        JDebugger.getInstance().makeDebuggingListenerActions();
        this.debuggingProcess = debuggingProcess;
        this.keepListening = keepListening;
        this.project = debuggingProcess.getProject();
        this.workspace = debuggingProcess.getWorkspace();
        this.runConfiguration = RunConfiguration.getInstance((PropertyStorage)this.project);
        this.debugConfiguration = DebugConfiguration.getInstance(this.runConfiguration);
        this.setIcon(DbgArb.getIcon(543));
    }

    boolean startListening() {
        return this.startListening(null);
    }

    boolean startListening(String listenPort) {
        this.connector = DebugFactory.newInstance(1);
        this.connectArgs = this.connector.getConnectArgs();
        int count = this.connectArgs.length;
        boolean errorOccurred = false;
        while (true) {
            if (this.runConfiguration.isRemoteDebuggingProfiling()) {
                boolean needDialog = this.debugConfiguration.isPromptForRemoteDebugging();
                int i = 0;
                while (i < count) {
                    DebugConnectArg connectArg = this.connectArgs[i];
                    String value = this.debugConfiguration.getRemoteParameterValue("jpdaListen", connectArg.getName());
                    if (value != null) {
                        connectArg.setValue(value);
                        if (value.length() == 0 && !connectArg.allowBlank()) {
                            needDialog = true;
                        }
                    } else {
                        needDialog = true;
                    }
                    ++i;
                }
                if (errorOccurred) {
                    needDialog = true;
                }
                if (needDialog) {
                    String[] labels = new String[count];
                    String[] values = new String[count];
                    boolean[] allowBlanks = new boolean[count];
                    int i2 = 0;
                    while (i2 < count) {
                        DebugConnectArg connectArg = this.connectArgs[i2];
                        labels[i2] = connectArg.getLabel();
                        values[i2] = connectArg.getValue();
                        allowBlanks[i2] = connectArg.allowBlank();
                        ++i2;
                    }
                    String title = DbgArb.getString(801);
                    String helpId = "f1_deb_listen_jpda_html";
                    boolean[] save = !Product.isRaptor() ? new boolean[1] : null;
                    boolean ok = RemoteConnectDialog.showRemoteConnectDialog(title, labels, values, allowBlanks, save, helpId);
                    if (!ok) {
                        return false;
                    }
                    int i3 = 0;
                    while (i3 < count) {
                        DebugConnectArg connectArg = this.connectArgs[i3];
                        connectArg.setValue(values[i3]);
                        if (save == null || save[0] || this.debugConfiguration.isCustom()) {
                            this.debugConfiguration.putRemoteParameterValue("jpdaListen", connectArg.getName(), values[i3]);
                        }
                        ++i3;
                    }
                    if (save == null || save[0]) {
                        this.debugConfiguration.setPromptForRemoteDebugging(false);
                    }
                }
            } else {
                Assert.check((listenPort != null ? 1 : 0) != 0);
                DebugConnectArg connectArg = DebugShared.findConnectArg(this.connectArgs, "port");
                if (connectArg != null) {
                    connectArg.setValue(listenPort);
                }
            }
            try {
                this.connector.startListening(this.connectArgs, this);
                StringBuffer sb = new StringBuffer();
                int i = 0;
                while (i < count) {
                    DebugConnectArg connectArg = this.connectArgs[i];
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    sb.append(connectArg.getLabel());
                    sb.append("=");
                    sb.append(connectArg.getValue());
                    ++i;
                }
                this.connectArgsLabel = sb.toString();
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                block19: {
                    int answer;
                    if (!this.runConfiguration.isRemoteDebuggingProfiling()) break block19;
                    errorOccurred = true;
                    String[] messages = new String[]{DbgArb.getString(192), DbgArb.getString(191)};
                    if ((answer = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), messages, DbgArb.getString(714), 0)) != 1) continue;
                }
                return false;
            }
            break;
        }
    }

    void stopListening() {
        try {
            this.connector.stopListening();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void listeningStarted() {
        SwingUtilities.invokeLater(new 1());
    }

    public boolean connectionEstablished(DebugVirtualMachine vm) {
        SwingUtilities.invokeLater(new 2(this, vm));
        return this.keepListening;
    }

    public void listeningStopped() {
        SwingUtilities.invokeLater(new 3());
    }

    public String getShortLabel() {
        if (this.connectArgsLabel != null && this.connectArgsLabel.length() > 0) {
            return DbgArb.format(604, this.connectArgsLabel);
        }
        return DbgArb.getString(605);
    }

    static DebuggingProcess ra$debuggingProcess(DebuggingListener debuggingListener) {
        return debuggingListener.debuggingProcess;
    }

    static void wa$debuggingProcess(DebuggingListener debuggingListener, DebuggingProcess debuggingProcess) {
        debuggingListener.debuggingProcess = debuggingProcess;
    }

    static Workspace ra$workspace(DebuggingListener debuggingListener) {
        return debuggingListener.workspace;
    }

    static Project ra$project(DebuggingListener debuggingListener) {
        return debuggingListener.project;
    }

    static DebugConnectArg[] ra$connectArgs(DebuggingListener debuggingListener) {
        return debuggingListener.connectArgs;
    }

    final class 1
    implements Runnable {
        public void run() {
            JDebugger.getInstance().listenerStarted(DebuggingListener.this);
            Runner.getRunner().getRunManagerFolder().add((Element)DebuggingListener.this);
        }
    }

    final class 2
    implements Runnable {
        private final /* synthetic */ DebugVirtualMachine v$vm;
        final /* synthetic */ DebuggingListener this$0;

        public void run() {
            DebuggingProcess debuggingProcessForAccept = DebuggingListener.ra$debuggingProcess(this.this$0);
            DebuggingListener.wa$debuggingProcess(this.this$0, null);
            if (debuggingProcessForAccept == null) {
                Context context = ContextBuilder.buildContext(null, (View)Runner.getRunner().getRunManagerWindow(), null, DebuggingListener.ra$workspace(this.this$0), DebuggingListener.ra$project(this.this$0));
                debuggingProcessForAccept = new DebuggingProcess(context);
            }
            debuggingProcessForAccept.accept(this.v$vm, DebuggingListener.ra$connectArgs(this.this$0));
        }

        public 2(DebuggingListener debuggingListener, DebugVirtualMachine debugVirtualMachine) {
            this.v$vm = debugVirtualMachine;
            this.this$0 = debuggingListener;
        }
    }

    final class 3
    implements Runnable {
        public void run() {
            if (DebuggingListener.ra$debuggingProcess(DebuggingListener.this) != null) {
                DebuggingListener.ra$debuggingProcess(DebuggingListener.this).listenerStopped();
                DebuggingListener.wa$debuggingProcess(DebuggingListener.this, null);
            }
            JDebugger.getInstance().listenerStopped(DebuggingListener.this);
            Runner.getRunner().getRunManagerFolder().remove((Element)DebuggingListener.this);
        }
    }
}

