/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.cmd.RevertNodeCommand;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.StatusBar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.WaitCursor;
import oracle.ide.docking.DockUtil;
import oracle.ide.docking.DockableView;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.IdeLayout;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.log.LogWindow;
import oracle.ide.log.MessagePage;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;
import oracle.ide.runner.DebuggerEvent;
import oracle.ide.runner.DebuggerEventSource;
import oracle.ide.runner.DebuggerListener;
import oracle.ide.runner.DebuggerStartCallback;
import oracle.ide.runner.RunLogPage;
import oracle.ide.runner.RunProcess;
import oracle.ide.runner.Runner;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeProfile;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ModelUtil;
import oracle.ide.view.View;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ClassCreatorExpr;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassInitializer;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceSynchStatement;
import oracle.javatools.util.NamedTimer;
import oracle.jdeveloper.ant.AntNode;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.model.PackagedSource;
import oracle.jdeveloper.runner.JRunProcess;
import oracle.jdeveloper.runner.JStarterFactory;
import oracle.jdeveloper.runner.RemoteConnectDialog;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.Source;
import oracle.jdevimpl.debugger.javascript.DebugJavaScriptArb;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxJavaScript;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxJavaScriptConnectArg;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxJavaScriptConnector;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointLogListener;
import oracle.jdevimpl.debugger.support.DebugCapabilities;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugConnectArg;
import oracle.jdevimpl.debugger.support.DebugConnector;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugFactory;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugHeapObjectInfo;
import oracle.jdevimpl.debugger.support.DebugListener;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.Helpers;
import oracle.jdevimpl.runner.debug.BaseEvaluator;
import oracle.jdevimpl.runner.debug.Breakpoint;
import oracle.jdevimpl.runner.debug.BytecodeFileSystemHelper;
import oracle.jdevimpl.runner.debug.ClassesWindow;
import oracle.jdevimpl.runner.debug.DatabaseDebuggingHelper;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugConfiguration;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.DebuggingListener;
import oracle.jdevimpl.runner.debug.EvaluatorHandle;
import oracle.jdevimpl.runner.debug.EvaluatorItem;
import oracle.jdevimpl.runner.debug.HeapWindow;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.MonitorsWindow;
import oracle.jdevimpl.runner.debug.ProfilingEvents;
import oracle.jdevimpl.runner.debug.RunWhilePaused;
import oracle.jdevimpl.runner.debug.SmartWindow;
import oracle.jdevimpl.runner.debug.SourceIcon;
import oracle.jdevimpl.runner.debug.ThreadsWindow;
import oracle.jdevimpl.runner.debug.TracingPanel;
import oracle.jdevimpl.runner.run.RunArb;
import oracle.jdevimpl.runner.xslt.XSLTRunnerAddin;

public class DebuggingProcess
extends JRunProcess
implements DebugListener,
DebugBreakpointLogListener {
    private long timeProgramStopped;
    private long timeWindowsUpdated;
    private long timeBeforeConnect;
    private long timeAfterConnect;
    private Toolbar logPageToolbar;
    private boolean logPageToolbarSet;
    private String localPort;
    private static final boolean socketRelay = false;
    private boolean skipCompile;
    private DatabaseDebuggingHelper databaseDebuggingHelper;
    private boolean databaseDebugging;
    private boolean xsltDebugging;
    private boolean antDebugging;
    private boolean jsMozillaFireFoxDebugging;
    private Node xsltInputNode;
    private Node xsltOutputNode;
    private Editor xsltOutputEditor;
    private volatile Thread connectionThread;
    protected volatile DebugVirtualMachine vm;
    private final Object vmSync;
    private DebugThreadInfo currentThread;
    private DebugThreadInfo lastKnownGoodThread;
    private DebugStackFrameInfo currentStackFrame;
    private DebugLocation currentLocation;
    private DebugThreadInfo[][] deadlocks;
    private List runAfterSelectedList;
    private boolean stopped;
    private int loadedClassesCount;
    private boolean resuming;
    private boolean stepping;
    private final boolean[] pause;
    private List runWhilePausedList;
    private List runAfterPausedList;
    private static final int INTERNAL = 0;
    private static final int USER = 1;
    private DebugBreakpoint runToCursor;
    private SourceIcon sourceIconForIP;
    private SourceIcon sourceIconForIPBytecode;
    private List messages;
    private String disconnectedMessage;
    private long updateNormalWindowsEndTime;
    private long stepRequestTime;
    private TimerTask timerTaskUpdateNormalWindows;
    private TimerTask timerTaskUpdateOtherWindows;
    private EventSource debuggerEventSource;
    private DebuggerStartCallback debuggerStartCallback;
    private static Timer timer = null;
    private static Class databaseDebuggingHelperClass = null;
    private static final int EXTRA_CONNECT_ARGS = 3;
    private ArrayList<DebuggingProcess> detachStartedProcesses;
    private boolean attachedToCreatedProcess;
    private static Controller controller;
    private static IdeAction actionTerminate;
    private static final int TERMINATE_CMD_ID;
    private DebugWindowSettings debugWindowSettings;
    private StructureChangeListener changeListener;
    private List<EvaluatorHandle> evaluatorHandles;
    private static HelpInfo helpInfo;
    static final Class starterFactorySubClass;
    private static int classLoadTracking;
    private static final int PRINT_SYSTEM_OUT = 1;
    private static final int PRINT_SYSTEM_ERR = 2;
    private static final int PRINT_LOG_WINDOW = 4;
    static String statusText;

    private void $init$() {
        this.vmSync = new Object();
        this.pause = new boolean[2];
        this.attachedToCreatedProcess = false;
        this.evaluatorHandles = new ArrayList<EvaluatorHandle>();
    }

    public DebuggingProcess(Context context) {
        this(context, null);
    }

    public DebuggingProcess(Context context, DebuggerStartCallback debuggerStartCallback) {
        super(context);
        this.$init$();
        try {
            if (databaseDebuggingHelperClass != null) {
                this.databaseDebuggingHelper = (DatabaseDebuggingHelper)databaseDebuggingHelperClass.newInstance();
                this.databaseDebuggingHelper.setDebuggingProcess(this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        JDebugger.getInstance().debuggingProcessCreated();
        this.runAfterSelectedList = new ArrayList();
        this.runWhilePausedList = new ArrayList();
        this.runAfterPausedList = new ArrayList();
        this.messages = new ArrayList();
        this.debuggerStartCallback = debuggerStartCallback;
    }

    DebugConfiguration getDebugConfiguration() {
        return DebugConfiguration.getInstance((PropertyStorage)this.getJProject());
    }

    public boolean canRun(String runType, Object cookie, Node node, List errors) {
        if ("Java".equals(runType)) {
            return this.canRunJava(node, errors);
        }
        if ("Database".equals(runType)) {
            return this.canRunInDatabase(node, cookie, errors);
        }
        if ("XSLT".equals(runType)) {
            return true;
        }
        if ("XQuery".equals(runType)) {
            errors.add(DbgArb.format(208, node.getShortLabel()));
            return false;
        }
        return false;
    }

    private boolean canRunJava(Node node, List errors) {
        if (!this.isRemoteDebuggingProfiling()) {
            JDK jdkDefinition = this.getJdkDefinition();
            if (this.runConfiguration.usingOJVM(jdkDefinition)) {
                return true;
            }
            if (this.runConfiguration.usingMinimal(jdkDefinition) || this.runConfiguration.usingVanilla(jdkDefinition)) {
                errors.add(DbgArb.format(709, node.getShortLabel()));
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean canRunInDatabase(Node node, Object db, List errors) {
        if (!this.isRemoteDebuggingProfiling() && this.databaseDebuggingHelper != null) {
            return this.databaseDebuggingHelper.canRunInDatabase(node, db, errors);
        }
        return false;
    }

    public Object getValue(String runType, Object cookie, String key) {
        if ("Java".equals(runType) && "FirstJavaCommandOptions".equals(key)) {
            return this.getFirstJavaCommandOptions();
        }
        if ("Database".equals(runType) && "DatabaseRunHelper".equals(key)) {
            this.databaseDebugging = true;
            return this.databaseDebuggingHelper;
        }
        if ("XSLT".equals(runType)) {
            if ("FirstXSLTCommandOptions".equals(key)) {
                return this.getFirstXSLTCommandOptions();
            }
            if ("LastXSLTCommandOptions".equals(key)) {
                return this.getLastXSLTCommandOptions();
            }
        }
        if ("Mozilla_FireFox".equals(runType)) {
            return this.getJSMozillaFireFoxCommandOptions();
        }
        if ("Ant".equals(runType)) {
            if ("FirstAntCommandOptions".equals(key)) {
                return this.getFirstAntCommandOptions();
            }
            if ("LastAntCommandOptions".equals(key)) {
                return this.getLastAntCommandOptions();
            }
        }
        return null;
    }

    private String[] getFirstJavaCommandOptions() {
        String portArg = this.localPort == null ? (this.localPort = Integer.toString(DebuggingProcess.getLocalPort())) : this.localPort;
        JDK jdkDefinition = this.getJdkDefinition();
        DebugConfiguration debugConfiguration = this.getDebugConfiguration();
        if (this.runConfiguration.usingMinimal(jdkDefinition) || this.runConfiguration.usingVanilla(jdkDefinition)) {
            return null;
        }
        if (this.runConfiguration.usingOJVM(jdkDefinition)) {
            return debugConfiguration.getOJVMDebugArguments(portArg);
        }
        if (this.runConfiguration.usingClassic(jdkDefinition)) {
            return debugConfiguration.getJPDAClassicDebugArguments(portArg);
        }
        return debugConfiguration.getJPDADebugArguments(portArg);
    }

    private String[] getFirstXSLTCommandOptions() {
        this.xsltDebugging = true;
        this.xsltInputNode = XSLTRunnerAddin.getXSLTInputNode(this.getJProject(), true);
        this.xsltOutputNode = XSLTRunnerAddin.getXSLTOutputNode(this.getJProject(), true);
        if (this.localPort == null) {
            this.localPort = Integer.toString(DebuggingProcess.getLocalPort());
        }
        String[] options = new String[]{XSLTRunnerAddin.getFirstXSLTDebugOption(this.localPort)};
        return options;
    }

    private String[] getLastXSLTCommandOptions() {
        String[] options = new String[]{XSLTRunnerAddin.getLastXSLTDebugOption()};
        return options;
    }

    private String[] getJSMozillaFireFoxCommandOptions() {
        this.jsMozillaFireFoxDebugging = true;
        if (this.localPort == null) {
            this.localPort = Integer.toString(DebuggingProcess.getLocalPort());
        }
        return new String[]{"-oraclejsdebugport=" + this.localPort};
    }

    private String[] getFirstAntCommandOptions() {
        this.antDebugging = true;
        if (this.localPort == null) {
            this.localPort = Integer.toString(DebuggingProcess.getLocalPort());
        }
        return new String[]{"-Djdev.ant.debug.port=" + this.localPort};
    }

    private String[] getLastAntCommandOptions() {
        return new String[]{"-listener", "oracle.jdevimpl.debugger.ant.DebugBuildListener"};
    }

    public String getProcessLabelPrefix() {
        return this.labelPrefixOverride != null ? this.labelPrefixOverride : DbgArb.getString(74);
    }

    public IdeLayout getProcessLayout() {
        return JDebugger.getInstance().getDebugLayout();
    }

    private void setLogPageNorthComponent() {
        this.logPageToolbarSet = true;
        LogPage lp = this.getLogPage();
        if (lp instanceof RunLogPage) {
            boolean show = DebugWindowSettings.getInstance().isShowToolbarInLogWindow();
            ((RunLogPage)lp).setNorthComponent((Component)(show ? this.getLogPageToolbar() : null));
        }
    }

    private void clearLogPageNorthComponent() {
        this.logPageToolbarSet = false;
        LogPage lp = this.getLogPage();
        if (lp instanceof RunLogPage) {
            ((RunLogPage)lp).setNorthComponent(null);
        }
    }

    void updateToolbarVisibility(boolean show) {
        LogPage lp;
        if (this.logPageToolbarSet && (lp = this.getLogPage()) instanceof RunLogPage) {
            ((RunLogPage)lp).setNorthComponent((Component)(show ? this.getLogPageToolbar() : null));
        }
    }

    Toolbar getLogPageToolbar() {
        if (this.logPageToolbar == null) {
            this.logPageToolbar = new Toolbar();
        }
        return this.logPageToolbar;
    }

    void clearLogPageToolbar() {
        if (this.logPageToolbar != null) {
            this.logPageToolbar.dispose();
            this.logPageToolbar.removeAll();
            this.logPageToolbar.validate();
        }
    }

    public void selected() {
        MonitorsWindow monitorsWindow;
        HeapWindow heapWindow;
        ClassesWindow classesWindow;
        DebugStackFrameInfo currentStackFrame;
        DebugThreadInfo currentThread;
        DebugVirtualMachine vm;
        super.selected();
        JDebugger jdebugger = JDebugger.getInstance();
        jdebugger.processSelected(this);
        if (this.vm != null && this.stopped) {
            vm = this.vm;
            currentThread = this.currentThread;
            currentStackFrame = this.currentStackFrame;
        } else {
            vm = null;
            currentThread = null;
            currentStackFrame = null;
        }
        this.showSourceIPIcon(false);
        jdebugger.getThreadsWindow(true).updateThreads(this, vm, currentThread);
        SmartWindow smartWindow = jdebugger.getSmartWindow(false);
        if (smartWindow != null) {
            smartWindow.updateData(this, vm, currentThread, currentStackFrame);
        }
        if ((classesWindow = jdebugger.getClassesWindow(false)) != null) {
            classesWindow.updateClasses(this, vm);
        }
        if ((heapWindow = jdebugger.getHeapWindow(false)) != null) {
            heapWindow.updateData(this, vm, null, null);
        }
        if ((monitorsWindow = jdebugger.getMonitorsWindow(false)) != null) {
            monitorsWindow.updateMonitors(this, vm);
        }
        while (this.runAfterSelectedList.size() > 0) {
            Runnable runAfterSelected = (Runnable)this.runAfterSelectedList.remove(0);
            runAfterSelected.run();
        }
    }

    public void doubleClicked() {
        super.doubleClicked();
        this.showIP();
    }

    public void unselected() {
        MonitorsWindow monitorsWindow;
        HeapWindow heapWindow;
        ClassesWindow classesWindow;
        super.unselected();
        JDebugger jdebugger = JDebugger.getInstance();
        jdebugger.processUnselected(this);
        this.hideSourceIPIcon();
        jdebugger.getThreadsWindow(true).clearThreads();
        SmartWindow smartWindow = jdebugger.getSmartWindow(false);
        if (smartWindow != null) {
            smartWindow.clearData();
        }
        if ((classesWindow = jdebugger.getClassesWindow(false)) != null) {
            classesWindow.clearClasses();
        }
        if ((heapWindow = jdebugger.getHeapWindow(false)) != null) {
            heapWindow.clearData();
        }
        if ((monitorsWindow = jdebugger.getMonitorsWindow(false)) != null) {
            monitorsWindow.clearMonitors();
        }
    }

    public Icon getIcon() {
        return this.iconOverride != null ? this.iconOverride : DbgArb.getIcon(632);
    }

    public HelpInfo getHelpInfo() {
        if (helpInfo == null) {
            helpInfo = new HelpInfo("f1_deb_log_debuggerprocess_html");
        }
        return helpInfo;
    }

    protected boolean compile() {
        if (this.skipCompile) {
            return true;
        }
        if (this.isRemoteDebuggingProfiling()) {
            return true;
        }
        return super.compile();
    }

    protected Class getStarterFactorySubClass() {
        return starterFactorySubClass;
    }

    protected void determineTargetAndStarter(Class starterFactorySubClass) {
        if (!this.isRemoteDebuggingProfiling()) {
            super.determineTargetAndStarter(starterFactorySubClass);
        }
    }

    protected boolean startTarget() {
        this.skipCompile = false;
        if (this.isRemoteDebuggingProfiling()) {
            DebugConfiguration debugConfiguration = this.getDebugConfiguration();
            if (debugConfiguration.getRemoteProtocol().equals("jpdaListen")) {
                DebuggingListener debuggingListener = new DebuggingListener(this, true);
                if (!debuggingListener.startListening()) {
                    return false;
                }
                if (this.debuggerStartCallback != null) {
                    this.debuggerStartCallback.readyToStart();
                }
                Runner.getRunner().viewRunManager();
            } else {
                if (this.runConfiguration.isClearLogBeforeRun()) {
                    this.getLogPage().clearAll();
                }
                if (!this.connectRemoteDebugging()) {
                    return false;
                }
                if (this.debuggerStartCallback != null) {
                    this.debuggerStartCallback.readyToStart();
                }
            }
        } else {
            if (!this.determineTargetAndStarterAlready) {
                this.determineTargetAndStarter();
            }
            if (this.starter != null && this.debuggerStartCallback != null) {
                this.debuggerStartCallback.readyToStart();
            }
            if (!super.startTarget()) {
                if (this.databaseDebugging) {
                    this.databaseDebuggingHelper.startTargetFailed();
                }
                return false;
            }
            if (!this.databaseDebugging) {
                if (!this.isStartOnly()) {
                    if (!this.isStartAndRemoteDebugging()) {
                        this.connectLocalDebugging();
                    } else {
                        if (this.runConfiguration.isClearLogBeforeRun()) {
                            this.getLogPage().clearAll();
                        }
                        if (!this.connectRemoteDebugging()) {
                            return false;
                        }
                    }
                } else {
                    DebuggingProcess.makeActions();
                    this.setToolbar();
                }
            }
        }
        return true;
    }

    public void addDetachFromStasrtedProcess(DebuggingProcess startedProcess) {
        if (this.detachStartedProcesses == null) {
            this.detachStartedProcesses = new ArrayList();
        }
        this.detachStartedProcesses.add(startedProcess);
    }

    public void setAttachToCreatedProcess(boolean b) {
        this.attachedToCreatedProcess = b;
    }

    static int getLocalPort() {
        DebugWindowSettings dbgSettings = DebugWindowSettings.getInstance();
        if (dbgSettings.isLocalPortRange()) {
            int min = dbgSettings.getLocalPortRangeMin();
            int max = dbgSettings.getLocalPortRangeMax();
            return Helpers.getLocalPort(min, max);
        }
        return Helpers.getLocalPort();
    }

    private boolean connectRemoteDebugging() {
        int debugFactory = this.getDebuggerFactory();
        DebugConnector connector = DebugFactory.newInstance(debugFactory);
        DebugConnectArg[] connectArgs = this.getDebugConnectArgs(connector);
        int count = connectArgs.length;
        DebugConfiguration debugConfiguration = this.getDebugConfiguration();
        String protocol = debugConfiguration.getRemoteProtocol();
        boolean needDialog = debugConfiguration.isPromptForRemoteDebugging();
        int i = 0;
        while (i < count) {
            DebugConnectArg connectArg = connectArgs[i];
            String value = debugConfiguration.getRemoteParameterValue(protocol, connectArg.getName());
            if (value != null) {
                connectArg.setValue(value);
                value = connectArg.getValue();
                if (value.length() == 0 && !connectArg.allowBlank()) {
                    needDialog = true;
                }
            } else if (!connectArg.allowBlank()) {
                needDialog = true;
            }
            ++i;
        }
        if (needDialog) {
            boolean ok;
            String[] labels = new String[count];
            String[] values = new String[count];
            boolean[] allowBlanks = new boolean[count];
            int i2 = 0;
            while (i2 < count) {
                DebugConnectArg connectArg = connectArgs[i2];
                labels[i2] = connectArg.getLabel();
                values[i2] = connectArg.getValue();
                allowBlanks[i2] = connectArg.allowBlank();
                ++i2;
            }
            String title = debugFactory == 0 ? DbgArb.getString(455) : (debugFactory == 2 ? DbgArb.getString(62) : (debugFactory == 4 ? DbgArb.getString(706) : DbgArb.getString(455)));
            String helpId = "f1_deb_attachto_ojvm_jpda_html";
            boolean[] save = new boolean[1];
            boolean[] attachPid = null;
            if (debugFactory == 0) {
                attachPid = new boolean[]{debugFactory == 0, false, false};
            }
            if (!(ok = RemoteConnectDialog.showRemoteConnectDialog(title, labels, values, allowBlanks, save, helpId, attachPid))) {
                return false;
            }
            if (connector instanceof DebugMozillaFireFoxJavaScriptConnector) {
                DebugConnectArg[] args = new DebugConnectArg[connectArgs.length + 1];
                System.arraycopy(connectArgs, 0, args, 0, connectArgs.length);
                DebugMozillaFireFoxJavaScriptConnectArg dca = new DebugMozillaFireFoxJavaScriptConnectArg("javascript_remote_attached", "javascript_remote_attached", true);
                dca.setValue(DbgArb.getString(87));
                args[args.length - 1] = dca;
                connectArgs = args;
                ++count;
            }
            String[] labels1 = new String[count];
            String[] values1 = new String[count];
            boolean[] allowBlanks1 = new boolean[count];
            System.arraycopy(labels, 0, labels1, 0, labels.length);
            System.arraycopy(values, 0, values1, 0, values.length);
            System.arraycopy(allowBlanks, 0, allowBlanks1, 0, allowBlanks.length);
            int i3 = count - 1;
            while (i3 < count) {
                DebugConnectArg connectArg = connectArgs[i3];
                labels1[i3] = connectArg.getLabel();
                values1[i3] = connectArg.getValue();
                allowBlanks1[i3] = connectArg.allowBlank();
                ++i3;
            }
            labels = labels1;
            values = values1;
            allowBlanks = allowBlanks1;
            int i4 = 0;
            while (i4 < count) {
                DebugConnectArg connectArg = connectArgs[i4];
                if (connectArg.getName().equals("jdi_attach_method:")) {
                    if (attachPid[1]) {
                        connectArg.setValue("jdi_attach_method_pid");
                    } else if (attachPid[2]) {
                        connectArg.setValue("jdi_attach_method_live_pid");
                    } else {
                        connectArg.setValue("");
                    }
                } else {
                    connectArg.setValue(values[i4]);
                    if (save[0] || debugConfiguration.isCustom()) {
                        debugConfiguration.putRemoteParameterValue(protocol, connectArg.getName(), values[i4]);
                    }
                }
                ++i4;
            }
            if (save[0]) {
                debugConfiguration.setPromptForRemoteDebugging(false);
            }
        }
        String host = this.findHostValue(connectArgs);
        String port = this.findPortValue(connectArgs);
        1 successRunnable = new 1();
        2 failureRunnable = new 2();
        Runnable canceledRunnable = null;
        String tryMsg = needDialog ? DbgArb.format(82, host, port) : DbgArb.format(71, host, port);
        String successMsg = DbgArb.format(711, host, port);
        this.connectToDebuggee(connector, connectArgs, tryMsg, successMsg, successRunnable, failureRunnable, canceledRunnable);
        return true;
    }

    protected DebugConnectArg[] getDebugConnectArgs(DebugConnector connector) {
        DebugConnectArg[] connectArgs = connector.getConnectArgs();
        return connectArgs;
    }

    protected String findHostValue(DebugConnectArg[] connectArgs) {
        DebugConnectArg connectArg = DebugShared.findConnectArg(connectArgs, "hostname");
        if (connectArg != null) {
            String host = connectArg.getValue();
            if (host == null || host.length() == 0) {
                host = DbgArb.getString(547);
            }
            return host;
        }
        int connectArgsLength = connectArgs.length;
        if (connectArgsLength >= 2) {
            int hostIndex = connectArgsLength - 2;
            String host = connectArgs[hostIndex].getValue();
            if (host == null || host.length() == 0) {
                host = DbgArb.getString(547);
            }
            return host;
        }
        return "";
    }

    private String findPortValue(DebugConnectArg[] connectArgs) {
        DebugConnectArg connectArg = DebugShared.findConnectArg(connectArgs, "port");
        if (connectArg != null) {
            return connectArg.getValue();
        }
        int connectArgsLength = connectArgs.length;
        if (connectArgsLength >= 1) {
            int portIndex = connectArgsLength - 1;
            return connectArgs[portIndex].getValue();
        }
        return "";
    }

    protected boolean isRemoteDebuggingProfiling() {
        return this.runConfiguration.isRemoteDebuggingProfiling() || this.attachedToCreatedProcess;
    }

    protected boolean isStartAndRemoteDebugging() {
        if (this.starter != null) {
            return this.starter.isStartAndRemoteDebugging();
        }
        return false;
    }

    protected boolean isStartOnly() {
        if (this.starter != null) {
            return this.starter.isStartOnly();
        }
        return false;
    }

    protected boolean isRemoteAttachment() {
        return this.isRemoteDebuggingProfiling() || this.isStartAndRemoteDebugging();
    }

    private void connectLocalDebugging() {
        3 failureRunnable = new 3();
        DebugConnector connector = null;
        try {
            connector = DebugFactory.newInstance(this.getDebuggerFactory());
        }
        catch (NoClassDefFoundError e) {
            failureRunnable.run();
            return;
        }
        DebugConnectArg[] connectArgs = connector.getConnectArgs();
        DebugConnectArg connectArg = DebugShared.findConnectArg(connectArgs, "port");
        if (connectArg != null) {
            connectArg.setValue(this.localPort);
        }
        4 successRunnable = new 4();
        5 canceledRunnable = new 5();
        String tryMsg = null;
        String successMsg = DbgArb.getString(597);
        this.connectToDebuggee(connector, connectArgs, tryMsg, successMsg, successRunnable, failureRunnable, canceledRunnable);
    }

    void connectToDebuggee(DebugConnector connector, DebugConnectArg[] connectArgs, String tryMsg, String successMsg, Runnable successRunnable, Runnable failureRunnable, Runnable canceledRunnable) {
        DebuggingProcess.showStatus(DbgArb.getString(663));
        if (tryMsg != null) {
            StringBuffer sb = new StringBuffer(tryMsg);
            this.log(sb);
        }
        int maxRetries = DebugWindowSettings.getInstance().getConnectionRetries();
        this.setLogPageNorthComponent();
        this.connectionThread = new 6(this, "DebugConnection", connectArgs, connector, successMsg, successRunnable, tryMsg, maxRetries, canceledRunnable, failureRunnable);
        JDebugger.getInstance().debuggingProcessBeforeConnecting(this);
        this.connectionThread.start();
    }

    boolean canCancelConnection() {
        return this.connectionThread != null;
    }

    void cancelConnection() {
        Thread connectionThread = this.connectionThread;
        if (connectionThread != null) {
            this.log(new StringBuffer(DbgArb.getString(70)));
            connectionThread.interrupt();
        }
    }

    private String isApplicationServer() {
        boolean foundTomcat = false;
        DebugClassInfo[] loadedClasses = this.vm.listClasses(true);
        int i = 0;
        while (i < loadedClasses.length) {
            String name;
            DebugClassInfo clazz = loadedClasses[i];
            if (clazz.isObject() && !(name = clazz.getName()).startsWith("java") && !name.startsWith("sun")) {
                if (name.startsWith("com.evermind") || name.startsWith("oracle.oc4j")) {
                    return DbgArb.getString(364);
                }
                if (name.startsWith("org.jboss.")) {
                    return DbgArb.getString(518);
                }
                if (name.startsWith("com.ibm.websphere.")) {
                    return DbgArb.getString(875);
                }
                if (name.startsWith("weblogic.")) {
                    return DbgArb.getString(139);
                }
                if (name.startsWith("org.apache.tomcat.")) {
                    foundTomcat = true;
                }
            }
            ++i;
        }
        if (foundTomcat) {
            return DbgArb.getString(1);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void afterConnection(String disconnectedMsg) {
        Object object = this.vmSync;
        synchronized (object) {
            if (this.vm == null) {
                return;
            }
        }
        this.disconnectedMessage = disconnectedMsg;
        WaitCursor wc = Ide.getWaitCursor();
        wc.show();
        super.started();
        if (this.xsltDebugging) {
            this.showXSLTInput();
        }
        if (this.isRemoteDebuggingProfiling()) {
            String appServer;
            boolean isRunning = false;
            Object object2 = this.vmSync;
            synchronized (object2) {
                if (this.vm == null) {
                    return;
                }
                isRunning = this.vm.isRunning();
            }
            if (isRunning && (appServer = this.isApplicationServer()) != null) {
                this.log(DbgArb.format(348, appServer));
                this.log(DbgArb.getString(347));
            }
        }
        Object object3 = this.vmSync;
        synchronized (object3) {
            if (this.vm == null) {
                return;
            }
            this.vm.addDebugListener(this);
            this.vm.addBreakpointLogListener(this);
        }
        this.setTracing();
        Object object4 = this.vmSync;
        synchronized (object4) {
            if (this.vm == null) {
                return;
            }
            this.vm.setPauseInterval(100);
        }
        JDebugger.getInstance().cacheNewBreakpoints();
        try {
            this.stopped = true;
            List[] breakpoints = Breakpoint.getBreakpoints(this.getWorkspace(), this.getProject());
            int length = breakpoints.length;
            int i = 0;
            while (i < length) {
                for (Breakpoint bp : breakpoints[i]) {
                    bp.putBreakpoint(this);
                }
                ++i;
            }
            this.stopped = false;
            if (this.timeBeforeConnect != 0L) {
                this.timeAfterConnect = System.currentTimeMillis();
                Assert.println((String)("Time to attach debugger to debuggee: " + (this.timeAfterConnect - this.timeBeforeConnect) + " ms"));
            }
            this.sendDebuggerEvent(1, 100);
            String startOption = DebugWindowSettings.getInstance().getStartOption();
            if (startOption.equals("stepover")) {
                Object object5 = this.vmSync;
                synchronized (object5) {
                    if (this.vm == null) {
                        // MONITOREXIT @DISABLED, blocks:[4, 5, 37, 28, 12] lbl86 : MonitorExitStatement: MONITOREXIT : var15_15
                        JDebugger.getInstance().flushNewBreakpoints();
                        return;
                    }
                    this.vm.start(true);
                }
            }
            if (startOption.equals("stepinto")) {
                Object object6 = this.vmSync;
                synchronized (object6) {
                    if (this.vm == null) {
                        // MONITOREXIT @DISABLED, blocks:[36, 4, 6, 27, 13] lbl101 : MonitorExitStatement: MONITOREXIT : var16_16
                        JDebugger.getInstance().flushNewBreakpoints();
                        return;
                    }
                    this.vm.start(false);
                }
            }
            Object object7 = this.vmSync;
            synchronized (object7) {
                if (this.vm == null) {
                    // MONITOREXIT @DISABLED, blocks:[4, 7, 26, 14] lbl115 : MonitorExitStatement: MONITOREXIT : var17_17
                    JDebugger.getInstance().flushNewBreakpoints();
                    return;
                }
                this.vm.resume();
            }
            this.setLogPageNorthComponent();
            JDebugger.getInstance().debuggingProcessStarted(this);
            wc.hide();
            Runner.getRunner().selectProcess((RunProcess)this);
        }
        finally {
            JDebugger.getInstance().flushNewBreakpoints();
        }
    }

    private void sendDebuggerEvent(int eventType, int state) {
        block13: {
            try {
                if (this.debuggerEventSource == null) {
                    this.debuggerEventSource = new EventSource();
                }
                this.debuggerEventSource.eventOccurring(eventType, state);
                DebuggerListener[] debuggerListeners = JDebugger.getInstance().getDebuggerListeners();
                if (debuggerListeners.length <= 0) break block13;
                DebuggerEvent event = new DebuggerEvent((Object)this.debuggerEventSource, eventType);
                switch (eventType) {
                    case 1: {
                        int i = 0;
                        while (i < debuggerListeners.length) {
                            debuggerListeners[i].debuggerStarted(event);
                            ++i;
                        }
                        break;
                    }
                    case 2: {
                        int i = 0;
                        while (i < debuggerListeners.length) {
                            debuggerListeners[i].debuggerStopping(event);
                            ++i;
                        }
                        break;
                    }
                    case 3: {
                        int i = 0;
                        while (i < debuggerListeners.length) {
                            debuggerListeners[i].debuggerResuming(event);
                            ++i;
                        }
                        this.clearEvaluatorHandles();
                        break;
                    }
                    case 4: {
                        int i = 0;
                        while (i < debuggerListeners.length) {
                            debuggerListeners[i].debuggerFinished(event);
                            ++i;
                        }
                        this.clearEvaluatorHandles();
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
        }
    }

    boolean canPop1StackFrame(Context context) {
        return this.pop1StackFrame(false, context);
    }

    void pop1StackFrame(Context context) {
        this.pop1StackFrame(true, context);
    }

    private boolean pop1StackFrame(boolean doIt, Context context) {
        try {
            int sfCount;
            DebugCapabilities capabilities;
            if (this.vm != null && this.stopped && this.vm.getCapabilities().canPopFrames() && (capabilities = this.vm.getCapabilities()).canPopFrames() && this.currentThread != null && DebuggingProcess.isThreadGood(this.currentThread) && (sfCount = this.currentThread.getStackFrameCount()) > 1) {
                DebugStackFrameInfo popTo = null;
                int i = 1;
                if (i < sfCount) {
                    popTo = this.currentThread.getStackFrame(i);
                }
                if (popTo != null) {
                    if (doIt) {
                        popTo.popBackToHere();
                        this.stackFramesPopped(this.currentThread);
                    }
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        return false;
    }

    boolean canSetTracing() {
        try {
            boolean bl = this.vm != null && this.vm.getCapabilities().canSetDebuggablePackages();
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    void setTracing() {
        DebugConfiguration debugConfiguration = this.getDebugConfiguration();
        this.vm.setDebuggablePackages(debugConfiguration.getTracingInclude(), debugConfiguration.getTracingExclude());
    }

    protected final List getTracingIncludeList() {
        return this.getDebugConfiguration().getTracingIncludeList();
    }

    protected final List getTracingExcludeList() {
        return this.getDebugConfiguration().getTracingExcludeList();
    }

    public boolean canTerminate() {
        if (this.vm != null) {
            return true;
        }
        return super.canTerminate();
    }

    public void started() {
        if (this.isStartOnly()) {
            super.started();
        }
    }

    void accept(DebugVirtualMachine vm, DebugConnectArg[] connectArgs) {
        String disconnectedMsg;
        String acceptedMsg;
        this.skipCompile = true;
        this.vm = vm;
        String port = this.findPortValue(connectArgs);
        if (this.databaseDebugging) {
            this.databaseDebuggingHelper.connectionAccepted();
            acceptedMsg = DbgArb.format(245, port);
            disconnectedMsg = DbgArb.getString(274);
        } else {
            acceptedMsg = DbgArb.format(955, port);
            disconnectedMsg = DbgArb.getString(149);
        }
        this.log(acceptedMsg);
        MessagePage mp = null;
        LogPage lp = this.getLogPage();
        if (lp instanceof MessagePage) {
            mp = (MessagePage)lp;
        }
        vm.afterConnection(mp);
        this.afterConnection(disconnectedMsg);
    }

    void listenerStopped() {
        if (this.databaseDebugging) {
            this.databaseDebuggingHelper.listenerStopped();
        }
    }

    public void programStopped() {
        SwingUtilities.invokeLater(new 7());
    }

    public void breakpointChanged(DebugBreakpoint dbp) {
        SwingUtilities.invokeLater(new 8(this, dbp));
    }

    public void programTerminating() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void programTerminated() {
        Object object = this.vmSync;
        synchronized (object) {
            this.vm = null;
        }
        SwingUtilities.invokeLater(new 9());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionLost() {
        if (this.detachStartedProcesses != null) {
            for (DebuggingProcess debProc : this.detachStartedProcesses) {
                if (debProc == null) continue;
                debProc.detach();
            }
        }
        Object object = this.vmSync;
        synchronized (object) {
            this.vm = null;
        }
        SwingUtilities.invokeLater(new 10());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logBreakpoint(DebugBreakpoint dbp, DebugThreadInfo thread, DebugStackFrameInfo[] stack) {
        String msg = null;
        Object object = this.vmSync;
        synchronized (object) {
            if (this.vm == null) {
                return;
            }
            Breakpoint bp = JDebugger.getInstance().findBreakpoint(dbp);
            msg = bp.logBreakpoint(this.vm, thread, stack);
        }
        this.logMessages();
        if (msg != null) {
            this.logMessage(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logException(DebugBreakpoint dbp, String classname, String detail, DebugThreadInfo thread, DebugStackFrameInfo[] stack) {
        String msg = null;
        Object object = this.vmSync;
        synchronized (object) {
            if (this.vm == null) {
                return;
            }
            Breakpoint bp = JDebugger.getInstance().findBreakpoint(dbp);
            msg = bp.logException(this.vm, thread, stack, classname, detail);
        }
        this.logMessages();
        if (msg != null) {
            this.logMessage(msg);
        }
    }

    public void logClassLoad(DebugBreakpoint dbp, String classname, DebugThreadInfo thread, DebugStackFrameInfo[] stack) {
    }

    public void logAllocation(DebugBreakpoint dbp, DebugHeapObjectInfo heapObject, DebugThreadInfo thread, DebugStackFrameInfo[] stack) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logDeadlock(DebugBreakpoint dbp, DebugThreadInfo thread, DebugStackFrameInfo[] stack) {
        String msg = null;
        Object object = this.vmSync;
        synchronized (object) {
            if (this.vm == null) {
                return;
            }
            Breakpoint bp = JDebugger.getInstance().findBreakpoint(dbp);
            msg = bp.logDeadlock(this.vm, thread, stack);
        }
        this.logMessages();
        if (msg != null) {
            this.logMessage(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logWatchpoint(DebugBreakpoint dbp, DebugFieldInfo field, DebugDataInfo futureValue, DebugThreadInfo thread, DebugStackFrameInfo[] stack) {
        String msg = null;
        Object object = this.vmSync;
        synchronized (object) {
            if (this.vm == null) {
                return;
            }
            Breakpoint bp = JDebugger.getInstance().findBreakpoint(dbp);
            msg = bp.logWatchpoint(this.vm, thread, stack, field, futureValue);
        }
        this.logMessages();
        if (msg != null) {
            this.logMessage(msg);
        }
    }

    private void logMessage(String msg) {
        this.waitForRedirectOutput();
        SwingUtilities.invokeLater(new 11(this, msg));
    }

    public DebugVirtualMachine getVM() {
        return this.vm;
    }

    DebugThreadInfo[][] getDeadlocks() {
        if (this.deadlocks == null) {
            this.deadlocks = this.vm.getDeadlockedThreads();
        }
        return this.deadlocks;
    }

    boolean isStopped() {
        return this.vm != null && this.stopped && !this.resuming;
    }

    private boolean isLocationDebuggable() {
        DebugClassInfo clazz;
        return this.currentLocation != null && (clazz = this.currentLocation.getClassInfo()).isDebuggable();
    }

    void stackFramesPopped(DebugThreadInfo thread) {
        if (thread == this.currentThread) {
            this.updateCurrentLocation(true);
        }
        JDebugger.getInstance().stackFramesPopped();
    }

    void setCurrentThread(DebugThreadInfo thread) {
        this.setCurrentThread(thread, true);
    }

    private static boolean isThreadGood(DebugThreadInfo thread) {
        int status = thread.getStatus();
        return (status == 2 || status == 3 || status == 4 || status == 5) && thread.getStackFrameCount() > 0;
    }

    private void setCurrentThread(DebugThreadInfo thread, boolean updateSource) {
        if (thread != null) {
            this.currentThread = thread;
        } else if (this.lastKnownGoodThread != null && DebuggingProcess.isThreadGood(this.lastKnownGoodThread)) {
            this.currentThread = this.lastKnownGoodThread;
        } else {
            DebugThreadInfo mainThread = null;
            DebugThreadInfo eventThread = null;
            DebugThreadInfo mainGroupThread = null;
            DebugThreadInfo otherThread = null;
            DebugThreadInfo[] threads = this.vm.listThreads();
            int length = threads.length;
            int i = 0;
            while (i < length) {
                DebugThreadInfo t = threads[i];
                if (t.getGroupName().equals("main")) {
                    String name = t.getName();
                    if (mainThread == null && name.equals("main")) {
                        if (DebuggingProcess.isThreadGood(t)) {
                            mainThread = t;
                        }
                    } else if (eventThread == null && name.startsWith("AWT-Event")) {
                        if (DebuggingProcess.isThreadGood(t)) {
                            eventThread = t;
                        }
                    } else if (mainGroupThread == null && DebuggingProcess.isThreadGood(t)) {
                        mainGroupThread = t;
                    }
                } else if (otherThread == null && DebuggingProcess.isThreadGood(t)) {
                    otherThread = t;
                }
                ++i;
            }
            if (mainThread != null) {
                this.currentThread = mainThread;
            } else if (eventThread != null) {
                this.currentThread = eventThread;
            } else if (mainGroupThread != null) {
                this.currentThread = mainGroupThread;
            } else if (otherThread != null) {
                this.currentThread = otherThread;
            }
        }
        if (this.currentThread != null) {
            this.lastKnownGoodThread = this.currentThread;
        }
        this.updateCurrentLocation(updateSource);
    }

    private void updateCurrentLocation(boolean updateSource) {
        if (updateSource) {
            this.hideSourceIPIcon();
        }
        this.currentStackFrame = null;
        this.currentLocation = null;
        if (this.currentThread != null) {
            this.currentStackFrame = DebuggingProcess.getNonNativeStackFrame(this.currentThread);
            DebugLocation debugLocation = this.currentLocation = this.currentStackFrame != null ? this.currentStackFrame.getLocation() : null;
        }
        if (updateSource) {
            this.showSourceIPIcon(true);
            SmartWindow smartWindow = JDebugger.getInstance().getSmartWindow(false);
            if (smartWindow != null) {
                smartWindow.updateData(this, this.vm, this.currentThread, this.currentStackFrame);
            }
        }
    }

    boolean isCurrentThread(DebugThreadInfo thread) {
        return this.currentThread != null && this.currentThread.equals(thread);
    }

    public void superTerminate() {
        super.terminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        if (this.detachStartedProcesses != null) {
            for (DebuggingProcess debProc : this.detachStartedProcesses) {
                if (debProc == null) continue;
                debProc.detach();
            }
        }
        if (this.starter != null && this.starter.canTerminateGracefully()) {
            if (this.vm != null) {
                if (!(this.vm instanceof DebugMozillaFireFoxJavaScript)) {
                    this.sendDebuggerEvent(4, 402);
                    this.debuggeeResuming(false, true);
                    this.vm.disconnect(false);
                    Object object = this.vmSync;
                    synchronized (object) {
                        this.vm = null;
                    }
                }
                this.clearLogPageToolbar();
            }
            this.starter.terminateGracefully();
            if (!(this.vm instanceof DebugMozillaFireFoxJavaScript)) {
                Object object = this.vmSync;
                synchronized (object) {
                    this.vm = null;
                }
            }
            return;
        }
        if (this.vm != null) {
            if (this.isRemoteDebuggingProfiling() && this.vm.wasRunning()) {
                String[] messages = new String[]{DbgArb.getString(214), DbgArb.getString(212), DbgArb.getString(211), DbgArb.getString(209)};
                Object[] answers = new String[]{DbgArb.getString(442), DbgArb.getString(859), DbgArb.getString(93)};
                int answer = JOptionPane.showOptionDialog((Component)Ide.getMainWindow(), messages, DbgArb.getString(330), -1, 2, null, answers, answers[0]);
                if (answer == -1 || answer == 2) {
                    return;
                }
                if (answer == 0) {
                    this.detach();
                    return;
                }
            } else if (this.isStartAndRemoteDebugging()) {
                this.detach();
                super.terminate();
                return;
            }
            this.sendDebuggerEvent(4, 402);
            this.debuggeeResuming(false, true);
            DebugVirtualMachine vmFinal = this.vm;
            12 disconnectThread = new 12(this, "DebugDisconnect", vmFinal);
            Object object = this.vmSync;
            synchronized (object) {
                this.vm = null;
            }
            this.clearLogPageToolbar();
            if (this.isRemoteDebuggingProfiling()) {
                this.finished();
            }
            disconnectThread.start();
        } else {
            super.terminate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished() {
        Integer exitCode;
        BytecodeFileSystemHelper bytecodeHelper = BytecodeFileSystemHelper.getInstance(false);
        if (bytecodeHelper != null) {
            bytecodeHelper.removeStaleMethods();
        }
        DebuggingProcess.clearStatus();
        if (this.databaseDebugging) {
            this.databaseDebuggingHelper.finished();
        }
        Object object = this.vmSync;
        synchronized (object) {
            this.vm = null;
        }
        this.lastKnownGoodThread = null;
        if (this.disconnectedMessage != null) {
            this.logMessage(this.disconnectedMessage);
            this.disconnectedMessage = null;
        }
        List[] breakpoints = Breakpoint.getBreakpoints(this.getWorkspace(), this.getProject());
        int length = breakpoints.length;
        int i = 0;
        while (i < length) {
            for (Breakpoint bp : breakpoints[i]) {
                bp.processFinished(this);
            }
            ++i;
        }
        this.clearLogPageNorthComponent();
        JDebugger.getInstance().debuggingProcessFinished(this);
        if (this.starter != null && (exitCode = this.starter.getExitCode()) != null && this instanceof DebuggingProcess && this.jsMozillaFireFoxDebugging) {
            String error = null;
            if (exitCode == -65536) {
                error = RunArb.getString(21);
            } else if (exitCode == -65535) {
                error = DebugJavaScriptArb.getString(16);
            } else if (exitCode == -65534) {
                error = DebugJavaScriptArb.getString(13);
            } else if (exitCode == -65533) {
                error = DebugJavaScriptArb.getString(26);
            } else if (exitCode == -65532) {
                error = DebugJavaScriptArb.getString(4);
            } else if (exitCode == -65531) {
                error = DebugJavaScriptArb.getString(11);
            } else if (exitCode == -65530) {
                error = DebugJavaScriptArb.getString(9);
            } else if (exitCode == -65529) {
                error = DebugJavaScriptArb.getString(25);
            } else if (exitCode == -65528) {
                error = RunArb.getString(24);
            }
            if (error != null && this.errors != null) {
                this.errors.add(error);
            }
        }
        super.finished();
    }

    protected void showSourceFile(DebugLocation location, boolean selectLine) {
        if (location != null) {
            int line = location.getLine();
            if (line != 0) {
                DebugClassInfo clazz = location.getClassInfo();
                String filename = location.getFilename();
                this.showSourceFile(clazz, filename, line, selectLine);
            } else {
                this.showSourceFile(location.getMethod());
            }
        }
    }

    protected void showSourceFile(DebugMethodInfo method) {
        try {
            SourceClass sourceClass;
            String className = method.getClassInfo().getName();
            String methodName = method.getNameWithoutClassOrSignature();
            String fullMethodName = method.getName();
            Project jproject = this.getJProject();
            JavaManager javaManager = JavaManager.getJavaManager((Project)jproject);
            JavaClass javaClass = javaManager.getClass(className);
            if (javaClass != null && (sourceClass = (SourceClass)javaClass.getSourceElement()) != null) {
                if (methodName.equals("<clinit>")) {
                    JavaMethod javaMethod = javaClass.getClinitMethod();
                    if (javaMethod instanceof SourceMethod) {
                        SourceMethod sourceMethod = (SourceMethod)javaMethod;
                        URL url = sourceClass.getURL();
                        int line = -sourceMethod.getStartOffset();
                        SourceName sourceName = sourceMethod.getNameElement();
                        if (sourceName != null) {
                            line = -sourceName.getStartOffset();
                        }
                        Source.showSourceFile(this.getWorkspace(), this.getProject(), url, line, true);
                        return;
                    }
                    List l = sourceClass.getSourceInitializers();
                    if (l != null && l.size() > 0) {
                        SourceClassInitializer sourceClassInitializer = (SourceClassInitializer)l.get(0);
                        URL url = sourceClass.getURL();
                        int line = -sourceClassInitializer.getStartOffset();
                        Source.showSourceFile(this.getWorkspace(), this.getProject(), url, line, true);
                        return;
                    }
                }
                ArrayList<JavaMethod> methods = null;
                if (methodName.equals("<init>")) {
                    methods = sourceClass.getDeclaredConstructors();
                } else {
                    Collection c = sourceClass.getDeclaredMethods();
                    if (c != null && c.size() > 0) {
                        methods = new ArrayList<JavaMethod>();
                        for (JavaMethod javaMethod : c) {
                            if (!javaMethod.getName().equals(methodName)) continue;
                            methods.add(javaMethod);
                        }
                    }
                }
                if (methods != null) {
                    int iSignature = fullMethodName.indexOf(40);
                    ++iSignature;
                    for (Object e : methods) {
                        if (!(e instanceof SourceMethod)) continue;
                        SourceMethod sourceMethod = (SourceMethod)e;
                        boolean parametersMatch = true;
                        Iterator itP = sourceMethod.getParameters().iterator();
                        while (itP.hasNext()) {
                            String parameter = ((JavaVariable)itP.next()).getResolvedType().getQualifiedName();
                            if (!fullMethodName.startsWith(parameter, iSignature)) {
                                parametersMatch = false;
                                break;
                            }
                            if (fullMethodName.charAt(iSignature += parameter.length()) != ',') continue;
                            ++iSignature;
                        }
                        if (fullMethodName.charAt(iSignature) != ')') {
                            parametersMatch = false;
                        }
                        if (!parametersMatch) continue;
                        URL url = sourceClass.getURL();
                        int line = -sourceMethod.getStartOffset();
                        SourceName sourceName = sourceMethod.getNameElement();
                        if (sourceName != null) {
                            line = -sourceName.getStartOffset();
                        }
                        Source.showSourceFile(this.getWorkspace(), this.getProject(), url, line, true);
                        return;
                    }
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        int line = 1;
        int[] lineRange = method.getMethodLineRange();
        if (lineRange != null) {
            line = lineRange[0];
        }
        DebugClassInfo clazz = method.getClassInfo();
        this.showSourceFile(clazz, clazz.getPrimarySourceFilename(), line, false);
    }

    protected void showSourceFile(DebugFieldInfo field) {
        try {
            JavaField javaField;
            SourceClass sourceClass;
            String className = field.getDeclaringClassInfo().getName();
            String fieldName = field.getName();
            Project jproject = this.getJProject();
            JavaManager javaManager = JavaManager.getJavaManager((Project)jproject);
            JavaClass javaClass = javaManager.getClass(className);
            if (javaClass != null && (sourceClass = (SourceClass)javaClass.getSourceElement()) != null && (javaField = sourceClass.getDeclaredField(fieldName)) instanceof SourceElement) {
                SourceName sourceName;
                SourceElement sourceField = (SourceElement)javaField;
                URL url = sourceClass.getURL();
                int line = -sourceField.getStartOffset();
                if (sourceField instanceof SourceHasName && (sourceName = ((SourceHasName)sourceField).getNameElement()) != null) {
                    line = -sourceName.getStartOffset();
                }
                Source.showSourceFile(this.getWorkspace(), this.getProject(), url, line, true);
                return;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        DebugClassInfo clazz = field.getDeclaringClassInfo();
        this.showSourceFile(clazz, clazz.getPrimarySourceFilename(), 1, false);
    }

    protected void showSourceFile(DebugClassInfo clazz) {
        try {
            SourceClass sourceClass;
            String className = clazz.getName();
            Project jproject = this.getJProject();
            JavaManager javaManager = JavaManager.getJavaManager((Project)jproject);
            JavaClass javaClass = javaManager.getClass(className);
            if (javaClass != null && (sourceClass = (SourceClass)javaClass.getSourceElement()) != null) {
                URL url = sourceClass.getURL();
                SourceName sourceName = sourceClass.getNameElement();
                int line = sourceName != null ? -sourceName.getStartOffset() : -sourceClass.getStartOffset();
                Source.showSourceFile(this.getWorkspace(), this.getProject(), url, line, true);
                return;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        DebugMethodInfo[] methods = clazz.getMethods();
        if (methods != null) {
            int methodsLength = methods.length;
            DebugLocation firstLocation = null;
            int i = 0;
            while (i < methodsLength) {
                DebugLocation location = methods[i].getFirstLocation();
                if (location != null) {
                    int line = location.getLine();
                    if (firstLocation == null || line != 0 && line < firstLocation.getLine()) {
                        firstLocation = location;
                    }
                }
                ++i;
            }
            if (firstLocation != null) {
                this.showSourceFile(firstLocation, false);
                return;
            }
        }
        this.showSourceFile(clazz, clazz.getPrimarySourceFilename(), 1, false);
    }

    private Node findSourceFile(DebugClassInfo clazz, String filename) {
        try {
            if (clazz != null && filename != null && filename.length() > 0) {
                Node node;
                String pkg = clazz.getPackage();
                Workspace workspace = this.getWorkspace();
                Project project = this.getProject();
                URL url = null;
                if (this.databaseDebugging) {
                    url = this.databaseDebuggingHelper.findSourceFile(workspace, project, pkg, filename);
                }
                if (this.jsMozillaFireFoxDebugging && this.vm != null) {
                    url = ((DebugMozillaFireFoxJavaScript)this.vm).findSourceFile(clazz, filename);
                }
                if (url == null) {
                    url = Source.findSourceFile(workspace, project, pkg, filename);
                }
                if (url != null && (node = NodeFactory.findOrCreate((URL)url)) != null) {
                    Node node2 = node;
                    return node2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected Node showSourceFile(DebugClassInfo clazz, String filename, int line, boolean selectLine) {
        return this.showSourceFile(clazz, filename, line, selectLine, null);
    }

    protected Node showSourceFile(DebugClassInfo clazz, String filename, int line, boolean selectLine, String sourceNotFoundMessage) {
        if (clazz != null) {
            Node node = this.findSourceFile(clazz, filename);
            if (node != null && Source.showSourceFile(this.getWorkspace(), this.getProject(), node, line, selectLine)) {
                return node;
            }
            Source.showSourceFile(this.getWorkspace(), this.getProject(), clazz.getPackage(), clazz.getName(), this.jsMozillaFireFoxDebugging ? clazz.getName() : filename, line, selectLine, sourceNotFoundMessage, this.vm);
        }
        return null;
    }

    private void showXSLTInput() {
        try {
            if (this.xsltInputNode != null) {
                Source.showNodeInDefaultEditor(this.getWorkspace(), this.getProject(), this.xsltInputNode);
            }
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
    }

    private void showXSLTOutput() {
        try {
            CodeEditor codeEditor;
            if (this.xsltOutputNode != null) {
                if (this.xsltOutputNode.isOpen()) {
                    RevertNodeCommand.reload((Node)this.xsltOutputNode);
                }
                if (this.xsltOutputEditor == null) {
                    this.xsltOutputEditor = Source.showNodeInDefaultEditor(this.getWorkspace(), this.getProject(), this.xsltOutputNode);
                }
            }
            if (this.xsltOutputEditor instanceof CodeEditor && (codeEditor = (CodeEditor)this.xsltOutputEditor).getGUI() != null && codeEditor.isVisible()) {
                codeEditor.gotoLine(codeEditor.getLineCount(), 0, false);
            }
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
    }

    private void showSourceIPIcon(boolean openCodeEditor) {
        this.showSourceIPIcon(openCodeEditor, null);
    }

    private void showSourceIPIcon(boolean openCodeEditor, String sourceNotFoundMessage) {
        boolean javaLineNotAvailable = false;
        try {
            if (this.currentLocation != null) {
                int line = this.currentLocation.getLine();
                if (line > 0) {
                    DebugClassInfo clazz = this.currentLocation.getClassInfo();
                    String filename = this.currentLocation.getFilename();
                    Node node = null;
                    node = openCodeEditor ? this.showSourceFile(clazz, filename, line, false, sourceNotFoundMessage) : this.findSourceFile(clazz, filename);
                    if (filename.length() > 0) {
                        String pkg = clazz.getPackage();
                        Workspace workspace = this.getWorkspace();
                        URL workspaceURL = workspace != null && workspace != Ide.getDefaultWorkspace() ? workspace.getURL() : null;
                        this.sourceIconForIP = new SourceIcon(workspaceURL, null, pkg, filename, line, node, DbgArb.getInstance(), 247, SourceIcon.ipStyle, 2, null);
                    }
                } else {
                    javaLineNotAvailable = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.showSourceIconForIPBytecode(openCodeEditor && javaLineNotAvailable);
    }

    void showSourceIconForIPBytecode(boolean openBytecode) {
        block5: {
            try {
                int line;
                URL url;
                int offset;
                BytecodeFileSystemHelper bytecodeHelper;
                if (this.sourceIconForIPBytecode != null || this.currentLocation == null || (bytecodeHelper = BytecodeFileSystemHelper.getInstance(false)) == null || (offset = this.currentLocation.getBytecodeOffset()) == -1) break block5;
                DebugMethodInfo method = this.currentLocation.getMethod();
                if (openBytecode) {
                    this.showBytecode(method, offset);
                    if (this.sourceIconForIPBytecode != null) {
                        return;
                    }
                }
                if ((url = bytecodeHelper.getURL(this, method)) == null || (line = bytecodeHelper.getLineFromBytecodeOffset(url, offset)) == 0) break block5;
                Node node = NodeFactory.find((URL)url);
                Workspace workspace = this.getWorkspace();
                URL workspaceURL = workspace != null && workspace != Ide.getDefaultWorkspace() ? workspace.getURL() : null;
                this.sourceIconForIPBytecode = new SourceIcon(workspaceURL, null, url, line, node, DbgArb.getInstance(), 247, SourceIcon.ipStyle, 2, null);
                if (node == null) break block5;
                Context context = Context.newIdeContext((Node)node);
                Project project = this.getProject();
                List editors = EditorManager.getEditorManager().findEditors(context);
                if (editors == null) break block5;
                for (Object o : editors) {
                    if (!(o instanceof CodeEditor)) continue;
                    Source.showSourceFile(workspace, project, node, line, false);
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    SourceIcon getSourceIconForIP() {
        return this.sourceIconForIP;
    }

    void showBytecode(DebugMethodInfo method, int offset) {
        BytecodeFileSystemHelper bytecodeHelper = BytecodeFileSystemHelper.getInstance(true);
        URL url = bytecodeHelper.addMethod(this, method);
        try {
            Node node = NodeFactory.findOrCreate((URL)url);
            if (node != null) {
                Workspace workspace = this.getWorkspace();
                Project project = this.getProject();
                int line = bytecodeHelper.getLineFromBytecodeOffset(url, offset);
                Source.showSourceFile(workspace, project, node, line, false);
                this.showSourceIconForIPBytecode(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void hideSourceIPIcon() {
        if (this.sourceIconForIP != null) {
            this.sourceIconForIP.hide();
            this.sourceIconForIP = null;
        }
        if (this.sourceIconForIPBytecode != null) {
            this.sourceIconForIPBytecode.hide();
            this.sourceIconForIPBytecode = null;
        }
    }

    private void debuggeeResuming(boolean stepping, boolean aboutToDisconnect) {
        int handle = -1;
        if (ProfilingEvents.eventOn[6]) {
            handle = IdeProfile.startEvent((int)ProfilingEvents.eventId[6]);
        }
        if (this.timerTaskUpdateNormalWindows != null) {
            this.timerTaskUpdateNormalWindows.cancel();
            this.timerTaskUpdateNormalWindows = null;
        }
        if (this.timerTaskUpdateOtherWindows != null) {
            this.timerTaskUpdateOtherWindows.cancel();
            this.timerTaskUpdateOtherWindows = null;
        }
        this.stepRequestTime = 0L;
        this.resuming = true;
        JDebugger jdebugger = JDebugger.getInstance();
        if (jdebugger.isActiveDebuggingProcess(this)) {
            this.hideSourceIPIcon();
            ThreadsWindow threadsWindow = jdebugger.getThreadsWindow(true);
            SmartWindow smartWindow = jdebugger.getSmartWindow(false);
            ClassesWindow classesWindow = jdebugger.getClassesWindow(false);
            HeapWindow heapWindow = jdebugger.getHeapWindow(false);
            MonitorsWindow monitorsWindow = jdebugger.getMonitorsWindow(false);
            if (aboutToDisconnect) {
                threadsWindow.updateThreads(this, null, null);
                if (smartWindow != null) {
                    smartWindow.updateData(this, null, null, null);
                }
                if (classesWindow != null) {
                    classesWindow.updateClasses(this, null);
                }
                if (heapWindow != null) {
                    heapWindow.updateData(this, null, null, null);
                }
                if (monitorsWindow != null) {
                    monitorsWindow.updateMonitors(this, null);
                }
            } else {
                threadsWindow.clearThreads();
                if (smartWindow != null) {
                    smartWindow.clearData();
                }
                if (classesWindow != null) {
                    classesWindow.clearClasses();
                }
                if (heapWindow != null) {
                    heapWindow.clearData();
                }
                if (monitorsWindow != null) {
                    monitorsWindow.clearMonitors();
                }
            }
        }
        this.currentThread = null;
        this.currentStackFrame = null;
        this.currentLocation = null;
        this.deadlocks = null;
        this.stepping = stepping;
        if (ProfilingEvents.eventOn[6]) {
            IdeProfile.endEvent((int)handle);
        }
    }

    private void debuggeeResumed() {
        this.resuming = false;
        this.stopped = false;
        this.checkCommands();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activeProgramStopped() {
        DebuggingProcess.clearStatus();
        if (this.xsltDebugging) {
            this.showXSLTOutput();
        }
        boolean useTimerToUpdateOtherWindows = true;
        boolean[] blArray = this.pause;
        synchronized (this.pause) {
            if (this.runAfterPausedList.size() > 0) {
                useTimerToUpdateOtherWindows = false;
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            try {
                this.debuggeeStopped(useTimerToUpdateOtherWindows);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.doRunAfterPause(true);
            return;
        }
    }

    private void debuggeeStopped(boolean useTimerToUpdateOtherWindows) {
        DebugBreakpoint debugBreakpoint;
        int handle = -1;
        if (ProfilingEvents.eventOn[1]) {
            handle = IdeProfile.startEvent((int)ProfilingEvents.eventId[1]);
        }
        this.stopped = true;
        if (this.runToCursor != null) {
            this.runToCursor.remove();
            this.runToCursor = null;
        }
        if ((debugBreakpoint = this.vm.getCurrentBreakpoint()) != null) {
            JDebugger.getInstance().debuggeeStoppedAtBreakpoint(debugBreakpoint);
        }
        Ide.getMainWindow().toFront();
        try {
            this.setCurrentThread(this.vm.getCurrentThread(), false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JDebugger jdebugger = JDebugger.getInstance();
        int status = this.vm.getCurrentStatus();
        BytecodeFileSystemHelper bytecodeHelper = BytecodeFileSystemHelper.getInstance(false);
        if (bytecodeHelper != null) {
            bytecodeHelper.updateMethods(this);
        }
        if (jdebugger.isActiveDebuggingProcess(this)) {
            try {
                boolean openCodeEditor = true;
                String sourceNotFoundMessage = null;
                switch (status) {
                    case 1: {
                        sourceNotFoundMessage = DbgArb.getString(846);
                        break;
                    }
                    case 2: {
                        sourceNotFoundMessage = DbgArb.getString(175);
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 5: {
                        sourceNotFoundMessage = DbgArb.getString(724);
                        break;
                    }
                    case 7: {
                        sourceNotFoundMessage = DbgArb.getString(385);
                        break;
                    }
                    case 8: {
                        openCodeEditor = false;
                        break;
                    }
                    case 10: {
                        sourceNotFoundMessage = DbgArb.getString(475);
                        break;
                    }
                }
                this.showSourceIPIcon(openCodeEditor, sourceNotFoundMessage);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (status != 8 && this.currentLocation != null && !this.isLocationDebuggable() && this.vm.getCapabilities().canSetDebuggablePackages()) {
                    String message = DbgArb.format(111, this.runConfiguration.getName(), DbgArb.getString(118));
                    message = message + DbgArb.getString(181);
                    if (!this.runConfiguration.isCustom()) {
                        message = message + DbgArb.format(83, this.runConfiguration.getName());
                    }
                    message = message + DbgArb.getString(103);
                    String title = this.getLogPage().getTitleName();
                    boolean answer = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)message, (String)title, null);
                    if (answer) {
                        DebugConfiguration debugConfiguration = this.getDebugConfiguration();
                        TracingPanel.showTracingDialog(debugConfiguration);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                this.checkCommands();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                this.classLoadTracking();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            switch (status) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 10: {
                    this.sendDebuggerEvent(2, 200);
                    break;
                }
                case 7: {
                    this.sendDebuggerEvent(2, 201);
                    break;
                }
                case 8: {
                    this.sendDebuggerEvent(2, 202);
                    break;
                }
            }
            try {
                boolean bl = this.timeWindowsUpdated != 0L && false;
                this.updateNormalWindows();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (this.timeWindowsUpdated != 0L && useTimerToUpdateOtherWindows) {
                    this.timerTaskUpdateOtherWindows = new 14();
                    if (timer == null) {
                        timer = new NamedTimer("DebuggingProcessTimer");
                    }
                    timer.schedule(this.timerTaskUpdateOtherWindows, 500L);
                } else {
                    this.updateOtherWindows();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            if (status == 5) {
                jdebugger.viewMonitors();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.timeWindowsUpdated == 0L) {
            this.timeWindowsUpdated = System.currentTimeMillis();
            long timeAfterCompile = this.getTimeAfterCompile();
            Assert.println((String)"Time to debug and hit breakpoint:");
            Assert.println((String)("    " + IdeUtil.prepad((String)Long.toString(this.timeProgramStopped - timeAfterCompile), (char)' ', (int)6) + " ms (measured from compiler finished to breakpoint hit)"));
            Assert.println((String)("    " + IdeUtil.prepad((String)Long.toString(this.timeWindowsUpdated - this.timeProgramStopped), (char)' ', (int)6) + " ms (measured from breakpoint hit to debugger windows updated)"));
            Assert.println((String)"    ---------");
            Assert.println((String)("    " + IdeUtil.prepad((String)Long.toString(this.timeWindowsUpdated - timeAfterCompile), (char)' ', (int)6) + " ms (total measured from compiler finished to debugger windows updated)"));
        }
        if (this.checkForPotentialClipboardDeadlock()) {
            this.resume();
        }
        if (ProfilingEvents.eventOn[1]) {
            IdeProfile.endEvent((int)handle);
        }
    }

    private void updateNormalWindows() {
        JDebugger jdebugger = JDebugger.getInstance();
        try {
            jdebugger.getThreadsWindow(true).updateThreads(this, this.vm, this.currentThread);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            SmartWindow smartWindow = jdebugger.getSmartWindow(false);
            if (smartWindow != null) {
                smartWindow.updateData(this, this.vm, this.currentThread, this.currentStackFrame);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateNormalWindowsEndTime = System.currentTimeMillis();
    }

    private void updateOtherWindows() {
        MonitorsWindow monitorsWindow;
        HeapWindow heapWindow;
        JDebugger jdebugger = JDebugger.getInstance();
        ClassesWindow classesWindow = jdebugger.getClassesWindow(false);
        if (classesWindow != null) {
            classesWindow.updateClasses(this, this.vm);
        }
        if ((heapWindow = jdebugger.getHeapWindow(false)) != null) {
            heapWindow.updateData(this, this.vm, null, null);
        }
        if ((monitorsWindow = jdebugger.getMonitorsWindow(false)) != null) {
            monitorsWindow.updateMonitors(this, this.vm);
        }
    }

    private void classLoadTracking() {
        if (classLoadTracking == -1) {
            String debuggerClassLoadTracking = Ide.getProperty((String)"DebuggerClassLoadTracking");
            classLoadTracking = debuggerClassLoadTracking != null ? DebuggingProcess.parsePrint(debuggerClassLoadTracking) : 0;
        }
        if (classLoadTracking != 0 && this.vm.countClasses() != this.loadedClassesCount) {
            DebugClassInfo[] loadedClasses = this.vm.listClasses();
            int loadedClassesLength = loadedClasses.length;
            String s = this.loadedClassesCount == 0 ? DbgArb.format(154, Integer.toString(loadedClassesLength)) : DbgArb.format(496, Integer.toString(loadedClassesLength - this.loadedClassesCount));
            this.print(classLoadTracking, s);
            int length = loadedClassesLength - this.loadedClassesCount;
            Object[] classNames = new String[length];
            int i = 0;
            while (i < length) {
                classNames[i] = loadedClasses[i + this.loadedClassesCount].getName();
                ++i;
            }
            Arrays.sort(classNames);
            int i2 = 0;
            while (i2 < length) {
                s = DbgArb.format(560, classNames[i2]);
                this.print(classLoadTracking, s);
                ++i2;
            }
            this.loadedClassesCount = loadedClassesLength;
            if (this.currentLocation != null) {
                String filename = this.currentLocation.getFilename();
                int line = this.currentLocation.getLine();
                s = DbgArb.format(694, Integer.toString(line), filename, Integer.toString(this.loadedClassesCount));
            } else {
                s = DbgArb.format(485, Integer.toString(this.loadedClassesCount));
            }
            this.print(classLoadTracking, s);
        }
    }

    private static int parsePrint(String s) {
        int print = 0;
        StringTokenizer st = new StringTokenizer(s, ",;| \t");
        while (st.hasMoreTokens()) {
            s = st.nextToken();
            if (s.equalsIgnoreCase("System.out")) {
                print |= 1;
                continue;
            }
            if (s.equalsIgnoreCase("System.err")) {
                print |= 2;
                continue;
            }
            if (!s.equalsIgnoreCase("LogWindow")) continue;
            print |= 4;
        }
        return print;
    }

    private void print(int print, String s) {
        if ((print & 1) != 0) {
            System.out.println(s);
        }
        if ((print & 2) != 0) {
            System.err.println(s);
        }
        if ((print & 4) != 0) {
            this.log(s);
        }
    }

    protected void checkCommands() {
        JDebugger.getInstance().checkCommandsBecauseDebuggingProcessStateChanged(this);
    }

    public boolean canPause() {
        return this.pause(false);
    }

    protected void pause() {
        this.pause(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean pause(boolean doIt) {
        try {
            if (this.vm == null) return false;
            if (this.stopped) return false;
            if (!this.vm.getCapabilities().canPauseProgram()) return false;
            if (!doIt) return true;
            boolean[] blArray = this.pause;
            synchronized (this.pause) {
                this.pause[1] = true;
                // ** MonitorExit[var3_2] (shouldn't be in output)
                this.vm.pauseProgram();
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    boolean canResume() {
        return this.resume(false);
    }

    protected void resume() {
        this.resume(true);
    }

    private boolean resume(boolean doIt) {
        try {
            if (this.vm != null && this.stopped) {
                if (doIt) {
                    this.sendDebuggerEvent(3, 300);
                    this.debuggeeResuming(false, false);
                    this.vm.resume();
                    this.debuggeeResumed();
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    boolean canDetach() {
        return this.detach(false);
    }

    void detach() {
        this.detach(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean detach(boolean doIt) {
        block8: {
            if (this.detachStartedProcesses != null) {
                for (DebuggingProcess debProc : this.detachStartedProcesses) {
                    if (debProc == null) continue;
                    debProc.detach();
                }
            }
            try {
                if (this.vm == null || !this.isRemoteAttachment()) break block8;
                if (doIt) {
                    this.sendDebuggerEvent(4, 403);
                    this.debuggeeResuming(false, true);
                    this.vm.disconnect(false);
                    Object object = this.vmSync;
                    synchronized (object) {
                        this.vm = null;
                    }
                    this.finished();
                }
                boolean bl = true;
                return bl;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    boolean canStepOver() {
        try {
            boolean bl = this.vm != null && this.stopped && this.currentThread != null && DebuggingProcess.isThreadGood(this.currentThread) && this.isLocationDebuggable();
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    void stepOver(long time) {
        if (this.canStepOver()) {
            DebugThreadInfo thread = this.currentThread;
            this.sendDebuggerEvent(3, 301);
            this.debuggeeResuming(true, false);
            this.stepRequestTime = time;
            thread.stepOver();
            this.debuggeeResumed();
        }
    }

    void stepOverBC(long time) {
        if (this.canStepOver()) {
            DebugThreadInfo thread = this.currentThread;
            this.sendDebuggerEvent(3, 301);
            this.debuggeeResuming(true, false);
            this.stepRequestTime = time;
            thread.stepOverBC();
            this.debuggeeResumed();
        }
    }

    boolean canStepInto() {
        try {
            boolean bl = this.vm != null && this.stopped && this.currentThread != null && DebuggingProcess.isThreadGood(this.currentThread);
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    void stepInto(long time) {
        if (this.canStepInto()) {
            DebugThreadInfo thread = this.currentThread;
            this.sendDebuggerEvent(3, 302);
            this.debuggeeResuming(true, false);
            this.stepRequestTime = time;
            thread.stepInto();
            this.debuggeeResumed();
        }
    }

    void stepIntoBC(long time) {
        if (this.canStepInto()) {
            DebugThreadInfo thread = this.currentThread;
            this.sendDebuggerEvent(3, 302);
            this.debuggeeResuming(true, false);
            this.stepRequestTime = time;
            thread.stepIntoBC();
            this.debuggeeResumed();
        }
    }

    boolean canStepOut() {
        try {
            boolean bl = this.vm != null && this.stopped && this.currentThread != null && DebuggingProcess.isThreadGood(this.currentThread);
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    void stepOut(long time) {
        if (this.canStepOut()) {
            DebugThreadInfo thread = this.currentThread;
            this.sendDebuggerEvent(3, 303);
            this.debuggeeResuming(true, false);
            this.stepRequestTime = time;
            thread.stepOut();
            this.debuggeeResumed();
        }
    }

    boolean canStepToEndOfMethod() {
        try {
            boolean bl = this.vm != null && this.stopped && this.vm.getCapabilities().canStepToEndOfMethod() && this.currentThread != null && DebuggingProcess.isThreadGood(this.currentThread) && this.isLocationDebuggable();
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    void stepToEndOfMethod(long time) {
        if (this.canStepToEndOfMethod()) {
            DebugThreadInfo thread = this.currentThread;
            this.sendDebuggerEvent(3, 304);
            this.debuggeeResuming(true, false);
            this.stepRequestTime = time;
            thread.stepToEndOfMethod();
            this.debuggeeResumed();
        }
    }

    boolean canContinueStep() {
        if (this.xsltDebugging) {
            return false;
        }
        try {
            boolean bl = this.vm != null && this.stopped && this.vm.getCapabilities().canContinueStep() && this.stepping && !this.vm.didStepFinish();
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    void continueStep() {
        if (this.canContinueStep()) {
            this.sendDebuggerEvent(3, 305);
            this.debuggeeResuming(true, false);
            this.vm.continueStep();
            this.debuggeeResumed();
        }
    }

    boolean canRunToCursor(Context context) {
        return this.runToCursor(false, context);
    }

    void runToCursor(Context context) {
        this.runToCursor(true, context);
    }

    private boolean runToCursor(boolean doIt, Context context) {
        try {
            String[] packageAndFile;
            int editorLine;
            Node editorNode;
            DebugLocation location;
            if (this.vm != null && this.stopped && this.currentThread != null && DebuggingProcess.isThreadGood(this.currentThread) && (location = this.currentLocation) != null && (editorNode = Source.getNodeFromCodeEditor(context)) != null && (editorLine = Source.getLineFromCodeEditor(context)) != 0 && (packageAndFile = this.node_to_packageAndFile(editorNode)) != null && packageAndFile.length == 2) {
                if (doIt) {
                    String editorPackage = packageAndFile[0];
                    String editorFilename = packageAndFile[1];
                    this.runToCursor = this.vm.putBreakpointPackageFileLine(editorPackage, editorFilename, editorLine);
                    if (this.runToCursor != null) {
                        this.sendDebuggerEvent(3, 306);
                        this.debuggeeResuming(false, false);
                        this.vm.resume();
                        this.debuggeeResumed();
                    }
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    boolean canStepIntoMethod(Context context) {
        return this.stepIntoMethod(false, context);
    }

    void stepIntoMethod(Context context) {
        this.stepIntoMethod(true, context);
    }

    private boolean stepIntoMethod(boolean doIt, Context context) {
        try {
            CodeEditor codeEditor;
            if (this.vm != null && this.stopped && context != null && this.currentLocation != null && this.currentThread != null && DebuggingProcess.isThreadGood(this.currentThread) && (codeEditor = Source.getCodeEditorFromContext(context)) != null && this.codeEditorHasIP(codeEditor)) {
                SourceElement sourceElement;
                JavaManager javaManager;
                SourceFile sourceFile;
                int caretPosition = codeEditor.getCaretPosition();
                int executableLine = this.getExecutableLineAtCaret(codeEditor.getCaretLine());
                Node editorNode = Source.getNodeFromCodeEditor(context);
                String[] packageAndFile = this.node_to_packageAndFile(editorNode);
                if (packageAndFile != null && packageAndFile.length == 2 && executableLine > 0 && (sourceFile = (javaManager = JavaManager.getJavaManager((Project)this.getJProject())).getSourceFile(editorNode.getURL())) != null && (sourceElement = sourceFile.getElementAt(caretPosition)) instanceof SourceName) {
                    SourceElement parent;
                    String methodName = null;
                    if ((sourceElement = sourceElement.getParent()) instanceof SourceMethodCallExpression) {
                        SourceMethodCallExpression expr = (SourceMethodCallExpression)sourceElement;
                        methodName = expr.getName();
                    } else if (sourceElement instanceof TypeSym && (parent = sourceElement.getParent()) instanceof ClassCreatorExpr) {
                        methodName = "<init>" + ((TypeSym)sourceElement).getName();
                    }
                    if (methodName != null) {
                        if (doIt) {
                            DebugThreadInfo thread = this.currentThread;
                            this.sendDebuggerEvent(3, 307);
                            this.debuggeeResuming(true, false);
                            thread.stepIntoMethod(methodName, packageAndFile[0], packageAndFile[1], executableLine);
                            this.debuggeeResumed();
                        }
                        boolean bl = true;
                        return bl;
                    }
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    private boolean codeEditorHasIP(CodeEditor codeEditor) {
        Object ipEditor = null;
        SourceIcon sourceIconForIP = this.getSourceIconForIP();
        if (sourceIconForIP != null) {
            return codeEditor == sourceIconForIP.getCodeEditor();
        }
        return false;
    }

    private int getExecutableLineAtCaret(int caretLine) {
        DebugMethodInfo method = this.currentLocation.getMethod();
        int[] executableLines = method.getMethodLines();
        int len = executableLines.length - 1;
        if (executableLines.length > 0 && executableLines[0] <= caretLine && executableLines[len] >= caretLine) {
            int x = len;
            while (x >= 0) {
                if (caretLine >= executableLines[x]) {
                    return executableLines[x];
                }
                --x;
            }
        }
        return -1;
    }

    boolean canSetNextStatement(Context context) {
        return this.setNextStatement(false, context);
    }

    void setNextStatement(Context context) {
        this.setNextStatement(true, context);
    }

    private boolean setNextStatement(boolean doIt, Context context) {
        try {
            String[] packageAndFile;
            int editorLine;
            Node editorNode;
            DebugLocation location;
            DebugCapabilities capabilities;
            if (this.vm != null && this.stopped && (capabilities = this.vm.getCapabilities()).canSetLocation() && this.currentThread != null && DebuggingProcess.isThreadGood(this.currentThread) && (location = this.currentLocation) != null && (editorNode = Source.getNodeFromCodeEditor(context)) != null && (editorLine = Source.getLineFromCodeEditor(context)) != 0 && (packageAndFile = this.node_to_packageAndFile(editorNode)) != null && packageAndFile.length == 2) {
                String editorPackage = packageAndFile[0];
                String locationPackage = location.getClassInfo().getPackage();
                if (Source.packageMatches(locationPackage, editorPackage)) {
                    DebugMethodInfo method;
                    DebugLocation newLocation;
                    int locationLine;
                    String editorFilename = packageAndFile[1];
                    String locationFilename = location.getFilename();
                    if (locationFilename.equals(editorFilename) && editorLine != (locationLine = location.getLine()) && (newLocation = (method = location.getMethod()).getLocation(editorFilename, editorLine)) != null) {
                        SourceSynchStatement editorSync;
                        CodeEditor codeEditor = Source.getCodeEditorFromContext(context);
                        JavaManager javaManager = JavaManager.getJavaManager((Project)this.getJProject());
                        SourceFile sourceFile = javaManager.getSourceFile(editorNode.getURL());
                        SourceSynchStatement locationSync = this.getSourceSynchStatement(sourceFile, JDebugger.getLineStartOffsetSkipWhite(codeEditor, locationLine));
                        if (ModelUtil.areEqual((Object)locationSync, (Object)(editorSync = this.getSourceSynchStatement(sourceFile, JDebugger.getLineStartOffsetSkipWhite(codeEditor, editorLine))))) {
                            if (doIt && this.currentThread.setLocation(newLocation)) {
                                this.hideSourceIPIcon();
                                this.currentStackFrame = DebuggingProcess.getNonNativeStackFrame(this.currentThread);
                                this.currentLocation = this.currentStackFrame != null ? this.currentStackFrame.getLocation() : null;
                                this.showSourceIPIcon(true);
                                JDebugger jdebugger = JDebugger.getInstance();
                                jdebugger.getThreadsWindow(true).updateThreads(this, this.vm, this.currentThread);
                                SmartWindow smartWindow = jdebugger.getSmartWindow(false);
                                if (smartWindow != null) {
                                    smartWindow.updateData(this, this.vm, this.currentThread, this.currentStackFrame);
                                }
                            }
                            boolean bl = true;
                            return bl;
                        }
                        if (locationSync != null) {
                            System.out.println("locationSync is from " + locationSync.getStartOffset() + " to " + locationSync.getEndOffset());
                        } else {
                            System.out.println("locationSync is null");
                        }
                        if (editorSync != null) {
                            System.out.println("editorSync is from " + editorSync.getStartOffset() + " to " + editorSync.getEndOffset());
                        } else {
                            System.out.println("editorSync is null");
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    private SourceSynchStatement getSourceSynchStatement(SourceFile sourceFile, int offset) {
        if (sourceFile != null) {
            SourceElement sourceElement = sourceFile.getElementAt(offset);
            while (sourceElement != null) {
                SourceSynchStatement sourceSynchStatement;
                SourceStatement primaryClause;
                if (sourceElement instanceof SourceSynchStatement && (primaryClause = (sourceSynchStatement = (SourceSynchStatement)sourceElement).getPrimaryClause()) != null && primaryClause.getStartOffset() <= offset && offset < primaryClause.getEndOffset()) {
                    return sourceSynchStatement;
                }
                sourceElement = sourceElement.getParent();
            }
        }
        return null;
    }

    boolean canShowIP() {
        try {
            boolean bl = this.vm != null && this.stopped && this.currentLocation != null && this.currentLocation.getLine() > 0;
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    void showIP() {
        if (this.canShowIP()) {
            this.showSourceFile(this.currentLocation, false);
        }
    }

    boolean canGC() {
        try {
            boolean bl = this.vm != null && this.stopped && this.vm.getCapabilities().canDoGarbageCollection();
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    void gc() {
        if (this.canGC()) {
            this.vm.doGarbageCollection();
            JDebugger.getInstance().dataHasBeenModified();
        }
    }

    void redefineClasses(Map nameToGuts) {
        if (this.vm != null) {
            if (this.vm.getCapabilities().canRedefineClasses()) {
                String[] errors = this.vm.redefineClasses(nameToGuts);
                if (errors == null) {
                    this.log(DbgArb.getString(76));
                    DebuggingProcess.showStatus(DbgArb.getString(76));
                    this.suggestPopFrame(nameToGuts);
                } else {
                    SwingUtilities.invokeLater(new 15());
                    this.log(DbgArb.getString(266));
                    DebuggingProcess.showStatus(DbgArb.getString(266));
                    int errorsLength = errors.length;
                    int i = 0;
                    while (i < errorsLength) {
                        this.log("    " + errors[i] + "\n");
                        ++i;
                    }
                }
            } else {
                this.log(DbgArb.getString(863));
                DebuggingProcess.showStatus(DbgArb.getString(863));
            }
        }
    }

    private void suggestPopFrame(Map nameToGuts) {
        if (this.vm != null && this.vm.getCurrentStatus() != 8) {
            ArrayList<String> logged = new ArrayList<String>();
            boolean suggestPopFrame = true;
            if (this.currentThread != null) {
                DebugStackFrameInfo[] stack = this.currentThread.listStack();
                int stackLength = stack.length;
                int istack = 0;
                while (istack < stackLength) {
                    String className;
                    DebugClassInfo clazz;
                    DebugLocation location = stack[istack].getLocation();
                    if (location != null && (clazz = location.getClassInfo()) != null && nameToGuts.containsKey(className = clazz.getName())) {
                        String niceClassName = DebugShared.makeCourtesyClassName(clazz, true);
                        String s = DbgArb.format(522, this.currentThread.getName(), niceClassName);
                        if (!logged.contains(s)) {
                            this.log(s);
                            logged.add(s);
                            if (stackLength == 1) {
                                suggestPopFrame = false;
                            }
                        }
                    }
                    ++istack;
                }
            }
            if (!logged.isEmpty()) {
                if (suggestPopFrame) {
                    this.log(DbgArb.getString(798));
                } else {
                    this.log(DbgArb.getString(186));
                }
            }
        }
    }

    void classesWindowCreated(ClassesWindow classesWindow) {
        if (classesWindow != null) {
            if (this.vm != null && this.stopped) {
                classesWindow.updateClasses(this, this.vm);
            } else {
                classesWindow.updateClasses(this, null);
            }
        }
    }

    void smartWindowCreated(SmartWindow smartWindow) {
        if (smartWindow != null) {
            if (this.vm != null && this.stopped) {
                smartWindow.updateData(this, this.vm, this.currentThread, this.currentStackFrame);
            } else {
                smartWindow.updateData(this, null, null, null);
            }
        }
    }

    void heapWindowCreated(HeapWindow heapWindow) {
        if (heapWindow != null) {
            if (this.vm != null && this.stopped) {
                heapWindow.updateData(this, this.vm, null, null);
            } else {
                heapWindow.updateData(this, null, null, null);
            }
        }
    }

    void monitorsWindowCreated(MonitorsWindow monitorsWindow) {
        if (monitorsWindow != null) {
            if (this.vm != null && this.stopped) {
                monitorsWindow.updateMonitors(this, this.vm);
            } else {
                monitorsWindow.updateMonitors(this, null);
            }
        }
    }

    private int getDebuggerFactory() {
        if (this.isRemoteDebuggingProfiling()) {
            DebugConfiguration debugConfiguration = this.getDebugConfiguration();
            String protocol = debugConfiguration.getRemoteProtocol();
            return DebugConfiguration.getDebuggerFactory(protocol);
        }
        if (this.databaseDebugging) {
            return this.databaseDebuggingHelper.getDebuggerFactory();
        }
        if (this.jsMozillaFireFoxDebugging) {
            return 4;
        }
        if (this.xsltDebugging) {
            return 0;
        }
        if (this.antDebugging) {
            return 3;
        }
        return 0;
    }

    static DebugLocation getNonNativeLocation(DebugThreadInfo thread) {
        DebugStackFrameInfo[] frames = thread.listStack();
        return DebuggingProcess.getNonNativeLocation(frames);
    }

    static DebugLocation getNonNativeLocation(DebugStackFrameInfo[] frames) {
        DebugStackFrameInfo stackFrame = DebuggingProcess.getNonNativeStackFrame(frames);
        if (stackFrame != null) {
            return stackFrame.getLocation();
        }
        return null;
    }

    static DebugStackFrameInfo getNonNativeStackFrame(DebugThreadInfo thread) {
        DebugStackFrameInfo[] frames = thread.listStack();
        return DebuggingProcess.getNonNativeStackFrame(frames);
    }

    static DebugStackFrameInfo getNonNativeStackFrame(DebugStackFrameInfo[] frames) {
        int framesLength = frames.length;
        int i = 0;
        while (i < framesLength) {
            DebugMethodInfo method;
            DebugLocation location;
            DebugStackFrameInfo stackFrame = frames[i];
            if (stackFrame != null && (location = stackFrame.getLocation()) != null && !Modifier.isNative((method = location.getMethod()).getAccess())) {
                return stackFrame;
            }
            ++i;
        }
        return null;
    }

    static void showStatus(String text) {
        statusText = text;
        Ide.getStatusBar().setText(statusText);
    }

    static void clearStatus() {
        StatusBar statusBar = Ide.getStatusBar();
        if (statusText != null && statusText.equals(statusBar.getText())) {
            statusBar.setText("");
        }
        statusText = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runWhilePaused(RunWhilePaused runWhilePaused) {
        if (this.vm != null) {
            if (this.stopped || this.vm.getLanguages() == 16) {
                runWhilePaused.run(this, true);
            } else {
                boolean[] blArray = this.pause;
                synchronized (this.pause) {
                    this.pause[0] = true;
                    this.runWhilePausedList.add(runWhilePaused);
                    this.vm.pauseProgram();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                }
            }
        } else {
            runWhilePaused.run(this, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runAfterPaused(RunWhilePaused runAfterPaused) {
        if (this.vm != null) {
            if (this.stopped) {
                if (JDebugger.getInstance().isActiveDebuggingProcess(this)) {
                    runAfterPaused.run(this, true);
                } else {
                    16 runAfterSelected = new 16(this, runAfterPaused);
                    this.runAfterSelectedList.add(runAfterSelected);
                    Runner.getRunner().selectProcess((RunProcess)this);
                }
            } else {
                boolean[] blArray = this.pause;
                synchronized (this.pause) {
                    this.pause[0] = true;
                    this.runAfterPausedList.add(runAfterPaused);
                    this.vm.pauseProgram();
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                }
            }
        } else {
            runAfterPaused.run(this, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForInternalPause(boolean live) {
        boolean internalPauseOnly = false;
        RunWhilePaused[] runnables = null;
        boolean[] blArray = this.pause;
        synchronized (this.pause) {
            if (this.pause[0]) {
                if (live) {
                    internalPauseOnly = !this.pause[1] && this.vm.getCurrentStatus() == 8 && this.runAfterPausedList.size() == 0;
                    this.vm.cancelPauseProgram();
                }
                runnables = this.runWhilePausedList.toArray(new RunWhilePaused[this.runWhilePausedList.size()]);
                this.runWhilePausedList.clear();
                this.pause[0] = false;
            }
            // ** MonitorExit[var8_4] (shouldn't be in output)
            if (runnables != null) {
                try {
                    RunWhilePaused[] finalRunnables = runnables;
                    int length = finalRunnables.length;
                    int i = 0;
                    while (i < length) {
                        finalRunnables[i].run(this, live);
                        ++i;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (internalPauseOnly) {
                    if (this.vm.getCapabilities().canContinueStep() && this.stepping && !this.vm.didStepFinish()) {
                        this.vm.continueStep();
                    } else {
                        this.vm.resume();
                    }
                }
            }
            return internalPauseOnly;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRunAfterPause(boolean live) {
        boolean[] blArray = this.pause;
        synchronized (this.pause) {
            RunWhilePaused[] runnables = this.runAfterPausedList.toArray(new RunWhilePaused[this.runAfterPausedList.size()]);
            this.runAfterPausedList.clear();
            // ** MonitorExit[var5_2] (shouldn't be in output)
            if (runnables != null) {
                int length = runnables.length;
                int i = 0;
                while (i < length) {
                    runnables[i].run(this, live);
                    ++i;
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMessage(String message) {
        List list = this.messages;
        synchronized (list) {
            this.messages.add(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logMessages() {
        List list = this.messages;
        synchronized (list) {
            while (this.messages.size() > 0) {
                String message = (String)this.messages.remove(0);
                this.logMessage(message);
            }
        }
    }

    EvaluatorItem makeTemporaryEvaluatorItem(String name, DebugDataCompositeInfo data) {
        EvaluatorItem ei = new EvaluatorItem((String)null);
        ei.pin(this, data);
        ei.setCanUnpin(false);
        ei.setOptions(name, false, this);
        return ei;
    }

    String[] url_to_packageAndFile(URL url) {
        try {
            Node node = NodeFactory.findOrCreate((URL)url);
            String[] stringArray = this.node_to_packageAndFile(node);
            return stringArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    String[] node_to_packageAndFile(Node node) {
        try {
            String pkg = null;
            String file = null;
            if (node instanceof PackagedSource) {
                pkg = Source.getPackageFromNode(node, this.getJProject());
                file = Source.getFilenameFromNode(node);
            } else if (node instanceof AntNode) {
                if (this.antDebugging) {
                    pkg = "$org.apache.tools.ant";
                    file = URLFileSystem.getPlatformPathName((URL)node.getURL());
                }
            } else if (node instanceof XMLSourceNode) {
                URL url = node.getURL();
                if (this.xsltDebugging) {
                    pkg = XSLTRunnerAddin.getXSLTPackage(url);
                    file = URLFileSystem.getFileName((URL)url);
                } else if (this.jsMozillaFireFoxDebugging) {
                    pkg = null;
                    file = url.toString();
                }
            }
            if ((pkg != null || this.jsMozillaFireFoxDebugging) && file != null && file.length() > 0) {
                String[] packageAndFile = new String[]{pkg, file};
                String[] stringArray = packageAndFile;
                return stringArray;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    static void setDatabaseDebuggingHelperClass(Class helperClass) {
        databaseDebuggingHelperClass = helperClass;
    }

    public final void setPort(String port) {
        this.localPort = port;
    }

    final String getPort() {
        return this.localPort;
    }

    final void forceDetach() {
        if (this.vm != null) {
            this.vm.disconnect(false);
            this.vm = null;
        }
    }

    private boolean checkForPotentialClipboardDeadlock() {
        try {
            DebugDataObjectInfo contentFieldData;
            DebugDataObjectInfo clipboardFieldData;
            DebugDataObjectInfo toolkitFieldData;
            DebugClassInfo toolkitClass;
            if (this.vm != null && (toolkitClass = this.vm.findFirstClassByName("java.awt.Toolkit")) != null && (toolkitFieldData = (DebugDataObjectInfo)DebugShared.findStaticFieldData(toolkitClass, "toolkit")) != null && (clipboardFieldData = (DebugDataObjectInfo)DebugShared.findFieldData(toolkitFieldData, "clipboard")) != null && (contentFieldData = (DebugDataObjectInfo)DebugShared.findFieldData(clipboardFieldData, "contents")) != null && !contentFieldData.isNull()) {
                if (clipboardFieldData.getClassInfo().getName().equals("sun.awt.motif.X11Clipboard")) {
                    StringBuffer message = new StringBuffer();
                    message.append(DbgArb.getString(553));
                    message.append("\n\n");
                    message.append(DbgArb.format(551, Ide.getProgramShortName()));
                    message.append("\n\n");
                    message.append(DbgArb.getString(550));
                    if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)message, (String)DbgArb.getString(3), null)) {
                        boolean bl = true;
                        return bl;
                    }
                } else {
                    StringBuffer message = new StringBuffer();
                    message.append(DbgArb.getString(553));
                    message.append("\n");
                    message.append(DbgArb.format(551, Ide.getProgramShortName()));
                    message.append("\n");
                    this.log(message);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    public boolean canStopOnException() {
        if (this.vm == null) {
            return false;
        }
        return this.vm.getCapabilities().canStopOnException();
    }

    public boolean canStopOnError() {
        if (this.vm == null) {
            return false;
        }
        return this.vm.getCapabilities().canStopOnError();
    }

    public boolean canStopOnDebuggerStatement() {
        if (this.vm == null) {
            return false;
        }
        return this.vm.getCapabilities().canStopOnDebuggerStatement();
    }

    public boolean canTransferErrors() {
        if (this.vm == null) {
            return false;
        }
        return this.vm.getCapabilities().canTransferErrors();
    }

    public boolean getStopOnException() {
        if (this.vm == null) {
            return false;
        }
        return this.vm.getStopOnException();
    }

    public boolean getStopOnError() {
        if (this.vm == null) {
            return false;
        }
        return this.vm.getStopOnError();
    }

    public boolean getStopOnDebuggerStatement() {
        if (this.vm == null) {
            return false;
        }
        return this.vm.getStopOnDebuggerStatement();
    }

    public boolean getTransferErrors() {
        if (this.vm == null) {
            return false;
        }
        return this.vm.getTransferErrors();
    }

    public void setStopOnException(boolean b) {
        if (this.vm == null) {
            return;
        }
        this.vm.setStopOnException(b);
    }

    public void setStopOnError(boolean b) {
        if (this.vm == null) {
            return;
        }
        this.vm.setStopOnError(b);
    }

    public void setStopOnDebuggerStatement(boolean b) {
        if (this.vm == null) {
            return;
        }
        this.vm.setStopOnDebuggerStatement(b);
    }

    public void setTransferErrors(boolean b) {
        if (this.vm == null) {
            return;
        }
        this.vm.setTransferErrors(b);
    }

    public boolean getStopInChrome() {
        if (this.vm == null) {
            return false;
        }
        return this.vm.getStopInChrome();
    }

    public void setStopInChrome(boolean b) {
        if (this.vm == null) {
            return;
        }
        this.vm.setStopInChrome(b);
    }

    public void doGarbageCollection() {
        if (this.vm == null) {
            return;
        }
        this.vm.doGarbageCollection();
    }

    public boolean canStopInChrome() {
        if (this.vm == null) {
            return false;
        }
        return this.vm.getCapabilities().canStopInChrome();
    }

    public boolean canGarbageCollect() {
        if (this.vm == null) {
            return false;
        }
        return this.vm.getCapabilities().canDoGarbageCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerEvaluatorHandle(EvaluatorHandle handle) {
        List<EvaluatorHandle> list = this.evaluatorHandles;
        synchronized (list) {
            this.evaluatorHandles.add(handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearEvaluatorHandles() {
        List<EvaluatorHandle> list = this.evaluatorHandles;
        synchronized (list) {
            for (EvaluatorHandle handle : this.evaluatorHandles) {
                handle.expire();
            }
            this.evaluatorHandles.clear();
        }
    }

    private static Controller makeController() {
        return new 17();
    }

    private static synchronized void makeActions() {
        if (controller != null) {
            return;
        }
        controller = DebuggingProcess.makeController();
        actionTerminate = IdeAction.get((int)TERMINATE_CMD_ID, null, (String)IdeArb.getString((int)92), null, (Integer)IdeArb.getInteger((int)424), (ArrayResourceBundle)IdeArb.getInstance(), (int)343, null, (boolean)false);
        actionTerminate.addController(controller);
    }

    private void setToolbar() {
        this.debugWindowSettings = DebugWindowSettings.getInstance();
        this.changeListener = new 18();
        this.debugWindowSettings.addStructureChangeListener(this.changeListener);
        this.logPageToolbarSet = true;
        LogPage lp = this.getLogPage();
        if (lp instanceof RunLogPage) {
            RunLogPage runLogPage = (RunLogPage)lp;
            boolean show = this.debugWindowSettings.isShowToolbarInLogWindow();
            runLogPage.setNorthComponent((Component)(show ? this.getRunLogPageToolbar() : null));
        }
    }

    private void removeToolbar() {
        if (this.debugWindowSettings != null) {
            this.debugWindowSettings.removeStructureChangeListener(this.changeListener);
        }
        this.changeListener = null;
        this.debugWindowSettings = null;
        this.logPageToolbarSet = false;
        LogPage lp = this.getLogPage();
        if (lp instanceof RunLogPage) {
            RunLogPage runLogPage = (RunLogPage)lp;
            runLogPage.setNorthComponent(null);
        }
        this.clearLogPageToolbar();
    }

    private void updateToolbarVisibility() {
        LogPage lp;
        if (this.logPageToolbarSet && (lp = this.getLogPage()) instanceof RunLogPage) {
            RunLogPage runLogPage = (RunLogPage)lp;
            boolean show = this.debugWindowSettings.isShowToolbarInLogWindow();
            runLogPage.setNorthComponent((Component)(show ? this.getRunLogPageToolbar() : null));
        }
    }

    private Toolbar getRunLogPageToolbar() {
        if (this.logPageToolbar == null) {
            this.logPageToolbar = new Toolbar();
            this.logPageToolbar.add((ToggleAction)actionTerminate);
            this.logPageToolbar.validate();
        }
        return this.logPageToolbar;
    }

    private void clearRunLogPageToolbar() {
        if (this.logPageToolbar != null) {
            this.logPageToolbar.dispose();
            this.logPageToolbar.removeAll();
            this.logPageToolbar.validate();
            this.logPageToolbar = null;
        }
    }

    static {
        TERMINATE_CMD_ID = Ide.findOrCreateCmdID((String)"RunDebugTerminateProcessCommand");
        starterFactorySubClass = JStarterFactory.class;
        classLoadTracking = -1;
    }

    static DebugThreadInfo ra$currentThread(DebuggingProcess debuggingProcess) {
        return debuggingProcess.currentThread;
    }

    static void mav$updateToolbarVisibility(DebuggingProcess debuggingProcess) {
        debuggingProcess.updateToolbarVisibility();
    }

    static int ra$TERMINATE_CMD_ID() {
        return TERMINATE_CMD_ID;
    }

    static void mav$logMessages(DebuggingProcess debuggingProcess) {
        debuggingProcess.logMessages();
    }

    static void mav$logMessage(DebuggingProcess debuggingProcess, String string) {
        debuggingProcess.logMessage(string);
    }

    static Object ra$vmSync(DebuggingProcess debuggingProcess) {
        return debuggingProcess.vmSync;
    }

    static boolean mav$checkForInternalPause(DebuggingProcess debuggingProcess, boolean bl) {
        return debuggingProcess.checkForInternalPause(bl);
    }

    static boolean ra$xsltDebugging(DebuggingProcess debuggingProcess) {
        return debuggingProcess.xsltDebugging;
    }

    static void mav$showXSLTOutput(DebuggingProcess debuggingProcess) {
        debuggingProcess.showXSLTOutput();
    }

    static void mav$sendDebuggerEvent(DebuggingProcess debuggingProcess, int n, int n2) {
        debuggingProcess.sendDebuggerEvent(n, n2);
    }

    static void mav$doRunAfterPause(DebuggingProcess debuggingProcess, boolean bl) {
        debuggingProcess.doRunAfterPause(bl);
    }

    static DebugBreakpoint ra$runToCursor(DebuggingProcess debuggingProcess) {
        return debuggingProcess.runToCursor;
    }

    static boolean[] ra$pause(DebuggingProcess debuggingProcess) {
        return debuggingProcess.pause;
    }

    static long ra$timeProgramStopped(DebuggingProcess debuggingProcess) {
        return debuggingProcess.timeProgramStopped;
    }

    static void wa$timeProgramStopped(DebuggingProcess debuggingProcess, long l) {
        debuggingProcess.timeProgramStopped = l;
    }

    static void mav$activeProgramStopped(DebuggingProcess debuggingProcess) {
        debuggingProcess.activeProgramStopped();
    }

    static List ra$runAfterSelectedList(DebuggingProcess debuggingProcess) {
        return debuggingProcess.runAfterSelectedList;
    }

    static void wa$timeBeforeConnect(DebuggingProcess debuggingProcess, long l) {
        debuggingProcess.timeBeforeConnect = l;
    }

    static RunConfiguration ra$runConfiguration(DebuggingProcess debuggingProcess) {
        return debuggingProcess.runConfiguration;
    }

    static void wa$connectionThread(DebuggingProcess debuggingProcess, Thread thread) {
        debuggingProcess.connectionThread = thread;
    }

    static void wa$jsMozillaFireFoxDebugging(DebuggingProcess debuggingProcess, boolean bl) {
        debuggingProcess.jsMozillaFireFoxDebugging = bl;
    }

    static boolean ra$stopped(DebuggingProcess debuggingProcess) {
        return debuggingProcess.stopped;
    }

    static boolean ra$resuming(DebuggingProcess debuggingProcess) {
        return debuggingProcess.resuming;
    }

    static TimerTask ra$timerTaskUpdateNormalWindows(DebuggingProcess debuggingProcess) {
        return debuggingProcess.timerTaskUpdateNormalWindows;
    }

    static void mav$updateNormalWindows(DebuggingProcess debuggingProcess) {
        debuggingProcess.updateNormalWindows();
    }

    static void wa$timerTaskUpdateNormalWindows(DebuggingProcess debuggingProcess, TimerTask timerTask) {
        debuggingProcess.timerTaskUpdateNormalWindows = timerTask;
    }

    static TimerTask ra$timerTaskUpdateOtherWindows(DebuggingProcess debuggingProcess) {
        return debuggingProcess.timerTaskUpdateOtherWindows;
    }

    static void mav$updateOtherWindows(DebuggingProcess debuggingProcess) {
        debuggingProcess.updateOtherWindows();
    }

    static void wa$timerTaskUpdateOtherWindows(DebuggingProcess debuggingProcess, TimerTask timerTask) {
        debuggingProcess.timerTaskUpdateOtherWindows = timerTask;
    }

    static void mav$clearLogPageNorthComponent(DebuggingProcess debuggingProcess) {
        debuggingProcess.clearLogPageNorthComponent();
    }

    final class 1
    implements Runnable {
        public void run() {
            String vmName = DebuggingProcess.this.vm.getName();
            if (vmName != null) {
                String msg = DbgArb.format(678, vmName);
                DebuggingProcess.this.log(msg);
            }
            DebuggingProcess.this.afterConnection(DbgArb.getString(149));
        }
    }

    final class 2
    implements Runnable {
        public void run() {
            String msg = DbgArb.getString(910);
            DebuggingProcess.this.log(msg);
            if (DebuggingProcess.this.isStartAndRemoteDebugging()) {
                DebuggingProcess.this.terminate();
            }
        }
    }

    final class 3
    implements Runnable {
        public void run() {
            String failedMsg = DbgArb.getString(905);
            DebuggingProcess.this.log(failedMsg);
            DebuggingProcess.this.superTerminate();
        }
    }

    final class 4
    implements Runnable {
        public void run() {
            DebuggingProcess.this.afterConnection(DbgArb.getString(610));
        }
    }

    final class 5
    implements Runnable {
        public void run() {
            DebuggingProcess.this.superTerminate();
        }
    }

    final class 6
    extends Thread {
        private final /* synthetic */ DebugConnectArg[] v$connectArgs;
        private final /* synthetic */ DebugConnector v$connector;
        private final /* synthetic */ String v$successMsg;
        private final /* synthetic */ Runnable v$successRunnable;
        private final /* synthetic */ String v$tryMsg;
        private final /* synthetic */ int v$maxRetries;
        private final /* synthetic */ Runnable v$canceledRunnable;
        private final /* synthetic */ Runnable v$failureRunnable;
        final /* synthetic */ DebuggingProcess this$0;

        public void run() {
            int countRetries = 0;
            boolean keepTrying = true;
            boolean canceled = false;
            Character dotCharacter = new Character('.');
            DebuggingProcess.wa$timeBeforeConnect(this.this$0, System.currentTimeMillis());
            while (true) {
                try {
                    DebugConnectArg[] connArgs = this.v$connectArgs;
                    if (this.v$connector instanceof DebugMozillaFireFoxJavaScriptConnector) {
                        DebugConnectArg[] args = new DebugConnectArg[this.v$connectArgs.length + 6];
                        System.arraycopy(this.v$connectArgs, 0, args, 0, this.v$connectArgs.length);
                        DebugMozillaFireFoxJavaScriptConnectArg dca = new DebugMozillaFireFoxJavaScriptConnectArg("javascript_enable_debug_stat", "javascript_enable_debug_stat", true);
                        String jsEnableDebugStr = DebuggingProcess.ra$runConfiguration(this.this$0).getJSRunConfigurationEnableDebug();
                        if (jsEnableDebugStr == null || !jsEnableDebugStr.equals(DbgArb.getString(441))) {
                            dca.setValue(DbgArb.getString(87));
                        } else {
                            dca.setValue(DbgArb.getString(441));
                        }
                        boolean stopOnError = false;
                        DebugMozillaFireFoxJavaScriptConnectArg dca1 = new DebugMozillaFireFoxJavaScriptConnectArg("javascript_stop_on_error", "javascript_stop_on_error", true);
                        String jsStopOnErrorStr = DebuggingProcess.ra$runConfiguration(this.this$0).getJSRunConfigurationStopOnError();
                        if (jsStopOnErrorStr == null || !jsStopOnErrorStr.equals(DbgArb.getString(441))) {
                            dca1.setValue(DbgArb.getString(87));
                            stopOnError = true;
                        } else {
                            dca1.setValue(DbgArb.getString(441));
                        }
                        DebugMozillaFireFoxJavaScriptConnectArg dca2 = new DebugMozillaFireFoxJavaScriptConnectArg("javascript_stop_on_exception", "javascript_stop_on_exception", true);
                        String jsStopOnExceptionStr = DebuggingProcess.ra$runConfiguration(this.this$0).getJSRunConfigurationStopOnException();
                        if (jsStopOnExceptionStr == null || !jsStopOnExceptionStr.equals(DbgArb.getString(87))) {
                            dca2.setValue(DbgArb.getString(441));
                        } else {
                            dca2.setValue(DbgArb.getString(441));
                        }
                        DebugMozillaFireFoxJavaScriptConnectArg dca3 = new DebugMozillaFireFoxJavaScriptConnectArg("javascript_transfer_errors", "javascript_transfer_errors", true);
                        String jsTransferErrorsStr = DebuggingProcess.ra$runConfiguration(this.this$0).getJSRunConfigurationTransferErrors();
                        if (stopOnError || jsTransferErrorsStr == null || !jsTransferErrorsStr.equals(DbgArb.getString(441))) {
                            dca3.setValue(DbgArb.getString(87));
                        } else {
                            dca3.setValue(DbgArb.getString(441));
                        }
                        DebugMozillaFireFoxJavaScriptConnectArg dca4 = new DebugMozillaFireFoxJavaScriptConnectArg("javascript_stop_in_chrome", "javascript_stop_in_chrome", true);
                        String jsStopInChrome = DebuggingProcess.ra$runConfiguration(this.this$0).getJSRunConfigurationStopInChrome();
                        if (jsStopInChrome == null || !jsStopInChrome.equals(DbgArb.getString(441))) {
                            dca4.setValue(DbgArb.getString(87));
                        } else {
                            dca4.setValue(DbgArb.getString(441));
                        }
                        DebugMozillaFireFoxJavaScriptConnectArg dca5 = new DebugMozillaFireFoxJavaScriptConnectArg("javascript_transfer_errors2", "javascript_transfer_errors2", true);
                        if (jsTransferErrorsStr == null || !jsTransferErrorsStr.equals(DbgArb.getString(441))) {
                            dca5.setValue(DbgArb.getString(87));
                        } else {
                            dca5.setValue(DbgArb.getString(441));
                        }
                        args[args.length - 6] = dca;
                        args[args.length - 5] = dca1;
                        args[args.length - 4] = dca2;
                        args[args.length - 3] = dca3;
                        args[args.length - 2] = dca4;
                        args[args.length - 1] = dca5;
                        connArgs = args;
                    }
                    DebugVirtualMachine vm = this.v$connector.connect(connArgs);
                    DebuggingProcess.wa$connectionThread(this.this$0, null);
                    DebuggingProcess.clearStatus();
                    if (this.v$successMsg != null) {
                        this.this$0.log(this.v$successMsg);
                    }
                    MessagePage mp = null;
                    LogPage lp = this.this$0.getLogPage();
                    if (lp instanceof MessagePage) {
                        mp = (MessagePage)lp;
                    }
                    vm.afterConnection(mp);
                    if (vm.getLanguages() == 16) {
                        DebuggingProcess.wa$jsMozillaFireFoxDebugging(this.this$0, true);
                    }
                    SwingUtilities.invokeLater(new 1(this, vm));
                    return;
                }
                catch (Exception e) {
                    String msg;
                    if (e instanceof IOException && (msg = e.getMessage()) != null && msg.equals("Target failed to handshake.")) {
                        keepTrying = false;
                    }
                    if (this.v$tryMsg != null) {
                        this.this$0.log(dotCharacter);
                    }
                    if (++countRetries > this.v$maxRetries) {
                        keepTrying = false;
                    }
                    if (!keepTrying) continue;
                    if (countRetries > this.v$maxRetries / 2) {
                        DebuggingProcess.showStatus(DbgArb.getString(195));
                    }
                    try {
                        Thread.sleep(250L);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        this.this$0.log(DbgArb.getString(618));
                        canceled = true;
                        keepTrying = false;
                    }
                    if (keepTrying) continue;
                    DebuggingProcess.wa$connectionThread(this.this$0, null);
                    DebuggingProcess.clearStatus();
                    if (canceled) {
                        SwingUtilities.invokeLater(new 2());
                    } else {
                        SwingUtilities.invokeLater(new 3());
                    }
                    return;
                }
                break;
            }
        }

        public 6(DebuggingProcess debuggingProcess, String string, DebugConnectArg[] debugConnectArgArray, DebugConnector debugConnector, String string2, Runnable runnable, String string3, int n, Runnable runnable2, Runnable runnable3) {
            this.v$failureRunnable = runnable3;
            this.v$canceledRunnable = runnable2;
            this.v$maxRetries = n;
            this.v$tryMsg = string3;
            this.v$successRunnable = runnable;
            this.v$successMsg = string2;
            this.v$connector = debugConnector;
            this.v$connectArgs = debugConnectArgArray;
            this.this$0 = debuggingProcess;
            super(string);
        }

        static Runnable ra$v$successRunnable(6 var0) {
            return var0.v$successRunnable;
        }

        static Runnable ra$v$canceledRunnable(6 var0) {
            return var0.v$canceledRunnable;
        }

        static Runnable ra$v$failureRunnable(6 var0) {
            return var0.v$failureRunnable;
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ DebugVirtualMachine v$vm;
            final /* synthetic */ 6 this$0;

            public void run() {
                this.this$0.this$0.vm = this.v$vm;
                DebuggingProcess.mav$clearLogPageNorthComponent(this.this$0.this$0);
                JDebugger.getInstance().debuggingProcessAfterConnecting(this.this$0.this$0);
                6.ra$v$successRunnable(this.this$0).run();
            }

            public 1(6 var1_1, DebugVirtualMachine debugVirtualMachine) {
                this.v$vm = debugVirtualMachine;
                this.this$0 = var1_1;
            }
        }

        final class 2
        implements Runnable {
            public void run() {
                DebuggingProcess.mav$clearLogPageNorthComponent(6.this.this$0);
                JDebugger.getInstance().debuggingProcessAfterConnecting(6.this.this$0);
                if (6.ra$v$canceledRunnable(6.this) != null) {
                    6.ra$v$canceledRunnable(6.this).run();
                }
            }
        }

        final class 3
        implements Runnable {
            public void run() {
                DebuggingProcess.mav$clearLogPageNorthComponent(6.this.this$0);
                JDebugger.getInstance().debuggingProcessAfterConnecting(6.this.this$0);
                6.ra$v$failureRunnable(6.this).run();
            }
        }
    }

    class EventSource
    extends DebuggerEventSource {
        int languages = 0;
        int eventType;
        int state;
        boolean isPrepared;
        DebuggerEventSource.StackFrame[] stackFrames;

        EventSource() {
        }

        synchronized void eventOccurring(int eventType, int state) {
            this.eventType = eventType;
            this.state = state;
            this.isPrepared = false;
            this.stackFrames = null;
        }

        synchronized void prepareStackFrames() {
            if (!this.isPrepared) {
                DebuggerEventSource.StackFrame[] stackFrames;
                if (this.eventType == 2) {
                    if (DebuggingProcess.ra$currentThread(DebuggingProcess.this) != null) {
                        DebugStackFrameInfo[] dsfi = DebuggingProcess.ra$currentThread(DebuggingProcess.this).listStack();
                        stackFrames = new DebuggerEventSource.StackFrame[dsfi.length];
                        int i = 0;
                        while (i < dsfi.length) {
                            DebugDataInfo dataThis;
                            DebugVariableInfo argThis;
                            DebugLocation location = dsfi[i].getLocation();
                            DebugClassInfo locationClassInfo = location.getClassInfo();
                            String className = locationClassInfo.getName();
                            String prettyClassName = DebugShared.makeCourtesyClassName(locationClassInfo, true);
                            DebugMethodInfo method = location.getMethod();
                            String methodName = method.getNameWithoutClassOrSignature();
                            String prettyMethodName = DebugShared.makeCourtesyMethodName(method, false, false, dsfi[i]);
                            String methodSignature = method.getParameterSignature();
                            String prettyMethodSignature = DebugShared.makeCourtesyMethodSignature(method, DebuggingProcess.this.vm);
                            int methodAccess = method.getAccess();
                            long thisID = 0L;
                            String thisClassName = null;
                            String prettyThisClassName = null;
                            int language = dsfi[i].getLanguage();
                            if (!Modifier.isStatic(methodAccess) && !Modifier.isNative(methodAccess) && DebuggingProcess.this.vm.getCapabilities().canGetUniqueIDs() && (argThis = BaseEvaluator.findThis(dsfi[i].listArguments())) != null && (dataThis = argThis.getDataInfo()) instanceof DebugDataCompositeInfo) {
                                DebugDataCompositeInfo ddci = (DebugDataCompositeInfo)dataThis;
                                thisID = JDebugger.getObjectNumber(ddci);
                                DebugClassInfo thisClassInfo = ddci.getClassInfo();
                                thisClassName = thisClassInfo.getName();
                                prettyThisClassName = DebugShared.makeCourtesyClassName(thisClassInfo, true);
                            }
                            String filename = location.getFilename();
                            int lineNumber = location.getLine();
                            stackFrames[i] = new DebuggerEventSource.StackFrame(className, prettyClassName, methodName, prettyMethodName, methodSignature, prettyMethodSignature, methodAccess, thisID, thisClassName, prettyThisClassName, filename, lineNumber, language);
                            ++i;
                        }
                    } else {
                        stackFrames = new DebuggerEventSource.StackFrame[]{};
                    }
                } else {
                    stackFrames = null;
                }
                this.stackFrames = stackFrames;
                this.isPrepared = true;
            }
        }

        public int getLanguages() {
            if (DebuggingProcess.this.vm != null) {
                this.languages = DebuggingProcess.this.vm.getLanguages();
            }
            return this.languages;
        }

        public int getState() {
            return this.state;
        }

        public DebuggerEventSource.StackFrame[] getStackFrames() {
            this.prepareStackFrames();
            return this.stackFrames;
        }

        public Context getContext() {
            return this.getContext();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("EventSource[");
            sb.append("state=");
            sb.append(this.state);
            sb.append("]");
            return sb.toString();
        }
    }

    final class 7
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String msg = null;
            Object object = DebuggingProcess.ra$vmSync(DebuggingProcess.this);
            synchronized (object) {
                if (DebuggingProcess.mav$checkForInternalPause(DebuggingProcess.this, DebuggingProcess.this.vm != null)) {
                    return;
                }
                boolean[] blArray = DebuggingProcess.ra$pause(DebuggingProcess.this);
                synchronized (blArray) {
                    DebuggingProcess.ra$pause((DebuggingProcess)DebuggingProcess.this)[1] = false;
                }
                if (DebuggingProcess.this.vm == null) {
                    return;
                }
                if (DebuggingProcess.ra$timeProgramStopped(DebuggingProcess.this) == 0L) {
                    DebuggingProcess.wa$timeProgramStopped(DebuggingProcess.this, System.currentTimeMillis());
                }
                if (DebuggingProcess.this.vm.getCurrentStatus() == 8) {
                    msg = DbgArb.getString(927);
                }
            }
            DebuggingProcess.mav$logMessages(DebuggingProcess.this);
            if (msg != null) {
                DebuggingProcess.mav$logMessage(DebuggingProcess.this, msg);
            }
            if (DebuggingProcess.this.vm == null) {
                return;
            }
            if (JDebugger.getInstance().isActiveDebuggingProcess(DebuggingProcess.this)) {
                DebuggingProcess.mav$activeProgramStopped(DebuggingProcess.this);
            } else {
                1 runAfterSelected = new 1();
                DebuggingProcess.ra$runAfterSelectedList(DebuggingProcess.this).add(runAfterSelected);
                Runner.getRunner().selectProcess((RunProcess)DebuggingProcess.this);
            }
        }

        final class 1
        implements Runnable {
            public void run() {
                DebuggingProcess.mav$activeProgramStopped(DebuggingProcess.this);
            }
        }
    }

    final class 8
    implements Runnable {
        private final /* synthetic */ DebugBreakpoint v$dbp;
        final /* synthetic */ DebuggingProcess this$0;

        public void run() {
            if (this.this$0.vm == null) {
                return;
            }
            if (this.v$dbp != DebuggingProcess.ra$runToCursor(this.this$0)) {
                JDebugger.getInstance().breakpointChanged(this.v$dbp, this.this$0);
            }
        }

        public 8(DebuggingProcess debuggingProcess, DebugBreakpoint debugBreakpoint) {
            this.v$dbp = debugBreakpoint;
            this.this$0 = debuggingProcess;
        }
    }

    final class 9
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            DebuggingProcess.mav$logMessages(DebuggingProcess.this);
            Object object = DebuggingProcess.ra$vmSync(DebuggingProcess.this);
            synchronized (object) {
                DebuggingProcess.mav$checkForInternalPause(DebuggingProcess.this, false);
            }
            if (DebuggingProcess.ra$xsltDebugging(DebuggingProcess.this)) {
                DebuggingProcess.mav$showXSLTOutput(DebuggingProcess.this);
            }
            DebuggingProcess.mav$sendDebuggerEvent(DebuggingProcess.this, 4, 400);
            if (DebuggingProcess.this.isRemoteDebuggingProfiling()) {
                DebuggingProcess.this.finished();
            } else {
                DebuggingProcess.this.superTerminate();
            }
            DebuggingProcess.this.checkCommands();
            DebuggingProcess.mav$doRunAfterPause(DebuggingProcess.this, false);
        }
    }

    final class 10
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            DebuggingProcess.mav$logMessages(DebuggingProcess.this);
            DebuggingProcess.mav$logMessage(DebuggingProcess.this, DbgArb.getString(244));
            Object object = DebuggingProcess.ra$vmSync(DebuggingProcess.this);
            synchronized (object) {
                DebuggingProcess.mav$checkForInternalPause(DebuggingProcess.this, false);
            }
            if (DebuggingProcess.ra$xsltDebugging(DebuggingProcess.this)) {
                DebuggingProcess.mav$showXSLTOutput(DebuggingProcess.this);
            }
            DebuggingProcess.mav$sendDebuggerEvent(DebuggingProcess.this, 4, 401);
            if (DebuggingProcess.this.isRemoteDebuggingProfiling()) {
                DebuggingProcess.this.finished();
            } else {
                DebuggingProcess.this.superTerminate();
            }
            DebuggingProcess.this.checkCommands();
            DebuggingProcess.mav$doRunAfterPause(DebuggingProcess.this, false);
        }
    }

    final class 11
    implements Runnable {
        private final /* synthetic */ String v$msg;
        final /* synthetic */ DebuggingProcess this$0;

        public void run() {
            this.this$0.log(this.v$msg);
        }

        public 11(DebuggingProcess debuggingProcess, String string) {
            this.v$msg = string;
            this.this$0 = debuggingProcess;
        }
    }

    final class 12
    extends Thread {
        private final /* synthetic */ DebugVirtualMachine v$vmFinal;
        final /* synthetic */ DebuggingProcess this$0;

        public void run() {
            if (this.v$vmFinal != null) {
                this.v$vmFinal.disconnect(true);
            }
        }

        public 12(DebuggingProcess debuggingProcess, String string, DebugVirtualMachine debugVirtualMachine) {
            this.v$vmFinal = debugVirtualMachine;
            this.this$0 = debuggingProcess;
            super(string);
        }
    }

    final class 13
    extends TimerTask {
        public void run() {
            SwingUtilities.invokeLater(new 1());
        }

        final class 1
        implements Runnable {
            public void run() {
                if (DebuggingProcess.ra$stopped(DebuggingProcess.this) && !DebuggingProcess.ra$resuming(DebuggingProcess.this) && DebuggingProcess.ra$timerTaskUpdateNormalWindows(DebuggingProcess.this) != null) {
                    DebuggingProcess.mav$updateNormalWindows(DebuggingProcess.this);
                }
                DebuggingProcess.wa$timerTaskUpdateNormalWindows(DebuggingProcess.this, null);
            }
        }
    }

    final class 14
    extends TimerTask {
        public void run() {
            SwingUtilities.invokeLater(new 1());
        }

        final class 1
        implements Runnable {
            public void run() {
                if (DebuggingProcess.ra$stopped(DebuggingProcess.this) && !DebuggingProcess.ra$resuming(DebuggingProcess.this) && DebuggingProcess.ra$timerTaskUpdateOtherWindows(DebuggingProcess.this) != null) {
                    DebuggingProcess.mav$updateOtherWindows(DebuggingProcess.this);
                }
                DebuggingProcess.wa$timerTaskUpdateOtherWindows(DebuggingProcess.this, null);
            }
        }
    }

    final class 15
    implements Runnable {
        public void run() {
            DockUtil.showDockableWindow((DockableView)LogManager.getIdeLogWindow());
            DebuggingProcess.this.getLogPage().getLogPageView().show();
        }
    }

    final class 16
    implements Runnable {
        private final /* synthetic */ RunWhilePaused v$runAfterPaused;
        final /* synthetic */ DebuggingProcess this$0;

        public void run() {
            this.v$runAfterPaused.run(this.this$0, true);
        }

        public 16(DebuggingProcess debuggingProcess, RunWhilePaused runWhilePaused) {
            this.v$runAfterPaused = runWhilePaused;
            this.this$0 = debuggingProcess;
        }
    }

    static final class 17
    implements Controller {
        public boolean update(IdeAction action, Context context) {
            int cmdId;
            DebuggingProcess debuggingProcess = this.getDebuggingProcess(context);
            if (debuggingProcess != null && (cmdId = action.getCommandId()) == DebuggingProcess.ra$TERMINATE_CMD_ID()) {
                action.setEnabled(debuggingProcess.canTerminate());
                return true;
            }
            action.setEnabled(false);
            return true;
        }

        public boolean handleEvent(IdeAction action, Context context) {
            int cmdId;
            DebuggingProcess debuggingProcess = this.getDebuggingProcess(context);
            if (debuggingProcess != null && (cmdId = action.getCommandId()) == DebuggingProcess.ra$TERMINATE_CMD_ID()) {
                debuggingProcess.terminate();
                return true;
            }
            return true;
        }

        private DebuggingProcess getDebuggingProcess(Context context) {
            RunProcess runProcess;
            LogPage logPage;
            LogWindow logWindow;
            View view;
            RunLogPage runLogPage = null;
            if (context != null && (view = context.getView()) instanceof RunLogPage) {
                runLogPage = (RunLogPage)view;
            }
            if (runLogPage == null && (logWindow = LogManager.getLogManager().getLogWindow()) != null && (logPage = logWindow.getPage()) instanceof RunLogPage) {
                runLogPage = (RunLogPage)logPage;
            }
            if (runLogPage != null && (runProcess = runLogPage.getRunProcess()) instanceof DebuggingProcess) {
                return (DebuggingProcess)runProcess;
            }
            return null;
        }
    }

    final class 18
    extends StructureChangeListener {
        public void structureValuesChanged(StructureChangeEvent e) {
            DebuggingProcess.mav$updateToolbarVisibility(DebuggingProcess.this);
        }
    }
}

