/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Project;
import oracle.ide.util.HistoryList;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.jdeveloper.dialogs.ClassPackageBrowserV2;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.runner.debug.DbgArb;

final class EditHeapClassDialog
extends JPanel
implements ActionListener,
DocumentListener,
ItemListener {
    private JEWTDialog dlg;
    private Project jproject;
    private HistoryList nameHistoryList;
    private JComboBox nameComboBox;
    private JTextField nameEditor;
    private JButton browseButton;
    private static final String nameHistoryName = "DebuggerHeapClass";

    static String showEditHeapClassDialog(String title, String prompt, String name, Project jproject, String helpId) {
        EditHeapClassDialog panel = new EditHeapClassDialog(prompt, name, jproject);
        JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, (Component)panel.nameEditor, (String)title);
        panel.setJEWTDialog(dlg);
        dlg.setOKButtonEnabled(panel.canOk());
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, helpId);
        if (WizardLauncher.runDialog((JDialog)dlg)) {
            return panel.getHeapClass();
        }
        return null;
    }

    private EditHeapClassDialog(String prompt, String name, Project jproject) {
        super(new GridBagLayout());
        this.jproject = jproject;
        if (name == null) {
            name = "";
        }
        JLabel nameLabel = new JLabel();
        this.nameHistoryList = Ide.loadHistoryList((String)nameHistoryName);
        this.nameComboBox = new JComboBox<String>(this.nameHistoryList.getHistory());
        this.nameComboBox.setEditable(true);
        this.nameEditor = (JTextField)this.nameComboBox.getEditor().getEditorComponent();
        this.nameComboBox.addActionListener(this);
        ResourceUtils.resLabel((JLabel)nameLabel, (Component)this.nameEditor, (String)prompt);
        IdeUtil.comboBoxSelectItem((JComboBox)this.nameComboBox, (Object)name);
        this.browseButton = new JButton();
        this.browseButton.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this.browseButton, (String)DbgArb.getString(468));
        int y = 0;
        this.add((Component)nameLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.nameComboBox, new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.browseButton, new GridBagConstraints(1, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)new JLabel(), new GridBagConstraints(0, y, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        IdeUtil.addComboBoxDocumentListener((JComboBox)this.nameComboBox, (DocumentListener)this);
        this.nameComboBox.addItemListener(this);
    }

    private void setJEWTDialog(JEWTDialog dlg) {
        this.dlg = dlg;
        dlg.addVetoableChangeListener((VetoableChangeListener)new 1());
    }

    private void processChange() {
        this.dlg.setOKButtonEnabled(this.canOk());
    }

    private boolean canOk() {
        try {
            boolean bl = this.nameEditor.getText().length() > 0;
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean veto() {
        JavaManager javaManager;
        JavaClass javaClass;
        String className = this.nameEditor.getText();
        if (className.length() > 0 && (javaClass = (javaManager = JavaManager.getJavaManager((Project)this.jproject)).getClass(className)) == null) {
            String[] messages = new String[]{DbgArb.format(534, className), DbgArb.getString(531)};
            int answer = JOptionPane.showConfirmDialog(this, messages, DbgArb.format(839, this.dlg.getTitle()), 0);
            return answer != 0;
        }
        return false;
    }

    public void actionPerformed(ActionEvent e) {
        String s;
        Object source = e.getSource();
        if (source == this.nameComboBox) {
            this.nameEditor.setText((String)this.nameComboBox.getSelectedItem());
        } else if (source == this.browseButton && (s = ClassPackageBrowserV2.browseClassOrPackage(this, this.jproject, 2)) != null) {
            this.nameEditor.setText(s);
        }
    }

    public void changedUpdate(DocumentEvent e) {
        this.processChange();
    }

    public void insertUpdate(DocumentEvent e) {
        this.processChange();
    }

    public void removeUpdate(DocumentEvent e) {
        this.processChange();
    }

    public void itemStateChanged(ItemEvent e) {
        this.processChange();
    }

    private String getHeapClass() {
        return this.nameHistoryList.comboBoxGetSelectedItem(this.nameComboBox);
    }

    static boolean mav$veto(EditHeapClassDialog editHeapClassDialog) {
        return editHeapClassDialog.veto();
    }

    final class 1
    implements VetoableChangeListener {
        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt) && EditHeapClassDialog.mav$veto(EditHeapClassDialog.this)) {
                throw new PropertyVetoException("no", evt);
            }
        }
    }
}

