/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import oracle.ide.util.FastStringBuffer;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.shared.DebugSharedPrimitives;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;

public class EvaluationInfo {
    private Object wrappedValue;
    private String value;
    private String hexValue;
    private DebugClassInfo classInfo;
    private DebugDataInfo data;

    EvaluationInfo(String value, DebugClassInfo classInfo, DebugDataInfo data) throws Exception {
        this.init(value, "", classInfo, data);
    }

    EvaluationInfo(String value, DebugClassInfo classInfo) throws Exception {
        this.init(value, "", classInfo, null);
    }

    EvaluationInfo(boolean z, DebugClassInfo classInfo) throws Exception {
        String hexValue;
        String value;
        Object object = this.wrappedValue = z ? Boolean.TRUE : Boolean.FALSE;
        if (z) {
            value = "true";
            hexValue = "01";
        } else {
            value = "false";
            hexValue = "00";
        }
        this.init(value, hexValue, classInfo, null);
    }

    EvaluationInfo(byte b, DebugClassInfo classInfo) throws Exception {
        this.wrappedValue = new Byte(b);
        String value = Byte.toString(b);
        byte i = b;
        String hexValue = DebugShared.prepadOrTrunc(Integer.toHexString(i), '0', 2);
        this.init(value, hexValue, classInfo, null);
    }

    EvaluationInfo(char c, DebugClassInfo classInfo) throws Exception {
        this.wrappedValue = new Character(c);
        char[] buf = new char[]{'\'', c, '\''};
        char i = c;
        String value = new String(buf) + "    " + i;
        String hexValue = DebugShared.prepadOrTrunc(Integer.toHexString(i), '0', 4);
        this.init(value, hexValue, classInfo, null);
    }

    EvaluationInfo(double d, DebugClassInfo classInfo) throws Exception {
        this.wrappedValue = new Double(d);
        String value = Double.toString(d);
        long l = Double.doubleToLongBits(d);
        String hexValue = DebugShared.prepadOrTrunc(Long.toHexString(l), '0', 16);
        this.init(value, hexValue, classInfo, null);
    }

    EvaluationInfo(float f, DebugClassInfo classInfo) throws Exception {
        this.wrappedValue = new Float(f);
        String value = Float.toString(f);
        int i = Float.floatToIntBits(f);
        String hexValue = DebugShared.prepadOrTrunc(Integer.toHexString(i), '0', 8);
        this.init(value, hexValue, classInfo, null);
    }

    EvaluationInfo(int i, DebugClassInfo classInfo) throws Exception {
        this.wrappedValue = new Integer(i);
        String value = Integer.toString(i);
        String hexValue = DebugShared.prepadOrTrunc(Integer.toHexString(i), '0', 8);
        this.init(value, hexValue, classInfo, null);
    }

    EvaluationInfo(long l, DebugClassInfo classInfo) throws Exception {
        this.wrappedValue = new Long(l);
        String value = Long.toString(l);
        String hexValue = DebugShared.prepadOrTrunc(Long.toHexString(l), '0', 16);
        this.init(value, hexValue, classInfo, null);
    }

    EvaluationInfo(short s, DebugClassInfo classInfo) throws Exception {
        this.wrappedValue = new Short(s);
        String value = Short.toString(s);
        short i = s;
        String hexValue = DebugShared.prepadOrTrunc(Integer.toHexString(i), '0', 4);
        this.init(value, hexValue, classInfo, null);
    }

    private void init(String value, String hexValue, DebugClassInfo classInfo, DebugDataInfo data) throws Exception {
        if (classInfo == null) {
            throw new Exception("EvaluationInfo classInfo is null");
        }
        this.value = value;
        this.hexValue = hexValue;
        this.classInfo = classInfo;
        this.data = data;
    }

    DebugDataInfo getDataInfo() {
        return this.data;
    }

    String getValue() {
        return this.getValue(false);
    }

    String getValue(boolean tryCourtesyValue) {
        if (tryCourtesyValue && this.data instanceof DebugDataCompositeInfo && (this.value == null || this.value.length() == 0)) {
            return DebugShared.makeCourtesyValue((DebugDataCompositeInfo)this.data);
        }
        return this.value;
    }

    String getHexValue() {
        return this.hexValue;
    }

    public DebugClassInfo getClassInfo() {
        return this.classInfo;
    }

    boolean isNull() {
        return this.value.equals("null") && (this.classInfo.isObject() || this.classInfo.isInterface() || this.classInfo.isArray());
    }

    void copyFrom(EvaluationInfo other) {
        this.value = other.value;
        this.hexValue = other.hexValue;
        this.classInfo = other.classInfo;
        this.data = other.data;
    }

    Object getWrappedValue() {
        return this.wrappedValue;
    }

    public boolean getBooleanValue() {
        if (this.wrappedValue instanceof Boolean) {
            return (Boolean)this.wrappedValue;
        }
        return DebugSharedPrimitives.booleanDecode(this.value);
    }

    public byte getByteValue() {
        if (this.wrappedValue instanceof Byte) {
            return (Byte)this.wrappedValue;
        }
        return DebugSharedPrimitives.byteDecode(this.value);
    }

    public char getCharValue() {
        if (this.wrappedValue instanceof Character) {
            return ((Character)this.wrappedValue).charValue();
        }
        return DebugSharedPrimitives.charDecode(this.value);
    }

    public double getDoubleValue() {
        if (this.wrappedValue instanceof Double) {
            return (Double)this.wrappedValue;
        }
        return DebugSharedPrimitives.doubleDecode(this.value);
    }

    public float getFloatValue() {
        if (this.wrappedValue instanceof Float) {
            return ((Float)this.wrappedValue).floatValue();
        }
        return DebugSharedPrimitives.floatDecode(this.value);
    }

    public int getIntValue() {
        if (this.wrappedValue instanceof Integer) {
            return (Integer)this.wrappedValue;
        }
        return DebugSharedPrimitives.intDecode(this.value);
    }

    public long getLongValue() {
        if (this.wrappedValue instanceof Long) {
            return (Long)this.wrappedValue;
        }
        return DebugSharedPrimitives.longDecode(this.value);
    }

    public short getShortValue() {
        if (this.wrappedValue instanceof Short) {
            return (Short)this.wrappedValue;
        }
        return DebugSharedPrimitives.shortDecode(this.value);
    }

    public String getStringValue() {
        if (this.data instanceof DebugDataObjectInfo) {
            Object wholeThing;
            DebugDataObjectInfo ddoi = (DebugDataObjectInfo)this.data;
            if (this.classInfo.getName().equals("$oracle.xml.xslt.XMLString")) {
                return DebugShared.makeCourtesyValue(ddoi, false, false);
            }
            if (!ddoi.isNull() && (wholeThing = ddoi.getWholeThing()) instanceof String) {
                return (String)wholeThing;
            }
        } else if (!this.value.equals("null")) {
            FastStringBuffer sb = new FastStringBuffer(this.value);
            int length = sb.length();
            if (length >= 2 && sb.charAt(0) == '\"' && sb.charAt(length - 1) == '\"') {
                sb.removeCharAt(length - 1);
                sb.removeCharAt(0);
            }
            return sb.toString();
        }
        return null;
    }
}

