/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.ArrayList;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.AntEvaluator;
import oracle.jdevimpl.runner.debug.BaseEvaluator;
import oracle.jdevimpl.runner.debug.DebugContext;
import oracle.jdevimpl.runner.debug.JavaEvaluator;
import oracle.jdevimpl.runner.debug.MozillaFireFoxJavaScriptEvaluator;
import oracle.jdevimpl.runner.debug.PlsqlEvaluator;
import oracle.jdevimpl.runner.debug.XsltEvaluator;

public class Evaluator
extends DebugContext {
    private JavaEvaluator javaEvaluator;
    private PlsqlEvaluator plsqlEvaluator;
    private XsltEvaluator xsltEvaluator;
    private AntEvaluator antEvaluator;
    private MozillaFireFoxJavaScriptEvaluator mozillaFireFoxJavaScriptEvaluator;

    public Evaluator(boolean allowMethodInvocation) {
        this.javaEvaluator = new JavaEvaluator(this, allowMethodInvocation);
        this.plsqlEvaluator = new PlsqlEvaluator(this);
        this.xsltEvaluator = new XsltEvaluator(this);
        this.antEvaluator = new AntEvaluator(this);
        this.mozillaFireFoxJavaScriptEvaluator = new MozillaFireFoxJavaScriptEvaluator(this);
    }

    public boolean setDebugContext(DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo frame) {
        if (super.setDebugContext(vm, thread, frame)) {
            this.clearCache();
            return true;
        }
        return false;
    }

    boolean setDebugContext(DebugDataObjectInfo dataObject) {
        if (super.setDebugContext(dataObject)) {
            this.clearCache();
            return true;
        }
        return false;
    }

    void clearCache() {
        this.javaEvaluator.clearCache();
        this.plsqlEvaluator.clearCache();
        this.xsltEvaluator.clearCache();
        this.antEvaluator.clearCache();
        this.mozillaFireFoxJavaScriptEvaluator.clearCache();
    }

    static boolean validate(String exp) {
        if (JavaEvaluator.validate(exp)) {
            return true;
        }
        if (PlsqlEvaluator.validate(exp)) {
            return true;
        }
        return XsltEvaluator.validate(exp);
    }

    int evaluateCondition(String condition) {
        BaseEvaluator[] evaluatorUsed = new BaseEvaluator[1];
        Object o = this.evaluate(condition, evaluatorUsed);
        if (o != null && evaluatorUsed[0] != null) {
            return evaluatorUsed[0].evaluateConditionResult(o);
        }
        return -2;
    }

    public Object evaluate(String exp) {
        return this.evaluate(exp, null);
    }

    private Object evaluate(String exp, BaseEvaluator[] evaluatorUsed) {
        if (this.vm != null) {
            int languages;
            ArrayList<BaseEvaluator> evaluators = new ArrayList<BaseEvaluator>();
            if (this.frame != null) {
                switch (this.frame.getLanguage()) {
                    case 1: {
                        evaluators.add(this.javaEvaluator);
                        break;
                    }
                    case 2: {
                        evaluators.add(this.plsqlEvaluator);
                        break;
                    }
                    case 4: {
                        evaluators.add(this.xsltEvaluator);
                        break;
                    }
                    case 8: {
                        evaluators.add(this.antEvaluator);
                    }
                    case 16: {
                        evaluators.add(this.mozillaFireFoxJavaScriptEvaluator);
                    }
                }
            }
            if (((languages = this.vm.getLanguages()) & 1) != 0 && !evaluators.contains(this.javaEvaluator)) {
                evaluators.add(this.javaEvaluator);
            }
            if ((languages & 2) != 0 && !evaluators.contains(this.plsqlEvaluator)) {
                evaluators.add(this.plsqlEvaluator);
            }
            if ((languages & 4) != 0 && !evaluators.contains(this.xsltEvaluator)) {
                evaluators.add(this.xsltEvaluator);
            }
            if ((languages & 8) != 0 && !evaluators.contains(this.antEvaluator)) {
                evaluators.add(this.antEvaluator);
            }
            if ((languages & 0x10) != 0 && !evaluators.contains(this.mozillaFireFoxJavaScriptEvaluator)) {
                evaluators.add(this.mozillaFireFoxJavaScriptEvaluator);
            }
            int size = evaluators.size();
            int i = 0;
            while (i < size) {
                BaseEvaluator evaluator = (BaseEvaluator)evaluators.get(i);
                Object o = evaluator.evaluate(exp);
                if (o != null) {
                    if (evaluatorUsed != null) {
                        evaluatorUsed[0] = evaluator;
                    }
                    return o;
                }
                ++i;
            }
        }
        return null;
    }

    static DebugDataInfo getDataInfo(Object o) {
        return BaseEvaluator.getDataInfo(o);
    }
}

