/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.runner.DebuggeeData;
import oracle.ide.runner.DebuggerEvaluator;
import oracle.ide.runner.DebuggerThread;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.CustomDataProvider;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DebuggeeDataInfo;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.Evaluator;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.ThreadHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EvaluatorHandle
implements DebuggerEvaluator {
    private boolean expired;
    private Evaluator evaluator;
    private DebuggingProcess debuggingProcess;
    private CustomDataProvider customDataProvider;
    private EvaluatorContext context;

    EvaluatorHandle(Evaluator evaluator, DebuggingProcess debuggingProcess, CustomDataProvider customDataProvider) {
        this.evaluator = evaluator;
        this.debuggingProcess = debuggingProcess;
        debuggingProcess.registerEvaluatorHandle(this);
        this.customDataProvider = customDataProvider;
    }

    synchronized void expire() {
        this.expired = true;
        this.debuggingProcess = null;
        this.evaluator = null;
        this.context = null;
        this.customDataProvider = null;
    }

    public synchronized boolean hasExpired() {
        return this.expired;
    }

    public synchronized Context getContext() {
        if (!this.expired) {
            return this.debuggingProcess.getContext();
        }
        return null;
    }

    public synchronized int getStackFrame() {
        if (!this.expired && this.evaluator.frame != null) {
            return this.evaluator.frame.getFrameNumber();
        }
        return -1;
    }

    public synchronized DebuggerThread getThread() {
        if (!this.expired && this.evaluator.thread != null) {
            return new ThreadHandle(this.evaluator.thread.getName());
        }
        return null;
    }

    public synchronized DebuggeeData evaluate(String expression, DebuggeeData context) {
        ArrayList<String> expressions = new ArrayList<String>(1);
        expressions.add(expression);
        List<DebuggeeData> result = this.evaluate(expressions, context);
        return result == null ? null : result.get(0);
    }

    public synchronized List<DebuggeeData> evaluate(List<String> expressions, DebuggeeData context) {
        if (!this.expired) {
            Object info;
            DebugThreadInfo thread = this.evaluator.thread;
            DebugStackFrameInfo frame = this.evaluator.frame;
            DebuggeeDataInfo parent = null;
            boolean restoreContext = false;
            if (context instanceof DebuggeeDataInfo && (info = ((DebuggeeDataInfo)context).getDataInfo()) instanceof DebugDataObjectInfo) {
                this.evaluator.setDebugContext((DebugDataObjectInfo)info);
                restoreContext = true;
                parent = (DebuggeeDataInfo)context;
            }
            ArrayList<DebuggeeData> results = new ArrayList<DebuggeeData>();
            for (String expression : expressions) {
                Object value = this.evaluator.evaluate(expression);
                if (value != null) {
                    String expressionOverride = parent == null ? expression : "." + expression;
                    DataPanel.DataItem dataItem = this.customDataProvider.makeDataItem(value, expressionOverride);
                    results.add(new DebuggeeDataInfo(parent, dataItem, this, this.customDataProvider));
                    continue;
                }
                results.add(null);
            }
            if (restoreContext) {
                this.evaluator.setDebugContext(this.evaluator.vm, thread, frame);
            }
            return results;
        }
        return null;
    }

    public synchronized int getStackFrameCount() {
        int size;
        if (!this.expired && (size = this.getDebugStackFrameInfos().size()) > 0) {
            return size;
        }
        return -1;
    }

    public synchronized DebuggerEvaluator getEvaluator(int stackFrame) {
        List<DebugStackFrameInfo> stackFrames;
        if (!this.expired && stackFrame < (stackFrames = this.getDebugStackFrameInfos()).size()) {
            Evaluator newEvaluator = new Evaluator(true);
            newEvaluator.setDebugContext(this.evaluator.vm, this.evaluator.thread, stackFrames.get(stackFrame));
            return new EvaluatorHandle(newEvaluator, this.debuggingProcess, this.customDataProvider);
        }
        return null;
    }

    public synchronized DebuggerEvaluator getEvaluator(DebuggerThread thread) {
        if (!this.expired) {
            DebugThreadInfo[] currentThreads = this.getDebugThreadInfos();
            DebugThreadInfo found = null;
            DebugThreadInfo[] debugThreadInfoArray = currentThreads;
            int n = 0;
            while (n < debugThreadInfoArray.length) {
                DebugThreadInfo currentThread = debugThreadInfoArray[n];
                if (thread.getName().equals(currentThread.getName())) {
                    found = currentThread;
                    break;
                }
                ++n;
            }
            if (found != null) {
                Evaluator newEvaluator = new Evaluator(true);
                newEvaluator.setDebugContext(this.evaluator.vm, found, this.evaluator.frame);
                return new EvaluatorHandle(newEvaluator, this.debuggingProcess, this.customDataProvider);
            }
        }
        return null;
    }

    public synchronized List<DebuggerThread> getAllThreads() {
        if (!this.expired && this.evaluator.vm != null) {
            DebugThreadInfo[] threads = this.evaluator.vm.listThreads();
            ArrayList<DebuggerThread> threadList = new ArrayList<DebuggerThread>(threads.length);
            DebugThreadInfo[] debugThreadInfoArray = threads;
            int n = 0;
            while (n < debugThreadInfoArray.length) {
                DebugThreadInfo thread = debugThreadInfoArray[n];
                threadList.add(new ThreadHandle(thread.getName()));
                ++n;
            }
            return threadList;
        }
        return null;
    }

    synchronized EvaluatorContext getEvaluatorContext() {
        if (!this.expired) {
            if (this.context == null) {
                this.context = new EvaluatorContext();
            }
            return this.context;
        }
        return null;
    }

    private DebugThreadInfo[] getDebugThreadInfos() {
        Evaluator currentEvaluator;
        if (!this.expired && (currentEvaluator = this.evaluator) != null && currentEvaluator.vm != null) {
            return currentEvaluator.vm.listThreads();
        }
        return new DebugThreadInfo[0];
    }

    private List<DebugStackFrameInfo> getDebugStackFrameInfos() {
        DebugThreadInfo thread;
        Evaluator currentEvaluator;
        if (!this.expired && (currentEvaluator = this.evaluator) != null && currentEvaluator.vm != null && (thread = currentEvaluator.vm.getCurrentThread()) != null) {
            int count = thread.getStackFrameCount();
            ArrayList<DebugStackFrameInfo> frameList = new ArrayList<DebugStackFrameInfo>(count);
            int i = 0;
            while (i < count) {
                frameList.add(thread.getStackFrame(i));
                ++i;
            }
            return frameList;
        }
        return Collections.emptyList();
    }

    static Evaluator ra$evaluator(EvaluatorHandle evaluatorHandle) {
        return evaluatorHandle.evaluator;
    }

    class EvaluatorContext {
        DebuggingProcess getDebuggingProcess() {
            return JDebugger.getInstance().findDebuggingProcess(EvaluatorHandle.ra$evaluator((EvaluatorHandle)EvaluatorHandle.this).vm);
        }

        DebugVirtualMachine getVm() {
            return EvaluatorHandle.ra$evaluator((EvaluatorHandle)EvaluatorHandle.this).vm;
        }

        DebugThreadInfo getThread() {
            return EvaluatorHandle.ra$evaluator((EvaluatorHandle)EvaluatorHandle.this).thread;
        }

        DebugStackFrameInfo getStackFrame() {
            return EvaluatorHandle.ra$evaluator((EvaluatorHandle)EvaluatorHandle.this).frame;
        }

        EvaluatorContext() {
        }
    }
}

