/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.HashMap;
import java.util.Map;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugPinListener;
import oracle.jdevimpl.debugger.support.DebugPinnedInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.Evaluator;
import oracle.jdevimpl.runner.debug.Expression;

public class EvaluatorItem
implements DebugPinListener {
    private String expression;
    private Map pinned;
    private Map discarded;
    private String name;
    private boolean showPinnedDiscarded;
    private DebuggingProcess temporary;
    private boolean canUnpin;

    public EvaluatorItem(String expression) {
        this.expression = expression;
        this.name = null;
        this.showPinnedDiscarded = true;
        this.canUnpin = true;
    }

    EvaluatorItem(Expression expression) {
        this(expression.getExpression());
        this.setOptions(expression.getName(), expression.isShowPinnedDiscarded(), expression.getTemporary());
    }

    void pin(DebuggingProcess debuggingProcess, DebugDataCompositeInfo datac) {
        DebugPinnedInfo pin = datac.pinObject(this);
        if (pin != null) {
            if (this.pinned == null) {
                this.pinned = new HashMap();
            }
            this.pinned.put(debuggingProcess, pin);
        }
    }

    public void setOptions(String name, boolean showPinnedDiscarded, DebuggingProcess temporary) {
        this.name = name;
        this.showPinnedDiscarded = showPinnedDiscarded;
        this.temporary = temporary;
    }

    public String getName() {
        return this.name;
    }

    public boolean isShowPinnedDiscarded() {
        return this.showPinnedDiscarded;
    }

    public DebuggingProcess getTemporary() {
        return this.temporary;
    }

    void setCanUnpin(boolean canUnpin) {
        this.canUnpin = canUnpin;
    }

    boolean canUnpin(DebuggingProcess debuggingProcess) {
        return this.canUnpin && this.isPinned(debuggingProcess);
    }

    void unpin(DebuggingProcess debuggingProcess) {
        DebugPinnedInfo p;
        if (this.pinned != null && (p = (DebugPinnedInfo)this.pinned.remove(debuggingProcess)) != null) {
            p.unpinObject();
        }
        if (this.discarded != null) {
            this.discarded.remove(debuggingProcess);
        }
    }

    void unpinForAll() {
        if (this.pinned != null) {
            for (DebuggingProcess debuggingProcess : this.pinned.keySet()) {
                if (!this.isPinned(debuggingProcess)) continue;
                this.unpin(debuggingProcess);
            }
        }
        if (this.discarded != null) {
            for (DebuggingProcess debuggingProcess : this.discarded.keySet()) {
                if (!this.isPinned(debuggingProcess)) continue;
                this.unpin(debuggingProcess);
            }
        }
    }

    public void pinnedObjectDiscarded(DebugVirtualMachine vm, DebugPinnedInfo pin) {
        if (this.pinned != null) {
            for (DebuggingProcess debuggingProcess : this.pinned.keySet()) {
                DebugPinnedInfo p;
                if (debuggingProcess.getVM() != vm || !(p = (DebugPinnedInfo)this.pinned.get(debuggingProcess)).equals(pin)) continue;
                this.pinned.remove(debuggingProcess);
                if (this.discarded == null) {
                    this.discarded = new HashMap();
                }
                this.discarded.put(debuggingProcess, pin);
                return;
            }
        }
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
        if (this.pinned != null) {
            this.pinned.clear();
        }
        if (this.discarded != null) {
            this.discarded.clear();
        }
    }

    boolean isPinned(DebuggingProcess debuggingProcess) {
        Object o;
        if (this.pinned != null && (o = this.pinned.get(debuggingProcess)) != null) {
            return true;
        }
        return this.isDiscarded(debuggingProcess);
    }

    private long getPinnedId(DebuggingProcess debuggingProcess) {
        DebugPinnedInfo p;
        if (this.pinned != null && (p = (DebugPinnedInfo)this.pinned.get(debuggingProcess)) != null) {
            return p.getUniqueID();
        }
        return 0L;
    }

    private boolean isDiscarded(DebuggingProcess debuggingProcess) {
        Object o;
        return this.discarded != null && (o = this.discarded.get(debuggingProcess)) != null;
    }

    long getDiscardedId(DebuggingProcess debuggingProcess) {
        DebugPinnedInfo p;
        if (this.discarded != null && (p = (DebugPinnedInfo)this.discarded.get(debuggingProcess)) != null) {
            return p.getUniqueID();
        }
        return 0L;
    }

    Object evaluate(DebuggingProcess debuggingProcess, Evaluator evaluator) {
        if (this.isDiscarded(debuggingProcess)) {
            return null;
        }
        if (this.isPinned(debuggingProcess)) {
            DebugPinnedInfo p = (DebugPinnedInfo)this.pinned.get(debuggingProcess);
            return p.getDataInfo();
        }
        return evaluator.evaluate(this.expression);
    }

    public String getName(DebuggingProcess debuggingProcess) {
        String baseName = this.name != null ? this.name : this.expression;
        if (this.showPinnedDiscarded) {
            long id = this.getPinnedId(debuggingProcess);
            if (id != 0L) {
                return baseName + " " + DbgArb.format(265, Long.toHexString(id).toUpperCase());
            }
            id = this.getDiscardedId(debuggingProcess);
            if (id != 0L) {
                return baseName + " " + DbgArb.format(888, Long.toHexString(id).toUpperCase());
            }
        }
        return baseName;
    }
}

