/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.net.URL;
import java.util.Map;
import oracle.ide.runner.DebuggerBreakpoint;
import oracle.ide.runner.DebuggerBreakpointLogEntry;
import oracle.ide.runner.DebuggerExceptionBreakpoint;
import oracle.ide.runner.DebuggerFileLineBreakpoint;
import oracle.ide.runner.DebuggerMethodBreakpoint;
import oracle.ide.runner.DebuggerURLLineBreakpoint;
import oracle.jdevimpl.runner.debug.Breakpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExtenderBreakpoint
implements DebuggerMethodBreakpoint,
DebuggerFileLineBreakpoint,
DebuggerExceptionBreakpoint,
DebuggerURLLineBreakpoint {
    private Breakpoint breakpoint;
    private ExtenderBreakpointLogEntry logEntry;

    ExtenderBreakpoint(Breakpoint breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException("Need valid breakpoint");
        }
        this.breakpoint = breakpoint;
    }

    Breakpoint getBreakpoint() {
        return this.breakpoint;
    }

    String getDebuggerExtenderID() {
        return this.breakpoint.getDebuggerExtenderID();
    }

    void enableBreakpoint(boolean enable) {
        this.breakpoint.setEnabled(enable);
    }

    public boolean isEnabled() {
        return this.breakpoint.isEnabled();
    }

    public URL getScope() {
        return this.breakpoint.getURL();
    }

    public String getCondition() {
        return this.breakpoint.getCondition();
    }

    public boolean canEditCondition() {
        return this.breakpoint.canEditCondition();
    }

    public int getPassCount() {
        return this.breakpoint.getPassCount();
    }

    public boolean canEditPassCount() {
        return this.breakpoint.canEditPassCount();
    }

    public String getGroupName() {
        return this.breakpoint.getGroupName();
    }

    public boolean canEditGroupName() {
        return this.breakpoint.canEditGroupName();
    }

    public String getTypeString() {
        return this.breakpoint.getTypeString();
    }

    public String getBreakForThreadNamed() {
        return this.breakpoint.getThreadName();
    }

    public String getBreakForThreadNotNamed() {
        return this.breakpoint.getThreadNameNot();
    }

    public boolean canEditBreakForThreads() {
        return this.breakpoint.canEditBreakForThreads();
    }

    public boolean isHaltOnBreakpointHit() {
        return this.breakpoint.isActionHalt();
    }

    public boolean isBeepOnBreakpointHit() {
        return this.breakpoint.isActionBeep();
    }

    public DebuggerBreakpointLogEntry getLogEntryOnBreakpointHit() {
        if (this.logEntry == null) {
            this.logEntry = new ExtenderBreakpointLogEntry(null);
        }
        return this.logEntry;
    }

    public String getEnableBreakpointGroupOnBreakpointHit() {
        return this.breakpoint.getActionEnableOther();
    }

    public String getDisableBreakpointGroupOnBreakpointHit() {
        return this.breakpoint.getActionDisableOther();
    }

    public boolean canEditBreakpointHitActions() {
        return this.breakpoint.canEditBreakpointHitActions();
    }

    public Map<String, String> getProperties() {
        return this.breakpoint.getProperties();
    }

    public DebuggerBreakpoint.BreakpointKind getKind() {
        switch (this.breakpoint.getType()) {
            case 2: {
                return DebuggerBreakpoint.BreakpointKind.EXCEPTION;
            }
            case 0: {
                return DebuggerBreakpoint.BreakpointKind.FILE_LINE;
            }
            case 5: {
                return DebuggerBreakpoint.BreakpointKind.URL_LINE;
            }
            case 1: {
                return DebuggerBreakpoint.BreakpointKind.METHOD;
            }
        }
        return null;
    }

    public String getMethodName() {
        if (this.getKind() == DebuggerBreakpoint.BreakpointKind.METHOD) {
            return this.breakpoint.getMethod();
        }
        return null;
    }

    public String getPackage() {
        if (this.getKind() == DebuggerBreakpoint.BreakpointKind.FILE_LINE) {
            return this.breakpoint.getPackage();
        }
        return null;
    }

    public String getFileName() {
        if (this.getKind() == DebuggerBreakpoint.BreakpointKind.FILE_LINE) {
            return this.breakpoint.getPackage();
        }
        return null;
    }

    public int getLine() {
        if (this.getKind() == DebuggerBreakpoint.BreakpointKind.FILE_LINE || this.getKind() == DebuggerBreakpoint.BreakpointKind.URL_LINE) {
            return this.breakpoint.getLine();
        }
        return -1;
    }

    public String getExceptionName() {
        if (this.getKind() == DebuggerBreakpoint.BreakpointKind.EXCEPTION) {
            return this.breakpoint.getException();
        }
        return null;
    }

    public boolean isBreakOnCaughtExceptions() {
        if (this.getKind() == DebuggerBreakpoint.BreakpointKind.EXCEPTION) {
            return this.breakpoint.isCaught();
        }
        return false;
    }

    public boolean isBreakOnUncaughtExceptions() {
        if (this.getKind() == DebuggerBreakpoint.BreakpointKind.EXCEPTION) {
            return this.breakpoint.isUncaught();
        }
        return false;
    }

    public URL getURL() {
        if (this.getKind() == DebuggerBreakpoint.BreakpointKind.URL_LINE) {
            return this.breakpoint.getURL();
        }
        return null;
    }

    static Breakpoint ra$breakpoint(ExtenderBreakpoint extenderBreakpoint) {
        return extenderBreakpoint.breakpoint;
    }

    private class ExtenderBreakpointLogEntry
    implements DebuggerBreakpointLogEntry {
        public boolean isEnabled() {
            return ExtenderBreakpoint.ra$breakpoint(ExtenderBreakpoint.this).isActionLog();
        }

        public boolean isLogStackTrace() {
            return ExtenderBreakpoint.ra$breakpoint(ExtenderBreakpoint.this).isActionLogStack();
        }

        public String getLogTag() {
            return ExtenderBreakpoint.ra$breakpoint(ExtenderBreakpoint.this).getActionLogTag();
        }

        public String getLogExpression() {
            return ExtenderBreakpoint.ra$breakpoint(ExtenderBreakpoint.this).getActionLogExpression();
        }

        private ExtenderBreakpointLogEntry() {
        }

        ExtenderBreakpointLogEntry(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

