/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.runner.DebuggerBreakpoint;
import oracle.ide.runner.DebuggerBreakpointLogEntry;
import oracle.ide.runner.DebuggerExceptionBreakpoint;
import oracle.ide.runner.DebuggerExtender;
import oracle.ide.runner.DebuggerExtenderCallback;
import oracle.ide.runner.DebuggerFileLineBreakpoint;
import oracle.ide.runner.DebuggerMethodBreakpoint;
import oracle.ide.runner.DebuggerURLLineBreakpoint;
import oracle.jdevimpl.runner.debug.Breakpoint;
import oracle.jdevimpl.runner.debug.ExtenderBreakpoint;
import oracle.jdevimpl.runner.debug.JDebugger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExtenderCallback
implements DebuggerExtenderCallback {
    private DebuggerExtender extender;
    private String extenderID;
    private List<ExtenderBreakpoint> extenderBreakpoints;

    ExtenderCallback(DebuggerExtender extender, String extenderID) {
        this.extender = extender;
        this.extenderID = extenderID;
    }

    DebuggerExtender getExtender() {
        return this.extender;
    }

    public DebuggerBreakpoint addBreakpoint(DebuggerBreakpoint breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException("Invalid breakpoint");
        }
        Breakpoint bp = null;
        switch (1.$sm$oracle$ide$runner$DebuggerBreakpoint$BreakpointKind[breakpoint.getKind().ordinal()]) {
            case 1: {
                if (!(breakpoint instanceof DebuggerMethodBreakpoint)) {
                    throw new IllegalArgumentException("Invalid breakpoint");
                }
                DebuggerMethodBreakpoint methodBreakpoint = (DebuggerMethodBreakpoint)breakpoint;
                bp = new Breakpoint(methodBreakpoint.getScope(), 1, methodBreakpoint.getMethodName());
                break;
            }
            case 2: {
                if (!(breakpoint instanceof DebuggerFileLineBreakpoint)) {
                    throw new IllegalArgumentException("Invalid breakpoint");
                }
                DebuggerFileLineBreakpoint fileLineBreakpoint = (DebuggerFileLineBreakpoint)breakpoint;
                bp = new Breakpoint(fileLineBreakpoint.getScope(), 0, fileLineBreakpoint.getPackage(), fileLineBreakpoint.getFileName(), fileLineBreakpoint.getLine());
                break;
            }
            case 3: {
                if (!(breakpoint instanceof DebuggerURLLineBreakpoint)) {
                    throw new IllegalArgumentException("Invalid breakpoint");
                }
                DebuggerURLLineBreakpoint urlLineBreakpoint = (DebuggerURLLineBreakpoint)breakpoint;
                bp = new Breakpoint(urlLineBreakpoint.getScope(), 5, urlLineBreakpoint.getURL(), urlLineBreakpoint.getLine());
                break;
            }
            case 4: {
                if (!(breakpoint instanceof DebuggerExceptionBreakpoint)) {
                    throw new IllegalArgumentException("Invalid breakpoint");
                }
                DebuggerExceptionBreakpoint exceptionBreakpoint = (DebuggerExceptionBreakpoint)breakpoint;
                bp = new Breakpoint(exceptionBreakpoint.getScope(), 2, exceptionBreakpoint.getExceptionName(), exceptionBreakpoint.isBreakOnCaughtExceptions(), exceptionBreakpoint.isBreakOnUncaughtExceptions());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid breakpoint");
            }
        }
        bp.setDebuggerExtenderID(this.extenderID);
        bp.setEnabled(breakpoint.isEnabled());
        bp.setCondition(breakpoint.getCondition());
        bp.setCanEditCondition(breakpoint.canEditCondition());
        bp.setPassCount(breakpoint.getPassCount());
        bp.setCanEditPassCount(breakpoint.canEditPassCount());
        bp.setGroupName(breakpoint.getGroupName());
        bp.setCanEditGroupName(breakpoint.canEditGroupName());
        bp.setTypeStringOverride(breakpoint.getTypeString());
        bp.setThreadName(null);
        bp.setThreadNameNot(null);
        if (breakpoint.getBreakForThreadNamed() != null) {
            bp.setThreadName(breakpoint.getBreakForThreadNamed());
        } else if (breakpoint.getBreakForThreadNotNamed() != null) {
            bp.setThreadNameNot(breakpoint.getBreakForThreadNotNamed());
        }
        bp.setCanEditBreakForThreads(breakpoint.canEditBreakForThreads());
        bp.setActionHalt(breakpoint.isHaltOnBreakpointHit());
        bp.setActionBeep(breakpoint.isBeepOnBreakpointHit());
        DebuggerBreakpointLogEntry logEntry = breakpoint.getLogEntryOnBreakpointHit();
        if (logEntry != null) {
            bp.setActionLog(logEntry.isEnabled());
            bp.setActionLogStack(logEntry.isLogStackTrace());
            bp.setActionLogExpression(logEntry.getLogExpression());
            bp.setActionLogTag(logEntry.getLogTag());
        } else {
            bp.setActionLog(false);
            bp.setActionLogStack(false);
            bp.setActionLogExpression(null);
            bp.setActionLogTag(null);
        }
        bp.setActionEnableOther(breakpoint.getEnableBreakpointGroupOnBreakpointHit());
        bp.setActionDisableOther(breakpoint.getDisableBreakpointGroupOnBreakpointHit());
        bp.setCanEditBreakpointHitActions(breakpoint.canEditBreakpointHitActions());
        bp.setProperties(breakpoint.getProperties());
        ExtenderBreakpoint extenderBreakpoint = new ExtenderBreakpoint(bp);
        this.addExtenderBreakpoint(extenderBreakpoint);
        JDebugger.getInstance().addBreakpoint(bp);
        return extenderBreakpoint;
    }

    public boolean deleteBreakpoint(DebuggerBreakpoint breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException("Invalid breakpoint");
        }
        if (breakpoint instanceof ExtenderBreakpoint) {
            ExtenderBreakpoint extenderBreakpoint = (ExtenderBreakpoint)breakpoint;
            this.deleteExtenderBreakpoint(extenderBreakpoint);
            JDebugger.getInstance().removeBreakpoint(extenderBreakpoint.getBreakpoint());
            return true;
        }
        return false;
    }

    synchronized void deleteExtenderBreakpoint(ExtenderBreakpoint breakpoint) {
        this.getExtenderBreakpoints();
        this.extenderBreakpoints.remove(breakpoint);
    }

    private synchronized void addExtenderBreakpoint(ExtenderBreakpoint breakpoint) {
        this.getExtenderBreakpoints();
        this.extenderBreakpoints.add(breakpoint);
    }

    public boolean setEnableBreakpoint(DebuggerBreakpoint breakpoint, boolean enable) {
        if (breakpoint == null) {
            throw new IllegalArgumentException("Invalid breakpoint");
        }
        if (breakpoint instanceof ExtenderBreakpoint) {
            ((ExtenderBreakpoint)breakpoint).enableBreakpoint(enable);
            return true;
        }
        return false;
    }

    public synchronized List<? extends DebuggerBreakpoint> getBreakpoints() {
        List<ExtenderBreakpoint> currentBreakpoints = this.getExtenderBreakpoints();
        ArrayList<ExtenderBreakpoint> copy = new ArrayList<ExtenderBreakpoint>(currentBreakpoints.size());
        for (ExtenderBreakpoint extenderBreakpoint : currentBreakpoints) {
            copy.add(extenderBreakpoint);
        }
        return copy;
    }

    synchronized List<ExtenderBreakpoint> getExtenderBreakpoints() {
        if (this.extenderBreakpoints == null) {
            List<Breakpoint> breakpoints = Breakpoint.getExtenderBreakpoints(this.extenderID);
            this.extenderBreakpoints = new ArrayList<ExtenderBreakpoint>();
            for (Breakpoint breakpoint : breakpoints) {
                this.extenderBreakpoints.add(new ExtenderBreakpoint(breakpoint));
            }
        }
        return this.extenderBreakpoints;
    }

    synchronized ExtenderBreakpoint getExtenderBreakpoint(Breakpoint breakpoint) {
        List<ExtenderBreakpoint> extenderBreakpoints = this.getExtenderBreakpoints();
        for (ExtenderBreakpoint extenderBreakpoint : extenderBreakpoints) {
            if (extenderBreakpoint.getBreakpoint() != breakpoint) continue;
            return extenderBreakpoint;
        }
        return null;
    }

    static class 1 {
        static final /* synthetic */ int[] $sm$oracle$ide$runner$DebuggerBreakpoint$BreakpointKind;

        static {
            int[] nArray = new int[DebuggerBreakpoint.BreakpointKind.values().length];
            $sm$oracle$ide$runner$DebuggerBreakpoint$BreakpointKind = nArray;
            try {
                nArray[DebuggerBreakpoint.BreakpointKind.METHOD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$ide$runner$DebuggerBreakpoint$BreakpointKind[DebuggerBreakpoint.BreakpointKind.FILE_LINE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$ide$runner$DebuggerBreakpoint$BreakpointKind[DebuggerBreakpoint.BreakpointKind.URL_LINE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$ide$runner$DebuggerBreakpoint$BreakpointKind[DebuggerBreakpoint.BreakpointKind.EXCEPTION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
        }
    }
}

