/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.runner.DebuggerBreakpoint;
import oracle.ide.runner.DebuggerExtender;
import oracle.jdevimpl.runner.debug.Breakpoint;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.ExtenderBreakpoint;
import oracle.jdevimpl.runner.debug.ExtenderCallback;

class ExtenderManager {
    private Map<String, ExtenderCallback> extenderMap;

    private void $init$() {
        this.extenderMap = new HashMap<String, ExtenderCallback>();
    }

    ExtenderManager() {
        this.$init$();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExtenderCallback addExtender(DebuggerExtender extender) {
        String ID = null;
        try {
            ID = extender.getID();
            if (ID == null) {
                ExtenderCallback extenderCallback = null;
                return extenderCallback;
            }
        }
        catch (Exception ex) {
            FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
            ex.printStackTrace();
            ExtenderCallback extenderCallback = null;
            return extenderCallback;
        }
        ExtenderCallback callback = new ExtenderCallback(extender, ID);
        Map<String, ExtenderCallback> map = this.extenderMap;
        synchronized (map) {
            this.extenderMap.put(ID, callback);
        }
        return callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeExtender(DebuggerExtender extender) {
        String ID = null;
        try {
            ID = extender.getID();
            if (ID == null) {
                return;
            }
        }
        catch (Exception ex) {
            FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
            ex.printStackTrace();
        }
        Map<String, ExtenderCallback> map = this.extenderMap;
        synchronized (map) {
            this.extenderMap.remove(ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void breakpointChanged(DebuggingProcess debuggingProcess, Breakpoint breakpoint) {
        ExtenderBreakpoint extenderBreakpoint;
        ExtenderCallback callback;
        Map<String, ExtenderCallback> map = this.extenderMap;
        synchronized (map) {
            callback = this.extenderMap.get(breakpoint.getDebuggerExtenderID());
        }
        if (callback != null && (extenderBreakpoint = callback.getExtenderBreakpoint(breakpoint)) != null) {
            DebuggerBreakpoint.BreakpointState newState;
            switch (breakpoint.getActiveStatus(debuggingProcess)) {
                case 0: {
                    newState = DebuggerBreakpoint.BreakpointState.DISABLED;
                    break;
                }
                case 1: {
                    newState = DebuggerBreakpoint.BreakpointState.ENABLED;
                    break;
                }
                case 2: {
                    newState = DebuggerBreakpoint.BreakpointState.UNVERIFIED;
                    break;
                }
                case 3: {
                    newState = DebuggerBreakpoint.BreakpointState.VERIFIED;
                    break;
                }
                default: {
                    return;
                }
            }
            try {
                callback.getExtender().breakpointStateChanged((DebuggerBreakpoint)extenderBreakpoint, newState);
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void breakpointDeleted(Breakpoint breakpoint) {
        ExtenderBreakpoint extenderBreakpoint;
        ExtenderCallback callback;
        Map<String, ExtenderCallback> map = this.extenderMap;
        synchronized (map) {
            callback = this.extenderMap.get(breakpoint.getDebuggerExtenderID());
        }
        if (callback != null && (extenderBreakpoint = callback.getExtenderBreakpoint(breakpoint)) != null) {
            try {
                callback.deleteExtenderBreakpoint(extenderBreakpoint);
                callback.getExtender().breakpointDeleted((DebuggerBreakpoint)extenderBreakpoint);
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void debuggeeStoppedAtBreakpoint(Breakpoint breakpoint) {
        ExtenderBreakpoint extenderBreakpoint;
        ExtenderCallback callback;
        Map<String, ExtenderCallback> map = this.extenderMap;
        synchronized (map) {
            callback = this.extenderMap.get(breakpoint.getDebuggerExtenderID());
        }
        if (callback != null && (extenderBreakpoint = callback.getExtenderBreakpoint(breakpoint)) != null) {
            try {
                callback.getExtender().debuggeeStoppedAtBreakpoint((DebuggerBreakpoint)extenderBreakpoint);
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean canShowBreakpointLocation(Breakpoint breakpoint) {
        ExtenderBreakpoint extenderBreakpoint;
        ExtenderCallback callback;
        Map<String, ExtenderCallback> map = this.extenderMap;
        synchronized (map) {
            callback = this.extenderMap.get(breakpoint.getDebuggerExtenderID());
        }
        if (callback != null && (extenderBreakpoint = callback.getExtenderBreakpoint(breakpoint)) != null) {
            try {
                boolean bl = callback.getExtender().canShowLocation((DebuggerBreakpoint)extenderBreakpoint);
                return bl;
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean showBreakpointLocation(Breakpoint breakpoint) {
        ExtenderBreakpoint extenderBreakpoint;
        ExtenderCallback callback;
        Map<String, ExtenderCallback> map = this.extenderMap;
        synchronized (map) {
            callback = this.extenderMap.get(breakpoint.getDebuggerExtenderID());
        }
        if (callback != null && (extenderBreakpoint = callback.getExtenderBreakpoint(breakpoint)) != null) {
            try {
                boolean bl = callback.getExtender().showLocation((DebuggerBreakpoint)extenderBreakpoint);
                return bl;
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
        return false;
    }

    void newDebugSession(Context context) {
        Collection<ExtenderCallback> callbacks = this.extenderMap.values();
        for (ExtenderCallback callback : callbacks) {
            try {
                callback.getExtender().newDebugSession(context);
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"DebuggerExtender Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
    }
}

