/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.Frame;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.Version;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.WaitCursor;
import oracle.ide.layout.Layout;
import oracle.ide.model.Project;
import oracle.ide.runner.DebuggerWindowProvider;
import oracle.ide.util.PropertyAccess;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugHeapAncestor;
import oracle.jdevimpl.debugger.support.DebugHeapInfo;
import oracle.jdevimpl.debugger.support.DebugHeapSubsetAncestors;
import oracle.jdevimpl.debugger.support.DebugHeapSubsetClasses;
import oracle.jdevimpl.debugger.support.DebugPinListener;
import oracle.jdevimpl.debugger.support.DebugPinnedInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.ClassesWindow;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DataWindow;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.EditHeapClassDialog;
import oracle.jdevimpl.runner.debug.HeapWindowSettings;
import oracle.jdevimpl.runner.debug.JDebugger;

final class HeapWindow
extends DataWindow {
    private List pins;
    private List pinDebuggingProcesses;
    private List pinSubsets;
    private HeapWindowSettings heapWindowSettings = HeapWindowSettings.getInstance();
    private static IdeAction actionAddNewClass;
    private static IdeAction actionEditClass;
    private static IdeAction actionRemoveFolder;
    private static IdeAction actionShowAncestors;
    private static IdeAction actionExpandAncestor;
    private static IdeAction actionViewWhole;
    private static IdeAction actionViewAnnotations;
    private static IdeAction actionViewAnnotationsForClass;
    private static IdeAction actionAdjustRange;
    private static IdeAction actionToggleValue;
    private static IdeAction actionModifyValue;
    private static IdeAction actionWatch;
    private static IdeAction actionInspect;
    private static IdeAction actionWatchClassLoader;
    private static IdeAction actionInspectClassLoader;
    private static IdeAction actionGoto;
    private static IdeAction actionGotoDeclared;
    private static IdeAction actionGotoField;
    private static IdeAction actionRemoveAllFolders;
    private static IdeAction actionUseFilters;
    private static IdeAction actionObjectPreferences;
    private static IdeAction actionCollapseAll;
    private static IdeAction actionSave;
    private static IdeAction actionSettings;
    private static JMenuItem menuitemAddNewClass;
    private static JMenuItem menuitemEditClass;
    private static JMenuItem menuitemRemoveFolder;
    private static JMenuItem menuitemShowAncestors;
    private static JMenuItem menuitemExpandAncestor;
    private static JMenuItem menuitemRemoveAllFolders;
    private static JMenuItem menuitemSettings;
    private static final int ADD_NEW_CLASS_CMD_ID;
    private static final int EDIT_CLASS_CMD_ID;
    private static final int REMOVE_FOLDER_CMD_ID;
    private static final int SHOW_ANCESTORS_CMD_ID;
    private static final int EXPAND_ANCESTOR_CMD_ID;
    private static final int VIEW_WHOLE_CMD_ID;
    private static final int VIEW_ANNOTATIONS_CMD_ID;
    private static final int VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID;
    private static final int ADJUST_RANGE_CMD_ID;
    private static final int TOGGLE_VALUE_CMD_ID;
    private static final int MODIFY_VALUE_CMD_ID;
    private static final int WATCH_CMD_ID;
    private static final int INSPECT_CMD_ID;
    private static final int WATCH_CLASSLOADER_CMD_ID;
    private static final int INSPECT_CLASSLOADER_CMD_ID;
    private static final int GOTO_CMD_ID;
    private static final int GOTO_DECLARED_CMD_ID;
    private static final int GOTO_FIELD_CMD_ID;
    private static final int REMOVE_ALL_FOLDERS_CMD_ID;
    private static final int USE_FILTERS_CMD_ID;
    private static final int OBJECT_PREFERENCES_CMD_ID;
    private static final int COLLAPSE_ALL_CMD_ID;
    private static final int SAVE_CMD_ID;
    private static final int SETTINGS_CMD_ID;
    static final String HEAP_WINDOW_ID = "Debugger.HeapWindow";
    private static Icon heapTabIcon;
    private static final String HEAP_KEY_COUNT = "Heap.Count";
    private static final String HEAP_KEY_PREFIX = "Heap.";
    private static final String HEAP_KEY_DOT = ".";
    private static final String HEAP_KEY_SCOPE = "scope";
    private static final String HEAP_KEY_CLASS = "class";
    private static final String GlobalHeapScope = "GlobalHeapScope";

    HeapWindow() {
        super(HEAP_WINDOW_ID, DbgArb.getString(86), "f1_deb_heapwindow_html");
        HeapWindow.makeActions();
        this.setDataPanel(new HeapPanel());
        this.setControllerForActions();
    }

    public DebuggerWindowProvider.DebuggerWindowPosition getPosition() {
        return DebuggerWindowProvider.DebuggerWindowPosition.SOUTH;
    }

    public boolean installByDefault() {
        return true;
    }

    public void shutDown() {
        super.shutDown();
        HeapPanel.mav$saveClasses((HeapPanel)this.dataPanel, (PropertyAccess)Ide.getIdeProperties());
    }

    public int getDefaultVisibility(Layout layout) {
        return 0;
    }

    public Icon getTabIcon() {
        if (heapTabIcon == null) {
            heapTabIcon = DbgArb.getIcon(305);
        }
        return heapTabIcon;
    }

    public String getMenuTitle() {
        if (!JDebugger.getInstance().canShowHeapWindow()) {
            return null;
        }
        return this.title;
    }

    public Component getGUI() {
        if (!JDebugger.getInstance().canShowHeapWindow()) {
            return null;
        }
        return super.getGUI();
    }

    static void addContextMenuToMainMenu(Menubar menubar, JMenu subMenu) {
        HeapWindow.makeActions();
        float section = 1.0f;
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionAddNewClass), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionEditClass), subMenu, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionRemoveFolder), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionShowAncestors), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionExpandAncestor), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionViewWhole), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionViewAnnotations), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionViewAnnotationsForClass), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionAdjustRange), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionToggleValue), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionModifyValue), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionWatch), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionInspect), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionWatchClassLoader), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionInspectClassLoader), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGoto), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGotoDeclared), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGotoField), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionRemoveAllFolders), subMenu, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionUseFilters), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionObjectPreferences), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionCollapseAll), subMenu, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSave), subMenu, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSettings), subMenu, section);
    }

    private static void makeActions() {
        if (actionShowAncestors == null) {
            actionShowAncestors = IdeAction.get((int)SHOW_ANCESTORS_CMD_ID, null, (String)DbgArb.getString(958), null, (Integer)DbgArb.getInteger(659), null, (int)-1, null, (boolean)false);
            actionShowAncestors.setEnabled(false);
            actionExpandAncestor = IdeAction.get((int)EXPAND_ANCESTOR_CMD_ID, null, (String)DbgArb.getString(876), null, (Integer)DbgArb.getInteger(570), null, (int)-1, null, (boolean)false);
            actionExpandAncestor.setEnabled(false);
            actionEditClass = IdeAction.get((int)EDIT_CLASS_CMD_ID, null, (String)DbgArb.getString(233), null, (Integer)DbgArb.getInteger(45), null, (int)-1, null, (boolean)false);
            actionEditClass.setEnabled(false);
            actionRemoveFolder = IdeAction.get((int)REMOVE_FOLDER_CMD_ID, null, (String)DbgArb.getString(919), null, (Integer)DbgArb.getInteger(168), null, (int)-1, null, (boolean)false);
            actionRemoveFolder.setEnabled(false);
            actionViewWhole = IdeAction.get((int)VIEW_WHOLE_CMD_ID, null, (String)DbgArb.getString(333), null, (Integer)DbgArb.getInteger(824), null, (int)-1, null, (boolean)false);
            actionViewWhole.setEnabled(false);
            actionViewAnnotations = IdeAction.get((int)VIEW_ANNOTATIONS_CMD_ID, null, (String)DbgArb.getString(33), null, (Integer)DbgArb.getInteger(961), null, (int)-1, null, (boolean)false);
            actionViewAnnotations.putValue("NoCtxName", (Object)DbgArb.getString(33));
            actionViewAnnotations.setEnabled(false);
            actionViewAnnotationsForClass = IdeAction.get((int)VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID, null, (String)DbgArb.getString(844), null, (Integer)DbgArb.getInteger(884), null, (int)-1, null, (boolean)false);
            actionViewAnnotationsForClass.setEnabled(false);
            actionAdjustRange = IdeAction.get((int)ADJUST_RANGE_CMD_ID, null, (String)DbgArb.getString(157), null, (Integer)DbgArb.getInteger(810), null, (int)-1, null, (boolean)false);
            actionAdjustRange.setEnabled(false);
            actionToggleValue = IdeAction.get((int)TOGGLE_VALUE_CMD_ID, null, (String)DbgArb.getString(183), null, (Integer)DbgArb.getInteger(891), null, (int)-1, null, (boolean)false);
            actionToggleValue.setEnabled(false);
            actionModifyValue = IdeAction.get((int)MODIFY_VALUE_CMD_ID, null, (String)DbgArb.getString(429), null, (Integer)DbgArb.getInteger(267), null, (int)-1, null, (boolean)false);
            actionModifyValue.setEnabled(false);
            actionWatch = IdeAction.get((int)WATCH_CMD_ID, null, (String)DbgArb.getString(197), null, (Integer)DbgArb.getInteger(682), null, (int)-1, null, (boolean)false);
            actionWatch.setEnabled(false);
            actionInspect = IdeAction.get((int)INSPECT_CMD_ID, null, (String)DbgArb.getString(96), null, (Integer)DbgArb.getInteger(484), null, (int)-1, null, (boolean)false);
            actionInspect.setEnabled(false);
            actionWatchClassLoader = IdeAction.get((int)WATCH_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(205), null, (Integer)DbgArb.getInteger(505), null, (int)-1, null, (boolean)false);
            actionWatchClassLoader.setEnabled(false);
            actionInspectClassLoader = IdeAction.get((int)INSPECT_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(273), null, (Integer)DbgArb.getInteger(921), null, (int)-1, null, (boolean)false);
            actionInspectClassLoader.setEnabled(false);
            actionGoto = IdeAction.get((int)GOTO_CMD_ID, null, (String)DbgArb.getString(389), null, (Integer)DbgArb.getInteger(598), null, (int)-1, null, (boolean)false);
            actionGoto.putValue("NoCtxName", (Object)DbgArb.getString(389));
            actionGoto.setEnabled(false);
            actionGotoDeclared = IdeAction.get((int)GOTO_DECLARED_CMD_ID, null, (String)DbgArb.getString(851), null, (Integer)DbgArb.getInteger(926), null, (int)-1, null, (boolean)false);
            actionGotoDeclared.putValue("NoCtxName", (Object)DbgArb.getString(851));
            actionGotoDeclared.setEnabled(false);
            actionGotoField = IdeAction.get((int)GOTO_FIELD_CMD_ID, null, (String)DbgArb.getString(617), null, (Integer)DbgArb.getInteger(788), null, (int)-1, null, (boolean)false);
            actionGotoField.putValue("NoCtxName", (Object)DbgArb.getString(617));
            actionGotoField.setEnabled(false);
            actionAddNewClass = IdeAction.get((int)ADD_NEW_CLASS_CMD_ID, null, (String)DbgArb.getString(94), null, (Integer)DbgArb.getInteger(47), null, (int)-1, null, (boolean)false);
            actionAddNewClass.setEnabled(false);
            actionRemoveAllFolders = IdeAction.get((int)REMOVE_ALL_FOLDERS_CMD_ID, null, (String)DbgArb.getString(848), null, (Integer)DbgArb.getInteger(825), null, (int)-1, null, (boolean)false);
            actionRemoveAllFolders.setEnabled(false);
            actionUseFilters = IdeAction.get((int)USE_FILTERS_CMD_ID, null, (String)DbgArb.getString(637), null, (Integer)DbgArb.getInteger(412), null, (int)-1, null, (boolean)false);
            actionUseFilters.putValue("Check", (Object)Boolean.TRUE);
            actionUseFilters.setEnabled(false);
            actionObjectPreferences = IdeAction.get((int)OBJECT_PREFERENCES_CMD_ID, null, (String)DbgArb.format(892, ""), null, (Integer)DbgArb.getInteger(594), null, (int)-1, null, (boolean)false);
            actionObjectPreferences.setEnabled(false);
            actionSettings = IdeAction.get((int)SETTINGS_CMD_ID, null, (String)RunMgrArb.getString(87), null, (Integer)RunMgrArb.getInteger(99), null, (int)-1, null, (boolean)false);
            actionSettings.setEnabled(false);
            actionCollapseAll = IdeAction.get((int)COLLAPSE_ALL_CMD_ID, null, (String)RunMgrArb.getString(0), null, (Integer)RunMgrArb.getInteger(7), null, (int)-1, null, (boolean)false);
            actionCollapseAll.setEnabled(false);
            actionSave = IdeAction.get((int)SAVE_CMD_ID, null, (String)RunMgrArb.getString(65), null, (Integer)RunMgrArb.getInteger(101), null, (int)-1, null, (boolean)false);
            actionSave.setEnabled(false);
        }
    }

    private void setControllerForActions() {
        IdeAction[] actions = new IdeAction[]{actionShowAncestors, actionExpandAncestor, actionEditClass, actionRemoveFolder, actionViewWhole, actionViewAnnotations, actionViewAnnotationsForClass, actionAdjustRange, actionToggleValue, actionModifyValue, actionWatch, actionInspect, actionWatchClassLoader, actionInspectClassLoader, actionGoto, actionGotoDeclared, actionGotoField, actionAddNewClass, actionRemoveAllFolders, actionUseFilters, actionObjectPreferences, actionSettings, actionCollapseAll, actionSave};
        JDebugger.setControllerForActions(actions, this.dataPanel);
    }

    void addHeapClass(String name) {
        ((HeapPanel)this.dataPanel).addClass(name);
    }

    static {
        ADD_NEW_CLASS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapAddNewClass");
        EDIT_CLASS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapEditClass");
        REMOVE_FOLDER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapRemoveFolder");
        SHOW_ANCESTORS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapShowAncestors");
        EXPAND_ANCESTOR_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapExpandAncestor");
        VIEW_WHOLE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapViewWhole");
        VIEW_ANNOTATIONS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapViewAnnotations");
        VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapViewAnnotationsForClass");
        ADJUST_RANGE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapAdjustRange");
        TOGGLE_VALUE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapToggleValue");
        MODIFY_VALUE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapModifyValue");
        WATCH_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapWatch");
        INSPECT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapInspect");
        WATCH_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapWatchClassLoader");
        INSPECT_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapInspectClassLoader");
        GOTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapGoto");
        GOTO_DECLARED_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapGotoDeclared");
        GOTO_FIELD_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapGotoField");
        REMOVE_ALL_FOLDERS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapRemoveAllFolders");
        USE_FILTERS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapUseFilters");
        OBJECT_PREFERENCES_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapObjectPreferences");
        COLLAPSE_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapCollapseAll");
        SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapSave");
        SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapSettings");
        heapTabIcon = null;
    }

    static HeapWindowSettings ra$heapWindowSettings(HeapWindow heapWindow) {
        return heapWindow.heapWindowSettings;
    }

    static List ra$pins(HeapWindow heapWindow) {
        return heapWindow.pins;
    }

    static void wa$pins(HeapWindow heapWindow, List list) {
        heapWindow.pins = list;
    }

    static List ra$pinDebuggingProcesses(HeapWindow heapWindow) {
        return heapWindow.pinDebuggingProcesses;
    }

    static void wa$pinDebuggingProcesses(HeapWindow heapWindow, List list) {
        heapWindow.pinDebuggingProcesses = list;
    }

    static List ra$pinSubsets(HeapWindow heapWindow) {
        return heapWindow.pinSubsets;
    }

    static void wa$pinSubsets(HeapWindow heapWindow, List list) {
        heapWindow.pinSubsets = list;
    }

    static int ra$SHOW_ANCESTORS_CMD_ID() {
        return SHOW_ANCESTORS_CMD_ID;
    }

    static int ra$EXPAND_ANCESTOR_CMD_ID() {
        return EXPAND_ANCESTOR_CMD_ID;
    }

    static int ra$EDIT_CLASS_CMD_ID() {
        return EDIT_CLASS_CMD_ID;
    }

    static int ra$REMOVE_FOLDER_CMD_ID() {
        return REMOVE_FOLDER_CMD_ID;
    }

    static int ra$ADD_NEW_CLASS_CMD_ID() {
        return ADD_NEW_CLASS_CMD_ID;
    }

    static int ra$REMOVE_ALL_FOLDERS_CMD_ID() {
        return REMOVE_ALL_FOLDERS_CMD_ID;
    }

    static int ra$SETTINGS_CMD_ID() {
        return SETTINGS_CMD_ID;
    }

    static IdeAction ra$actionSettings() {
        return actionSettings;
    }

    static JMenuItem ra$menuitemSettings() {
        return menuitemSettings;
    }

    static void wa$menuitemSettings(JMenuItem jMenuItem) {
        menuitemSettings = jMenuItem;
    }

    static IdeAction ra$actionRemoveAllFolders() {
        return actionRemoveAllFolders;
    }

    static JMenuItem ra$menuitemRemoveAllFolders() {
        return menuitemRemoveAllFolders;
    }

    static void wa$menuitemRemoveAllFolders(JMenuItem jMenuItem) {
        menuitemRemoveAllFolders = jMenuItem;
    }

    static IdeAction ra$actionEditClass() {
        return actionEditClass;
    }

    static JMenuItem ra$menuitemEditClass() {
        return menuitemEditClass;
    }

    static void wa$menuitemEditClass(JMenuItem jMenuItem) {
        menuitemEditClass = jMenuItem;
    }

    static IdeAction ra$actionRemoveFolder() {
        return actionRemoveFolder;
    }

    static JMenuItem ra$menuitemRemoveFolder() {
        return menuitemRemoveFolder;
    }

    static void wa$menuitemRemoveFolder(JMenuItem jMenuItem) {
        menuitemRemoveFolder = jMenuItem;
    }

    static IdeAction ra$actionShowAncestors() {
        return actionShowAncestors;
    }

    static JMenuItem ra$menuitemShowAncestors() {
        return menuitemShowAncestors;
    }

    static void wa$menuitemShowAncestors(JMenuItem jMenuItem) {
        menuitemShowAncestors = jMenuItem;
    }

    static IdeAction ra$actionExpandAncestor() {
        return actionExpandAncestor;
    }

    static JMenuItem ra$menuitemExpandAncestor() {
        return menuitemExpandAncestor;
    }

    static void wa$menuitemExpandAncestor(JMenuItem jMenuItem) {
        menuitemExpandAncestor = jMenuItem;
    }

    static IdeAction ra$actionAddNewClass() {
        return actionAddNewClass;
    }

    static JMenuItem ra$menuitemAddNewClass() {
        return menuitemAddNewClass;
    }

    static void wa$menuitemAddNewClass(JMenuItem jMenuItem) {
        menuitemAddNewClass = jMenuItem;
    }

    static IdeAction ra$actionViewWhole() {
        return actionViewWhole;
    }

    static IdeAction ra$actionViewAnnotations() {
        return actionViewAnnotations;
    }

    static IdeAction ra$actionViewAnnotationsForClass() {
        return actionViewAnnotationsForClass;
    }

    static IdeAction ra$actionAdjustRange() {
        return actionAdjustRange;
    }

    static IdeAction ra$actionToggleValue() {
        return actionToggleValue;
    }

    static IdeAction ra$actionModifyValue() {
        return actionModifyValue;
    }

    static IdeAction ra$actionWatch() {
        return actionWatch;
    }

    static IdeAction ra$actionInspect() {
        return actionInspect;
    }

    static IdeAction ra$actionWatchClassLoader() {
        return actionWatchClassLoader;
    }

    static IdeAction ra$actionInspectClassLoader() {
        return actionInspectClassLoader;
    }

    static IdeAction ra$actionGoto() {
        return actionGoto;
    }

    static IdeAction ra$actionGotoDeclared() {
        return actionGotoDeclared;
    }

    static IdeAction ra$actionGotoField() {
        return actionGotoField;
    }

    static IdeAction ra$actionUseFilters() {
        return actionUseFilters;
    }

    static IdeAction ra$actionObjectPreferences() {
        return actionObjectPreferences;
    }

    static IdeAction ra$actionCollapseAll() {
        return actionCollapseAll;
    }

    static IdeAction ra$actionSave() {
        return actionSave;
    }

    static int ra$VIEW_WHOLE_CMD_ID() {
        return VIEW_WHOLE_CMD_ID;
    }

    static int ra$VIEW_ANNOTATIONS_CMD_ID() {
        return VIEW_ANNOTATIONS_CMD_ID;
    }

    static int ra$VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID() {
        return VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID;
    }

    static int ra$ADJUST_RANGE_CMD_ID() {
        return ADJUST_RANGE_CMD_ID;
    }

    static int ra$TOGGLE_VALUE_CMD_ID() {
        return TOGGLE_VALUE_CMD_ID;
    }

    static int ra$MODIFY_VALUE_CMD_ID() {
        return MODIFY_VALUE_CMD_ID;
    }

    static int ra$WATCH_CMD_ID() {
        return WATCH_CMD_ID;
    }

    static int ra$INSPECT_CMD_ID() {
        return INSPECT_CMD_ID;
    }

    static int ra$WATCH_CLASSLOADER_CMD_ID() {
        return WATCH_CLASSLOADER_CMD_ID;
    }

    static int ra$INSPECT_CLASSLOADER_CMD_ID() {
        return INSPECT_CLASSLOADER_CMD_ID;
    }

    static int ra$GOTO_CMD_ID() {
        return GOTO_CMD_ID;
    }

    static int ra$GOTO_DECLARED_CMD_ID() {
        return GOTO_DECLARED_CMD_ID;
    }

    static int ra$GOTO_FIELD_CMD_ID() {
        return GOTO_FIELD_CMD_ID;
    }

    static int ra$USE_FILTERS_CMD_ID() {
        return USE_FILTERS_CMD_ID;
    }

    static int ra$OBJECT_PREFERENCES_CMD_ID() {
        return OBJECT_PREFERENCES_CMD_ID;
    }

    static int ra$COLLAPSE_ALL_CMD_ID() {
        return COLLAPSE_ALL_CMD_ID;
    }

    static int ra$SAVE_CMD_ID() {
        return SAVE_CMD_ID;
    }

    final class HeapPanel
    extends DataPanel
    implements DebugPinListener {
        private Map mapProjectHeapFolders;
        private Map mapProcessHeapFolders;

        HeapPanel() {
            super(HeapWindow.this, HeapWindow.ra$heapWindowSettings(HeapWindow.this).getDataPanelSettings());
            this.mapProjectHeapFolders = new HashMap();
            this.mapProcessHeapFolders = new HashMap();
            this.loadHeap((PropertyAccess)Ide.getIdeProperties());
            this._actionViewWhole = HeapWindow.ra$actionViewWhole();
            this._actionViewAnnotations = HeapWindow.ra$actionViewAnnotations();
            this._actionViewAnnotationsForClass = HeapWindow.ra$actionViewAnnotationsForClass();
            this._actionAdjustRange = HeapWindow.ra$actionAdjustRange();
            this._actionToggleValue = HeapWindow.ra$actionToggleValue();
            this._actionModifyValue = HeapWindow.ra$actionModifyValue();
            this._actionWatch = HeapWindow.ra$actionWatch();
            this._actionInspect = HeapWindow.ra$actionInspect();
            this._actionWatchClassLoader = HeapWindow.ra$actionWatchClassLoader();
            this._actionInspectClassLoader = HeapWindow.ra$actionInspectClassLoader();
            this._actionGoto = HeapWindow.ra$actionGoto();
            this._actionGotoDeclared = HeapWindow.ra$actionGotoDeclared();
            this._actionGotoField = HeapWindow.ra$actionGotoField();
            this._actionUseFilters = HeapWindow.ra$actionUseFilters();
            this._actionObjectPreferences = HeapWindow.ra$actionObjectPreferences();
            this._actionCollapseAll = HeapWindow.ra$actionCollapseAll();
            this._actionSave = HeapWindow.ra$actionSave();
            this._VIEW_WHOLE_CMD_ID = HeapWindow.ra$VIEW_WHOLE_CMD_ID();
            this._VIEW_ANNOTATIONS_CMD_ID = HeapWindow.ra$VIEW_ANNOTATIONS_CMD_ID();
            this._VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID = HeapWindow.ra$VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID();
            this._ADJUST_RANGE_CMD_ID = HeapWindow.ra$ADJUST_RANGE_CMD_ID();
            this._TOGGLE_VALUE_CMD_ID = HeapWindow.ra$TOGGLE_VALUE_CMD_ID();
            this._MODIFY_VALUE_CMD_ID = HeapWindow.ra$MODIFY_VALUE_CMD_ID();
            this._WATCH_CMD_ID = HeapWindow.ra$WATCH_CMD_ID();
            this._INSPECT_CMD_ID = HeapWindow.ra$INSPECT_CMD_ID();
            this._WATCH_CLASSLOADER_CMD_ID = HeapWindow.ra$WATCH_CLASSLOADER_CMD_ID();
            this._INSPECT_CLASSLOADER_CMD_ID = HeapWindow.ra$INSPECT_CLASSLOADER_CMD_ID();
            this._GOTO_CMD_ID = HeapWindow.ra$GOTO_CMD_ID();
            this._GOTO_DECLARED_CMD_ID = HeapWindow.ra$GOTO_DECLARED_CMD_ID();
            this._GOTO_FIELD_CMD_ID = HeapWindow.ra$GOTO_FIELD_CMD_ID();
            this._USE_FILTERS_CMD_ID = HeapWindow.ra$USE_FILTERS_CMD_ID();
            this._OBJECT_PREFERENCES_CMD_ID = HeapWindow.ra$OBJECT_PREFERENCES_CMD_ID();
            this._COLLAPSE_ALL_CMD_ID = HeapWindow.ra$COLLAPSE_ALL_CMD_ID();
            this._SAVE_CMD_ID = HeapWindow.ra$SAVE_CMD_ID();
        }

        protected void adjustGUI() {
            if (Version.DEBUG_BUILD != 0) {
                this.heapAncestorOutsideHeapFont = this.getBoldFont();
                this.ancestorDepthZeroFont = this.getBoldItalicFont();
            } else {
                this.ancestorDepthZeroFont = this.getBoldFont();
            }
            this.treeTable.addKeyListener((KeyListener)new 1());
        }

        private void loadHeap(PropertyAccess properties) {
            String s = properties.getProperty(HeapWindow.HEAP_KEY_COUNT, null);
            if (s != null) {
                try {
                    int count = Integer.parseInt(s);
                    int i = 0;
                    while (i < count) {
                        this.loadHeapItem(properties, i);
                        ++i;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }

        private boolean loadHeapItem(PropertyAccess properties, int number) {
            String prefix = HeapWindow.HEAP_KEY_PREFIX + number + HeapWindow.HEAP_KEY_DOT;
            String scope = properties.getProperty(prefix + HeapWindow.HEAP_KEY_SCOPE, HeapWindow.GlobalHeapScope);
            String s = properties.getProperty(prefix + HeapWindow.HEAP_KEY_CLASS, null);
            if (s != null && s.length() > 0) {
                ArrayList<String> list = (ArrayList<String>)this.mapProjectHeapFolders.get(scope);
                if (list == null) {
                    list = new ArrayList<String>();
                    this.mapProjectHeapFolders.put(scope, list);
                }
                list.add(s);
                return true;
            }
            return false;
        }

        private void saveClasses(PropertyAccess properties) {
            int previousCount = 0;
            String s = properties.getProperty(HeapWindow.HEAP_KEY_COUNT, null);
            if (s != null) {
                try {
                    previousCount = Integer.parseInt(s);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            int count = 0;
            for (String scope : this.mapProjectHeapFolders.keySet()) {
                List list = (List)this.mapProjectHeapFolders.get(scope);
                for (String name : list) {
                    this.saveClass(properties, count, scope, name);
                    ++count;
                }
            }
            int i = count;
            while (i < previousCount) {
                this.removeSavedClass(properties, i);
                ++i;
            }
            properties.setProperty(HeapWindow.HEAP_KEY_COUNT, Integer.toString(count));
        }

        private void saveClass(PropertyAccess properties, int number, String scope, String name) {
            String prefix = HeapWindow.HEAP_KEY_PREFIX + number + HeapWindow.HEAP_KEY_DOT;
            properties.setProperty(prefix + HeapWindow.HEAP_KEY_SCOPE, scope);
            properties.setProperty(prefix + HeapWindow.HEAP_KEY_CLASS, name);
        }

        private void removeSavedClass(PropertyAccess properties, int number) {
            String prefix = HeapWindow.HEAP_KEY_PREFIX + number + HeapWindow.HEAP_KEY_DOT;
            properties.setProperty(prefix + HeapWindow.HEAP_KEY_SCOPE, null);
            properties.setProperty(prefix + HeapWindow.HEAP_KEY_CLASS, null);
        }

        protected void addPopupMenuItemsForNew(ContextMenu popup, Context context) {
            this.update(HeapWindow.ra$actionAddNewClass(), context);
            if (HeapWindow.ra$actionAddNewClass().isEnabled()) {
                if (HeapWindow.ra$menuitemAddNewClass() == null) {
                    HeapWindow.wa$menuitemAddNewClass(popup.createMenuItem((ToggleAction)HeapWindow.ra$actionAddNewClass()));
                }
                popup.add((Component)HeapWindow.ra$menuitemAddNewClass(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_NEW_ITEM_CTXT_MENU);
            }
            super.addPopupMenuItemsForNew(popup, context);
        }

        protected void addPopupMenuItemsForDataItem(ContextMenu popup, Context context) {
            this.update(HeapWindow.ra$actionEditClass(), context);
            if (HeapWindow.ra$actionEditClass().isEnabled()) {
                if (HeapWindow.ra$menuitemEditClass() == null) {
                    HeapWindow.wa$menuitemEditClass(popup.createMenuItem((ToggleAction)HeapWindow.ra$actionEditClass()));
                }
                popup.add((Component)HeapWindow.ra$menuitemEditClass(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            this.update(HeapWindow.ra$actionRemoveFolder(), context);
            if (HeapWindow.ra$actionRemoveFolder().isEnabled()) {
                if (HeapWindow.ra$menuitemRemoveFolder() == null) {
                    HeapWindow.wa$menuitemRemoveFolder(popup.createMenuItem((ToggleAction)HeapWindow.ra$actionRemoveFolder()));
                }
                popup.add((Component)HeapWindow.ra$menuitemRemoveFolder(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            this.update(HeapWindow.ra$actionShowAncestors(), context);
            if (HeapWindow.ra$actionShowAncestors().isEnabled()) {
                if (HeapWindow.ra$menuitemShowAncestors() == null) {
                    HeapWindow.wa$menuitemShowAncestors(popup.createMenuItem((ToggleAction)HeapWindow.ra$actionShowAncestors()));
                }
                popup.add((Component)HeapWindow.ra$menuitemShowAncestors(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            this.update(HeapWindow.ra$actionExpandAncestor(), context);
            if (HeapWindow.ra$actionExpandAncestor().isEnabled()) {
                if (HeapWindow.ra$menuitemExpandAncestor() == null) {
                    HeapWindow.wa$menuitemExpandAncestor(popup.createMenuItem((ToggleAction)HeapWindow.ra$actionExpandAncestor()));
                }
                popup.add((Component)HeapWindow.ra$menuitemExpandAncestor(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            super.addPopupMenuItemsForDataItem(popup, context);
        }

        protected void addPopupMenuItemsForData(ContextMenu popup, Context context) {
            this.update(HeapWindow.ra$actionRemoveAllFolders(), context);
            if (HeapWindow.ra$actionRemoveAllFolders().isEnabled()) {
                if (HeapWindow.ra$menuitemRemoveAllFolders() == null) {
                    HeapWindow.wa$menuitemRemoveAllFolders(popup.createMenuItem((ToggleAction)HeapWindow.ra$actionRemoveAllFolders()));
                }
                popup.add((Component)HeapWindow.ra$menuitemRemoveAllFolders(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_SPECIFIC_CTXT_MENU);
            }
            super.addPopupMenuItemsForData(popup, context);
        }

        protected void addPopupMenuItemsForCommon(ContextMenu popup, Context context) {
            super.addPopupMenuItemsForCommon(popup, context);
            this.update(HeapWindow.ra$actionSettings(), context);
            if (HeapWindow.ra$actionSettings().isEnabled()) {
                if (HeapWindow.ra$menuitemSettings() == null) {
                    HeapWindow.wa$menuitemSettings(popup.createMenuItem((ToggleAction)HeapWindow.ra$actionSettings()));
                }
                popup.add((Component)HeapWindow.ra$menuitemSettings(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
            }
        }

        public boolean update(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (action.getValue("Debugger.actionOwner") == this) {
                if (this.treeTable == null || !this.dockableWindow.isVisible()) {
                    action.setEnabled(false);
                    return true;
                }
                if (!(this.treeTable.isEnabled() && this.debuggingProcess != null && this.vm != null || cmdId == HeapWindow.ra$SETTINGS_CMD_ID())) {
                    action.setEnabled(false);
                    return true;
                }
            }
            if (cmdId == HeapWindow.ra$SHOW_ANCESTORS_CMD_ID()) {
                DataPanel.DataItem dataItem = this.getSelectedDataItem();
                if (dataItem != null) {
                    action.setEnabled(this.canShowAncestors(dataItem));
                } else {
                    action.setEnabled(false);
                }
                return true;
            }
            if (cmdId == HeapWindow.ra$EXPAND_ANCESTOR_CMD_ID()) {
                DataPanel.DataItem dataItem = this.getSelectedDataItem();
                TreePath treePath = this.getSelectedTreePath();
                if (dataItem != null && treePath != null) {
                    action.setEnabled(this.canExpandAncestor(dataItem));
                } else {
                    action.setEnabled(false);
                }
                return true;
            }
            if (cmdId == HeapWindow.ra$EDIT_CLASS_CMD_ID()) {
                DataPanel.DataItem dataItem = this.getSelectedDataItem();
                TreePath treePath = this.getSelectedTreePath();
                if (dataItem instanceof HeapClassFolderDataItem && treePath != null) {
                    action.setEnabled(true);
                } else {
                    action.setEnabled(false);
                }
                return true;
            }
            if (cmdId == HeapWindow.ra$REMOVE_FOLDER_CMD_ID()) {
                DataPanel.DataItem dataItem = this.getSelectedDataItem();
                if (dataItem instanceof HeapDataItem) {
                    action.setEnabled(true);
                } else {
                    action.setEnabled(false);
                }
                return true;
            }
            if (cmdId == HeapWindow.ra$ADD_NEW_CLASS_CMD_ID()) {
                action.setEnabled(true);
                return true;
            }
            if (cmdId == HeapWindow.ra$REMOVE_ALL_FOLDERS_CMD_ID()) {
                action.setEnabled(this.canRemoveAllFolders());
                return true;
            }
            if (cmdId == HeapWindow.ra$SETTINGS_CMD_ID()) {
                action.setEnabled(true);
                return true;
            }
            return super.update(action, context);
        }

        public boolean handleEvent(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (cmdId == HeapWindow.ra$SHOW_ANCESTORS_CMD_ID()) {
                DataPanel.DataItem dataItem = this.getSelectedDataItem();
                if (dataItem != null) {
                    WaitCursor wc = Ide.getWaitCursor();
                    wc.show();
                    this.showAncestors(dataItem);
                    wc.hide();
                }
                return true;
            }
            if (cmdId == HeapWindow.ra$EXPAND_ANCESTOR_CMD_ID()) {
                DataPanel.DataItem dataItem = this.getSelectedDataItem();
                TreePath treePath = this.getSelectedTreePath();
                if (dataItem != null && treePath != null) {
                    WaitCursor wc = Ide.getWaitCursor();
                    wc.show();
                    this.expandAncestor(dataItem, treePath);
                    wc.hide();
                }
                return true;
            }
            if (cmdId == HeapWindow.ra$EDIT_CLASS_CMD_ID()) {
                DataPanel.DataItem dataItem = this.getSelectedDataItem();
                TreePath treePath = this.getSelectedTreePath();
                if (dataItem instanceof HeapClassFolderDataItem && treePath != null) {
                    this.editClass((HeapClassFolderDataItem)dataItem, treePath);
                }
                return true;
            }
            if (cmdId == HeapWindow.ra$REMOVE_FOLDER_CMD_ID()) {
                DataPanel.DataItem dataItem = this.getSelectedDataItem();
                if (dataItem instanceof HeapDataItem) {
                    this.removeFolder((HeapDataItem)dataItem);
                }
                return true;
            }
            if (cmdId == HeapWindow.ra$ADD_NEW_CLASS_CMD_ID()) {
                this.addNewClass();
                return true;
            }
            if (cmdId == HeapWindow.ra$REMOVE_ALL_FOLDERS_CMD_ID()) {
                this.removeAllFolders();
                return true;
            }
            if (cmdId == HeapWindow.ra$SETTINGS_CMD_ID()) {
                String[] path = new String[]{DbgArb.getString(16), DbgArb.getString(934)};
                Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), path);
                return true;
            }
            return super.handleEvent(action, context);
        }

        protected void addDataItems() {
            List processHeapFolders = this.getProcessHeapFolders(this.debuggingProcess);
            if (processHeapFolders != null) {
                List root = this.getRoot();
                for (Object o : processHeapFolders) {
                    if (o instanceof String) {
                        String name = (String)o;
                        Object subset = this.makeHeapSubsetForClass(name);
                        HeapClassFolderDataItem heapClassFolderDataItem = new HeapClassFolderDataItem(subset);
                        root.add(heapClassFolderDataItem);
                        continue;
                    }
                    if (!(o instanceof HeapAncestorSubset)) continue;
                    HeapAncestorSubset has = (HeapAncestorSubset)o;
                    Object subset = this.makeHeapSubsetForAncestors(has);
                    HeapAncestorsFolderDataItem heapAncestorsFolderDataItem = new HeapAncestorsFolderDataItem(subset, has);
                    root.add(heapAncestorsFolderDataItem);
                }
            }
        }

        private Object makeHeapSubsetForClass(String name) {
            DebugHeapInfo heap;
            DebugHeapSubsetClasses subset = new DebugHeapSubsetClasses(name, null);
            subset.addClass(name, false);
            if (this.vm != null && (heap = this.vm.getHeap(subset)) != null) {
                return heap;
            }
            return subset;
        }

        protected void checkDrag(DropTargetDragEvent e) {
            if (e.isDataFlavorSupported(ClassesWindow.getClassFlavor()) || e.isDataFlavorSupported(ClassesWindow.getArrayFlavor()) || e.isDataFlavorSupported(HeapPanel.getHeapObjectFlavor())) {
                e.acceptDrag(1);
                return;
            }
            super.checkDrag(e);
        }

        protected void checkDrop(DropTargetDropEvent e) {
            if (e.isLocalTransfer()) {
                if (e.isDataFlavorSupported(ClassesWindow.getClassFlavor())) {
                    try {
                        Transferable t = e.getTransferable();
                        ClassesWindow.ClassFlavorData data = (ClassesWindow.ClassFlavorData)t.getTransferData(ClassesWindow.getClassFlavor());
                        this.addClass(data.getName());
                        JDebugger.getInstance().viewHeap();
                        e.acceptDrop(1);
                        e.getDropTargetContext().dropComplete(true);
                        return;
                    }
                    catch (Exception ex) {}
                } else if (e.isDataFlavorSupported(ClassesWindow.getArrayFlavor())) {
                    try {
                        Transferable t = e.getTransferable();
                        ClassesWindow.ClassFlavorData data = (ClassesWindow.ClassFlavorData)t.getTransferData(ClassesWindow.getArrayFlavor());
                        this.addClass(data.getName());
                        JDebugger.getInstance().viewHeap();
                        e.acceptDrop(1);
                        e.getDropTargetContext().dropComplete(true);
                        return;
                    }
                    catch (Exception ex) {}
                } else if (e.isDataFlavorSupported(HeapPanel.getHeapObjectFlavor())) {
                    try {
                        Transferable t = e.getTransferable();
                        DebugDataCompositeInfo data = (DebugDataCompositeInfo)t.getTransferData(HeapPanel.getHeapObjectFlavor());
                        this.showAncestors(data);
                        JDebugger.getInstance().viewHeap();
                        e.acceptDrop(1);
                        e.getDropTargetContext().dropComplete(true);
                        return;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
            super.checkDrop(e);
        }

        void processFinished(DebuggingProcess debuggingProcess) {
            if (HeapWindow.ra$pinDebuggingProcesses(HeapWindow.this) != null) {
                int i = HeapWindow.ra$pinDebuggingProcesses(HeapWindow.this).size() - 1;
                while (i >= 0) {
                    if (debuggingProcess.equals(HeapWindow.ra$pinDebuggingProcesses(HeapWindow.this).get(i))) {
                        HeapWindow.ra$pins(HeapWindow.this).remove(i);
                        HeapWindow.ra$pinDebuggingProcesses(HeapWindow.this).remove(i);
                        HeapWindow.ra$pinSubsets(HeapWindow.this).remove(i);
                    }
                    --i;
                }
            }
            this.mapProcessHeapFolders.remove(debuggingProcess);
            super.processFinished(debuggingProcess);
        }

        private List getProcessHeapFolders(DebuggingProcess debuggingProcess) {
            if (debuggingProcess != null) {
                ArrayList list = (ArrayList)this.mapProcessHeapFolders.get(debuggingProcess);
                if (list == null) {
                    list = new ArrayList(this.getProjectHeapFolders(debuggingProcess));
                    this.mapProcessHeapFolders.put(debuggingProcess, list);
                }
                return list;
            }
            return null;
        }

        private List getProjectHeapFolders(DebuggingProcess debuggingProcess) {
            if (debuggingProcess != null) {
                Project project = debuggingProcess.getProject();
                String scope = project != null && project != Ide.getDefaultProject() ? project.getURL().toString() : HeapWindow.GlobalHeapScope;
                ArrayList list = (ArrayList)this.mapProjectHeapFolders.get(scope);
                if (list == null) {
                    list = new ArrayList();
                    this.mapProjectHeapFolders.put(scope, list);
                }
                return list;
            }
            return null;
        }

        private int convertProcessHeapFolderIndexToProjectHeapFolderIndex(List processHeapFolders, int index) {
            int count = 0;
            int i = 0;
            while (i < index) {
                Object o = processHeapFolders.get(i);
                if (o instanceof String) {
                    ++count;
                }
                ++i;
            }
            return count;
        }

        private void editClass(HeapClassFolderDataItem heapClassFolderDataItem, TreePath treePath) {
            List processHeapFolders;
            int i = this.getRoot().indexOf(heapClassFolderDataItem);
            if (i != -1 && (processHeapFolders = this.getProcessHeapFolders(this.debuggingProcess)) != null) {
                int index = this.convertProcessHeapFolderIndexToProjectHeapFolderIndex(processHeapFolders, i);
                String name = (String)processHeapFolders.get(i);
                String title = DbgArb.getString(937);
                String prompt = DbgArb.getString(343);
                String helpId = "f1_deb_edit_heap_classdialog_html";
                if ((name = EditHeapClassDialog.showEditHeapClassDialog(title, prompt, name, this.debuggingProcess.getProject(), helpId)) != null) {
                    processHeapFolders.set(i, name);
                    List projectHeapFolders = this.getProjectHeapFolders(this.debuggingProcess);
                    projectHeapFolders.set(index, name);
                    Object subset = this.makeHeapSubsetForClass(name);
                    heapClassFolderDataItem.modifyClass(subset, treePath);
                }
            }
        }

        private void removeFolder(HeapDataItem heapDataItem) {
            List processHeapFolders;
            int i = this.getRoot().indexOf(heapDataItem);
            if (i != -1 && (processHeapFolders = this.getProcessHeapFolders(this.debuggingProcess)) != null) {
                int size;
                int index = -1;
                if (heapDataItem instanceof HeapClassFolderDataItem) {
                    index = this.convertProcessHeapFolderIndexToProjectHeapFolderIndex(processHeapFolders, i);
                }
                this.removeTopDataItem(i);
                processHeapFolders.remove(i);
                if (heapDataItem instanceof HeapClassFolderDataItem) {
                    List projectHeapFolders = this.getProjectHeapFolders(this.debuggingProcess);
                    projectHeapFolders.remove(index);
                }
                if (heapDataItem instanceof HeapAncestorsFolderDataItem) {
                    HeapAncestorsFolderDataItem hasFolder = (HeapAncestorsFolderDataItem)heapDataItem;
                    HeapAncestorSubset.mav$unpin(hasFolder.has);
                }
                if (i < (size = processHeapFolders.size())) {
                    this.selectTopDataItem(i);
                } else if (0 <= --i && i < size) {
                    this.selectTopDataItem(i);
                }
            }
        }

        private void addNewClass() {
            String title = DbgArb.getString(217);
            String prompt = DbgArb.getString(22);
            String helpId = "f1_deb_add_class_folder_dialog_html";
            String name = EditHeapClassDialog.showEditHeapClassDialog(title, prompt, null, this.debuggingProcess.getProject(), helpId);
            if (name != null) {
                this.addClass(name);
            }
        }

        private void addClass(DebugDataCompositeInfo data) {
            WaitCursor wc = Ide.getWaitCursor();
            wc.show();
            long address = data.getAddressOfObject();
            DebugClassInfo classInfo = data.getClassInfo();
            HeapClassFolderDataItem folder = this.addClass(classInfo.getName(), false);
            TreePath treePath = new TreePath(this.getRoot()).pathByAddingChild(folder);
            Iterator i = this.model.getChildren(folder);
            while (i.hasNext()) {
                DataPanel.DataItem item = (DataPanel.DataItem)i.next();
                if (item.getAddressOfObject() != address) continue;
                TreePath treePathToSelect = treePath.pathByAddingChild(item);
                this.treeTable.getTree().makeVisible(treePathToSelect);
                JDebugger.getInstance().selectTreeTablePath(this.treeTable, treePathToSelect, true);
                break;
            }
            wc.hide();
        }

        HeapClassFolderDataItem addClass(String name) {
            return this.addClass(name, true);
        }

        HeapClassFolderDataItem addClass(String name, boolean highlight) {
            List processHeapFolders = this.getProcessHeapFolders(this.debuggingProcess);
            if (processHeapFolders != null) {
                int index = processHeapFolders.indexOf(name);
                if (index == -1) {
                    index = processHeapFolders.size();
                    processHeapFolders.add(name);
                    index = processHeapFolders.size() - 1;
                    List projectHeapFolders = this.getProjectHeapFolders(this.debuggingProcess);
                    projectHeapFolders.add(name);
                    Object subset = this.makeHeapSubsetForClass(name);
                    HeapClassFolderDataItem heapClassFolderDataItem = new HeapClassFolderDataItem(subset);
                    this.addTopDataItem(heapClassFolderDataItem, highlight);
                    return heapClassFolderDataItem;
                }
                if (highlight) {
                    this.selectTopDataItem(index);
                }
                return (HeapClassFolderDataItem)this.getRoot().get(index);
            }
            return null;
        }

        private boolean canRemoveAllFolders() {
            List processHeapFolders = this.getProcessHeapFolders(this.debuggingProcess);
            return processHeapFolders != null && processHeapFolders.size() > 0;
        }

        private void removeAllFolders() {
            List projectHeapFolders;
            this.unpinAncestorFolders();
            List processHeapFolders = this.getProcessHeapFolders(this.debuggingProcess);
            if (processHeapFolders != null) {
                processHeapFolders.clear();
            }
            if ((projectHeapFolders = this.getProjectHeapFolders(this.debuggingProcess)) != null) {
                projectHeapFolders.clear();
            }
            this.everythingChanged();
        }

        private boolean canShowAncestors(DataPanel.DataItem dataItem) {
            return dataItem.getAddressOfObject() != 0L;
        }

        private void showAncestors(DataPanel.DataItem dataItem) {
            DebugDataInfo data = dataItem.getDataInfo();
            if (data instanceof DebugDataCompositeInfo) {
                DebugDataCompositeInfo datac = (DebugDataCompositeInfo)data;
                this.showAncestors(datac);
            }
        }

        private void showAncestors(DebugDataCompositeInfo datac) {
            long address = datac.getAddressOfObject();
            HeapAncestorSubset has = new HeapAncestorSubset(address, datac.getClassInfo());
            List processHeapFolders = this.getProcessHeapFolders(this.debuggingProcess);
            if (processHeapFolders != null) {
                int index = processHeapFolders.indexOf(has);
                if (index == -1) {
                    processHeapFolders.add(has);
                    index = processHeapFolders.size() - 1;
                    this.pin(datac, has);
                    Object subset = this.makeHeapSubsetForAncestors(has);
                    HeapAncestorsFolderDataItem heapAncestorsFolderDataItem = new HeapAncestorsFolderDataItem(subset, has);
                    this.addTopDataItem(heapAncestorsFolderDataItem);
                } else {
                    this.selectTopDataItem(index);
                }
            }
        }

        private void pin(DebugDataCompositeInfo datac, HeapAncestorSubset has) {
            DebugPinnedInfo pin = datac.pinObject(this);
            if (HeapWindow.ra$pins(HeapWindow.this) == null) {
                HeapWindow.wa$pins(HeapWindow.this, new ArrayList());
            }
            if (HeapWindow.ra$pinDebuggingProcesses(HeapWindow.this) == null) {
                HeapWindow.wa$pinDebuggingProcesses(HeapWindow.this, new ArrayList());
            }
            if (HeapWindow.ra$pinSubsets(HeapWindow.this) == null) {
                HeapWindow.wa$pinSubsets(HeapWindow.this, new ArrayList());
            }
            HeapWindow.ra$pins(HeapWindow.this).add(pin);
            HeapWindow.ra$pinDebuggingProcesses(HeapWindow.this).add(this.debuggingProcess);
            HeapWindow.ra$pinSubsets(HeapWindow.this).add(has);
        }

        private void unpinAncestorFolders() {
            List processHeapFolders = this.getProcessHeapFolders(this.debuggingProcess);
            if (processHeapFolders != null) {
                for (Object o : processHeapFolders) {
                    if (!(o instanceof HeapAncestorSubset)) continue;
                    HeapAncestorSubset has = (HeapAncestorSubset)o;
                    HeapAncestorSubset.mav$unpin(has);
                }
            }
        }

        public void pinnedObjectDiscarded(DebugVirtualMachine vm, DebugPinnedInfo pin) {
            List processHeapFolders;
            long address = pin.getAddressOfObject();
            DebuggingProcess debuggingProcess = JDebugger.getInstance().findDebuggingProcess(vm);
            if (debuggingProcess != null && (processHeapFolders = this.getProcessHeapFolders(debuggingProcess)) != null) {
                for (Object o : processHeapFolders) {
                    if (!(o instanceof HeapAncestorSubset)) continue;
                    HeapAncestorSubset has = (HeapAncestorSubset)o;
                    if (has.address != address) continue;
                    HeapAncestorSubset.mav$discarded(has);
                }
            }
        }

        private Object makeHeapSubsetForAncestors(HeapAncestorSubset has) {
            DebugHeapInfo heap;
            String name = DbgArb.format(494, "@" + Long.toHexString(has.address).toUpperCase());
            if (has.discarded) {
                name = name + " " + DbgArb.getString(349);
            }
            int ignoreLevel = HeapWindow.ra$heapWindowSettings(HeapWindow.this).isIgnoreSoftWeak() ? 4 : 2;
            int depth = HeapWindow.ra$heapWindowSettings(HeapWindow.this).getMaximumDepth();
            DebugHeapSubsetAncestors subset = new DebugHeapSubsetAncestors(name, has.address, depth, ignoreLevel, has.classInfo);
            if (!has.discarded && this.vm != null && (heap = this.vm.getHeap(subset)) != null) {
                return heap;
            }
            return subset;
        }

        private boolean canExpandAncestor(DataPanel.DataItem dataItem) {
            return dataItem.ancestorHeapInfo != null && (dataItem.info instanceof DebugHeapAncestor || dataItem.ancestorDepth != 0);
        }

        private void expandAncestor(DataPanel.DataItem dataItem, TreePath treePath) {
            if (this.canExpandAncestor(dataItem)) {
                Iterator i = dataItem.getChildren();
                while (i.hasNext()) {
                    DataPanel.DataItem child = (DataPanel.DataItem)i.next();
                    if (!child.ancestorShortestDepth) continue;
                    this.treeTable.getTree().expandPath(treePath);
                    this.expandAncestor(child, treePath.pathByAddingChild(child));
                    break;
                }
            }
        }

        static void mav$saveClasses(HeapPanel heapPanel, PropertyAccess propertyAccess) {
            heapPanel.saveClasses(propertyAccess);
        }

        final class 1
        extends KeyAdapter {
            public void keyPressed(KeyEvent e) {
                int key = e.getKeyCode();
                switch (key) {
                    case 127: {
                        Context context = HeapPanel.this.getContext(e);
                        HeapPanel.this.update(HeapWindow.ra$actionRemoveFolder(), context);
                        if (!HeapWindow.ra$actionRemoveFolder().isEnabled()) break;
                        HeapPanel.this.handleEvent(HeapWindow.ra$actionRemoveFolder(), context);
                        e.consume();
                        break;
                    }
                }
            }
        }

        protected abstract class HeapDataItem
        extends DataPanel.DataItem {
            HeapDataItem(Object info) {
                super(info);
            }
        }

        protected final class HeapClassFolderDataItem
        extends HeapDataItem {
            HeapClassFolderDataItem(Object info) {
                super(info);
            }

            void modifyClass(Object info, TreePath treePath) {
                this.modifyInfo(info, null, null, treePath);
            }
        }

        protected final class HeapAncestorsFolderDataItem
        extends HeapDataItem {
            HeapAncestorSubset has;

            HeapAncestorsFolderDataItem(Object info, HeapAncestorSubset has) {
                super(info);
                this.has = has;
            }
        }

        final class HeapAncestorSubset {
            final long address;
            final DebugClassInfo classInfo;
            boolean discarded;

            HeapAncestorSubset(long address, DebugClassInfo classInfo) {
                this.address = address;
                this.discarded = false;
                this.classInfo = classInfo;
            }

            private void unpin() {
                int i = HeapWindow.ra$pinSubsets(HeapWindow.this).indexOf(this);
                if (i != -1) {
                    DebugPinnedInfo pin = (DebugPinnedInfo)HeapWindow.ra$pins(HeapWindow.this).get(i);
                    pin.unpinObject();
                    HeapWindow.ra$pins(HeapWindow.this).remove(i);
                    HeapWindow.ra$pinDebuggingProcesses(HeapWindow.this).remove(i);
                    HeapWindow.ra$pinSubsets(HeapWindow.this).remove(i);
                }
            }

            private void discarded() {
                this.discarded = true;
                int i = HeapWindow.ra$pinSubsets(HeapWindow.this).indexOf(this);
                if (i != -1) {
                    HeapWindow.ra$pins(HeapWindow.this).remove(i);
                    HeapWindow.ra$pinDebuggingProcesses(HeapWindow.this).remove(i);
                    HeapWindow.ra$pinSubsets(HeapWindow.this).remove(i);
                }
            }

            public int hashCode() {
                return (int)this.address;
            }

            public boolean equals(Object o) {
                if (o instanceof HeapAncestorSubset) {
                    return this.address == ((HeapAncestorSubset)o).address;
                }
                return false;
            }

            static void mav$discarded(HeapAncestorSubset heapAncestorSubset) {
                heapAncestorSubset.discarded();
            }

            static void mav$unpin(HeapAncestorSubset heapAncestorSubset) {
                heapAncestorSubset.unpin();
            }
        }
    }
}

