/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.Frame;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.runner.DebuggerWindowProvider;
import oracle.ide.util.PropertyAccess;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DataWindow;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.EditWatchDialog;
import oracle.jdevimpl.runner.debug.EvaluatorItem;
import oracle.jdevimpl.runner.debug.EvaluatorPanel;
import oracle.jdevimpl.runner.debug.InspectorWindowSettings;
import oracle.jdevimpl.runner.debug.JDebugger;

final class InspectorWindow
extends DataWindow {
    private InspectorWindowSettings inspectorWindowSettings = InspectorWindowSettings.getInstance();
    private static IdeAction actionEditExpression;
    private static IdeAction actionPin;
    private static IdeAction actionUnpin;
    private static IdeAction actionViewWhole;
    private static IdeAction actionViewAnnotations;
    private static IdeAction actionViewAnnotationsForClass;
    private static IdeAction actionAdjustRange;
    private static IdeAction actionToggleValue;
    private static IdeAction actionModifyValue;
    private static IdeAction actionWatch;
    private static IdeAction actionInspect;
    private static IdeAction actionWatchClassLoader;
    private static IdeAction actionInspectClassLoader;
    private static IdeAction actionGoto;
    private static IdeAction actionGotoDeclared;
    private static IdeAction actionGotoField;
    private static IdeAction actionUseFilters;
    private static IdeAction actionObjectPreferences;
    private static IdeAction actionCollapseAll;
    private static IdeAction actionSave;
    private static IdeAction actionSettings;
    private static JMenuItem menuitemEditExpression;
    private static JMenuItem menuitemSettings;
    private static final int EDIT_EXPRESSION_CMD_ID;
    private static final int PIN_CMD_ID;
    private static final int UNPIN_CMD_ID;
    private static final int VIEW_WHOLE_CMD_ID;
    private static final int VIEW_ANNOTATIONS_CMD_ID;
    private static final int VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID;
    private static final int ADJUST_RANGE_CMD_ID;
    private static final int TOGGLE_VALUE_CMD_ID;
    private static final int MODIFY_VALUE_CMD_ID;
    private static final int WATCH_CMD_ID;
    private static final int INSPECT_CMD_ID;
    private static final int WATCH_CLASSLOADER_CMD_ID;
    private static final int INSPECT_CLASSLOADER_CMD_ID;
    private static final int GOTO_CMD_ID;
    private static final int GOTO_DECLARED_CMD_ID;
    private static final int GOTO_FIELD_CMD_ID;
    private static final int USE_FILTERS_CMD_ID;
    private static final int OBJECT_PREFERENCES_CMD_ID;
    private static final int COLLAPSE_ALL_CMD_ID;
    private static final int SAVE_CMD_ID;
    private static final int SETTINGS_CMD_ID;
    static final String INSPECTOR_WINDOW_ID = "Debugger.InspectorWindow";
    private static int countInspectorWindows;
    private static final String expHistoryName = "DebuggerInspector";
    private static final String INSPECTOR_KEY_EXPRESSION = ".expression";

    InspectorWindow(String windowId, Object expression) {
        super(windowId, DbgArb.getString(295), "f1_deb_inspectorwindow_html");
        InspectorWindow.makeActions();
        if (expression != null) {
            this.setDataPanel(new InspectorPanel(expression));
        } else {
            this.setDataPanel(new InspectorPanel());
            InspectorWindow.useInspectorWindowId(windowId);
        }
    }

    public String getTitleName() {
        String titleWithExpression = this.title;
        if (this.dataPanel != null) {
            EvaluatorItem ei = InspectorPanel.ra$ei((InspectorPanel)this.dataPanel);
            String name = ei.getName();
            titleWithExpression = name != null ? titleWithExpression + " - " + name : titleWithExpression + " - " + ei.getExpression();
        }
        return titleWithExpression;
    }

    public DebuggerWindowProvider.DebuggerWindowPosition getPosition() {
        return DebuggerWindowProvider.DebuggerWindowPosition.FLOATING;
    }

    public boolean installByDefault() {
        return false;
    }

    public void shutDown() {
        super.shutDown();
        InspectorPanel.mav$saveExpression((InspectorPanel)this.dataPanel, (PropertyAccess)Ide.getIdeProperties());
    }

    static void addContextMenuToMainMenu(Menubar menubar, JMenu subMenu) {
        InspectorWindow.makeActions();
        float section = 1.0f;
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionEditExpression), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionPin), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionUnpin), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionViewWhole), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionViewAnnotations), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionViewAnnotationsForClass), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionAdjustRange), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionToggleValue), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionModifyValue), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionWatch), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionInspect), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionWatchClassLoader), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionInspectClassLoader), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGoto), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGotoDeclared), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGotoField), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionUseFilters), subMenu, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionObjectPreferences), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionCollapseAll), subMenu, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSave), subMenu, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSettings), subMenu, section);
    }

    private static void makeActions() {
        if (actionEditExpression == null) {
            actionEditExpression = IdeAction.get((int)EDIT_EXPRESSION_CMD_ID, null, (String)DbgArb.getString(238), null, (Integer)DbgArb.getInteger(463), null, (int)-1, null, (boolean)false);
            actionEditExpression.setEnabled(false);
            actionPin = IdeAction.get((int)PIN_CMD_ID, null, (String)DbgArb.getString(158), null, (Integer)DbgArb.getInteger(497), null, (int)-1, null, (boolean)false);
            actionPin.setEnabled(false);
            actionUnpin = IdeAction.get((int)UNPIN_CMD_ID, null, (String)DbgArb.getString(509), null, (Integer)DbgArb.getInteger(513), null, (int)-1, null, (boolean)false);
            actionUnpin.setEnabled(false);
            actionViewWhole = IdeAction.get((int)VIEW_WHOLE_CMD_ID, null, (String)DbgArb.getString(333), null, (Integer)DbgArb.getInteger(824), null, (int)-1, null, (boolean)false);
            actionViewWhole.setEnabled(false);
            actionViewAnnotations = IdeAction.get((int)VIEW_ANNOTATIONS_CMD_ID, null, (String)DbgArb.getString(33), null, (Integer)DbgArb.getInteger(961), null, (int)-1, null, (boolean)false);
            actionViewAnnotations.putValue("NoCtxName", (Object)DbgArb.getString(33));
            actionViewAnnotations.setEnabled(false);
            actionViewAnnotationsForClass = IdeAction.get((int)VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID, null, (String)DbgArb.getString(844), null, (Integer)DbgArb.getInteger(884), null, (int)-1, null, (boolean)false);
            actionViewAnnotationsForClass.setEnabled(false);
            actionAdjustRange = IdeAction.get((int)ADJUST_RANGE_CMD_ID, null, (String)DbgArb.getString(157), null, (Integer)DbgArb.getInteger(810), null, (int)-1, null, (boolean)false);
            actionAdjustRange.setEnabled(false);
            actionToggleValue = IdeAction.get((int)TOGGLE_VALUE_CMD_ID, null, (String)DbgArb.getString(183), null, (Integer)DbgArb.getInteger(891), null, (int)-1, null, (boolean)false);
            actionToggleValue.setEnabled(false);
            actionModifyValue = IdeAction.get((int)MODIFY_VALUE_CMD_ID, null, (String)DbgArb.getString(429), null, (Integer)DbgArb.getInteger(267), null, (int)-1, null, (boolean)false);
            actionModifyValue.setEnabled(false);
            actionWatch = IdeAction.get((int)WATCH_CMD_ID, null, (String)DbgArb.getString(197), null, (Integer)DbgArb.getInteger(682), null, (int)-1, null, (boolean)false);
            actionWatch.setEnabled(false);
            actionInspect = IdeAction.get((int)INSPECT_CMD_ID, null, (String)DbgArb.getString(96), null, (Integer)DbgArb.getInteger(484), null, (int)-1, null, (boolean)false);
            actionInspect.setEnabled(false);
            actionWatchClassLoader = IdeAction.get((int)WATCH_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(205), null, (Integer)DbgArb.getInteger(505), null, (int)-1, null, (boolean)false);
            actionWatchClassLoader.setEnabled(false);
            actionInspectClassLoader = IdeAction.get((int)INSPECT_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(273), null, (Integer)DbgArb.getInteger(921), null, (int)-1, null, (boolean)false);
            actionInspectClassLoader.setEnabled(false);
            actionGoto = IdeAction.get((int)GOTO_CMD_ID, null, (String)DbgArb.getString(389), null, (Integer)DbgArb.getInteger(598), null, (int)-1, null, (boolean)false);
            actionGoto.putValue("NoCtxName", (Object)DbgArb.getString(389));
            actionGoto.setEnabled(false);
            actionGotoDeclared = IdeAction.get((int)GOTO_DECLARED_CMD_ID, null, (String)DbgArb.getString(851), null, (Integer)DbgArb.getInteger(926), null, (int)-1, null, (boolean)false);
            actionGotoDeclared.putValue("NoCtxName", (Object)DbgArb.getString(851));
            actionGotoDeclared.setEnabled(false);
            actionGotoField = IdeAction.get((int)GOTO_FIELD_CMD_ID, null, (String)DbgArb.getString(617), null, (Integer)DbgArb.getInteger(788), null, (int)-1, null, (boolean)false);
            actionGotoField.putValue("NoCtxName", (Object)DbgArb.getString(617));
            actionGotoField.setEnabled(false);
            actionUseFilters = IdeAction.get((int)USE_FILTERS_CMD_ID, null, (String)DbgArb.getString(637), null, (Integer)DbgArb.getInteger(412), null, (int)-1, null, (boolean)false);
            actionUseFilters.putValue("Check", (Object)Boolean.TRUE);
            actionUseFilters.setEnabled(false);
            actionObjectPreferences = IdeAction.get((int)OBJECT_PREFERENCES_CMD_ID, null, (String)DbgArb.format(892, ""), null, (Integer)DbgArb.getInteger(594), null, (int)-1, null, (boolean)false);
            actionObjectPreferences.setEnabled(false);
            actionSettings = IdeAction.get((int)SETTINGS_CMD_ID, null, (String)RunMgrArb.getString(87), null, (Integer)RunMgrArb.getInteger(99), null, (int)-1, null, (boolean)false);
            actionSettings.setEnabled(false);
            actionCollapseAll = IdeAction.get((int)COLLAPSE_ALL_CMD_ID, null, (String)RunMgrArb.getString(0), null, (Integer)RunMgrArb.getInteger(7), null, (int)-1, null, (boolean)false);
            actionCollapseAll.setEnabled(false);
            actionSave = IdeAction.get((int)SAVE_CMD_ID, null, (String)RunMgrArb.getString(65), null, (Integer)RunMgrArb.getInteger(101), null, (int)-1, null, (boolean)false);
            actionSave.setEnabled(false);
        }
    }

    void inspectorActiveView(boolean active) {
        if (active) {
            this.setControllerForActions();
        } else {
            this.clearControllerForActions();
        }
    }

    private IdeAction[] getActions() {
        return new IdeAction[]{actionEditExpression, actionPin, actionUnpin, actionViewWhole, actionViewAnnotations, actionViewAnnotationsForClass, actionAdjustRange, actionToggleValue, actionModifyValue, actionWatch, actionInspect, actionWatchClassLoader, actionInspectClassLoader, actionGoto, actionGotoDeclared, actionGotoField, actionUseFilters, actionObjectPreferences, actionSettings, actionCollapseAll, actionSave};
    }

    private void setControllerForActions() {
        IdeAction[] actions = this.getActions();
        JDebugger.setControllerForActions(actions, this.dataPanel);
    }

    private void clearControllerForActions() {
        IdeAction[] actions = this.getActions();
        JDebugger.clearControllerForActions(actions, this.dataPanel);
    }

    static String inspectDialog(String expression) {
        String prompt;
        String title = DbgArb.getString(703);
        expression = EditWatchDialog.showEditWatchDialog(title, prompt = DbgArb.getString(671), expHistoryName, expression);
        if (expression != null) {
            return expression;
        }
        return null;
    }

    static String getNewInspectorWindowId() {
        return INSPECTOR_WINDOW_ID + countInspectorWindows++;
    }

    private static void useInspectorWindowId(String windowId) {
        if (windowId.startsWith(INSPECTOR_WINDOW_ID)) {
            try {
                String s = windowId.substring(INSPECTOR_WINDOW_ID.length());
                int i = Integer.parseInt(s);
                if (countInspectorWindows < i) {
                    countInspectorWindows = i;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static boolean isInspectorWindowId(String windowId) {
        if (windowId.startsWith(INSPECTOR_WINDOW_ID)) {
            int len = INSPECTOR_WINDOW_ID.length();
            String s = windowId.substring(len);
            try {
                int i = Integer.parseInt(s);
                boolean bl = i < countInspectorWindows;
                return bl;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return false;
    }

    public int getType() {
        return super.getType() | 1;
    }

    public void stateChange(int newState) {
        super.stateChange(newState);
        if (newState == 3) {
            JDebugger.getInstance().removeInspectorWindow(this);
        }
    }

    void removeInspector() {
        InspectorPanel.mav$removeInspector((InspectorPanel)this.dataPanel);
    }

    static {
        EDIT_EXPRESSION_CMD_ID = Ide.findOrCreateCmdID((String)"DebugInspectorEditExpression");
        PIN_CMD_ID = Ide.findOrCreateCmdID((String)"DebugInspectorPin");
        UNPIN_CMD_ID = Ide.findOrCreateCmdID((String)"DebugInspectorUnpin");
        VIEW_WHOLE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugInspectorViewWhole");
        VIEW_ANNOTATIONS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugInspectorViewAnnotations");
        VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugInspectorViewAnnotationsForClass");
        ADJUST_RANGE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugInspectorAdjustRange");
        TOGGLE_VALUE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugInspectorToggleValue");
        MODIFY_VALUE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugInspectorModifyValue");
        WATCH_CMD_ID = Ide.findOrCreateCmdID((String)"DebugInspectorWatch");
        INSPECT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugInspectorInspect");
        WATCH_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugInspectorWatchClassLoader");
        INSPECT_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugInspectorInspectClassLoader");
        GOTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugInspectorGoto");
        GOTO_DECLARED_CMD_ID = Ide.findOrCreateCmdID((String)"DebugInspectorGotoDeclared");
        GOTO_FIELD_CMD_ID = Ide.findOrCreateCmdID((String)"DebugInspectorGotoField");
        USE_FILTERS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugInspectorUseFilters");
        OBJECT_PREFERENCES_CMD_ID = Ide.findOrCreateCmdID((String)"DebugInspectorObjectPreferences");
        COLLAPSE_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugInspectorCollapseAll");
        SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugInspectorSave");
        SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugInspectorSettings");
        countInspectorWindows = 0;
    }

    static int ra$EDIT_EXPRESSION_CMD_ID() {
        return EDIT_EXPRESSION_CMD_ID;
    }

    static int ra$SETTINGS_CMD_ID() {
        return SETTINGS_CMD_ID;
    }

    static IdeAction ra$actionSettings() {
        return actionSettings;
    }

    static JMenuItem ra$menuitemSettings() {
        return menuitemSettings;
    }

    static void wa$menuitemSettings(JMenuItem jMenuItem) {
        menuitemSettings = jMenuItem;
    }

    static IdeAction ra$actionEditExpression() {
        return actionEditExpression;
    }

    static JMenuItem ra$menuitemEditExpression() {
        return menuitemEditExpression;
    }

    static void wa$menuitemEditExpression(JMenuItem jMenuItem) {
        menuitemEditExpression = jMenuItem;
    }

    static IdeAction ra$actionPin() {
        return actionPin;
    }

    static IdeAction ra$actionUnpin() {
        return actionUnpin;
    }

    static IdeAction ra$actionViewWhole() {
        return actionViewWhole;
    }

    static IdeAction ra$actionViewAnnotations() {
        return actionViewAnnotations;
    }

    static IdeAction ra$actionViewAnnotationsForClass() {
        return actionViewAnnotationsForClass;
    }

    static IdeAction ra$actionAdjustRange() {
        return actionAdjustRange;
    }

    static IdeAction ra$actionToggleValue() {
        return actionToggleValue;
    }

    static IdeAction ra$actionModifyValue() {
        return actionModifyValue;
    }

    static IdeAction ra$actionWatch() {
        return actionWatch;
    }

    static IdeAction ra$actionInspect() {
        return actionInspect;
    }

    static IdeAction ra$actionWatchClassLoader() {
        return actionWatchClassLoader;
    }

    static IdeAction ra$actionInspectClassLoader() {
        return actionInspectClassLoader;
    }

    static IdeAction ra$actionGoto() {
        return actionGoto;
    }

    static IdeAction ra$actionGotoDeclared() {
        return actionGotoDeclared;
    }

    static IdeAction ra$actionGotoField() {
        return actionGotoField;
    }

    static IdeAction ra$actionUseFilters() {
        return actionUseFilters;
    }

    static IdeAction ra$actionObjectPreferences() {
        return actionObjectPreferences;
    }

    static IdeAction ra$actionCollapseAll() {
        return actionCollapseAll;
    }

    static IdeAction ra$actionSave() {
        return actionSave;
    }

    static int ra$PIN_CMD_ID() {
        return PIN_CMD_ID;
    }

    static int ra$UNPIN_CMD_ID() {
        return UNPIN_CMD_ID;
    }

    static int ra$VIEW_WHOLE_CMD_ID() {
        return VIEW_WHOLE_CMD_ID;
    }

    static int ra$VIEW_ANNOTATIONS_CMD_ID() {
        return VIEW_ANNOTATIONS_CMD_ID;
    }

    static int ra$VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID() {
        return VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID;
    }

    static int ra$ADJUST_RANGE_CMD_ID() {
        return ADJUST_RANGE_CMD_ID;
    }

    static int ra$TOGGLE_VALUE_CMD_ID() {
        return TOGGLE_VALUE_CMD_ID;
    }

    static int ra$MODIFY_VALUE_CMD_ID() {
        return MODIFY_VALUE_CMD_ID;
    }

    static int ra$WATCH_CMD_ID() {
        return WATCH_CMD_ID;
    }

    static int ra$INSPECT_CMD_ID() {
        return INSPECT_CMD_ID;
    }

    static int ra$WATCH_CLASSLOADER_CMD_ID() {
        return WATCH_CLASSLOADER_CMD_ID;
    }

    static int ra$INSPECT_CLASSLOADER_CMD_ID() {
        return INSPECT_CLASSLOADER_CMD_ID;
    }

    static int ra$GOTO_CMD_ID() {
        return GOTO_CMD_ID;
    }

    static int ra$GOTO_DECLARED_CMD_ID() {
        return GOTO_DECLARED_CMD_ID;
    }

    static int ra$GOTO_FIELD_CMD_ID() {
        return GOTO_FIELD_CMD_ID;
    }

    static int ra$USE_FILTERS_CMD_ID() {
        return USE_FILTERS_CMD_ID;
    }

    static int ra$OBJECT_PREFERENCES_CMD_ID() {
        return OBJECT_PREFERENCES_CMD_ID;
    }

    static int ra$COLLAPSE_ALL_CMD_ID() {
        return COLLAPSE_ALL_CMD_ID;
    }

    static int ra$SAVE_CMD_ID() {
        return SAVE_CMD_ID;
    }

    static InspectorWindowSettings ra$inspectorWindowSettings(InspectorWindow inspectorWindow) {
        return inspectorWindow.inspectorWindowSettings;
    }

    final class InspectorPanel
    extends EvaluatorPanel {
        private EvaluatorItem ei;

        InspectorPanel() {
            super(InspectorWindow.this, InspectorWindow.ra$inspectorWindowSettings(InspectorWindow.this).getDataPanelSettings());
            this.loadExpression((PropertyAccess)Ide.getIdeProperties());
            this.hookUpActions();
        }

        InspectorPanel(Object expression) {
            super(InspectorWindow.this, InspectorWindow.ra$inspectorWindowSettings(InspectorWindow.this).getDataPanelSettings());
            if (expression instanceof EvaluatorItem) {
                this.ei = (EvaluatorItem)expression;
            } else if (expression instanceof String) {
                this.ei = new EvaluatorItem((String)expression);
            }
            this.hookUpActions();
        }

        private void hookUpActions() {
            this._actionPin = InspectorWindow.ra$actionPin();
            this._actionUnpin = InspectorWindow.ra$actionUnpin();
            this._actionViewWhole = InspectorWindow.ra$actionViewWhole();
            this._actionViewAnnotations = InspectorWindow.ra$actionViewAnnotations();
            this._actionViewAnnotationsForClass = InspectorWindow.ra$actionViewAnnotationsForClass();
            this._actionAdjustRange = InspectorWindow.ra$actionAdjustRange();
            this._actionToggleValue = InspectorWindow.ra$actionToggleValue();
            this._actionModifyValue = InspectorWindow.ra$actionModifyValue();
            this._actionWatch = InspectorWindow.ra$actionWatch();
            this._actionInspect = InspectorWindow.ra$actionInspect();
            this._actionWatchClassLoader = InspectorWindow.ra$actionWatchClassLoader();
            this._actionInspectClassLoader = InspectorWindow.ra$actionInspectClassLoader();
            this._actionGoto = InspectorWindow.ra$actionGoto();
            this._actionGotoDeclared = InspectorWindow.ra$actionGotoDeclared();
            this._actionGotoField = InspectorWindow.ra$actionGotoField();
            this._actionUseFilters = InspectorWindow.ra$actionUseFilters();
            this._actionObjectPreferences = InspectorWindow.ra$actionObjectPreferences();
            this._actionCollapseAll = InspectorWindow.ra$actionCollapseAll();
            this._actionSave = InspectorWindow.ra$actionSave();
            this._PIN_CMD_ID = InspectorWindow.ra$PIN_CMD_ID();
            this._UNPIN_CMD_ID = InspectorWindow.ra$UNPIN_CMD_ID();
            this._VIEW_WHOLE_CMD_ID = InspectorWindow.ra$VIEW_WHOLE_CMD_ID();
            this._VIEW_ANNOTATIONS_CMD_ID = InspectorWindow.ra$VIEW_ANNOTATIONS_CMD_ID();
            this._VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID = InspectorWindow.ra$VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID();
            this._ADJUST_RANGE_CMD_ID = InspectorWindow.ra$ADJUST_RANGE_CMD_ID();
            this._TOGGLE_VALUE_CMD_ID = InspectorWindow.ra$TOGGLE_VALUE_CMD_ID();
            this._MODIFY_VALUE_CMD_ID = InspectorWindow.ra$MODIFY_VALUE_CMD_ID();
            this._WATCH_CMD_ID = InspectorWindow.ra$WATCH_CMD_ID();
            this._INSPECT_CMD_ID = InspectorWindow.ra$INSPECT_CMD_ID();
            this._WATCH_CLASSLOADER_CMD_ID = InspectorWindow.ra$WATCH_CLASSLOADER_CMD_ID();
            this._INSPECT_CLASSLOADER_CMD_ID = InspectorWindow.ra$INSPECT_CLASSLOADER_CMD_ID();
            this._GOTO_CMD_ID = InspectorWindow.ra$GOTO_CMD_ID();
            this._GOTO_DECLARED_CMD_ID = InspectorWindow.ra$GOTO_DECLARED_CMD_ID();
            this._GOTO_FIELD_CMD_ID = InspectorWindow.ra$GOTO_FIELD_CMD_ID();
            this._USE_FILTERS_CMD_ID = InspectorWindow.ra$USE_FILTERS_CMD_ID();
            this._OBJECT_PREFERENCES_CMD_ID = InspectorWindow.ra$OBJECT_PREFERENCES_CMD_ID();
            this._COLLAPSE_ALL_CMD_ID = InspectorWindow.ra$COLLAPSE_ALL_CMD_ID();
            this._SAVE_CMD_ID = InspectorWindow.ra$SAVE_CMD_ID();
        }

        void processFinished(DebuggingProcess debuggingProcess) {
            if (this.ei.isPinned(debuggingProcess)) {
                this.ei.unpin(debuggingProcess);
            }
            super.processFinished(debuggingProcess);
            if (this.ei.getTemporary() == debuggingProcess) {
                InspectorWindow.this.close();
            }
        }

        private String getKeyPrefix() {
            return this.dockableWindow.getId();
        }

        private void loadExpression(PropertyAccess properties) {
            String prefix = this.getKeyPrefix();
            String expression = properties.getProperty(prefix + InspectorWindow.INSPECTOR_KEY_EXPRESSION, "");
            this.ei = expression != null ? new EvaluatorItem(expression) : new EvaluatorItem("");
        }

        private void saveExpression(PropertyAccess properties) {
            String prefix = this.getKeyPrefix();
            String expression = this.ei.getExpression();
            properties.setProperty(prefix + InspectorWindow.INSPECTOR_KEY_EXPRESSION, expression);
        }

        private void removeSavedExpression(PropertyAccess properties) {
            String prefix = this.getKeyPrefix();
            properties.setProperty(prefix + InspectorWindow.INSPECTOR_KEY_EXPRESSION, null);
        }

        private void removeInspector() {
            this.removeSavedExpression((PropertyAccess)Ide.getIdeProperties());
            if (this.ei != null) {
                this.ei.unpinForAll();
            }
        }

        protected void addPopupMenuItemsForDataItem(ContextMenu popup, Context context) {
            this.update(InspectorWindow.ra$actionEditExpression(), context);
            if (InspectorWindow.ra$actionEditExpression().isEnabled()) {
                if (InspectorWindow.ra$menuitemEditExpression() == null) {
                    InspectorWindow.wa$menuitemEditExpression(popup.createMenuItem((ToggleAction)InspectorWindow.ra$actionEditExpression()));
                }
                popup.add((Component)InspectorWindow.ra$menuitemEditExpression(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            super.addPopupMenuItemsForDataItem(popup, context);
        }

        protected void addPopupMenuItemsForCommon(ContextMenu popup, Context context) {
            super.addPopupMenuItemsForCommon(popup, context);
            this.update(InspectorWindow.ra$actionSettings(), context);
            if (InspectorWindow.ra$actionSettings().isEnabled()) {
                if (InspectorWindow.ra$menuitemSettings() == null) {
                    InspectorWindow.wa$menuitemSettings(popup.createMenuItem((ToggleAction)InspectorWindow.ra$actionSettings()));
                }
                popup.add((Component)InspectorWindow.ra$menuitemSettings(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
            }
        }

        public boolean update(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (action.getValue("Debugger.actionOwner") == this) {
                if (this.treeTable == null || !this.dockableWindow.isVisible()) {
                    action.setEnabled(false);
                    return true;
                }
                if (!(this.treeTable.isEnabled() && this.debuggingProcess != null && this.vm != null || cmdId == InspectorWindow.ra$SETTINGS_CMD_ID())) {
                    action.setEnabled(false);
                    return true;
                }
            }
            if (cmdId == InspectorWindow.ra$EDIT_EXPRESSION_CMD_ID()) {
                DataPanel.DataItem dataItem = this.getSelectedDataItem();
                TreePath treePath = this.getSelectedTreePath();
                if (dataItem instanceof EvaluatorPanel.EvaluatorDataItem && treePath != null) {
                    EvaluatorPanel.EvaluatorDataItem evaluatorDataItem = (EvaluatorPanel.EvaluatorDataItem)dataItem;
                    action.setEnabled(evaluatorDataItem.canEditExpression());
                } else {
                    action.setEnabled(false);
                }
                return true;
            }
            if (cmdId == InspectorWindow.ra$SETTINGS_CMD_ID()) {
                action.setEnabled(true);
                return true;
            }
            return super.update(action, context);
        }

        public boolean handleEvent(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (cmdId == InspectorWindow.ra$EDIT_EXPRESSION_CMD_ID()) {
                EvaluatorPanel.EvaluatorDataItem evaluatorDataItem;
                DataPanel.DataItem dataItem = this.getSelectedDataItem();
                TreePath treePath = this.getSelectedTreePath();
                if (dataItem instanceof EvaluatorPanel.EvaluatorDataItem && treePath != null && (evaluatorDataItem = (EvaluatorPanel.EvaluatorDataItem)dataItem).canEditExpression()) {
                    this.editExpression(evaluatorDataItem, treePath);
                }
                return true;
            }
            if (cmdId == InspectorWindow.ra$SETTINGS_CMD_ID()) {
                String[] path = new String[]{DbgArb.getString(16), DbgArb.getString(281)};
                Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), path);
                return true;
            }
            return super.handleEvent(action, context);
        }

        private void editExpression(EvaluatorPanel.EvaluatorDataItem evaluatorDataItem, TreePath treePath) {
            if (evaluatorDataItem.editExpression(DbgArb.getString(8), DbgArb.getString(293), InspectorWindow.expHistoryName, treePath)) {
                this.dockableWindow.updateTitle(null);
            }
        }

        protected void addDataItems() {
            List root = this.getRoot();
            this.addDataItem(root, this.ei, false, false);
        }

        static void mav$removeInspector(InspectorPanel inspectorPanel) {
            inspectorPanel.removeInspector();
        }

        static void mav$saveExpression(InspectorPanel inspectorPanel, PropertyAccess propertyAccess) {
            inspectorPanel.saveExpression(propertyAccess);
        }

        static EvaluatorItem ra$ei(InspectorPanel inspectorPanel) {
            return inspectorPanel.ei;
        }
    }
}

