/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreePath;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.IdeMainWindow;
import oracle.ide.ceditor.CEToolTipProvider;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.ceditor.CursorListener;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.compiler.BuildSystemListener;
import oracle.ide.compiler.Compiler;
import oracle.ide.config.IdeSettings;
import oracle.ide.config.Preferences;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.JFastTreeTable;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.WaitCursor;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.DockUtil;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableView;
import oracle.ide.docking.DockableWindow;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.exception.SingletonClassException;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.explorer.ExplorerWindow;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.layout.IdeLayout;
import oracle.ide.layout.Layout;
import oracle.ide.layout.Layouts;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.log.LogWindow;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.Navigable;
import oracle.ide.resource.IdeArb;
import oracle.ide.runner.Debugger;
import oracle.ide.runner.DebuggerAdapter;
import oracle.ide.runner.DebuggerExtender;
import oracle.ide.runner.DebuggerExtenderCallback;
import oracle.ide.runner.DebuggerListener;
import oracle.ide.runner.DebuggerStartCallback;
import oracle.ide.runner.DebuggerWindowProvider;
import oracle.ide.runner.DebuggerWindowProviderCallback;
import oracle.ide.runner.RunLogPage;
import oracle.ide.runner.RunProcess;
import oracle.ide.runner.RunnableItem;
import oracle.ide.runner.Runner;
import oracle.ide.runner.SmartDataProvider;
import oracle.ide.runner.ToolTipExpressionProvider;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.MnemonicSolver;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;
import oracle.ideri.util.Product;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.gutter.Gutter;
import oracle.javatools.editor.gutter.GutterClickListener;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourcePackage;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.compiler.UnifiedBuildSystem;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.model.PackagedSource;
import oracle.jdeveloper.refactoring.RefactoringManager;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunConfigurations;
import oracle.jdeveloper.runner.Source;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugBreakpoint;
import oracle.jdevimpl.debugger.support.DebugCapabilities;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.java.explorer.ClassElement;
import oracle.jdevimpl.java.explorer.FieldElement;
import oracle.jdevimpl.runner.RunManager;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.Breakpoint;
import oracle.jdevimpl.runner.debug.BreakpointsWindow;
import oracle.jdevimpl.runner.debug.BreakpointsWindowSettings;
import oracle.jdevimpl.runner.debug.BreakpointsWindowSettingsPanel;
import oracle.jdevimpl.runner.debug.BreakpointsWindowSettingsPanel2;
import oracle.jdevimpl.runner.debug.BytecodeFileSystemHelper;
import oracle.jdevimpl.runner.debug.ClassesWindow;
import oracle.jdevimpl.runner.debug.ClassesWindowSettings;
import oracle.jdevimpl.runner.debug.ClassesWindowSettingsPanel;
import oracle.jdevimpl.runner.debug.ColumnMenuListener;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugConfiguration;
import oracle.jdevimpl.runner.debug.DebugConfigurationPanel;
import oracle.jdevimpl.runner.debug.DebugContext;
import oracle.jdevimpl.runner.debug.DebugDockableFactory;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.DebugWindowSettingsPanel;
import oracle.jdevimpl.runner.debug.DebuggingListener;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.EvaluationInfo;
import oracle.jdevimpl.runner.debug.Evaluator;
import oracle.jdevimpl.runner.debug.EvaluatorItem;
import oracle.jdevimpl.runner.debug.ExtenderManager;
import oracle.jdevimpl.runner.debug.HeapWindow;
import oracle.jdevimpl.runner.debug.HeapWindowSettings;
import oracle.jdevimpl.runner.debug.InspectorWindow;
import oracle.jdevimpl.runner.debug.InspectorWindowSettings;
import oracle.jdevimpl.runner.debug.InspectorWindowSettingsPanel;
import oracle.jdevimpl.runner.debug.JavaEvaluator;
import oracle.jdevimpl.runner.debug.LocalsWindow;
import oracle.jdevimpl.runner.debug.LocalsWindowSettings;
import oracle.jdevimpl.runner.debug.LocalsWindowSettingsPanel;
import oracle.jdevimpl.runner.debug.MonitorsWindow;
import oracle.jdevimpl.runner.debug.MonitorsWindowDataSettingsPanel;
import oracle.jdevimpl.runner.debug.MonitorsWindowSettings;
import oracle.jdevimpl.runner.debug.MonitorsWindowThreadsSettingsPanel;
import oracle.jdevimpl.runner.debug.ObjectPreferences;
import oracle.jdevimpl.runner.debug.PackageFileLineCheck;
import oracle.jdevimpl.runner.debug.PackageFileLineChecker;
import oracle.jdevimpl.runner.debug.RemoteDebugSettingsPanel;
import oracle.jdevimpl.runner.debug.RunWhilePaused;
import oracle.jdevimpl.runner.debug.SharedActions;
import oracle.jdevimpl.runner.debug.SmartJava;
import oracle.jdevimpl.runner.debug.SmartWindow;
import oracle.jdevimpl.runner.debug.SmartWindowSettings;
import oracle.jdevimpl.runner.debug.SmartWindowSettingsPanel;
import oracle.jdevimpl.runner.debug.SourceIcon;
import oracle.jdevimpl.runner.debug.StackWindow;
import oracle.jdevimpl.runner.debug.StackWindowSettings;
import oracle.jdevimpl.runner.debug.StackWindowSettingsPanel;
import oracle.jdevimpl.runner.debug.ThreadsWindow;
import oracle.jdevimpl.runner.debug.ThreadsWindowSettings;
import oracle.jdevimpl.runner.debug.ThreadsWindowSettingsPanel;
import oracle.jdevimpl.runner.debug.ToolTipEvaluator;
import oracle.jdevimpl.runner.debug.ToolTipJava;
import oracle.jdevimpl.runner.debug.TracingPanel;
import oracle.jdevimpl.runner.debug.WatchWindow;
import oracle.jdevimpl.runner.debug.WatchWindowSettings;
import oracle.jdevimpl.runner.debug.WatchWindowSettingsPanel;
import oracle.jdevimpl.runner.debug.WindowManager;
import oracle.jdevimpl.runner.run.JRunner;
import oracle.jdevimpl.runner.run.RunArb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JDebugger
extends Debugger
implements ActiveViewListener,
ContextMenuListener,
Controller,
EditorListener,
GutterClickListener,
CEToolTipProvider,
MenuListener,
Observer,
CursorListener,
Addin,
ShutdownHook,
IdeListener,
ViewSelectionListener,
BuildSystemListener {
    private static JDebugger instance;
    private DebugDockableFactory debugDockableFactory;
    private IdeLayout debugLayout;
    private DebugWindowSettings dbgSettings;
    private static ContextMenu contextMenu;
    static URL lastSavedFile;
    private Workspace activeWorkspace;
    private Project activeProject;
    private View activeView;
    private CodeEditor activeCodeEditor;
    private List[] activeBreakpoints;
    private InspectorWindow activeInspector;
    private DebuggingProcess activeDebuggingProcess;
    private volatile int duringClassRedefinition;
    private boolean isToolTipProvider;
    private ToolTipEvaluator toolTipEvaluator;
    private Map breakpointForDebugBreakpoint;
    private List<DebuggingProcess> debuggingProcesses;
    private List<DebuggingProcess> debuggingProcessesConnecting;
    private List<DebuggingListener> debuggingListeners;
    private List<DebuggerListener> debuggerListeners;
    private WindowManager windowManager;
    private ExtenderManager extenderManager;
    private List<Breakpoint> cachedNewBreakpoints;
    private Boolean cacheNewBreakpoints;
    private BreakpointsWindow breakpointsWindow;
    private ThreadsWindow threadsWindow;
    private StackWindow stackWindow;
    private SmartWindow smartWindow;
    private LocalsWindow localsWindow;
    private WatchWindow watchWindow;
    private ClassesWindow classesWindow;
    private HeapWindow heapWindow;
    private MonitorsWindow monitorsWindow;
    private List inspectorWindows;
    private ObjectPreferences objectPreferences;
    private static JMenu viewDebuggerSubMenu;
    private static boolean viewDebuggerSubMenuBuilt;
    private static JMenu runMenu;
    private static boolean debugMenuBuilt;
    private static JMenu debugContextSubMenu;
    private static boolean debugContextSubMenuAdded;
    private static boolean debugContextSubMenuBuilt;
    private static List<SmartDataProvider> smartDataProviders;
    private static List<ToolTipExpressionProvider> toolTipExpressionProviders;
    private static List<IdeAction> viewDebuggerActions;
    private static IdeAction actionViewBreakpoints;
    private static IdeAction actionViewThreads;
    private static IdeAction actionViewStack;
    private static IdeAction actionViewSmart;
    private static IdeAction actionViewLocals;
    private static IdeAction actionViewWatches;
    private static IdeAction actionViewClasses;
    private static IdeAction actionViewMonitors;
    private static IdeAction actionViewLog;
    private static IdeAction actionDebugProject;
    private static IdeAction actionEmpty;
    private static IdeAction actionDebugSelection;
    private static IdeAction actionDebugToggleBreakpoint;
    private static IdeAction actionDebugPause;
    private static IdeAction actionDebugResume;
    private static IdeAction actionDebugDetach;
    private static IdeAction actionDebugReset;
    private static IdeAction actionDebugStepOver;
    private static IdeAction actionDebugStepOverBC;
    private static IdeAction actionDebugStepInto;
    private static IdeAction actionDebugStepIntoBC;
    private static IdeAction actionDebugStepOut;
    private static IdeAction actionDebugStepToEndOfMethod;
    private static IdeAction actionDebugContinueStep;
    private static IdeAction actionDebugRunToCursor;
    private static IdeAction actionDebugStepIntoMethod;
    private static IdeAction actionDebugSetNextStatement;
    private static IdeAction actionDebugShowIP;
    private static IdeAction actionDebugGC;
    private static IdeAction actionContextMenuDebug;
    private static final int DEBUG_CMD_MRU_CONFIGURATION_ID;
    private static IdeAction actionMRUConfigurationMenuDebug;
    public static Component debugContextMenu;
    private static IdeAction actionNavigatorStopListening;
    private static IdeAction actionNavigatorDetachDebugger;
    private static JMenuItem menuitemNavigatorStopListening;
    private static JMenuItem menuitemNavigatorDetachDebugger;
    private static IdeAction actionCodeEditorGutterToggleBreakpoint;
    private static IdeAction actionCodeEditorToggleWatchpoint;
    private static IdeAction actionCodeEditorGutterEnableBreakpoint;
    private static IdeAction actionCodeEditorGutterDisableBreakpoint;
    private static IdeAction actionCodeEditorGutterEditBreakpoint;
    private static IdeAction actionCodeEditorWatch;
    private static IdeAction actionCodeEditorInspect;
    private static JMenuItem menuitemCodeEditorGutterToggleBreakpoint;
    private static JMenuItem menuitemCodeEditorToggleWatchpoint;
    private static JMenuItem menuitemCodeEditorGutterEnableBreakpoint;
    private static JMenuItem menuitemCodeEditorGutterDisableBreakpoint;
    private static JMenuItem menuitemCodeEditorGutterEditBreakpoint;
    private static JMenuItem menuitemCodeEditorRunToCursor;
    private static JMenuItem menuitemCodeEditorStepIntoMethod;
    private static JMenuItem menuitemCodeEditorSetNextStatement;
    private static JMenuItem menuitemCodeEditorWatch;
    private static JMenuItem menuitemCodeEditorInspect;
    private static IdeAction actionStructureCreateWatchpoint;
    private static JMenuItem menuitemStructureCreateWatchpoint;
    private static IdeAction actionLogWindowCancelDebugConnection;
    private static IdeAction actionLogWindowShowIP;
    private static IdeAction actionLogWindowResume;
    private static IdeAction actionLogWindowStepOver;
    private static IdeAction actionLogWindowStepInto;
    private static IdeAction actionLogWindowStepOut;
    private static IdeAction actionLogWindowStepToEndOfMethod;
    private static IdeAction actionLogWindowStepOverBC;
    private static IdeAction actionLogWindowStepIntoBC;
    private static IdeAction actionLogWindowPause;
    private static IdeAction actionLogWindowReset;
    private static IdeAction actionLogWindowGC;
    private static JMenuItem menuitemLogWindowCancelDebugConnection;
    private static final int VIEW_BREAKPOINTS_CMD_ID;
    private static final int VIEW_THREADS_CMD_ID;
    private static final int VIEW_STACK_CMD_ID;
    private static final int VIEW_SMART_CMD_ID;
    private static final int VIEW_LOCALS_CMD_ID;
    private static final int VIEW_WATCHES_CMD_ID;
    private static final int VIEW_CLASSES_CMD_ID;
    private static final int VIEW_HEAP_CMD_ID;
    private static final int VIEW_MONITORS_CMD_ID;
    private static final int VIEW_LOG_CMD_ID;
    private static final String DEBUG_PROJECT_CMD_PREFIX = "DebugProjectCommand";
    private static final int DEBUG_PROJECT_CMD_ID;
    private static int[] debugProjectCmdIds;
    private static final int DEBUG_SELECTION_CMD_ID;
    private static final int DEBUG_PAUSE_CMD_ID;
    private static final int DEBUG_RESUME_CMD_ID;
    private static final int DEBUG_DETACH_CMD_ID;
    private static final int DEBUG_RESET_CMD_ID;
    private static final int DEBUG_STEPOVER_CMD_ID;
    private static final int DEBUG_STEPOVERBC_CMD_ID;
    private static final int DEBUG_STEPINTO_CMD_ID;
    private static final int DEBUG_STEPINTOBC_CMD_ID;
    private static final int DEBUG_STEPOUT_CMD_ID;
    private static final int DEBUG_STEPTOENDOFMETHOD_CMD_ID;
    private static final int DEBUG_CONTINUESTEP_CMD_ID;
    private static final int DEBUG_RUNTOCURSOR_CMD_ID;
    private static final int DEBUG_STEPINTOMETHOD_CMD_ID;
    private static final int DEBUG_SETNEXTSTATEMENT_CMD_ID;
    private static final int DEBUG_SHOWIP_CMD_ID;
    private static final int DEBUG_GC_CMD_ID;
    private static final int DEBUG_POP_1_STACK_FRAME_CMD_ID;
    private static final int CONTEXTMENU_DEBUG_CMD_ID;
    private static final int NAVIGATOR_STOPLISTENING_CMD_ID;
    private static final int NAVIGATOR_DETACHDEBUGGER_CMD_ID;
    private static final int CODE_EDITOR_GUTTER_TOGGLEBREAKPOINT_CMD_ID;
    private static final int CODE_EDITOR_GUTTER_TOGGLEWATCHPOINT_CMD_ID;
    private static final int CODE_EDITOR_GUTTER_ENABLEBREAKPOINT_CMD_ID;
    private static final int CODE_EDITOR_GUTTER_DISABLEBREAKPOINT_CMD_ID;
    private static final int CODE_EDITOR_GUTTER_EDITBREAKPOINT_CMD_ID;
    private static final int CODE_EDITOR_WATCH_CMD_ID;
    private static final int CODE_EDITOR_INSPECT_CMD_ID;
    private static final int STRUCTURE_CREATEWATCHPOINT_CMD_ID;
    private static final int LOG_WINDOW_CANCEL_DEBUG_CONNECTION_CMD_ID;
    private static final int LOG_WINDOW_SHOWIP_CMD_ID;
    private static final int LOG_WINDOW_RESUME_CMD_ID;
    private static final int LOG_WINDOW_STEPOVER_CMD_ID;
    private static final int LOG_WINDOW_STEPINTO_CMD_ID;
    private static final int LOG_WINDOW_STEPOUT_CMD_ID;
    private static final int LOG_WINDOW_STEPTOENDOFMETHOD_CMD_ID;
    private static final int LOG_WINDOW_STEPOVERBC_CMD_ID;
    private static final int LOG_WINDOW_STEPINTOBC_CMD_ID;
    private static final int LOG_WINDOW_PAUSE_CMD_ID;
    private static final int LOG_WINDOW_RESET_CMD_ID;
    private static final int LOG_WINDOW_GC_CMD_ID;
    static final String ACTION_OWNER = "Debugger.actionOwner";
    static final String DEBUGGER_ID = "Debugger";
    static final String DEBUG_LAYOUT_KEY = "debugLayout";
    volatile boolean firstDebuggingProcessCreated;

    private void $init$() {
        this.activeBreakpoints = new List[0];
        this.debuggerListeners = new ArrayList<DebuggerListener>();
        this.windowManager = new WindowManager();
        this.extenderManager = new ExtenderManager();
        this.cacheNewBreakpoints = Boolean.FALSE;
        this.firstDebuggingProcessCreated = true;
    }

    public JDebugger() throws SingletonClassException {
        this.$init$();
        if (instance != null) {
            throw new SingletonClassException("oracle.jdevimpl.runner.debug.JDebugger");
        }
        instance = this;
    }

    public static JDebugger getInstance() {
        return instance;
    }

    public static int getContextMenuDebugCommandID() {
        return CONTEXTMENU_DEBUG_CMD_ID;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        Assert.check((boolean)action.isEnabled());
        int cmdId = action.getCommandId();
        if (cmdId == VIEW_BREAKPOINTS_CMD_ID) {
            this.viewBreakpoints();
            return true;
        }
        if (cmdId == VIEW_THREADS_CMD_ID) {
            DockUtil.showDockableWindow((DockableView)this.getThreadsWindow(true));
            return true;
        }
        if (cmdId == VIEW_STACK_CMD_ID) {
            DockUtil.showDockableWindow((DockableView)this.getStackWindow(true));
            return true;
        }
        if (cmdId == VIEW_SMART_CMD_ID) {
            DockUtil.showDockableWindow((DockableView)this.getSmartWindow(true));
            return true;
        }
        if (cmdId == VIEW_LOCALS_CMD_ID) {
            DockUtil.showDockableWindow((DockableView)this.getLocalsWindow(true));
            return true;
        }
        if (cmdId == VIEW_WATCHES_CMD_ID) {
            this.viewWatches();
            return true;
        }
        if (cmdId == VIEW_CLASSES_CMD_ID) {
            DockUtil.showDockableWindow((DockableView)this.getClassesWindow(true));
            return true;
        }
        if (cmdId == VIEW_HEAP_CMD_ID) {
            this.viewHeap();
            return true;
        }
        if (cmdId == VIEW_MONITORS_CMD_ID) {
            this.viewMonitors();
            return true;
        }
        if (cmdId == VIEW_LOG_CMD_ID) {
            this.viewLog();
            return true;
        }
        if (cmdId == DEBUG_PROJECT_CMD_ID) {
            this.startMruProcess();
            return true;
        }
        if (cmdId == DEBUG_CMD_MRU_CONFIGURATION_ID) {
            this.startMruProcess();
            return true;
        }
        if (RunManager.arrayContains(debugProjectCmdIds, cmdId)) {
            RunConfiguration runConfiguration = (RunConfiguration)((Object)action.getValue("UserData"));
            RunConfigurations.setActiveRunConfiguration(this.activeProject, runConfiguration);
            this.startProcess(null, true);
            return true;
        }
        if (cmdId == DEBUG_SELECTION_CMD_ID) {
            Node contextNode = RunProcess.getContextNodeForRun((Context)context);
            if (contextNode != null && !(contextNode instanceof Workspace) && !(contextNode instanceof Project)) {
                context.setProperty(RunProcess.RUN_PROCESS_DO_NOT_CONSIDER_DEFAULT, (Object)Boolean.TRUE);
            }
            this.startProcess(context, false);
            return true;
        }
        if (cmdId == DEBUG_PAUSE_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.pause();
            }
            return true;
        }
        if (cmdId == DEBUG_RESUME_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.resume();
            }
            return true;
        }
        if (cmdId == DEBUG_DETACH_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.detach();
            }
            return true;
        }
        if (cmdId == DEBUG_RESET_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.terminate();
            }
            return true;
        }
        if (cmdId == DEBUG_STEPOVER_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.stepOver(JDebugger.getEventTime(context));
            }
            return true;
        }
        if (cmdId == DEBUG_STEPOVERBC_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.stepOverBC(JDebugger.getEventTime(context));
            }
            return true;
        }
        if (cmdId == DEBUG_STEPINTO_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.stepInto(JDebugger.getEventTime(context));
            }
            return true;
        }
        if (cmdId == DEBUG_STEPINTOBC_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.stepIntoBC(JDebugger.getEventTime(context));
            }
            return true;
        }
        if (cmdId == DEBUG_STEPOUT_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.stepOut(JDebugger.getEventTime(context));
            }
            return true;
        }
        if (cmdId == DEBUG_STEPTOENDOFMETHOD_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.stepToEndOfMethod(JDebugger.getEventTime(context));
            }
            return true;
        }
        if (cmdId == DEBUG_CONTINUESTEP_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.continueStep();
            }
            return true;
        }
        if (cmdId == DEBUG_RUNTOCURSOR_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.runToCursor(context);
            }
            return true;
        }
        if (cmdId == DEBUG_STEPINTOMETHOD_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.stepIntoMethod(context);
            }
            return true;
        }
        if (cmdId == DEBUG_POP_1_STACK_FRAME_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.pop1StackFrame(context);
            }
            return true;
        }
        if (cmdId == DEBUG_SETNEXTSTATEMENT_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.setNextStatement(context);
            }
            return true;
        }
        if (cmdId == DEBUG_SHOWIP_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.showIP();
            }
            return true;
        }
        if (cmdId == DEBUG_GC_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.gc();
            }
            return true;
        }
        if (cmdId == CONTEXTMENU_DEBUG_CMD_ID) {
            context = (Context)action.getValue("UserData");
            action.putValue("UserData", null);
            Node contextNode = RunProcess.getContextNodeForRun((Context)context);
            if (contextNode != null && !(contextNode instanceof Workspace) && !(contextNode instanceof Project)) {
                context.setProperty(RunProcess.RUN_PROCESS_DO_NOT_CONSIDER_DEFAULT, (Object)Boolean.TRUE);
            }
            this.startProcess(context, false);
            return true;
        }
        if (cmdId == NAVIGATOR_STOPLISTENING_CMD_ID) {
            this.stopListening(context);
            return true;
        }
        if (cmdId == NAVIGATOR_DETACHDEBUGGER_CMD_ID) {
            this.detachDebugger(context);
            return true;
        }
        if (cmdId == CODE_EDITOR_GUTTER_TOGGLEBREAKPOINT_CMD_ID) {
            this.toggleBreakpointFromCodeEditor(context, null);
            return true;
        }
        if (cmdId == CODE_EDITOR_GUTTER_TOGGLEWATCHPOINT_CMD_ID) {
            this.toggleWatchpointFromCodeEditor(context, null);
            return true;
        }
        if (cmdId == CODE_EDITOR_GUTTER_ENABLEBREAKPOINT_CMD_ID) {
            this.enableBreakpointFromCodeEditor(context, null);
            return true;
        }
        if (cmdId == CODE_EDITOR_GUTTER_DISABLEBREAKPOINT_CMD_ID) {
            this.disableBreakpointFromCodeEditor(context, null);
            return true;
        }
        if (cmdId == CODE_EDITOR_GUTTER_EDITBREAKPOINT_CMD_ID) {
            this.editBreakpointFromCodeEditor(context, null);
            return true;
        }
        if (cmdId == CODE_EDITOR_WATCH_CMD_ID) {
            this.watchFromCodeEditor(context);
            return true;
        }
        if (cmdId == CODE_EDITOR_INSPECT_CMD_ID) {
            this.inspectFromCodeEditor(context);
            return true;
        }
        if (cmdId == STRUCTURE_CREATEWATCHPOINT_CMD_ID) {
            this.createWatchpointFromStructure(context, null);
            return true;
        }
        if (cmdId == LOG_WINDOW_CANCEL_DEBUG_CONNECTION_CMD_ID || cmdId == LOG_WINDOW_SHOWIP_CMD_ID || cmdId == LOG_WINDOW_RESUME_CMD_ID || cmdId == LOG_WINDOW_STEPOVER_CMD_ID || cmdId == LOG_WINDOW_STEPINTO_CMD_ID || cmdId == LOG_WINDOW_STEPOUT_CMD_ID || cmdId == LOG_WINDOW_STEPTOENDOFMETHOD_CMD_ID || cmdId == LOG_WINDOW_STEPOVERBC_CMD_ID || cmdId == LOG_WINDOW_STEPINTOBC_CMD_ID || cmdId == LOG_WINDOW_PAUSE_CMD_ID || cmdId == LOG_WINDOW_RESET_CMD_ID || cmdId == LOG_WINDOW_GC_CMD_ID) {
            this.doLogWindowAction(context, cmdId);
            return true;
        }
        return cmdId == 5 || cmdId == 6 || cmdId == 18 || cmdId == 17 || cmdId == 78 || cmdId == 19;
    }

    private void startMruProcess() {
        Context context = JRunner.prepareMruProcess();
        this.startProcess(context, true);
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == DEBUG_PROJECT_CMD_ID) {
            this.updateDebugProjectAction(action);
            return true;
        }
        if (cmdId == DEBUG_CMD_MRU_CONFIGURATION_ID) {
            this.updateDebugMRUConfigurationAction(action);
            return true;
        }
        if (RunManager.arrayContains(debugProjectCmdIds, cmdId)) {
            RunConfiguration runConfiguration = (RunConfiguration)((Object)action.getValue("UserData"));
            action.setState(false);
            return true;
        }
        if (cmdId == DEBUG_SELECTION_CMD_ID) {
            this.updateDebugSelectionAction(action, context);
            return true;
        }
        if (cmdId == DEBUG_PAUSE_CMD_ID) {
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canPause());
            return true;
        }
        if (cmdId == DEBUG_RESUME_CMD_ID) {
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canResume());
            return true;
        }
        if (cmdId == DEBUG_DETACH_CMD_ID) {
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canDetach());
            return true;
        }
        if (cmdId == DEBUG_RESET_CMD_ID) {
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canTerminate());
            return true;
        }
        if (cmdId == DEBUG_STEPOVER_CMD_ID || cmdId == DEBUG_STEPOVERBC_CMD_ID) {
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canStepOver());
            return true;
        }
        if (cmdId == DEBUG_STEPINTO_CMD_ID || cmdId == DEBUG_STEPINTOBC_CMD_ID) {
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canStepInto());
            return true;
        }
        if (cmdId == DEBUG_STEPOUT_CMD_ID) {
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canStepOut());
            return true;
        }
        if (cmdId == DEBUG_STEPTOENDOFMETHOD_CMD_ID) {
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canStepToEndOfMethod());
            return true;
        }
        if (cmdId == DEBUG_CONTINUESTEP_CMD_ID) {
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canContinueStep());
            return true;
        }
        if (cmdId == DEBUG_RUNTOCURSOR_CMD_ID) {
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canRunToCursor(context));
            return true;
        }
        if (cmdId == DEBUG_STEPINTOMETHOD_CMD_ID) {
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canStepIntoMethod(context));
            return true;
        }
        if (cmdId == DEBUG_SETNEXTSTATEMENT_CMD_ID) {
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canSetNextStatement(context));
            return true;
        }
        if (cmdId == DEBUG_POP_1_STACK_FRAME_CMD_ID) {
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canPop1StackFrame(context));
            return true;
        }
        if (cmdId == DEBUG_SHOWIP_CMD_ID) {
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canShowIP());
            return true;
        }
        if (cmdId == DEBUG_GC_CMD_ID) {
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canGC());
            return true;
        }
        if (cmdId == VIEW_BREAKPOINTS_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        if (cmdId == VIEW_THREADS_CMD_ID) {
            action.setEnabled(this.canShowDebuggingWindows());
            return true;
        }
        if (cmdId == VIEW_CLASSES_CMD_ID) {
            action.setEnabled(this.canShowDebuggingWindows());
            return true;
        }
        if (cmdId == VIEW_STACK_CMD_ID) {
            action.setEnabled(this.canShowDebuggingWindows());
            return true;
        }
        if (cmdId == VIEW_SMART_CMD_ID) {
            action.setEnabled(this.canShowDebuggingWindows());
            return true;
        }
        if (cmdId == VIEW_LOCALS_CMD_ID) {
            action.setEnabled(this.canShowDebuggingWindows());
            return true;
        }
        if (cmdId == VIEW_WATCHES_CMD_ID) {
            action.setEnabled(this.canShowDebuggingWindows());
            return true;
        }
        if (cmdId == VIEW_HEAP_CMD_ID) {
            action.setEnabled(this.canShowDebuggingWindows() && this.canShowHeapWindow());
            return true;
        }
        if (cmdId == VIEW_MONITORS_CMD_ID) {
            action.setEnabled(this.canShowDebuggingWindows() && this.canShowMonitorsWindow());
            return true;
        }
        if (cmdId == VIEW_LOG_CMD_ID) {
            action.setEnabled(this.canShowDebuggingWindows());
            return true;
        }
        if (cmdId == CONTEXTMENU_DEBUG_CMD_ID) {
            context = (Context)action.getValue("UserData");
            this.updateContextMenuDebugAction(action, context);
            return true;
        }
        if (cmdId == NAVIGATOR_STOPLISTENING_CMD_ID) {
            action.setEnabled(this.canStopListening(context));
            return true;
        }
        if (cmdId == NAVIGATOR_DETACHDEBUGGER_CMD_ID) {
            action.setEnabled(this.canDetachDebugger(context));
            return true;
        }
        if (cmdId == CODE_EDITOR_GUTTER_TOGGLEBREAKPOINT_CMD_ID) {
            action.setEnabled(this.toggleBreakpointFromCodeEditor(context, action));
            return true;
        }
        if (cmdId == CODE_EDITOR_GUTTER_TOGGLEWATCHPOINT_CMD_ID) {
            action.setEnabled(this.toggleWatchpointFromCodeEditor(context, action));
            return true;
        }
        if (cmdId == CODE_EDITOR_GUTTER_ENABLEBREAKPOINT_CMD_ID) {
            action.setEnabled(this.enableBreakpointFromCodeEditor(context, action));
            return true;
        }
        if (cmdId == CODE_EDITOR_GUTTER_DISABLEBREAKPOINT_CMD_ID) {
            action.setEnabled(this.disableBreakpointFromCodeEditor(context, action));
            return true;
        }
        if (cmdId == CODE_EDITOR_GUTTER_EDITBREAKPOINT_CMD_ID) {
            action.setEnabled(this.editBreakpointFromCodeEditor(context, action));
            return true;
        }
        if (cmdId == CODE_EDITOR_WATCH_CMD_ID || cmdId == CODE_EDITOR_INSPECT_CMD_ID) {
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.isStopped());
            return true;
        }
        if (cmdId == STRUCTURE_CREATEWATCHPOINT_CMD_ID) {
            action.setEnabled(this.createWatchpointFromStructure(context, action));
            return true;
        }
        if (cmdId == LOG_WINDOW_CANCEL_DEBUG_CONNECTION_CMD_ID || cmdId == LOG_WINDOW_SHOWIP_CMD_ID || cmdId == LOG_WINDOW_RESUME_CMD_ID || cmdId == LOG_WINDOW_STEPOVER_CMD_ID || cmdId == LOG_WINDOW_STEPINTO_CMD_ID || cmdId == LOG_WINDOW_STEPOUT_CMD_ID || cmdId == LOG_WINDOW_STEPTOENDOFMETHOD_CMD_ID || cmdId == LOG_WINDOW_STEPOVERBC_CMD_ID || cmdId == LOG_WINDOW_STEPINTOBC_CMD_ID || cmdId == LOG_WINDOW_PAUSE_CMD_ID || cmdId == LOG_WINDOW_RESET_CMD_ID || cmdId == LOG_WINDOW_GC_CMD_ID) {
            action.setEnabled(this.canDoLogWindowAction(context, cmdId));
            return true;
        }
        if (cmdId == 5 || cmdId == 6 || cmdId == 18 || cmdId == 17 || cmdId == 78 || cmdId == 19) {
            action.setEnabled(false);
            return true;
        }
        return false;
    }

    public void menuWillShow(ContextMenu popup) {
        DebuggingProcess connectingDebuggingProcess;
        Context context = popup.getContext();
        View view = context.getView();
        if (view instanceof NavigatorWindow) {
            if (context.getElement() == null && context.getNode() == null) {
                return;
            }
            this.insertRunnableItems(popup, context);
            if (actionNavigatorStopListening != null) {
                this.update(actionNavigatorStopListening, context);
                if (actionNavigatorStopListening.isEnabled()) {
                    if (menuitemNavigatorStopListening == null) {
                        menuitemNavigatorStopListening = popup.createMenuItem((ToggleAction)actionNavigatorStopListening);
                    }
                    popup.add((Component)menuitemNavigatorStopListening, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
                }
            }
            if (actionNavigatorDetachDebugger != null) {
                this.update(actionNavigatorDetachDebugger, context);
                if (actionNavigatorDetachDebugger.isEnabled()) {
                    if (menuitemNavigatorDetachDebugger == null) {
                        menuitemNavigatorDetachDebugger = popup.createMenuItem((ToggleAction)actionNavigatorDetachDebugger);
                    }
                    popup.add((Component)menuitemNavigatorDetachDebugger, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
                }
            }
        } else if (view instanceof Editor) {
            if (context.getElement() == null && context.getNode() == null) {
                return;
            }
            this.insertRunnableItems(popup, context);
            this.update(actionCodeEditorToggleWatchpoint, context);
            if (actionCodeEditorToggleWatchpoint.isEnabled()) {
                if (menuitemCodeEditorToggleWatchpoint == null) {
                    menuitemCodeEditorToggleWatchpoint = popup.createMenuItem((ToggleAction)actionCodeEditorToggleWatchpoint, JDeveloperMenuConstants.WEIGHT_DEBUG_TOGGLE_BREAKPOINT);
                }
                popup.add((Component)menuitemCodeEditorToggleWatchpoint, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
            }
            this.update(actionDebugRunToCursor, context);
            if (actionDebugRunToCursor.isEnabled()) {
                if (menuitemCodeEditorRunToCursor == null) {
                    menuitemCodeEditorRunToCursor = popup.createMenuItem((ToggleAction)actionDebugRunToCursor, JDeveloperMenuConstants.WEIGHT_DEBUG_RUN_TO_CURSOR);
                }
                popup.add((Component)menuitemCodeEditorRunToCursor, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
            }
            this.update(actionDebugStepIntoMethod, context);
            if (actionDebugStepIntoMethod.isEnabled()) {
                if (menuitemCodeEditorStepIntoMethod == null) {
                    menuitemCodeEditorStepIntoMethod = popup.createMenuItem((ToggleAction)actionDebugStepIntoMethod, JDeveloperMenuConstants.WEIGHT_DEBUG_STEP_INTO_METHOD_AT_CURSOR);
                }
                popup.add((Component)menuitemCodeEditorStepIntoMethod, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
            }
            this.update(actionDebugSetNextStatement, context);
            if (actionDebugSetNextStatement.isEnabled()) {
                if (menuitemCodeEditorSetNextStatement == null) {
                    menuitemCodeEditorSetNextStatement = popup.createMenuItem((ToggleAction)actionDebugSetNextStatement, JDeveloperMenuConstants.WEIGHT_DEBUG_SET_NEXT_STATEMENT);
                }
                popup.add((Component)menuitemCodeEditorSetNextStatement, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
            }
            this.update(actionCodeEditorWatch, context);
            if (actionCodeEditorWatch.isEnabled()) {
                if (menuitemCodeEditorWatch == null) {
                    menuitemCodeEditorWatch = popup.createMenuItem((ToggleAction)actionCodeEditorWatch, JDeveloperMenuConstants.WEIGHT_DEBUG_VIEW_WATCH);
                }
                popup.add((Component)menuitemCodeEditorWatch, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
            }
            this.update(actionCodeEditorInspect, context);
            if (actionCodeEditorInspect.isEnabled()) {
                if (menuitemCodeEditorInspect == null) {
                    menuitemCodeEditorInspect = popup.createMenuItem((ToggleAction)actionCodeEditorInspect, JDeveloperMenuConstants.WEIGHT_DEBUG_VIEW_INSPECT);
                }
                popup.add((Component)menuitemCodeEditorInspect, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
            }
        } else if (view instanceof CodeEditorGutter.GutterView) {
            if (context.getElement() == null && context.getNode() == null) {
                return;
            }
            if (CodeEditorGutter.isMarkDroppingDown((Context)context)) {
                return;
            }
            this.update(actionCodeEditorGutterToggleBreakpoint, context);
            if (actionCodeEditorGutterToggleBreakpoint.isEnabled()) {
                if (menuitemCodeEditorGutterToggleBreakpoint == null) {
                    menuitemCodeEditorGutterToggleBreakpoint = popup.createMenuItem((ToggleAction)actionCodeEditorGutterToggleBreakpoint, JDeveloperMenuConstants.WEIGHT_DEBUG_TOGGLE_BREAKPOINT);
                }
                popup.add((Component)menuitemCodeEditorGutterToggleBreakpoint, 3.0f);
            }
            this.update(actionCodeEditorToggleWatchpoint, context);
            if (actionCodeEditorToggleWatchpoint.isEnabled()) {
                if (menuitemCodeEditorToggleWatchpoint == null) {
                    menuitemCodeEditorToggleWatchpoint = popup.createMenuItem((ToggleAction)actionCodeEditorToggleWatchpoint, JDeveloperMenuConstants.WEIGHT_DEBUG_TOGGLE_BREAKPOINT);
                }
                popup.add((Component)menuitemCodeEditorToggleWatchpoint, 3.0f);
            }
            this.update(actionCodeEditorGutterEnableBreakpoint, context);
            if (actionCodeEditorGutterEnableBreakpoint.isEnabled()) {
                if (menuitemCodeEditorGutterEnableBreakpoint == null) {
                    menuitemCodeEditorGutterEnableBreakpoint = popup.createMenuItem((ToggleAction)actionCodeEditorGutterEnableBreakpoint, JDeveloperMenuConstants.WEIGHT_DEBUG_ENABLE_BREAKPOINT);
                }
                popup.add((Component)menuitemCodeEditorGutterEnableBreakpoint, 3.0f);
            }
            this.update(actionCodeEditorGutterDisableBreakpoint, context);
            if (actionCodeEditorGutterDisableBreakpoint.isEnabled()) {
                if (menuitemCodeEditorGutterDisableBreakpoint == null) {
                    menuitemCodeEditorGutterDisableBreakpoint = popup.createMenuItem((ToggleAction)actionCodeEditorGutterDisableBreakpoint, JDeveloperMenuConstants.WEIGHT_DEBUG_ENABLE_BREAKPOINT);
                }
                popup.add((Component)menuitemCodeEditorGutterDisableBreakpoint, 3.0f);
            }
            this.update(actionCodeEditorGutterEditBreakpoint, context);
            if (actionCodeEditorGutterEditBreakpoint.isEnabled()) {
                if (menuitemCodeEditorGutterEditBreakpoint == null) {
                    menuitemCodeEditorGutterEditBreakpoint = popup.createMenuItem((ToggleAction)actionCodeEditorGutterEditBreakpoint, JDeveloperMenuConstants.WEIGHT_DEBUG_EDIT_BREAKPOINT);
                }
                popup.add((Component)menuitemCodeEditorGutterEditBreakpoint, 3.0f);
            }
        } else if (view instanceof ExplorerWindow) {
            if (context.getElement() == null && context.getNode() == null) {
                return;
            }
            this.update(actionStructureCreateWatchpoint, context);
            if (actionStructureCreateWatchpoint.isEnabled()) {
                if (menuitemStructureCreateWatchpoint == null) {
                    menuitemStructureCreateWatchpoint = popup.createMenuItem((ToggleAction)actionStructureCreateWatchpoint, JDeveloperMenuConstants.WEIGHT_DEBUG_TOGGLE_BREAKPOINT);
                }
                popup.add((Component)menuitemStructureCreateWatchpoint, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
            }
        } else if (view instanceof RunLogPage && (connectingDebuggingProcess = this.findDebuggingProcess((RunLogPage)view, true)) != null) {
            this.update(actionLogWindowCancelDebugConnection, context);
            if (actionLogWindowCancelDebugConnection.isEnabled()) {
                if (menuitemLogWindowCancelDebugConnection == null) {
                    menuitemLogWindowCancelDebugConnection = popup.createMenuItem((ToggleAction)actionLogWindowCancelDebugConnection);
                }
                popup.add((Component)menuitemLogWindowCancelDebugConnection, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
            }
        }
    }

    public void menuWillHide(ContextMenu popup) {
        RunnableItem.reset();
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private void insertRunnableItems(ContextMenu popup, Context context) {
        if (actionContextMenuDebug == null) {
            actionContextMenuDebug = IdeAction.get((int)CONTEXTMENU_DEBUG_CMD_ID, null, (String)DbgArb.getString(358), null, (Integer)DbgArb.getInteger(923), (ArrayResourceBundle)DbgArb.getInstance(), (int)92, null, (boolean)false);
            actionContextMenuDebug.putValue("NoCtxName", (Object)DbgArb.getString(358));
            actionContextMenuDebug.addController((Controller)this);
        }
        actionContextMenuDebug.putValue("UserData", (Object)context);
        this.update(actionContextMenuDebug, context);
        if (actionContextMenuDebug.isEnabled()) {
            MnemonicSolver.MenuLabel mlabel;
            JMenuItem menuitemContextMenuDebug = popup.createMenuItem((ToggleAction)actionContextMenuDebug, JDeveloperMenuConstants.WEIGHT_DEBUG_DEBUG_FILE);
            popup.add((Component)menuitemContextMenuDebug, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
            MnemonicSolver solver = popup.getMnemonicSolver();
            if (solver != null && (mlabel = solver.findMenuLabel(menuitemContextMenuDebug)) != null) {
                mlabel.setText(DbgArb.getString(358));
            }
        } else {
            actionContextMenuDebug.putValue("UserData", null);
        }
    }

    public void editorOpened(Editor editor) {
        if (editor instanceof CodeEditor) {
            CodeEditor ceditor = (CodeEditor)editor;
            SourceIcon.gutterCreated(ceditor);
            CodeEditorGutter gutter = ceditor.getGutter();
            gutter.addGutterClickListener((GutterClickListener)this);
            if (this.isToolTipProvider) {
                ceditor.addCEToolTipProvider((CEToolTipProvider)this);
            }
        }
    }

    public void editorActivated(Editor editor) {
    }

    public void editorDeactivated(Editor editor) {
    }

    public void editorClosed(Editor editor) {
        if (editor instanceof CodeEditor) {
            CodeEditor ceditor = (CodeEditor)editor;
            SourceIcon.gutterDestroyed(ceditor);
            CodeEditorGutter gutter = ceditor.getGutter();
            gutter.removeGutterClickListener((GutterClickListener)this);
            if (this.isToolTipProvider) {
                ceditor.removeCEToolTipProvider((CEToolTipProvider)this);
            }
        }
    }

    public void lineClicked(Gutter gutter, int clickedLine, MouseEvent event) {
        CodeEditorGutter codeEditorGutter;
        Context context;
        if (gutter instanceof CodeEditorGutter && (context = (codeEditorGutter = (CodeEditorGutter)gutter).getContext()) != null) {
            this.toggleBreakpoint(context, codeEditorGutter.getCodeEditor(), clickedLine);
        }
    }

    public String getToolTipText(CodeEditor codeEditor, MouseEvent mouseEvent, int offset) {
        if (this.shouldProvideToolTip()) {
            if (this.toolTipEvaluator == null) {
                this.toolTipEvaluator = new ToolTipEvaluator(this);
            }
            String toolTip = this.toolTipEvaluator.getToolTip(codeEditor, offset);
            return toolTip;
        }
        return null;
    }

    public void activeViewChanged(ActiveViewEvent e) {
        if (this.activeView != null) {
            this.activeView.removeViewSelectionListener((ViewSelectionListener)this);
        }
        if (this.activeCodeEditor != null) {
            this.activeCodeEditor.removeCursorListener((CursorListener)this);
        }
        if (this.activeInspector != null) {
            this.activeInspector.inspectorActiveView(false);
        }
        this.activeView = Ide.getMainWindow().getLastActiveView();
        Context context = this.activeView.getContext();
        this.activeCodeEditor = Source.getCodeEditorFromContext(context);
        InspectorWindow inspectorWindow = this.activeInspector = this.activeView instanceof InspectorWindow ? (InspectorWindow)this.activeView : null;
        if (this.activeView != null) {
            this.activeView.addViewSelectionListener((ViewSelectionListener)this);
        }
        if (this.activeCodeEditor != null) {
            this.activeCodeEditor.addCursorListener((CursorListener)this);
        }
        if (this.activeInspector != null) {
            this.activeInspector.inspectorActiveView(true);
        }
        this.checkCommandsBecauseActiveViewChanged();
    }

    public void viewSelectionChanged(ViewSelectionEvent e) {
        this.checkCommandsBecauseViewSelectionChanged();
    }

    public void update(Object observed, UpdateMessage change) {
        1 runnable = new 1(this, change, observed);
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void addinsLoaded(IdeEvent e) {
    }

    public void mainWindowOpened(IdeEvent e) {
        Ide.removeIdeListener((IdeListener)this);
        Breakpoint.loadBreakpoints();
        JDebugger.registerPanels();
        SourceIcon.createHighlightStyles();
        this.activeViewChanged(null);
        this.activeProjectChanged();
        Ide.getSystem().attach((Observer)this);
        Ide.getMainWindow().addActiveViewListener((ActiveViewListener)this);
        Compiler compiler = Compiler.getCompiler();
        if (compiler != null) {
            compiler.addBuildSystemListener((BuildSystemListener)this);
        }
        if (NavigatorManager.getWorkspaceNavigatorManager() != null) {
            NavigatorManager.getWorkspaceNavigatorManager().addContextMenuListener((ContextMenuListener)this, null);
        }
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener((ContextMenuListener)this);
        LogManager.getLogManager().getContextMenu().addContextMenuListener((ContextMenuListener)this);
        CodeEditorGutter.getGutterContextMenu().addContextMenuListener((ContextMenuListener)this);
        ExplorerManager.getExplorerManager().getContextMenu().addContextMenuListener((ContextMenuListener)this);
        RefactoringManager refactoringManager = RefactoringManager.getRefactoringManager();
        if (refactoringManager != null) {
            refactoringManager.registerUrlHandler(Breakpoint.getRefactoringHandler(), 0.5);
        }
        Project.addProjectChangeListener((String)"", (ProjectChangeListener)new 2());
    }

    public void mainWindowClosing(IdeEvent e) {
        Ide.getSystem().detach((Observer)this);
        Ide.getMainWindow().removeActiveViewListener((ActiveViewListener)this);
        Compiler compiler = Compiler.getCompiler();
        if (compiler != null) {
            compiler.removeBuildSystemListener((BuildSystemListener)this);
        }
        NavigatorManager.getWorkspaceNavigatorManager().removeContextMenuListener((ContextMenuListener)this);
        EditorManager.getEditorManager().getContextMenu().removeContextMenuListener((ContextMenuListener)this);
        LogManager.getLogManager().getContextMenu().removeContextMenuListener((ContextMenuListener)this);
        CodeEditorGutter.getGutterContextMenu().removeContextMenuListener((ContextMenuListener)this);
        ExplorerManager.getExplorerManager().getContextMenu().removeContextMenuListener((ContextMenuListener)this);
    }

    public void cursorUpdate(CodeEditor codeEditor) {
        this.checkCommandsBecauseCursorMoved();
    }

    public void initialize() {
        Debugger.setDebugger((Debugger)this);
        this.initializeIDESettings();
        this.dbgSettings = DebugWindowSettings.getInstance();
        this.dbgSettings.addStructureChangeListener(new 3());
        this.makeActions();
        this.declareShortcuts();
        this.addViewDebuggerSubMenu();
        runMenu = MenuManager.getJMenu((String)"Run");
        runMenu.addMenuListener(this);
        this.debugDockableFactory = new DebugDockableFactory(this);
        this.getDebugLayout();
        EditorManager.getEditorManager().addEditorListener((EditorListener)this);
        Ide.addIdeListener((IdeListener)this);
        ExitCommand.addShutdownHook((ShutdownHook)this);
    }

    public boolean canShutdown() {
        return true;
    }

    public void shutdown() {
        EditorManager.getEditorManager().removeEditorListener((EditorListener)this);
        if (this.debuggingListeners != null) {
            int i = this.debuggingListeners.size() - 1;
            while (i >= 0) {
                DebuggingListener debuggingListener = this.debuggingListeners.get(i);
                debuggingListener.stopListening();
                --i;
            }
        }
        if (this.debuggingProcesses != null) {
            int i = this.debuggingProcesses.size() - 1;
            while (i >= 0) {
                DebuggingProcess debuggingProcess = this.debuggingProcesses.get(i);
                debuggingProcess.terminate();
                --i;
            }
        }
        if (this.objectPreferences != null) {
            this.objectPreferences.saveChangedSettings();
        }
        Breakpoint.saveBreakpoints();
        this.windowManager.shutdownWindows();
    }

    public void buildWillStart(Context context) {
        SwingUtilities.invokeLater(new 4());
    }

    public void buildFinished(int errorCount, int warningCount, int infoCount) {
        new 5("JDebuggerWaitForCompiler").start();
    }

    public void cleanWillStart(Context context) {
    }

    public void cleanFinished(Context context) {
    }

    public JMenu getDebugMenu() {
        return runMenu;
    }

    public synchronized ContextMenu getContextMenu() {
        if (contextMenu == null) {
            contextMenu = new ContextMenu();
        }
        return contextMenu;
    }

    public JMenu getViewMenu() {
        if (!viewDebuggerSubMenuBuilt) {
            this.buildViewDebuggerSubMenu();
        }
        return viewDebuggerSubMenu;
    }

    public boolean isDebugging() {
        if (this.debuggingProcesses != null) {
            return this.debuggingProcesses.isEmpty() ^ true;
        }
        return false;
    }

    public void startDebugger(Context context, DebuggerStartCallback callBack) {
        DebuggingProcess pr = new DebuggingProcess(context, callBack);
        pr.start();
    }

    public void redefineClasses(Map compilerMap) {
        this.redefineClasses(null, compilerMap);
    }

    public void redefineClasses(Project project, Map compilerMap) {
        HashMap nameToGuts = new HashMap();
        nameToGuts.putAll(compilerMap);
        ++this.duringClassRedefinition;
        6 runWhilePaused = new 6(this, nameToGuts);
        7 runOnceLater = new 7();
        this.pauseAndInvoke(runWhilePaused, runOnceLater);
    }

    public boolean isStackTraceLine(String line) {
        try {
            int openParen = line.indexOf(40);
            if (openParen != -1) {
                int closeParen;
                int space = line.lastIndexOf(32, openParen);
                int dot = line.lastIndexOf(46, openParen);
                int colon = line.indexOf(58, openParen);
                if (space != -1 && dot != -1 && colon != -1 && dot > space + 1 && colon > openParen + 1 && (closeParen = line.indexOf(41, colon)) != -1 && closeParen > colon + 1) {
                    int lineNumber = Integer.parseInt(line.substring(colon + 1, closeParen));
                    String classname = line.substring(space + 1, dot);
                    String filename = line.substring(openParen + 1, colon);
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    public boolean showSourceFileForStackTraceLine(Workspace workspace, Project project, String stackTraceLine) {
        try {
            int openParen = stackTraceLine.indexOf(40);
            if (openParen != -1) {
                int closeParen;
                int space = stackTraceLine.lastIndexOf(32, openParen);
                int dot = stackTraceLine.lastIndexOf(46, openParen);
                int colon = stackTraceLine.indexOf(58, openParen);
                if (space != -1 && dot != -1 && colon != -1 && dot > space + 1 && colon > openParen + 1 && (closeParen = stackTraceLine.indexOf(41, colon)) != -1 && closeParen > colon + 1) {
                    int lineNumber = Integer.parseInt(stackTraceLine.substring(colon + 1, closeParen));
                    String classname = stackTraceLine.substring(space + 1, dot);
                    String filename = stackTraceLine.substring(openParen + 1, colon);
                    int lastDot = classname.lastIndexOf(46);
                    String pkg = lastDot != -1 ? classname.substring(0, lastDot) : "";
                    boolean bl = Source.showSourceFile(workspace, project, pkg, classname, filename, lineNumber, false, null);
                    return bl;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    public URL parseStackTraceLine(Workspace workspace, Project project, String stackTraceLine) {
        try {
            int openParen = stackTraceLine.indexOf(40);
            if (openParen != -1) {
                int closeParen;
                int space = stackTraceLine.lastIndexOf(32, openParen);
                int dot = stackTraceLine.lastIndexOf(46, openParen);
                int colon = stackTraceLine.indexOf(58, openParen);
                if (space != -1 && dot != -1 && colon != -1 && dot > space + 1 && colon > openParen + 1 && (closeParen = stackTraceLine.indexOf(41, colon)) != -1 && closeParen > colon + 1) {
                    URL urlWithLine;
                    int lineNumber = Integer.parseInt(stackTraceLine.substring(colon + 1, closeParen));
                    String classname = stackTraceLine.substring(space + 1, dot);
                    String filename = stackTraceLine.substring(openParen + 1, colon);
                    int lastDot = classname.lastIndexOf(46);
                    String pkg = lastDot != -1 ? classname.substring(0, lastDot) : "";
                    URL url = Source.findSourceFile(workspace, project, pkg, filename);
                    URL uRL = urlWithLine = URLFactory.replaceRefPart((URL)url, (String)Integer.toString(lineNumber));
                    return uRL;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    public boolean showSourceFileForStackTraceLine(Workspace workspace, Project project, URL urlWithLine) {
        int lineNumber = 0;
        try {
            String ref = urlWithLine.getRef();
            lineNumber = Integer.parseInt(ref);
        }
        catch (Exception e) {
            // empty catch block
        }
        URL url = URLFactory.replaceRefPart((URL)urlWithLine, null);
        return Source.showSourceFile(workspace, project, url, lineNumber, true);
    }

    public void addSmartDataProvider(SmartDataProvider smartDataProvider) {
        smartDataProviders.add(smartDataProvider);
    }

    public void removeSmartDataProvider(SmartDataProvider smartDataProvider) {
        smartDataProviders.remove(smartDataProvider);
    }

    public void addToolTipExpressionProvider(ToolTipExpressionProvider toolTipExpressionProvider) {
        toolTipExpressionProviders.add(toolTipExpressionProvider);
    }

    public void removeToolTipExpressionProvider(ToolTipExpressionProvider toolTipExpressionProvider) {
        toolTipExpressionProviders.remove(toolTipExpressionProvider);
    }

    public void addRunAndDebugToContextMenu(ContextMenu popup, Context context) {
        JRunner.getInstance().insertRunnableItems(popup, context);
        this.insertRunnableItems(popup, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDebuggerListener(DebuggerAdapter debuggerListener) {
        List<DebuggerListener> list = this.debuggerListeners;
        synchronized (list) {
            if (!this.debuggerListeners.contains(debuggerListener)) {
                this.debuggerListeners.add((DebuggerListener)debuggerListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDebuggerListener(DebuggerAdapter debuggerListener) {
        List<DebuggerListener> list = this.debuggerListeners;
        synchronized (list) {
            this.debuggerListeners.remove(debuggerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebuggerWindowProviderCallback addDebuggerWindowProvider(DebuggerWindowProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Need a valid DebuggerWindowProvider argument");
        }
        List<DebuggerListener> list = this.debuggerListeners;
        synchronized (list) {
            provider.setDebuggerDockableLayoutPrefix(DEBUGGER_ID);
            if (!this.debuggerListeners.contains(provider)) {
                this.debuggerListeners.add((DebuggerListener)provider);
            }
        }
        return this.windowManager.addDebuggerWindowProvider(provider, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDebuggerWindowProvider(DebuggerWindowProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Need a valid DebuggerWindowProvider argument");
        }
        List<DebuggerListener> list = this.debuggerListeners;
        synchronized (list) {
            this.debuggerListeners.remove(provider);
        }
        this.windowManager.removeDebuggerWindowProvider(provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebuggerExtenderCallback addDebuggerExtender(DebuggerExtender extender) {
        if (extender == null) {
            throw new IllegalArgumentException("Need a valid DebuggerExtender argument");
        }
        List<DebuggerListener> list = this.debuggerListeners;
        synchronized (list) {
            if (!this.debuggerListeners.contains(extender)) {
                this.debuggerListeners.add((DebuggerListener)extender);
            }
        }
        return this.extenderManager.addExtender(extender);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDebuggerExtender(DebuggerExtender extender) {
        if (extender == null) {
            throw new IllegalArgumentException("Need a valid DebuggerExtender argument");
        }
        List<DebuggerListener> list = this.debuggerListeners;
        synchronized (list) {
            this.debuggerListeners.remove(extender);
        }
        this.extenderManager.removeExtender(extender);
    }

    public Object evaluateNumericExpression(String expression) {
        JavaEvaluator evaluator = new JavaEvaluator(new DebugContext(), false);
        Object o = evaluator.evaluate(expression);
        if (o instanceof EvaluationInfo) {
            EvaluationInfo eval = (EvaluationInfo)o;
            return eval.getWrappedValue();
        }
        return null;
    }

    public void addObjectPreferencesExpression(String className, String expression, boolean select) {
        if (expression != null && expression.length() > 0) {
            this.getObjectPreferences();
            this.objectPreferences.addValueExpressionSuggestion(className, expression);
            if (select) {
                this.objectPreferences.setValueExpression(className, expression);
            }
        }
    }

    public void addObjectPreferencesExpansion(String className, String expansion, boolean select) {
        if (expansion != null && expansion.length() > 0) {
            this.getObjectPreferences();
            this.objectPreferences.addExpandExpressionSuggestion(className, expansion);
            if (select) {
                this.objectPreferences.setExpandExpression(className, expansion);
            }
        }
    }

    public void addObjectPreferencesHideAllFields(String className) {
        if (className != null && className.length() > 0) {
            this.getObjectPreferences();
            this.objectPreferences.addHideAllFields(className);
        }
    }

    public void addObjectPreferencesHideField(String className, String fieldName) {
        if (className != null && className.length() > 0 && fieldName != null && fieldName.length() > 0) {
            this.getObjectPreferences();
            this.objectPreferences.addHideField(className, fieldName);
        }
    }

    public void addObjectPreferencesIcon(String className, String iconName) {
        if (className != null && className.length() > 0 && iconName != null && iconName.length() > 0) {
            this.getObjectPreferences();
            this.objectPreferences.addIcon(className, iconName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DebuggerListener[] getDebuggerListeners() {
        List<DebuggerListener> list = this.debuggerListeners;
        synchronized (list) {
            DebuggerListener[] debuggerListenerArray = this.debuggerListeners.toArray(new DebuggerListener[this.debuggerListeners.size()]);
            return debuggerListenerArray;
        }
    }

    synchronized IdeLayout getDebugLayout() {
        if (this.debugLayout == null) {
            ExtensionRegistry er = ExtensionRegistry.getOracleRegistry();
            URL url = er.getSystemDirectory("oracle.ide");
            String filename = url.getPath() + "Debugging" + ".layout";
            this.debugLayout = new IdeLayout(URLFactory.newFileURL((String)filename), DbgArb.getString(628), DbgArb.getInstance(), 586);
            this.debugLayout.setProperty(DEBUG_LAYOUT_KEY, Boolean.toString(true));
            Layouts.getLayouts().add((Element)this.debugLayout);
        }
        return this.debugLayout;
    }

    private void makeActions() {
        String category = DbgArb.getString(171);
        SharedActions shared = SharedActions.getInstance();
        int EMPTY_DEBUG_PROJECT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugProjectCommandEmpty");
        actionEmpty = IdeAction.get((int)EMPTY_DEBUG_PROJECT_CMD_ID, null, (String)RunMgrArb.getString(33), (String)category, null, null, null, (boolean)false);
        actionDebugProject = IdeAction.get((int)DEBUG_PROJECT_CMD_ID, null, (String)DbgArb.getString(667), (String)category, (Integer)DbgArb.getInteger(216), (ArrayResourceBundle)DbgArb.getInstance(), (int)465, null, (boolean)false);
        actionDebugProject.putValue("NoCtxName", (Object)DbgArb.getString(667));
        actionDebugProject.addController((Controller)this);
        actionDebugProject.putValue("ActionMenuActions", (Object)new IdeAction[]{actionEmpty});
        actionDebugSelection = IdeAction.get((int)DEBUG_SELECTION_CMD_ID, null, (String)DbgArb.getString(43), (String)category, (Integer)DbgArb.getInteger(339), (ArrayResourceBundle)DbgArb.getInstance(), (int)737, null, (boolean)false);
        actionDebugSelection.putValue("NoCtxName", (Object)DbgArb.getString(43));
        actionDebugSelection.addController((Controller)this);
        actionDebugToggleBreakpoint = IdeAction.get((int)CODE_EDITOR_GUTTER_TOGGLEBREAKPOINT_CMD_ID, null, (String)DbgArb.getString(488), (String)category, (Integer)DbgArb.getInteger(430), (ArrayResourceBundle)DbgArb.getInstance(), (int)562, null, (boolean)false);
        actionDebugToggleBreakpoint.addController((Controller)this);
        actionDebugPause = shared.getSuspendAction();
        actionDebugResume = shared.getResumeAction();
        actionDebugDetach = IdeAction.get((int)DEBUG_DETACH_CMD_ID, null, (String)DbgArb.getString(65), (String)category, (Integer)DbgArb.getInteger(240), (ArrayResourceBundle)DbgArb.getInstance(), (int)5, null, (boolean)false);
        actionDebugDetach.addController((Controller)this);
        actionDebugReset = shared.getTerminateAction();
        actionDebugStepOver = IdeAction.get((int)DEBUG_STEPOVER_CMD_ID, null, (String)DbgArb.getString(118), (String)category, (Integer)DbgArb.getInteger(354), (ArrayResourceBundle)DbgArb.getInstance(), (int)372, null, (boolean)false);
        actionDebugStepOver.addController((Controller)this);
        actionDebugStepOverBC = IdeAction.get((int)DEBUG_STEPOVERBC_CMD_ID, null, (String)DbgArb.getString(778), (String)category, (Integer)DbgArb.getInteger(132), (ArrayResourceBundle)DbgArb.getInstance(), (int)945, null, (boolean)false);
        actionDebugStepOverBC.addController((Controller)this);
        actionDebugStepInto = IdeAction.get((int)DEBUG_STEPINTO_CMD_ID, null, (String)DbgArb.getString(755), (String)category, (Integer)DbgArb.getInteger(477), (ArrayResourceBundle)DbgArb.getInstance(), (int)450, null, (boolean)false);
        actionDebugStepInto.addController((Controller)this);
        actionDebugStepIntoBC = IdeAction.get((int)DEBUG_STEPINTOBC_CMD_ID, null, (String)DbgArb.getString(914), (String)category, (Integer)DbgArb.getInteger(698), (ArrayResourceBundle)DbgArb.getInstance(), (int)865, null, (boolean)false);
        actionDebugStepIntoBC.addController((Controller)this);
        actionDebugStepOut = IdeAction.get((int)DEBUG_STEPOUT_CMD_ID, null, (String)DbgArb.getString(435), (String)category, (Integer)DbgArb.getInteger(179), (ArrayResourceBundle)DbgArb.getInstance(), (int)236, null, (boolean)false);
        actionDebugStepOut.addController((Controller)this);
        actionDebugStepToEndOfMethod = IdeAction.get((int)DEBUG_STEPTOENDOFMETHOD_CMD_ID, null, (String)DbgArb.getString(325), (String)category, (Integer)DbgArb.getInteger(394), (ArrayResourceBundle)DbgArb.getInstance(), (int)460, null, (boolean)false);
        actionDebugStepToEndOfMethod.addController((Controller)this);
        actionDebugContinueStep = IdeAction.get((int)DEBUG_CONTINUESTEP_CMD_ID, null, (String)DbgArb.getString(906), (String)category, (Integer)DbgArb.getInteger(541), (ArrayResourceBundle)DbgArb.getInstance(), (int)261, null, (boolean)false);
        actionDebugContinueStep.addController((Controller)this);
        actionDebugRunToCursor = IdeAction.get((int)DEBUG_RUNTOCURSOR_CMD_ID, null, (String)DbgArb.getString(206), (String)category, (Integer)DbgArb.getInteger(298), (ArrayResourceBundle)DbgArb.getInstance(), (int)406, null, (boolean)false);
        actionDebugRunToCursor.addController((Controller)this);
        actionDebugStepIntoMethod = IdeAction.get((int)DEBUG_STEPINTOMETHOD_CMD_ID, null, (String)DbgArb.getString(582), (String)category, (Integer)DbgArb.getInteger(512), (ArrayResourceBundle)DbgArb.getInstance(), (int)432, null, (boolean)false);
        actionDebugStepIntoMethod.addController((Controller)this);
        actionDebugSetNextStatement = IdeAction.get((int)DEBUG_POP_1_STACK_FRAME_CMD_ID, null, (String)DbgArb.getString(166), (String)category, (Integer)DbgArb.getInteger(36), (ArrayResourceBundle)DbgArb.getInstance(), (int)44, null, (boolean)false);
        actionDebugSetNextStatement.addController((Controller)this);
        actionDebugShowIP = IdeAction.get((int)DEBUG_SHOWIP_CMD_ID, null, (String)DbgArb.getString(877), (String)category, (Integer)DbgArb.getInteger(384), (ArrayResourceBundle)DbgArb.getInstance(), (int)495, null, (boolean)false);
        actionDebugShowIP.addController((Controller)this);
        actionDebugGC = shared.getGcAction();
        shared.addController(this);
        String ACTION_CATEGORY_VIEW = IdeMainWindow.ACTION_CATEGORY_VIEW;
        actionViewBreakpoints = IdeAction.get((int)VIEW_BREAKPOINTS_CMD_ID, null, (String)DbgArb.getString(424), (String)ACTION_CATEGORY_VIEW, (Integer)DbgArb.getInteger(39), (ArrayResourceBundle)DbgArb.getInstance(), (int)903, null, (boolean)true);
        actionViewBreakpoints.addController((Controller)this);
        actionViewThreads = IdeAction.get((int)VIEW_THREADS_CMD_ID, null, (String)DbgArb.getString(861), (String)ACTION_CATEGORY_VIEW, (Integer)DbgArb.getInteger(438), (ArrayResourceBundle)DbgArb.getInstance(), (int)63, null, (boolean)false);
        actionViewThreads.addController((Controller)this);
        actionViewStack = IdeAction.get((int)VIEW_STACK_CMD_ID, null, (String)DbgArb.getString(235), (String)ACTION_CATEGORY_VIEW, (Integer)DbgArb.getInteger(713), (ArrayResourceBundle)DbgArb.getInstance(), (int)242, null, (boolean)false);
        actionViewStack.addController((Controller)this);
        actionViewSmart = IdeAction.get((int)VIEW_SMART_CMD_ID, null, (String)DbgArb.getString(0), (String)ACTION_CATEGORY_VIEW, (Integer)DbgArb.getInteger(809), (ArrayResourceBundle)DbgArb.getInstance(), (int)695, null, (boolean)false);
        actionViewSmart.addController((Controller)this);
        actionViewLocals = IdeAction.get((int)VIEW_LOCALS_CMD_ID, null, (String)DbgArb.getString(311), (String)ACTION_CATEGORY_VIEW, (Integer)DbgArb.getInteger(398), (Icon)OracleIcons.getIcon((String)"field.png"), null, (boolean)false);
        actionViewLocals.addController((Controller)this);
        actionViewWatches = IdeAction.get((int)VIEW_WATCHES_CMD_ID, null, (String)DbgArb.getString(508), (String)ACTION_CATEGORY_VIEW, (Integer)DbgArb.getInteger(702), (ArrayResourceBundle)DbgArb.getInstance(), (int)942, null, (boolean)false);
        actionViewWatches.addController((Controller)this);
        actionViewClasses = IdeAction.get((int)VIEW_CLASSES_CMD_ID, null, (String)DbgArb.getString(504), (String)ACTION_CATEGORY_VIEW, (Integer)DbgArb.getInteger(557), (Icon)OracleIcons.getIcon((String)"class.png"), null, (boolean)false);
        actionViewClasses.addController((Controller)this);
        actionViewMonitors = IdeAction.get((int)VIEW_MONITORS_CMD_ID, null, (String)DbgArb.getString(749), (String)ACTION_CATEGORY_VIEW, (Integer)DbgArb.getInteger(909), (ArrayResourceBundle)DbgArb.getInstance(), (int)649, null, (boolean)false);
        actionViewMonitors.addController((Controller)this);
        actionViewLog = IdeAction.get((int)VIEW_LOG_CMD_ID, null, (String)DbgArb.getString(346), (String)ACTION_CATEGORY_VIEW, (Integer)DbgArb.getInteger(138), (Icon)OracleIcons.getIcon((String)"log.png"), null, (boolean)false);
        actionViewLog.addController((Controller)this);
        viewDebuggerActions.add(actionViewBreakpoints);
        viewDebuggerActions.add(actionViewStack);
        viewDebuggerActions.add(actionViewSmart);
        viewDebuggerActions.add(actionViewLocals);
        viewDebuggerActions.add(actionViewWatches);
        viewDebuggerActions.add(actionViewLog);
        if (!Product.isRaptor()) {
            viewDebuggerActions.add(actionViewThreads);
            viewDebuggerActions.add(actionViewClasses);
            viewDebuggerActions.add(actionViewMonitors);
        }
        Collections.sort(viewDebuggerActions, new 8());
        actionCodeEditorGutterToggleBreakpoint = IdeAction.get((int)CODE_EDITOR_GUTTER_TOGGLEBREAKPOINT_CMD_ID, null, (String)DbgArb.getString(488), (String)category, (Integer)DbgArb.getInteger(430), (ArrayResourceBundle)DbgArb.getInstance(), (int)562, null, (boolean)false);
        actionCodeEditorGutterToggleBreakpoint.addController((Controller)this);
        actionCodeEditorToggleWatchpoint = IdeAction.get((int)CODE_EDITOR_GUTTER_TOGGLEWATCHPOINT_CMD_ID, null, (String)DbgArb.getString(493), (String)category, (Integer)DbgArb.getInteger(382), (ArrayResourceBundle)DbgArb.getInstance(), (int)734, null, (boolean)false);
        actionCodeEditorToggleWatchpoint.addController((Controller)this);
        actionCodeEditorGutterEnableBreakpoint = IdeAction.get((int)CODE_EDITOR_GUTTER_ENABLEBREAKPOINT_CMD_ID, null, (String)DbgArb.getString(701), (String)category, (Integer)DbgArb.getInteger(303), (ArrayResourceBundle)DbgArb.getInstance(), (int)691, null, (boolean)false);
        actionCodeEditorGutterEnableBreakpoint.addController((Controller)this);
        actionCodeEditorGutterDisableBreakpoint = IdeAction.get((int)CODE_EDITOR_GUTTER_DISABLEBREAKPOINT_CMD_ID, null, (String)DbgArb.getString(569), (String)category, (Integer)DbgArb.getInteger(895), (ArrayResourceBundle)DbgArb.getInstance(), (int)172, null, (boolean)false);
        actionCodeEditorGutterDisableBreakpoint.addController((Controller)this);
        actionCodeEditorGutterEditBreakpoint = IdeAction.get((int)CODE_EDITOR_GUTTER_EDITBREAKPOINT_CMD_ID, null, (String)DbgArb.getString(362), (String)category, (Integer)DbgArb.getInteger(668), (ArrayResourceBundle)DbgArb.getInstance(), (int)353, null, (boolean)false);
        actionCodeEditorGutterEditBreakpoint.addController((Controller)this);
        actionCodeEditorWatch = IdeAction.get((int)CODE_EDITOR_WATCH_CMD_ID, null, (String)DbgArb.getString(46), (String)category, (Integer)DbgArb.getInteger(199), (ArrayResourceBundle)DbgArb.getInstance(), (int)68, null, (boolean)false);
        actionCodeEditorWatch.addController((Controller)this);
        actionCodeEditorInspect = IdeAction.get((int)CODE_EDITOR_INSPECT_CMD_ID, null, (String)DbgArb.getString(506), (String)category, (Integer)DbgArb.getInteger(436), (ArrayResourceBundle)DbgArb.getInstance(), (int)302, null, (boolean)false);
        actionCodeEditorInspect.addController((Controller)this);
        actionStructureCreateWatchpoint = IdeAction.get((int)STRUCTURE_CREATEWATCHPOINT_CMD_ID, null, (String)DbgArb.getString(962), (String)category, (Integer)DbgArb.getInteger(288), (ArrayResourceBundle)DbgArb.getInstance(), (int)922, null, (boolean)false);
        actionStructureCreateWatchpoint.addController((Controller)this);
        actionMRUConfigurationMenuDebug = IdeAction.get((int)DEBUG_CMD_MRU_CONFIGURATION_ID, null, (String)RunMgrArb.getString(33), (String)category, null, null, null, null, (boolean)false);
        actionMRUConfigurationMenuDebug.putValue("NoCtxName", (Object)RunArb.getString(8));
        actionMRUConfigurationMenuDebug.putValue("Radio", (Object)Boolean.TRUE);
        actionMRUConfigurationMenuDebug.addController((Controller)this);
    }

    void makeDebuggingListenerActions() {
        if (actionNavigatorStopListening != null) {
            return;
        }
        actionNavigatorStopListening = IdeAction.get((int)NAVIGATOR_STOPLISTENING_CMD_ID, null, (String)DbgArb.getString(673), null, (Integer)DbgArb.getInteger(576), (ArrayResourceBundle)DbgArb.getInstance(), (int)296, null, (boolean)false);
        actionNavigatorStopListening.addController((Controller)this);
    }

    private void makeDebuggingProcessActions() {
        if (actionNavigatorDetachDebugger != null) {
            return;
        }
        actionNavigatorDetachDebugger = IdeAction.get((int)NAVIGATOR_DETACHDEBUGGER_CMD_ID, null, (String)DbgArb.getString(291), null, (Integer)DbgArb.getInteger(473), (ArrayResourceBundle)DbgArb.getInstance(), (int)409, null, (boolean)false);
        actionNavigatorDetachDebugger.addController((Controller)this);
        actionLogWindowCancelDebugConnection = IdeAction.get((int)LOG_WINDOW_CANCEL_DEBUG_CONNECTION_CMD_ID, null, (String)DbgArb.getString(312), null, (Integer)DbgArb.getInteger(847), (ArrayResourceBundle)IdeArb.getInstance(), (int)343, null, (boolean)false);
        actionLogWindowCancelDebugConnection.addController((Controller)this);
        actionLogWindowShowIP = IdeAction.get((int)LOG_WINDOW_SHOWIP_CMD_ID, null, (String)DbgArb.getString(188), null, (Integer)DbgArb.getInteger(799), (ArrayResourceBundle)DbgArb.getInstance(), (int)12, null, (boolean)false);
        actionLogWindowShowIP.addController((Controller)this);
        actionLogWindowResume = IdeAction.get((int)LOG_WINDOW_RESUME_CMD_ID, null, (String)DbgArb.getString(78), null, (Integer)DbgArb.getInteger(79), (ArrayResourceBundle)DbgArb.getInstance(), (int)99, null, (boolean)false);
        actionLogWindowResume.addController((Controller)this);
        actionLogWindowStepOver = IdeAction.get((int)LOG_WINDOW_STEPOVER_CMD_ID, null, (String)DbgArb.getString(528), null, (Integer)DbgArb.getInteger(309), (ArrayResourceBundle)DbgArb.getInstance(), (int)294, null, (boolean)false);
        actionLogWindowStepOver.addController((Controller)this);
        actionLogWindowStepInto = IdeAction.get((int)LOG_WINDOW_STEPINTO_CMD_ID, null, (String)DbgArb.getString(225), null, (Integer)DbgArb.getInteger(588), (ArrayResourceBundle)DbgArb.getInstance(), (int)397, null, (boolean)false);
        actionLogWindowStepInto.addController((Controller)this);
        actionLogWindowStepOut = IdeAction.get((int)LOG_WINDOW_STEPOUT_CMD_ID, null, (String)DbgArb.getString(443), null, (Integer)DbgArb.getInteger(647), (ArrayResourceBundle)DbgArb.getInstance(), (int)133, null, (boolean)false);
        actionLogWindowStepOut.addController((Controller)this);
        actionLogWindowStepToEndOfMethod = IdeAction.get((int)LOG_WINDOW_STEPTOENDOFMETHOD_CMD_ID, null, (String)DbgArb.getString(420), null, (Integer)DbgArb.getInteger(510), (ArrayResourceBundle)DbgArb.getInstance(), (int)229, null, (boolean)false);
        actionLogWindowStepToEndOfMethod.addController((Controller)this);
        actionLogWindowStepOverBC = IdeAction.get((int)LOG_WINDOW_STEPOVERBC_CMD_ID, null, (String)DbgArb.getString(313), null, (Integer)DbgArb.getInteger(153), (ArrayResourceBundle)DbgArb.getInstance(), (int)416, null, (boolean)false);
        actionLogWindowStepOverBC.addController((Controller)this);
        actionLogWindowStepIntoBC = IdeAction.get((int)LOG_WINDOW_STEPINTOBC_CMD_ID, null, (String)DbgArb.getString(289), null, (Integer)DbgArb.getInteger(716), (ArrayResourceBundle)DbgArb.getInstance(), (int)340, null, (boolean)false);
        actionLogWindowStepIntoBC.addController((Controller)this);
        actionLogWindowPause = IdeAction.get((int)LOG_WINDOW_PAUSE_CMD_ID, null, (String)DbgArb.getString(566), null, (Integer)DbgArb.getInteger(912), (ArrayResourceBundle)DbgArb.getInstance(), (int)213, null, (boolean)false);
        actionLogWindowPause.addController((Controller)this);
        actionLogWindowReset = IdeAction.get((int)LOG_WINDOW_RESET_CMD_ID, null, (String)IdeArb.getString((int)92), null, (Integer)IdeArb.getInteger((int)424), (ArrayResourceBundle)IdeArb.getInstance(), (int)343, null, (boolean)false);
        actionLogWindowReset.addController((Controller)this);
        actionLogWindowGC = IdeAction.get((int)LOG_WINDOW_GC_CMD_ID, null, (String)DbgArb.getString(480), null, (Integer)DbgArb.getInteger(720), (ArrayResourceBundle)DbgArb.getInstance(), (int)421, null, (boolean)false);
        actionLogWindowGC.addController((Controller)this);
    }

    private void addViewDebuggerSubMenu() {
        Menubar menubar = Ide.getMenubar();
        viewDebuggerSubMenu = menubar.createSubMenu(DbgArb.getString(42), DbgArb.getInteger(536), JDeveloperMenuConstants.WEIGHT_VIEW_DEBUGGER);
        viewDebuggerSubMenu.addMenuListener(this);
        if (viewDebuggerActions.size() > 0) {
            viewDebuggerSubMenu.add(menubar.createMenuItem((ToggleAction)viewDebuggerActions.get(0)));
        }
        menubar.add((Component)viewDebuggerSubMenu, MenuManager.getJMenu((String)"View"), JDeveloperMenuConstants.SECTION_VIEW_DEBUG_RUN);
    }

    private void declareShortcuts() {
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), "oracle/jdevimpl/runner/debug/accelerators.xml");
    }

    static String getExtensionID() {
        return Product.getProductID();
    }

    private void initializeIDESettings() {
        Preferences preferences = Preferences.getPreferences();
        IdeSettings settings = Ide.getSettings();
        settings.putLegacyData("DebugWindowOptions", (Copyable)DebugWindowSettings.getInstance((PropertyStorage)preferences));
        settings.putLegacyData("BreakpointsWindowOptions", (Copyable)BreakpointsWindowSettings.getInstance((PropertyStorage)preferences));
        settings.putLegacyData("ClassesWindowOptions", (Copyable)ClassesWindowSettings.getInstance((PropertyStorage)preferences));
        settings.putLegacyData("LocalsWindowOptions", (Copyable)LocalsWindowSettings.getInstance((PropertyStorage)preferences));
        settings.putLegacyData("HeapWindowOptions", (Copyable)HeapWindowSettings.getInstance((PropertyStorage)preferences));
        settings.putLegacyData("InspectorWindowOptions", (Copyable)InspectorWindowSettings.getInstance((PropertyStorage)preferences));
        settings.putLegacyData("SmartWindowOptions", (Copyable)SmartWindowSettings.getInstance((PropertyStorage)preferences));
        settings.putLegacyData("StackWindowOptions", (Copyable)StackWindowSettings.getInstance((PropertyStorage)preferences));
        settings.putLegacyData("WatchWindowOptions", (Copyable)WatchWindowSettings.getInstance((PropertyStorage)preferences));
        settings.putLegacyData("ThreadsWindowOptions", (Copyable)ThreadsWindowSettings.getInstance((PropertyStorage)preferences));
        settings.putLegacyData("MonitorsWindowOptions", (Copyable)MonitorsWindowSettings.getInstance((PropertyStorage)preferences));
    }

    private static void registerPanels() {
        Navigable debuggerNavigable = new Navigable(DbgArb.getString(16), DebugWindowSettingsPanel.class);
        Navigable navigable = new Navigable(DbgArb.getString(554), BreakpointsWindowSettingsPanel.class);
        Navigable navigable2 = new Navigable(DbgArb.getString(446), BreakpointsWindowSettingsPanel2.class);
        navigable.addChildNavigable(navigable2);
        debuggerNavigable.addChildNavigable(navigable);
        navigable = new Navigable(DbgArb.getString(374), StackWindowSettingsPanel.class);
        debuggerNavigable.addChildNavigable(navigable);
        navigable = new Navigable(DbgArb.getString(893), SmartWindowSettingsPanel.class);
        debuggerNavigable.addChildNavigable(navigable);
        navigable = new Navigable(DbgArb.getString(816), LocalsWindowSettingsPanel.class);
        debuggerNavigable.addChildNavigable(navigable);
        navigable = new Navigable(DbgArb.getString(774), WatchWindowSettingsPanel.class);
        debuggerNavigable.addChildNavigable(navigable);
        navigable = new Navigable(DbgArb.getString(281), InspectorWindowSettingsPanel.class);
        debuggerNavigable.addChildNavigable(navigable);
        if (!Product.isRaptor()) {
            navigable = new Navigable(DbgArb.getString(23), ThreadsWindowSettingsPanel.class);
            debuggerNavigable.addChildNavigable(navigable);
            navigable = new Navigable(DbgArb.getString(255), ClassesWindowSettingsPanel.class);
            debuggerNavigable.addChildNavigable(navigable);
            navigable = new Navigable(DbgArb.getString(110), MonitorsWindowDataSettingsPanel.class);
            navigable2 = new Navigable(DbgArb.getString(935), MonitorsWindowThreadsSettingsPanel.class);
            navigable.addChildNavigable(navigable2);
            debuggerNavigable.addChildNavigable(navigable);
        }
        IdeSettings.registerUI((Navigable)debuggerNavigable);
        navigable = new Navigable(DbgArb.getString(458), DebugConfigurationPanel.class);
        navigable2 = new Navigable(DbgArb.getString(789), RemoteDebugSettingsPanel.class);
        navigable.addChildNavigable(navigable2);
        Runner.getRunner().addRunConfigurationToolNavigable(navigable);
    }

    private void activeProjectChanged() {
        if (this.activeWorkspace != null) {
            this.activeWorkspace.detach((Observer)this);
        }
        if (this.activeProject != null) {
            this.activeProject.detach((Observer)this);
        }
        Workspace prevWorkspace = this.activeWorkspace;
        Project prevProject = this.activeProject;
        this.activeWorkspace = Ide.getActiveWorkspace();
        this.activeProject = Ide.getActiveProject();
        if (this.activeWorkspace != null) {
            this.activeWorkspace.attach((Observer)this);
        }
        if (this.activeProject != null) {
            this.activeProject.attach((Observer)this);
        }
        this.updateRunConfigurationList();
        this.checkCommandsBecauseActiveProjectChanged();
        if (this.activeWorkspace != prevWorkspace || this.activeProject != prevProject || this.activeBreakpoints.length == 0) {
            Breakpoint.hideBreakpointIcons(this.activeBreakpoints);
            this.activeBreakpoints = Breakpoint.getBreakpoints(this.activeWorkspace, this.activeProject);
            Breakpoint.showBreakpointIcons(this.activeBreakpoints);
            if (this.breakpointsWindow != null) {
                this.breakpointsWindow.setBreakpoints(this.activeWorkspace, this.activeProject, this.activeBreakpoints);
            }
        }
    }

    private void debugWindowSettingsChanged() {
        if (debugMenuBuilt) {
            if (this.dbgSettings.isContextMenusOnMainMenu()) {
                if (!debugContextSubMenuAdded) {
                    runMenu.add(debugContextSubMenu);
                    debugContextSubMenuAdded = true;
                }
            } else if (debugContextSubMenuAdded) {
                runMenu.remove(debugContextSubMenu);
                debugContextSubMenuAdded = false;
            }
        }
        this.updateToolTipProvider();
        boolean isShowToolbarInLogWindow = this.dbgSettings.isShowToolbarInLogWindow();
        if (this.debuggingProcessesConnecting != null) {
            int i = this.debuggingProcessesConnecting.size() - 1;
            while (i >= 0) {
                DebuggingProcess debuggingProcess = this.debuggingProcessesConnecting.get(i);
                debuggingProcess.updateToolbarVisibility(isShowToolbarInLogWindow);
                --i;
            }
        }
        if (this.debuggingProcesses != null) {
            int i = this.debuggingProcesses.size() - 1;
            while (i >= 0) {
                DebuggingProcess debuggingProcess = this.debuggingProcesses.get(i);
                debuggingProcess.updateToolbarVisibility(isShowToolbarInLogWindow);
                --i;
            }
        }
    }

    void tracingChanged() {
        9 runWhilePaused = new 9();
        10 runOnceLater = new 10();
        this.pauseAndInvoke(runWhilePaused, runOnceLater);
        ClassesWindow classesWindow = this.getClassesWindow(false);
        if (classesWindow != null) {
            classesWindow.tracingChanged();
        }
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    @Override
    public void menuDeselected(MenuEvent e) {
    }

    @Override
    public void menuSelected(MenuEvent e) {
        Object source = e.getSource();
        if (source == runMenu) {
            runMenu.removeMenuListener(this);
            this.buildDebugMenu();
        } else if (source == viewDebuggerSubMenu) {
            viewDebuggerSubMenu.removeMenuListener(this);
            this.buildViewDebuggerSubMenu();
        } else if (source == debugContextSubMenu) {
            debugContextSubMenu.removeMenuListener(this);
            JDebugger.buildDebugContextSubMenu();
        }
    }

    private void buildDebugMenu() {
        if (!debugMenuBuilt) {
            Menubar menubar = Ide.getMenubar();
            Context[] context = new Context[]{Ide.getMainWindow().getLastActiveView().getContext()};
            if (!Product.isRaptor()) {
                this.updateIfNotVisible(actionDebugProject, context);
                menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugProject, JDeveloperMenuConstants.WEIGHT_DEBUG_DEBUG_PROJECT), runMenu, JDeveloperMenuConstants.SECTION_DEBUG_DEBUG_RUN);
            }
            this.updateIfNotVisible(actionDebugSelection, context);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugSelection, JDeveloperMenuConstants.WEIGHT_DEBUG_DEBUG_FILE), runMenu, JDeveloperMenuConstants.SECTION_DEBUG_DEBUG_RUN);
            this.updateIfNotVisible(actionDebugToggleBreakpoint, context);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugToggleBreakpoint, JDeveloperMenuConstants.WEIGHT_DEBUG_TOGGLE_BREAKPOINT), runMenu, JDeveloperMenuConstants.SECTION_DEBUG_BREAKPOINT);
            this.updateIfNotVisible(actionDebugPause, context);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugPause, JDeveloperMenuConstants.WEIGHT_DEBUG_PAUSE), runMenu, JDeveloperMenuConstants.SECTION_DEBUG_PAUSE_RESUME);
            this.updateIfNotVisible(actionDebugResume, context);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugResume, JDeveloperMenuConstants.WEIGHT_DEBUG_RESUME), runMenu, JDeveloperMenuConstants.SECTION_DEBUG_PAUSE_RESUME);
            this.updateIfNotVisible(actionDebugDetach, context);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugDetach, JDeveloperMenuConstants.WEIGHT_DEBUG_DETACH), runMenu, JDeveloperMenuConstants.SECTION_DEBUG_PAUSE_RESUME);
            this.updateIfNotVisible(actionDebugStepOver, context);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugStepOver, JDeveloperMenuConstants.WEIGHT_DEBUG_STEP_OVER), runMenu, JDeveloperMenuConstants.SECTION_DEBUG_STEP);
            this.updateIfNotVisible(actionDebugStepInto, context);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugStepInto, JDeveloperMenuConstants.WEIGHT_DEBUG_STEP_INTO), runMenu, JDeveloperMenuConstants.SECTION_DEBUG_STEP);
            this.updateIfNotVisible(actionDebugStepOut, context);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugStepOut, JDeveloperMenuConstants.WEIGHT_DEBUG_STEP_OUT), runMenu, JDeveloperMenuConstants.SECTION_DEBUG_STEP);
            this.updateIfNotVisible(actionDebugStepToEndOfMethod, context);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugStepToEndOfMethod, JDeveloperMenuConstants.WEIGHT_DEBUG_STEP_TO_END_OF_METHOD), runMenu, JDeveloperMenuConstants.SECTION_DEBUG_STEP);
            this.updateIfNotVisible(actionDebugContinueStep, context);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugContinueStep, JDeveloperMenuConstants.WEIGHT_DEBUG_CONTINUE_STEP), runMenu, JDeveloperMenuConstants.SECTION_DEBUG_STEP);
            this.updateIfNotVisible(actionDebugRunToCursor, context);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugRunToCursor, JDeveloperMenuConstants.WEIGHT_DEBUG_RUN_TO_CURSOR), runMenu, JDeveloperMenuConstants.SECTION_DEBUG_PRECISION);
            this.updateIfNotVisible(actionDebugStepIntoMethod, context);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugStepIntoMethod, JDeveloperMenuConstants.WEIGHT_DEBUG_STEP_INTO_METHOD_AT_CURSOR), runMenu, JDeveloperMenuConstants.SECTION_DEBUG_STEP);
            this.updateIfNotVisible(actionDebugSetNextStatement, context);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugSetNextStatement, JDeveloperMenuConstants.WEIGHT_DEBUG_SET_NEXT_STATEMENT), runMenu, JDeveloperMenuConstants.SECTION_DEBUG_PRECISION);
            this.updateIfNotVisible(actionDebugShowIP, context);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugShowIP, JDeveloperMenuConstants.WEIGHT_DEBUG_FIND_EXECUTION_POINT), runMenu, JDeveloperMenuConstants.SECTION_DEBUG_PRECISION);
            this.updateIfNotVisible(actionDebugGC, context);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugGC, JDeveloperMenuConstants.WEIGHT_DEBUG_GARBAGE_COLLECT), runMenu, JDeveloperMenuConstants.SECTION_DEBUG_GARBAGE);
            debugContextSubMenu = menubar.createSubMenu(DbgArb.getString(549), DbgArb.getInteger(202));
            debugContextSubMenu.addMenuListener(this);
            JMenu subMenu = menubar.createSubMenu(DbgArb.getString(913), DbgArb.getInteger(58));
            BreakpointsWindow.addContextMenuToMainMenu(menubar, subMenu);
            debugContextSubMenu.add(subMenu);
            if (this.dbgSettings.isContextMenusOnMainMenu()) {
                menubar.add((Component)debugContextSubMenu, runMenu, JDeveloperMenuConstants.SECTION_DEBUG_GARBAGE);
                debugContextSubMenuAdded = true;
            }
            debugMenuBuilt = true;
        }
    }

    private void buildViewDebuggerSubMenu() {
        if (!viewDebuggerSubMenuBuilt) {
            Menubar menubar = Ide.getMenubar();
            Context context = Ide.getMainWindow().getLastActiveView().getContext();
            int size = viewDebuggerActions.size();
            int i = 1;
            while (i < size) {
                IdeAction action = viewDebuggerActions.get(i);
                this.update(action, context);
                viewDebuggerSubMenu.add(menubar.createMenuItem((ToggleAction)action));
                ++i;
            }
            viewDebuggerSubMenuBuilt = true;
            viewDebuggerActions = null;
        }
    }

    private static void buildDebugContextSubMenu() {
        if (!debugContextSubMenuBuilt) {
            Menubar menubar = Ide.getMenubar();
            JMenu subMenu = menubar.createSubMenu(DbgArb.getString(699), DbgArb.getInteger(672));
            ThreadsWindow.addContextMenuToMainMenu(menubar, subMenu);
            debugContextSubMenu.add(subMenu);
            subMenu = menubar.createSubMenu(DbgArb.getString(523), DbgArb.getInteger(59));
            StackWindow.addContextMenuToMainMenu(menubar, subMenu);
            debugContextSubMenu.add(subMenu);
            subMenu = menubar.createSubMenu(DbgArb.getString(337), DbgArb.getInteger(591));
            SmartWindow.addContextMenuToMainMenu(menubar, subMenu);
            debugContextSubMenu.add(subMenu);
            subMenu = menubar.createSubMenu(DbgArb.getString(310), DbgArb.getInteger(4));
            LocalsWindow.addContextMenuToMainMenu(menubar, subMenu);
            debugContextSubMenu.add(subMenu);
            subMenu = menubar.createSubMenu(DbgArb.getString(321), DbgArb.getInteger(956));
            WatchWindow.addContextMenuToMainMenu(menubar, subMenu);
            debugContextSubMenu.add(subMenu);
            subMenu = menubar.createSubMenu(DbgArb.getString(949), DbgArb.getInteger(256));
            InspectorWindow.addContextMenuToMainMenu(menubar, subMenu);
            debugContextSubMenu.add(subMenu);
            subMenu = menubar.createSubMenu(DbgArb.getString(360), DbgArb.getInteger(413));
            ClassesWindow.addContextMenuToMainMenu(menubar, subMenu);
            debugContextSubMenu.add(subMenu);
            subMenu = menubar.createSubMenu(DbgArb.getString(410), DbgArb.getInteger(908));
            MonitorsWindow.addContextMenuToMainMenu(menubar, subMenu);
            debugContextSubMenu.add(subMenu);
            debugContextSubMenuBuilt = true;
        }
    }

    private Project getMRUProject() {
        Workspace currentWorkspace = Ide.getActiveWorkspace();
        if (currentWorkspace == null) {
            return null;
        }
        HashStructure userProps = currentWorkspace.getUserPropertiesOnly();
        if (userProps != null) {
            Node node;
            String projectShortName = userProps.getString(JRunner.MRU_CONFIG_PROJECT_SHORT_NAME);
            String configName = userProps.getString(JRunner.MRU_CONFIG_NAME);
            String projectRelativeUrl = userProps.getString(JRunner.MRU_CONFIG_PROJECT_RELATIVE_URL);
            if (projectShortName != null && configName != null && projectRelativeUrl != null && (node = NodeFactory.find((URL)URLFactory.newURL((URL)URLFileSystem.getParent((URL)currentWorkspace.getURL()), (String)projectRelativeUrl))) instanceof Project) {
                return (Project)node;
            }
        }
        return null;
    }

    private void updateDebugProjectAction(IdeAction action) {
        String name;
        action.setEnabled(this.canStartProcess(null));
        Project mruProject = this.getMRUProject();
        if (mruProject != null) {
            String projectShortLabel = mruProject.getShortLabel();
            name = DbgArb.format(664, projectShortLabel);
        } else {
            name = DbgArb.getString(667);
        }
        action.putValue("Name", (Object)name);
    }

    private void updateDebugSelectionAction(IdeAction action, Context context) {
        String name;
        Project project = context.getProject();
        if (project != null && RunConfiguration.getInstance((PropertyStorage)project).isRemoteDebuggingProfiling()) {
            action.setEnabled(false);
            action.putValue("Name", (Object)DbgArb.getString(43));
            return;
        }
        Node node = RunProcess.getContextNodeForRun((Context)context);
        if (node instanceof Project) {
            action.setEnabled(false);
            action.putValue("Name", (Object)DbgArb.getString(43));
            return;
        }
        action.setEnabled(this.canStartProcess(context));
        if (node != null && Runner.getRunner().couldNodeBeRunnable(node, DebuggingProcess.starterFactorySubClass)) {
            String nodeShortLabel = node.getShortLabel();
            name = DbgArb.format(41, nodeShortLabel);
        } else {
            name = DbgArb.getString(43);
        }
        action.putValue("Name", (Object)name);
    }

    private void updateContextMenuDebugAction(IdeAction action, Context context) {
        Project project;
        boolean enabled = Runner.getRunner().enableRunDebugActions(context, DebuggingProcess.starterFactorySubClass) && this.canStartProcess(context);
        action.setEnabled(enabled);
        if (enabled && (project = context.getProject()) != null && RunConfiguration.getInstance((PropertyStorage)project).isRemoteDebuggingProfiling()) {
            action.putValue("Name", (Object)DbgArb.getString(730));
            return;
        }
        action.putValue("Name", (Object)DbgArb.getString(358));
    }

    private void updateDebugActions() {
        Context[] context = new Context[1];
        this.updateIfVisible(actionDebugProject, context);
        this.updateIfVisible(actionDebugSelection, context);
    }

    private String getMRUMenuName() {
        HashStructure userProps;
        Project lastMRUProject = null;
        String shortMruConfigurationLabel = null;
        Workspace currentWorkspace = Ide.getActiveWorkspace();
        if (currentWorkspace != null && (userProps = currentWorkspace.getUserPropertiesOnly()) != null) {
            URL projUrl;
            String projectShortName = userProps.getString(JRunner.MRU_CONFIG_PROJECT_SHORT_NAME);
            String projectRelativeUrl = userProps.getString(JRunner.MRU_CONFIG_PROJECT_RELATIVE_URL);
            String configName = userProps.getString(JRunner.MRU_CONFIG_NAME);
            if (projectShortName != null && projectRelativeUrl != null && configName != null && (projUrl = URLFactory.newURL((URL)URLFileSystem.getParent((URL)currentWorkspace.getURL()), (String)projectRelativeUrl)) != null && URLFileSystem.exists((URL)projUrl)) {
                StringBuilder sb = new StringBuilder();
                sb.append(projectShortName);
                sb.append(":");
                sb.append(configName);
                return sb.toString();
            }
        }
        if (lastMRUProject == null) {
            lastMRUProject = Ide.getActiveProject();
        }
        if (lastMRUProject != null) {
            RunConfiguration activeConfig = RunConfigurations.getActiveRunConfiguration(lastMRUProject);
            if (activeConfig != null) {
                StringBuilder sb = new StringBuilder();
                sb.append(lastMRUProject.getShortLabel());
                sb.append(":");
                sb.append(activeConfig.getName());
                shortMruConfigurationLabel = sb.toString();
            } else {
                shortMruConfigurationLabel = RunMgrArb.getString(33);
            }
        } else {
            shortMruConfigurationLabel = RunMgrArb.getString(33);
        }
        return shortMruConfigurationLabel;
    }

    private void updateDebugMRUConfigurationAction(IdeAction action) {
        String mruMenuLabel = this.getMRUMenuName();
        action.setState(true);
        if (RunMgrArb.getString(33).equals(mruMenuLabel)) {
            action.setEnabled(false);
        } else {
            action.setName(mruMenuLabel);
            action.setEnabled(true);
        }
    }

    private boolean isActionVisible(IdeAction action) {
        int cmdId = action.getCommandId();
        return cmdId == DEBUG_PROJECT_CMD_ID || cmdId == DEBUG_CMD_MRU_CONFIGURATION_ID || cmdId == DEBUG_RESUME_CMD_ID || cmdId == DEBUG_STEPOVER_CMD_ID || cmdId == DEBUG_STEPINTO_CMD_ID || cmdId == DEBUG_STEPOUT_CMD_ID || cmdId == DEBUG_STEPTOENDOFMETHOD_CMD_ID || cmdId == DEBUG_PAUSE_CMD_ID || cmdId == DEBUG_RESET_CMD_ID || cmdId == DEBUG_GC_CMD_ID || cmdId == LOG_WINDOW_CANCEL_DEBUG_CONNECTION_CMD_ID || cmdId == LOG_WINDOW_SHOWIP_CMD_ID || cmdId == LOG_WINDOW_RESUME_CMD_ID || cmdId == LOG_WINDOW_STEPOVER_CMD_ID || cmdId == LOG_WINDOW_STEPINTO_CMD_ID || cmdId == LOG_WINDOW_STEPOUT_CMD_ID || cmdId == LOG_WINDOW_STEPTOENDOFMETHOD_CMD_ID || cmdId == LOG_WINDOW_STEPOVERBC_CMD_ID || cmdId == LOG_WINDOW_STEPINTOBC_CMD_ID || cmdId == LOG_WINDOW_PAUSE_CMD_ID || cmdId == LOG_WINDOW_RESET_CMD_ID || cmdId == LOG_WINDOW_GC_CMD_ID;
    }

    private void updateIfVisible(IdeAction action, Context[] context) {
        if (this.isActionVisible(action)) {
            if (context[0] == null) {
                context[0] = Ide.getMainWindow().getLastActiveView().getContext();
            }
            this.update(action, context[0]);
        }
    }

    private void updateIfNotVisible(IdeAction action, Context[] context) {
        if (!this.isActionVisible(action)) {
            if (context[0] == null) {
                context[0] = Ide.getMainWindow().getLastActiveView().getContext();
            }
            this.update(action, context[0]);
        }
    }

    private void checkCommandsBecauseActiveProjectChanged() {
        this.updateDebugActions();
    }

    private void checkCommandsBecauseActiveViewChanged() {
        this.updateDebugActions();
        Context[] context = new Context[1];
        this.updateIfVisible(actionDebugRunToCursor, context);
        this.updateIfVisible(actionDebugStepIntoMethod, context);
        this.updateIfVisible(actionDebugSetNextStatement, context);
        this.checkCommandsForTopLogPage();
    }

    private void checkCommandsBecauseViewSelectionChanged() {
        this.updateDebugActions();
    }

    private void checkCommandsBecauseCursorMoved() {
        if (this.activeDebuggingProcess != null) {
            Context[] context = new Context[1];
            this.updateIfVisible(actionDebugRunToCursor, context);
            this.updateIfVisible(actionDebugStepIntoMethod, context);
            this.updateIfVisible(actionDebugSetNextStatement, context);
        }
    }

    private boolean shouldProvideToolTip() {
        return this.duringClassRedefinition == 0 && this.activeDebuggingProcess != null && this.activeDebuggingProcess.isStopped() && this.dbgSettings.isShowToolTipInCodeEditor();
    }

    private void updateToolTipProvider() {
        block5: {
            boolean should = this.shouldProvideToolTip();
            if (this.isToolTipProvider == should) break block5;
            this.isToolTipProvider = should;
            CodeEditor[] ceditors = SourceIcon.getOpenCodeEditors();
            if (this.isToolTipProvider) {
                int i = ceditors.length - 1;
                while (i >= 0) {
                    ceditors[i].addCEToolTipProvider((CEToolTipProvider)this);
                    --i;
                }
            } else {
                if (this.toolTipEvaluator != null) {
                    this.toolTipEvaluator.clearEvaluator();
                }
                int i = ceditors.length - 1;
                while (i >= 0) {
                    ceditors[i].removeCEToolTipProvider((CEToolTipProvider)this);
                    --i;
                }
            }
        }
    }

    private void checkCommandsBecauseActiveDebuggingProcessChanged() {
        this.updateToolTipProvider();
        Context[] context = new Context[1];
        this.updateIfVisible(actionDebugPause, context);
        this.updateIfVisible(actionDebugResume, context);
        this.updateIfVisible(actionDebugDetach, context);
        this.updateIfVisible(actionDebugReset, context);
        this.updateIfVisible(actionDebugStepOver, context);
        this.updateIfVisible(actionDebugStepOverBC, context);
        this.updateIfVisible(actionDebugStepInto, context);
        this.updateIfVisible(actionDebugStepIntoBC, context);
        this.updateIfVisible(actionDebugStepOut, context);
        this.updateIfVisible(actionDebugStepToEndOfMethod, context);
        this.updateIfVisible(actionDebugContinueStep, context);
        this.updateIfVisible(actionDebugRunToCursor, context);
        this.updateIfVisible(actionDebugStepIntoMethod, context);
        this.updateIfVisible(actionDebugSetNextStatement, context);
        this.updateIfVisible(actionDebugShowIP, context);
        this.updateIfVisible(actionDebugGC, context);
    }

    void checkCommandsBecauseDebuggingProcessStateChanged(DebuggingProcess debuggingProcess) {
        if (debuggingProcess == this.activeDebuggingProcess) {
            this.updateToolTipProvider();
            Context[] context = new Context[1];
            this.updateIfVisible(actionDebugPause, context);
            this.updateIfVisible(actionDebugResume, context);
            this.updateIfVisible(actionDebugDetach, context);
            this.updateIfVisible(actionDebugReset, context);
            this.updateIfVisible(actionDebugStepOver, context);
            this.updateIfVisible(actionDebugStepOverBC, context);
            this.updateIfVisible(actionDebugStepInto, context);
            this.updateIfVisible(actionDebugStepIntoBC, context);
            this.updateIfVisible(actionDebugStepOut, context);
            this.updateIfVisible(actionDebugStepToEndOfMethod, context);
            this.updateIfVisible(actionDebugContinueStep, context);
            this.updateIfVisible(actionDebugRunToCursor, context);
            this.updateIfVisible(actionDebugStepIntoMethod, context);
            this.updateIfVisible(actionDebugSetNextStatement, context);
            this.updateIfVisible(actionDebugShowIP, context);
            this.updateIfVisible(actionDebugGC, context);
        }
        this.checkCommandsForTopLogPage();
    }

    private void checkCommandsForTopLogPage() {
        LogPage logPage = LogManager.getIdeLogWindow().getPage();
        if (logPage instanceof RunLogPage) {
            DebuggingProcess debuggingProcess;
            Context[] context = new Context[]{logPage.getLogPageView().getContext()};
            DebuggingProcess connectingDebuggingProcess = this.findDebuggingProcess((RunLogPage)logPage, true);
            if (connectingDebuggingProcess != null) {
                this.updateIfVisible(actionLogWindowCancelDebugConnection, context);
            }
            if ((debuggingProcess = this.findDebuggingProcess((RunLogPage)logPage, false)) != null) {
                this.updateIfVisible(actionLogWindowShowIP, context);
                this.updateIfVisible(actionLogWindowResume, context);
                this.updateIfVisible(actionLogWindowStepOver, context);
                this.updateIfVisible(actionLogWindowStepInto, context);
                this.updateIfVisible(actionLogWindowStepOut, context);
                this.updateIfVisible(actionLogWindowStepToEndOfMethod, context);
                this.updateIfVisible(actionLogWindowStepOverBC, context);
                this.updateIfVisible(actionLogWindowStepIntoBC, context);
                this.updateIfVisible(actionLogWindowPause, context);
                this.updateIfVisible(actionLogWindowReset, context);
                this.updateIfVisible(actionLogWindowGC, context);
            }
        }
    }

    private void checkCommandsBecauseTracingChanged() {
        Context[] context = new Context[1];
        this.updateIfVisible(actionDebugStepOver, context);
        this.updateIfVisible(actionDebugStepOverBC, context);
        this.updateIfVisible(actionDebugStepInto, context);
        this.updateIfVisible(actionDebugStepIntoBC, context);
        this.updateIfVisible(actionDebugStepToEndOfMethod, context);
        this.checkCommandsForTopLogPage();
    }

    private boolean canStartProcess(Context context) {
        Node node;
        Compiler compiler = Compiler.getCompiler();
        if (compiler != null && compiler.isBusy(null)) {
            return false;
        }
        if (context != null && (node = RunProcess.getContextNodeForRun((Context)context)) instanceof Project && node == context.getProject()) {
            context = null;
        }
        boolean contextOk = false;
        if (context != null) {
            contextOk = this.isContextNodeRunnable(context);
        } else if (this.activeProject != null) {
            contextOk = true;
        } else {
            Context activeContext = new Context(Ide.getMainWindow().getLastActiveView().getContext());
            if (activeContext != null) {
                contextOk = this.isContextNodeRunnable(activeContext);
            }
        }
        return contextOk;
    }

    private boolean isContextNodeRunnable(Context context) {
        Node node = RunProcess.getContextNodeForRun((Context)context);
        return node != null && Runner.getRunner().couldNodeBeRunnable(node, DebuggingProcess.starterFactorySubClass);
    }

    private void startProcess(Context context, boolean updateMruProperties) {
        if (this.debuggingProcesses == null) {
            this.windowManager.installCustomWindows();
        }
        this.extenderManager.newDebugSession(context);
        DebuggingProcess debuggingProcess = this.createDebuggingProcess(context, updateMruProperties);
        debuggingProcess.start();
    }

    private DebuggingProcess createDebuggingProcess(Context context, boolean updateMruProperties) {
        Context context2 = JRunner.prepareProcessContext(context, updateMruProperties);
        DebuggingProcess debuggingProcess = new DebuggingProcess(context2);
        return debuggingProcess;
    }

    private boolean canStopListening(Context context) {
        Element[] selection = context.getSelection();
        if (selection != null && selection.length > 0) {
            int i = selection.length - 1;
            while (i >= 0) {
                Element element = selection[i];
                if (!(element instanceof DebuggingListener)) {
                    return false;
                }
                --i;
            }
            return true;
        }
        return false;
    }

    private void stopListening(Context context) {
        Element[] selection = context.getSelection();
        if (selection != null && selection.length > 0) {
            int i = selection.length - 1;
            while (i >= 0) {
                Element element = selection[i];
                if (element instanceof DebuggingListener) {
                    DebuggingListener debuggingListener = (DebuggingListener)element;
                    debuggingListener.stopListening();
                }
                --i;
            }
        }
    }

    private boolean canDetachDebugger(Context context) {
        Element[] selection = context.getSelection();
        if (selection != null && selection.length > 0) {
            int i = selection.length - 1;
            while (i >= 0) {
                Element element = selection[i];
                if (element instanceof DebuggingProcess) {
                    DebuggingProcess debuggingProcess = (DebuggingProcess)element;
                    if (!debuggingProcess.canDetach()) {
                        return false;
                    }
                } else {
                    return false;
                }
                --i;
            }
            return true;
        }
        return false;
    }

    private void detachDebugger(Context context) {
        Element[] selection = context.getSelection();
        if (selection != null && selection.length > 0) {
            int i = selection.length - 1;
            while (i >= 0) {
                DebuggingProcess debuggingProcess;
                Element element = selection[i];
                if (element instanceof DebuggingProcess && (debuggingProcess = (DebuggingProcess)element).canDetach()) {
                    debuggingProcess.detach();
                }
                --i;
            }
        }
    }

    DockableWindow getOrCreateDebuggerWindow(String windowID) {
        DockableWindow debuggerWindow = this.windowManager.getDebuggerWindow(windowID);
        if (debuggerWindow != null) {
            return debuggerWindow;
        }
        if (windowID.equals("Debugger.BreakpointsWindow")) {
            return this.getBreakpointsWindow(true);
        }
        if (windowID.equals("Debugger.ThreadsWindow")) {
            return this.getThreadsWindow(true);
        }
        if (windowID.equals("Debugger.StackWindow")) {
            return this.getStackWindow(true);
        }
        if (windowID.equals("Debugger.LocalsWindow")) {
            return this.getLocalsWindow(true);
        }
        if (windowID.equals("Debugger.WatchWindow")) {
            return this.getWatchWindow(true);
        }
        if (windowID.equals("Debugger.SmartWindow")) {
            return this.getSmartWindow(true);
        }
        if (windowID.equals("Debugger.HeapWindow")) {
            return this.getHeapWindow(true);
        }
        if (windowID.equals("Debugger.ClassesWindow")) {
            return this.getClassesWindow(true);
        }
        if (windowID.equals("Debugger.MonitorsWindow")) {
            return this.getMonitorsWindow(true);
        }
        if (InspectorWindow.isInspectorWindowId(windowID)) {
            return this.getOrCreateInspectorWindow(windowID);
        }
        return null;
    }

    BreakpointsWindow getBreakpointsWindow(boolean forceCreate) {
        if (this.breakpointsWindow == null && forceCreate) {
            this.breakpointsWindow = new BreakpointsWindow(this.activeWorkspace, this.activeProject, this.activeBreakpoints);
            this.windowManager.addDebuggerWindowProvider(this.breakpointsWindow, false);
        }
        return this.breakpointsWindow;
    }

    ThreadsWindow getThreadsWindow(boolean forceCreate) {
        if (this.threadsWindow == null && forceCreate) {
            this.threadsWindow = new ThreadsWindow();
            this.windowManager.addDebuggerWindowProvider(this.threadsWindow, false);
            if (this.stackWindow != null) {
                this.threadsWindow.setStackWindow(this.stackWindow);
            }
        }
        return this.threadsWindow;
    }

    StackWindow getStackWindow(boolean forceCreate) {
        this.getThreadsWindow(forceCreate);
        if (this.stackWindow == null && forceCreate) {
            this.stackWindow = new StackWindow();
            this.windowManager.addDebuggerWindowProvider(this.stackWindow, false);
            if (this.threadsWindow != null) {
                this.threadsWindow.setStackWindow(this.stackWindow);
            }
            if (this.localsWindow != null) {
                this.stackWindow.setLocalsWindow(this.localsWindow);
            }
            if (this.watchWindow != null) {
                this.stackWindow.setWatchWindow(this.watchWindow);
            }
        }
        return this.stackWindow;
    }

    SmartWindow getSmartWindow(boolean forceCreate) {
        if (this.smartWindow == null && forceCreate) {
            this.smartWindow = new SmartWindow();
            this.windowManager.addDebuggerWindowProvider(this.smartWindow, false);
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.smartWindowCreated(this.smartWindow);
            }
        }
        return this.smartWindow;
    }

    LocalsWindow getLocalsWindow(boolean forceCreate) {
        this.getStackWindow(forceCreate);
        if (this.localsWindow == null && forceCreate) {
            this.localsWindow = new LocalsWindow();
            this.windowManager.addDebuggerWindowProvider(this.localsWindow, false);
            if (this.stackWindow != null) {
                this.stackWindow.setLocalsWindow(this.localsWindow);
            }
        }
        return this.localsWindow;
    }

    WatchWindow getWatchWindow(boolean forceCreate) {
        this.getStackWindow(forceCreate);
        if (this.watchWindow == null && forceCreate) {
            this.watchWindow = new WatchWindow();
            this.windowManager.addDebuggerWindowProvider(this.watchWindow, false);
            if (this.stackWindow != null) {
                this.stackWindow.setWatchWindow(this.watchWindow);
            }
        }
        return this.watchWindow;
    }

    ClassesWindow getClassesWindow(boolean forceCreate) {
        if (this.classesWindow == null && forceCreate) {
            this.classesWindow = new ClassesWindow();
            this.windowManager.addDebuggerWindowProvider(this.classesWindow, false);
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.classesWindowCreated(this.classesWindow);
            }
        }
        return this.classesWindow;
    }

    HeapWindow getHeapWindow(boolean forceCreate) {
        if (this.heapWindow == null && forceCreate) {
            this.heapWindow = new HeapWindow();
            this.windowManager.addDebuggerWindowProvider(this.heapWindow, false);
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.heapWindowCreated(this.heapWindow);
            }
        }
        return this.heapWindow;
    }

    MonitorsWindow getMonitorsWindow(boolean forceCreate) {
        if (this.monitorsWindow == null && forceCreate) {
            this.monitorsWindow = new MonitorsWindow();
            this.windowManager.addDebuggerWindowProvider(this.monitorsWindow, false);
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.monitorsWindowCreated(this.monitorsWindow);
            }
        }
        return this.monitorsWindow;
    }

    public EvaluatorItem addWatch(Object expression) {
        this.viewWatches();
        this.getWatchWindow(true);
        return this.watchWindow.addWatch(expression);
    }

    public boolean removeWatch(EvaluatorItem ei) {
        this.getWatchWindow(true);
        return this.watchWindow.removeWatch(ei);
    }

    public InspectorWindow inspect(Object expression) {
        String windowId = InspectorWindow.getNewInspectorWindowId();
        InspectorWindow inspectorWindow = this.createInspectorWindow(windowId, expression);
        this.addInspectorWindow(inspectorWindow, true);
        return inspectorWindow;
    }

    private void addInspectorWindow(InspectorWindow inspectorWindow, boolean updateLayout) {
        if (this.inspectorWindows == null) {
            this.inspectorWindows = new ArrayList();
        }
        this.inspectorWindows.add(inspectorWindow);
        this.getStackWindow(true);
        this.stackWindow.newInspectorWindow(inspectorWindow);
        if (updateLayout) {
            this.windowManager.installWindow(inspectorWindow.getId());
        }
    }

    private InspectorWindow createInspectorWindow(String windowID, Object expression) {
        InspectorWindow inspectorWindow = new InspectorWindow(windowID, expression);
        this.windowManager.addDebuggerWindowProvider(inspectorWindow, false);
        return inspectorWindow;
    }

    InspectorWindow getOrCreateInspectorWindow(String windowId) {
        if (this.inspectorWindows != null) {
            for (InspectorWindow inspectorWindow : this.inspectorWindows) {
                if (!windowId.equals(inspectorWindow.getId())) continue;
                return inspectorWindow;
            }
        }
        InspectorWindow inspectorWindow = this.createInspectorWindow(windowId, null);
        this.addInspectorWindow(inspectorWindow, false);
        return inspectorWindow;
    }

    void removeInspectorWindow(InspectorWindow inspectorWindow) {
        if (this.inspectorWindows != null) {
            this.inspectorWindows.remove(inspectorWindow);
            inspectorWindow.removeInspector();
        }
    }

    Iterator getInspectorWindows() {
        if (this.inspectorWindows != null) {
            List clone = (List)((ArrayList)this.inspectorWindows).clone();
            return clone.iterator();
        }
        return new ArrayList().iterator();
    }

    DebuggingProcess[] getDebuggingProcessesForBreakpoint(Breakpoint bp) {
        ArrayList<DebuggingProcess> list = new ArrayList<DebuggingProcess>();
        if (this.debuggingProcesses != null) {
            block0: for (DebuggingProcess debuggingProcess : this.debuggingProcesses) {
                List[] breakpoints = Breakpoint.getBreakpoints(debuggingProcess.getWorkspace(), debuggingProcess.getProject());
                int length = breakpoints.length;
                int i = 0;
                while (i < length) {
                    if (breakpoints[i].contains(bp)) {
                        list.add(debuggingProcess);
                        continue block0;
                    }
                    ++i;
                }
            }
        }
        return list.toArray(new DebuggingProcess[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheNewBreakpoints() {
        Boolean bl = this.cacheNewBreakpoints;
        synchronized (bl) {
            this.cacheNewBreakpoints = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushNewBreakpoints() {
        Boolean bl = this.cacheNewBreakpoints;
        synchronized (bl) {
            this.cacheNewBreakpoints = false;
            if (this.cachedNewBreakpoints != null) {
                for (Breakpoint bp : this.cachedNewBreakpoints) {
                    this.addBreakpoint(bp);
                }
                this.cachedNewBreakpoints = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBreakpoint(Breakpoint bp) {
        Boolean bl = this.cacheNewBreakpoints;
        synchronized (bl) {
            if (this.cacheNewBreakpoints.booleanValue()) {
                if (this.cachedNewBreakpoints == null) {
                    this.cachedNewBreakpoints = new ArrayList<Breakpoint>();
                }
                this.cachedNewBreakpoints.add(bp);
                return;
            }
        }
        if (bp != null) {
            if (this.breakpointsWindow != null) {
                this.breakpointsWindow.addNewBreakpoint(bp);
            } else {
                this.addBreakpoint(bp, null);
            }
        }
    }

    void addBreakpoint(Breakpoint bp, Runnable runOnceLater) {
        Breakpoint.addBreakpointToOwner(bp, true);
        bp.putBreakpoint(runOnceLater);
        String classOrPackage1 = null;
        String classOrPackage2 = null;
        int bpType = bp.getType();
        if (bpType == 0) {
            classOrPackage1 = bp.getPackage();
            String file = bp.getFile();
            int dot = file.indexOf(46);
            if (dot != -1) {
                file = file.substring(0, dot);
            }
            classOrPackage2 = classOrPackage1 + "." + file;
        } else if (bpType == 1) {
            String method = bp.getMethod();
            int lastDot = method.lastIndexOf(46);
            if (lastDot != -1) {
                classOrPackage1 = method.substring(0, lastDot);
            }
        } else if (bpType == 7) {
            int iDot;
            int iClass;
            String fqMethodName = bp.getMethod();
            int iSignature = fqMethodName.indexOf("(");
            if (iSignature != -1 && (iClass = fqMethodName.lastIndexOf(" ", iSignature) + 1) != -1 && (iDot = fqMethodName.lastIndexOf(".", iSignature)) != -1) {
                classOrPackage1 = fqMethodName.substring(iClass, iDot);
            }
        } else if (bpType == 4) {
            classOrPackage1 = bp.getClassName();
        }
        if (!(classOrPackage1 == null && classOrPackage2 == null || this.activeDebuggingProcess != null && !this.activeDebuggingProcess.canSetTracing())) {
            DebugConfiguration debugConfiguration = null;
            if (this.activeDebuggingProcess != null) {
                debugConfiguration = this.activeDebuggingProcess.getDebugConfiguration();
            } else if (this.activeProject != null) {
                debugConfiguration = DebugConfiguration.getInstance((PropertyStorage)this.activeProject);
            }
            if (debugConfiguration != null) {
                List tracingIncludeList = debugConfiguration.getTracingIncludeList();
                List tracingExcludeList = debugConfiguration.getTracingExcludeList();
                if (classOrPackage1 != null && !DebugShared.isClassOrPackageDebuggable(classOrPackage1, tracingIncludeList, tracingExcludeList) || classOrPackage2 != null && !DebugShared.isClassOrPackageDebuggable(classOrPackage2, tracingIncludeList, tracingExcludeList)) {
                    RunConfiguration runConfiguration = debugConfiguration.getRunConfiguration();
                    String message = DbgArb.format(376, runConfiguration.getName(), DbgArb.getString(118));
                    message = message + DbgArb.getString(181);
                    if (!runConfiguration.isCustom()) {
                        message = message + DbgArb.format(83, runConfiguration.getName());
                    }
                    message = message + DbgArb.getString(103);
                    String title = DbgArb.getString(700);
                    boolean answer = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)message, (String)title, null);
                    if (answer) {
                        TracingPanel.showTracingDialog(debugConfiguration);
                    }
                }
            }
        }
    }

    void removeBreakpoint(Breakpoint bp) {
        if (bp != null) {
            bp.removeBreakpoint();
            this.updateBreakpointsWindow();
        }
    }

    void updateBreakpointsWindow() {
        if (this.breakpointsWindow != null) {
            this.breakpointsWindow.everythingChanged();
        }
    }

    void updateBreakpointsWindowDescription() {
        if (this.breakpointsWindow != null) {
            this.breakpointsWindow.breakpointDescriptionChanged();
        }
    }

    void updateBreakpointsWindowStatus() {
        if (this.breakpointsWindow != null) {
            this.breakpointsWindow.breakpointStatusChanged();
        }
    }

    void updateBreakpointsWindowInstanceFilters() {
        if (this.breakpointsWindow != null) {
            this.breakpointsWindow.breakpointInstanceFiltersChanged();
        }
    }

    private Breakpoint findBreakpointByIconLocation(CodeEditor codeEditor, int line, Boolean watchpoint) {
        Breakpoint possible = null;
        URL ownerURL = JDebugger.getNewBreakpointOwnerURL(this.activeWorkspace, this.activeProject);
        int length = this.activeBreakpoints.length;
        int i = 0;
        while (i < length) {
            for (Breakpoint bp : this.activeBreakpoints[i]) {
                if (watchpoint != null && (watchpoint == false ? bp.getType() == 6 : bp.getType() != 6) || !bp.matchesIconLocation(codeEditor, line)) continue;
                if (ownerURL == null || URLFileSystem.equals((URL)ownerURL, (URL)bp.getOwnerURL())) {
                    return bp;
                }
                possible = bp;
            }
            ++i;
        }
        return possible;
    }

    private void toggleBreakpoint(Context context, CodeEditor codeEditor, int line) {
        Breakpoint bp = this.findBreakpointByIconLocation(codeEditor, line, Boolean.FALSE);
        if (bp != null) {
            bp.removeBreakpoint();
            this.updateBreakpointsWindow();
        } else {
            this.createBreakpoint(context, line);
        }
    }

    private void createBreakpoint(Context context, int line) {
        URL ownerURL = JDebugger.getNewBreakpointOwnerURL(this.activeWorkspace, this.activeProject);
        Node node = context.getNode();
        if (node != null) {
            Breakpoint bp = null;
            if (JDebugger.usePackageFileLine(context, line)) {
                String pkg = Source.getPackageFromNode(node, context.getProject());
                String file = Source.getFilenameFromNode(node);
                if (pkg != null && file != null && file.length() > 0) {
                    bp = new Breakpoint(ownerURL, 0, pkg, file, line);
                }
            } else {
                String methodName;
                URL url = node.getURL();
                boolean nodeIsBytecodeDisassembly = false;
                BytecodeFileSystemHelper bytecodeHelper = BytecodeFileSystemHelper.getInstance(false);
                if (bytecodeHelper != null && (methodName = BytecodeFileSystemHelper.getMethodName(url)) != null) {
                    nodeIsBytecodeDisassembly = true;
                    int offset = bytecodeHelper.getBytecodeOffsetFromLine(url, line);
                    if (offset != -1) {
                        bp = new Breakpoint(ownerURL, 7, methodName, offset);
                    }
                }
                if (!nodeIsBytecodeDisassembly) {
                    bp = new Breakpoint(ownerURL, 5, url, line);
                }
            }
            this.addBreakpoint(bp);
        }
    }

    Breakpoint findWatchpoint(String className, String fieldName) {
        Breakpoint possible = null;
        URL ownerURL = JDebugger.getNewBreakpointOwnerURL(this.activeWorkspace, this.activeProject);
        int length = this.activeBreakpoints.length;
        int i = 0;
        while (i < length) {
            for (Breakpoint bp : this.activeBreakpoints[i]) {
                if (bp.getType() != 6 || !bp.getClassName().equals(className) || !bp.getFieldName().equals(fieldName)) continue;
                if (ownerURL == null || URLFileSystem.equals((URL)ownerURL, (URL)bp.getOwnerURL())) {
                    return bp;
                }
                possible = bp;
            }
            ++i;
        }
        return possible;
    }

    private void createWatchpoint(String className, String fieldName) {
        URL ownerURL = JDebugger.getNewBreakpointOwnerURL(this.activeWorkspace, this.activeProject);
        this.addBreakpoint(new Breakpoint(ownerURL, 6, className, fieldName, false, true));
    }

    private void toggleWatchpoint(String className, String fieldName) {
        Breakpoint bp = this.findWatchpoint(className, fieldName);
        if (bp != null) {
            bp.removeBreakpoint();
            this.updateBreakpointsWindow();
        } else {
            this.createWatchpoint(className, fieldName);
        }
    }

    static URL getNewBreakpointOwnerURL(Workspace workspace, Project project) {
        String bpScope = BreakpointsWindowSettings.getInstance().getBreakpointScope();
        if (bpScope.equals("workspace") && workspace != null && workspace != Ide.getDefaultWorkspace()) {
            return workspace.getURL();
        }
        if (bpScope.equals("project") && project != null && project != Ide.getDefaultProject()) {
            return project.getURL();
        }
        return null;
    }

    static boolean usePackageFileLine(Context context, int line) {
        Iterator<PackageFileLineCheck> packageFileLineChecks = PackageFileLineChecker.getPackageFileLineChecks();
        while (packageFileLineChecks.hasNext()) {
            if (packageFileLineChecks.next().usePackageFileLine(context, line)) continue;
            return false;
        }
        Node node = context.getNode();
        return node instanceof PackagedSource;
    }

    void breakpointHasBeenPut(Breakpoint bp, DebugBreakpoint dbp) {
        if (this.breakpointForDebugBreakpoint == null) {
            this.breakpointForDebugBreakpoint = new HashMap();
        }
        this.breakpointForDebugBreakpoint.put(dbp, bp);
    }

    void breakpointHasBeenRemoved(DebugBreakpoint dbp) {
        Assert.check((this.breakpointForDebugBreakpoint != null ? 1 : 0) != 0);
        this.breakpointForDebugBreakpoint.remove(dbp);
    }

    void breakpointHasBeenRemoved(Breakpoint bp) {
        this.extenderManager.breakpointDeleted(bp);
    }

    Breakpoint findBreakpoint(DebugBreakpoint dbp) {
        if (this.breakpointForDebugBreakpoint != null) {
            return (Breakpoint)this.breakpointForDebugBreakpoint.get(dbp);
        }
        return null;
    }

    void breakpointChanged(DebugBreakpoint dbp, DebuggingProcess debuggingProcess) {
        Breakpoint bp = this.findBreakpoint(dbp);
        if (bp != null) {
            bp.changed(dbp, debuggingProcess);
            this.updateBreakpointsWindow();
            this.extenderManager.breakpointChanged(debuggingProcess, bp);
        }
    }

    void debuggeeStoppedAtBreakpoint(DebugBreakpoint dbp) {
        Breakpoint bp = this.findBreakpoint(dbp);
        if (bp != null) {
            this.extenderManager.debuggeeStoppedAtBreakpoint(bp);
        }
    }

    boolean canShowBreakpointLocation(Breakpoint bp) {
        return this.extenderManager.canShowBreakpointLocation(bp);
    }

    boolean showBreakpointLocation(Breakpoint bp) {
        return this.extenderManager.showBreakpointLocation(bp);
    }

    void viewBreakpoints() {
        DockUtil.showDockableWindow((DockableView)this.getBreakpointsWindow(true));
    }

    void viewWatches() {
        DockUtil.showDockableWindow((DockableView)this.getWatchWindow(true));
    }

    void viewHeap() {
    }

    void viewMonitors() {
        this.windowManager.installWindow("Debugger.MonitorsWindow");
        DockableWindow dw = this.windowManager.getDebuggerWindow("Debugger.MonitorsWindow");
        DockUtil.showDockableWindow((DockableView)dw);
    }

    private void viewLog() {
        LogPage logPage;
        DebuggingProcess process = this.activeDebuggingProcess;
        if (process != null && (logPage = process.getLogPage()) instanceof RunLogPage) {
            ((RunLogPage)logPage).show();
        }
    }

    void listenerStarted(DebuggingListener debuggingListener) {
        if (this.debuggingListeners == null) {
            this.debuggingListeners = new ArrayList<DebuggingListener>();
        }
        this.debuggingListeners.add(debuggingListener);
    }

    void listenerStopped(DebuggingListener debuggingListener) {
        Assert.check((this.debuggingListeners != null ? 1 : 0) != 0);
        this.debuggingListeners.remove(debuggingListener);
    }

    void debuggingProcessCreated() {
        if (this.firstDebuggingProcessCreated) {
            this.firstDebuggingProcessCreated = false;
            this.makeDebuggingProcessActions();
            this.addSmartDataProvider(new SmartJava());
            this.addToolTipExpressionProvider(new ToolTipJava());
        }
    }

    void debuggingProcessBeforeConnecting(DebuggingProcess debuggingProcess) {
        if (this.debuggingProcessesConnecting == null) {
            this.debuggingProcessesConnecting = new ArrayList<DebuggingProcess>();
        }
        this.debuggingProcessesConnecting.add(debuggingProcess);
        Toolbar toolbar = debuggingProcess.getLogPageToolbar();
        if (toolbar != null) {
            toolbar.add((ToggleAction)actionLogWindowCancelDebugConnection);
            toolbar.validate();
            this.checkCommandsForTopLogPage();
        }
    }

    void debuggingProcessAfterConnecting(DebuggingProcess debuggingProcess) {
        if (this.debuggingProcessesConnecting != null) {
            this.debuggingProcessesConnecting.remove(debuggingProcess);
        }
        debuggingProcess.clearLogPageToolbar();
    }

    void debuggingProcessStarted(DebuggingProcess debuggingProcess) {
        if (this.debuggingProcesses == null) {
            this.debuggingProcesses = new ArrayList<DebuggingProcess>();
        }
        this.debuggingProcesses.add(debuggingProcess);
        Toolbar toolbar = debuggingProcess.getLogPageToolbar();
        if (toolbar != null) {
            this.addNormalButtons(toolbar);
            this.checkCommandsForTopLogPage();
        }
        this.getThreadsWindow(true).getGUI();
        this.getStackWindow(true).getGUI();
    }

    private void addNormalButtons(Toolbar toolbar) {
        toolbar.add((ToggleAction)actionLogWindowShowIP);
        toolbar.add((ToggleAction)actionLogWindowStepOver);
        toolbar.add((ToggleAction)actionLogWindowStepInto);
        toolbar.add((ToggleAction)actionLogWindowStepOut);
        toolbar.add((ToggleAction)actionLogWindowStepToEndOfMethod);
        if (BytecodeFileSystemHelper.getInstance(false) != null) {
            toolbar.add((ToggleAction)actionLogWindowStepOverBC);
            toolbar.add((ToggleAction)actionLogWindowStepIntoBC);
        }
        toolbar.add((ToggleAction)actionLogWindowResume);
        toolbar.add((ToggleAction)actionLogWindowPause);
        toolbar.add((ToggleAction)actionLogWindowReset);
        toolbar.add((ToggleAction)actionLogWindowGC);
        toolbar.validate();
    }

    void addStepBytecodeActions() {
        if (this.debuggingProcesses != null) {
            for (DebuggingProcess debuggingProcess : this.debuggingProcesses) {
                Toolbar toolbar = debuggingProcess.getLogPageToolbar();
                if (toolbar == null) continue;
                toolbar.dispose();
                toolbar.removeAll();
                this.addNormalButtons(toolbar);
            }
            LogPage logPage = LogManager.getIdeLogWindow().getPage();
            if (logPage instanceof RunLogPage) {
                Context[] context = new Context[]{logPage.getLogPageView().getContext()};
                this.updateIfVisible(actionLogWindowStepOverBC, context);
                this.updateIfVisible(actionLogWindowStepIntoBC, context);
            }
        }
    }

    void pauseAndInvoke(RunWhilePaused runWhilePaused, Runnable runOnceLater) {
        DebuggingProcess[] processes = this.debuggingProcesses != null ? this.debuggingProcesses.toArray(new DebuggingProcess[this.debuggingProcesses.size()]) : new DebuggingProcess[]{};
        JDebugger.pauseAndInvoke(processes, runWhilePaused, runOnceLater);
    }

    static void pauseAndInvoke(DebuggingProcess[] processes, RunWhilePaused runWhilePaused, Runnable runOnceLater) {
        int length = processes.length;
        if (length > 0) {
            int[] countDown = new int[]{length};
            11 wrapper = new 11(runWhilePaused, countDown, runOnceLater);
            int i = 0;
            while (i < length) {
                processes[i].runWhilePaused(wrapper);
                ++i;
            }
        } else if (runOnceLater != null) {
            SwingUtilities.invokeLater(runOnceLater);
        }
    }

    DebuggingProcess findDebuggingProcess(DebugVirtualMachine vm) {
        if (this.debuggingProcesses != null) {
            for (DebuggingProcess debuggingProcess : this.debuggingProcesses) {
                if (debuggingProcess.getVM() != vm) continue;
                return debuggingProcess;
            }
        }
        return null;
    }

    DebuggingProcess findDebuggingProcess(RunLogPage runLogPage, boolean connecting) {
        List<DebuggingProcess> list;
        List<DebuggingProcess> list2 = list = connecting ? this.debuggingProcessesConnecting : this.debuggingProcesses;
        if (list != null) {
            for (DebuggingProcess debuggingProcess : list) {
                if (debuggingProcess.getLogPage() != runLogPage) continue;
                return debuggingProcess;
            }
        }
        return null;
    }

    void processSelected(DebuggingProcess debuggingProcess) {
        this.activeDebuggingProcess = debuggingProcess;
        Workspace workspace = debuggingProcess.getWorkspace();
        Project project = debuggingProcess.getProject();
        List[] breakpoints = Breakpoint.getBreakpoints(workspace, project);
        Breakpoint.updateBreakpointIcons(breakpoints);
        if (this.breakpointsWindow != null) {
            this.breakpointsWindow.processSelectionChanged();
        }
        this.checkCommandsBecauseActiveDebuggingProcessChanged();
        this.windowManager.setDebuggerWindowProvidersContext(debuggingProcess.getContext());
    }

    void processUnselected(DebuggingProcess debuggingProcess) {
        this.activeDebuggingProcess = null;
        SourceIcon.removeColumn(2);
        Container popupMenu = contextMenu.getGUI(false);
        if (popupMenu != null && popupMenu.isVisible()) {
            popupMenu.setVisible(false);
        }
        Workspace workspace = debuggingProcess.getWorkspace();
        Project project = debuggingProcess.getProject();
        List[] breakpoints = Breakpoint.getBreakpoints(workspace, project);
        Breakpoint.updateBreakpointIcons(breakpoints);
        if (this.breakpointsWindow != null) {
            this.breakpointsWindow.processSelectionChanged();
        }
        this.checkCommandsBecauseActiveDebuggingProcessChanged();
    }

    void debuggingProcessFinished(DebuggingProcess debuggingProcess) {
        if (this.activeDebuggingProcess == debuggingProcess) {
            this.activeDebuggingProcess = null;
            SourceIcon.removeColumn(2);
        }
        if (this.debuggingProcesses != null) {
            this.debuggingProcesses.remove(debuggingProcess);
        }
        debuggingProcess.clearLogPageToolbar();
        if (this.threadsWindow != null) {
            this.threadsWindow.processFinished(debuggingProcess);
        }
        if (this.smartWindow != null) {
            this.smartWindow.processFinished(debuggingProcess);
        }
        if (this.classesWindow != null) {
            this.classesWindow.processFinished(debuggingProcess);
        }
        if (this.heapWindow != null) {
            this.heapWindow.processFinished(debuggingProcess);
        }
        if (this.monitorsWindow != null) {
            this.monitorsWindow.processFinished(debuggingProcess);
        }
        if (this.objectPreferences != null) {
            this.objectPreferences.processFinished();
        }
    }

    boolean isActiveDebuggingProcess(DebuggingProcess debuggingProcess) {
        if (this.activeDebuggingProcess != null) {
            return this.activeDebuggingProcess.equals(debuggingProcess);
        }
        return false;
    }

    DebuggingProcess getActiveDebuggingProcess() {
        return this.activeDebuggingProcess;
    }

    boolean canShowDebuggingWindows() {
        return this.activeDebuggingProcess != null;
    }

    static boolean isDebuggingLayout(Layout layout) {
        String debugLayoutProperty = layout.getProperty(DEBUG_LAYOUT_KEY, Boolean.toString(false));
        return Boolean.toString(true).equals(debugLayoutProperty);
    }

    boolean canShowDebuggingWindows(Layout layout) {
        return this.canShowDebuggingWindows() && JDebugger.isDebuggingLayout(layout);
    }

    boolean canShowHeapWindow() {
        return false;
    }

    boolean canShowMonitorsWindow() {
        if (this.activeDebuggingProcess != null) {
            try {
                DebugVirtualMachine vm = this.activeDebuggingProcess.getVM();
                if (vm != null) {
                    boolean bl = vm.getCapabilities().canGetMonitors();
                    return bl;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private Breakpoint getBreakpointFromGutterMarkRightClick(Context context) {
        Object o;
        GutterMark gutterMark;
        if (context.getView() instanceof CodeEditorGutter.GutterView && (gutterMark = CodeEditorGutter.getMarkForContext((Context)context)) != null && (o = gutterMark.getUserData()) instanceof SourceIcon) {
            SourceIcon sourceIcon = (SourceIcon)o;
            Breakpoint bp = sourceIcon.getBreakpoint();
            return bp;
        }
        return null;
    }

    private boolean toggleBreakpointFromCodeEditor(Context context, IdeAction action) {
        int editorLine;
        Breakpoint bp = this.getBreakpointFromGutterMarkRightClick(context);
        if (bp != null && bp.getType() != 6) {
            if (action == null) {
                bp.removeBreakpoint();
                this.updateBreakpointsWindow();
            }
            return true;
        }
        CodeEditor codeEditor = Source.getCodeEditorFromContext(context);
        if (codeEditor != null && (editorLine = Source.getLineFromCodeEditor(context)) != 0) {
            if (action == null) {
                this.toggleBreakpoint(context, codeEditor, editorLine);
            }
            return true;
        }
        return false;
    }

    private boolean toggleWatchpointFromCodeEditor(Context context, IdeAction action) {
        Node editorNode;
        Breakpoint bp = this.getBreakpointFromGutterMarkRightClick(context);
        if (bp != null && bp.getType() == 6) {
            if (action == null) {
                bp.removeBreakpoint();
                this.updateBreakpointsWindow();
            }
            return true;
        }
        CodeEditor codeEditor = Source.getCodeEditorFromContext(context);
        if (codeEditor != null && (editorNode = Source.getNodeFromCodeEditor(context)) instanceof JavaSourceNode) {
            JavaManager javaManager;
            SourceFile sourceFile;
            int editorOffset = 0;
            if (context.getView() instanceof CodeEditorGutter.GutterView) {
                int line = Source.getLineFromCodeEditor(context);
                if (line == 0) {
                    return false;
                }
                editorOffset = JDebugger.getLineStartOffsetSkipWhite(codeEditor, line);
            } else {
                editorOffset = codeEditor.getCaretPosition();
            }
            Project project = context.getProject();
            if (project != null && (sourceFile = (javaManager = JavaManager.getJavaManager((Project)project)).getSourceFile(editorNode.getURL())) != null) {
                SourceElement sourceElement = sourceFile.getElementAt(editorOffset);
                SourceFieldVariable sourceFieldVariable = null;
                if (sourceElement instanceof SourceName) {
                    Iterator itVariables;
                    if ((sourceElement = sourceElement.getParent()) instanceof SourceFieldVariable) {
                        sourceFieldVariable = (SourceFieldVariable)sourceElement;
                    } else if (sourceElement instanceof SourceTypeReference && (sourceElement = sourceElement.getParent()) instanceof SourceFieldDeclaration && (itVariables = ((SourceFieldDeclaration)sourceElement).getVariables().iterator()).hasNext()) {
                        sourceFieldVariable = (SourceFieldVariable)itVariables.next();
                    }
                }
                if (sourceFieldVariable != null) {
                    SourcePackage sourcePackage;
                    SourceClass sourceClass = sourceFieldVariable.getEnclosingClass();
                    String className = sourceClass.getName();
                    if (className.indexOf(".") == -1 && (sourcePackage = sourceFile.getSourcePackage()) != null) {
                        className = sourcePackage.getName() + "." + className;
                    }
                    String fieldName = sourceFieldVariable.getName();
                    if (action == null) {
                        this.toggleWatchpoint(className, fieldName);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private boolean enableBreakpointFromCodeEditor(Context context, IdeAction action) {
        int editorLine;
        CodeEditor codeEditor = Source.getCodeEditorFromContext(context);
        if (codeEditor != null && (editorLine = Source.getLineFromCodeEditor(context)) != 0) {
            Breakpoint bp = this.getBreakpointFromGutterMarkRightClick(context);
            if (bp == null) {
                bp = this.findBreakpointByIconLocation(codeEditor, editorLine, null);
            }
            if (bp != null && !bp.isEnabledNow()) {
                if (action != null) {
                    if (bp.getType() == 6) {
                        action.putValue("Name", (Object)DbgArb.getString(704));
                    } else {
                        action.putValue("Name", (Object)DbgArb.getString(701));
                    }
                } else {
                    bp.setEnabled(true);
                }
                return true;
            }
        }
        return false;
    }

    private boolean disableBreakpointFromCodeEditor(Context context, IdeAction action) {
        int editorLine;
        CodeEditor codeEditor = Source.getCodeEditorFromContext(context);
        if (codeEditor != null && (editorLine = Source.getLineFromCodeEditor(context)) != 0) {
            Breakpoint bp = this.getBreakpointFromGutterMarkRightClick(context);
            if (bp == null) {
                bp = this.findBreakpointByIconLocation(codeEditor, editorLine, null);
            }
            if (bp != null && bp.isEnabledNow()) {
                if (action != null) {
                    if (bp.getType() == 6) {
                        action.putValue("Name", (Object)DbgArb.getString(431));
                    } else {
                        action.putValue("Name", (Object)DbgArb.getString(569));
                    }
                } else {
                    bp.setEnabled(false);
                }
                return true;
            }
        }
        return false;
    }

    private boolean editBreakpointFromCodeEditor(Context context, IdeAction action) {
        int editorLine;
        CodeEditor codeEditor = Source.getCodeEditorFromContext(context);
        if (codeEditor != null && (editorLine = Source.getLineFromCodeEditor(context)) != 0) {
            Breakpoint bp = this.getBreakpointFromGutterMarkRightClick(context);
            if (bp == null) {
                bp = this.findBreakpointByIconLocation(codeEditor, editorLine, null);
            }
            if (bp != null) {
                if (action != null) {
                    if (bp.getType() == 6) {
                        action.putValue("Name", (Object)DbgArb.getString(368));
                    } else {
                        action.putValue("Name", (Object)DbgArb.getString(362));
                    }
                } else {
                    this.getBreakpointsWindow(true).editBreakpoint(bp);
                }
                return true;
            }
        }
        return false;
    }

    private boolean createWatchpointFromStructure(Context context, IdeAction action) {
        Element element = context.getElement();
        if (element instanceof FieldElement) {
            String fieldName;
            Breakpoint bp;
            String pkg;
            FieldElement fieldElement = (FieldElement)element;
            ClassElement classElement = fieldElement.getEnclosingClass();
            String className = classElement.getSymbolName();
            if (className.indexOf(".") == -1 && (pkg = classElement.getPackageName()) != null && pkg.length() > 0) {
                className = pkg + "." + className;
            }
            if ((bp = this.findWatchpoint(className, fieldName = fieldElement.getSymbolName())) == null) {
                if (action == null) {
                    this.createWatchpoint(className, fieldName);
                }
                return true;
            }
        }
        return false;
    }

    static String trimExpression(String expression) {
        StringBuffer buffer = new StringBuffer();
        String[] parts = expression.split("[\r\n]");
        int i = 0;
        while (i < parts.length) {
            buffer.append(parts[i].trim());
            ++i;
        }
        return buffer.toString();
    }

    private void watchFromCodeEditor(Context context) {
        if (this.activeDebuggingProcess != null && this.activeDebuggingProcess.isStopped()) {
            String expression = "";
            CodeEditor codeEditor = Source.getCodeEditorFromContext(context);
            if (codeEditor != null) {
                expression = codeEditor.getSelectedText();
                expression = expression != null ? JDebugger.trimExpression(expression) : "";
            }
            this.getWatchWindow(true);
            if (this.watchWindow.addWatchDialog(expression)) {
                this.viewWatches();
            }
        }
    }

    private void inspectFromCodeEditor(Context context) {
        if (this.activeDebuggingProcess != null && this.activeDebuggingProcess.isStopped()) {
            String expression = "";
            CodeEditor codeEditor = Source.getCodeEditorFromContext(context);
            if (codeEditor != null) {
                expression = codeEditor.getSelectedText();
                expression = expression != null ? JDebugger.trimExpression(expression) : "";
            }
            if ((expression = InspectorWindow.inspectDialog(expression)) != null) {
                this.inspect(expression);
            }
        }
    }

    private static RunLogPage getRunLogPage(Context context) {
        LogPage logPage;
        View view = context.getView();
        if (view instanceof RunLogPage) {
            return (RunLogPage)view;
        }
        LogWindow logWindow = LogManager.getLogManager().getLogWindow();
        if (logWindow != null && (logPage = logWindow.getPage()) instanceof RunLogPage) {
            return (RunLogPage)logPage;
        }
        return null;
    }

    private boolean canDoLogWindowAction(Context context, int cmdId) {
        RunLogPage runLogPage;
        if (context != null && (runLogPage = JDebugger.getRunLogPage(context)) != null) {
            if (cmdId == LOG_WINDOW_CANCEL_DEBUG_CONNECTION_CMD_ID) {
                DebuggingProcess debuggingProcess = this.findDebuggingProcess(runLogPage, true);
                if (debuggingProcess != null) {
                    return debuggingProcess.canCancelConnection();
                }
            } else {
                DebuggingProcess debuggingProcess = this.findDebuggingProcess(runLogPage, false);
                if (debuggingProcess != null) {
                    if (cmdId == LOG_WINDOW_SHOWIP_CMD_ID) {
                        return debuggingProcess.canShowIP();
                    }
                    if (cmdId == LOG_WINDOW_RESUME_CMD_ID) {
                        return debuggingProcess.canResume();
                    }
                    if (cmdId == LOG_WINDOW_STEPOVER_CMD_ID) {
                        return debuggingProcess.canStepOver();
                    }
                    if (cmdId == LOG_WINDOW_STEPINTO_CMD_ID) {
                        return debuggingProcess.canStepInto();
                    }
                    if (cmdId == LOG_WINDOW_STEPOUT_CMD_ID) {
                        return debuggingProcess.canStepOut();
                    }
                    if (cmdId == LOG_WINDOW_STEPTOENDOFMETHOD_CMD_ID) {
                        return debuggingProcess.canStepToEndOfMethod();
                    }
                    if (cmdId == LOG_WINDOW_STEPOVERBC_CMD_ID) {
                        return debuggingProcess.canStepOver();
                    }
                    if (cmdId == LOG_WINDOW_STEPINTOBC_CMD_ID) {
                        return debuggingProcess.canStepInto();
                    }
                    if (cmdId == LOG_WINDOW_PAUSE_CMD_ID) {
                        return debuggingProcess.canPause();
                    }
                    if (cmdId == LOG_WINDOW_RESET_CMD_ID) {
                        return debuggingProcess.canTerminate();
                    }
                    if (cmdId == LOG_WINDOW_GC_CMD_ID) {
                        return debuggingProcess.canGC();
                    }
                }
            }
        }
        return false;
    }

    private void doLogWindowAction(Context context, int cmdId) {
        RunLogPage runLogPage;
        if (context != null && (runLogPage = JDebugger.getRunLogPage(context)) != null) {
            if (cmdId == LOG_WINDOW_CANCEL_DEBUG_CONNECTION_CMD_ID) {
                DebuggingProcess debuggingProcess = this.findDebuggingProcess(runLogPage, true);
                if (debuggingProcess != null) {
                    debuggingProcess.cancelConnection();
                }
            } else {
                DebuggingProcess debuggingProcess = this.findDebuggingProcess(runLogPage, false);
                if (debuggingProcess != null) {
                    if (cmdId == LOG_WINDOW_SHOWIP_CMD_ID) {
                        debuggingProcess.showIP();
                    } else if (cmdId == LOG_WINDOW_RESUME_CMD_ID) {
                        debuggingProcess.resume();
                    } else if (cmdId == LOG_WINDOW_STEPOVER_CMD_ID) {
                        debuggingProcess.stepOver(JDebugger.getEventTime(context));
                    } else if (cmdId == LOG_WINDOW_STEPINTO_CMD_ID) {
                        debuggingProcess.stepInto(JDebugger.getEventTime(context));
                    } else if (cmdId == LOG_WINDOW_STEPOUT_CMD_ID) {
                        debuggingProcess.stepOut(JDebugger.getEventTime(context));
                    } else if (cmdId == LOG_WINDOW_STEPTOENDOFMETHOD_CMD_ID) {
                        debuggingProcess.stepToEndOfMethod(JDebugger.getEventTime(context));
                    } else if (cmdId == LOG_WINDOW_STEPOVERBC_CMD_ID) {
                        debuggingProcess.stepOverBC(JDebugger.getEventTime(context));
                    } else if (cmdId == LOG_WINDOW_STEPINTOBC_CMD_ID) {
                        debuggingProcess.stepIntoBC(JDebugger.getEventTime(context));
                    } else if (cmdId == LOG_WINDOW_PAUSE_CMD_ID) {
                        debuggingProcess.pause();
                    } else if (cmdId == LOG_WINDOW_RESET_CMD_ID) {
                        debuggingProcess.terminate();
                    } else if (cmdId == LOG_WINDOW_GC_CMD_ID) {
                        debuggingProcess.gc();
                    }
                }
            }
        }
    }

    void showContextMenu(MouseEvent e, DockableWindow dw, JFastTreeTable treeTable) {
        if (treeTable != null && treeTable.isEnabled() && e.getSource() == treeTable) {
            JTree tree = treeTable.getTree();
            int y = e.getY();
            int w = treeTable.getWidth();
            int x = 20;
            while (x < w) {
                TreePath treePath = tree.getPathForLocation(x, y);
                if (treePath != null) {
                    boolean alreadySelected = false;
                    TreePath[] treePaths = tree.getSelectionPaths();
                    if (treePaths != null) {
                        int i = treePaths.length - 1;
                        while (i >= 0) {
                            if (treePath.equals(treePaths[i])) {
                                alreadySelected = true;
                                break;
                            }
                            --i;
                        }
                    }
                    if (!alreadySelected) {
                        this.selectTreeTablePath(treeTable, treePath, false);
                    }
                }
                x += 20;
            }
        }
        this.showContextMenu(e, dw);
    }

    void showContextMenu(MouseEvent e, DockableWindow dw, JTable table) {
        int row;
        if (table != null && table.isEnabled() && e.getSource() == table && table.isEnabled() && (row = table.rowAtPoint(e.getPoint())) != -1) {
            ListSelectionModel listSelectionModel = table.getSelectionModel();
            listSelectionModel.clearSelection();
            listSelectionModel.addSelectionInterval(row, row);
        }
        this.showContextMenu(e, dw);
    }

    void showContextMenu(MouseEvent e, DockableWindow dw) {
        DockStation.getDockStation().activateDockable((Dockable)dw);
        SwingUtilities.invokeLater(new 12(this, e));
    }

    void selectTreeTablePath(JFastTreeTable treeTable, TreePath treePath, boolean scrollToVisible) {
        JTree tree = treeTable.getTree();
        if (scrollToVisible) {
            SwingUtilities.invokeLater(new 13(this, tree, treePath, treeTable));
        }
        SwingUtilities.invokeLater(new 14(this, tree, treePath));
    }

    static void adjustColumnsAfterResize(JScrollPane scrollPane, JTable table) {
        int tableWidth;
        if (table.getAutoResizeMode() == 0) {
            tableWidth = table.getWidth();
        } else {
            tableWidth = 0;
            TableColumnModel tableColumnModel = table.getColumnModel();
            Enumeration<TableColumn> e = tableColumnModel.getColumns();
            while (e.hasMoreElements()) {
                TableColumn column = e.nextElement();
                tableWidth += column.getPreferredWidth();
            }
        }
        int extra = scrollPane.getViewport().getWidth() - tableWidth;
        if (extra > 0) {
            boolean firstColumn = true;
            TableColumnModel tableColumnModel = table.getColumnModel();
            Enumeration<TableColumn> e = tableColumnModel.getColumns();
            while (e.hasMoreElements()) {
                TableColumn column = e.nextElement();
                int width = column.getPreferredWidth();
                if (firstColumn) {
                    int remainingColumnCount = tableColumnModel.getColumnCount() - 1;
                    int extraForFirstColumn = remainingColumnCount > 0 ? extra / 2 : extra;
                    width += extraForFirstColumn;
                    if ((extra -= extraForFirstColumn) > 0 && remainingColumnCount > 0) {
                        extra /= remainingColumnCount;
                    }
                } else {
                    width += extra;
                }
                column.setPreferredWidth(width);
                firstColumn = false;
                if (extra <= 0) break;
            }
        }
    }

    static void addColumnsMenu(JTable table, ColumnMenuListener columnMenuListener, boolean[] showColumnInMenu) {
        int showColumnInMenuLength = showColumnInMenu.length;
        ArrayList<TableColumn> allColumns = new ArrayList<TableColumn>();
        TableColumnModel tableColumnModel = table.getColumnModel();
        Enumeration<TableColumn> e = tableColumnModel.getColumns();
        while (e.hasMoreElements()) {
            TableColumn column = e.nextElement();
            int modelIndex = column.getModelIndex();
            if (modelIndex >= showColumnInMenuLength || !showColumnInMenu[modelIndex]) continue;
            allColumns.add(column);
        }
        JTableHeader tableHeader = table.getTableHeader();
        tableHeader.addMouseListener(new 15(allColumns, columnMenuListener, table));
    }

    static boolean isDoubleClickInTreeTable(JFastTreeTable treeTable, MouseEvent e) {
        if ((e.getModifiers() & 0x10) != 0 && e.getClickCount() == 2) {
            int columnAtX = treeTable.getColumnModel().getColumnIndexAtX(e.getX());
            int column = treeTable.convertColumnIndexToModel(columnAtX);
            if (column == 0) {
                Rectangle r;
                JTree tree = treeTable.getTree();
                TreePath treePath = tree.getSelectionPath();
                if (treePath != null && (r = tree.getPathBounds(treePath)) != null) {
                    r.width = 1000;
                    Point p = e.getPoint();
                    if (r.contains(p)) {
                        return true;
                    }
                }
            } else {
                return true;
            }
        }
        return false;
    }

    ObjectPreferences getObjectPreferences() {
        if (this.objectPreferences == null) {
            this.objectPreferences = new ObjectPreferences();
        }
        return this.objectPreferences;
    }

    void setUseFilters(boolean useFilters) {
        this.dbgSettings.setUseFilters(useFilters);
        if (this.smartWindow != null) {
            this.smartWindow.setUseFilters(useFilters);
        }
        if (this.localsWindow != null) {
            this.localsWindow.setUseFilters(useFilters);
        }
        if (this.watchWindow != null) {
            this.watchWindow.setUseFilters(useFilters);
        }
        if (this.inspectorWindows != null) {
            for (InspectorWindow inspectorWindow : this.inspectorWindows) {
                inspectorWindow.setUseFilters(useFilters);
            }
        }
        if (this.heapWindow != null) {
            this.heapWindow.setUseFilters(useFilters);
        }
        if (this.monitorsWindow != null) {
            this.monitorsWindow.setUseFilters(useFilters);
        }
    }

    void dataHasBeenModified() {
        WaitCursor wc = Ide.getWaitCursor();
        wc.show();
        try {
            this.updateDataWindows();
            if (this.threadsWindow != null) {
                this.threadsWindow.everythingChanged();
            }
            if (this.classesWindow != null) {
                this.classesWindow.everythingChanged();
            }
        }
        finally {
            wc.hide();
        }
    }

    void updateDataWindows() {
        if (this.smartWindow != null) {
            this.smartWindow.everythingChanged();
        }
        if (this.localsWindow != null) {
            this.localsWindow.everythingChanged();
        }
        if (this.watchWindow != null) {
            this.watchWindow.everythingChanged();
        }
        if (this.inspectorWindows != null) {
            for (InspectorWindow inspectorWindow : this.inspectorWindows) {
                inspectorWindow.everythingChanged();
            }
        }
        if (this.heapWindow != null) {
            this.heapWindow.everythingChanged();
        }
        if (this.monitorsWindow != null) {
            this.monitorsWindow.everythingChanged();
        }
        this.windowManager.refreshCustomWindows();
    }

    void refreshSmartWindow() {
        if (this.smartWindow != null) {
            this.smartWindow.refreshWindow();
        }
    }

    void refreshCustomWindows(Evaluator evaluator, DebuggingProcess process) {
        this.windowManager.refreshCustomWindows(evaluator, process);
    }

    static List<SmartDataProvider> getSmartDataProviders() {
        return smartDataProviders;
    }

    static List<ToolTipExpressionProvider> getToolTipExpressionProviders() {
        return toolTipExpressionProviders;
    }

    void stackFramesPopped() {
        if (this.stackWindow != null) {
            this.stackWindow.everythingChanged();
        }
        if (this.monitorsWindow != null) {
            this.monitorsWindow.everythingChanged();
        }
    }

    static PrintWriter printHtmlHeader(URL url, String title) throws IOException {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(URLFileSystem.openOutputStream((URL)url)), IdeUtil.getIdeIanaEncoding()));
        pw.println("<!doctype html public \"-//w3c//dtd html 4.0 transitional//en\">");
        pw.println("<html>");
        pw.println("<head>");
        pw.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + IdeUtil.getIdeIanaEncoding() + "\">");
        pw.println("<meta name=\"Author\" content=\"JDeveloper Debugger\">");
        pw.println("<title>" + title + "</title>");
        pw.println("</head>");
        pw.println("<body>");
        return pw;
    }

    static void printHtmlFooter(PrintWriter pw) {
        pw.println("</body>");
        pw.println("</html>");
    }

    static void setControllerForActions(IdeAction[] actions, Controller controller) {
        int i = 0;
        while (i < actions.length) {
            IdeAction action = actions[i];
            if (action != null) {
                action.addController(controller);
                action.putValue(ACTION_OWNER, (Object)controller);
            }
            ++i;
        }
    }

    static void clearControllerForActions(IdeAction[] actions, Controller controller) {
        int i = 0;
        while (i < actions.length) {
            IdeAction action = actions[i];
            if (action != null) {
                action.removeController(controller);
                action.putValue(ACTION_OWNER, null);
                action.setEnabled(false);
            }
            ++i;
        }
    }

    static String fixTreeCellAccessibleName(String accessibleName, boolean expanded) {
        if (accessibleName != null) {
            accessibleName = expanded ? DbgArb.format(960, accessibleName) : DbgArb.format(123, accessibleName);
        }
        return accessibleName;
    }

    static long getObjectNumber(DebugDataCompositeInfo dci) {
        long address;
        DebugVirtualMachine vm = dci.getVM();
        DebugCapabilities capabilities = vm.getCapabilities();
        if (capabilities.canGetUniqueIDs()) {
            long uniqueID = dci.getUniqueID();
            if (uniqueID != 0L) {
                return uniqueID;
            }
        } else if (capabilities.canGetAddresses() && (address = dci.getAddressOfObject()) != 0L) {
            return address;
        }
        return 0L;
    }

    private static URL getUrlForClassSourceFile(Project jproject, String className) {
        SourceClass sourceClass;
        JavaManager javaManager = JavaManager.getJavaManager((Project)jproject);
        JavaClass javaClass = javaManager.getClass(className);
        if (javaClass != null && (sourceClass = (SourceClass)javaClass.getSourceElement()) != null) {
            return sourceClass.getURL();
        }
        return null;
    }

    private static URL getUrlForPackage(Project jproject, String packageName) {
        JavaManager javaManager = JavaManager.getJavaManager((Project)jproject);
        JavaPackage javaPackage = javaManager.getPackage(packageName);
        Collection classes = javaPackage.getDeclaredClasses();
        if (classes != null && classes.size() > 0) {
            for (JavaClass javaClass : classes) {
                SourceClass sourceClass;
                if (javaClass == null || (sourceClass = (SourceClass)javaClass.getSourceElement()) == null) continue;
                URL urlClass = sourceClass.getURL();
                URL urlPackage = URLFileSystem.getParent((URL)urlClass);
                return urlPackage;
            }
        }
        return null;
    }

    private static String[] getFileNamesFromUrls(URL[] urls) {
        int length = urls.length;
        String[] fileNames = new String[length];
        int i = 0;
        while (i < length) {
            fileNames[i] = URLFileSystem.getFileName((URL)urls[i]);
            ++i;
        }
        return fileNames;
    }

    private static long getEventTime(Context context) {
        EventObject event = context.getEvent();
        if (event instanceof ActionEvent) {
            return ((ActionEvent)event).getWhen();
        }
        return 0L;
    }

    static int getLineStartOffsetSkipWhite(CodeEditor codeEditor, int line) {
        int offset = codeEditor.getLineStartOffset(line);
        try {
            String lineOfText = codeEditor.getText(offset, codeEditor.getLineEndOffset(line) - offset);
            int i = 0;
            while (Character.isWhitespace(lineOfText.charAt(i))) {
                ++offset;
                ++i;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return offset;
    }

    private void updateRunConfigurationList() {
        RunConfigurations runConfigurations;
        RunConfiguration[] runConfigs;
        int runConfigsLength;
        IdeAction[] actions = null;
        if (this.activeProject != null && this.activeProject.isOpen() && (runConfigsLength = (runConfigs = (runConfigurations = RunConfigurations.getInstance((PropertyStorage)this.activeProject)).getVisibleRunConfigurations()).length) > 0) {
            debugProjectCmdIds = new int[runConfigsLength];
            actions = new IdeAction[runConfigsLength];
            String category = DbgArb.getString(171);
            Context context = Ide.getMainWindow().getLastActiveView().getContext();
            int i = 0;
            while (i < runConfigsLength) {
                RunConfiguration runConfiguration = runConfigs[i];
                String name = runConfiguration.getName();
                int cmdId = Ide.findOrCreateCmdID((String)(DEBUG_PROJECT_CMD_PREFIX + i));
                IdeAction action = IdeAction.get((int)cmdId, null, (String)name, (String)category, null, null, (Object)((Object)runConfiguration), (boolean)true);
                action.putValue("Name", (Object)name);
                action.putValue("UserData", (Object)runConfiguration);
                action.putValue("Radio", (Object)Boolean.TRUE);
                action.addController((Controller)this);
                JDebugger.debugProjectCmdIds[i] = cmdId;
                actions[i] = action;
                this.update(action, context);
                ++i;
            }
        }
        if (actions == null) {
            debugProjectCmdIds = new int[0];
            actions = new IdeAction[]{actionEmpty};
        }
        int i = actions.length;
        IdeAction[] newActions = new IdeAction[i + 2];
        if (actionMRUConfigurationMenuDebug != null) {
            newActions = new IdeAction[i + 4];
        }
        System.arraycopy(actions, 0, newActions, 0, i);
        actions = newActions;
        if (actionMRUConfigurationMenuDebug != null) {
            actions[i++] = null;
            actions[i++] = actionMRUConfigurationMenuDebug;
        }
        actions[i++] = null;
        actions[i] = RunManager.getManageRunConfigurationsAction();
        actionDebugProject.putValue("ActionMenuActions", (Object)actions);
    }

    public Action getActionDebugProject() {
        return actionDebugProject;
    }

    static boolean isSecretFeatureEnabled(String feature) {
        return Ide.getProperty((String)feature) != null;
    }

    public void installWindows() {
        boolean isRaptor = Product.isRaptor();
        this.windowManager.installWindow("Debugger.BreakpointsWindow");
        this.windowManager.installWindow("Debugger.SmartWindow");
        this.windowManager.installWindow("Debugger.LocalsWindow");
        this.windowManager.installWindow("Debugger.WatchWindow");
        if (!isRaptor) {
            this.windowManager.installWindow("Debugger.HeapWindow");
            this.windowManager.installWindow("Debugger.ThreadsWindow");
            this.windowManager.installWindow("Debugger.ClassesWindow");
        }
        this.windowManager.installWindow("Debugger.StackWindow");
        if (!isRaptor) {
            this.windowManager.installWindow("Debugger.MonitorsWindow");
        }
        this.windowManager.installCustomWindows();
    }

    DebugDockableFactory getDebugDockableFactory() {
        return this.debugDockableFactory;
    }

    static {
        lastSavedFile = null;
        viewDebuggerSubMenuBuilt = false;
        debugMenuBuilt = false;
        debugContextSubMenuAdded = false;
        debugContextSubMenuBuilt = false;
        smartDataProviders = new ArrayList<SmartDataProvider>();
        toolTipExpressionProviders = new ArrayList<ToolTipExpressionProvider>();
        viewDebuggerActions = new ArrayList<IdeAction>();
        DEBUG_CMD_MRU_CONFIGURATION_ID = Ide.findOrCreateCmdID((String)"DebugMRUConfiguration_ID");
        VIEW_BREAKPOINTS_CMD_ID = Ide.findOrCreateCmdID((String)"ViewDebugBreakpointsCommand");
        VIEW_THREADS_CMD_ID = Ide.findOrCreateCmdID((String)"ViewDebugThreadsCommand");
        VIEW_STACK_CMD_ID = Ide.findOrCreateCmdID((String)"ViewDebugStackCommand");
        VIEW_SMART_CMD_ID = Ide.findOrCreateCmdID((String)"ViewDebugSmartCommand");
        VIEW_LOCALS_CMD_ID = Ide.findOrCreateCmdID((String)"ViewDebugLocalsCommand");
        VIEW_WATCHES_CMD_ID = Ide.findOrCreateCmdID((String)"ViewDebugWatchesCommand");
        VIEW_CLASSES_CMD_ID = Ide.findOrCreateCmdID((String)"ViewDebugClassesCommand");
        VIEW_HEAP_CMD_ID = Ide.findOrCreateCmdID((String)"ViewDebugHeapCommand");
        VIEW_MONITORS_CMD_ID = Ide.findOrCreateCmdID((String)"ViewDebugMonitorsCommand");
        VIEW_LOG_CMD_ID = Ide.findOrCreateCmdID((String)"ViewDebugLogCommand");
        DEBUG_PROJECT_CMD_ID = Ide.findOrCreateCmdID((String)DEBUG_PROJECT_CMD_PREFIX);
        debugProjectCmdIds = new int[0];
        DEBUG_SELECTION_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSelectionCommand");
        DEBUG_PAUSE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugPauseCommand");
        DEBUG_RESUME_CMD_ID = Ide.findOrCreateCmdID((String)"DebugResumeCommand");
        DEBUG_DETACH_CMD_ID = Ide.findOrCreateCmdID((String)"DebugDetachCommand");
        DEBUG_RESET_CMD_ID = Ide.findOrCreateCmdID((String)"DebugResetCommand");
        DEBUG_STEPOVER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStepOverCommand");
        DEBUG_STEPOVERBC_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStepOverBCCommand");
        DEBUG_STEPINTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStepIntoCommand");
        DEBUG_STEPINTOBC_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStepIntoBCCommand");
        DEBUG_STEPOUT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStepOutCommand");
        DEBUG_STEPTOENDOFMETHOD_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStepToEndOfMethodCommand");
        DEBUG_CONTINUESTEP_CMD_ID = Ide.findOrCreateCmdID((String)"DebugContinueStepCommand");
        DEBUG_RUNTOCURSOR_CMD_ID = Ide.findOrCreateCmdID((String)"DebugRunToCursorCommand");
        DEBUG_STEPINTOMETHOD_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStepIntoMethodCommand");
        DEBUG_SETNEXTSTATEMENT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSetNextStatementCommand");
        DEBUG_SHOWIP_CMD_ID = Ide.findOrCreateCmdID((String)"DebugShowIPCommand");
        DEBUG_GC_CMD_ID = Ide.findOrCreateCmdID((String)"DebugGCCommand");
        DEBUG_POP_1_STACK_FRAME_CMD_ID = Ide.findOrCreateCmdID((String)"DebugPop1StackFrameCommand");
        CONTEXTMENU_DEBUG_CMD_ID = Ide.findOrCreateCmdID((String)"ContextMenuDebug");
        NAVIGATOR_STOPLISTENING_CMD_ID = Ide.findOrCreateCmdID((String)"NavigatorStopListening");
        NAVIGATOR_DETACHDEBUGGER_CMD_ID = Ide.findOrCreateCmdID((String)"NavigatorDetachDebugger");
        CODE_EDITOR_GUTTER_TOGGLEBREAKPOINT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugCodeEditorToggleBreakpointCommand");
        CODE_EDITOR_GUTTER_TOGGLEWATCHPOINT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugCodeEditorToggleWatchpointCommand");
        CODE_EDITOR_GUTTER_ENABLEBREAKPOINT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugCodeEditorEnableBreakpointCommand");
        CODE_EDITOR_GUTTER_DISABLEBREAKPOINT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugCodeEditorDisableBreakpointCommand");
        CODE_EDITOR_GUTTER_EDITBREAKPOINT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugCodeEditorEditBreakpointCommand");
        CODE_EDITOR_WATCH_CMD_ID = Ide.findOrCreateCmdID((String)"DebugCodeEditorWatchCommand");
        CODE_EDITOR_INSPECT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugCodeEditorInspectCommand");
        STRUCTURE_CREATEWATCHPOINT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStructureCreateWatchpointCommand");
        LOG_WINDOW_CANCEL_DEBUG_CONNECTION_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLogWindowCancelDebugConnectionCommand");
        LOG_WINDOW_SHOWIP_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLogWindowShowIPCommand");
        LOG_WINDOW_RESUME_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLogWindowResumeCommand");
        LOG_WINDOW_STEPOVER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLogWindowStepOverCommand");
        LOG_WINDOW_STEPINTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLogWindowStepIntoCommand");
        LOG_WINDOW_STEPOUT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLogWindowStepOutCommand");
        LOG_WINDOW_STEPTOENDOFMETHOD_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLogWindowStepToEndOfMethodCommand");
        LOG_WINDOW_STEPOVERBC_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLogWindowStepOverBCCommand");
        LOG_WINDOW_STEPINTOBC_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLogWindowStepIntoBCCommand");
        LOG_WINDOW_PAUSE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLogWindowPauseCommand");
        LOG_WINDOW_RESET_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLogWindowResetCommand");
        LOG_WINDOW_GC_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLogWindowGCCommand");
    }

    static void mav$checkCommandsBecauseTracingChanged(JDebugger jDebugger) {
        jDebugger.checkCommandsBecauseTracingChanged();
    }

    static int ra$duringClassRedefinition(JDebugger jDebugger) {
        return jDebugger.duringClassRedefinition;
    }

    static void wa$duringClassRedefinition(JDebugger jDebugger, int n) {
        jDebugger.duringClassRedefinition = n;
    }

    static void mav$updateDebugActions(JDebugger jDebugger) {
        jDebugger.updateDebugActions();
    }

    static void mav$debugWindowSettingsChanged(JDebugger jDebugger) {
        jDebugger.debugWindowSettingsChanged();
    }

    static Project ra$activeProject(JDebugger jDebugger) {
        return jDebugger.activeProject;
    }

    static void mav$activeProjectChanged(JDebugger jDebugger) {
        jDebugger.activeProjectChanged();
    }

    static void mav$updateRunConfigurationList(JDebugger jDebugger) {
        jDebugger.updateRunConfigurationList();
    }

    static void mav$checkCommandsBecauseActiveProjectChanged(JDebugger jDebugger) {
        jDebugger.checkCommandsBecauseActiveProjectChanged();
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ UpdateMessage v$change;
        private final /* synthetic */ Object v$observed;
        final /* synthetic */ JDebugger this$0;

        public void run() {
            int messageID = this.v$change.getMessageID();
            if (this.v$observed == Ide.getSystem()) {
                if (messageID == IdeConstants.ACTIVE_PROJECT_CHANGED) {
                    JDebugger.mav$activeProjectChanged(this.this$0);
                }
            } else if (this.v$observed instanceof Workspace) {
                if (messageID == UpdateMessage.OBJECT_RENAMED) {
                    Breakpoint.breakpointOwnerRenamed(this.v$change);
                }
            } else if (this.v$observed instanceof Project && messageID == UpdateMessage.OBJECT_RENAMED) {
                Breakpoint.breakpointOwnerRenamed(this.v$change);
            }
        }

        public 1(JDebugger jDebugger, UpdateMessage updateMessage, Object object) {
            this.v$observed = object;
            this.v$change = updateMessage;
            this.this$0 = jDebugger;
        }
    }

    final class 2
    extends ProjectChangeListener {
        public void projectOpened(Project project) {
            if (project == JDebugger.ra$activeProject(JDebugger.this)) {
                this.updateNowOrLater();
            }
        }

        public void projectPropertiesChanged(ProjectChangeEvent e) {
            if (e.getProject() == JDebugger.ra$activeProject(JDebugger.this)) {
                this.updateNowOrLater();
            }
        }

        private void updateNowOrLater() {
            1 runnable = new 1();
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }

        final class 1
        implements Runnable {
            public void run() {
                JDebugger.mav$updateRunConfigurationList(JDebugger.this);
                JDebugger.this.tracingChanged();
                JDebugger.mav$checkCommandsBecauseActiveProjectChanged(JDebugger.this);
            }
        }
    }

    final class 3
    extends StructureChangeListener {
        public void structureValuesChanged(StructureChangeEvent e) {
            JDebugger.mav$debugWindowSettingsChanged(JDebugger.this);
        }
    }

    final class 4
    implements Runnable {
        public void run() {
            JDebugger.mav$updateDebugActions(JDebugger.this);
        }
    }

    final class 5
    extends Thread {
        public void run() {
            try {
                UnifiedBuildSystem.getInstance().join(0L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SwingUtilities.invokeLater(new 1());
        }

        public 5(String string) {
            super(string);
        }

        final class 1
        implements Runnable {
            public void run() {
                JDebugger.mav$updateDebugActions(JDebugger.this);
            }
        }
    }

    final class 6
    implements RunWhilePaused {
        private final /* synthetic */ Map v$nameToGuts;
        final /* synthetic */ JDebugger this$0;

        public void run(DebuggingProcess debuggingProcess, boolean live) {
            if (live) {
                debuggingProcess.redefineClasses(this.v$nameToGuts);
                SwingUtilities.invokeLater(new 1(this, debuggingProcess));
            }
        }

        public 6(JDebugger jDebugger, Map map) {
            this.v$nameToGuts = map;
            this.this$0 = jDebugger;
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ DebuggingProcess v$debuggingProcess;
            final /* synthetic */ 6 this$0;

            public void run() {
                this.this$0.this$0.getStackWindow(true).everythingChanged();
                Breakpoint.updateBreakpointIcons(Breakpoint.getBreakpoints(this.v$debuggingProcess.getWorkspace(), this.v$debuggingProcess.getProject()));
                this.this$0.this$0.updateBreakpointsWindowStatus();
            }

            public 1(6 var1_1, DebuggingProcess debuggingProcess) {
                this.v$debuggingProcess = debuggingProcess;
                this.this$0 = var1_1;
            }
        }
    }

    final class 7
    implements Runnable {
        public void run() {
            JDebugger jDebugger = JDebugger.this;
            JDebugger.wa$duringClassRedefinition(jDebugger, JDebugger.ra$duringClassRedefinition(jDebugger) - 1);
        }
    }

    final class 8
    implements Comparator {
        public int compare(IdeAction o1, IdeAction o2) {
            String name1 = (String)o1.getValue("Name");
            String name2 = (String)o2.getValue("Name");
            return name1.compareTo(name2);
        }
    }

    final class 9
    implements RunWhilePaused {
        public void run(DebuggingProcess debuggingProcess, boolean live) {
            if (debuggingProcess != null && live) {
                debuggingProcess.setTracing();
            }
        }
    }

    final class 10
    implements Runnable {
        public void run() {
            JDebugger.mav$checkCommandsBecauseTracingChanged(JDebugger.this);
        }
    }

    static final class 11
    implements RunWhilePaused {
        private final /* synthetic */ RunWhilePaused v$runWhilePaused;
        private final /* synthetic */ int[] v$countDown;
        private final /* synthetic */ Runnable v$runOnceLater;

        public void run(DebuggingProcess debuggingProcess, boolean live) {
            if (debuggingProcess != null && live) {
                this.v$runWhilePaused.run(debuggingProcess, live);
            }
            this.v$countDown[0] = this.v$countDown[0] - 1;
            if (this.v$countDown[0] == 0 && this.v$runOnceLater != null) {
                SwingUtilities.invokeLater(this.v$runOnceLater);
            }
        }

        public 11(RunWhilePaused runWhilePaused, int[] nArray, Runnable runnable) {
            this.v$runOnceLater = runnable;
            this.v$countDown = nArray;
            this.v$runWhilePaused = runWhilePaused;
        }
    }

    final class 12
    implements Runnable {
        private final /* synthetic */ MouseEvent v$e;
        final /* synthetic */ JDebugger this$0;

        public void run() {
            Context context = Ide.getMainWindow().getLastActiveView().getContext((EventObject)this.v$e);
            ContextMenu debuggerContextMenu = this.this$0.getContextMenu();
            debuggerContextMenu.show(context);
        }

        public 12(JDebugger jDebugger, MouseEvent mouseEvent) {
            this.v$e = mouseEvent;
            this.this$0 = jDebugger;
        }
    }

    final class 13
    implements Runnable {
        private final /* synthetic */ JTree v$tree;
        private final /* synthetic */ TreePath v$treePath;
        private final /* synthetic */ JFastTreeTable v$treeTable;
        final /* synthetic */ JDebugger this$0;

        public void run() {
            int row = this.v$tree.getRowForPath(this.v$treePath);
            Rectangle r = this.v$treeTable.getCellRect(row, 0, true);
            if (r != null) {
                this.v$treeTable.scrollRectToVisible(r);
            }
        }

        public 13(JDebugger jDebugger, JTree jTree, TreePath treePath, JFastTreeTable jFastTreeTable) {
            this.v$treeTable = jFastTreeTable;
            this.v$treePath = treePath;
            this.v$tree = jTree;
            this.this$0 = jDebugger;
        }
    }

    final class 14
    implements Runnable {
        private final /* synthetic */ JTree v$tree;
        private final /* synthetic */ TreePath v$treePath;
        final /* synthetic */ JDebugger this$0;

        public void run() {
            this.v$tree.setSelectionPath(this.v$treePath);
        }

        public 14(JDebugger jDebugger, JTree jTree, TreePath treePath) {
            this.v$treePath = treePath;
            this.v$tree = jTree;
            this.this$0 = jDebugger;
        }
    }

    static final class 15
    extends MouseAdapter {
        private final /* synthetic */ List v$allColumns;
        private final /* synthetic */ ColumnMenuListener v$columnMenuListener;
        private final /* synthetic */ JTable v$table;

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        private void showPopup(MouseEvent e) {
            Context context = Ide.getMainWindow().getLastActiveView().getContext((EventObject)e);
            ContextMenu contextMenu = new ContextMenu();
            contextMenu.addContextMenuListener((ContextMenuListener)new 1());
            contextMenu.show(context);
        }

        public 15(List list, ColumnMenuListener columnMenuListener, JTable jTable) {
            this.v$table = jTable;
            this.v$columnMenuListener = columnMenuListener;
            this.v$allColumns = list;
        }

        static List ra$v$allColumns(15 var0) {
            return var0.v$allColumns;
        }

        static JTable ra$v$table(15 var0) {
            return var0.v$table;
        }

        static ColumnMenuListener ra$v$columnMenuListener(15 var0) {
            return var0.v$columnMenuListener;
        }

        final class oracle.jdevimpl.runner.debug.JDebugger$15$1
        implements ContextMenuListener {
            public void menuWillShow(ContextMenu popup) {
                HashMap<Integer, JCheckBoxMenuItem> menuItems = new HashMap<Integer, JCheckBoxMenuItem>();
                for (TableColumn column : 15.ra$v$allColumns(15.this)) {
                    int modelIndex = column.getModelIndex();
                    JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(column.getHeaderValue().toString());
                    menuItem.addActionListener(new 1(this, menuItem, modelIndex));
                    menuItems.put(modelIndex, menuItem);
                    popup.add((Component)menuItem);
                }
                TableColumnModel tableColumnModel = 15.ra$v$table(15.this).getColumnModel();
                Enumeration<TableColumn> e = tableColumnModel.getColumns();
                while (e.hasMoreElements()) {
                    TableColumn column = e.nextElement();
                    int modelIndex = column.getModelIndex();
                    JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)menuItems.get(modelIndex);
                    if (menuItem == null) continue;
                    menuItem.setState(true);
                }
            }

            public void menuWillHide(ContextMenu popup) {
            }

            public boolean handleDefaultAction(Context context) {
                return false;
            }

            final class 1
            implements ActionListener {
                private final /* synthetic */ JCheckBoxMenuItem v$menuItem;
                private final /* synthetic */ int v$modelIndex;
                final /* synthetic */ oracle.jdevimpl.runner.debug.JDebugger$15$1 this$0;

                public void actionPerformed(ActionEvent e) {
                    if (this.v$menuItem.getState()) {
                        15.ra$v$columnMenuListener(this.this$0.15.this).showColumn(this.v$modelIndex);
                    } else {
                        15.ra$v$columnMenuListener(this.this$0.15.this).hideColumn(this.v$modelIndex);
                    }
                }

                public 1(oracle.jdevimpl.runner.debug.JDebugger$15$1 var1_1, JCheckBoxMenuItem jCheckBoxMenuItem, int n) {
                    this.v$modelIndex = n;
                    this.v$menuItem = jCheckBoxMenuItem;
                    this.this$0 = var1_1;
                }
            }
        }
    }
}

