/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.runner.DebuggerWindowProvider;
import oracle.ide.util.FastStringBuffer;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugStackSlotInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.BaseEvaluator;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DataWindow;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.LocalsWindowSettings;

final class LocalsWindow
extends DataWindow {
    private LocalsWindowSettings localsWindowSettings = LocalsWindowSettings.getInstance();
    private static IdeAction actionViewWhole;
    private static IdeAction actionViewAnnotations;
    private static IdeAction actionViewAnnotationsForClass;
    private static IdeAction actionAdjustRange;
    private static IdeAction actionToggleValue;
    private static IdeAction actionModifyValue;
    private static IdeAction actionWatch;
    private static IdeAction actionInspect;
    private static IdeAction actionWatchClassLoader;
    private static IdeAction actionInspectClassLoader;
    private static IdeAction actionGoto;
    private static IdeAction actionGotoDeclared;
    private static IdeAction actionGotoField;
    private static IdeAction actionUseFilters;
    private static IdeAction actionObjectPreferences;
    private static IdeAction actionCollapseAll;
    private static IdeAction actionSave;
    private static IdeAction actionSettings;
    private static JMenuItem menuitemSettings;
    private static final int VIEW_WHOLE_CMD_ID;
    private static final int VIEW_ANNOTATIONS_CMD_ID;
    private static final int VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID;
    private static final int ADJUST_RANGE_CMD_ID;
    private static final int TOGGLE_VALUE_CMD_ID;
    private static final int MODIFY_VALUE_CMD_ID;
    private static final int WATCH_CMD_ID;
    private static final int INSPECT_CMD_ID;
    private static final int WATCH_CLASSLOADER_CMD_ID;
    private static final int INSPECT_CLASSLOADER_CMD_ID;
    private static final int GOTO_CMD_ID;
    private static final int GOTO_DECLARED_CMD_ID;
    private static final int GOTO_FIELD_CMD_ID;
    private static final int USE_FILTERS_CMD_ID;
    private static final int OBJECT_PREFERENCES_CMD_ID;
    private static final int COLLAPSE_ALL_CMD_ID;
    private static final int SAVE_CMD_ID;
    private static final int SETTINGS_CMD_ID;
    static final String LOCALS_WINDOW_ID = "Debugger.LocalsWindow";

    LocalsWindow() {
        super(LOCALS_WINDOW_ID, DbgArb.getString(768), "f1_deb_datawindow_html");
        LocalsWindow.makeActions();
        this.setDataPanel(new LocalsPanel());
        this.setControllerForActions();
    }

    public Icon getTabIcon() {
        return OracleIcons.getIcon((String)"field.png");
    }

    public DebuggerWindowProvider.DebuggerWindowPosition getPosition() {
        return DebuggerWindowProvider.DebuggerWindowPosition.SOUTH;
    }

    public boolean installByDefault() {
        return true;
    }

    static void addContextMenuToMainMenu(Menubar menubar, JMenu subMenu) {
        LocalsWindow.makeActions();
        float section = 1.0f;
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionViewWhole), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionViewAnnotations), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionViewAnnotationsForClass), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionAdjustRange), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionToggleValue), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionModifyValue), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionWatch), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionInspect), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionWatchClassLoader), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionInspectClassLoader), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGoto), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGotoDeclared), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGotoField), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionUseFilters), subMenu, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionObjectPreferences), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionCollapseAll), subMenu, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSave), subMenu, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSettings), subMenu, section);
    }

    private static void makeActions() {
        if (actionViewWhole == null) {
            actionViewWhole = IdeAction.get((int)VIEW_WHOLE_CMD_ID, null, (String)DbgArb.getString(333), null, (Integer)DbgArb.getInteger(824), null, (int)-1, null, (boolean)false);
            actionViewWhole.setEnabled(false);
            actionViewAnnotations = IdeAction.get((int)VIEW_ANNOTATIONS_CMD_ID, null, (String)DbgArb.getString(33), null, (Integer)DbgArb.getInteger(961), null, (int)-1, null, (boolean)false);
            actionViewAnnotations.putValue("NoCtxName", (Object)DbgArb.getString(33));
            actionViewAnnotations.setEnabled(false);
            actionViewAnnotationsForClass = IdeAction.get((int)VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID, null, (String)DbgArb.getString(844), null, (Integer)DbgArb.getInteger(884), null, (int)-1, null, (boolean)false);
            actionViewAnnotationsForClass.setEnabled(false);
            actionAdjustRange = IdeAction.get((int)ADJUST_RANGE_CMD_ID, null, (String)DbgArb.getString(157), null, (Integer)DbgArb.getInteger(810), null, (int)-1, null, (boolean)false);
            actionAdjustRange.setEnabled(false);
            actionToggleValue = IdeAction.get((int)TOGGLE_VALUE_CMD_ID, null, (String)DbgArb.getString(183), null, (Integer)DbgArb.getInteger(891), null, (int)-1, null, (boolean)false);
            actionToggleValue.setEnabled(false);
            actionModifyValue = IdeAction.get((int)MODIFY_VALUE_CMD_ID, null, (String)DbgArb.getString(429), null, (Integer)DbgArb.getInteger(267), null, (int)-1, null, (boolean)false);
            actionModifyValue.setEnabled(false);
            actionWatch = IdeAction.get((int)WATCH_CMD_ID, null, (String)DbgArb.getString(197), null, (Integer)DbgArb.getInteger(682), null, (int)-1, null, (boolean)false);
            actionWatch.setEnabled(false);
            actionInspect = IdeAction.get((int)INSPECT_CMD_ID, null, (String)DbgArb.getString(96), null, (Integer)DbgArb.getInteger(484), null, (int)-1, null, (boolean)false);
            actionInspect.setEnabled(false);
            actionWatchClassLoader = IdeAction.get((int)WATCH_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(205), null, (Integer)DbgArb.getInteger(505), null, (int)-1, null, (boolean)false);
            actionWatchClassLoader.setEnabled(false);
            actionInspectClassLoader = IdeAction.get((int)INSPECT_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(273), null, (Integer)DbgArb.getInteger(921), null, (int)-1, null, (boolean)false);
            actionInspectClassLoader.setEnabled(false);
            actionGoto = IdeAction.get((int)GOTO_CMD_ID, null, (String)DbgArb.getString(389), null, (Integer)DbgArb.getInteger(598), null, (int)-1, null, (boolean)false);
            actionGoto.putValue("NoCtxName", (Object)DbgArb.getString(389));
            actionGoto.setEnabled(false);
            actionGotoDeclared = IdeAction.get((int)GOTO_DECLARED_CMD_ID, null, (String)DbgArb.getString(851), null, (Integer)DbgArb.getInteger(926), null, (int)-1, null, (boolean)false);
            actionGotoDeclared.putValue("NoCtxName", (Object)DbgArb.getString(851));
            actionGotoDeclared.setEnabled(false);
            actionGotoField = IdeAction.get((int)GOTO_FIELD_CMD_ID, null, (String)DbgArb.getString(617), null, (Integer)DbgArb.getInteger(788), null, (int)-1, null, (boolean)false);
            actionGotoField.putValue("NoCtxName", (Object)DbgArb.getString(617));
            actionGotoField.setEnabled(false);
            actionUseFilters = IdeAction.get((int)USE_FILTERS_CMD_ID, null, (String)DbgArb.getString(637), null, (Integer)DbgArb.getInteger(412), null, (int)-1, null, (boolean)false);
            actionUseFilters.putValue("Check", (Object)Boolean.TRUE);
            actionUseFilters.setEnabled(false);
            actionObjectPreferences = IdeAction.get((int)OBJECT_PREFERENCES_CMD_ID, null, (String)DbgArb.format(892, ""), null, (Integer)DbgArb.getInteger(594), null, (int)-1, null, (boolean)false);
            actionObjectPreferences.setEnabled(false);
            actionSettings = IdeAction.get((int)SETTINGS_CMD_ID, null, (String)RunMgrArb.getString(87), null, (Integer)RunMgrArb.getInteger(99), null, (int)-1, null, (boolean)false);
            actionSettings.setEnabled(false);
            actionCollapseAll = IdeAction.get((int)COLLAPSE_ALL_CMD_ID, null, (String)RunMgrArb.getString(0), null, (Integer)RunMgrArb.getInteger(7), null, (int)-1, null, (boolean)false);
            actionCollapseAll.setEnabled(false);
            actionSave = IdeAction.get((int)SAVE_CMD_ID, null, (String)RunMgrArb.getString(65), null, (Integer)RunMgrArb.getInteger(101), null, (int)-1, null, (boolean)false);
            actionSave.setEnabled(false);
        }
    }

    private void setControllerForActions() {
        IdeAction[] actions = new IdeAction[]{actionViewWhole, actionViewAnnotations, actionViewAnnotationsForClass, actionAdjustRange, actionToggleValue, actionModifyValue, actionWatch, actionInspect, actionWatchClassLoader, actionInspectClassLoader, actionGoto, actionGotoDeclared, actionGotoField, actionUseFilters, actionObjectPreferences, actionSettings, actionCollapseAll, actionSave};
        JDebugger.setControllerForActions(actions, this.dataPanel);
    }

    static {
        VIEW_WHOLE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsViewWhole");
        VIEW_ANNOTATIONS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsViewAnnotations");
        VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsViewAnnotationsForClass");
        ADJUST_RANGE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsAdjustRange");
        TOGGLE_VALUE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsToggleValue");
        MODIFY_VALUE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsModifyValue");
        WATCH_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsWatch");
        INSPECT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsInspect");
        WATCH_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsWatchClassLoader");
        INSPECT_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsInspectClassLoader");
        GOTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsGoto");
        GOTO_DECLARED_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsGotoDeclared");
        GOTO_FIELD_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsGotoField");
        USE_FILTERS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsUseFilters");
        OBJECT_PREFERENCES_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsObjectPreferences");
        COLLAPSE_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsCollapseAll");
        SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsSave");
        SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLocalsSettings");
    }

    static LocalsWindowSettings ra$localsWindowSettings(LocalsWindow localsWindow) {
        return localsWindow.localsWindowSettings;
    }

    static int ra$SETTINGS_CMD_ID() {
        return SETTINGS_CMD_ID;
    }

    static IdeAction ra$actionSettings() {
        return actionSettings;
    }

    static JMenuItem ra$menuitemSettings() {
        return menuitemSettings;
    }

    static void wa$menuitemSettings(JMenuItem jMenuItem) {
        menuitemSettings = jMenuItem;
    }

    static IdeAction ra$actionViewWhole() {
        return actionViewWhole;
    }

    static IdeAction ra$actionViewAnnotations() {
        return actionViewAnnotations;
    }

    static IdeAction ra$actionViewAnnotationsForClass() {
        return actionViewAnnotationsForClass;
    }

    static IdeAction ra$actionAdjustRange() {
        return actionAdjustRange;
    }

    static IdeAction ra$actionToggleValue() {
        return actionToggleValue;
    }

    static IdeAction ra$actionModifyValue() {
        return actionModifyValue;
    }

    static IdeAction ra$actionWatch() {
        return actionWatch;
    }

    static IdeAction ra$actionInspect() {
        return actionInspect;
    }

    static IdeAction ra$actionWatchClassLoader() {
        return actionWatchClassLoader;
    }

    static IdeAction ra$actionInspectClassLoader() {
        return actionInspectClassLoader;
    }

    static IdeAction ra$actionGoto() {
        return actionGoto;
    }

    static IdeAction ra$actionGotoDeclared() {
        return actionGotoDeclared;
    }

    static IdeAction ra$actionGotoField() {
        return actionGotoField;
    }

    static IdeAction ra$actionUseFilters() {
        return actionUseFilters;
    }

    static IdeAction ra$actionObjectPreferences() {
        return actionObjectPreferences;
    }

    static IdeAction ra$actionCollapseAll() {
        return actionCollapseAll;
    }

    static IdeAction ra$actionSave() {
        return actionSave;
    }

    static int ra$VIEW_WHOLE_CMD_ID() {
        return VIEW_WHOLE_CMD_ID;
    }

    static int ra$VIEW_ANNOTATIONS_CMD_ID() {
        return VIEW_ANNOTATIONS_CMD_ID;
    }

    static int ra$VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID() {
        return VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID;
    }

    static int ra$ADJUST_RANGE_CMD_ID() {
        return ADJUST_RANGE_CMD_ID;
    }

    static int ra$TOGGLE_VALUE_CMD_ID() {
        return TOGGLE_VALUE_CMD_ID;
    }

    static int ra$MODIFY_VALUE_CMD_ID() {
        return MODIFY_VALUE_CMD_ID;
    }

    static int ra$WATCH_CMD_ID() {
        return WATCH_CMD_ID;
    }

    static int ra$INSPECT_CMD_ID() {
        return INSPECT_CMD_ID;
    }

    static int ra$WATCH_CLASSLOADER_CMD_ID() {
        return WATCH_CLASSLOADER_CMD_ID;
    }

    static int ra$INSPECT_CLASSLOADER_CMD_ID() {
        return INSPECT_CLASSLOADER_CMD_ID;
    }

    static int ra$GOTO_CMD_ID() {
        return GOTO_CMD_ID;
    }

    static int ra$GOTO_DECLARED_CMD_ID() {
        return GOTO_DECLARED_CMD_ID;
    }

    static int ra$GOTO_FIELD_CMD_ID() {
        return GOTO_FIELD_CMD_ID;
    }

    static int ra$USE_FILTERS_CMD_ID() {
        return USE_FILTERS_CMD_ID;
    }

    static int ra$OBJECT_PREFERENCES_CMD_ID() {
        return OBJECT_PREFERENCES_CMD_ID;
    }

    static int ra$COLLAPSE_ALL_CMD_ID() {
        return COLLAPSE_ALL_CMD_ID;
    }

    static int ra$SAVE_CMD_ID() {
        return SAVE_CMD_ID;
    }

    final class LocalsPanel
    extends DataPanel {
        LocalsPanel() {
            super(LocalsWindow.this, LocalsWindow.ra$localsWindowSettings(LocalsWindow.this).getDataPanelSettings());
            this._actionViewWhole = LocalsWindow.ra$actionViewWhole();
            this._actionViewAnnotations = LocalsWindow.ra$actionViewAnnotations();
            this._actionViewAnnotationsForClass = LocalsWindow.ra$actionViewAnnotationsForClass();
            this._actionAdjustRange = LocalsWindow.ra$actionAdjustRange();
            this._actionToggleValue = LocalsWindow.ra$actionToggleValue();
            this._actionModifyValue = LocalsWindow.ra$actionModifyValue();
            this._actionWatch = LocalsWindow.ra$actionWatch();
            this._actionInspect = LocalsWindow.ra$actionInspect();
            this._actionWatchClassLoader = LocalsWindow.ra$actionWatchClassLoader();
            this._actionInspectClassLoader = LocalsWindow.ra$actionInspectClassLoader();
            this._actionGoto = LocalsWindow.ra$actionGoto();
            this._actionGotoDeclared = LocalsWindow.ra$actionGotoDeclared();
            this._actionGotoField = LocalsWindow.ra$actionGotoField();
            this._actionUseFilters = LocalsWindow.ra$actionUseFilters();
            this._actionObjectPreferences = LocalsWindow.ra$actionObjectPreferences();
            this._actionCollapseAll = LocalsWindow.ra$actionCollapseAll();
            this._actionSave = LocalsWindow.ra$actionSave();
            this._VIEW_WHOLE_CMD_ID = LocalsWindow.ra$VIEW_WHOLE_CMD_ID();
            this._VIEW_ANNOTATIONS_CMD_ID = LocalsWindow.ra$VIEW_ANNOTATIONS_CMD_ID();
            this._VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID = LocalsWindow.ra$VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID();
            this._ADJUST_RANGE_CMD_ID = LocalsWindow.ra$ADJUST_RANGE_CMD_ID();
            this._TOGGLE_VALUE_CMD_ID = LocalsWindow.ra$TOGGLE_VALUE_CMD_ID();
            this._MODIFY_VALUE_CMD_ID = LocalsWindow.ra$MODIFY_VALUE_CMD_ID();
            this._WATCH_CMD_ID = LocalsWindow.ra$WATCH_CMD_ID();
            this._INSPECT_CMD_ID = LocalsWindow.ra$INSPECT_CMD_ID();
            this._WATCH_CLASSLOADER_CMD_ID = LocalsWindow.ra$WATCH_CLASSLOADER_CMD_ID();
            this._INSPECT_CLASSLOADER_CMD_ID = LocalsWindow.ra$INSPECT_CLASSLOADER_CMD_ID();
            this._GOTO_CMD_ID = LocalsWindow.ra$GOTO_CMD_ID();
            this._GOTO_DECLARED_CMD_ID = LocalsWindow.ra$GOTO_DECLARED_CMD_ID();
            this._GOTO_FIELD_CMD_ID = LocalsWindow.ra$GOTO_FIELD_CMD_ID();
            this._USE_FILTERS_CMD_ID = LocalsWindow.ra$USE_FILTERS_CMD_ID();
            this._OBJECT_PREFERENCES_CMD_ID = LocalsWindow.ra$OBJECT_PREFERENCES_CMD_ID();
            this._COLLAPSE_ALL_CMD_ID = LocalsWindow.ra$COLLAPSE_ALL_CMD_ID();
            this._SAVE_CMD_ID = LocalsWindow.ra$SAVE_CMD_ID();
        }

        protected void addPopupMenuItemsForCommon(ContextMenu popup, Context context) {
            super.addPopupMenuItemsForCommon(popup, context);
            this.update(LocalsWindow.ra$actionSettings(), context);
            if (LocalsWindow.ra$actionSettings().isEnabled()) {
                if (LocalsWindow.ra$menuitemSettings() == null) {
                    LocalsWindow.wa$menuitemSettings(popup.createMenuItem((ToggleAction)LocalsWindow.ra$actionSettings()));
                }
                popup.add((Component)LocalsWindow.ra$menuitemSettings(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
            }
        }

        public boolean update(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (action.getValue("Debugger.actionOwner") == this) {
                if (this.treeTable == null || !this.dockableWindow.isVisible()) {
                    action.setEnabled(false);
                    return true;
                }
                if (!(this.treeTable.isEnabled() && this.debuggingProcess != null && this.vm != null || cmdId == LocalsWindow.ra$SETTINGS_CMD_ID())) {
                    action.setEnabled(false);
                    return true;
                }
            }
            if (cmdId == LocalsWindow.ra$SETTINGS_CMD_ID()) {
                action.setEnabled(true);
                return true;
            }
            return super.update(action, context);
        }

        public boolean handleEvent(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (cmdId == LocalsWindow.ra$SETTINGS_CMD_ID()) {
                String[] path = new String[]{DbgArb.getString(16), DbgArb.getString(816)};
                Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), path);
                return true;
            }
            return super.handleEvent(action, context);
        }

        protected void addDataItems() {
            DebugLocation location;
            DebugDataObjectInfo currentThrow;
            List root = this.getRoot();
            if (this.vm != null && this.thread != null && this.thread.equals(this.vm.getCurrentThread()) && this.frame != null && this.frame.getFrameNumber() == 0 && (currentThrow = this.vm.getCurrentThrow()) != null) {
                String part = BaseEvaluator.getThrowExpressionPart();
                root.add(new DataPanel.DataItem(currentThrow, part, part));
            }
            if (this.frame != null) {
                DebugStackSlotInfo[] slots;
                int sLength;
                DebugVariableInfo[] a = this.frame.listArguments();
                int aLength = a.length;
                DebugVariableInfo[] l = this.frame.listLocals();
                int lLength = l.length;
                DebugFieldInfo[] sv = this.getSyntheticValues(a);
                int svLength = sv.length;
                boolean localVariableTablePresent = lLength > 0;
                int length = aLength + lLength + svLength;
                if (length > 0) {
                    Object[] vars = new Object[length];
                    if (aLength > 0) {
                        System.arraycopy(a, 0, vars, 0, aLength);
                    }
                    if (lLength > 0) {
                        System.arraycopy(l, 0, vars, aLength, lLength);
                    }
                    if (svLength > 0) {
                        System.arraycopy(sv, 0, vars, aLength + lLength, svLength);
                    }
                    if (LocalsWindow.ra$localsWindowSettings(LocalsWindow.this).isSortVarsByName()) {
                        Arrays.sort(vars, new 1());
                    }
                    int i = 0;
                    while (i < length) {
                        if (vars[i] instanceof DebugFieldInfo) {
                            DebugFieldInfo field = (DebugFieldInfo)vars[i];
                            String realName = this.getDisplayName(field);
                            root.add(new DataPanel.DataItem(field, realName, realName));
                        } else {
                            DebugVariableInfo var = (DebugVariableInfo)vars[i];
                            if (!LocalsWindow.ra$localsWindowSettings(LocalsWindow.this).isHideOutOfScopeVars() || var.isInScope()) {
                                if (var.getName().startsWith("<")) {
                                    int iSlot = 0;
                                    while (iSlot < aLength) {
                                        if (var == a[iSlot]) {
                                            String slotExpr = BaseEvaluator.getSlotExpressionPartPrefix() + iSlot;
                                            root.add(new DataPanel.DataItem(var, slotExpr, slotExpr));
                                            break;
                                        }
                                        ++iSlot;
                                    }
                                } else {
                                    if (!var.getName().equals("this")) {
                                        localVariableTablePresent = true;
                                    }
                                    root.add(new DataPanel.DataItem(var));
                                }
                            }
                        }
                        ++i;
                    }
                }
                if (!localVariableTablePresent && (sLength = (slots = this.frame.listSlots()).length) > 0) {
                    int countArgSlots = 0;
                    int i = 0;
                    while (i < aLength) {
                        countArgSlots += a[i].getSlotSize();
                        ++i;
                    }
                    int i2 = countArgSlots;
                    while (i2 < sLength) {
                        String slotExpr = BaseEvaluator.getSlotExpressionPartPrefix() + i2;
                        root.add(new DataPanel.DataItem(slots[i2], slotExpr, slotExpr));
                        ++i2;
                    }
                }
            }
            if (this.thread != null && this.frame != null && this.frame.getFrameNumber() == 0) {
                DebugDataInfo data;
                DebugDataInfo data2;
                boolean addedReturnValue = false;
                DebugVariableInfo var = this.thread.getReturnValue();
                if (var != null && (data2 = var.getDataInfo()) != null) {
                    String part = BaseEvaluator.getReturnExpressionPart();
                    root.add(new DataPanel.DataItem(var, part, part));
                    addedReturnValue = true;
                }
                if (!addedReturnValue && (var = this.thread.getReturnedValue()) != null && (data = var.getDataInfo()) != null) {
                    String part = BaseEvaluator.getReturnedExpressionPart();
                    root.add(new DataPanel.DataItem(var, part, part));
                }
            }
            if (this.frame != null && LocalsWindow.ra$localsWindowSettings(LocalsWindow.this).isShowStaticFolder() && (location = this.frame.getLocation()) != null) {
                DebugClassInfo clazz = location.getClassInfo();
                String className = clazz.getName();
                if (className.startsWith("$Oracle.")) {
                    if (className.startsWith("$Oracle.PackageBody.")) {
                        DebugClassInfo bodyClass = clazz;
                        DataPanel.DataItem bodyFolder = new DataPanel.DataItem(bodyClass);
                        root.add(bodyFolder);
                        FastStringBuffer sb = new FastStringBuffer(className);
                        int i = 0;
                        while (i < 4) {
                            sb.removeCharAt(15);
                            ++i;
                        }
                        String specClassName = sb.toString();
                        DebugClassInfo specClass = this.vm.findFirstClassByName(specClassName);
                        DataPanel.DataItem specFolder = new DataPanel.DataItem(specClass);
                        root.add(specFolder);
                    } else if (className.startsWith("$Oracle.Package.")) {
                        DebugClassInfo specClass = clazz;
                        DataPanel.DataItem specFolder = new DataPanel.DataItem(specClass);
                        root.add(specFolder);
                    }
                } else if (clazz.getLanguage() != 8 && clazz.getLanguage() != 16) {
                    String outerClassName;
                    DebugClassInfo outerClass;
                    int firstDollar = className.indexOf(36);
                    if (firstDollar != -1 && (outerClass = this.vm.findFirstClassByName(outerClassName = className.substring(0, firstDollar))) != null) {
                        clazz = outerClass;
                    }
                    DataPanel.DataItem staticFolder = new DataPanel.DataItem(clazz);
                    root.add(staticFolder);
                }
            }
        }

        private String getDisplayName(Object o) {
            String name;
            if (o instanceof DebugFieldInfo) {
                name = ((DebugFieldInfo)o).getName();
                if (name.startsWith("val$")) {
                    name = name.substring(4);
                }
                if (name.startsWith("v$")) {
                    name = name.substring(2);
                }
            } else {
                name = ((DebugVariableInfo)o).getName();
            }
            return name;
        }

        private DebugFieldInfo[] getSyntheticValues(DebugVariableInfo[] args) {
            ArrayList<DebugFieldInfo> temp = new ArrayList<DebugFieldInfo>();
            int length = args.length;
            int i = 0;
            while (i < length) {
                if (args[i].getName().equals("this")) {
                    DebugDataObjectInfo o;
                    DebugClassInfo clazz;
                    DebugDataInfo data = args[i].getDataInfo();
                    if (!(data instanceof DebugDataObjectInfo) || (clazz = (o = (DebugDataObjectInfo)data).getClassInfo()) == null || clazz.getName().indexOf(36) == -1) break;
                    DebugFieldInfo[] fields = o.getFields(0, false, true, false);
                    int fieldsLength = fields.length;
                    int f = 0;
                    while (f < fieldsLength) {
                        DebugFieldInfo field = fields[f];
                        String name = field.getName();
                        if (name.startsWith("val$")) {
                            temp.add(field);
                        } else if (name.startsWith("v$")) {
                            temp.add(field);
                        }
                        ++f;
                    }
                    break;
                }
                ++i;
            }
            return temp.toArray(new DebugFieldInfo[temp.size()]);
        }

        static String mav$getDisplayName(LocalsPanel localsPanel, Object object) {
            return localsPanel.getDisplayName(object);
        }

        final class 1
        implements Comparator {
            public int compare(Object o1, Object o2) {
                String name1 = LocalsPanel.mav$getDisplayName(LocalsPanel.this, o1);
                String name2 = LocalsPanel.mav$getDisplayName(LocalsPanel.this, o2);
                return name1.compareToIgnoreCase(name2);
            }
        }
    }
}

