/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.runner.debug.DataPanelSettingsPanel;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.LocalsWindowSettings;

public final class LocalsWindowSettingsPanel
extends DefaultTraversablePanel {
    private DataPanelSettingsPanel dataPanel;
    private JCheckBox sortVarsByNameCheckBox;
    private JCheckBox showStaticFolderCheckBox;
    private JCheckBox hideOutOfScopeVarsCheckBox;
    private JLabel spacerLabel;

    private void $init$() {
        this.dataPanel = new DataPanelSettingsPanel();
        this.sortVarsByNameCheckBox = new JCheckBox();
        this.showStaticFolderCheckBox = new JCheckBox();
        this.hideOutOfScopeVarsCheckBox = new JCheckBox();
        this.spacerLabel = new JLabel();
    }

    public LocalsWindowSettingsPanel() {
        this.$init$();
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_deb_datawindowsettingspanel_html");
        this.setLayout(new GridBagLayout());
        ResourceUtils.resButton((AbstractButton)this.sortVarsByNameCheckBox, (String)DbgArb.getString(101));
        ResourceUtils.resButton((AbstractButton)this.showStaticFolderCheckBox, (String)DbgArb.getString(826));
        ResourceUtils.resButton((AbstractButton)this.hideOutOfScopeVarsCheckBox, (String)DbgArb.getString(769));
        this.spacerLabel.setEnabled(false);
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0);
        this.add(this.dataPanel.makeChooseColumnsPanel(null), constraints);
        ++constraints.gridy;
        constraints.insets.top = 8;
        this.add(this.dataPanel.makeSortPanel(this.sortVarsByNameCheckBox), constraints);
        ++constraints.gridy;
        this.add(this.dataPanel.makeShowPanel(this.showStaticFolderCheckBox), constraints);
        ++constraints.gridy;
        this.add(this.dataPanel.makeHidePanel(this.hideOutOfScopeVarsCheckBox), constraints);
        ++constraints.gridy;
        constraints.weighty = 1.0;
        this.add(this.spacerLabel, constraints);
    }

    private LocalsWindowSettings getData(TraversableContext tc) {
        return LocalsWindowSettings.getInstance(tc.getPropertyStorage());
    }

    public void onEntry(TraversableContext tc) {
        LocalsWindowSettings settings = this.getData(tc);
        this.dataPanel.onEntry(settings.getDataPanelSettings());
        this.sortVarsByNameCheckBox.setSelected(settings.isSortVarsByName());
        this.showStaticFolderCheckBox.setSelected(settings.isShowStaticFolder());
        this.hideOutOfScopeVarsCheckBox.setSelected(settings.isHideOutOfScopeVars());
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        LocalsWindowSettings settings = this.getData(tc);
        this.dataPanel.onExit(settings.getDataPanelSettings());
        settings.setSortVarsByName(this.sortVarsByNameCheckBox.isSelected());
        settings.setShowStaticFolder(this.showStaticFolderCheckBox.isSelected());
        settings.setHideOutOfScopeVars(this.hideOutOfScopeVarsCheckBox.isSelected());
    }
}

