/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.runner.SmartDataProvider;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.BaseEvaluator;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.SmartWindowSettings;
import oracle.jdevimpl.runner.debug.SourceIcon;

class LocationInfo {
    private DebugStackFrameInfo savedFrame;
    private DebugLocation location;
    private DebugMethodInfo method;
    private CodeEditor codeEditor;
    private int line;
    private List<String> expressions;
    private int numberOfLines;

    LocationInfo(DebuggingProcess debuggingProcess, DebugStackFrameInfo frame) {
        this.savedFrame = frame;
        this.location = frame.getLocation();
        this.method = this.location != null ? this.location.getMethod() : null;
        SourceIcon sourceIconForIP = debuggingProcess.getSourceIconForIP();
        if (sourceIconForIP != null) {
            this.codeEditor = sourceIconForIP.getCodeEditor();
            this.line = sourceIconForIP.getLine();
        }
    }

    boolean isSameFrame(DebugStackFrameInfo otherFrame) {
        return this.savedFrame == otherFrame;
    }

    DebugMethodInfo getMethod() {
        return this.method;
    }

    private boolean isAtStartOfMethod() {
        if (this.location != null) {
            int bytecodeOffset = this.location.getBytecodeOffset();
            if (this.method != null && this.method.getNameWithoutClassOrSignature().equals("<init>") ? bytecodeOffset <= 4 : bytecodeOffset == 0) {
                return true;
            }
        }
        return false;
    }

    List getExpressions(SmartWindowSettings smartWindowSettings, DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo frame) {
        block21: {
            if (this.expressions == null || this.numberOfLines != smartWindowSettings.getNumberOfLines()) {
                this.expressions = new ArrayList<String>();
                if (this.isAtStartOfMethod()) {
                    DebugVariableInfo[] args = frame.listArguments();
                    int argsLength = args.length;
                    int i = 0;
                    while (i < argsLength) {
                        this.expressions.add(args[i].getName());
                        ++i;
                    }
                } else if (this.method != null && (this.method.getAccess() & 8) == 0) {
                    this.expressions.add("this");
                }
                if (vm != null && vm.getCurrentThrow() != null) {
                    this.expressions.add(BaseEvaluator.getThrowExpressionPart());
                }
                if (thread != null) {
                    if (thread.getReturnValue() != null) {
                        this.expressions.add(BaseEvaluator.getReturnExpressionPart());
                    } else if (thread.getReturnedValue() != null) {
                        this.expressions.add(BaseEvaluator.getReturnedExpressionPart());
                    }
                }
                this.numberOfLines = smartWindowSettings.getNumberOfLines();
                try {
                    Context context;
                    Node node;
                    if (this.codeEditor == null || this.line <= 0 || !((node = (context = this.codeEditor.getContext()).getNode()) instanceof TextNode)) break block21;
                    int startOffset = this.codeEditor.getLineStartOffset(this.line);
                    int endOffset = startOffset + 1;
                    int endLine = this.line + this.numberOfLines - 1;
                    while (endLine >= this.line) {
                        try {
                            endOffset = this.codeEditor.getLineEndOffset(endLine);
                            if (endOffset >= startOffset) {
                                break;
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        --endLine;
                    }
                    TextNode textNode = (TextNode)node;
                    TextBuffer tb = textNode.acquireTextBuffer();
                    tb.readLock();
                    try {
                        List<SmartDataProvider> smartDataProviders = JDebugger.getSmartDataProviders();
                        int i = smartDataProviders.size() - 1;
                        while (i >= 0) {
                            SmartDataProvider smartDataProvider = smartDataProviders.get(i);
                            if (smartDataProvider.canUnderstand(node)) {
                                smartDataProvider.getExpressions((ReadTextBuffer)tb, startOffset, endOffset, this.expressions);
                            }
                            --i;
                        }
                    }
                    finally {
                        tb.readUnlock();
                        textNode.releaseTextBuffer();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return this.expressions;
    }
}

