/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.DefaultCaret;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.Encodings;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.editor.EditorProperties;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugArrayElementInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataArrayInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugPinListener;
import oracle.jdevimpl.debugger.support.DebugPinnedInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.ModifyValueDialog;

final class MemoViewDialog
extends JPanel
implements ItemListener,
ActionListener,
CaretListener {
    private DebugDataCompositeInfo dci;
    private Object memo;
    private MakeString makeString;
    private JCheckBox wrapTextCheckbox;
    private JCheckBox viewAsStringCheckbox;
    private JLabel encodingsLabel;
    private JComboBox encodingsComboBox;
    private JTextArea textArea;
    private JButton modifyButton;
    private Font font;
    private static boolean HEX_INDEXES = false;
    private static char[] hexDigits = null;
    private static char[] hexBuf = null;
    private static char[] decDigits = null;
    private static char[] decBuf = null;

    static void showMemoViewDialog(String title, String type, String name, DebugDataCompositeInfo dci) {
        MemoViewDialog panel = new MemoViewDialog(type, name, dci);
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_deb_show_wholevaluedialog_html");
        OnePageWizardDialogFactory.runDialog((Component)panel, (Component)panel.textArea, (String)title, (int)5);
    }

    private MemoViewDialog(String type, String name, DebugDataCompositeInfo dci) {
        super(new GridBagLayout());
        this.dci = dci;
        this.makeMemo();
        this.makeString = new MakeString();
        JLabel label = new JLabel(type + " " + name);
        Container panel1 = null;
        if (this.memo instanceof byte[] || this.memo instanceof char[] || this.memo instanceof String) {
            this.viewAsStringCheckbox = new JCheckBox();
            this.wrapTextCheckbox = new JCheckBox();
            if (this.memo instanceof String || this.memo instanceof char[]) {
                this.viewAsStringCheckbox.setSelected(true);
            }
            ResourceUtils.resButton((AbstractButton)this.viewAsStringCheckbox, (String)DbgArb.getString(963));
            ResourceUtils.resButton((AbstractButton)this.wrapTextCheckbox, (String)DbgArb.getString(898));
            if (panel1 == null) {
                panel1 = new JPanel(new FlowLayout(0, 5, 5));
            }
            panel1.add(this.viewAsStringCheckbox);
            panel1.add(this.wrapTextCheckbox);
        }
        if (this.memo instanceof byte[]) {
            this.encodingsLabel = new JLabel();
            this.encodingsComboBox = new JComboBox();
            ResourceUtils.resLabel((JLabel)this.encodingsLabel, (Component)this.encodingsComboBox, (String)DbgArb.getString(783));
            Object[] encodings = Encodings.getEncodings();
            String defaultEncoding = Encodings.getDefaultEncoding();
            this.encodingsComboBox.setModel(new NonNullableComboBoxModel(encodings));
            this.encodingsComboBox.setSelectedItem(defaultEncoding);
            if (panel1 == null) {
                panel1 = new JPanel(new FlowLayout(0, 5, 5));
            }
            panel1.add(this.encodingsLabel);
            panel1.add(this.encodingsComboBox);
        }
        this.textArea = new JTextArea();
        this.font = EditorProperties.getProperties().getBaseFont();
        this.textArea.setCaret(new 1());
        this.textArea.setFont(this.font);
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(false);
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        if (dci instanceof DebugDataArrayInfo) {
            this.modifyButton = new JButton();
            ResourceUtils.resButton((AbstractButton)this.modifyButton, (String)DbgArb.getString(492));
        }
        int y = 0;
        this.add((Component)label, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        if (panel1 != null) {
            this.add((Component)panel1, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        }
        this.add((Component)scrollPane, new GridBagConstraints(0, y, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 5, 0, 5), 0, 0));
        if (this.modifyButton != null) {
            this.add((Component)this.modifyButton, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        }
        this.setPreferredSize(new Dimension(762, 306));
        if (this.viewAsStringCheckbox != null) {
            this.viewAsStringCheckbox.addItemListener(this);
        }
        if (this.wrapTextCheckbox != null) {
            this.wrapTextCheckbox.addItemListener(this);
        }
        if (this.encodingsLabel != null) {
            this.encodingsComboBox.addItemListener(this);
        }
        if (this.modifyButton != null) {
            this.textArea.addCaretListener(this);
            this.modifyButton.addActionListener(this);
        }
        this.updateTextArea();
    }

    private void makeMemo() {
        this.memo = this.dci.getWholeThing();
        if (this.memo instanceof String && this.dci instanceof DebugDataArrayInfo) {
            this.memo = ((String)this.memo).toCharArray();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        this.updateTextArea();
    }

    public void caretUpdate(CaretEvent e) {
        this.modifyButton.setEnabled(this.canModify());
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.modifyButton) {
            this.modify();
        }
    }

    private void updateTextArea() {
        this.makeString.makeString();
        if (this.viewAsStringCheckbox != null && this.wrapTextCheckbox != null) {
            if (this.viewAsStringCheckbox.isSelected()) {
                this.wrapTextCheckbox.setEnabled(true);
            } else {
                this.wrapTextCheckbox.setEnabled(false);
            }
            if (this.wrapTextCheckbox.isSelected()) {
                this.textArea.setLineWrap(true);
            } else {
                this.textArea.setLineWrap(false);
            }
        }
        this.textArea.setText(this.makeString.getResult());
        this.textArea.setSelectionStart(0);
        this.textArea.setSelectionEnd(0);
    }

    private boolean canModify() {
        try {
            if (this.dci instanceof DebugDataArrayInfo && this.makeString.isModifyableNow()) {
                int i = this.makeString.getArrayIndexFromStringOffsets(this.textArea.getSelectionStart(), this.textArea.getSelectionEnd());
                DebugDataArrayInfo dai = (DebugDataArrayInfo)this.dci;
                int arrayStart = dai.getArrayStart();
                int arrayCount = dai.getArrayCount();
                boolean bl = arrayStart <= i && (arrayCount == -1 || i < arrayStart + arrayCount);
                return bl;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    private void modify() {
        try {
            if (this.dci instanceof DebugDataArrayInfo && this.makeString.isModifyableNow()) {
                DebugDataInfo data;
                DebugArrayElementInfo[] elements;
                int start = this.textArea.getSelectionStart();
                int end = this.textArea.getSelectionEnd();
                int i = this.makeString.getArrayIndexFromStringOffsets(start, end);
                DebugDataArrayInfo dai = (DebugDataArrayInfo)this.dci;
                int arrayStart = dai.getArrayStart();
                int arrayCount = dai.getArrayCount();
                if (arrayStart <= i && (arrayCount == -1 || i < arrayStart + arrayCount) && (elements = dai.getArrayElements(i, 1)) != null && elements.length == 1 && (data = elements[0].getDataInfo()) != null && data.canModifyDataWithString()) {
                    DebugClassInfo actualClassInfo;
                    String currentValue;
                    String displayName;
                    DebugPinnedInfo pinned = dai.pinObject(new 2());
                    DebugClassInfo declaredClassInfo = dai.getArrayElementClassInfo();
                    String displayType = DebugShared.makeCourtesyClassName(declaredClassInfo, true);
                    boolean ok = ModifyValueDialog.showModifyValueDialog(displayType, displayName = "[" + i + "]", currentValue = "0x" + data.getHexValue() + "    " + data.getValue(), null, actualClassInfo = data.getClassInfo(), data, true, false, false);
                    if (ok) {
                        if (this.dci != null) {
                            this.dci = pinned.getDataInfo();
                            this.makeMemo();
                        }
                        pinned.unpinObject();
                        pinned = null;
                        this.makeString.clear();
                        this.updateTextArea();
                        this.textArea.setSelectionStart(start);
                        this.textArea.setSelectionEnd(end);
                        JDebugger.getInstance().dataHasBeenModified();
                    }
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private static void initHexStuff() {
        if (hexDigits == null) {
            hexDigits = new char[16];
            MemoViewDialog.hexDigits[0] = 48;
            MemoViewDialog.hexDigits[1] = 49;
            MemoViewDialog.hexDigits[2] = 50;
            MemoViewDialog.hexDigits[3] = 51;
            MemoViewDialog.hexDigits[4] = 52;
            MemoViewDialog.hexDigits[5] = 53;
            MemoViewDialog.hexDigits[6] = 54;
            MemoViewDialog.hexDigits[7] = 55;
            MemoViewDialog.hexDigits[8] = 56;
            MemoViewDialog.hexDigits[9] = 57;
            MemoViewDialog.hexDigits[10] = 65;
            MemoViewDialog.hexDigits[11] = 66;
            MemoViewDialog.hexDigits[12] = 67;
            MemoViewDialog.hexDigits[13] = 68;
            MemoViewDialog.hexDigits[14] = 69;
            MemoViewDialog.hexDigits[15] = 70;
        }
        if (hexBuf == null) {
            String s = Long.toHexString(Long.MAX_VALUE);
            hexBuf = new char[s.length()];
        }
    }

    private static void appendHex(int i, int hexLength, StringBuffer sb) {
        int nl = hexLength;
        while (--nl >= 0) {
            MemoViewDialog.hexBuf[nl] = hexDigits[i & 0xF];
            i >>= 4;
        }
        sb.append(hexBuf, 0, hexLength);
    }

    private static void appendHex(long l, int hexLength, StringBuffer sb) {
        int nl = hexLength;
        while (--nl >= 0) {
            MemoViewDialog.hexBuf[nl] = hexDigits[(int)l & 0xF];
            l >>= 4;
        }
        sb.append(hexBuf, 0, hexLength);
    }

    private static void initDecStuff() {
        if (decDigits == null) {
            decDigits = new char[10];
            MemoViewDialog.decDigits[0] = 48;
            MemoViewDialog.decDigits[1] = 49;
            MemoViewDialog.decDigits[2] = 50;
            MemoViewDialog.decDigits[3] = 51;
            MemoViewDialog.decDigits[4] = 52;
            MemoViewDialog.decDigits[5] = 53;
            MemoViewDialog.decDigits[6] = 54;
            MemoViewDialog.decDigits[7] = 55;
            MemoViewDialog.decDigits[8] = 56;
            MemoViewDialog.decDigits[9] = 57;
        }
        if (decBuf == null) {
            String s = Long.toString(Long.MAX_VALUE);
            decBuf = new char[s.length()];
        }
    }

    private static void appendDec(int i, int decLength, StringBuffer sb) {
        int nl = decLength;
        while (--nl >= 0) {
            if (i > 0) {
                MemoViewDialog.decBuf[nl] = decDigits[i % 10];
                i /= 10;
                continue;
            }
            MemoViewDialog.decBuf[nl] = 48;
        }
        sb.append(decBuf, 0, decLength);
    }

    private static void appendDec(long l, int decLength, StringBuffer sb) {
        int nl = decLength;
        while (--nl >= 0) {
            if (l > 0L) {
                MemoViewDialog.decBuf[nl] = decDigits[(int)l % 10];
                l /= (long)10;
                continue;
            }
            MemoViewDialog.decBuf[nl] = 48;
        }
        sb.append(decBuf, 0, decLength);
    }

    private static void appendIndexRange(int i, int itemsPerRow, int count, int indexLength, StringBuffer sb) {
        sb.append('[');
        int firstIndex = i;
        if (HEX_INDEXES) {
            MemoViewDialog.appendHex(firstIndex, indexLength, sb);
        } else {
            MemoViewDialog.appendDec(firstIndex, indexLength, sb);
        }
        sb.append("..");
        int lastIndex = i + itemsPerRow - 1;
        if (lastIndex > count - 1) {
            lastIndex = count - 1;
        }
        if (HEX_INDEXES) {
            MemoViewDialog.appendHex(lastIndex, indexLength, sb);
        } else {
            MemoViewDialog.appendDec(lastIndex, indexLength, sb);
        }
        sb.append("] ");
    }

    static void maS$appendIndexRange(int n, int n2, int n3, int n4, StringBuffer stringBuffer) {
        MemoViewDialog.appendIndexRange(n, n2, n3, n4, stringBuffer);
    }

    static void maS$appendHex(long l, int n, StringBuffer stringBuffer) {
        MemoViewDialog.appendHex(l, n, stringBuffer);
    }

    static void maS$appendHex(int n, int n2, StringBuffer stringBuffer) {
        MemoViewDialog.appendHex(n, n2, stringBuffer);
    }

    static Font ra$font(MemoViewDialog memoViewDialog) {
        return memoViewDialog.font;
    }

    static boolean ra$HEX_INDEXES() {
        return HEX_INDEXES;
    }

    static Object ra$memo(MemoViewDialog memoViewDialog) {
        return memoViewDialog.memo;
    }

    static JCheckBox ra$viewAsStringCheckbox(MemoViewDialog memoViewDialog) {
        return memoViewDialog.viewAsStringCheckbox;
    }

    static JComboBox ra$encodingsComboBox(MemoViewDialog memoViewDialog) {
        return memoViewDialog.encodingsComboBox;
    }

    static void maS$initHexStuff() {
        MemoViewDialog.initHexStuff();
    }

    static void maS$initDecStuff() {
        MemoViewDialog.initDecStuff();
    }

    static void wa$dci(MemoViewDialog memoViewDialog, DebugDataCompositeInfo debugDataCompositeInfo) {
        memoViewDialog.dci = debugDataCompositeInfo;
    }

    final class 1
    extends DefaultCaret {
        public void focusLost(FocusEvent e) {
        }
    }

    final class 2
    implements DebugPinListener {
        public void pinnedObjectDiscarded(DebugVirtualMachine vm, DebugPinnedInfo pin) {
            MemoViewDialog.wa$dci(MemoViewDialog.this, null);
        }
    }

    class MakeString {
        private boolean viewAsString;
        private String encoding;
        private int count;
        private int hexLength;
        private int itemsPerRow;
        private int indexLength;
        private int indexRangeLength;
        private int itemLength;
        private int rowCount;
        private int beforeFirstHex;
        private int beforeFirstChar;
        private int perRow;
        private String result;

        MakeString() {
            MemoViewDialog.maS$initHexStuff();
            MemoViewDialog.maS$initDecStuff();
        }

        boolean isModifyableNow() {
            if (MemoViewDialog.ra$memo(MemoViewDialog.this) instanceof byte[]) {
                return MemoViewDialog.ra$viewAsStringCheckbox(MemoViewDialog.this).isSelected() ^ true;
            }
            if (MemoViewDialog.ra$memo(MemoViewDialog.this) instanceof char[]) {
                return MemoViewDialog.ra$viewAsStringCheckbox(MemoViewDialog.this).isSelected() ^ true;
            }
            if (MemoViewDialog.ra$memo(MemoViewDialog.this) instanceof short[]) {
                return true;
            }
            if (MemoViewDialog.ra$memo(MemoViewDialog.this) instanceof int[]) {
                return true;
            }
            return MemoViewDialog.ra$memo(MemoViewDialog.this) instanceof long[];
        }

        void makeString() {
            try {
                if (MemoViewDialog.ra$memo(MemoViewDialog.this) instanceof byte[]) {
                    boolean viewAsString = MemoViewDialog.ra$viewAsStringCheckbox(MemoViewDialog.this).isSelected();
                    String encoding = (String)MemoViewDialog.ra$encodingsComboBox(MemoViewDialog.this).getSelectedItem();
                    if (this.result == null || this.viewAsString != viewAsString || ModelUtil.areDifferent((Object)this.encoding, (Object)encoding)) {
                        this.viewAsString = viewAsString;
                        this.encoding = encoding;
                        if (viewAsString) {
                            this.result = new String((byte[])MemoViewDialog.ra$memo(MemoViewDialog.this), encoding);
                        } else {
                            this.makeBytes((byte[])MemoViewDialog.ra$memo(MemoViewDialog.this));
                        }
                    }
                } else if (MemoViewDialog.ra$memo(MemoViewDialog.this) instanceof char[]) {
                    boolean viewAsString = MemoViewDialog.ra$viewAsStringCheckbox(MemoViewDialog.this).isSelected();
                    if (this.result == null || this.viewAsString != viewAsString) {
                        this.viewAsString = viewAsString;
                        if (viewAsString) {
                            this.result = new String((char[])MemoViewDialog.ra$memo(MemoViewDialog.this));
                        } else {
                            this.makeChars((char[])MemoViewDialog.ra$memo(MemoViewDialog.this));
                        }
                    }
                } else if (MemoViewDialog.ra$memo(MemoViewDialog.this) instanceof String) {
                    boolean viewAsString = MemoViewDialog.ra$viewAsStringCheckbox(MemoViewDialog.this).isSelected();
                    if (this.result == null || this.viewAsString != viewAsString) {
                        this.viewAsString = viewAsString;
                        if (viewAsString) {
                            this.result = (String)MemoViewDialog.ra$memo(MemoViewDialog.this);
                        } else {
                            this.makeChars(((String)MemoViewDialog.ra$memo(MemoViewDialog.this)).toCharArray());
                        }
                    }
                } else if (MemoViewDialog.ra$memo(MemoViewDialog.this) instanceof short[]) {
                    if (this.result == null) {
                        this.makeShorts((short[])MemoViewDialog.ra$memo(MemoViewDialog.this));
                    }
                } else if (MemoViewDialog.ra$memo(MemoViewDialog.this) instanceof int[]) {
                    if (this.result == null) {
                        this.makeInts((int[])MemoViewDialog.ra$memo(MemoViewDialog.this));
                    }
                } else if (MemoViewDialog.ra$memo(MemoViewDialog.this) instanceof long[]) {
                    if (this.result == null) {
                        this.makeLongs((long[])MemoViewDialog.ra$memo(MemoViewDialog.this));
                    }
                } else {
                    this.result = null;
                }
            }
            catch (Exception e) {
                this.result = null;
            }
        }

        String getResult() {
            if (this.result == null) {
                return "";
            }
            return this.result;
        }

        int getArrayIndexFromStringOffsets(int start, int end) {
            if (start > end) {
                int swap = start;
                start = end;
                end = swap;
            }
            int row = start / this.perRow;
            int arrayOffset = row * this.itemsPerRow;
            int col = start % this.perRow;
            if (this.beforeFirstHex <= col && col < this.beforeFirstHex + this.itemsPerRow * this.itemLength) {
                if ((col -= this.beforeFirstHex) % this.itemLength == 0) {
                    arrayOffset += col / this.itemLength;
                    if (end == start + this.hexLength) {
                        return arrayOffset;
                    }
                }
            } else if (this.beforeFirstChar != 0 && this.beforeFirstChar <= col && col < this.beforeFirstChar + this.itemsPerRow) {
                arrayOffset += col - this.beforeFirstChar;
                if (end == start + 1) {
                    return arrayOffset;
                }
            }
            return -1;
        }

        void clear() {
            this.count = 0;
            this.hexLength = 0;
            this.itemsPerRow = 0;
            this.indexLength = 0;
            this.indexRangeLength = 0;
            this.itemLength = 0;
            this.rowCount = 0;
            this.beforeFirstHex = 0;
            this.beforeFirstChar = 0;
            this.perRow = 0;
            this.result = null;
        }

        private void setup(int arrayLength, int hexLength) {
            this.count = arrayLength;
            this.hexLength = hexLength;
            this.itemsPerRow = 32 / hexLength;
            this.indexLength = MemoViewDialog.ra$HEX_INDEXES() ? Integer.toHexString(this.count - 1).length() : Integer.toString(this.count - 1).length();
            this.indexRangeLength = 2 * this.indexLength + 5;
            this.itemLength = hexLength + 1;
            this.rowCount = this.count / this.itemsPerRow + 1;
        }

        private void makeBytes(byte[] a) {
            this.clear();
            this.setup(a.length, 2);
            StringBuffer sb = new StringBuffer(this.rowCount * this.indexRangeLength + this.count * this.itemLength);
            int i = 0;
            while (i < this.count) {
                MemoViewDialog.maS$appendIndexRange(i, this.itemsPerRow, this.count, this.indexLength, sb);
                if (this.beforeFirstHex == 0) {
                    this.beforeFirstHex = sb.length();
                }
                int offset = i;
                int j = 0;
                while (j < this.itemsPerRow) {
                    if (i < this.count) {
                        MemoViewDialog.maS$appendHex(a[i++], this.hexLength, sb);
                        sb.append(' ');
                    } else {
                        sb.append("   ");
                    }
                    ++j;
                }
                sb.append("   ");
                StringBuffer sb2 = new StringBuffer();
                try {
                    String s = new String(a, offset, i - offset, this.encoding);
                    if (MemoViewDialog.ra$font(MemoViewDialog.this).canDisplayUpTo(s) == -1) {
                        sb2.append(s);
                    } else {
                        int length = s.length();
                        int j2 = 0;
                        while (j2 < length) {
                            char c = s.charAt(j2);
                            if (MemoViewDialog.ra$font(MemoViewDialog.this).canDisplay(c)) {
                                sb2.append(c);
                            } else {
                                sb2.append(' ');
                            }
                            ++j2;
                        }
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                int max = this.itemsPerRow;
                while (sb2.length() > max) {
                    sb2.append(' ');
                }
                sb.append(sb2.toString());
                sb.append('\n');
                if (this.perRow != 0) continue;
                this.perRow = sb.length();
            }
            this.result = sb.toString();
        }

        private void makeChars(char[] a) {
            this.clear();
            this.setup(a.length, 4);
            StringBuffer sb = new StringBuffer(this.rowCount * this.indexRangeLength + this.count * this.itemLength);
            int i = 0;
            while (i < this.count) {
                MemoViewDialog.maS$appendIndexRange(i, this.itemsPerRow, this.count, this.indexLength, sb);
                if (this.beforeFirstHex == 0) {
                    this.beforeFirstHex = sb.length();
                }
                int offset = i;
                int j = 0;
                while (j < this.itemsPerRow) {
                    if (i < this.count) {
                        MemoViewDialog.maS$appendHex(a[i++], this.hexLength, sb);
                        sb.append(' ');
                    } else {
                        sb.append("     ");
                    }
                    ++j;
                }
                sb.append("   ");
                if (this.beforeFirstChar == 0) {
                    this.beforeFirstChar = sb.length();
                }
                StringBuffer sb2 = new StringBuffer();
                try {
                    String s = new String(a, offset, i - offset);
                    if (MemoViewDialog.ra$font(MemoViewDialog.this).canDisplayUpTo(s) == -1) {
                        sb2.append(s);
                    } else {
                        int length = s.length();
                        int j2 = 0;
                        while (j2 < length) {
                            char c = s.charAt(j2);
                            if (MemoViewDialog.ra$font(MemoViewDialog.this).canDisplay(c)) {
                                sb2.append(c);
                            } else {
                                sb2.append(' ');
                            }
                            ++j2;
                        }
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                int max = this.itemsPerRow;
                while (sb2.length() > max) {
                    sb2.append(' ');
                }
                sb.append(sb2.toString());
                sb.append('\n');
                if (this.perRow != 0) continue;
                this.perRow = sb.length();
            }
            this.result = sb.toString();
        }

        private void makeShorts(short[] a) {
            this.clear();
            this.setup(a.length, 4);
            StringBuffer sb = new StringBuffer(this.rowCount * this.indexRangeLength + this.count * this.itemLength);
            int i = 0;
            while (i < this.count) {
                MemoViewDialog.maS$appendIndexRange(i, this.itemsPerRow, this.count, this.indexLength, sb);
                if (this.beforeFirstHex == 0) {
                    this.beforeFirstHex = sb.length();
                }
                int j = 0;
                while (j < this.itemsPerRow) {
                    if (i < this.count) {
                        MemoViewDialog.maS$appendHex(a[i++], this.hexLength, sb);
                        sb.append(' ');
                    } else {
                        sb.append("     ");
                    }
                    ++j;
                }
                sb.append('\n');
                if (this.perRow != 0) continue;
                this.perRow = sb.length();
            }
            this.result = sb.toString();
        }

        private void makeInts(int[] a) {
            this.clear();
            this.setup(a.length, 8);
            StringBuffer sb = new StringBuffer(this.rowCount * this.indexRangeLength + this.count * this.itemLength);
            int i = 0;
            while (i < this.count) {
                MemoViewDialog.maS$appendIndexRange(i, this.itemsPerRow, this.count, this.indexLength, sb);
                if (this.beforeFirstHex == 0) {
                    this.beforeFirstHex = sb.length();
                }
                int j = 0;
                while (j < this.itemsPerRow) {
                    if (i < this.count) {
                        MemoViewDialog.maS$appendHex(a[i++], this.hexLength, sb);
                        sb.append(' ');
                    } else {
                        sb.append("         ");
                    }
                    ++j;
                }
                sb.append('\n');
                if (this.perRow != 0) continue;
                this.perRow = sb.length();
            }
            this.result = sb.toString();
        }

        private void makeLongs(long[] a) {
            this.clear();
            this.setup(a.length, 16);
            StringBuffer sb = new StringBuffer(this.rowCount * this.indexRangeLength + this.count * this.itemLength);
            int i = 0;
            while (i < this.count) {
                MemoViewDialog.maS$appendIndexRange(i, this.itemsPerRow, this.count, this.indexLength, sb);
                if (this.beforeFirstHex == 0) {
                    this.beforeFirstHex = sb.length();
                }
                int j = 0;
                while (j < this.itemsPerRow) {
                    if (i < this.count) {
                        MemoViewDialog.maS$appendHex(a[i++], this.hexLength, sb);
                        sb.append(' ');
                    } else {
                        sb.append("                 ");
                    }
                    ++j;
                }
                sb.append('\n');
                if (this.perRow != 0) continue;
                this.perRow = sb.length();
            }
            this.result = sb.toString();
        }
    }
}

