/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.Dockable;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.ide.runner.DebuggerWindowProvider;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.debugger.support.DebugMonitorInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugDockableFactory;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.DebuggerWindow;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.MonitorsWindowSettings;
import oracle.jdevimpl.runner.debug.ThreadsPanel;

final class MonitorsWindow
extends DebuggerWindow {
    private static IdeAction actionViewWhole;
    private static IdeAction actionViewAnnotations;
    private static IdeAction actionViewAnnotationsForClass;
    private static IdeAction actionAdjustRange;
    private static IdeAction actionToggleValue;
    private static IdeAction actionModifyValue;
    private static IdeAction actionWatchClassLoader;
    private static IdeAction actionInspectClassLoader;
    private static IdeAction actionGoto;
    private static IdeAction actionGotoDeclared;
    private static IdeAction actionGotoField;
    private static IdeAction actionUseFilters;
    private static IdeAction actionObjectPreferences;
    private static IdeAction actionCollapseAll;
    private static IdeAction actionSave;
    private static IdeAction actionSettings;
    private static JMenuItem menuitemNotify;
    private static JMenuItem menuitemNotifyAll;
    private static JMenuItem menuitemSettings;
    private static final int VIEW_WHOLE_CMD_ID;
    private static final int VIEW_ANNOTATIONS_CMD_ID;
    private static final int VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID;
    private static final int ADJUST_RANGE_CMD_ID;
    private static final int TOGGLE_VALUE_CMD_ID;
    private static final int MODIFY_VALUE_CMD_ID;
    private static final int WATCH_CLASSLOADER_CMD_ID;
    private static final int INSPECT_CLASSLOADER_CMD_ID;
    private static final int GOTO_CMD_ID;
    private static final int GOTO_DECLARED_CMD_ID;
    private static final int GOTO_FIELD_CMD_ID;
    private static final int USE_FILTERS_CMD_ID;
    private static final int OBJECT_PREFERENCES_CMD_ID;
    private static final int COLLAPSE_ALL_CMD_ID;
    private static final int SAVE_CMD_ID;
    private static final int SETTINGS_CMD_ID;
    private static IdeAction actionOwningThreadGoTo;
    private static IdeAction actionOwningThreadSave;
    private static IdeAction actionOwningThreadSettings;
    private static final int OWNING_THREAD_GOTO_CMD_ID;
    private static final int OWNING_THREAD_SAVE_CMD_ID;
    private static final int OWNING_THREAD_SETTINGS_CMD_ID;
    private static IdeAction actionWaitingThreadsGoTo;
    private static IdeAction actionWaitingThreadsSave;
    private static IdeAction actionWaitingThreadsSettings;
    private static final int WAITING_THREADS_GOTO_CMD_ID;
    private static final int WAITING_THREADS_SAVE_CMD_ID;
    private static final int WAITING_THREADS_SETTINGS_CMD_ID;
    private static IdeAction actionBlockedThreadsGoTo;
    private static IdeAction actionBlockedThreadsSave;
    private static IdeAction actionBlockedThreadsSettings;
    private static final int BLOCKED_THREADS_GOTO_CMD_ID;
    private static final int BLOCKED_THREADS_SAVE_CMD_ID;
    private static final int BLOCKED_THREADS_SETTINGS_CMD_ID;
    static final String MONITORS_WINDOW_ID = "Debugger.MonitorsWindow";
    private static Icon monitorsTabIcon;
    static final int OWNING_THREAD_PANEL_ID = 1;
    static final int WAITING_THREADS_PANEL_ID = 2;
    static final int BLOCKED_THREADS_PANEL_ID = 3;
    private String title;
    private MonitorsPanel monitorsPanel;
    private MonitorsThreadsPanel owningThreadPanel;
    private MonitorsThreadsPanel waitingThreadsPanel;
    private MonitorsThreadsPanel blockedThreadsPanel;
    private JSplitPane splitPane;
    private MonitorsWindowSettings monitorsWindowSettings = MonitorsWindowSettings.getInstance();

    MonitorsWindow() {
        super(MONITORS_WINDOW_ID);
        this.title = DbgArb.getString(365);
        MonitorsWindow.makeActions();
        this.owningThreadPanel = new MonitorsThreadsPanel(1, DbgArb.getString(161), 1);
        this.waitingThreadsPanel = new MonitorsThreadsPanel(2, DbgArb.getString(574), 2);
        this.blockedThreadsPanel = new MonitorsThreadsPanel(3, DbgArb.getString(491), 2);
        this.monitorsPanel = new MonitorsPanel(this.owningThreadPanel, this.waitingThreadsPanel, this.blockedThreadsPanel);
        this.setControllerForActions();
    }

    public int getDefaultVisibility(Layout layout) {
        return 0;
    }

    public Icon getTabIcon() {
        if (monitorsTabIcon == null) {
            monitorsTabIcon = DbgArb.getIcon(649);
        }
        return monitorsTabIcon;
    }

    public DebuggerWindowProvider.DebuggerWindowPosition getPosition() {
        return DebuggerWindowProvider.DebuggerWindowPosition.FLOATING;
    }

    public Rectangle getFloatingPosition() {
        Point centerOfScreen = DebugDockableFactory.getCenterOfScreen((Dockable)this);
        return new Rectangle(centerOfScreen.x, centerOfScreen.y, 400, 200);
    }

    public void refresh() {
        this.everythingChanged();
    }

    public boolean installByDefault() {
        return true;
    }

    public void shutDown() {
        this.saveSettings();
    }

    private void makeSplitPane() {
        if (this.splitPane == null) {
            this.splitPane = new JSplitPane();
            this.splitPane.setLeftComponent(this.makeLeftPanel());
            this.splitPane.setRightComponent(this.makeRightPanel());
            this.splitPane.setResizeWeight(0.5);
        }
    }

    private JPanel makeLeftPanel() {
        JPanel leftPanel = new JPanel(new GridBagLayout());
        JLabel monitorsLabel = new JLabel();
        Component monitorsComponent = this.monitorsPanel.getGUI();
        ResourceUtils.resLabel((JLabel)monitorsLabel, (Component)monitorsComponent, (String)DbgArb.getString(286));
        int y = 0;
        leftPanel.add((Component)monitorsLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        leftPanel.add(monitorsComponent, new GridBagConstraints(0, y, 0, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        return leftPanel;
    }

    private JPanel makeRightPanel() {
        JPanel rightPanel = new JPanel(new GridBagLayout());
        JLabel owningThreadLabel = new JLabel();
        JLabel waitingThreadsLabel = new JLabel();
        JLabel blockedThreadsLabel = new JLabel();
        Component owningThreadComponent = this.owningThreadPanel.getGUI();
        Component waitingThreadsComponent = this.waitingThreadsPanel.getGUI();
        Component blockedThreadsComponent = this.blockedThreadsPanel.getGUI();
        ResourceUtils.resLabel((JLabel)owningThreadLabel, (Component)owningThreadComponent, (String)DbgArb.getString(931));
        ResourceUtils.resLabel((JLabel)waitingThreadsLabel, (Component)waitingThreadsComponent, (String)DbgArb.getString(29));
        ResourceUtils.resLabel((JLabel)blockedThreadsLabel, (Component)blockedThreadsComponent, (String)DbgArb.getString(669));
        int y = 0;
        rightPanel.add((Component)owningThreadLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        rightPanel.add(owningThreadComponent, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.2, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        rightPanel.add((Component)waitingThreadsLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        rightPanel.add(waitingThreadsComponent, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.4, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        rightPanel.add((Component)blockedThreadsLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        rightPanel.add(blockedThreadsComponent, new GridBagConstraints(0, y, 0, 1, 1.0, 0.4, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        return rightPanel;
    }

    private void loadSettings() {
        this.monitorsPanel.loadSettings();
        this.owningThreadPanel.loadSettings();
        this.waitingThreadsPanel.loadSettings();
        this.blockedThreadsPanel.loadSettings();
    }

    private void debugWindowSettingsChanged(DebugWindowSettings dbgSettings) {
        this.monitorsPanel.debugWindowSettingsChanged(dbgSettings);
    }

    void setUseFilters(boolean useFilters) {
        this.monitorsPanel.setUseFilters(useFilters);
    }

    private void saveSettings() {
        this.monitorsPanel.saveSettings();
        this.owningThreadPanel.saveSettings();
        this.waitingThreadsPanel.saveSettings();
        this.blockedThreadsPanel.saveSettings();
    }

    static void addContextMenuToMainMenu(Menubar menubar, JMenu subMenu) {
        MonitorsWindow.makeActions();
        JMenu subMenu0 = menubar.createSubMenu(DbgArb.getString(907), DbgArb.getInteger(873));
        float section = 1.0f;
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionViewWhole), subMenu0, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionViewAnnotations), subMenu0, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionViewAnnotationsForClass), subMenu0, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionAdjustRange), subMenu0, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionToggleValue), subMenu0, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionModifyValue), subMenu0, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionWatchClassLoader), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionInspectClassLoader), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGoto), subMenu0, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGotoDeclared), subMenu0, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGotoField), subMenu0, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionUseFilters), subMenu0, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionObjectPreferences), subMenu0, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionCollapseAll), subMenu0, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSave), subMenu0, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSettings), subMenu0, section);
        subMenu.add(subMenu0);
        JMenu subMenu1 = menubar.createSubMenu(DbgArb.getString(772), DbgArb.getInteger(612));
        section = 1.0f;
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionOwningThreadGoTo), subMenu1, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionOwningThreadSave), subMenu1, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionOwningThreadSettings), subMenu1, section);
        subMenu.add(subMenu1);
        JMenu subMenu2 = menubar.createSubMenu(DbgArb.getString(54), DbgArb.getInteger(951));
        section = 1.0f;
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionWaitingThreadsGoTo), subMenu2, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionWaitingThreadsSave), subMenu2, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionWaitingThreadsSettings), subMenu2, section);
        subMenu.add(subMenu2);
        JMenu subMenu3 = menubar.createSubMenu(DbgArb.getString(75), DbgArb.getInteger(423));
        section = 1.0f;
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionBlockedThreadsGoTo), subMenu3, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionBlockedThreadsSave), subMenu3, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionBlockedThreadsSettings), subMenu3, section);
        subMenu.add(subMenu3);
    }

    private static void makeActions() {
        if (actionViewWhole == null) {
            actionViewWhole = IdeAction.get((int)VIEW_WHOLE_CMD_ID, null, (String)DbgArb.getString(333), null, (Integer)DbgArb.getInteger(824), null, (int)-1, null, (boolean)false);
            actionViewWhole.setEnabled(false);
            actionViewAnnotations = IdeAction.get((int)VIEW_ANNOTATIONS_CMD_ID, null, (String)DbgArb.getString(33), null, (Integer)DbgArb.getInteger(961), null, (int)-1, null, (boolean)false);
            actionViewAnnotations.putValue("NoCtxName", (Object)DbgArb.getString(33));
            actionViewAnnotations.setEnabled(false);
            actionViewAnnotationsForClass = IdeAction.get((int)VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID, null, (String)DbgArb.getString(844), null, (Integer)DbgArb.getInteger(884), null, (int)-1, null, (boolean)false);
            actionViewAnnotationsForClass.setEnabled(false);
            actionAdjustRange = IdeAction.get((int)ADJUST_RANGE_CMD_ID, null, (String)DbgArb.getString(157), null, (Integer)DbgArb.getInteger(810), null, (int)-1, null, (boolean)false);
            actionAdjustRange.setEnabled(false);
            actionToggleValue = IdeAction.get((int)TOGGLE_VALUE_CMD_ID, null, (String)DbgArb.getString(183), null, (Integer)DbgArb.getInteger(891), null, (int)-1, null, (boolean)false);
            actionToggleValue.setEnabled(false);
            actionModifyValue = IdeAction.get((int)MODIFY_VALUE_CMD_ID, null, (String)DbgArb.getString(429), null, (Integer)DbgArb.getInteger(267), null, (int)-1, null, (boolean)false);
            actionModifyValue.setEnabled(false);
            actionWatchClassLoader = IdeAction.get((int)WATCH_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(205), null, (Integer)DbgArb.getInteger(505), null, (int)-1, null, (boolean)false);
            actionWatchClassLoader.setEnabled(false);
            actionInspectClassLoader = IdeAction.get((int)INSPECT_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(273), null, (Integer)DbgArb.getInteger(921), null, (int)-1, null, (boolean)false);
            actionInspectClassLoader.setEnabled(false);
            actionGoto = IdeAction.get((int)GOTO_CMD_ID, null, (String)DbgArb.getString(389), null, (Integer)DbgArb.getInteger(598), null, (int)-1, null, (boolean)false);
            actionGoto.putValue("NoCtxName", (Object)DbgArb.getString(389));
            actionGoto.setEnabled(false);
            actionGotoDeclared = IdeAction.get((int)GOTO_DECLARED_CMD_ID, null, (String)DbgArb.getString(851), null, (Integer)DbgArb.getInteger(926), null, (int)-1, null, (boolean)false);
            actionGotoDeclared.putValue("NoCtxName", (Object)DbgArb.getString(851));
            actionGotoDeclared.setEnabled(false);
            actionGotoField = IdeAction.get((int)GOTO_FIELD_CMD_ID, null, (String)DbgArb.getString(617), null, (Integer)DbgArb.getInteger(788), null, (int)-1, null, (boolean)false);
            actionGotoField.putValue("NoCtxName", (Object)DbgArb.getString(617));
            actionGotoField.setEnabled(false);
            actionUseFilters = IdeAction.get((int)USE_FILTERS_CMD_ID, null, (String)DbgArb.getString(637), null, (Integer)DbgArb.getInteger(412), null, (int)-1, null, (boolean)false);
            actionUseFilters.putValue("Check", (Object)Boolean.TRUE);
            actionUseFilters.setEnabled(false);
            actionObjectPreferences = IdeAction.get((int)OBJECT_PREFERENCES_CMD_ID, null, (String)DbgArb.format(892, ""), null, (Integer)DbgArb.getInteger(594), null, (int)-1, null, (boolean)false);
            actionObjectPreferences.setEnabled(false);
            actionSettings = IdeAction.get((int)SETTINGS_CMD_ID, null, (String)RunMgrArb.getString(87), null, (Integer)RunMgrArb.getInteger(99), null, (int)-1, null, (boolean)false);
            actionSettings.setEnabled(false);
            actionCollapseAll = IdeAction.get((int)COLLAPSE_ALL_CMD_ID, null, (String)RunMgrArb.getString(0), null, (Integer)RunMgrArb.getInteger(7), null, (int)-1, null, (boolean)false);
            actionCollapseAll.setEnabled(false);
            actionSave = IdeAction.get((int)SAVE_CMD_ID, null, (String)RunMgrArb.getString(65), null, (Integer)RunMgrArb.getInteger(101), null, (int)-1, null, (boolean)false);
            actionSave.setEnabled(false);
            actionOwningThreadGoTo = IdeAction.get((int)OWNING_THREAD_GOTO_CMD_ID, null, (String)DbgArb.getString(66), null, (Integer)DbgArb.getInteger(483), null, (int)-1, null, (boolean)false);
            actionOwningThreadGoTo.setEnabled(false);
            actionOwningThreadSettings = IdeAction.get((int)OWNING_THREAD_SETTINGS_CMD_ID, null, (String)RunMgrArb.getString(87), null, (Integer)RunMgrArb.getInteger(99), null, (int)-1, null, (boolean)false);
            actionOwningThreadSettings.setEnabled(false);
            actionOwningThreadSave = IdeAction.get((int)OWNING_THREAD_SAVE_CMD_ID, null, (String)RunMgrArb.getString(65), null, (Integer)RunMgrArb.getInteger(101), null, (int)-1, null, (boolean)false);
            actionOwningThreadSave.setEnabled(false);
            actionWaitingThreadsGoTo = IdeAction.get((int)WAITING_THREADS_GOTO_CMD_ID, null, (String)DbgArb.getString(66), null, (Integer)DbgArb.getInteger(483), null, (int)-1, null, (boolean)false);
            actionWaitingThreadsGoTo.setEnabled(false);
            actionWaitingThreadsSettings = IdeAction.get((int)WAITING_THREADS_SETTINGS_CMD_ID, null, (String)RunMgrArb.getString(87), null, (Integer)RunMgrArb.getInteger(99), null, (int)-1, null, (boolean)false);
            actionWaitingThreadsSettings.setEnabled(false);
            actionWaitingThreadsSave = IdeAction.get((int)WAITING_THREADS_SAVE_CMD_ID, null, (String)RunMgrArb.getString(65), null, (Integer)RunMgrArb.getInteger(101), null, (int)-1, null, (boolean)false);
            actionWaitingThreadsSave.setEnabled(false);
            actionBlockedThreadsGoTo = IdeAction.get((int)BLOCKED_THREADS_GOTO_CMD_ID, null, (String)DbgArb.getString(66), null, (Integer)DbgArb.getInteger(483), null, (int)-1, null, (boolean)false);
            actionBlockedThreadsGoTo.setEnabled(false);
            actionBlockedThreadsSettings = IdeAction.get((int)BLOCKED_THREADS_SETTINGS_CMD_ID, null, (String)RunMgrArb.getString(87), null, (Integer)RunMgrArb.getInteger(99), null, (int)-1, null, (boolean)false);
            actionBlockedThreadsSettings.setEnabled(false);
            actionBlockedThreadsSave = IdeAction.get((int)BLOCKED_THREADS_SAVE_CMD_ID, null, (String)RunMgrArb.getString(65), null, (Integer)RunMgrArb.getInteger(101), null, (int)-1, null, (boolean)false);
            actionBlockedThreadsSave.setEnabled(false);
        }
    }

    private void setControllerForActions() {
        IdeAction[] actions = new IdeAction[]{actionViewWhole, actionViewAnnotations, actionViewAnnotationsForClass, actionAdjustRange, actionToggleValue, actionModifyValue, actionWatchClassLoader, actionInspectClassLoader, actionGoto, actionGotoDeclared, actionGotoField, actionUseFilters, actionObjectPreferences, actionSettings, actionCollapseAll, actionSave};
        JDebugger.setControllerForActions(actions, this.monitorsPanel);
        actions = new IdeAction[]{actionOwningThreadGoTo, actionOwningThreadSettings, actionOwningThreadSave};
        JDebugger.setControllerForActions(actions, this.owningThreadPanel);
        actions = new IdeAction[]{actionWaitingThreadsGoTo, actionWaitingThreadsSettings, actionWaitingThreadsSave};
        JDebugger.setControllerForActions(actions, this.waitingThreadsPanel);
        actions = new IdeAction[]{actionBlockedThreadsGoTo, actionBlockedThreadsSettings, actionBlockedThreadsSave};
        JDebugger.setControllerForActions(actions, this.blockedThreadsPanel);
    }

    public String getMenuTitle() {
        if (!JDebugger.getInstance().canShowMonitorsWindow()) {
            return null;
        }
        return this.title;
    }

    public Component getGUI() {
        if (!JDebugger.getInstance().canShowMonitorsWindow()) {
            return null;
        }
        if (this.splitPane == null) {
            DebugWindowSettings dbgSettings = DebugWindowSettings.getInstance();
            this.makeSplitPane();
            this.loadSettings();
            this.debugWindowSettingsChanged(dbgSettings);
            this.monitorsPanel.dataPanelSettingsChanged(false);
            this.owningThreadPanel.threadsPanelSettingsChanged(false);
            this.waitingThreadsPanel.threadsPanelSettingsChanged(false);
            this.blockedThreadsPanel.threadsPanelSettingsChanged(false);
            this.splitPane.resetToPreferredSizes();
            DebugDockableFactory.updateSiteGeometry((Dockable)this);
            dbgSettings.addStructureChangeListener(new 1(this, dbgSettings));
        }
        return this.splitPane;
    }

    public ContextMenu getContextMenu() {
        return JDebugger.getInstance().getContextMenu();
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_deb_monitorswindow_html");
    }

    public Controller getController() {
        Object f = this.findFocus();
        if (f instanceof Controller) {
            return (Controller)f;
        }
        return this.monitorsPanel;
    }

    public Context getContext(EventObject event) {
        Object f = this.findFocus();
        if (f == this.monitorsPanel) {
            return this.monitorsPanel.getContext(event);
        }
        if (f == this.owningThreadPanel) {
            return this.owningThreadPanel.getContext(event);
        }
        if (f == this.waitingThreadsPanel) {
            return this.waitingThreadsPanel.getContext(event);
        }
        if (f == this.blockedThreadsPanel) {
            return this.blockedThreadsPanel.getContext(event);
        }
        return this.monitorsPanel.getContext(event);
    }

    public String getTabName() {
        return this.title;
    }

    public String getTitleName() {
        return this.title;
    }

    private Object findFocus() {
        Window w;
        Component focus;
        Component c = this.splitPane;
        while (c != null && !(c instanceof Window)) {
            c = c.getParent();
        }
        if (c != null && (focus = (w = (Window)c).getFocusOwner()) != null) {
            Component monitorsPanelGUI = this.monitorsPanel.getGUI();
            Component owningThreadPanelGUI = this.owningThreadPanel.getGUI();
            Component waitingThreadsPanelGUI = this.waitingThreadsPanel.getGUI();
            Component blockedThreadsPanelGUI = this.blockedThreadsPanel.getGUI();
            c = focus;
            while (c != null) {
                if (c == monitorsPanelGUI) {
                    return this.monitorsPanel;
                }
                if (c == owningThreadPanelGUI) {
                    return this.owningThreadPanel;
                }
                if (c == waitingThreadsPanelGUI) {
                    return this.waitingThreadsPanel;
                }
                if (c == blockedThreadsPanelGUI) {
                    return this.blockedThreadsPanel;
                }
                c = c.getParent();
            }
        }
        return null;
    }

    void everythingChanged() {
        this.monitorsPanel.everythingChanged();
    }

    void updateMonitors(DebuggingProcess debuggingProcess, DebugVirtualMachine vm) {
        this.monitorsPanel.updateData(debuggingProcess, vm, null, null);
    }

    void clearMonitors() {
        this.monitorsPanel.clearData();
    }

    void processFinished(DebuggingProcess debuggingProcess) {
        this.monitorsPanel.processFinished(debuggingProcess);
    }

    static {
        VIEW_WHOLE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsViewWhole");
        VIEW_ANNOTATIONS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsViewAnnotations");
        VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsViewAnnotationsForClass");
        ADJUST_RANGE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsAdjustRange");
        TOGGLE_VALUE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsToggleValue");
        MODIFY_VALUE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsModifyValue");
        WATCH_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsWatchClassLoader");
        INSPECT_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsInspectClassLoader");
        GOTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsGoto");
        GOTO_DECLARED_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsGotoDeclared");
        GOTO_FIELD_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsGotoField");
        USE_FILTERS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsUseFilters");
        OBJECT_PREFERENCES_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsObjectPreferences");
        COLLAPSE_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsCollapseAll");
        SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsSave");
        SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsSettings");
        OWNING_THREAD_GOTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsOwningThreadGoTo");
        OWNING_THREAD_SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsOwningThreadSave");
        OWNING_THREAD_SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsOwningThreadSettings");
        WAITING_THREADS_GOTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsWaitingThreadsGoTo");
        WAITING_THREADS_SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsWaitingThreadsSave");
        WAITING_THREADS_SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsWaitingThreadsSettings");
        BLOCKED_THREADS_GOTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsBlockedThreadsGoTo");
        BLOCKED_THREADS_SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsBlockedThreadsSave");
        BLOCKED_THREADS_SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugMonitorsBlockedThreadsSettings");
        monitorsTabIcon = null;
    }

    static int ra$SETTINGS_CMD_ID() {
        return SETTINGS_CMD_ID;
    }

    static IdeAction ra$actionSettings() {
        return actionSettings;
    }

    static JMenuItem ra$menuitemSettings() {
        return menuitemSettings;
    }

    static void wa$menuitemSettings(JMenuItem jMenuItem) {
        menuitemSettings = jMenuItem;
    }

    static MonitorsWindowSettings ra$monitorsWindowSettings(MonitorsWindow monitorsWindow) {
        return monitorsWindow.monitorsWindowSettings;
    }

    static IdeAction ra$actionViewWhole() {
        return actionViewWhole;
    }

    static IdeAction ra$actionViewAnnotations() {
        return actionViewAnnotations;
    }

    static IdeAction ra$actionViewAnnotationsForClass() {
        return actionViewAnnotationsForClass;
    }

    static IdeAction ra$actionAdjustRange() {
        return actionAdjustRange;
    }

    static IdeAction ra$actionToggleValue() {
        return actionToggleValue;
    }

    static IdeAction ra$actionModifyValue() {
        return actionModifyValue;
    }

    static IdeAction ra$actionWatchClassLoader() {
        return actionWatchClassLoader;
    }

    static IdeAction ra$actionInspectClassLoader() {
        return actionInspectClassLoader;
    }

    static IdeAction ra$actionGoto() {
        return actionGoto;
    }

    static IdeAction ra$actionGotoDeclared() {
        return actionGotoDeclared;
    }

    static IdeAction ra$actionGotoField() {
        return actionGotoField;
    }

    static IdeAction ra$actionUseFilters() {
        return actionUseFilters;
    }

    static IdeAction ra$actionObjectPreferences() {
        return actionObjectPreferences;
    }

    static IdeAction ra$actionCollapseAll() {
        return actionCollapseAll;
    }

    static IdeAction ra$actionSave() {
        return actionSave;
    }

    static int ra$VIEW_WHOLE_CMD_ID() {
        return VIEW_WHOLE_CMD_ID;
    }

    static int ra$VIEW_ANNOTATIONS_CMD_ID() {
        return VIEW_ANNOTATIONS_CMD_ID;
    }

    static int ra$VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID() {
        return VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID;
    }

    static int ra$ADJUST_RANGE_CMD_ID() {
        return ADJUST_RANGE_CMD_ID;
    }

    static int ra$TOGGLE_VALUE_CMD_ID() {
        return TOGGLE_VALUE_CMD_ID;
    }

    static int ra$MODIFY_VALUE_CMD_ID() {
        return MODIFY_VALUE_CMD_ID;
    }

    static int ra$WATCH_CLASSLOADER_CMD_ID() {
        return WATCH_CLASSLOADER_CMD_ID;
    }

    static int ra$INSPECT_CLASSLOADER_CMD_ID() {
        return INSPECT_CLASSLOADER_CMD_ID;
    }

    static int ra$GOTO_CMD_ID() {
        return GOTO_CMD_ID;
    }

    static int ra$GOTO_DECLARED_CMD_ID() {
        return GOTO_DECLARED_CMD_ID;
    }

    static int ra$GOTO_FIELD_CMD_ID() {
        return GOTO_FIELD_CMD_ID;
    }

    static int ra$USE_FILTERS_CMD_ID() {
        return USE_FILTERS_CMD_ID;
    }

    static int ra$OBJECT_PREFERENCES_CMD_ID() {
        return OBJECT_PREFERENCES_CMD_ID;
    }

    static int ra$COLLAPSE_ALL_CMD_ID() {
        return COLLAPSE_ALL_CMD_ID;
    }

    static int ra$SAVE_CMD_ID() {
        return SAVE_CMD_ID;
    }

    static IdeAction ra$actionOwningThreadGoTo() {
        return actionOwningThreadGoTo;
    }

    static IdeAction ra$actionOwningThreadSettings() {
        return actionOwningThreadSettings;
    }

    static IdeAction ra$actionOwningThreadSave() {
        return actionOwningThreadSave;
    }

    static int ra$OWNING_THREAD_GOTO_CMD_ID() {
        return OWNING_THREAD_GOTO_CMD_ID;
    }

    static int ra$OWNING_THREAD_SETTINGS_CMD_ID() {
        return OWNING_THREAD_SETTINGS_CMD_ID;
    }

    static int ra$OWNING_THREAD_SAVE_CMD_ID() {
        return OWNING_THREAD_SAVE_CMD_ID;
    }

    static IdeAction ra$actionWaitingThreadsGoTo() {
        return actionWaitingThreadsGoTo;
    }

    static IdeAction ra$actionWaitingThreadsSettings() {
        return actionWaitingThreadsSettings;
    }

    static IdeAction ra$actionWaitingThreadsSave() {
        return actionWaitingThreadsSave;
    }

    static int ra$WAITING_THREADS_GOTO_CMD_ID() {
        return WAITING_THREADS_GOTO_CMD_ID;
    }

    static int ra$WAITING_THREADS_SETTINGS_CMD_ID() {
        return WAITING_THREADS_SETTINGS_CMD_ID;
    }

    static int ra$WAITING_THREADS_SAVE_CMD_ID() {
        return WAITING_THREADS_SAVE_CMD_ID;
    }

    static IdeAction ra$actionBlockedThreadsGoTo() {
        return actionBlockedThreadsGoTo;
    }

    static IdeAction ra$actionBlockedThreadsSettings() {
        return actionBlockedThreadsSettings;
    }

    static IdeAction ra$actionBlockedThreadsSave() {
        return actionBlockedThreadsSave;
    }

    static int ra$BLOCKED_THREADS_GOTO_CMD_ID() {
        return BLOCKED_THREADS_GOTO_CMD_ID;
    }

    static int ra$BLOCKED_THREADS_SETTINGS_CMD_ID() {
        return BLOCKED_THREADS_SETTINGS_CMD_ID;
    }

    static int ra$BLOCKED_THREADS_SAVE_CMD_ID() {
        return BLOCKED_THREADS_SAVE_CMD_ID;
    }

    static void mav$debugWindowSettingsChanged(MonitorsWindow monitorsWindow, DebugWindowSettings debugWindowSettings) {
        monitorsWindow.debugWindowSettingsChanged(debugWindowSettings);
    }

    final class 1
    extends StructureChangeListener {
        private final /* synthetic */ DebugWindowSettings v$dbgSettings;
        final /* synthetic */ MonitorsWindow this$0;

        public void structureValuesChanged(StructureChangeEvent e) {
            MonitorsWindow.mav$debugWindowSettingsChanged(this.this$0, this.v$dbgSettings);
        }

        public 1(MonitorsWindow monitorsWindow, DebugWindowSettings debugWindowSettings) {
            this.v$dbgSettings = debugWindowSettings;
            this.this$0 = monitorsWindow;
        }
    }

    final class MonitorsPanel
    extends DataPanel {
        private MonitorsThreadsPanel owningThreadPanel;
        private MonitorsThreadsPanel waitingThreadsPanel;
        private MonitorsThreadsPanel blockedThreadsPanel;

        MonitorsPanel(MonitorsThreadsPanel owningThreadPanel, MonitorsThreadsPanel waitingThreadsPanel, MonitorsThreadsPanel blockedThreadsPanel) {
            super(MonitorsWindow.this, MonitorsWindow.ra$monitorsWindowSettings(MonitorsWindow.this).getDataPanelSettings());
            this.selectFirstRowIfNoPreviousSelection = true;
            this.owningThreadPanel = owningThreadPanel;
            this.waitingThreadsPanel = waitingThreadsPanel;
            this.blockedThreadsPanel = blockedThreadsPanel;
            this._actionViewWhole = MonitorsWindow.ra$actionViewWhole();
            this._actionViewAnnotations = MonitorsWindow.ra$actionViewAnnotations();
            this._actionViewAnnotationsForClass = MonitorsWindow.ra$actionViewAnnotationsForClass();
            this._actionAdjustRange = MonitorsWindow.ra$actionAdjustRange();
            this._actionToggleValue = MonitorsWindow.ra$actionToggleValue();
            this._actionModifyValue = MonitorsWindow.ra$actionModifyValue();
            this._actionWatch = null;
            this._actionInspect = null;
            this._actionWatchClassLoader = MonitorsWindow.ra$actionWatchClassLoader();
            this._actionInspectClassLoader = MonitorsWindow.ra$actionInspectClassLoader();
            this._actionGoto = MonitorsWindow.ra$actionGoto();
            this._actionGotoDeclared = MonitorsWindow.ra$actionGotoDeclared();
            this._actionGotoField = MonitorsWindow.ra$actionGotoField();
            this._actionUseFilters = MonitorsWindow.ra$actionUseFilters();
            this._actionObjectPreferences = MonitorsWindow.ra$actionObjectPreferences();
            this._actionCollapseAll = MonitorsWindow.ra$actionCollapseAll();
            this._actionSave = MonitorsWindow.ra$actionSave();
            this._VIEW_WHOLE_CMD_ID = MonitorsWindow.ra$VIEW_WHOLE_CMD_ID();
            this._VIEW_ANNOTATIONS_CMD_ID = MonitorsWindow.ra$VIEW_ANNOTATIONS_CMD_ID();
            this._VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID = MonitorsWindow.ra$VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID();
            this._ADJUST_RANGE_CMD_ID = MonitorsWindow.ra$ADJUST_RANGE_CMD_ID();
            this._TOGGLE_VALUE_CMD_ID = MonitorsWindow.ra$TOGGLE_VALUE_CMD_ID();
            this._MODIFY_VALUE_CMD_ID = MonitorsWindow.ra$MODIFY_VALUE_CMD_ID();
            this._WATCH_CMD_ID = -1;
            this._INSPECT_CMD_ID = -1;
            this._WATCH_CLASSLOADER_CMD_ID = MonitorsWindow.ra$WATCH_CLASSLOADER_CMD_ID();
            this._INSPECT_CLASSLOADER_CMD_ID = MonitorsWindow.ra$INSPECT_CLASSLOADER_CMD_ID();
            this._GOTO_CMD_ID = MonitorsWindow.ra$GOTO_CMD_ID();
            this._GOTO_DECLARED_CMD_ID = MonitorsWindow.ra$GOTO_DECLARED_CMD_ID();
            this._GOTO_FIELD_CMD_ID = MonitorsWindow.ra$GOTO_FIELD_CMD_ID();
            this._USE_FILTERS_CMD_ID = MonitorsWindow.ra$USE_FILTERS_CMD_ID();
            this._OBJECT_PREFERENCES_CMD_ID = MonitorsWindow.ra$OBJECT_PREFERENCES_CMD_ID();
            this._COLLAPSE_ALL_CMD_ID = MonitorsWindow.ra$COLLAPSE_ALL_CMD_ID();
            this._SAVE_CMD_ID = MonitorsWindow.ra$SAVE_CMD_ID();
        }

        protected void adjustGUI() {
            this.columnDefaultWidth[2] = this.columnDefaultWidth[2] * 2;
            this.column[2].setPreferredWidth(this.columnDefaultWidth[2]);
        }

        protected void addPopupMenuItemsForCommon(ContextMenu popup, Context context) {
            super.addPopupMenuItemsForCommon(popup, context);
            this.update(MonitorsWindow.ra$actionSettings(), context);
            if (MonitorsWindow.ra$actionSettings().isEnabled()) {
                if (MonitorsWindow.ra$menuitemSettings() == null) {
                    MonitorsWindow.wa$menuitemSettings(popup.createMenuItem((ToggleAction)MonitorsWindow.ra$actionSettings()));
                }
                popup.add((Component)MonitorsWindow.ra$menuitemSettings(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
            }
        }

        public boolean update(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (action.getValue("Debugger.actionOwner") == this) {
                if (this.treeTable == null || !this.dockableWindow.isVisible()) {
                    action.setEnabled(false);
                    return true;
                }
                if (!(this.treeTable.isEnabled() && this.debuggingProcess != null && this.vm != null || cmdId == MonitorsWindow.ra$SETTINGS_CMD_ID())) {
                    action.setEnabled(false);
                    return true;
                }
            }
            if (cmdId == MonitorsWindow.ra$SETTINGS_CMD_ID()) {
                action.setEnabled(true);
                return true;
            }
            return super.update(action, context);
        }

        public boolean handleEvent(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (cmdId == MonitorsWindow.ra$SETTINGS_CMD_ID()) {
                String[] path = new String[]{DbgArb.getString(16), DbgArb.getString(110)};
                Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), path);
                return true;
            }
            return super.handleEvent(action, context);
        }

        protected void addDataItems() {
            if (this.vm != null) {
                List root = this.getRoot();
                DebugMonitorInfo[] monitors = this.vm.listMonitorsInUse();
                int length = monitors.length;
                boolean[] deadlocked = new boolean[length];
                int i = 0;
                while (i < length) {
                    DebugMonitorInfo monitor = monitors[i];
                    deadlocked[i] = this.isDeadlocked(monitor);
                    ++i;
                }
                int i2 = 0;
                while (i2 < length) {
                    if (deadlocked[i2]) {
                        DebugMonitorInfo monitor = monitors[i2];
                        root.add(new MonitorDataItem(monitor, true));
                    }
                    ++i2;
                }
                int i3 = 0;
                while (i3 < length) {
                    if (!deadlocked[i3]) {
                        DebugMonitorInfo monitor = monitors[i3];
                        root.add(new MonitorDataItem(monitor, false));
                    }
                    ++i3;
                }
            }
        }

        private boolean isDeadlocked(DebugMonitorInfo monitor) {
            DebugThreadInfo[][] deadlocks = this.debuggingProcess.getDeadlocks();
            int length = deadlocks.length;
            if (length != 0) {
                int i = 0;
                while (i < length) {
                    int jLength = deadlocks[i].length;
                    int j = 0;
                    while (j < jLength) {
                        DebugThreadInfo t = deadlocks[i][j];
                        DebugMonitorInfo mon = t.getMonitorThreadBlockedFor();
                        if (monitor.equals(mon)) {
                            return true;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            return false;
        }

        public void valueChanged(TreeSelectionEvent e) {
            super.valueChanged(e);
            this.updateOtherPanels();
        }

        public void clearData() {
            super.clearData();
            this.updateOtherPanels();
        }

        void processFinished(DebuggingProcess debuggingProcess) {
            super.processFinished(debuggingProcess);
            this.owningThreadPanel.processFinished(debuggingProcess);
            this.waitingThreadsPanel.processFinished(debuggingProcess);
            this.blockedThreadsPanel.processFinished(debuggingProcess);
        }

        private DebugMonitorInfo getSelectedMonitorInfo() {
            TreePath treePath = this.treeTable.getTree().getSelectionPath();
            if (treePath != null) {
                Object[] path = treePath.getPath();
                int i = path.length - 1;
                while (i >= 0) {
                    MonitorDataItem monitorDataItem;
                    Object info;
                    Object pathObject = path[i];
                    if (pathObject instanceof MonitorDataItem && (info = (monitorDataItem = (MonitorDataItem)pathObject).getInfo()) instanceof DebugMonitorInfo) {
                        return (DebugMonitorInfo)info;
                    }
                    --i;
                }
            }
            return null;
        }

        private void updateOtherPanels() {
            if (this.treeTable != null && this.treeTable.isEnabled()) {
                if (this.debuggingProcess != null && this.vm != null) {
                    DebugMonitorInfo monitor = this.getSelectedMonitorInfo();
                    if (monitor != null) {
                        this.owningThreadPanel.setThread(monitor.getOwnerThread());
                        this.waitingThreadsPanel.setThreads(monitor.listWaitingThreads());
                        this.blockedThreadsPanel.setThreads(monitor.listBlockedThreads());
                    } else {
                        this.owningThreadPanel.setThreads(null);
                        this.waitingThreadsPanel.setThreads(null);
                        this.blockedThreadsPanel.setThreads(null);
                    }
                    this.owningThreadPanel.updateThreads(this.debuggingProcess, this.vm, null);
                    this.waitingThreadsPanel.updateThreads(this.debuggingProcess, this.vm, null);
                    this.blockedThreadsPanel.updateThreads(this.debuggingProcess, this.vm, null);
                } else {
                    this.owningThreadPanel.updateThreads(null, null, null);
                    this.waitingThreadsPanel.updateThreads(null, null, null);
                    this.blockedThreadsPanel.updateThreads(null, null, null);
                }
            } else {
                this.owningThreadPanel.clearThreads();
                this.waitingThreadsPanel.clearThreads();
                this.blockedThreadsPanel.clearThreads();
            }
        }

        protected final class MonitorDataItem
        extends DataPanel.DataItem {
            boolean deadlocked;

            MonitorDataItem(Object info, boolean deadlocked) {
                super(info);
                this.deadlocked = deadlocked;
            }

            protected Font getFont(int column) {
                if (column == 0 && this.deadlocked) {
                    return MonitorsPanel.this.getBoldFont();
                }
                return super.getFont(column);
            }
        }
    }

    final class MonitorsThreadsPanel
    extends ThreadsPanel {
        private String accessibleName;
        private DebugThreadInfo[] threads;
        private IdeAction _actionSettings;
        private JMenuItem _menuitemSettings;
        private int _SETTINGS_CMD_ID;

        MonitorsThreadsPanel(int panelId, String accessibleName, int preferredVisibleRowCount) {
            super(MonitorsWindow.this, MonitorsWindow.ra$monitorsWindowSettings(MonitorsWindow.this).getThreadsPanelSettings());
            this.accessibleName = accessibleName;
            this.preferredVisibleRowCount = preferredVisibleRowCount;
            this.boldCurrentThreadName = false;
            switch (panelId) {
                case 1: {
                    this._actionGoTo = MonitorsWindow.ra$actionOwningThreadGoTo();
                    this._actionSettings = MonitorsWindow.ra$actionOwningThreadSettings();
                    this._actionSave = MonitorsWindow.ra$actionOwningThreadSave();
                    this._GOTO_CMD_ID = MonitorsWindow.ra$OWNING_THREAD_GOTO_CMD_ID();
                    this._SETTINGS_CMD_ID = MonitorsWindow.ra$OWNING_THREAD_SETTINGS_CMD_ID();
                    this._SAVE_CMD_ID = MonitorsWindow.ra$OWNING_THREAD_SAVE_CMD_ID();
                    break;
                }
                case 2: {
                    this._actionGoTo = MonitorsWindow.ra$actionWaitingThreadsGoTo();
                    this._actionSettings = MonitorsWindow.ra$actionWaitingThreadsSettings();
                    this._actionSave = MonitorsWindow.ra$actionWaitingThreadsSave();
                    this._GOTO_CMD_ID = MonitorsWindow.ra$WAITING_THREADS_GOTO_CMD_ID();
                    this._SETTINGS_CMD_ID = MonitorsWindow.ra$WAITING_THREADS_SETTINGS_CMD_ID();
                    this._SAVE_CMD_ID = MonitorsWindow.ra$WAITING_THREADS_SAVE_CMD_ID();
                    break;
                }
                case 3: {
                    this._actionGoTo = MonitorsWindow.ra$actionBlockedThreadsGoTo();
                    this._actionSettings = MonitorsWindow.ra$actionBlockedThreadsSettings();
                    this._actionSave = MonitorsWindow.ra$actionBlockedThreadsSave();
                    this._GOTO_CMD_ID = MonitorsWindow.ra$BLOCKED_THREADS_GOTO_CMD_ID();
                    this._SETTINGS_CMD_ID = MonitorsWindow.ra$BLOCKED_THREADS_SETTINGS_CMD_ID();
                    this._SAVE_CMD_ID = MonitorsWindow.ra$BLOCKED_THREADS_SAVE_CMD_ID();
                    break;
                }
            }
        }

        protected void adjustGUI() {
            this.treeTable.getAccessibleContext().setAccessibleName(this.accessibleName);
            this.columnDefaultWidth[1] = this.columnDefaultWidth[1] * 2;
            this.column[1].setPreferredWidth(this.columnDefaultWidth[1]);
        }

        void setThreads(DebugThreadInfo[] threads) {
            this.threads = threads;
        }

        void setThread(DebugThreadInfo thread) {
            if (thread != null) {
                this.threads = new DebugThreadInfo[1];
                this.threads[0] = thread;
            } else {
                this.threads = null;
            }
        }

        void clearThreads() {
            this.threads = null;
            super.clearThreads();
        }

        protected void addPopupMenuItemsForCommon(ContextMenu popup, Context context) {
            super.addPopupMenuItemsForCommon(popup, context);
            this.update(this._actionSettings, context);
            if (this._actionSettings.isEnabled()) {
                if (this._menuitemSettings == null) {
                    this._menuitemSettings = popup.createMenuItem((ToggleAction)this._actionSettings);
                }
                popup.add((Component)this._menuitemSettings, JDeveloperMenuConstants.SECTION_TOOLS_CTXT_MENU);
            }
        }

        public boolean handleEvent(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (cmdId == this._SETTINGS_CMD_ID) {
                String[] path = new String[]{DbgArb.getString(16), DbgArb.getString(110), DbgArb.getString(935)};
                Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), path);
                return true;
            }
            return super.handleEvent(action, context);
        }

        public boolean update(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (action.getValue("Debugger.actionOwner") == this) {
                if (this.treeTable == null || !this.dockableWindow.isVisible()) {
                    action.setEnabled(false);
                    return true;
                }
                if (!(this.treeTable.isEnabled() && this.debuggingProcess != null && this.vm != null || cmdId == this._SETTINGS_CMD_ID)) {
                    action.setEnabled(false);
                    return true;
                }
            }
            if (cmdId == this._SETTINGS_CMD_ID) {
                action.setEnabled(true);
                return true;
            }
            return super.update(action, context);
        }

        protected void addThreadItems() {
            if (this.threads != null) {
                List root = this.getRoot();
                Arrays.sort(this.threads, this);
                int i = 0;
                while (i < this.threads.length) {
                    root.add(new ThreadsPanel.ThreadItem(this, this.threads[i]));
                    ++i;
                }
            }
        }
    }
}

