/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.exception.SingletonClassException;
import oracle.ide.runner.Debugger;
import oracle.jdeveloper.JDeveloperMenuConstants;

public final class PolygonViewer
implements Addin,
Controller,
ContextMenuListener {
    private static PolygonViewer instance;
    private static final int VIEW_POLYGON_CMD_ID;
    private static IdeAction actionViewPolygon;
    private static JMenuItem menuitemViewPolygon;

    public PolygonViewer() throws SingletonClassException {
        if (instance != null) {
            throw new SingletonClassException("oracle.jdevimpl.runner.debug.PolygonViewer");
        }
        instance = this;
    }

    public void initialize() {
        actionViewPolygon = IdeAction.get((int)VIEW_POLYGON_CMD_ID, (String)"View Polygon...", (Integer)new Integer(83));
        actionViewPolygon.addController((Controller)this);
        Debugger debugger = Debugger.getDebugger();
        ContextMenu contextMenu = debugger.getContextMenu();
        contextMenu.addContextMenuListener((ContextMenuListener)this);
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == VIEW_POLYGON_CMD_ID) {
            Polygon polygon;
            if (action.isEnabled() && (polygon = PolygonViewer.getPolygon(context)) != null) {
                PolygonViewer.showViewer(polygon);
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == VIEW_POLYGON_CMD_ID) {
            action.setEnabled(PolygonViewer.isPolygon(context));
            return true;
        }
        return false;
    }

    public void menuWillShow(ContextMenu popup) {
        Context context = popup.getContext();
        this.update(actionViewPolygon, context);
        if (actionViewPolygon.isEnabled()) {
            if (menuitemViewPolygon == null) {
                menuitemViewPolygon = popup.createMenuItem((ToggleAction)actionViewPolygon);
            }
            popup.add((Component)menuitemViewPolygon, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private static boolean isPolygon(Context context) {
        try {
            ObjectReference or;
            ReferenceType rt;
            Object value;
            if (context != null && (value = context.getProperty("com.sun.jdi.Value")) instanceof ObjectReference && (rt = (or = (ObjectReference)value).referenceType()) instanceof ClassType) {
                ClassType ct = (ClassType)rt;
                do {
                    if (!ct.name().equals("java.awt.Polygon")) continue;
                    boolean bl = true;
                    return bl;
                } while ((ct = ct.superclass()) != null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static Polygon getPolygon(Context context) {
        try {
            if (PolygonViewer.isPolygon(context)) {
                ObjectReference or = (ObjectReference)context.getProperty("com.sun.jdi.Value");
                ReferenceType rt = or.referenceType();
                int npoints = PolygonViewer.getIntField(or, rt, "npoints");
                int[] xpoints = PolygonViewer.getIntArrayField(or, rt, "xpoints");
                int[] ypoints = PolygonViewer.getIntArrayField(or, rt, "ypoints");
                Polygon polygon = new Polygon(xpoints, ypoints, npoints);
                return polygon;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static int getIntField(ObjectReference or, ReferenceType rt, String fieldName) throws Exception {
        return ((IntegerValue)or.getValue(rt.fieldByName(fieldName))).value();
    }

    private static int[] getIntArrayField(ObjectReference or, ReferenceType rt, String fieldName) throws Exception {
        ArrayReference ar = (ArrayReference)or.getValue(rt.fieldByName(fieldName));
        List<Value> values = ar.getValues();
        int[] array = new int[values.size()];
        int i = 0;
        for (Value iv : values) {
            array[i++] = ((IntegerValue)iv).value();
        }
        return array;
    }

    private static void showViewer(Polygon polygon) {
        int margin = 10;
        Rectangle translate = polygon.getBounds();
        polygon.translate(-translate.x + 10, -translate.y + 10);
        Rectangle bounds = polygon.getBounds();
        Dimension size = new Dimension(bounds.x + bounds.width + 10, bounds.y + bounds.height + 10);
        1 component = new 1(polygon);
        component.setPreferredSize(size);
        JScrollPane scrollPane = new JScrollPane(component);
        scrollPane.getVerticalScrollBar().setUnitIncrement(10);
        scrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)scrollPane, "Center");
        OnePageWizardDialogFactory.runDialog((Component)panel, null, (String)"Polygon Viewer", (int)1);
    }

    static {
        VIEW_POLYGON_CMD_ID = Ide.findOrCreateCmdID((String)"DebuggerViewPolygon");
    }

    static final class 1
    extends JComponent {
        private final /* synthetic */ Polygon v$polygon;

        public boolean isFocusTraversable() {
            return false;
        }

        protected void paintComponent(Graphics g) {
            Rectangle clipBounds = g.getClipBounds();
            g.setColor(Color.WHITE);
            g.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
            g.setColor(Color.BLACK);
            if (g instanceof Graphics2D) {
                ((Graphics2D)g).fill(this.v$polygon);
            }
        }

        public 1(Polygon polygon) {
            this.v$polygon = polygon;
        }
    }
}

