/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunConfigurationEditorUtil;
import oracle.jdevimpl.debugger.support.DebugConnectArg;
import oracle.jdevimpl.debugger.support.DebugFactory;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugConfiguration;

public final class RemoteDebugSettingsPanel
extends DefaultTraversablePanel
implements ItemListener {
    private static final int INDEX_JPDA = 0;
    private static final int INDEX_JPDALISTEN = 1;
    private static final int INDEX_MOZILLA_FIREFOX_ATTACH = 2;
    private static final int COUNT = 3;
    private final Protocol[] protocols;
    private final JComboBox protocolComboBox;
    private final CardLayout cardLayout;
    private final JPanel cardPanel;
    private final JCheckBox promptCheckBox;

    public RemoteDebugSettingsPanel() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_deb_remotesetpanel_html");
        this.protocols = new Protocol[3];
        this.protocols[0] = new Protocol(0, "jpda", DbgArb.getString(381));
        this.protocols[1] = new Protocol(1, "jpdaListen", DbgArb.getString(705));
        this.protocols[2] = new Protocol(4, "mozillaFireFoxJavaScript", DbgArb.getString(507));
        JLabel protocolLabel = new JLabel();
        this.protocolComboBox = new JComboBox();
        this.protocolComboBox.setModel(new NonNullableComboBoxModel((Object[])this.protocols));
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel(this.cardLayout);
        this.fillCardPanel();
        this.promptCheckBox = new JCheckBox();
        ResourceUtils.resLabel((JLabel)protocolLabel, (Component)this.protocolComboBox, (String)DbgArb.getString(53));
        ResourceUtils.resButton((AbstractButton)this.promptCheckBox, (String)DbgArb.getString(885));
        this.setLayout(new GridBagLayout());
        int y = 0;
        this.add(protocolLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.protocolComboBox, new GridBagConstraints(1, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add(this.cardPanel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 20, 0, 0), 0, 0));
        this.add(this.promptCheckBox, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add(new JLabel(), new GridBagConstraints(0, y, 0, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.protocolComboBox.addItemListener(this);
    }

    public void onEntry(TraversableContext tc) {
        DebugConfiguration debugConfiguration = RemoteDebugSettingsPanel.getDebugConfiguration(tc);
        this.loadFrom(debugConfiguration);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        DebugConfiguration debugConfiguration = RemoteDebugSettingsPanel.getDebugConfiguration(tc);
        this.commitTo(debugConfiguration);
    }

    private static DebugConfiguration getDebugConfiguration(TraversableContext tc) {
        RunConfiguration runConfiguration = RunConfigurationEditorUtil.getRunConfiguration((Namespace)tc);
        return DebugConfiguration.getInstance(runConfiguration);
    }

    public void itemStateChanged(ItemEvent e) {
        String card = this.protocolComboBox.getSelectedItem().toString();
        this.cardLayout.show(this.cardPanel, card);
    }

    private void loadFrom(DebugConfiguration debugConfiguration) {
        String remoteProtocol = debugConfiguration.getRemoteProtocol();
        int index = remoteProtocol.equals("jpda") ? 0 : (remoteProtocol.equals("jpdaListen") ? 1 : (remoteProtocol.equals("mozillaFireFoxJavaScript") ? 2 : 0));
        this.protocolComboBox.setSelectedIndex(index);
        int protocolsLength = this.protocols.length;
        int i = 0;
        while (i < protocolsLength) {
            this.protocols[i].loadFrom(debugConfiguration);
            ++i;
        }
        this.promptCheckBox.setSelected(debugConfiguration.isPromptForRemoteDebugging());
    }

    private void commitTo(DebugConfiguration debugConfiguration) {
        int index = this.protocolComboBox.getSelectedIndex();
        debugConfiguration.setRemoteProtocol(this.protocols[index].getProtocol());
        int protocolsLength = this.protocols.length;
        int i = 0;
        while (i < protocolsLength) {
            this.protocols[i].commitTo(debugConfiguration);
            ++i;
        }
        debugConfiguration.setPromptForRemoteDebugging(this.promptCheckBox.isSelected());
    }

    private void fillCardPanel() {
        int protocolsLength = this.protocols.length;
        if (protocolsLength > 0) {
            int i = 0;
            while (i < protocolsLength) {
                Protocol protocol = this.protocols[i];
                this.cardPanel.add((Component)protocol.getPanel(), protocol.toString());
                ++i;
            }
            this.cardLayout.first(this.cardPanel);
        }
    }

    static class Protocol {
        private final String protocol;
        private final String label;
        private final DebugConnectArg[] connectArgs;
        private final JLabel[] connectParamLabels;
        private final JTextField[] connectParams;
        private final JLabel info1;
        private final JTextArea info2;
        private final JPanel panel;

        Protocol(int factory, String protocol, String label) {
            this.protocol = protocol;
            this.label = label;
            this.connectArgs = DebugFactory.newInstance(factory).getConnectArgs();
            int length = this.connectArgs.length;
            this.connectParamLabels = new JLabel[length];
            this.connectParams = new JTextField[length];
            int i = 0;
            while (i < length) {
                DebugConnectArg connectArg = this.connectArgs[i];
                this.connectParamLabels[i] = new JLabel(connectArg.getLabel());
                this.connectParams[i] = new JTextField(connectArg.getValue());
                this.connectParamLabels[i].setLabelFor(this.connectParams[i]);
                ++i;
            }
            this.info1 = new JLabel();
            this.info1.setHorizontalAlignment(2);
            this.info2 = new JTextArea();
            this.info2.setBackground(this.info1.getBackground());
            this.info2.setEditable(false);
            this.info2.setLineWrap(true);
            this.info2.setWrapStyleWord(true);
            this.info1.setLabelFor(this.info2);
            switch (factory) {
                case 0: {
                    this.info1.setText(DbgArb.getString(729));
                    this.info2.setText(DbgArb.getString(728));
                    break;
                }
                case 1: {
                    this.info1.setText(DbgArb.getString(194));
                    this.info2.setText(DbgArb.getString(193));
                    break;
                }
                case 4: {
                    this.info1.setText(DbgArb.getString(452));
                    this.info2.setText(DbgArb.getString(451));
                    break;
                }
            }
            this.panel = new JPanel(new GridBagLayout());
            int y = 0;
            int i2 = 0;
            while (i2 < this.connectArgs.length) {
                this.panel.add((Component)this.connectParamLabels[i2], new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
                this.panel.add((Component)this.connectParams[i2], new GridBagConstraints(1, y++, 0, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
                ++i2;
            }
            this.panel.add((Component)this.info1, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
            this.panel.add((Component)this.info2, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel(), new GridBagConstraints(0, y, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }

        String getProtocol() {
            return this.protocol;
        }

        public String toString() {
            return this.label;
        }

        JPanel getPanel() {
            return this.panel;
        }

        void loadFrom(DebugConfiguration debugConfiguration) {
            int i = 0;
            while (i < this.connectArgs.length) {
                DebugConnectArg connectArg = this.connectArgs[i];
                String value = debugConfiguration.getRemoteParameterValue(this.protocol, connectArg.getName());
                this.connectParams[i].setText(value);
                ++i;
            }
        }

        void commitTo(DebugConfiguration debugConfiguration) {
            int i = 0;
            while (i < this.connectArgs.length) {
                DebugConnectArg connectArg = this.connectArgs[i];
                String value = this.connectParams[i].getText();
                debugConfiguration.putRemoteParameterValue(this.protocol, connectArg.getName(), value);
                ++i;
            }
        }
    }
}

