/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.ArrayList;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.View;
import oracle.jdevimpl.runner.debug.DbgArb;

public class SharedActions
implements Controller {
    private static IdeAction actionDebugPause;
    private static IdeAction actionDebugResume;
    private static IdeAction actionDebugGC;
    private static IdeAction actionDebugReset;
    public static final int DEBUG_PAUSE_CMD_ID;
    public static final int DEBUG_RESUME_CMD_ID;
    public static final int DEBUG_RESET_CMD_ID;
    public static final int DEBUG_GC_CMD_ID;
    private static final int NUM_CMDS = 4;
    private static final int[] actionIDs;
    private ArrayList<Controller> controllers;
    private static final SharedActions instance;

    private void $init$() {
        this.controllers = new ArrayList();
    }

    private SharedActions() {
        this.$init$();
    }

    public static synchronized SharedActions getInstance() {
        return instance;
    }

    public void addController(Controller controller) {
        if (!this.controllers.contains(controller)) {
            this.controllers.add(controller);
        }
    }

    public void removeController(Controller controller) {
        this.controllers.remove(controller);
    }

    public void initialize() {
        this.getSuspendAction();
        this.getResumeAction();
        this.getTerminateAction();
        this.getGcAction();
    }

    public IdeAction getSuspendAction() {
        if (actionDebugPause == null) {
            actionDebugPause = IdeAction.get((int)DEBUG_PAUSE_CMD_ID, null, (String)DbgArb.getString(344), (String)DbgArb.getString(171), (Integer)DbgArb.getInteger(400), (ArrayResourceBundle)DbgArb.getInstance(), (int)684, null, (boolean)false);
            actionDebugPause.addController((Controller)this);
        }
        return actionDebugPause;
    }

    public IdeAction getResumeAction() {
        if (actionDebugResume == null) {
            actionDebugResume = IdeAction.get((int)DEBUG_RESUME_CMD_ID, null, (String)DbgArb.getString(756), (String)DbgArb.getString(171), (Integer)DbgArb.getInteger(609), (ArrayResourceBundle)DbgArb.getInstance(), (int)584, null, (boolean)false);
            actionDebugResume.addController((Controller)this);
        }
        return actionDebugResume;
    }

    public IdeAction getTerminateAction() {
        if (actionDebugReset == null) {
            actionDebugReset = IdeAction.get((int)DEBUG_RESET_CMD_ID, null, (String)IdeArb.getString((int)92), (String)DbgArb.getString(171), null, (ArrayResourceBundle)IdeArb.getInstance(), (int)343, null, (boolean)false);
            actionDebugReset.addController((Controller)this);
        }
        return actionDebugReset;
    }

    public IdeAction getGcAction() {
        if (actionDebugGC == null) {
            actionDebugGC = IdeAction.get((int)DEBUG_GC_CMD_ID, null, (String)DbgArb.getString(538), (String)DbgArb.getString(171), (Integer)DbgArb.getInteger(252), (ArrayResourceBundle)DbgArb.getInstance(), (int)272, null, (boolean)false);
            actionDebugGC.addController((Controller)this);
        }
        return actionDebugGC;
    }

    private int getCmdID(int actionID) {
        int i = 0;
        while (i < 4) {
            if (actionIDs[i] == actionID) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean isSharedAction(IdeAction action) {
        int commandId = action.getCommandId();
        return commandId == DEBUG_PAUSE_CMD_ID || commandId == DEBUG_RESUME_CMD_ID || commandId == DEBUG_RESET_CMD_ID || commandId == DEBUG_GC_CMD_ID;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        if (this.isSharedAction(action)) {
            Controller controller;
            View view = context.getView();
            Controller controller2 = controller = view != null ? view.getController() : null;
            if (controller instanceof SharedActionController) {
                return controller.handleEvent(action, context);
            }
            for (Controller handler : this.controllers) {
                if (!handler.handleEvent(action, context)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        if (this.isSharedAction(action)) {
            Controller controller;
            View view = context.getView();
            Controller controller2 = controller = view != null ? view.getController() : null;
            if (controller instanceof SharedActionController) {
                return controller.update(action, context);
            }
            for (Controller handler : this.controllers) {
                if (!handler.update(action, context)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        DEBUG_PAUSE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugPauseCommand");
        DEBUG_RESUME_CMD_ID = Ide.findOrCreateCmdID((String)"DebugResumeCommand");
        DEBUG_RESET_CMD_ID = Ide.findOrCreateCmdID((String)"DebugResetCommand");
        DEBUG_GC_CMD_ID = Ide.findOrCreateCmdID((String)"DebugGCCommand");
        actionIDs = new int[]{DEBUG_PAUSE_CMD_ID, DEBUG_RESUME_CMD_ID, DEBUG_RESET_CMD_ID, DEBUG_GC_CMD_ID};
        instance = new SharedActions();
    }

    public static interface SharedActionController
    extends Controller {
    }
}

