/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.layout.Layout;
import oracle.ide.runner.DebuggerWindowProvider;
import oracle.ide.util.IdeProfile;
import oracle.ide.util.ModelUtil;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.DataWindow;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.EvaluatorItem;
import oracle.jdevimpl.runner.debug.EvaluatorPanel;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.LocationInfo;
import oracle.jdevimpl.runner.debug.ProfilingEvents;
import oracle.jdevimpl.runner.debug.SmartWindowSettings;

final class SmartWindow
extends DataWindow {
    private SmartWindowSettings smartWindowSettings = SmartWindowSettings.getInstance();
    private static IdeAction actionViewWhole;
    private static IdeAction actionViewAnnotations;
    private static IdeAction actionViewAnnotationsForClass;
    private static IdeAction actionAdjustRange;
    private static IdeAction actionToggleValue;
    private static IdeAction actionModifyValue;
    private static IdeAction actionWatch;
    private static IdeAction actionInspect;
    private static IdeAction actionWatchClassLoader;
    private static IdeAction actionInspectClassLoader;
    private static IdeAction actionGoto;
    private static IdeAction actionGotoDeclared;
    private static IdeAction actionGotoField;
    private static IdeAction actionUseFilters;
    private static IdeAction actionObjectPreferences;
    private static IdeAction actionCollapseAll;
    private static IdeAction actionSave;
    private static IdeAction actionSettings;
    private static JMenuItem menuitemSettings;
    private static final int VIEW_WHOLE_CMD_ID;
    private static final int VIEW_ANNOTATIONS_CMD_ID;
    private static final int VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID;
    private static final int ADJUST_RANGE_CMD_ID;
    private static final int TOGGLE_VALUE_CMD_ID;
    private static final int MODIFY_VALUE_CMD_ID;
    private static final int WATCH_CMD_ID;
    private static final int INSPECT_CMD_ID;
    private static final int WATCH_CLASSLOADER_CMD_ID;
    private static final int INSPECT_CLASSLOADER_CMD_ID;
    private static final int GOTO_CMD_ID;
    private static final int GOTO_DECLARED_CMD_ID;
    private static final int GOTO_FIELD_CMD_ID;
    private static final int USE_FILTERS_CMD_ID;
    private static final int OBJECT_PREFERENCES_CMD_ID;
    private static final int COLLAPSE_ALL_CMD_ID;
    private static final int SAVE_CMD_ID;
    private static final int SETTINGS_CMD_ID;
    static final String SMART_WINDOW_ID = "Debugger.SmartWindow";
    private static Icon smartTabIcon;

    SmartWindow() {
        super(SMART_WINDOW_ID, DbgArb.getString(131), "f1_deb_smartdatawindow_html");
        SmartWindow.makeActions();
        this.setDataPanel(new SmartPanel());
        this.setControllerForActions();
    }

    public Icon getTabIcon() {
        if (smartTabIcon == null) {
            smartTabIcon = DbgArb.getIcon(695);
        }
        return smartTabIcon;
    }

    public int getDefaultVisibility(Layout layout) {
        return super.getDefaultVisibility(layout) | 4;
    }

    void refreshWindow() {
        ((SmartPanel)this.dataPanel).refreshWindow();
    }

    public DebuggerWindowProvider.DebuggerWindowPosition getPosition() {
        return DebuggerWindowProvider.DebuggerWindowPosition.SOUTH;
    }

    public boolean installByDefault() {
        return true;
    }

    static void addContextMenuToMainMenu(Menubar menubar, JMenu subMenu) {
        SmartWindow.makeActions();
        float section = 1.0f;
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionViewWhole), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionViewAnnotations), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionViewAnnotationsForClass), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionAdjustRange), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionToggleValue), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionModifyValue), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionWatch), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionInspect), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionWatchClassLoader), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionInspectClassLoader), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGoto), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGotoDeclared), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGotoField), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionUseFilters), subMenu, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionObjectPreferences), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionCollapseAll), subMenu, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSave), subMenu, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSettings), subMenu, section);
    }

    private static void makeActions() {
        if (actionViewWhole == null) {
            actionViewWhole = IdeAction.get((int)VIEW_WHOLE_CMD_ID, null, (String)DbgArb.getString(333), null, (Integer)DbgArb.getInteger(824), null, (int)-1, null, (boolean)false);
            actionViewWhole.setEnabled(false);
            actionViewAnnotations = IdeAction.get((int)VIEW_ANNOTATIONS_CMD_ID, null, (String)DbgArb.getString(33), null, (Integer)DbgArb.getInteger(961), null, (int)-1, null, (boolean)false);
            actionViewAnnotations.putValue("NoCtxName", (Object)DbgArb.getString(33));
            actionViewAnnotations.setEnabled(false);
            actionViewAnnotationsForClass = IdeAction.get((int)VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID, null, (String)DbgArb.getString(844), null, (Integer)DbgArb.getInteger(884), null, (int)-1, null, (boolean)false);
            actionViewAnnotationsForClass.setEnabled(false);
            actionAdjustRange = IdeAction.get((int)ADJUST_RANGE_CMD_ID, null, (String)DbgArb.getString(157), null, (Integer)DbgArb.getInteger(810), null, (int)-1, null, (boolean)false);
            actionAdjustRange.setEnabled(false);
            actionToggleValue = IdeAction.get((int)TOGGLE_VALUE_CMD_ID, null, (String)DbgArb.getString(183), null, (Integer)DbgArb.getInteger(891), null, (int)-1, null, (boolean)false);
            actionToggleValue.setEnabled(false);
            actionModifyValue = IdeAction.get((int)MODIFY_VALUE_CMD_ID, null, (String)DbgArb.getString(429), null, (Integer)DbgArb.getInteger(267), null, (int)-1, null, (boolean)false);
            actionModifyValue.setEnabled(false);
            actionWatch = IdeAction.get((int)WATCH_CMD_ID, null, (String)DbgArb.getString(197), null, (Integer)DbgArb.getInteger(682), null, (int)-1, null, (boolean)false);
            actionWatch.setEnabled(false);
            actionInspect = IdeAction.get((int)INSPECT_CMD_ID, null, (String)DbgArb.getString(96), null, (Integer)DbgArb.getInteger(484), null, (int)-1, null, (boolean)false);
            actionInspect.setEnabled(false);
            actionWatchClassLoader = IdeAction.get((int)WATCH_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(205), null, (Integer)DbgArb.getInteger(505), null, (int)-1, null, (boolean)false);
            actionWatchClassLoader.setEnabled(false);
            actionInspectClassLoader = IdeAction.get((int)INSPECT_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(273), null, (Integer)DbgArb.getInteger(921), null, (int)-1, null, (boolean)false);
            actionInspectClassLoader.setEnabled(false);
            actionGoto = IdeAction.get((int)GOTO_CMD_ID, null, (String)DbgArb.getString(389), null, (Integer)DbgArb.getInteger(598), null, (int)-1, null, (boolean)false);
            actionGoto.putValue("NoCtxName", (Object)DbgArb.getString(389));
            actionGoto.setEnabled(false);
            actionGotoDeclared = IdeAction.get((int)GOTO_DECLARED_CMD_ID, null, (String)DbgArb.getString(851), null, (Integer)DbgArb.getInteger(926), null, (int)-1, null, (boolean)false);
            actionGotoDeclared.putValue("NoCtxName", (Object)DbgArb.getString(851));
            actionGotoDeclared.setEnabled(false);
            actionGotoField = IdeAction.get((int)GOTO_FIELD_CMD_ID, null, (String)DbgArb.getString(617), null, (Integer)DbgArb.getInteger(788), null, (int)-1, null, (boolean)false);
            actionGotoField.putValue("NoCtxName", (Object)DbgArb.getString(617));
            actionGotoField.setEnabled(false);
            actionUseFilters = IdeAction.get((int)USE_FILTERS_CMD_ID, null, (String)DbgArb.getString(637), null, (Integer)DbgArb.getInteger(412), null, (int)-1, null, (boolean)false);
            actionUseFilters.putValue("Check", (Object)Boolean.TRUE);
            actionUseFilters.setEnabled(false);
            actionObjectPreferences = IdeAction.get((int)OBJECT_PREFERENCES_CMD_ID, null, (String)DbgArb.format(892, ""), null, (Integer)DbgArb.getInteger(594), null, (int)-1, null, (boolean)false);
            actionObjectPreferences.setEnabled(false);
            actionSettings = IdeAction.get((int)SETTINGS_CMD_ID, null, (String)RunMgrArb.getString(87), null, (Integer)RunMgrArb.getInteger(99), null, (int)-1, null, (boolean)false);
            actionSettings.setEnabled(false);
            actionCollapseAll = IdeAction.get((int)COLLAPSE_ALL_CMD_ID, null, (String)RunMgrArb.getString(0), null, (Integer)RunMgrArb.getInteger(7), null, (int)-1, null, (boolean)false);
            actionCollapseAll.setEnabled(false);
            actionSave = IdeAction.get((int)SAVE_CMD_ID, null, (String)RunMgrArb.getString(65), null, (Integer)RunMgrArb.getInteger(101), null, (int)-1, null, (boolean)false);
            actionSave.setEnabled(false);
        }
    }

    private void setControllerForActions() {
        IdeAction[] actions = new IdeAction[]{actionViewWhole, actionViewAnnotations, actionViewAnnotationsForClass, actionAdjustRange, actionToggleValue, actionModifyValue, actionWatch, actionInspect, actionWatchClassLoader, actionInspectClassLoader, actionGoto, actionGotoDeclared, actionGotoField, actionUseFilters, actionObjectPreferences, actionSettings, actionCollapseAll, actionSave};
        JDebugger.setControllerForActions(actions, this.dataPanel);
    }

    static {
        VIEW_WHOLE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartViewWhole");
        VIEW_ANNOTATIONS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartViewAnnotations");
        VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartViewAnnotationsForClass");
        ADJUST_RANGE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartAdjustRange");
        TOGGLE_VALUE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartToggleValue");
        MODIFY_VALUE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartModifyValue");
        WATCH_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartWatch");
        INSPECT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartInspect");
        WATCH_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartWatchClassLoader");
        INSPECT_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartInspectClassLoader");
        GOTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartGoto");
        GOTO_DECLARED_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartGotoDeclared");
        GOTO_FIELD_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartGotoField");
        USE_FILTERS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartUseFilters");
        OBJECT_PREFERENCES_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartObjectPreferences");
        COLLAPSE_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartCollapseAll");
        SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartSave");
        SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartSettings");
        smartTabIcon = null;
    }

    static SmartWindowSettings ra$smartWindowSettings(SmartWindow smartWindow) {
        return smartWindow.smartWindowSettings;
    }

    static int ra$SETTINGS_CMD_ID() {
        return SETTINGS_CMD_ID;
    }

    static IdeAction ra$actionSettings() {
        return actionSettings;
    }

    static JMenuItem ra$menuitemSettings() {
        return menuitemSettings;
    }

    static void wa$menuitemSettings(JMenuItem jMenuItem) {
        menuitemSettings = jMenuItem;
    }

    static IdeAction ra$actionViewWhole() {
        return actionViewWhole;
    }

    static IdeAction ra$actionViewAnnotations() {
        return actionViewAnnotations;
    }

    static IdeAction ra$actionViewAnnotationsForClass() {
        return actionViewAnnotationsForClass;
    }

    static IdeAction ra$actionAdjustRange() {
        return actionAdjustRange;
    }

    static IdeAction ra$actionToggleValue() {
        return actionToggleValue;
    }

    static IdeAction ra$actionModifyValue() {
        return actionModifyValue;
    }

    static IdeAction ra$actionWatch() {
        return actionWatch;
    }

    static IdeAction ra$actionInspect() {
        return actionInspect;
    }

    static IdeAction ra$actionWatchClassLoader() {
        return actionWatchClassLoader;
    }

    static IdeAction ra$actionInspectClassLoader() {
        return actionInspectClassLoader;
    }

    static IdeAction ra$actionGoto() {
        return actionGoto;
    }

    static IdeAction ra$actionGotoDeclared() {
        return actionGotoDeclared;
    }

    static IdeAction ra$actionGotoField() {
        return actionGotoField;
    }

    static IdeAction ra$actionUseFilters() {
        return actionUseFilters;
    }

    static IdeAction ra$actionObjectPreferences() {
        return actionObjectPreferences;
    }

    static IdeAction ra$actionCollapseAll() {
        return actionCollapseAll;
    }

    static IdeAction ra$actionSave() {
        return actionSave;
    }

    static int ra$VIEW_WHOLE_CMD_ID() {
        return VIEW_WHOLE_CMD_ID;
    }

    static int ra$VIEW_ANNOTATIONS_CMD_ID() {
        return VIEW_ANNOTATIONS_CMD_ID;
    }

    static int ra$VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID() {
        return VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID;
    }

    static int ra$ADJUST_RANGE_CMD_ID() {
        return ADJUST_RANGE_CMD_ID;
    }

    static int ra$TOGGLE_VALUE_CMD_ID() {
        return TOGGLE_VALUE_CMD_ID;
    }

    static int ra$MODIFY_VALUE_CMD_ID() {
        return MODIFY_VALUE_CMD_ID;
    }

    static int ra$WATCH_CMD_ID() {
        return WATCH_CMD_ID;
    }

    static int ra$INSPECT_CMD_ID() {
        return INSPECT_CMD_ID;
    }

    static int ra$WATCH_CLASSLOADER_CMD_ID() {
        return WATCH_CLASSLOADER_CMD_ID;
    }

    static int ra$INSPECT_CLASSLOADER_CMD_ID() {
        return INSPECT_CLASSLOADER_CMD_ID;
    }

    static int ra$GOTO_CMD_ID() {
        return GOTO_CMD_ID;
    }

    static int ra$GOTO_DECLARED_CMD_ID() {
        return GOTO_DECLARED_CMD_ID;
    }

    static int ra$GOTO_FIELD_CMD_ID() {
        return GOTO_FIELD_CMD_ID;
    }

    static int ra$USE_FILTERS_CMD_ID() {
        return USE_FILTERS_CMD_ID;
    }

    static int ra$OBJECT_PREFERENCES_CMD_ID() {
        return OBJECT_PREFERENCES_CMD_ID;
    }

    static int ra$COLLAPSE_ALL_CMD_ID() {
        return COLLAPSE_ALL_CMD_ID;
    }

    static int ra$SAVE_CMD_ID() {
        return SAVE_CMD_ID;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class SmartPanel
    extends EvaluatorPanel {
        private Map map;
        private List<String> lastExpressions;
        private boolean createNewExpressions;

        private void $init$() {
            this.createNewExpressions = true;
        }

        SmartPanel() {
            super(SmartWindow.this, SmartWindow.ra$smartWindowSettings(SmartWindow.this).getDataPanelSettings());
            this.$init$();
            this.map = new HashMap();
            this._actionPin = null;
            this._actionUnpin = null;
            this._actionViewWhole = SmartWindow.ra$actionViewWhole();
            this._actionViewAnnotations = SmartWindow.ra$actionViewAnnotations();
            this._actionViewAnnotationsForClass = SmartWindow.ra$actionViewAnnotationsForClass();
            this._actionAdjustRange = SmartWindow.ra$actionAdjustRange();
            this._actionToggleValue = SmartWindow.ra$actionToggleValue();
            this._actionModifyValue = SmartWindow.ra$actionModifyValue();
            this._actionWatch = SmartWindow.ra$actionWatch();
            this._actionInspect = SmartWindow.ra$actionInspect();
            this._actionWatchClassLoader = SmartWindow.ra$actionWatchClassLoader();
            this._actionInspectClassLoader = SmartWindow.ra$actionInspectClassLoader();
            this._actionGoto = SmartWindow.ra$actionGoto();
            this._actionGotoDeclared = SmartWindow.ra$actionGotoDeclared();
            this._actionGotoField = SmartWindow.ra$actionGotoField();
            this._actionUseFilters = SmartWindow.ra$actionUseFilters();
            this._actionObjectPreferences = SmartWindow.ra$actionObjectPreferences();
            this._actionCollapseAll = SmartWindow.ra$actionCollapseAll();
            this._actionSave = SmartWindow.ra$actionSave();
            this._PIN_CMD_ID = -1;
            this._UNPIN_CMD_ID = -1;
            this._VIEW_WHOLE_CMD_ID = SmartWindow.ra$VIEW_WHOLE_CMD_ID();
            this._VIEW_ANNOTATIONS_CMD_ID = SmartWindow.ra$VIEW_ANNOTATIONS_CMD_ID();
            this._VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID = SmartWindow.ra$VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID();
            this._ADJUST_RANGE_CMD_ID = SmartWindow.ra$ADJUST_RANGE_CMD_ID();
            this._TOGGLE_VALUE_CMD_ID = SmartWindow.ra$TOGGLE_VALUE_CMD_ID();
            this._MODIFY_VALUE_CMD_ID = SmartWindow.ra$MODIFY_VALUE_CMD_ID();
            this._WATCH_CMD_ID = SmartWindow.ra$WATCH_CMD_ID();
            this._INSPECT_CMD_ID = SmartWindow.ra$INSPECT_CMD_ID();
            this._WATCH_CLASSLOADER_CMD_ID = SmartWindow.ra$WATCH_CLASSLOADER_CMD_ID();
            this._INSPECT_CLASSLOADER_CMD_ID = SmartWindow.ra$INSPECT_CLASSLOADER_CMD_ID();
            this._GOTO_CMD_ID = SmartWindow.ra$GOTO_CMD_ID();
            this._GOTO_DECLARED_CMD_ID = SmartWindow.ra$GOTO_DECLARED_CMD_ID();
            this._GOTO_FIELD_CMD_ID = SmartWindow.ra$GOTO_FIELD_CMD_ID();
            this._USE_FILTERS_CMD_ID = SmartWindow.ra$USE_FILTERS_CMD_ID();
            this._OBJECT_PREFERENCES_CMD_ID = SmartWindow.ra$OBJECT_PREFERENCES_CMD_ID();
            this._COLLAPSE_ALL_CMD_ID = SmartWindow.ra$COLLAPSE_ALL_CMD_ID();
            this._SAVE_CMD_ID = SmartWindow.ra$SAVE_CMD_ID();
        }

        @Override
        protected void addPopupMenuItemsForCommon(ContextMenu popup, Context context) {
            super.addPopupMenuItemsForCommon(popup, context);
            this.update(SmartWindow.ra$actionSettings(), context);
            if (SmartWindow.ra$actionSettings().isEnabled()) {
                if (SmartWindow.ra$menuitemSettings() == null) {
                    SmartWindow.wa$menuitemSettings(popup.createMenuItem((ToggleAction)SmartWindow.ra$actionSettings()));
                }
                popup.add((Component)SmartWindow.ra$menuitemSettings(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
            }
        }

        @Override
        public boolean update(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (action.getValue("Debugger.actionOwner") == this) {
                if (this.treeTable == null || !this.dockableWindow.isVisible()) {
                    action.setEnabled(false);
                    return true;
                }
                if (!(this.treeTable.isEnabled() && this.debuggingProcess != null && this.vm != null || cmdId == SmartWindow.ra$SETTINGS_CMD_ID())) {
                    action.setEnabled(false);
                    return true;
                }
            }
            if (cmdId == SmartWindow.ra$SETTINGS_CMD_ID()) {
                action.setEnabled(true);
                return true;
            }
            return super.update(action, context);
        }

        @Override
        public boolean handleEvent(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (cmdId == SmartWindow.ra$SETTINGS_CMD_ID()) {
                String[] path = new String[]{DbgArb.getString(16), DbgArb.getString(893)};
                Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), path);
                return true;
            }
            return super.handleEvent(action, context);
        }

        @Override
        void processFinished(DebuggingProcess debuggingProcess) {
            super.processFinished(debuggingProcess);
            this.map.remove(debuggingProcess);
        }

        @Override
        public void updateData(DebuggingProcess debuggingProcess, DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo frame) {
            this.createNewExpressions = true;
            this.lastExpressions = null;
            this.updateDataImpl(debuggingProcess, vm, thread, frame);
        }

        private void updateDataImpl(DebuggingProcess debuggingProcess, DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo frame) {
            int handle = -1;
            if (ProfilingEvents.eventOn[11]) {
                handle = IdeProfile.startEvent((int)ProfilingEvents.eventId[11], (String)this.dockableWindow.getTitleName());
            }
            if (debuggingProcess != null && vm != null && thread != null && frame != null && !this.sameAsLastFrame(debuggingProcess, frame)) {
                this.insertCurrent(debuggingProcess, vm, thread, frame);
            }
            super.updateData(debuggingProcess, vm, thread, frame);
            if (ProfilingEvents.eventOn[11]) {
                IdeProfile.endEvent((int)handle);
            }
        }

        void refreshWindow() {
            this.updateDataImpl(this.debuggingProcess, this.vm, this.thread, this.thread.getStackFrame(0));
        }

        private boolean sameAsLastFrame(DebuggingProcess debuggingProcess, DebugStackFrameInfo frame) {
            LocationInfo lastInfo;
            List listOfInfo = (List)this.map.get(debuggingProcess);
            return listOfInfo != null && listOfInfo.size() > 0 && (lastInfo = (LocationInfo)listOfInfo.get(0)).isSameFrame(frame);
        }

        private void insertCurrent(DebuggingProcess debuggingProcess, DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo frame) {
            ArrayList<LocationInfo> listOfInfo = (ArrayList<LocationInfo>)this.map.get(debuggingProcess);
            if (listOfInfo == null) {
                listOfInfo = new ArrayList<LocationInfo>();
                this.map.put(debuggingProcess, listOfInfo);
            }
            LocationInfo info = new LocationInfo(debuggingProcess, frame);
            listOfInfo.add(0, info);
            int max = 10;
            while (listOfInfo.size() > 10) {
                listOfInfo.remove(10);
            }
        }

        private List<String> getExpressions(DebuggingProcess debuggingProcess) {
            int listSize;
            ArrayList<String> expressions = new ArrayList<String>();
            List listOfInfo = (List)this.map.get(debuggingProcess);
            if (listOfInfo != null && (listSize = listOfInfo.size()) > 0) {
                int numLocations = SmartWindow.ra$smartWindowSettings(SmartWindow.this).getNumberOfLocations();
                ArrayList<LocationInfo> locations = new ArrayList<LocationInfo>();
                int count = 0;
                LocationInfo currentInfo = (LocationInfo)listOfInfo.get(0);
                DebugMethodInfo currentMethod = currentInfo.getMethod();
                locations.add(currentInfo);
                if (++count < numLocations) {
                    int i = 1;
                    while (i < listSize) {
                        LocationInfo info = (LocationInfo)listOfInfo.get(i);
                        DebugMethodInfo method = info.getMethod();
                        if (ModelUtil.areEqual((Object)method, (Object)currentMethod)) {
                            locations.add(info);
                            if (++count >= numLocations) break;
                        }
                        ++i;
                    }
                }
                int i = count - 1;
                while (i >= 0) {
                    LocationInfo info = (LocationInfo)locations.get(i);
                    List infoExpressions = info.getExpressions(SmartWindow.ra$smartWindowSettings(SmartWindow.this), this.vm, this.thread, this.frame);
                    if (infoExpressions != null) {
                        int size = infoExpressions.size();
                        int e = 0;
                        while (e < size) {
                            String expression = (String)infoExpressions.get(e);
                            if (!expressions.contains(expression)) {
                                expressions.add(expression);
                            }
                            ++e;
                        }
                    }
                    --i;
                }
            }
            return expressions;
        }

        @Override
        protected void addDataItems() {
            if (this.frame != null) {
                List<String> expressions;
                if (!this.createNewExpressions && this.lastExpressions != null) {
                    expressions = this.lastExpressions;
                } else {
                    expressions = this.getExpressions(this.debuggingProcess);
                    this.lastExpressions = expressions;
                    this.createNewExpressions = false;
                }
                int size = expressions.size();
                if (size > 0) {
                    if (SmartWindow.ra$smartWindowSettings(SmartWindow.this).isSortExpressions()) {
                        Collections.sort(expressions);
                    }
                    List root = this.getRoot();
                    int i = 0;
                    while (i < size) {
                        String s = expressions.get(i);
                        EvaluatorItem ei = new EvaluatorItem(s);
                        this.addDataItem(root, ei, true, true);
                        ++i;
                    }
                }
            }
        }
    }
}

