/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.Assert;
import oracle.javatools.editor.FileOverviewMargin;
import oracle.javatools.editor.FileOverviewMark;
import oracle.javatools.editor.gutter.GutterColumn;
import oracle.javatools.editor.gutter.GutterColumnListener;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.runner.Source;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.runner.debug.Breakpoint;
import oracle.jdevimpl.runner.debug.BytecodeFileSystemHelper;
import oracle.jdevimpl.runner.debug.DbgArb;

final class SourceIcon
implements FileOverviewMark {
    static HighlightStyle disabledBPStyle;
    static HighlightStyle enabledBPStyle;
    static HighlightStyle ipStyle;
    static final int TYPE_BREAKPOINT = 0;
    static final int TYPE_WATCHPOINT = 1;
    static final int TYPE_IP = 2;
    private static final String[] columnNames;
    private static final int[] markOrder;
    private static final int[] markOptions;
    private static Map mapGutterToCodeEditor;
    private static List shownIcons;
    private final URL workspaceURL;
    private final URL projectURL;
    private final String pkg;
    private final String filename;
    private final URL url;
    private int line;
    private final String className;
    private final String fieldName;
    private final String fqMethodName;
    private final int offset;
    private final Node nodeToMatch;
    private ArrayResourceBundle iconBundle;
    private int iconKey;
    private HighlightStyle style;
    private final int type;
    private final Breakpoint breakpoint;
    private Map gutterMarks;
    public static final String DISABLED_BREAKPOINT_STYLE = "disabled-breakpoint";
    public static final String ENABLED_BREAKPOINT_STYLE = "enabled-breakpoint";
    public static final String EXECUTION_POINT_STYLE = "execution-point";
    private static final Map mapStyleToCategory;

    SourceIcon(URL workspaceURL, URL projectURL, String pkg, String filename, int line, Node nodeToMatch, ArrayResourceBundle iconBundle, int iconKey, HighlightStyle style, int type, Breakpoint breakpoint) {
        this.workspaceURL = workspaceURL;
        this.projectURL = projectURL;
        this.pkg = pkg;
        this.filename = filename;
        this.url = null;
        this.line = line;
        this.className = null;
        this.fieldName = null;
        this.fqMethodName = null;
        this.offset = -1;
        this.nodeToMatch = nodeToMatch;
        this.iconBundle = iconBundle;
        this.iconKey = iconKey;
        this.style = style;
        this.type = type;
        this.breakpoint = breakpoint;
        this.show();
    }

    SourceIcon(URL workspaceURL, URL projectURL, URL url, int line, Node nodeToMatch, ArrayResourceBundle iconBundle, int iconKey, HighlightStyle style, int type, Breakpoint breakpoint) {
        this.workspaceURL = workspaceURL;
        this.projectURL = projectURL;
        this.pkg = null;
        this.filename = null;
        this.url = url;
        this.line = line;
        this.className = null;
        this.fieldName = null;
        this.fqMethodName = null;
        this.offset = -1;
        this.nodeToMatch = nodeToMatch;
        this.iconBundle = iconBundle;
        this.iconKey = iconKey;
        this.style = style;
        this.type = type;
        this.breakpoint = breakpoint;
        this.show();
    }

    SourceIcon(URL workspaceURL, URL projectURL, String className, String fieldName, Node nodeToMatch, ArrayResourceBundle iconBundle, int iconKey, HighlightStyle style, int type, Breakpoint breakpoint) {
        this.workspaceURL = workspaceURL;
        this.projectURL = projectURL;
        this.pkg = null;
        this.filename = null;
        this.url = null;
        this.line = 0;
        this.className = className;
        this.fieldName = fieldName;
        this.fqMethodName = null;
        this.offset = -1;
        this.nodeToMatch = nodeToMatch;
        this.iconBundle = iconBundle;
        this.iconKey = iconKey;
        this.style = style;
        this.type = type;
        this.breakpoint = breakpoint;
        this.show();
    }

    SourceIcon(URL workspaceURL, URL projectURL, String fqMethodName, int offset, Node nodeToMatch, ArrayResourceBundle iconBundle, int iconKey, HighlightStyle style, int type, Breakpoint breakpoint) {
        this.workspaceURL = workspaceURL;
        this.projectURL = projectURL;
        this.pkg = null;
        this.filename = null;
        this.url = null;
        this.line = 0;
        this.className = null;
        this.fieldName = null;
        this.fqMethodName = fqMethodName;
        this.offset = offset;
        this.nodeToMatch = nodeToMatch;
        this.iconBundle = iconBundle;
        this.iconKey = iconKey;
        this.style = style;
        this.type = type;
        this.breakpoint = breakpoint;
        this.show();
    }

    Breakpoint getBreakpoint() {
        return this.breakpoint;
    }

    void show() {
        Assert.check((this.gutterMarks == null ? 1 : 0) != 0, (String)"SourceIcon.show called when already showing");
        this.gutterMarks = new HashMap();
        for (CodeEditorGutter gutter : mapGutterToCodeEditor.keySet()) {
            CodeEditor codeEditor = (CodeEditor)mapGutterToCodeEditor.get(gutter);
            if (!this.matchesGutter(gutter)) continue;
            this.makeMark(codeEditor, gutter);
        }
        shownIcons.add(this);
    }

    void hide() {
        Assert.check((this.gutterMarks != null ? 1 : 0) != 0, (String)"SourceIcon.hide called when already hidden");
        shownIcons.remove(this);
        for (CodeEditor codeEditor : this.gutterMarks.keySet()) {
            GutterMark gutterMark = (GutterMark)this.gutterMarks.get(codeEditor);
            this.removeMark(codeEditor, gutterMark, false);
        }
        this.gutterMarks.clear();
        this.gutterMarks = null;
    }

    private void removedDuringEdit(CodeEditor codeEditor, int line) {
        this.removeFileOverviewMark(codeEditor, line);
        this.gutterMarks.remove(codeEditor);
    }

    private void removeMark(CodeEditor codeEditor, GutterMark gutterMark, boolean removeFromMap) {
        this.removeFileOverviewMark(codeEditor, gutterMark.getLine());
        gutterMark.getGutterColumn().removeGutterMark(gutterMark);
        if (removeFromMap) {
            this.gutterMarks.remove(codeEditor);
        }
    }

    private void makeMark(CodeEditor codeEditor, CodeEditorGutter gutter) {
        int offset;
        GutterColumn gutterColumn = SourceIcon.createGutterColumn(gutter, this.type);
        Icon icon = this.iconBundle.getIconImpl(this.iconKey);
        int[] lineAndOffset = this.getLineAndOffset(codeEditor);
        int line = lineAndOffset[0];
        GutterMark gutterMark = gutterColumn.addGutterMark(line, icon, this.style, markOrder[this.type] + (offset = lineAndOffset[1]), markOptions[this.type]);
        if (gutterMark != null) {
            gutterMark.setUserData((Object)this);
            this.gutterMarks.put(codeEditor, gutterMark);
            this.addFileOverviewMark(codeEditor, line);
        }
    }

    private void addFileOverviewMark(CodeEditor codeEditor, int line) {
        String category = (String)mapStyleToCategory.get(this.style.getName());
        this.addFileOverviewMark(codeEditor, line, category);
    }

    private void removeFileOverviewMark(CodeEditor codeEditor, int line) {
        String category = (String)mapStyleToCategory.get(this.style.getName());
        this.removeFileOverviewMark(codeEditor, line, category);
    }

    private void addFileOverviewMark(CodeEditor codeEditor, int line, String category) {
        FileOverviewMargin fom = codeEditor.getFileOverviewMargin();
        if (fom != null) {
            fom.addMark(category, line, (FileOverviewMark)this);
        }
    }

    private void removeFileOverviewMark(CodeEditor codeEditor, int line, String category) {
        FileOverviewMargin fom = codeEditor.getFileOverviewMargin();
        if (fom != null) {
            fom.removeMark(category, line, (FileOverviewMark)this);
        }
    }

    private static GutterColumn createGutterColumn(CodeEditorGutter gutter, int type) {
        String columnName = columnNames[type];
        GutterColumn gutterColumn = gutter.lookupGutterColumn(columnName);
        if (gutterColumn == null) {
            SourceIconGutterColumnListener gutterColumnListener = new SourceIconGutterColumnListener();
            gutterColumn = gutter.createGutterColumn(columnName, (GutterColumnListener)gutterColumnListener);
            switch (type) {
                default: {
                    throw new IllegalArgumentException("type is invalid");
                }
                case 0: {
                    int breakpointWidth = Math.max(DbgArb.getIcon(606).getIconWidth(), Math.max(DbgArb.getIcon(284).getIconWidth(), DbgArb.getIcon(524).getIconWidth()));
                    gutterColumn.setReservedWidth(breakpointWidth);
                    break;
                }
                case 1: {
                    int watchpointWidth = Math.max(DbgArb.getIcon(580).getIconWidth(), DbgArb.getIcon(447).getIconWidth());
                    gutterColumn.setReservedWidth(watchpointWidth);
                    gutterColumn.setLayoutConstraint("breakpoint", 1);
                    break;
                }
                case 2: {
                    int width = DbgArb.getIcon(247).getIconWidth();
                    gutterColumn.setReservedWidth(width);
                    gutterColumn.setLayoutConstraint("lightbulb", 2);
                    break;
                }
            }
        }
        return gutterColumn;
    }

    private void handleGutterDestroyed(CodeEditor codeEditor, CodeEditorGutter gutter) {
        GutterMark gutterMark = (GutterMark)this.gutterMarks.get(codeEditor);
        if (gutterMark != null) {
            this.removeMark(codeEditor, gutterMark, true);
        }
    }

    boolean matchesIconLocation(CodeEditor codeEditor, int line) {
        GutterMark gutterMark = (GutterMark)this.gutterMarks.get(codeEditor);
        return gutterMark != null && gutterMark.getLine() == line;
    }

    void changeIcon(ArrayResourceBundle iconBundle, int iconKey, HighlightStyle style) {
        String oldCategory = (String)mapStyleToCategory.get(this.style.getName());
        String newCategory = (String)mapStyleToCategory.get(style.getName());
        this.iconBundle = iconBundle;
        this.iconKey = iconKey;
        this.style = style;
        for (CodeEditor codeEditor : this.gutterMarks.keySet()) {
            GutterMark gutterMark = (GutterMark)this.gutterMarks.get(codeEditor);
            Icon icon = iconBundle.getIconImpl(iconKey);
            gutterMark.setIcon(icon);
            if (oldCategory == newCategory) continue;
            this.removeFileOverviewMark(codeEditor, gutterMark.getLine(), oldCategory);
            this.addFileOverviewMark(codeEditor, gutterMark.getLine(), newCategory);
        }
    }

    CodeEditor getCodeEditor() {
        Iterator i;
        if (this.gutterMarks.size() > 0 && (i = this.gutterMarks.keySet().iterator()).hasNext()) {
            return (CodeEditor)i.next();
        }
        return null;
    }

    private JavaField getJavaField(Project jproject, URL nodeURL) {
        JavaManager javaManager = JavaManager.getJavaManager((Project)jproject);
        SourceFile sourceFile = javaManager.getSourceFile(nodeURL);
        if (sourceFile != null) {
            String sourceFilePackage = sourceFile.getPackageName();
            if (sourceFilePackage == null) {
                sourceFilePackage = "";
            }
            if (sourceFilePackage.equals(DebugShared.getPackage(this.className))) {
                List classes = sourceFile.getSourceClasses();
                for (SourceClass sourceClass : classes) {
                    if (!this.className.equals(sourceClass.getQualifiedName())) continue;
                    JavaField javaField = sourceClass.getDeclaredField(this.fieldName);
                    return javaField;
                }
            }
        }
        return null;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.breakpoint != null) {
            return this.breakpoint.getMarkToolTip(null, mouseEvent);
        }
        if (this.type == 2) {
            return DbgArb.getString(571);
        }
        return null;
    }

    public int getSelectionStart() {
        return this.offset;
    }

    public int getSelectionLength() {
        return 0;
    }

    public int getSeverity() {
        return 0;
    }

    int getLine() {
        return this.line;
    }

    private int[] getLineAndOffset(CodeEditor codeEditor) {
        int[] result = new int[2];
        if (codeEditor != null) {
            int lineFromBytecodeOffset;
            BytecodeFileSystemHelper bytecodeHelper;
            Node node;
            Context context;
            Node node2;
            Context context2;
            if (this.className != null && this.fieldName != null && (context2 = codeEditor.getContext()) != null && (node2 = context2.getNode()) != null) {
                JavaField javaField;
                Project jproject = context2.getProject();
                if (jproject == null) {
                    jproject = Ide.getActiveProject();
                }
                if ((javaField = this.getJavaField(jproject, node2.getURL())) instanceof SourceElement) {
                    SourceName sourceName;
                    SourceElement sourceField = (SourceElement)javaField;
                    int offset = sourceField.getStartOffset();
                    if (sourceField instanceof SourceHasName && (sourceName = ((SourceHasName)sourceField).getNameElement()) != null) {
                        offset = sourceName.getStartOffset();
                    }
                    result[0] = codeEditor.getLineFromOffset(offset);
                    result[1] = offset - codeEditor.getLineStartOffset(result[0]);
                    return result;
                }
            }
            if (this.fqMethodName != null && (context = codeEditor.getContext()) != null && (node = context.getNode()) != null && (bytecodeHelper = BytecodeFileSystemHelper.getInstance(false)) != null && (lineFromBytecodeOffset = bytecodeHelper.getLineFromBytecodeOffset(node.getURL(), this.offset)) != 0) {
                result[0] = lineFromBytecodeOffset;
                result[1] = 0;
                return result;
            }
        }
        result[0] = this.line;
        result[1] = 0;
        return result;
    }

    private boolean matchesGutter(CodeEditorGutter gutter) {
        Context context = gutter.getContext();
        if (context != null) {
            URL gutterWorkspaceURL;
            Workspace gutterWorkspace = context.getWorkspace();
            URL uRL = gutterWorkspaceURL = gutterWorkspace != null ? gutterWorkspace.getURL() : null;
            if (this.workspaceURL == null || gutterWorkspaceURL == null || URLFileSystem.equals((URL)this.workspaceURL, (URL)gutterWorkspaceURL)) {
                Node node;
                URL gutterProjectURL;
                Project gutterProject = context.getProject();
                URL uRL2 = gutterProjectURL = gutterProject != null ? gutterProject.getURL() : null;
                if ((this.projectURL == null || gutterProjectURL == null || URLFileSystem.equals((URL)this.projectURL, (URL)gutterProjectURL)) && (node = context.getNode()) != null) {
                    if (this.nodeToMatch != null) {
                        if (this.nodeToMatch.equals((Object)node)) {
                            return true;
                        }
                    } else {
                        URL nodeURL;
                        String nodeMethodName;
                        BytecodeFileSystemHelper bytecodeHelper;
                        JavaField javaField;
                        if (this.url != null && this.url.equals(node.getURL())) {
                            return true;
                        }
                        Project jproject = gutterProject;
                        if (jproject == null) {
                            jproject = Ide.getActiveProject();
                        }
                        if (this.filename != null && this.filename.equals(Source.getFilenameFromNode(node)) && Source.packageMatches(this.pkg, node, jproject)) {
                            return true;
                        }
                        if (this.className != null && (javaField = this.getJavaField(jproject, node.getURL())) != null) {
                            return true;
                        }
                        if (this.fqMethodName != null && (bytecodeHelper = BytecodeFileSystemHelper.getInstance(false)) != null && (nodeMethodName = BytecodeFileSystemHelper.getMethodName(nodeURL = node.getURL())) != null && this.fqMethodName.equals(nodeMethodName)) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    static void gutterCreated(CodeEditor codeEditor) {
        CodeEditorGutter gutter = codeEditor.getGutter();
        mapGutterToCodeEditor.put(gutter, codeEditor);
        SourceIcon.createGutterColumn(gutter, 0);
        SourceIcon.createGutterColumn(gutter, 1);
        try {
            Context context = codeEditor.getContext();
            if (context != null) {
                int i = shownIcons.size() - 1;
                while (i >= 0) {
                    SourceIcon sourceIcon = (SourceIcon)shownIcons.get(i);
                    if (sourceIcon.matchesGutter(gutter)) {
                        sourceIcon.makeMark(codeEditor, gutter);
                    }
                    --i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void gutterDestroyed(CodeEditor codeEditor) {
        try {
            CodeEditorGutter gutter = codeEditor.getGutter();
            mapGutterToCodeEditor.remove(gutter);
            int i = shownIcons.size() - 1;
            while (i >= 0) {
                SourceIcon sourceIcon = (SourceIcon)shownIcons.get(i);
                sourceIcon.handleGutterDestroyed(codeEditor, gutter);
                --i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static CodeEditor[] getOpenCodeEditors() {
        ArrayList<CodeEditor> temp = new ArrayList<CodeEditor>();
        for (CodeEditor codeEditor : mapGutterToCodeEditor.values()) {
            Context context = codeEditor.getContext();
            if (context == null) continue;
            temp.add(codeEditor);
        }
        return temp.toArray(new CodeEditor[temp.size()]);
    }

    static void removeColumn(int type) {
        if (!columnNames[type].equals("breakpoint")) {
            for (CodeEditorGutter gutter : mapGutterToCodeEditor.keySet()) {
                GutterColumn gutterColumn = gutter.lookupGutterColumn(columnNames[type]);
                if (gutterColumn == null) continue;
                gutter.removeGutterColumn(gutterColumn);
            }
        }
    }

    static void createHighlightStyles() {
        disabledBPStyle = CodeEditor.createHighlightStyle((String)DISABLED_BREAKPOINT_STYLE, (String)DbgArb.getString(121), (int)25, (Color)Color.black, (Color)Color.green);
        enabledBPStyle = CodeEditor.createHighlightStyle((String)ENABLED_BREAKPOINT_STYLE, (String)DbgArb.getString(418), (int)30, (Color)Color.white, (Color)Color.red);
        ipStyle = CodeEditor.createHighlightStyle((String)EXECUTION_POINT_STYLE, (String)DbgArb.getString(387), (int)40, (Color)Color.white, (Color)Color.blue);
        int order = 0;
        String ipCategory = order++ + EXECUTION_POINT_STYLE;
        mapStyleToCategory.put(EXECUTION_POINT_STYLE, ipCategory);
        String enabledBPCategory = order++ + ENABLED_BREAKPOINT_STYLE;
        mapStyleToCategory.put(ENABLED_BREAKPOINT_STYLE, enabledBPCategory);
        String disabledBPCategory = order + DISABLED_BREAKPOINT_STYLE;
        mapStyleToCategory.put(DISABLED_BREAKPOINT_STYLE, disabledBPCategory);
        FileOverviewMargin.setMarkColor((String)disabledBPCategory, (HighlightStyle)disabledBPStyle);
        FileOverviewMargin.setMarkColor((String)enabledBPCategory, (HighlightStyle)enabledBPStyle);
        FileOverviewMargin.setMarkColor((String)ipCategory, (HighlightStyle)ipStyle);
    }

    static {
        columnNames = new String[]{"breakpoint", "watchpoint", "ip"};
        markOrder = new int[]{0, 1000, 7000};
        markOptions = new int[]{1, 3, 2};
        mapGutterToCodeEditor = new HashMap();
        shownIcons = new ArrayList();
        mapStyleToCategory = new HashMap();
    }

    static Breakpoint ra$breakpoint(SourceIcon sourceIcon) {
        return sourceIcon.breakpoint;
    }

    static Map ra$mapGutterToCodeEditor() {
        return mapGutterToCodeEditor;
    }

    static void mav$removedDuringEdit(SourceIcon sourceIcon, CodeEditor codeEditor, int n) {
        sourceIcon.removedDuringEdit(codeEditor, n);
    }

    static void mav$removeFileOverviewMark(SourceIcon sourceIcon, CodeEditor codeEditor, int n) {
        sourceIcon.removeFileOverviewMark(codeEditor, n);
    }

    static int ra$line(SourceIcon sourceIcon) {
        return sourceIcon.line;
    }

    static void wa$line(SourceIcon sourceIcon, int n) {
        sourceIcon.line = n;
    }

    static void mav$addFileOverviewMark(SourceIcon sourceIcon, CodeEditor codeEditor, int n) {
        sourceIcon.addFileOverviewMark(codeEditor, n);
    }

    public static class SourceIconGutterColumnListener
    implements GutterColumnListener {
        public void markMoved(GutterMark gutterMark, int oldLine, int newLine) {
            SourceIcon sourceIcon = (SourceIcon)gutterMark.getUserData();
            CodeEditor codeEditor = (CodeEditor)SourceIcon.ra$mapGutterToCodeEditor().get(gutterMark.getGutter());
            SourceIcon.mav$removeFileOverviewMark(sourceIcon, codeEditor, oldLine);
            if (SourceIcon.ra$line(sourceIcon) != 0) {
                SourceIcon.wa$line(sourceIcon, newLine);
            }
            SourceIcon.mav$addFileOverviewMark(sourceIcon, codeEditor, newLine);
            if (SourceIcon.ra$breakpoint(sourceIcon) != null) {
                SourceIcon.ra$breakpoint(sourceIcon).markMoved(gutterMark, oldLine, newLine);
            }
        }

        public void markRemoved(GutterMark gutterMark, int deletedLine) {
            SourceIcon sourceIcon = (SourceIcon)gutterMark.getUserData();
            SourceIcon.mav$removedDuringEdit(sourceIcon, (CodeEditor)SourceIcon.ra$mapGutterToCodeEditor().get(gutterMark.getGutter()), gutterMark.getLine());
            if (SourceIcon.ra$breakpoint(sourceIcon) != null) {
                SourceIcon.ra$breakpoint(sourceIcon).markRemoved(gutterMark, deletedLine);
            }
        }

        public void markClicked(GutterMark gutterMark, int clickedLine, MouseEvent event) {
            SourceIcon sourceIcon = (SourceIcon)gutterMark.getUserData();
            if (SourceIcon.ra$breakpoint(sourceIcon) != null) {
                SourceIcon.ra$breakpoint(sourceIcon).markClicked(gutterMark, clickedLine, event);
            }
        }

        public String getMarkToolTip(GutterMark gutterMark, MouseEvent event) {
            SourceIcon sourceIcon = (SourceIcon)gutterMark.getUserData();
            return sourceIcon.getToolTipText(event);
        }
    }
}

