/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedOutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableWindow;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.peek.CodePeek;
import oracle.ide.peek.Peek;
import oracle.ide.peek.PeekableTable;
import oracle.ide.runner.DebuggerWindowProvider;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeProfile;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.View;
import oracle.ideri.util.Product;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugAnnotationInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugHasAnnotations;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.debugger.support.JDIInformationProvider;
import oracle.jdevimpl.java.util.JavaCodePeek;
import oracle.jdevimpl.runner.Helpers;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.BaseElement;
import oracle.jdevimpl.runner.debug.ColumnMenuListener;
import oracle.jdevimpl.runner.debug.ContextBuilder;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugDockableFactory;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.DebuggerWindow;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.Evaluator;
import oracle.jdevimpl.runner.debug.InspectorWindow;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.LocalsWindow;
import oracle.jdevimpl.runner.debug.ProfilingEvents;
import oracle.jdevimpl.runner.debug.StackWindowSettings;
import oracle.jdevimpl.runner.debug.UpdateableDataWindow;
import oracle.jdevimpl.runner.debug.WatchWindow;

final class StackWindow
extends DebuggerWindow
implements ListSelectionListener,
Controller,
ContextMenuListener,
ColumnMenuListener {
    private List tableData;
    private JTable table;
    private StackTableCellRenderer stackTableCellRenderer;
    private StackTableModel model;
    private DebugStackFrameInfo highlightStackFrame;
    private LocalsWindow localsWindow;
    private WatchWindow watchWindow;
    private boolean skippedUpdate;
    private DebuggingProcess debuggingProcess;
    private DebugVirtualMachine vm;
    private DebugThreadInfo thread;
    private int languages;
    private String title;
    private JScrollPane scrollPane;
    private StackWindowSettings stackSettings;
    private int preferredVisibleRowCount;
    private static IdeAction actionPopToHere;
    private static IdeAction actionGoTo;
    private static IdeAction actionViewAnnotations;
    private static IdeAction actionBytecode;
    private static IdeAction actionSave;
    private static IdeAction actionSettings;
    private static JMenuItem menuitemPopToHere;
    private static JMenuItem menuitemGoTo;
    private static JMenuItem menuitemViewAnnotations;
    private static JMenuItem menuitemBytecode;
    private static JMenuItem menuitemSave;
    private static JMenuItem menuitemSettings;
    private static final int POPTOHERE_CMD_ID;
    private static final int GOTO_CMD_ID;
    private static final int VIEW_ANNOTATIONS_CMD_ID;
    private static final int BYTECODE_CMD_ID;
    private static final int SAVE_CMD_ID;
    private static final int SETTINGS_CMD_ID;
    static final int COLUMN_CLASS = 0;
    static final int COLUMN_METHOD = 1;
    static final int COLUMN_FILENAME = 2;
    static final int COLUMN_LINE = 3;
    static final int COLUMN_OFFSET = 4;
    static final int NUMBER_OF_COLUMNS = 5;
    private TableColumn[] column;
    private int[] columnDefaultWidth;
    private boolean[] columnShowing;
    static final String STACK_WINDOW_ID = "Debugger.StackWindow";
    private static Icon stackTabIcon;
    private static final String NOT_AVAILABLE = "";
    private boolean allowUpdateDataWindows;
    private boolean adjustColumnsAlreadyDone;

    private void $init$() {
        this.skippedUpdate = true;
        this.preferredVisibleRowCount = 6;
        this.column = new TableColumn[5];
        this.columnDefaultWidth = new int[5];
        this.columnShowing = new boolean[5];
        this.allowUpdateDataWindows = true;
        this.adjustColumnsAlreadyDone = false;
    }

    StackWindow() {
        super(STACK_WINDOW_ID);
        this.$init$();
        this.title = DbgArb.getString(896);
        JDebugger.getInstance().getContextMenu().addContextMenuListener((ContextMenuListener)this);
        StackWindow.makeActions();
        this.setControllerForActions();
    }

    void setLocalsWindow(LocalsWindow localsWindow) {
        this.localsWindow = localsWindow;
        this.updateData(localsWindow);
    }

    void setWatchWindow(WatchWindow watchWindow) {
        this.watchWindow = watchWindow;
        this.updateData(watchWindow);
    }

    void newInspectorWindow(InspectorWindow inspectorWindow) {
        this.updateData(inspectorWindow);
    }

    public DebuggerWindowProvider.DebuggerWindowPosition getPosition() {
        return DebuggerWindowProvider.DebuggerWindowPosition.WEST;
    }

    public void refresh() {
        this.everythingChanged();
    }

    public boolean installByDefault() {
        return true;
    }

    public void shutDown() {
        this.saveSettings();
    }

    private void loadSettings() {
        int i = 0;
        while (i < 5) {
            int width = this.stackSettings.getColumnWidth(i);
            if (width != 0) {
                this.adjustColumnsAlreadyDone = true;
                this.column[i].setPreferredWidth(width);
            }
            ++i;
        }
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        String order = this.stackSettings.getColumnOrder();
        if (order != null) {
            int i2 = 0;
            while (i2 < 5) {
                String identifier;
                int comma = order.indexOf(44);
                if (comma != -1) {
                    identifier = order.substring(0, comma);
                    order = order.substring(comma + 1);
                } else {
                    identifier = order;
                }
                if (identifier.length() == 0) break;
                try {
                    int from = tableColumnModel.getColumnIndex(identifier);
                    if (from != i2) {
                        this.table.moveColumn(from, i2);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                ++i2;
            }
        }
    }

    void stackWindowSettingsChanged(boolean changed) {
        if (this.table == null) {
            return;
        }
        int i = 0;
        while (i < 5) {
            boolean show = this.stackSettings.getColumnVisible(i);
            if (this.columnShowing[i] != show) {
                this.columnShowing[i] = show;
                if (show) {
                    this.table.addColumn(this.column[i]);
                } else {
                    this.table.removeColumn(this.column[i]);
                }
            }
            ++i;
        }
        if (changed && this.table.isEnabled()) {
            SwingUtilities.invokeLater(new 1());
        }
        Dimension d = this.table.getPreferredSize();
        d.height = this.table.getTableHeader().getPreferredSize().height + this.preferredVisibleRowCount * this.table.getRowHeight() + this.scrollPane.getHorizontalScrollBar().getPreferredSize().height;
        this.scrollPane.setPreferredSize(d);
    }

    private void saveSettings() {
        if (this.table == null) {
            return;
        }
        int i = 0;
        while (i < 5) {
            this.stackSettings.setColumnWidth(i, this.column[i].getWidth());
            ++i;
        }
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        String order = NOT_AVAILABLE;
        Enumeration<TableColumn> e = tableColumnModel.getColumns();
        while (e.hasMoreElements()) {
            TableColumn column = e.nextElement();
            order = order + column.getIdentifier() + ",";
        }
        this.stackSettings.setColumnOrder(order);
    }

    static void addContextMenuToMainMenu(Menubar menubar, JMenu subMenu) {
        StackWindow.makeActions();
        float section = 1.0f;
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionPopToHere), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGoTo), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionViewAnnotations), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionBytecode), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSave), subMenu, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSettings), subMenu, section);
    }

    private static void makeActions() {
        if (actionGoTo == null) {
            actionGoTo = IdeAction.get((int)GOTO_CMD_ID, null, (String)DbgArb.getString(11), null, (Integer)DbgArb.getInteger(408), null, (int)-1, null, (boolean)false);
            actionGoTo.setEnabled(false);
            actionViewAnnotations = IdeAction.get((int)VIEW_ANNOTATIONS_CMD_ID, null, (String)DbgArb.getString(581), null, (Integer)DbgArb.getInteger(897), null, (int)-1, null, (boolean)false);
            actionViewAnnotations.setEnabled(false);
            actionBytecode = IdeAction.get((int)BYTECODE_CMD_ID, null, (String)DbgArb.getString(89), null, (Integer)DbgArb.getInteger(428), null, (int)-1, null, (boolean)false);
            actionBytecode.setEnabled(false);
            actionPopToHere = IdeAction.get((int)POPTOHERE_CMD_ID, null, (String)DbgArb.getString(880), null, (Integer)DbgArb.getInteger(342), null, (int)-1, null, (boolean)false);
            actionPopToHere.setEnabled(false);
            actionSettings = IdeAction.get((int)SETTINGS_CMD_ID, null, (String)RunMgrArb.getString(87), null, (Integer)RunMgrArb.getInteger(99), null, (int)-1, null, (boolean)false);
            actionSettings.setEnabled(false);
            actionSave = IdeAction.get((int)SAVE_CMD_ID, null, (String)RunMgrArb.getString(65), null, (Integer)RunMgrArb.getInteger(101), null, (int)-1, null, (boolean)false);
            actionSave.setEnabled(false);
        }
    }

    private void setControllerForActions() {
        IdeAction[] actions = new IdeAction[]{actionGoTo, actionViewAnnotations, actionBytecode, actionPopToHere, actionSettings, actionSave};
        JDebugger.setControllerForActions(actions, this);
    }

    public Component getGUI() {
        if (this.scrollPane == null) {
            this.stackSettings = StackWindowSettings.getInstance();
            this.createGUI();
            this.loadSettings();
            this.stackWindowSettingsChanged(false);
            DebugDockableFactory.updateSiteGeometry((Dockable)this);
            this.everythingChanged();
            this.stackSettings.addStructureChangeListener(new 2());
        }
        return this.scrollPane;
    }

    public ContextMenu getContextMenu() {
        return JDebugger.getInstance().getContextMenu();
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_deb_stackwindow_html");
    }

    public Controller getController() {
        return this;
    }

    public Context getContext(EventObject event) {
        DebugStackFrameInfo info;
        StackItem stackItem = this.getSelectedStackItem();
        JDIInformationProvider jdiInformationProvider = null;
        if (stackItem != null && (info = stackItem.getStackFrameInfo()) instanceof JDIInformationProvider) {
            jdiInformationProvider = (JDIInformationProvider)((Object)info);
        }
        return ContextBuilder.buildContext((Element)stackItem, (View)this, event, this.debuggingProcess, jdiInformationProvider);
    }

    public int getDefaultVisibility(Layout layout) {
        boolean visible = JDebugger.getInstance().canShowDebuggingWindows(layout);
        return visible ? 5 : 0;
    }

    public String getTabName() {
        return this.title;
    }

    public Icon getTabIcon() {
        if (stackTabIcon == null) {
            stackTabIcon = DbgArb.getIcon(242);
        }
        return stackTabIcon;
    }

    public String getTitleName() {
        return this.title;
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting() && this.table.isShowing()) {
            this.highlightStackFrame = this.getSelectedStackFrameInfo();
            this.updateData();
        }
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == GOTO_CMD_ID) {
            StackItem stackItem = this.getSelectedStackItem();
            if (stackItem != null) {
                stackItem.showInSource();
            }
            return true;
        }
        if (cmdId == VIEW_ANNOTATIONS_CMD_ID) {
            StackItem stackItem = this.getSelectedStackItem();
            if (stackItem != null) {
                stackItem.viewAnnotations();
            }
            return true;
        }
        if (cmdId == BYTECODE_CMD_ID) {
            StackItem stackItem = this.getSelectedStackItem();
            if (stackItem != null) {
                stackItem.showBytecode();
            }
            return true;
        }
        if (cmdId == POPTOHERE_CMD_ID) {
            StackItem stackItem = this.getSelectedStackItem();
            if (stackItem != null) {
                stackItem.popToHere();
            }
            return true;
        }
        if (cmdId == SETTINGS_CMD_ID) {
            String[] path = new String[]{DbgArb.getString(16), DbgArb.getString(374)};
            Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), path);
            return true;
        }
        if (cmdId == SAVE_CMD_ID) {
            this.saveToFile();
            return true;
        }
        if (cmdId == 18) {
            Object o;
            int column;
            StackItem stackItem = this.getSelectedStackItem();
            if (stackItem != null && (column = this.table.getSelectedColumn()) != -1 && (o = stackItem.getValueOfColumn(column)) != null) {
                IdeUtil.copyToClipboard((String)o.toString());
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (action.getValue("Debugger.actionOwner") == this) {
            if (this.table == null || !this.isVisible()) {
                action.setEnabled(false);
                return true;
            }
            if (!(this.table.isEnabled() && this.debuggingProcess != null && this.vm != null || cmdId == SETTINGS_CMD_ID)) {
                action.setEnabled(false);
                return true;
            }
        }
        if (cmdId == GOTO_CMD_ID) {
            StackItem stackItem = this.getSelectedStackItem();
            if (stackItem != null) {
                action.setEnabled(stackItem.canShowInSource());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == VIEW_ANNOTATIONS_CMD_ID) {
            StackItem stackItem = this.getSelectedStackItem();
            if (stackItem != null) {
                action.setEnabled(stackItem.canViewAnnotations());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == BYTECODE_CMD_ID) {
            StackItem stackItem = this.getSelectedStackItem();
            if (stackItem != null) {
                action.setEnabled(stackItem.canShowBytecode());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == POPTOHERE_CMD_ID) {
            StackItem stackItem = this.getSelectedStackItem();
            if (stackItem != null) {
                action.setEnabled(stackItem.canPopToHere());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == SETTINGS_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        if (cmdId == SAVE_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        if (cmdId == 18) {
            StackItem stackItem = this.getSelectedStackItem();
            int column = this.table.getSelectedColumn();
            action.setEnabled(stackItem != null && column != -1);
            return true;
        }
        return false;
    }

    public void menuWillShow(ContextMenu popup) {
        Context context = popup.getContext();
        if (this.table != null && (Helpers.contextMatchesSource(context, this.table) || Helpers.contextMatchesSource(context, this.scrollPane))) {
            StackItem stackItem = this.getSelectedStackItem();
            if (stackItem != null) {
                this.addPopupMenuItemsForStackItem(popup, context);
            }
            this.addPopupMenuItemsForStack(popup, context);
            this.addPopupMenuItemsForCommon(popup, context);
        }
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void showColumn(int index) {
        this.columnShowing[index] = true;
        if (this.stackSettings != null) {
            this.stackSettings.setColumnVisible(index, true);
        }
        this.table.addColumn(this.column[index]);
    }

    public void hideColumn(int index) {
        this.columnShowing[index] = false;
        if (this.stackSettings != null) {
            this.stackSettings.setColumnVisible(index, false);
        }
        this.table.removeColumn(this.column[index]);
    }

    private void createGUI() {
        this.tableData = new ArrayList();
        this.model = new StackTableModel(null);
        this.table = new PeekableStackTable(this.model);
        this.table.getAccessibleContext().setAccessibleName(this.getTitleName());
        this.table.setAutoResizeMode(DebugWindowSettings.getInstance().getTableResizeMode());
        Set emptySet = Collections.emptySet();
        this.table.setFocusTraversalKeys(0, emptySet);
        this.table.setFocusTraversalKeys(1, emptySet);
        Dimension spacing = new Dimension(0, 0);
        this.table.setIntercellSpacing(spacing);
        this.table.setShowHorizontalLines(false);
        this.table.setShowVerticalLines(false);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int i = 0;
        while (i < 5) {
            this.column[i] = tableColumnModel.getColumn(i);
            this.columnDefaultWidth[i] = this.column[i].getPreferredWidth();
            this.columnShowing[i] = true;
            ++i;
        }
        boolean[] showColumnInMenu = new boolean[5];
        Arrays.fill(showColumnInMenu, true);
        if (Product.isRaptor()) {
            showColumnInMenu[0] = false;
            showColumnInMenu[4] = false;
        }
        JDebugger.addColumnsMenu(this.table, this, showColumnInMenu);
        this.columnDefaultWidth[3] = this.columnDefaultWidth[3] / 2;
        this.column[3].setPreferredWidth(this.columnDefaultWidth[3]);
        this.columnDefaultWidth[4] = this.columnDefaultWidth[4] / 2;
        this.column[4].setPreferredWidth(this.columnDefaultWidth[4]);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        listSelectionModel.addListSelectionListener(this);
        this.stackTableCellRenderer = new StackTableCellRenderer();
        this.table.setDefaultRenderer(String.class, this.stackTableCellRenderer);
        JTableHeader tableHeader = this.table.getTableHeader();
        TableCellRenderer headerRenderer = tableHeader.getDefaultRenderer();
        tableHeader.setDefaultRenderer(new 3(this, headerRenderer));
        this.table.addMouseListener(new 4());
        tableHeader.addMouseListener(new 5());
        this.table.addKeyListener(new 6());
        this.scrollPane = new JScrollPane(this.table);
        Color background = this.table.getBackground();
        this.scrollPane.setBackground(background);
        this.scrollPane.getViewport().setBackground(background);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.addMouseListener(new 7());
        this.scrollPane.addComponentListener(new 8());
        this.table.addHierarchyListener(new 9());
    }

    private void adjustColumnsAfterResize() {
        if (this.adjustColumnsAlreadyDone) {
            return;
        }
        this.adjustColumnsAlreadyDone = true;
        JDebugger.adjustColumnsAfterResize(this.scrollPane, this.table);
    }

    void showPopup(MouseEvent e) {
        JDebugger.getInstance().showContextMenu(e, (DockableWindow)this, this.table);
    }

    private void addPopupMenuItemsForStackItem(ContextMenu popup, Context context) {
        this.update(actionPopToHere, context);
        if (actionPopToHere.isEnabled()) {
            if (menuitemPopToHere == null) {
                menuitemPopToHere = popup.createMenuItem((ToggleAction)actionPopToHere);
            }
            popup.add((Component)menuitemPopToHere, JDeveloperMenuConstants.SECTION_DYNAMIC_CTXT_MENU);
        }
        this.update(actionGoTo, context);
        if (actionGoTo.isEnabled()) {
            if (menuitemGoTo == null) {
                menuitemGoTo = popup.createMenuItem((ToggleAction)actionGoTo);
            }
            popup.add((Component)menuitemGoTo, JDeveloperMenuConstants.SECTION_NAVIGATE_CTXT_MENU);
        }
        this.update(actionViewAnnotations, context);
        if (actionViewAnnotations.isEnabled()) {
            if (menuitemViewAnnotations == null) {
                menuitemViewAnnotations = popup.createMenuItem((ToggleAction)actionViewAnnotations);
            }
            popup.add((Component)menuitemViewAnnotations, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(actionBytecode, context);
        if (actionBytecode.isEnabled()) {
            if (menuitemBytecode == null) {
                menuitemBytecode = popup.createMenuItem((ToggleAction)actionBytecode);
            }
            popup.add((Component)menuitemBytecode, JDeveloperMenuConstants.SECTION_NAVIGATE_CTXT_MENU);
        }
    }

    private void addPopupMenuItemsForStack(ContextMenu popup, Context context) {
    }

    private void addPopupMenuItemsForCommon(ContextMenu popup, Context context) {
        this.update(actionSave, context);
        if (actionSave.isEnabled()) {
            if (menuitemSave == null) {
                menuitemSave = popup.createMenuItem((ToggleAction)actionSave);
            }
            popup.add((Component)menuitemSave, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
        }
        this.update(actionSettings, context);
        if (actionSettings.isEnabled()) {
            if (menuitemSettings == null) {
                menuitemSettings = popup.createMenuItem((ToggleAction)actionSettings);
            }
            popup.add((Component)menuitemSettings, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
        }
    }

    private void selectRow(int row) {
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.clearSelection();
        listSelectionModel.addSelectionInterval(row, row);
    }

    private void saveToFile() {
        URL url;
        String dlgTitle = RunMgrArb.format(19, this.getTitleName());
        URLChooser chooser = DialogUtil.newURLChooser((Context)this.getContext());
        if (JDebugger.lastSavedFile != null) {
            chooser.setSelectedURL(JDebugger.lastSavedFile);
        }
        if (chooser.showSaveDialog((Component)Ide.getMainWindow(), dlgTitle) == 0 && (url = chooser.getSelectedURL()) != null) {
            JDebugger.lastSavedFile = url;
            WaitCursor wc = Ide.getWaitCursor();
            wc.show();
            Exception exceptionOccurred = null;
            try {
                PrintWriter out;
                String suffixUpper = URLFileSystem.getSuffix((URL)url).toUpperCase();
                boolean html = suffixUpper.equals(".HTML") || suffixUpper.equals(".HTM");
                PrintWriter printWriter = out = html ? JDebugger.printHtmlHeader(url, this.getTitleName()) : new PrintWriter(new BufferedOutputStream(URLFileSystem.openOutputStream((URL)url)));
                if (html) {
                    out.println("<table border=\"1\">");
                }
                TableColumnModel tableColumnModel = this.table.getColumnModel();
                int nColumns = tableColumnModel.getColumnCount();
                int[] columns = new int[nColumns];
                int i = 0;
                Enumeration<TableColumn> e = tableColumnModel.getColumns();
                while (e.hasMoreElements()) {
                    TableColumn column = e.nextElement();
                    columns[i++] = column.getModelIndex();
                }
                StringBuffer sb = new StringBuffer();
                StringBuffer sb2 = new StringBuffer();
                if (html) {
                    sb.append("<tr>");
                }
                i = 0;
                while (i < nColumns) {
                    String columnName = this.model.getColumnName(columns[i]);
                    if (html) {
                        sb.append("<th>");
                        columnName = IdeUtil.replaceHTMLReservedCharacters((String)columnName.toString());
                        sb.append(columnName);
                        sb.append("</th>");
                    } else {
                        sb.append(columnName);
                        int ii = columnName.length();
                        while (ii >= 0) {
                            sb2.append('-');
                            --ii;
                        }
                        if (i < nColumns - 1) {
                            sb.append('\t');
                            sb2.append('\t');
                        }
                    }
                    ++i;
                }
                if (html) {
                    sb.append("</tr>");
                }
                out.println(sb.toString());
                if (!html) {
                    out.println(sb2.toString());
                }
                int size = this.tableData.size();
                int row = 0;
                while (row < size) {
                    sb.setLength(0);
                    if (html) {
                        sb.append("<tr>");
                    }
                    i = 0;
                    while (i < nColumns) {
                        Object columnValue = this.model.getValueAt(row, columns[i]);
                        if (html) {
                            sb.append("<td>");
                            String columnValueString = IdeUtil.replaceHTMLReservedCharacters((String)columnValue.toString());
                            if (columnValueString.length() > 0) {
                                sb.append(columnValueString);
                            } else {
                                sb.append("&nbsp;");
                            }
                            sb.append("</td>");
                        } else {
                            sb.append(columnValue);
                            if (i < nColumns - 1) {
                                sb.append('\t');
                            }
                        }
                        ++i;
                    }
                    if (html) {
                        sb.append("</tr>");
                    }
                    out.println(sb.toString());
                    ++row;
                }
                if (html) {
                    out.println("</table>");
                    JDebugger.printHtmlFooter(out);
                }
                out.flush();
                out.close();
            }
            catch (Exception e) {
                exceptionOccurred = e;
            }
            wc.hide();
            if (exceptionOccurred != null) {
                String message = DbgArb.format(341, DbgArb.getString(896), URLFileSystem.getPlatformPathName((URL)url));
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exceptionOccurred, (String)dlgTitle, (String)message, null);
            }
        }
    }

    private void nowShown() {
        if (this.skippedUpdate && this.table.isEnabled()) {
            this.updateModel();
        }
    }

    void everythingChanged() {
        this.highlightStackFrame = null;
        this.updateModel();
    }

    void updateStack(DebuggingProcess debuggingProcess, DebugVirtualMachine vm, DebugThreadInfo thread) {
        int handle = -1;
        if (ProfilingEvents.eventOn[3]) {
            handle = IdeProfile.startEvent((int)ProfilingEvents.eventId[3]);
        }
        this.debuggingProcess = debuggingProcess;
        this.vm = vm;
        this.thread = thread;
        this.highlightStackFrame = null;
        this.updateModel();
        if (ProfilingEvents.eventOn[3]) {
            IdeProfile.endEvent((int)handle);
        }
    }

    private void updateModel() {
        if (this.table == null) {
            return;
        }
        this.allowUpdateDataWindows = false;
        try {
            this.stackTableCellRenderer.clear();
            DebugStackFrameInfo saveHighlightFrame = this.highlightStackFrame;
            this.table.getSelectionModel().clearSelection();
            this.highlightStackFrame = saveHighlightFrame;
            if (this.highlightStackFrame == null && this.thread != null) {
                this.highlightStackFrame = this.thread.getStackFrame(0);
            }
            this.table.setEnabled(true);
            if (this.table.isShowing()) {
                this.skippedUpdate = false;
                if (this.debuggingProcess != null && this.vm != null && this.thread != null) {
                    int languages = this.vm.getLanguages();
                    if (this.languages != languages) {
                        this.languages = languages;
                        int i = 0;
                        while (i < 5) {
                            this.column[i].setHeaderValue(this.model.getColumnName(i));
                            ++i;
                        }
                        this.table.getTableHeader().repaint();
                    }
                    DebugStackFrameInfo[] frames = this.thread != null ? this.thread.listStack() : new DebugStackFrameInfo[]{};
                    int framesLength = frames.length;
                    ArrayList<StackItem> stackItems = new ArrayList<StackItem>();
                    int i = 0;
                    while (i < framesLength) {
                        stackItems.add(new StackItem(frames[i]));
                        ++i;
                    }
                    saveHighlightFrame = this.highlightStackFrame;
                    this.updateTable(stackItems);
                    this.highlightStackFrame = saveHighlightFrame;
                    if (this.highlightStackFrame != null) {
                        int row = this.highlightStackFrame.getFrameNumber();
                        this.selectRow(row);
                    }
                } else {
                    this.updateTable(new ArrayList());
                }
            } else {
                this.skippedUpdate = true;
            }
        }
        finally {
            this.allowUpdateDataWindows = true;
        }
        this.updateData();
    }

    void clearStack() {
        if (this.table == null) {
            return;
        }
        int handle = -1;
        if (ProfilingEvents.eventOn[8]) {
            handle = IdeProfile.startEvent((int)ProfilingEvents.eventId[8]);
        }
        this.table.setEnabled(false);
        int size = this.tableData.size();
        int row = 0;
        while (row < size) {
            StackItem stackItem = (StackItem)this.tableData.get(row);
            stackItem.clearStack();
            ++row;
        }
        this.vm = null;
        this.thread = null;
        this.updateData();
        if (ProfilingEvents.eventOn[8]) {
            IdeProfile.endEvent((int)handle);
        }
    }

    void processFinished(DebuggingProcess debuggingProcess) {
        if (this.debuggingProcess == debuggingProcess) {
            this.debuggingProcess = null;
            this.highlightStackFrame = null;
            this.table.setEnabled(true);
            this.updateTable(new ArrayList());
        }
        if (this.localsWindow != null) {
            this.localsWindow.processFinished(debuggingProcess);
        }
        if (this.watchWindow != null) {
            this.watchWindow.processFinished(debuggingProcess);
        }
        Iterator i = JDebugger.getInstance().getInspectorWindows();
        while (i.hasNext()) {
            InspectorWindow inspectorWindow = (InspectorWindow)i.next();
            inspectorWindow.processFinished(debuggingProcess);
        }
    }

    private void updateData() {
        if (this.vm != null) {
            this.vm.setCurrentStackFrame(this.highlightStackFrame);
        }
        if (this.allowUpdateDataWindows) {
            this.updateData(this.localsWindow);
            this.updateData(this.watchWindow);
            Iterator i = JDebugger.getInstance().getInspectorWindows();
            while (i.hasNext()) {
                InspectorWindow inspectorWindow = (InspectorWindow)i.next();
                this.updateData(inspectorWindow);
            }
            this.updateCustomWindows();
        }
    }

    void updateEvaluator(Evaluator evaluator) {
        if (this.table.isEnabled() && this.debuggingProcess != null && this.vm != null && this.thread != null) {
            evaluator.setDebugContext(this.vm, this.thread, this.highlightStackFrame);
        } else {
            evaluator.setDebugContext(null, null, null);
        }
    }

    private void updateData(UpdateableDataWindow updateableDataWindow) {
        if (updateableDataWindow != null) {
            if (this.table != null && this.table.isEnabled()) {
                if (this.debuggingProcess != null && this.vm != null && this.thread != null) {
                    updateableDataWindow.updateData(this.debuggingProcess, this.vm, this.thread, this.highlightStackFrame);
                } else {
                    updateableDataWindow.updateData(null, null, null, null);
                }
            } else {
                updateableDataWindow.clearData();
            }
        }
    }

    private void updateCustomWindows() {
        if (this.debuggingProcess != null && this.vm != null && this.thread != null) {
            Evaluator evaluator = new Evaluator(true);
            evaluator.setDebugContext(this.vm, this.thread, this.highlightStackFrame);
            JDebugger.getInstance().refreshCustomWindows(evaluator, this.debuggingProcess);
        }
    }

    private void updateTable(List stackItems) {
        this.tableData = stackItems;
        this.model.fireTableChanged(new TableModelEvent(this.model));
    }

    private void updateColumn(int column) {
        this.clearCacheForColumn(column);
        this.model.fireTableChanged(new TableModelEvent(this.model, 0, this.tableData.size() - 1, column));
    }

    void clearCacheForColumn(int column) {
        int size = this.tableData.size();
        int row = 0;
        while (row < size) {
            StackItem stackItem = (StackItem)this.tableData.get(row);
            stackItem.clearCacheForColumn(column);
            ++row;
        }
    }

    private StackItem getSelectedStackItem() {
        int row;
        if (this.table != null && 0 <= (row = this.table.getSelectedRow()) && row < this.tableData.size()) {
            return (StackItem)this.tableData.get(row);
        }
        return null;
    }

    private DebugStackFrameInfo getSelectedStackFrameInfo() {
        StackItem stackItem = this.getSelectedStackItem();
        if (stackItem != null) {
            return stackItem.getStackFrameInfo();
        }
        return null;
    }

    static {
        POPTOHERE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStackPopToHere");
        GOTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStackGoTo");
        VIEW_ANNOTATIONS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStackViewAnnotations");
        BYTECODE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStackBytecode");
        SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStackSave");
        SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStackSettings");
        stackTabIcon = null;
    }

    static List ra$tableData(StackWindow stackWindow) {
        return stackWindow.tableData;
    }

    static StackTableModel ra$model(StackWindow stackWindow) {
        return stackWindow.model;
    }

    static int ra$languages(StackWindow stackWindow) {
        return stackWindow.languages;
    }

    static DebuggingProcess ra$debuggingProcess(StackWindow stackWindow) {
        return stackWindow.debuggingProcess;
    }

    static DebugVirtualMachine ra$vm(StackWindow stackWindow) {
        return stackWindow.vm;
    }

    static DebugThreadInfo ra$thread(StackWindow stackWindow) {
        return stackWindow.thread;
    }

    static JTable ra$table(StackWindow stackWindow) {
        return stackWindow.table;
    }

    static StackWindowSettings ra$stackSettings(StackWindow stackWindow) {
        return stackWindow.stackSettings;
    }

    static IdeAction ra$actionGoTo() {
        return actionGoTo;
    }

    static void mav$adjustColumnsAfterResize(StackWindow stackWindow) {
        stackWindow.adjustColumnsAfterResize();
    }

    static void mav$nowShown(StackWindow stackWindow) {
        stackWindow.nowShown();
    }

    static void mav$updateColumn(StackWindow stackWindow, int n) {
        stackWindow.updateColumn(n);
    }

    final class 1
    implements Runnable {
        public void run() {
            StackWindow.mav$updateColumn(StackWindow.this, 0);
        }
    }

    final class 2
    extends StructureChangeListener {
        public void structureValuesChanged(StructureChangeEvent e) {
            StackWindow.this.stackWindowSettingsChanged(true);
        }
    }

    final class 3
    extends DefaultTableCellRenderer {
        private final /* synthetic */ TableCellRenderer v$headerRenderer;
        final /* synthetic */ StackWindow this$0;

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (this.v$headerRenderer instanceof DefaultTableCellRenderer) {
                DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)this.v$headerRenderer;
                int modelColumn = table.convertColumnIndexToModel(column);
                int horizontalAlignment = 2;
                if (modelColumn == 3 || modelColumn == 4) {
                    horizontalAlignment = 4;
                }
                defaultTableCellRenderer.setHorizontalAlignment(horizontalAlignment);
            }
            return this.v$headerRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }

        public 3(StackWindow stackWindow, TableCellRenderer tableCellRenderer) {
            this.v$headerRenderer = tableCellRenderer;
            this.this$0 = stackWindow;
        }
    }

    final class 4
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                StackWindow.this.showPopup(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                StackWindow.this.showPopup(e);
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (StackWindow.ra$debuggingProcess(StackWindow.this) == null || !StackWindow.ra$debuggingProcess(StackWindow.this).isStopped()) {
                Toolkit.getDefaultToolkit().beep();
                DebuggingProcess.showStatus(DbgArb.format(253, StackWindow.this.getTitleName()));
            }
            if ((e.getModifiers() & 0x10) != 0 && e.getClickCount() == 2) {
                Context context = StackWindow.this.getContext(e);
                StackWindow.this.update(StackWindow.ra$actionGoTo(), context);
                if (StackWindow.ra$actionGoTo().isEnabled()) {
                    StackWindow.this.handleEvent(StackWindow.ra$actionGoTo(), context);
                }
            }
        }
    }

    final class 5
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            if (StackWindow.ra$debuggingProcess(StackWindow.this) == null || !StackWindow.ra$debuggingProcess(StackWindow.this).isStopped()) {
                Toolkit.getDefaultToolkit().beep();
                DebuggingProcess.showStatus(DbgArb.format(253, StackWindow.this.getTitleName()));
            }
        }
    }

    final class 6
    extends KeyAdapter {
        public void keyPressed(KeyEvent e) {
            int key = e.getKeyCode();
            switch (key) {
                case 10: {
                    Context context = StackWindow.this.getContext(e);
                    StackWindow.this.update(StackWindow.ra$actionGoTo(), context);
                    if (!StackWindow.ra$actionGoTo().isEnabled()) break;
                    StackWindow.this.handleEvent(StackWindow.ra$actionGoTo(), context);
                    e.consume();
                    break;
                }
            }
        }
    }

    final class 7
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                StackWindow.this.showPopup(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                StackWindow.this.showPopup(e);
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (StackWindow.ra$debuggingProcess(StackWindow.this) == null || !StackWindow.ra$debuggingProcess(StackWindow.this).isStopped()) {
                Toolkit.getDefaultToolkit().beep();
                DebuggingProcess.showStatus(DbgArb.format(253, StackWindow.this.getTitleName()));
            }
        }
    }

    final class 8
    extends ComponentAdapter {
        public void componentResized(ComponentEvent e) {
            StackWindow.mav$adjustColumnsAfterResize(StackWindow.this);
        }
    }

    final class 9
    implements HierarchyListener {
        public void hierarchyChanged(HierarchyEvent e) {
            if ((e.getChangeFlags() & (long)4) != 0L && StackWindow.ra$table(StackWindow.this).isShowing()) {
                StackWindow.mav$nowShown(StackWindow.this);
            }
        }
    }

    class StackTableCellRenderer
    extends DefaultTableCellRenderer {
        private StackItem stackItem;
        private int modelColumn;

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.stackItem = (StackItem)StackWindow.ra$tableData(StackWindow.this).get(row);
            this.modelColumn = table.convertColumnIndexToModel(column);
            int horizontalAlignment = 2;
            if (this.modelColumn == 3 || this.modelColumn == 4) {
                horizontalAlignment = 4;
            }
            this.setHorizontalAlignment(horizontalAlignment);
            if (column == 0) {
                this.setIcon(this.stackItem.getIcon());
            } else {
                this.setIcon(null);
            }
            AccessibleContext ac = this.getAccessibleContext();
            String accessibleName = StackTableModel.mav$getAccessibleNameAt(StackWindow.ra$model(StackWindow.this), row, this.modelColumn);
            if (accessibleName != null) {
                ac.setAccessibleName(accessibleName);
            }
            return this;
        }

        public String getToolTipText(MouseEvent event) {
            return this.stackItem.getToolTip(this.modelColumn);
        }

        void clear() {
            this.stackItem = null;
        }

        StackTableCellRenderer() {
        }
    }

    private final class StackTableModel
    extends AbstractTableModel {
        public int getRowCount() {
            return StackWindow.ra$tableData(StackWindow.this).size();
        }

        public int getColumnCount() {
            return 5;
        }

        public Class getColumnClass(int column) {
            return String.class;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    if (StackWindow.ra$languages(StackWindow.this) == 8) {
                        return DbgArb.getString(40);
                    }
                    if (StackWindow.ra$languages(StackWindow.this) == 4) {
                        return DbgArb.getString(437);
                    }
                    return DbgArb.getString(740);
                }
                case 1: {
                    if (Product.isRaptor()) {
                        return DbgArb.getString(835);
                    }
                    if (StackWindow.ra$languages(StackWindow.this) == 8) {
                        return DbgArb.getString(162);
                    }
                    if (StackWindow.ra$languages(StackWindow.this) == 4) {
                        return DbgArb.getString(308);
                    }
                    return DbgArb.getString(116);
                }
                case 2: {
                    return DbgArb.getString(595);
                }
                case 3: {
                    return DbgArb.getString(527);
                }
                case 4: {
                    return DbgArb.getString(642);
                }
            }
            return StackWindow.NOT_AVAILABLE;
        }

        public Object getValueAt(int row, int column) {
            try {
                StackItem stackItem = (StackItem)StackWindow.ra$tableData(StackWindow.this).get(row);
                Object object = stackItem.getValueOfColumn(column);
                return object;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        private String getAccessibleNameAt(int row, int column) {
            int id = 638;
            String columnName = this.getColumnName(column);
            String value = (String)this.getValueAt(row, column);
            if (value.length() == 0) {
                value = DbgArb.getString(32);
            }
            return DbgArb.format(id, columnName, value);
        }

        private StackTableModel() {
        }

        StackTableModel(1 var2_2) {
            this();
        }

        static String mav$getAccessibleNameAt(StackTableModel stackTableModel, int n, int n2) {
            return stackTableModel.getAccessibleNameAt(n, n2);
        }

        public final class 1 {
        }
    }

    private final class StackItem
    extends BaseElement {
        private DebugStackFrameInfo stackFrame;
        private DebugLocation location;
        private DebugClassInfo clazz;
        private DebugMethodInfo method;
        private String filename;
        private int line;
        private int bc;
        private String cachedMethodName;
        private String cachedClassName;

        StackItem(DebugStackFrameInfo stackFrame) {
            this.stackFrame = stackFrame;
            this.location = stackFrame.getLocation();
            if (this.location != null) {
                this.clazz = this.location.getClassInfo();
                this.method = this.location.getMethod();
                this.filename = this.location.getFilename();
                if (Product.isRaptor() && this.filename != null && this.filename.endsWith(".pls")) {
                    this.filename = this.filename.substring(0, this.filename.length() - 4);
                }
                this.line = this.location.getLine();
                this.bc = this.location.getBytecodeOffset();
            }
            this.setIcon(OracleIcons.getIcon((String)"method.png"));
        }

        void clearStack() {
            this.stackFrame = null;
            this.location = null;
            this.clazz = null;
            this.method = null;
        }

        void clearCacheForColumn(int column) {
            switch (column) {
                case 0: {
                    this.cachedClassName = null;
                    break;
                }
                case 1: {
                    this.cachedMethodName = null;
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
            }
        }

        Object getValueOfColumn(int column) {
            switch (column) {
                case 0: {
                    return this.getClassName();
                }
                case 1: {
                    return this.getMethodName();
                }
                case 2: {
                    return this.getFilename();
                }
                case 3: {
                    return this.getLine();
                }
                case 4: {
                    return this.getOffset();
                }
            }
            return null;
        }

        String getToolTip(int column) {
            String tooltip = null;
            if (!Product.isRaptor()) {
                switch (column) {
                    case 0: {
                        if (this.clazz == null) break;
                        tooltip = DebugShared.makeCourtesyClassName(this.clazz, true);
                        break;
                    }
                    case 1: {
                        if (this.method == null) break;
                        tooltip = DebugShared.makeCourtesyMethodName(this.method, false, true, this.stackFrame);
                        break;
                    }
                }
            }
            if (tooltip == null) {
                tooltip = (String)this.getValueOfColumn(column);
            }
            if (tooltip != null && tooltip.length() > 0) {
                return tooltip;
            }
            return null;
        }

        public String getShortLabel() {
            return this.getMethodName();
        }

        public Object getData() {
            return this;
        }

        DebugStackFrameInfo getStackFrameInfo() {
            return this.stackFrame;
        }

        String getClassName() {
            if (this.cachedClassName == null && StackWindow.ra$table(StackWindow.this).isEnabled() && this.clazz != null) {
                this.cachedClassName = DebugShared.makeCourtesyClassName(this.clazz, StackWindow.ra$stackSettings(StackWindow.this).isShowPackages());
            }
            if (this.cachedClassName != null) {
                return this.cachedClassName;
            }
            return StackWindow.NOT_AVAILABLE;
        }

        String getMethodName() {
            if (this.cachedMethodName == null && StackWindow.ra$table(StackWindow.this).isEnabled()) {
                if (Product.isRaptor()) {
                    if (this.stackFrame != null && this.stackFrame.getLanguage() == 2 && this.clazz != null && this.method != null) {
                        int thirdDot;
                        int secondDot;
                        String className = this.clazz.getName();
                        Assert.check((boolean)className.startsWith("$Oracle."));
                        int firstDot = className.indexOf(".");
                        if (firstDot != -1 && (secondDot = className.indexOf(".", 8)) != -1 && (thirdDot = className.indexOf(".", secondDot + 1)) != -1) {
                            String type = className.substring(firstDot + 1, secondDot);
                            String schemaDotBodyDotSubroutine = className.substring(secondDot + 1, thirdDot) + ".";
                            if (type.equals("Block")) {
                                schemaDotBodyDotSubroutine = schemaDotBodyDotSubroutine + DbgArb.getString(51);
                            } else {
                                if (type.equals("PackageBody") || type.equals("TypeBody")) {
                                    String body = className.substring(thirdDot + 1);
                                    schemaDotBodyDotSubroutine = schemaDotBodyDotSubroutine + body + ".";
                                }
                                schemaDotBodyDotSubroutine = schemaDotBodyDotSubroutine + this.method.getNameWithoutClassOrSignature();
                            }
                            this.cachedMethodName = schemaDotBodyDotSubroutine;
                        }
                    }
                    if (this.cachedMethodName == null && this.method != null) {
                        this.cachedMethodName = this.method.getNameWithoutSignature();
                    }
                } else if (this.method != null) {
                    this.cachedMethodName = DebugShared.makeCourtesyMethodName(this.method, false, false, this.stackFrame);
                }
            }
            if (this.cachedMethodName != null) {
                return this.cachedMethodName;
            }
            return StackWindow.NOT_AVAILABLE;
        }

        String getFilename() {
            if (this.filename != null) {
                return this.filename;
            }
            return StackWindow.NOT_AVAILABLE;
        }

        String getLine() {
            if (this.line > 0) {
                return Integer.toString(this.line);
            }
            return StackWindow.NOT_AVAILABLE;
        }

        String getOffset() {
            if (this.bc >= 0) {
                return Integer.toString(this.bc);
            }
            return StackWindow.NOT_AVAILABLE;
        }

        boolean canShowInSource() {
            return this.location != null || this.clazz != null;
        }

        void showInSource() {
            if (this.location != null) {
                StackWindow.ra$debuggingProcess(StackWindow.this).showSourceFile(this.location, true);
            } else if (this.clazz != null) {
                StackWindow.ra$debuggingProcess(StackWindow.this).showSourceFile(this.clazz);
            }
        }

        boolean canViewAnnotations() {
            return this.method instanceof DebugHasAnnotations && ((DebugHasAnnotations)((Object)this.method)).countAnnotations() > 0;
        }

        void viewAnnotations() {
            if (this.method instanceof DebugHasAnnotations) {
                DebugAnnotationInfo[] annotations = ((DebugHasAnnotations)((Object)this.method)).getAnnotations();
                String methodName = this.getMethodName();
                String dlgTitle = DbgArb.format(26, methodName);
                DataPanel.showAnnotationsDialog(dlgTitle, null, StackWindow.ra$debuggingProcess(StackWindow.this), StackWindow.ra$vm(StackWindow.this), StackWindow.ra$thread(StackWindow.this), this.stackFrame, annotations);
            }
        }

        boolean canPopToHere() {
            if (StackWindow.ra$debuggingProcess(StackWindow.this) != null && StackWindow.ra$vm(StackWindow.this) != null && StackWindow.ra$thread(StackWindow.this) != null && StackWindow.ra$vm(StackWindow.this).getCapabilities().canPopFrames() && this.stackFrame.getFrameNumber() != 0) {
                int row = StackWindow.ra$tableData(StackWindow.this).indexOf(this);
                while (row >= 0) {
                    StackItem stackItem = (StackItem)StackWindow.ra$tableData(StackWindow.this).get(row);
                    if (stackItem.method == null) {
                        return false;
                    }
                    if ((stackItem.method.getAccess() & 0x100) != 0) {
                        return false;
                    }
                    --row;
                }
                return true;
            }
            return false;
        }

        void popToHere() {
            if (this.canPopToHere()) {
                this.stackFrame.popBackToHere();
                StackWindow.ra$debuggingProcess(StackWindow.this).stackFramesPopped(StackWindow.ra$thread(StackWindow.this));
            }
        }

        boolean canShowBytecode() {
            return StackWindow.ra$vm(StackWindow.this) != null && StackWindow.ra$vm(StackWindow.this).getCapabilities().canDisassembleMethod() && this.stackFrame.getLanguage() == 1 && this.method != null;
        }

        void showBytecode() {
            if (this.canShowBytecode()) {
                StackWindow.ra$debuggingProcess(StackWindow.this).showBytecode(this.method, this.bc);
            }
        }
    }

    private class PeekableStackTable
    extends PeekableTable {
        PeekableStackTable(TableModel model) {
            super(model);
        }

        public Peek createPeek(int row, int col) {
            StackItem item = (StackItem)StackWindow.ra$tableData(StackWindow.this).get(row);
            if (item.canShowInSource() && item.getLine().length() > 0) {
                String fqName = item.getStackFrameInfo().getLocation().getClassInfo().getName();
                JavaManager jMan = JavaManager.getInstance((Project)StackWindow.ra$debuggingProcess(StackWindow.this).getProject());
                URL url = jMan.getJavaClassLocator().getSourceURL(fqName);
                if (url == null) {
                    return null;
                }
                Rectangle rect = this.getCellRect(row, 0, true);
                rect.add(this.getCellRect(row, this.getColumnCount() - 1, true));
                CodePeek peek = JavaCodePeek.createCodePeek(StackWindow.ra$debuggingProcess(StackWindow.this).getProject(), url, Integer.parseInt(item.getLine()), fqName + " " + item.getLongLabel(), (JComponent)((Object)this), rect, "execution-point");
                return peek;
            }
            return null;
        }
    }
}

