/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.StackWindowSettings;

public final class StackWindowSettingsPanel
extends DefaultTraversablePanel {
    private JCheckBox showColumnClassCheckBox;
    private JCheckBox showColumnMethodCheckBox;
    private JCheckBox showColumnFilenameCheckBox;
    private JCheckBox showColumnLineCheckBox;
    private JCheckBox showPackagesCheckBox;
    private JLabel spacerLabel;

    private void $init$() {
        this.showColumnClassCheckBox = new JCheckBox();
        this.showColumnMethodCheckBox = new JCheckBox();
        this.showColumnFilenameCheckBox = new JCheckBox();
        this.showColumnLineCheckBox = new JCheckBox();
        this.showPackagesCheckBox = new JCheckBox();
        this.spacerLabel = new JLabel();
    }

    public StackWindowSettingsPanel() {
        this.$init$();
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_deb_stackwindowsetpanel_html");
        this.setLayout(new GridBagLayout());
        ResourceUtils.resButton((AbstractButton)this.showColumnClassCheckBox, (String)DbgArb.getString(587));
        ResourceUtils.resButton((AbstractButton)this.showColumnMethodCheckBox, (String)DbgArb.getString(144));
        ResourceUtils.resButton((AbstractButton)this.showColumnFilenameCheckBox, (String)DbgArb.getString(520));
        ResourceUtils.resButton((AbstractButton)this.showColumnLineCheckBox, (String)DbgArb.getString(170));
        ResourceUtils.resButton((AbstractButton)this.showPackagesCheckBox, (String)DbgArb.getString(915));
        this.spacerLabel.setEnabled(false);
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0);
        Insets borderInsets = new Insets(0, 0, 0, 0);
        this.add(this.makeChooseColumnsPanel(borderInsets), constraints);
        ++constraints.gridy;
        constraints.insets.top = 10;
        this.add(this.makeMiscPanel(borderInsets), constraints);
        ++constraints.gridy;
        constraints.weighty = 1.0;
        this.add(this.spacerLabel, constraints);
    }

    private JPanel makeChooseColumnsPanel(Insets borderInsets) {
        JPanel panel = new JPanel(new GridLayout(0, 2, 0, 0));
        TitledBorder border = BorderFactory.createTitledBorder(RunMgrArb.getString(70));
        panel.setBorder(border);
        if (borderInsets != null) {
            Insets temp = border.getBorderInsets(panel);
            borderInsets.top = temp.top;
            borderInsets.left = temp.left;
            borderInsets.bottom = temp.bottom;
            borderInsets.right = temp.right;
        }
        panel.add(this.showColumnClassCheckBox);
        panel.add(this.showColumnMethodCheckBox);
        panel.add(this.showColumnFilenameCheckBox);
        panel.add(this.showColumnLineCheckBox);
        return panel;
    }

    private JPanel makeMiscPanel(Insets borderInsets) {
        JPanel panel = new JPanel(new GridLayout(0, 1, 0, 0));
        panel.setBorder(BorderFactory.createEmptyBorder(0, borderInsets.left, 0, borderInsets.right));
        panel.add(this.showPackagesCheckBox);
        return panel;
    }

    private StackWindowSettings getData(TraversableContext tc) {
        return StackWindowSettings.getInstance(tc.getPropertyStorage());
    }

    public void onEntry(TraversableContext tc) {
        StackWindowSettings settings = this.getData(tc);
        this.showColumnClassCheckBox.setSelected(settings.getColumnVisible(0));
        this.showColumnMethodCheckBox.setSelected(settings.getColumnVisible(1));
        this.showColumnFilenameCheckBox.setSelected(settings.getColumnVisible(2));
        this.showColumnLineCheckBox.setSelected(settings.getColumnVisible(3));
        this.showPackagesCheckBox.setSelected(settings.isShowPackages());
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        StackWindowSettings settings = this.getData(tc);
        settings.setColumnVisible(0, this.showColumnClassCheckBox.isSelected());
        settings.setColumnVisible(1, this.showColumnMethodCheckBox.isSelected());
        settings.setColumnVisible(2, this.showColumnFilenameCheckBox.isSelected());
        settings.setColumnVisible(3, this.showColumnLineCheckBox.isSelected());
        settings.setShowPackages(this.showPackagesCheckBox.isSelected());
    }
}

