/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedOutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.AbstractTreeTableModel;
import oracle.ide.controls.JFastTreeTable;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.TreeTableModel;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.docking.DockableWindow;
import oracle.ide.model.Element;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeProfile;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.View;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugThreadGroupInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.debugger.support.JDIInformationProvider;
import oracle.jdevimpl.runner.Helpers;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.BaseElement;
import oracle.jdevimpl.runner.debug.ClassesWindow;
import oracle.jdevimpl.runner.debug.ColumnMenuListener;
import oracle.jdevimpl.runner.debug.ContextBuilder;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.EvaluatorItem;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.ProfilingEvents;
import oracle.jdevimpl.runner.debug.ThreadsPanelSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ThreadsPanel
implements TreeExpansionListener,
TreeSelectionListener,
Controller,
ContextMenuListener,
Comparator,
ColumnMenuListener {
    protected DockableWindow dockableWindow;
    protected ThreadTreeTableModel model;
    protected JFastTreeTable treeTable;
    private JScrollPane scrollPane;
    private boolean skippedUpdate;
    protected DebuggingProcess debuggingProcess;
    protected DebugVirtualMachine vm;
    private ThreadsPanelSettings threadsPanelSettings;
    protected int preferredVisibleRowCount;
    protected boolean boldCurrentThreadName;
    protected boolean boldDeadlockedThreadStatus;
    protected IdeAction _actionGoTo;
    protected IdeAction _actionSave;
    protected JMenuItem _menuitemGoTo;
    protected JMenuItem _menuitemSave;
    protected int _GOTO_CMD_ID;
    protected int _SAVE_CMD_ID;
    static final int COLUMN_NAME = 0;
    static final int COLUMN_STATUS = 1;
    static final int COLUMN_GROUP = 2;
    static final int COLUMN_PRIORITY = 3;
    static final int COLUMN_DAEMON = 4;
    static final int NUMBER_OF_COLUMNS = 5;
    protected TableColumn[] column;
    protected int[] columnDefaultWidth;
    private boolean[] columnShowing;
    private static Icon threadGroupIcon = null;
    private static Icon threadIcon = null;
    private static Icon threadIconGray = null;
    private static Icon currentThreadIcon = null;
    private static Icon currentThreadIconGray = null;
    private static final String NOT_AVAILABLE = "";
    private boolean adjustColumnsAlreadyDone;
    private Font normalFont;
    private Font boldFont;

    private void $init$() {
        this.skippedUpdate = true;
        this.preferredVisibleRowCount = 6;
        this.boldCurrentThreadName = true;
        this.boldDeadlockedThreadStatus = true;
        this.column = new TableColumn[5];
        this.columnDefaultWidth = new int[5];
        this.columnShowing = new boolean[5];
        this.adjustColumnsAlreadyDone = false;
    }

    ThreadsPanel(DockableWindow dockableWindow, ThreadsPanelSettings threadsPanelSettings) {
        this.$init$();
        this.dockableWindow = dockableWindow;
        this.threadsPanelSettings = threadsPanelSettings;
        JDebugger.getInstance().getContextMenu().addContextMenuListener((ContextMenuListener)this);
        threadsPanelSettings.addStructureChangeListener(new 1());
    }

    @Override
    public void showColumn(int index) {
        if (index != 0) {
            this.columnShowing[index] = true;
            if (this.threadsPanelSettings != null) {
                this.threadsPanelSettings.setColumnVisible(index, true);
            }
            this.treeTable.addColumn(this.column[index]);
        }
    }

    @Override
    public void hideColumn(int index) {
        if (index != 0) {
            this.columnShowing[index] = false;
            if (this.threadsPanelSettings != null) {
                this.threadsPanelSettings.setColumnVisible(index, false);
            }
            this.treeTable.removeColumn(this.column[index]);
        }
    }

    private void createGUI() {
        List modelRoot = Collections.synchronizedList(new ArrayList());
        this.model = new ThreadTreeTableModel(modelRoot);
        this.treeTable = new JFastTreeTable((TreeTableModel)this.model);
        this.treeTable.setKeySearchNavigable(true);
        this.treeTable.getAccessibleContext().setAccessibleName(this.dockableWindow.getTitleName());
        this.treeTable.setAutoResizeMode(DebugWindowSettings.getInstance().getTableResizeMode());
        Set emptySet = Collections.emptySet();
        this.treeTable.setFocusTraversalKeys(0, emptySet);
        this.treeTable.setFocusTraversalKeys(1, emptySet);
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        int i = 0;
        while (i < 5) {
            this.column[i] = tableColumnModel.getColumn(i);
            this.columnDefaultWidth[i] = this.column[i].getPreferredWidth();
            this.columnShowing[i] = true;
            ++i;
        }
        boolean[] showColumnInMenu = new boolean[5];
        Arrays.fill(showColumnInMenu, true);
        showColumnInMenu[0] = false;
        JDebugger.addColumnsMenu((JTable)this.treeTable, this, showColumnInMenu);
        this.columnDefaultWidth[0] = this.columnDefaultWidth[0] * 2;
        this.column[0].setPreferredWidth(this.columnDefaultWidth[0]);
        this.columnDefaultWidth[4] = this.columnDefaultWidth[4] / 2;
        this.column[4].setPreferredWidth(this.columnDefaultWidth[4]);
        ListSelectionModel listSelectionModel = this.treeTable.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        JTree tree = this.treeTable.getTree();
        tree.setRootVisible(false);
        TreeSelectionModel treeSelectionModel = tree.getSelectionModel();
        treeSelectionModel.setSelectionMode(1);
        tree.addTreeExpansionListener(this);
        tree.addTreeSelectionListener(this);
        tree.setCellRenderer(new 2());
        this.treeTable.setDefaultRenderer(String.class, (TableCellRenderer)new 3());
        TableCellRenderer booleanRenderer = this.treeTable.getDefaultRenderer(Boolean.class);
        if (booleanRenderer instanceof JCheckBox) {
            JCheckBox checkBox = (JCheckBox)((Object)booleanRenderer);
            checkBox.setBorderPaintedFlat(true);
        }
        JTableHeader tableHeader = this.treeTable.getTableHeader();
        TableCellRenderer headerRenderer = tableHeader.getDefaultRenderer();
        tableHeader.setDefaultRenderer(new 4(this, headerRenderer));
        this.treeTable.addMouseListener((MouseListener)new 5());
        tableHeader.addMouseListener(new 6());
        this.treeTable.addKeyListener((KeyListener)new 7());
        this.scrollPane = new JScrollPane((Component)this.treeTable);
        Color background = this.treeTable.getBackground();
        this.scrollPane.setBackground(background);
        this.scrollPane.getViewport().setBackground(background);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.addMouseListener(new 8());
        this.scrollPane.addComponentListener(new 9());
        this.treeTable.addHierarchyListener((HierarchyListener)new 10());
        this.adjustGUI();
    }

    protected void adjustGUI() {
    }

    private void adjustColumnsAfterResize() {
        if (this.adjustColumnsAlreadyDone) {
            return;
        }
        this.adjustColumnsAlreadyDone = true;
        JDebugger.adjustColumnsAfterResize(this.scrollPane, (JTable)this.treeTable);
    }

    private Font getNormalFont() {
        if (this.normalFont == null) {
            this.normalFont = this.treeTable.getTree().getFont();
        }
        return this.normalFont;
    }

    private Font getBoldFont() {
        if (this.boldFont == null) {
            this.boldFont = this.getNormalFont().deriveFont(1);
        }
        return this.boldFont;
    }

    Component getGUI() {
        if (this.scrollPane == null) {
            this.createGUI();
        }
        return this.scrollPane;
    }

    void loadSettings() {
        int i = 0;
        while (i < 5) {
            int width = this.threadsPanelSettings.getColumnWidth(i);
            if (width != 0) {
                this.adjustColumnsAlreadyDone = true;
                this.column[i].setPreferredWidth(width);
            }
            ++i;
        }
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        String order = this.threadsPanelSettings.getColumnOrder();
        if (order != null) {
            int i2 = 0;
            while (i2 < 5) {
                String identifier;
                int comma = order.indexOf(44);
                if (comma != -1) {
                    identifier = order.substring(0, comma);
                    order = order.substring(comma + 1);
                } else {
                    identifier = order;
                }
                if (identifier.length() == 0) break;
                try {
                    int from = tableColumnModel.getColumnIndex(identifier);
                    if (from != i2) {
                        this.treeTable.moveColumn(from, i2);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                ++i2;
            }
        }
    }

    void threadsPanelSettingsChanged(boolean changed) {
        if (this.treeTable == null) {
            return;
        }
        int i = 0;
        while (i < 5) {
            boolean show = this.threadsPanelSettings.getColumnVisible(i);
            if (this.columnShowing[i] != show) {
                this.columnShowing[i] = show;
                if (show) {
                    this.treeTable.addColumn(this.column[i]);
                } else {
                    this.treeTable.removeColumn(this.column[i]);
                }
            }
            ++i;
        }
        if (changed && this.treeTable.isEnabled()) {
            SwingUtilities.invokeLater(new 11());
        }
        Dimension d = this.treeTable.getPreferredSize();
        d.height = this.treeTable.getTableHeader().getPreferredSize().height + this.preferredVisibleRowCount * this.treeTable.getRowHeight() + this.scrollPane.getHorizontalScrollBar().getPreferredSize().height;
        this.scrollPane.setPreferredSize(d);
    }

    void saveSettings() {
        if (this.treeTable == null) {
            return;
        }
        int i = 0;
        while (i < 5) {
            this.threadsPanelSettings.setColumnWidth(i, this.column[i].getWidth());
            ++i;
        }
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        String order = NOT_AVAILABLE;
        Enumeration<TableColumn> e = tableColumnModel.getColumns();
        while (e.hasMoreElements()) {
            TableColumn column = e.nextElement();
            order = order + column.getIdentifier() + ",";
        }
        this.threadsPanelSettings.setColumnOrder(order);
    }

    Context getContext() {
        return this.getContext(null);
    }

    Context getContext(EventObject event) {
        Object info;
        ThreadItem threadItem = this.getSelectedThreadItem();
        JDIInformationProvider jdiInformationProvider = null;
        if (threadItem != null && (info = threadItem.getInfo()) instanceof JDIInformationProvider) {
            jdiInformationProvider = (JDIInformationProvider)info;
        }
        return ContextBuilder.buildContext((Element)threadItem, (View)this.dockableWindow, event, this.debuggingProcess, jdiInformationProvider);
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        this.model.branchExpanded(event.getPath());
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        this.model.branchCollapsed(event.getPath());
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == this._GOTO_CMD_ID) {
            ThreadItem threadItem = this.getSelectedThreadItem();
            if (threadItem != null) {
                threadItem.showInSource();
            }
            return true;
        }
        if (cmdId == this._SAVE_CMD_ID) {
            this.saveToFile();
            return true;
        }
        if (cmdId == 18) {
            Object o;
            int column;
            ThreadItem threadItem = this.getSelectedThreadItem();
            if (threadItem != null && (column = this.treeTable.getSelectedColumn()) != -1 && (o = this.model.getValueAt(threadItem, column)) != null) {
                IdeUtil.copyToClipboard((String)o.toString());
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (action.getValue("Debugger.actionOwner") == this) {
            if (this.treeTable == null || !this.dockableWindow.isVisible()) {
                action.setEnabled(false);
                return true;
            }
            if (!this.treeTable.isEnabled() || this.debuggingProcess == null || this.vm == null) {
                action.setEnabled(false);
                return true;
            }
        }
        if (cmdId == this._GOTO_CMD_ID) {
            ThreadItem threadItem = this.getSelectedThreadItem();
            if (threadItem != null) {
                action.setEnabled(threadItem.canShowInSource());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == this._SAVE_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        if (cmdId == 18) {
            ThreadItem threadItem = this.getSelectedThreadItem();
            int column = this.treeTable.getSelectedColumn();
            action.setEnabled(threadItem != null && column != -1);
            return true;
        }
        return false;
    }

    public void menuWillShow(ContextMenu popup) {
        Context context = popup.getContext();
        if (this.treeTable != null && context.getView() == this.dockableWindow && (Helpers.contextMatchesSource(context, this.treeTable) || Helpers.contextMatchesSource(context, this.scrollPane))) {
            ThreadItem threadItem = this.getSelectedThreadItem();
            if (threadItem != null) {
                this.addPopupMenuItemsForThreadItem(popup, context);
            }
            this.addPopupMenuItemsForThreads(popup, context);
            this.addPopupMenuItemsForTreeTable(popup, context);
            this.addPopupMenuItemsForCommon(popup, context);
        }
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public int compare(Object o1, Object o2) {
        if (o1 instanceof DebugThreadGroupInfo) {
            DebugThreadGroupInfo group1 = (DebugThreadGroupInfo)o1;
            DebugThreadGroupInfo group2 = (DebugThreadGroupInfo)o2;
            return group1.getName().compareToIgnoreCase(group2.getName());
        }
        DebugThreadInfo thread1 = (DebugThreadInfo)o1;
        DebugThreadInfo thread2 = (DebugThreadInfo)o2;
        return thread1.getName().compareToIgnoreCase(thread2.getName());
    }

    protected void addPopupMenuItemsForThreadItem(ContextMenu popup, Context context) {
        this.update(this._actionGoTo, context);
        if (this._actionGoTo.isEnabled()) {
            if (this._menuitemGoTo == null) {
                this._menuitemGoTo = popup.createMenuItem((ToggleAction)this._actionGoTo);
            }
            popup.add((Component)this._menuitemGoTo, JDeveloperMenuConstants.SECTION_NAVIGATE_CTXT_MENU);
        }
    }

    protected void addPopupMenuItemsForThreads(ContextMenu popup, Context context) {
    }

    protected void addPopupMenuItemsForTreeTable(ContextMenu popup, Context context) {
    }

    protected void addPopupMenuItemsForCommon(ContextMenu popup, Context context) {
        this.update(this._actionSave, context);
        if (this._actionSave.isEnabled()) {
            if (this._menuitemSave == null) {
                this._menuitemSave = popup.createMenuItem((ToggleAction)this._actionSave);
            }
            popup.add((Component)this._menuitemSave, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
        }
    }

    void showPopup(MouseEvent e) {
        JDebugger.getInstance().showContextMenu(e, this.dockableWindow, this.treeTable);
    }

    private void saveToFile() {
        URL url;
        String dlgTitle = RunMgrArb.format(19, this.dockableWindow.getTitleName());
        URLChooser chooser = DialogUtil.newURLChooser((Context)this.getContext());
        if (JDebugger.lastSavedFile != null) {
            chooser.setSelectedURL(JDebugger.lastSavedFile);
        }
        if (chooser.showSaveDialog((Component)Ide.getMainWindow(), dlgTitle) == 0 && (url = chooser.getSelectedURL()) != null) {
            JDebugger.lastSavedFile = url;
            WaitCursor wc = Ide.getWaitCursor();
            wc.show();
            Exception exceptionOccurred = null;
            try {
                String suffixUpper = URLFileSystem.getSuffix((URL)url).toUpperCase();
                boolean html = suffixUpper.equals(".HTML") || suffixUpper.equals(".HTM");
                PrintWriter out = html ? JDebugger.printHtmlHeader(url, this.dockableWindow.getTitleName()) : new PrintWriter(new BufferedOutputStream(URLFileSystem.openOutputStream((URL)url)));
                ThreadTreeTableModel.mav$save(this.model, out, html);
                if (html) {
                    JDebugger.printHtmlFooter(out);
                }
                out.flush();
                out.close();
            }
            catch (Exception e) {
                exceptionOccurred = e;
            }
            wc.hide();
            if (exceptionOccurred != null) {
                String message = DbgArb.format(341, this.dockableWindow.getTitleName(), URLFileSystem.getPlatformPathName((URL)url));
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exceptionOccurred, (String)dlgTitle, (String)message, null);
            }
        }
    }

    void nowShown() {
        if (this.skippedUpdate && this.treeTable.isEnabled()) {
            this.everythingChanged();
        }
    }

    void everythingChanged() {
        if (this.model != null) {
            ThreadInfoPath highlight = this.getCurrentHighlight();
            this.model.updateThreads(highlight);
        }
    }

    void invalidatePane() {
        this.everythingChanged();
    }

    void updateCell(int row, int column) {
        TableModel tableModel = this.treeTable.getModel();
        TableModelEvent event = new TableModelEvent(tableModel, row, row, column);
        if (tableModel instanceof AbstractTableModel) {
            ((AbstractTableModel)tableModel).fireTableChanged(event);
        }
    }

    protected ThreadInfoPath getCurrentHighlight() {
        return this.model.getCurrentHighlight();
    }

    void updateThreads(DebuggingProcess debuggingProcess, DebugVirtualMachine vm, DebugThreadInfo highlightThread) {
        int handle = -1;
        if (ProfilingEvents.eventOn[2]) {
            handle = IdeProfile.startEvent((int)ProfilingEvents.eventId[2], (String)this.dockableWindow.getTitleName());
        }
        this.debuggingProcess = debuggingProcess;
        this.vm = vm;
        ThreadInfoPath highlight = null;
        if (highlightThread != null) {
            highlight = new ThreadInfoPath(debuggingProcess, highlightThread);
        }
        if (this.model != null) {
            this.model.updateThreads(highlight);
        }
        if (ProfilingEvents.eventOn[2]) {
            IdeProfile.endEvent((int)handle);
        }
    }

    void clearThreads() {
        if (this.treeTable == null) {
            return;
        }
        int handle = -1;
        if (ProfilingEvents.eventOn[7]) {
            handle = IdeProfile.startEvent((int)ProfilingEvents.eventId[7], (String)this.dockableWindow.getTitleName());
        }
        this.treeTable.setEnabled(false);
        this.model.clearThreads();
        this.vm = null;
        if (ProfilingEvents.eventOn[7]) {
            IdeProfile.endEvent((int)handle);
        }
    }

    protected abstract void addThreadItems();

    void processFinished(DebuggingProcess debuggingProcess) {
        if (this.model != null) {
            this.model.processFinished(debuggingProcess);
        }
        if (this.debuggingProcess == debuggingProcess) {
            this.debuggingProcess = null;
            this.vm = null;
            if (this.treeTable != null) {
                this.treeTable.setEnabled(true);
                this.model.updateThreads(null);
            }
        }
    }

    ThreadItem getThreadItemForTreePath(TreePath treePath) {
        Object node;
        if (treePath != null && (node = treePath.getLastPathComponent()) instanceof ThreadItem) {
            return (ThreadItem)node;
        }
        return null;
    }

    ThreadItem getSelectedThreadItem() {
        if (this.treeTable != null) {
            TreePath treePath = this.treeTable.getTree().getSelectionPath();
            return this.getThreadItemForTreePath(treePath);
        }
        return null;
    }

    DebugThreadInfo getSelectedThreadInfo() {
        ThreadItem threadItem = this.getSelectedThreadItem();
        if (threadItem != null) {
            return threadItem.getThreadInfo();
        }
        return null;
    }

    protected List getRoot() {
        return (List)this.model.getRoot();
    }

    void resetIcons() {
        ThreadTreeTableModel.mav$resetIcons(this.model);
    }

    protected static String getThreadStatus(int status) {
        switch (status) {
            default: {
                return DbgArb.getString(860);
            }
            case 1: {
                return DbgArb.getString(61);
            }
            case 2: {
                return DbgArb.getString(874);
            }
            case 3: {
                return DbgArb.getString(91);
            }
            case 4: {
                return DbgArb.getString(215);
            }
            case 5: {
                return DbgArb.getString(858);
            }
            case 6: 
        }
        return DbgArb.getString(911);
    }

    protected static boolean isDeadlocked(DebugThreadInfo threadInfo, DebuggingProcess debuggingProcess) {
        DebugThreadInfo[][] deadlocks = debuggingProcess.getDeadlocks();
        int length = deadlocks.length;
        if (length != 0) {
            int i = 0;
            while (i < length) {
                int jLength = deadlocks[i].length;
                int j = 0;
                while (j < jLength) {
                    DebugThreadInfo t = deadlocks[i][j];
                    if (t.equals(threadInfo)) {
                        return true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return false;
    }

    protected static String[] getPriorityDaemon(DebugThreadInfo threadInfo) {
        String[] a = new String[2];
        DebugDataObjectInfo threadObject = threadInfo.getThreadObject();
        if (threadObject != null && !threadObject.isNull()) {
            DebugDataInfo data = DebugShared.findFieldData(threadObject, "priority", "int", "java.lang.Thread");
            if (data != null) {
                a[0] = data.getValue();
            }
            if ((data = DebugShared.findFieldData(threadObject, "daemon", "boolean", "java.lang.Thread")) != null) {
                a[1] = data.getValue();
            }
        }
        return a;
    }

    protected static String[] getMaxPriorityDaemon(DebugThreadGroupInfo groupInfo) {
        String[] a = new String[2];
        DebugDataObjectInfo threadGroupObject = groupInfo.getThreadGroupObject();
        if (threadGroupObject != null && !threadGroupObject.isNull()) {
            DebugDataInfo data = DebugShared.findFieldData(threadGroupObject, "maxPriority", "int", "java.lang.ThreadGroup");
            if (data != null) {
                a[0] = data.getValue();
            }
            if ((data = DebugShared.findFieldData(threadGroupObject, "daemon", "boolean", "java.lang.ThreadGroup")) != null) {
                a[1] = data.getValue();
            }
        }
        return a;
    }

    private static Icon getThreadGroupIcon() {
        if (threadGroupIcon == null) {
            threadGroupIcon = DbgArb.getIcon(174);
        }
        return threadGroupIcon;
    }

    private static Icon getThreadIcon() {
        if (threadIcon == null) {
            threadIcon = DbgArb.getIcon(559);
        }
        return threadIcon;
    }

    private static Icon getThreadIconGray() {
        if (threadIconGray == null) {
            threadIconGray = IdeUtil.grayIcon((Icon)ThreadsPanel.getThreadIcon());
        }
        return threadIconGray;
    }

    private static Icon getCurrentThreadIcon() {
        if (currentThreadIcon == null) {
            currentThreadIcon = DbgArb.getIcon(613);
        }
        return currentThreadIcon;
    }

    private static Icon getCurrentThreadIconGray() {
        if (currentThreadIconGray == null) {
            currentThreadIconGray = IdeUtil.grayIcon((Icon)ThreadsPanel.getCurrentThreadIcon());
        }
        return currentThreadIconGray;
    }

    static void wa$skippedUpdate(ThreadsPanel threadsPanel, boolean bl) {
        threadsPanel.skippedUpdate = bl;
    }

    static Font mav$getBoldFont(ThreadsPanel threadsPanel) {
        return threadsPanel.getBoldFont();
    }

    static Font mav$getNormalFont(ThreadsPanel threadsPanel) {
        return threadsPanel.getNormalFont();
    }

    static Icon maS$getThreadGroupIcon() {
        return ThreadsPanel.getThreadGroupIcon();
    }

    static Icon maS$getCurrentThreadIconGray() {
        return ThreadsPanel.getCurrentThreadIconGray();
    }

    static Icon maS$getCurrentThreadIcon() {
        return ThreadsPanel.getCurrentThreadIcon();
    }

    static Icon maS$getThreadIconGray() {
        return ThreadsPanel.getThreadIconGray();
    }

    static Icon maS$getThreadIcon() {
        return ThreadsPanel.getThreadIcon();
    }

    static void mav$adjustColumnsAfterResize(ThreadsPanel threadsPanel) {
        threadsPanel.adjustColumnsAfterResize();
    }

    final class 1
    extends StructureChangeListener {
        public void structureValuesChanged(StructureChangeEvent e) {
            ThreadsPanel.this.threadsPanelSettingsChanged(true);
        }
    }

    final class 2
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof ThreadItem) {
                String accessibleDescription;
                ThreadItem threadItem = (ThreadItem)value;
                this.setIcon(threadItem.getIcon());
                this.setFont(ThreadItem.mav$getFont(threadItem, 0));
                String tooltip = threadItem.getName();
                this.setToolTipText(tooltip);
                AccessibleContext ac = this.getAccessibleContext();
                String accessibleName = ThreadTreeTableModel.mav$getAccessibleNameAt(ThreadsPanel.this.model, threadItem, 0);
                if (threadItem.mayHaveChildren()) {
                    accessibleName = JDebugger.fixTreeCellAccessibleName(accessibleName, expanded);
                }
                if (accessibleName != null) {
                    ac.setAccessibleName(accessibleName);
                }
                if ((accessibleDescription = tooltip) != null) {
                    ac.setAccessibleDescription(accessibleDescription);
                }
            } else {
                this.setIcon(null);
                this.setFont(ThreadsPanel.mav$getNormalFont(ThreadsPanel.this));
                this.setToolTipText(null);
            }
            return this;
        }
    }

    final class 3
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String accessibleDescription;
            String tooltip;
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int modelColumn = table.convertColumnIndexToModel(column);
            TreePath treePath = ThreadsPanel.this.treeTable.getTree().getPathForRow(row);
            ThreadItem threadItem = ThreadsPanel.this.getThreadItemForTreePath(treePath);
            this.setFont(ThreadItem.mav$getFont(threadItem, modelColumn));
            int horizontalAlignment = 2;
            if (modelColumn == 3) {
                horizontalAlignment = 4;
            }
            this.setHorizontalAlignment(horizontalAlignment);
            String string = tooltip = value instanceof String ? (String)value : null;
            if (tooltip != null) {
                this.setToolTipText(tooltip);
            }
            AccessibleContext ac = this.getAccessibleContext();
            String accessibleName = ThreadTreeTableModel.mav$getAccessibleNameAt(ThreadsPanel.this.model, threadItem, modelColumn);
            if (accessibleName != null) {
                ac.setAccessibleName(accessibleName);
            }
            if ((accessibleDescription = tooltip) != null) {
                ac.setAccessibleDescription(accessibleDescription);
            }
            return this;
        }
    }

    final class 4
    extends DefaultTableCellRenderer {
        private final /* synthetic */ TableCellRenderer v$headerRenderer;
        final /* synthetic */ ThreadsPanel this$0;

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (this.v$headerRenderer instanceof DefaultTableCellRenderer) {
                DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)this.v$headerRenderer;
                int modelColumn = table.convertColumnIndexToModel(column);
                int horizontalAlignment = 2;
                if (modelColumn == 3) {
                    horizontalAlignment = 4;
                }
                defaultTableCellRenderer.setHorizontalAlignment(horizontalAlignment);
            }
            return this.v$headerRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }

        public 4(ThreadsPanel threadsPanel, TableCellRenderer tableCellRenderer) {
            this.v$headerRenderer = tableCellRenderer;
            this.this$0 = threadsPanel;
        }
    }

    final class 5
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                ThreadsPanel.this.showPopup(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                ThreadsPanel.this.showPopup(e);
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (ThreadsPanel.this.debuggingProcess == null || !ThreadsPanel.this.debuggingProcess.isStopped()) {
                Toolkit.getDefaultToolkit().beep();
                DebuggingProcess.showStatus(DbgArb.format(253, ThreadsPanel.this.dockableWindow.getTitleName()));
            }
            if (JDebugger.isDoubleClickInTreeTable(ThreadsPanel.this.treeTable, e)) {
                Context context = ThreadsPanel.this.getContext(e);
                ThreadsPanel.this.update(ThreadsPanel.this._actionGoTo, context);
                if (ThreadsPanel.this._actionGoTo.isEnabled()) {
                    ThreadsPanel.this.handleEvent(ThreadsPanel.this._actionGoTo, context);
                }
            }
        }
    }

    final class 6
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            if (ThreadsPanel.this.debuggingProcess == null || !ThreadsPanel.this.debuggingProcess.isStopped()) {
                Toolkit.getDefaultToolkit().beep();
                DebuggingProcess.showStatus(DbgArb.format(253, ThreadsPanel.this.dockableWindow.getTitleName()));
            }
        }
    }

    final class 7
    extends KeyAdapter {
        public void keyPressed(KeyEvent e) {
            int key = e.getKeyCode();
            switch (key) {
                case 10: {
                    ThreadsPanel.this.update(ThreadsPanel.this._actionGoTo, null);
                    if (!ThreadsPanel.this._actionGoTo.isEnabled()) break;
                    ThreadsPanel.this.handleEvent(ThreadsPanel.this._actionGoTo, null);
                    e.consume();
                    break;
                }
            }
        }
    }

    final class 8
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                ThreadsPanel.this.showPopup(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                ThreadsPanel.this.showPopup(e);
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (ThreadsPanel.this.debuggingProcess == null || !ThreadsPanel.this.debuggingProcess.isStopped()) {
                Toolkit.getDefaultToolkit().beep();
                DebuggingProcess.showStatus(DbgArb.format(253, ThreadsPanel.this.dockableWindow.getTitleName()));
            }
        }
    }

    final class 9
    extends ComponentAdapter {
        public void componentResized(ComponentEvent e) {
            ThreadsPanel.mav$adjustColumnsAfterResize(ThreadsPanel.this);
        }
    }

    final class 10
    implements HierarchyListener {
        public void hierarchyChanged(HierarchyEvent e) {
            if ((e.getChangeFlags() & (long)4) != 0L && ThreadsPanel.this.treeTable.isShowing()) {
                ThreadsPanel.this.nowShown();
            }
        }
    }

    final class 11
    implements Runnable {
        public void run() {
            ThreadsPanel.this.everythingChanged();
        }
    }

    final class ThreadTreeTableModel
    extends AbstractTreeTableModel {
        private List root;
        private List expanded;

        ThreadTreeTableModel(List root) {
            super((Object)root);
            this.root = root;
            this.expanded = Collections.synchronizedList(new ArrayList());
        }

        void updateThreads(ThreadInfoPath highlight) {
            ThreadsPanel.this.treeTable.getSelectionModel().clearSelection();
            ThreadsPanel.this.treeTable.setEnabled(true);
            this.root.clear();
            if (ThreadsPanel.this.treeTable.isShowing()) {
                ThreadsPanel.wa$skippedUpdate(ThreadsPanel.this, false);
                if (ThreadsPanel.this.debuggingProcess != null && ThreadsPanel.this.vm != null) {
                    ThreadsPanel.this.addThreadItems();
                }
            } else {
                ThreadsPanel.wa$skippedUpdate(ThreadsPanel.this, true);
            }
            this.fireChanged(new TreePath(this.root));
            this.restoreExpanded();
            this.restoreHighlight(highlight);
        }

        private void fireChanged(TreePath path) {
            this.fireTreeStructureChanged((Object)this, path.getPath(), null, null);
        }

        void clearThreads() {
            this.clearAll();
        }

        void processFinished(DebuggingProcess debuggingProcess) {
            int i = this.expanded.size() - 1;
            while (i >= 0) {
                ThreadInfoPath threadInfoPath = (ThreadInfoPath)this.expanded.get(i);
                if (threadInfoPath.getDebuggingProcess() == debuggingProcess) {
                    this.expanded.remove(i);
                }
                --i;
            }
        }

        private void clearAll() {
            this.clearAll(ThreadsPanel.this.treeTable.getTree(), new TreePath(this.root));
        }

        private void clearAll(JTree tree, TreePath treePath) {
            Object node = treePath.getLastPathComponent();
            if (node instanceof ThreadItem) {
                ((ThreadItem)node).clearThread();
            }
            int count = this.getChildCount(node);
            int i = 0;
            while (i < count) {
                Object child = this.getChild(node, i);
                this.clearAll(tree, treePath.pathByAddingChild(child));
                ++i;
            }
        }

        private void restoreExpanded() {
            int length = this.expanded.size();
            if (length == 0) {
                this.expandAll();
            } else {
                ThreadInfoPath[] ex = this.expanded.toArray(new ThreadInfoPath[length]);
                int i = 0;
                while (i < length) {
                    this.expandBranch(ex[i]);
                    ++i;
                }
            }
        }

        private void restoreHighlight(ThreadInfoPath highlight) {
            if (highlight != null) {
                TreePath treePath = this.makeVisible(highlight);
                JDebugger.getInstance().selectTreeTablePath(ThreadsPanel.this.treeTable, treePath, false);
            }
        }

        private TreePath expandBranch(ThreadInfoPath threadInfoPath) {
            return this.expandBranch(new TreePath(this.root), threadInfoPath);
        }

        private TreePath expandBranch(TreePath treePath, ThreadInfoPath threadInfoPath) {
            JTree tree = ThreadsPanel.this.treeTable.getTree();
            Object node = treePath.getLastPathComponent();
            if (node instanceof ThreadItem) {
                ThreadItem threadItem = (ThreadItem)node;
                if (threadInfoPath.getInfo().equals(threadItem.getInfo())) {
                    tree.expandPath(treePath);
                    return treePath;
                }
            }
            int count = this.getChildCount(node);
            int i = 0;
            while (i < count) {
                Object child = this.getChild(node, i);
                TreePath result = this.expandBranch(treePath.pathByAddingChild(child), threadInfoPath);
                if (result != null) {
                    return result;
                }
                ++i;
            }
            return null;
        }

        TreePath makeVisible(ThreadInfoPath threadInfoPath) {
            return this.makeVisible(new TreePath(this.root), threadInfoPath);
        }

        private TreePath makeVisible(TreePath treePath, ThreadInfoPath threadInfoPath) {
            Object node = treePath.getLastPathComponent();
            if (node instanceof ThreadItem) {
                ThreadItem threadItem = (ThreadItem)node;
                if (threadInfoPath.getInfo().equals(threadItem.getInfo())) {
                    ThreadsPanel.this.treeTable.getTree().makeVisible(treePath);
                    return treePath;
                }
            }
            int count = this.getChildCount(node);
            int i = 0;
            while (i < count) {
                Object child = this.getChild(node, i);
                TreePath result = this.makeVisible(treePath.pathByAddingChild(child), threadInfoPath);
                if (result != null) {
                    return result;
                }
                ++i;
            }
            return null;
        }

        void branchExpanded(TreePath treePath) {
            ThreadInfoPath threadInfoPath = this.convertTreePathToThreadInfoPath(treePath);
            if (threadInfoPath != null) {
                int i = this.expanded.indexOf(threadInfoPath);
                if (i != -1) {
                    this.expanded.remove(i);
                }
                this.expanded.add(0, threadInfoPath);
            }
        }

        void branchCollapsed(TreePath treePath) {
            ThreadInfoPath threadInfoPath = this.convertTreePathToThreadInfoPath(treePath);
            if (threadInfoPath != null) {
                this.expanded.remove(threadInfoPath);
            }
        }

        ThreadInfoPath getCurrentHighlight() {
            TreePath treePath = ThreadsPanel.this.treeTable.getTree().getSelectionPath();
            if (treePath != null) {
                return this.convertTreePathToThreadInfoPath(treePath);
            }
            return null;
        }

        ThreadInfoPath convertTreePathToThreadInfoPath(TreePath treePath) {
            Object node = treePath.getLastPathComponent();
            if (node instanceof ThreadItem) {
                ThreadItem threadItem = (ThreadItem)node;
                return threadItem.getThreadInfoPath();
            }
            return null;
        }

        private void resetIcons() {
            this.resetIcons(new TreePath(this.root));
            ThreadsPanel.this.treeTable.repaint(ThreadsPanel.this.treeTable.getVisibleRect());
        }

        private void resetIcons(TreePath treePath) {
            Object node = treePath.getLastPathComponent();
            if (node instanceof ThreadItem) {
                ThreadItem.mav$setIconAppropriately((ThreadItem)node);
            }
            int count = this.getChildCount(node);
            int i = 0;
            while (i < count) {
                Object child = this.getChild(node, i);
                this.resetIcons(treePath.pathByAddingChild(child));
                ++i;
            }
        }

        void expandAll() {
            WaitCursor wc = Ide.getWaitCursor();
            wc.show();
            this.expandAll(ThreadsPanel.this.treeTable.getTree(), new TreePath(this.root));
            wc.hide();
        }

        private void expandAll(JTree tree, TreePath treePath) {
            Object node = treePath.getLastPathComponent();
            tree.expandPath(treePath);
            int count = this.getChildCount(node);
            int i = 0;
            while (i < count) {
                Object child = this.getChild(node, i);
                this.expandAll(tree, treePath.pathByAddingChild(child));
                ++i;
            }
        }

        void collapseAll() {
            WaitCursor wc = Ide.getWaitCursor();
            wc.show();
            this.collapseAll(ThreadsPanel.this.treeTable.getTree(), new TreePath(this.root));
            wc.hide();
        }

        private void collapseAll(JTree tree, TreePath treePath) {
            Object node = treePath.getLastPathComponent();
            int count = this.getChildCount(node);
            int i = 0;
            while (i < count) {
                Object child = this.getChild(node, i);
                this.collapseAll(tree, treePath.pathByAddingChild(child));
                ++i;
            }
            if (!node.equals(this.root)) {
                tree.collapsePath(treePath);
            }
        }

        private void save(PrintWriter out, boolean html) {
            if (html) {
                out.println("<table border=\"1\">");
            }
            this.saveHeader(out, html);
            this.save(ThreadsPanel.this.treeTable.getTree(), new TreePath(this.root), out, html, ThreadsPanel.NOT_AVAILABLE);
            if (html) {
                out.println("</table>");
            }
        }

        private void saveHeader(PrintWriter out, boolean html) {
            StringBuffer sb = new StringBuffer();
            StringBuffer sb2 = new StringBuffer();
            if (html) {
                sb.append("<tr>");
            }
            TableColumnModel tableColumnModel = ThreadsPanel.this.treeTable.getColumnModel();
            Enumeration<TableColumn> e = tableColumnModel.getColumns();
            while (e.hasMoreElements()) {
                TableColumn column = e.nextElement();
                int i = column.getModelIndex();
                String columnName = this.getColumnName(i);
                if (html) {
                    sb.append("<th>");
                    columnName = IdeUtil.replaceHTMLReservedCharacters((String)columnName.toString());
                    sb.append(columnName);
                    sb.append("</th>");
                    continue;
                }
                sb.append(columnName);
                int ii = columnName.length();
                while (ii >= 0) {
                    sb2.append('-');
                    --ii;
                }
                if (!e.hasMoreElements()) continue;
                sb.append('\t');
                sb2.append('\t');
            }
            if (html) {
                sb.append("</tr>");
            }
            out.println(sb.toString());
            if (!html) {
                out.println(sb2.toString());
            }
        }

        private void save(JTree tree, TreePath treePath, PrintWriter out, boolean html, String indent) {
            if (tree.isVisible(treePath)) {
                Object node = treePath.getLastPathComponent();
                if (node instanceof ThreadItem) {
                    ThreadItem threadItem = (ThreadItem)node;
                    StringBuffer sb = new StringBuffer();
                    if (html) {
                        sb.append("<tr>");
                    }
                    TableColumnModel tableColumnModel = ThreadsPanel.this.treeTable.getColumnModel();
                    Enumeration<TableColumn> e = tableColumnModel.getColumns();
                    while (e.hasMoreElements()) {
                        TableColumn column = e.nextElement();
                        int i = column.getModelIndex();
                        Object columnValue = this.getValueAt(node, i);
                        if (columnValue instanceof Boolean) {
                            columnValue = (Boolean)columnValue != false ? "true" : "false";
                        }
                        if (html) {
                            String columnValueString;
                            sb.append("<td>");
                            if (i == 0) {
                                sb.append("<tt>");
                                if (indent != null) {
                                    sb.append(indent);
                                }
                                if (tree.isExpanded(treePath)) {
                                    sb.append("-&nbsp;");
                                } else if (threadItem.mayHaveChildren()) {
                                    sb.append("+&nbsp;");
                                } else {
                                    sb.append("&nbsp;&nbsp;");
                                }
                                sb.append("</tt>");
                            }
                            if ((columnValueString = IdeUtil.replaceHTMLReservedCharacters((String)columnValue.toString())).length() > 0) {
                                sb.append(columnValueString);
                            } else {
                                sb.append("&nbsp;");
                            }
                            sb.append("</td>");
                            continue;
                        }
                        if (i == 0) {
                            if (indent != null) {
                                sb.append(indent);
                            }
                            if (tree.isExpanded(treePath)) {
                                sb.append("- ");
                            } else if (threadItem.mayHaveChildren()) {
                                sb.append("+ ");
                            } else {
                                sb.append("  ");
                            }
                        }
                        sb.append(columnValue);
                        if (!e.hasMoreElements()) continue;
                        sb.append('\t');
                    }
                    if (html) {
                        sb.append("</tr>");
                    }
                    out.println(sb.toString());
                }
                if (node != this.root) {
                    indent = html ? indent + "&nbsp;&nbsp;&nbsp;&nbsp;" : indent + "    ";
                }
                int count = this.getChildCount(node);
                int i = 0;
                while (i < count) {
                    Object child = this.getChild(node, i);
                    this.save(tree, treePath.pathByAddingChild(child), out, html, indent);
                    ++i;
                }
            }
        }

        public boolean isLeaf(Object node) {
            try {
                if (node instanceof List) {
                    boolean bl = false;
                    return bl;
                }
                ThreadItem threadItem = (ThreadItem)node;
                boolean bl = threadItem.mayHaveChildren() ^ true;
                return bl;
            }
            catch (Exception e) {
                e.printStackTrace();
                return true;
            }
        }

        public Object getChild(Object parent, int index) {
            try {
                if (parent instanceof List) {
                    Object e = ((List)parent).get(index);
                    return e;
                }
                ThreadItem threadItem = (ThreadItem)parent;
                ThreadItem threadItem2 = threadItem.getChildNodes()[index];
                return threadItem2;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public int getChildCount(Object parent) {
            try {
                if (parent instanceof List) {
                    int n = ((List)parent).size();
                    return n;
                }
                ThreadItem threadItem = (ThreadItem)parent;
                int n = threadItem.countChildNodes();
                return n;
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        }

        public int getColumnCount() {
            return 5;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return DbgArb.getString(190);
                }
                case 1: {
                    return DbgArb.getString(841);
                }
                case 2: {
                    return DbgArb.getString(855);
                }
                case 3: {
                    return DbgArb.getString(572);
                }
                case 4: {
                    return DbgArb.getString(472);
                }
            }
            return ThreadsPanel.NOT_AVAILABLE;
        }

        public Class getColumnClass(int column) {
            if (column == 0) {
                return TreeTableModel.class;
            }
            if (column == 4) {
                return Boolean.class;
            }
            return String.class;
        }

        public Object getValueAt(Object node, int column) {
            try {
                if (node instanceof List) {
                    switch (column) {
                        case 0: {
                            String string = "root";
                            return string;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            String string = ThreadsPanel.NOT_AVAILABLE;
                            return string;
                        }
                        case 4: {
                            Boolean bl = Boolean.FALSE;
                            return bl;
                        }
                    }
                    Object var8_6 = null;
                    return var8_6;
                }
                ThreadItem threadItem = (ThreadItem)node;
                switch (column) {
                    case 0: {
                        String string = threadItem.getName();
                        return string;
                    }
                    case 1: {
                        String string = threadItem.getStatus();
                        return string;
                    }
                    case 2: {
                        String string = threadItem.getGroup();
                        return string;
                    }
                    case 3: {
                        String string = threadItem.getPriority();
                        return string;
                    }
                    case 4: {
                        Boolean bl = threadItem.getDaemon();
                        return bl;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        private String getAccessibleNameAt(ThreadItem threadItem, int column) {
            int id;
            if (threadItem.isThread()) {
                id = 329;
            } else if (threadItem.isThreadGroup()) {
                id = 565;
            } else {
                return null;
            }
            String columnName = this.getColumnName(column);
            String value = (String)this.getValueAt(threadItem, column);
            if (value.length() == 0) {
                value = DbgArb.getString(32);
            }
            return DbgArb.format(id, columnName, value);
        }

        static void mav$resetIcons(ThreadTreeTableModel threadTreeTableModel) {
            threadTreeTableModel.resetIcons();
        }

        static void mav$save(ThreadTreeTableModel threadTreeTableModel, PrintWriter printWriter, boolean bl) {
            threadTreeTableModel.save(printWriter, bl);
        }

        static String mav$getAccessibleNameAt(ThreadTreeTableModel threadTreeTableModel, ThreadItem threadItem, int n) {
            return threadTreeTableModel.getAccessibleNameAt(threadItem, n);
        }
    }

    protected final class ThreadItem
    extends BaseElement {
        private Object info;
        private String accessiblePrefix;
        private DebugThreadGroupInfo[] groups;
        private DebugThreadInfo[] threads;
        private DebugLocation location;
        private int status;
        private boolean deadlocked;
        private ThreadItem[] children;
        private Boolean cachedMayHaveChildren;
        private String cachedName;
        private String cachedGroup;
        private String cachedStatus;
        private String cachedPriority;
        private Boolean cachedDaemon;

        ThreadItem(Object info) {
            this.info = info;
            if (info instanceof DebugThreadGroupInfo) {
                DebugThreadGroupInfo group = (DebugThreadGroupInfo)info;
                this.groups = group.listGroups();
                Arrays.sort(this.groups, ThreadsPanel.this);
                this.threads = group.listThreads();
                Arrays.sort(this.threads, ThreadsPanel.this);
                this.accessiblePrefix = DbgArb.getString(565);
            } else {
                this.groups = new DebugThreadGroupInfo[0];
                this.threads = new DebugThreadInfo[0];
                this.accessiblePrefix = DbgArb.getString(329);
            }
            this.setStatusAndDeadlock();
            this.setIconAppropriately();
        }

        boolean isThreadGroup() {
            return this.info instanceof DebugThreadGroupInfo;
        }

        boolean isThread() {
            return this.info instanceof DebugThreadInfo;
        }

        String getAccessiblePrefix() {
            return this.accessiblePrefix;
        }

        private void setStatusAndDeadlock() {
            if (this.info instanceof DebugThreadInfo) {
                DebugThreadInfo threadInfo = (DebugThreadInfo)this.info;
                this.status = threadInfo.getStatus();
                this.deadlocked = this.status == 2 ? ThreadsPanel.isDeadlocked(threadInfo, ThreadsPanel.this.debuggingProcess) : false;
            }
        }

        private void setIconAppropriately() {
            if (this.info instanceof DebugThreadGroupInfo) {
                this.setIcon(ThreadsPanel.maS$getThreadGroupIcon());
            } else if (this.info instanceof DebugThreadInfo) {
                DebugThreadInfo thread = (DebugThreadInfo)this.info;
                if (ThreadsPanel.this.debuggingProcess.isCurrentThread(thread)) {
                    if (this.status == 6) {
                        this.setIcon(ThreadsPanel.maS$getCurrentThreadIconGray());
                    } else {
                        this.setIcon(ThreadsPanel.maS$getCurrentThreadIcon());
                    }
                } else if (this.status == 6) {
                    this.setIcon(ThreadsPanel.maS$getThreadIconGray());
                } else {
                    this.setIcon(ThreadsPanel.maS$getThreadIcon());
                }
            }
        }

        private Font getFont(int column) {
            if (column == 0 ? ThreadsPanel.this.boldCurrentThreadName && this.info instanceof DebugThreadInfo && ThreadsPanel.this.debuggingProcess.isCurrentThread((DebugThreadInfo)this.info) : column == 1 && ThreadsPanel.this.boldDeadlockedThreadStatus && this.deadlocked) {
                return ThreadsPanel.mav$getBoldFont(ThreadsPanel.this);
            }
            return ThreadsPanel.mav$getNormalFont(ThreadsPanel.this);
        }

        void clearThread() {
            this.info = null;
            this.groups = null;
            this.threads = null;
            this.location = null;
        }

        Object getInfo() {
            return this.info;
        }

        ThreadInfoPath getThreadInfoPath() {
            return new ThreadInfoPath(ThreadsPanel.this.debuggingProcess, this.info);
        }

        DebugThreadGroupInfo getThreadGroupInfo() {
            if (this.info instanceof DebugThreadGroupInfo) {
                return (DebugThreadGroupInfo)this.info;
            }
            return null;
        }

        DebugThreadInfo getThreadInfo() {
            if (this.info instanceof DebugThreadInfo) {
                return (DebugThreadInfo)this.info;
            }
            return null;
        }

        public String getShortLabel() {
            return this.getName();
        }

        public Object getData() {
            return this;
        }

        public boolean mayHaveChildren() {
            if (this.cachedMayHaveChildren == null && ThreadsPanel.this.treeTable.isEnabled()) {
                this.cachedMayHaveChildren = this.info instanceof DebugThreadGroupInfo ? Boolean.TRUE : Boolean.FALSE;
            }
            if (this.cachedMayHaveChildren != null) {
                return this.cachedMayHaveChildren;
            }
            return false;
        }

        public Iterator getChildren() {
            return Arrays.asList(this.getChildNodes()).iterator();
        }

        public String getName() {
            if (this.cachedName == null && ThreadsPanel.this.treeTable.isEnabled()) {
                this.cachedName = this.info instanceof DebugThreadGroupInfo ? ((DebugThreadGroupInfo)this.info).getName() : (this.info instanceof DebugThreadInfo ? ((DebugThreadInfo)this.info).getName() : ThreadsPanel.NOT_AVAILABLE);
            }
            if (this.cachedName != null) {
                return this.cachedName;
            }
            return ThreadsPanel.NOT_AVAILABLE;
        }

        public String getGroup() {
            if (this.cachedGroup == null && ThreadsPanel.this.treeTable.isEnabled()) {
                this.cachedGroup = this.info instanceof DebugThreadInfo ? ((DebugThreadInfo)this.info).getGroupName() : ThreadsPanel.NOT_AVAILABLE;
            }
            if (this.cachedGroup != null) {
                return this.cachedGroup;
            }
            return ThreadsPanel.NOT_AVAILABLE;
        }

        public String getStatus() {
            if (this.cachedStatus == null && ThreadsPanel.this.treeTable.isEnabled()) {
                if (this.info instanceof DebugThreadInfo) {
                    String s = ThreadsPanel.getThreadStatus(this.status);
                    if (((DebugThreadInfo)this.info).isThreadInterrupted()) {
                        s = s + " " + DbgArb.getString(953);
                    }
                    if (((DebugThreadInfo)this.info).isThreadDebuggerStopped()) {
                        s = s + " " + DbgArb.getString(210);
                    }
                    if (((DebugThreadInfo)this.info).isThreadSuspended()) {
                        s = s + " " + DbgArb.getString(395);
                    }
                    if (this.deadlocked) {
                        s = s + " " + DbgArb.getString(17);
                    }
                    this.cachedStatus = s;
                } else {
                    this.cachedStatus = ThreadsPanel.NOT_AVAILABLE;
                }
            }
            if (this.cachedStatus != null) {
                return this.cachedStatus;
            }
            return ThreadsPanel.NOT_AVAILABLE;
        }

        public String getPriority() {
            if (this.cachedPriority == null && ThreadsPanel.this.treeTable.isEnabled()) {
                this.getPriorityAndDaemon();
            }
            if (this.cachedPriority != null) {
                return this.cachedPriority;
            }
            return ThreadsPanel.NOT_AVAILABLE;
        }

        public Boolean getDaemon() {
            if (this.cachedDaemon == null && ThreadsPanel.this.treeTable.isEnabled()) {
                this.getPriorityAndDaemon();
            }
            if (this.cachedDaemon != null) {
                return this.cachedDaemon;
            }
            return Boolean.FALSE;
        }

        private void getPriorityAndDaemon() {
            this.cachedPriority = ThreadsPanel.NOT_AVAILABLE;
            this.cachedDaemon = Boolean.FALSE;
            if (this.info instanceof DebugThreadGroupInfo) {
                String[] a = ThreadsPanel.getMaxPriorityDaemon((DebugThreadGroupInfo)this.info);
                if (a[0] != null) {
                    this.cachedPriority = DbgArb.format(643, a[0]);
                }
                if (a[1] != null) {
                    this.cachedDaemon = a[1].equals("true") ? Boolean.TRUE : Boolean.FALSE;
                }
            } else if (this.info instanceof DebugThreadInfo) {
                String[] a = ThreadsPanel.getPriorityDaemon((DebugThreadInfo)this.info);
                if (a[0] != null) {
                    this.cachedPriority = a[0];
                }
                if (a[1] != null) {
                    this.cachedDaemon = a[1].equals("true") ? Boolean.TRUE : Boolean.FALSE;
                }
            }
        }

        int countChildNodes() {
            if (this.children != null) {
                return this.children.length;
            }
            if (this.groups != null && this.threads != null) {
                return this.groups.length + this.threads.length;
            }
            return 0;
        }

        ThreadItem[] getChildNodes() {
            if (this.children == null) {
                int count = this.groups.length + this.threads.length;
                this.children = new ThreadItem[count];
                int ichild = 0;
                int i = 0;
                while (i < this.groups.length) {
                    this.children[ichild++] = new ThreadItem(this.groups[i]);
                    ++i;
                }
                int i2 = 0;
                while (i2 < this.threads.length) {
                    this.children[ichild++] = new ThreadItem(this.threads[i2]);
                    ++i2;
                }
            }
            return this.children;
        }

        DebugLocation getLocation() {
            if (this.location == null && this.info instanceof DebugThreadInfo) {
                this.location = DebuggingProcess.getNonNativeLocation((DebugThreadInfo)this.info);
            }
            return this.location;
        }

        boolean canShowInSource() {
            DebugLocation location = this.getLocation();
            return location != null;
        }

        void showInSource() {
            DebugLocation location = this.getLocation();
            if (location != null) {
                ThreadsPanel.this.debuggingProcess.showSourceFile(location, true);
            }
        }

        boolean canMakeCurrentThread() {
            DebugThreadInfo thread;
            return this.info instanceof DebugThreadInfo && !ThreadsPanel.this.debuggingProcess.isCurrentThread(thread = (DebugThreadInfo)this.info) && this.status != 6;
        }

        void makeCurrentThread() {
            if (this.info instanceof DebugThreadInfo) {
                ThreadsPanel.this.debuggingProcess.setCurrentThread((DebugThreadInfo)this.info);
                ThreadsPanel.this.resetIcons();
                this.showInSource();
            }
        }

        boolean canSuspendThread() {
            DebugThreadInfo thread;
            return this.info instanceof DebugThreadInfo && ThreadsPanel.this.vm != null && ThreadsPanel.this.vm.getCapabilities().canSuspendThread() && ThreadsPanel.this.vm.getCapabilities().canResumeThread() && !(thread = (DebugThreadInfo)this.info).isThreadSuspended();
        }

        void suspendThread() {
            DebugThreadInfo thread;
            if (this.info instanceof DebugThreadInfo && ThreadsPanel.this.vm != null && ThreadsPanel.this.vm.getCapabilities().canSuspendThread() && ThreadsPanel.this.vm.getCapabilities().canResumeThread() && !(thread = (DebugThreadInfo)this.info).isThreadSuspended()) {
                thread.suspendThread();
                this.cachedStatus = null;
                ThreadsPanel.this.updateCell(ThreadsPanel.this.treeTable.getSelectedRow(), 1);
            }
        }

        boolean canResumeThread() {
            DebugThreadInfo thread;
            return this.info instanceof DebugThreadInfo && ThreadsPanel.this.vm != null && ThreadsPanel.this.vm.getCapabilities().canSuspendThread() && ThreadsPanel.this.vm.getCapabilities().canResumeThread() && (thread = (DebugThreadInfo)this.info).isThreadSuspended();
        }

        void resumeThread() {
            DebugThreadInfo thread;
            if (this.info instanceof DebugThreadInfo && ThreadsPanel.this.vm != null && ThreadsPanel.this.vm.getCapabilities().canSuspendThread() && ThreadsPanel.this.vm.getCapabilities().canResumeThread() && (thread = (DebugThreadInfo)this.info).isThreadSuspended()) {
                thread.resumeThread();
                this.cachedStatus = null;
                ThreadsPanel.this.updateCell(ThreadsPanel.this.treeTable.getSelectedRow(), 1);
            }
        }

        boolean canInterruptThread() {
            if (this.info instanceof DebugThreadInfo && ThreadsPanel.this.vm != null && ThreadsPanel.this.vm.getCapabilities().canInterruptThread()) {
                DebugThreadInfo thread = (DebugThreadInfo)this.info;
                return thread == null || !thread.isThreadInterrupted() && (thread.getStatus() == 4 || thread.getStatus() == 3 || thread.getStatus() == 2);
            }
            return false;
        }

        boolean canDebuggerStopThread() {
            if (this.info instanceof DebugThreadInfo && ThreadsPanel.this.vm != null && ThreadsPanel.this.vm.getCapabilities().canDebuggerStopThread()) {
                DebugThreadInfo thread = (DebugThreadInfo)this.info;
                return thread == null || thread.canDebuggerStopThread() && !thread.isThreadDebuggerStopped() && thread.getStatus() != 4 && thread.getStatus() != 3 && thread.getStatus() != 2;
            }
            return false;
        }

        void interruptThread() {
            if (this.info instanceof DebugThreadInfo && ThreadsPanel.this.vm != null && ThreadsPanel.this.vm.getCapabilities().canInterruptThread()) {
                DebugThreadInfo thread = (DebugThreadInfo)this.info;
                if (thread != null && thread.isThreadInterrupted()) {
                    return;
                }
                thread.interruptThread();
                this.cachedStatus = null;
                ThreadsPanel.this.invalidatePane();
            }
        }

        void stopThread() {
            if (this.info instanceof DebugThreadInfo && ThreadsPanel.this.vm != null && ThreadsPanel.this.vm.getCapabilities().canDebuggerStopThread()) {
                DebugThreadInfo thread = (DebugThreadInfo)this.info;
                if (!this.canDebuggerStopThread()) {
                    return;
                }
                thread.stopThread();
                this.cachedStatus = null;
                ThreadsPanel.this.invalidatePane();
            }
        }

        boolean canWatchInspectThread() {
            DebugThreadInfo thread;
            DebugDataObjectInfo threadObject;
            return this.info instanceof DebugThreadInfo && (threadObject = (thread = (DebugThreadInfo)this.info).getThreadObject()) != null && !threadObject.isNull() && threadObject.getFieldCount(-1, false, true) > 0;
        }

        void watchThread() {
            DebugThreadInfo thread;
            DebugDataObjectInfo threadObject;
            if (this.info instanceof DebugThreadInfo && (threadObject = (thread = (DebugThreadInfo)this.info).getThreadObject()) != null && !threadObject.isNull() && threadObject.getFieldCount(-1, false, true) > 0) {
                String name = DbgArb.format(324, Long.toString(JDebugger.getObjectNumber(threadObject)));
                EvaluatorItem ei = ThreadsPanel.this.debuggingProcess.makeTemporaryEvaluatorItem(name, threadObject);
                JDebugger.getInstance().addWatch(ei);
            }
        }

        void inspectThread() {
            DebugThreadInfo thread;
            DebugDataObjectInfo threadObject;
            if (this.info instanceof DebugThreadInfo && (threadObject = (thread = (DebugThreadInfo)this.info).getThreadObject()) != null && !threadObject.isNull() && threadObject.getFieldCount(-1, false, true) > 0) {
                String name = DbgArb.format(324, Long.toString(JDebugger.getObjectNumber(threadObject)));
                EvaluatorItem ei = ThreadsPanel.this.debuggingProcess.makeTemporaryEvaluatorItem(name, threadObject);
                JDebugger.getInstance().inspect(ei);
            }
        }

        boolean canWatchInspectClassLoader() {
            DebugDataObjectInfo classLoaderObject;
            DebugThreadInfo thread;
            DebugClassLoaderInfo classLoader;
            return this.info instanceof DebugThreadInfo && (classLoader = (thread = (DebugThreadInfo)this.info).getContextClassLoader()) != null && (classLoaderObject = classLoader.getClassLoaderObject()) != null && !classLoaderObject.isNull();
        }

        void watchClassLoader() {
            DebugDataObjectInfo classLoaderObject;
            DebugThreadInfo thread;
            DebugClassLoaderInfo classLoader;
            if (this.info instanceof DebugThreadInfo && (classLoader = (thread = (DebugThreadInfo)this.info).getContextClassLoader()) != null && (classLoaderObject = classLoader.getClassLoaderObject()) != null && !classLoaderObject.isNull()) {
                String name = ClassesWindow.makeClassLoaderName(classLoader);
                EvaluatorItem ei = ThreadsPanel.this.debuggingProcess.makeTemporaryEvaluatorItem(name, classLoaderObject);
                JDebugger.getInstance().addWatch(ei);
            }
        }

        void inspectClassLoader() {
            DebugDataObjectInfo classLoaderObject;
            DebugThreadInfo thread;
            DebugClassLoaderInfo classLoader;
            if (this.info instanceof DebugThreadInfo && (classLoader = (thread = (DebugThreadInfo)this.info).getContextClassLoader()) != null && (classLoaderObject = classLoader.getClassLoaderObject()) != null) {
                String name = ClassesWindow.makeClassLoaderName(classLoader);
                EvaluatorItem ei = ThreadsPanel.this.debuggingProcess.makeTemporaryEvaluatorItem(name, classLoaderObject);
                JDebugger.getInstance().inspect(ei);
            }
        }

        static void mav$setIconAppropriately(ThreadItem threadItem) {
            threadItem.setIconAppropriately();
        }

        static Font mav$getFont(ThreadItem threadItem, int n) {
            return threadItem.getFont(n);
        }
    }

    protected final class ThreadInfoPath {
        private DebuggingProcess debuggingProcess;
        private Object info;

        ThreadInfoPath(DebuggingProcess debuggingProcess, Object info) {
            this.debuggingProcess = debuggingProcess;
            this.info = info;
        }

        DebuggingProcess getDebuggingProcess() {
            return this.debuggingProcess;
        }

        Object getInfo() {
            return this.info;
        }

        public int hashCode() {
            return this.debuggingProcess.hashCode() + this.info.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof ThreadInfoPath) {
                ThreadInfoPath other = (ThreadInfoPath)o;
                return this.debuggingProcess == other.debuggingProcess && this.info.equals(other.info);
            }
            return false;
        }
    }
}

