/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.Frame;
import java.io.BufferedOutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.docking.Dockable;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.runner.DebuggerWindowProvider;
import oracle.ide.util.IdeUtil;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadGroupInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugDockableFactory;
import oracle.jdevimpl.runner.debug.DebuggerWindow;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.StackWindow;
import oracle.jdevimpl.runner.debug.ThreadsPanel;
import oracle.jdevimpl.runner.debug.ThreadsWindowSettings;

final class ThreadsWindow
extends DebuggerWindow {
    private String title;
    private AllThreadsPanel threadsPanel;
    private Component gui;
    private ThreadsWindowSettings threadsWindowSettings = ThreadsWindowSettings.getInstance();
    private static IdeAction actionMakeCurrent;
    private static IdeAction actionSuspend;
    private static IdeAction actionResume;
    private static IdeAction actionInterrupt;
    private static IdeAction actionDebuggerStop;
    private static IdeAction actionWatchThread;
    private static IdeAction actionInspectThread;
    private static IdeAction actionWatchClassLoader;
    private static IdeAction actionInspectClassLoader;
    private static IdeAction actionGoTo;
    private static IdeAction actionDump;
    private static IdeAction actionExpandAll;
    private static IdeAction actionCollapseAll;
    private static IdeAction actionSave;
    private static IdeAction actionSettings;
    private static JMenuItem menuitemMakeCurrent;
    private static JMenuItem menuitemSuspend;
    private static JMenuItem menuitemResume;
    private static JMenuItem menuitemInterrupt;
    private static JMenuItem menuitemDebuggerStop;
    private static JMenuItem menuitemWatchThread;
    private static JMenuItem menuitemInspectThread;
    private static JMenuItem menuitemWatchClassLoader;
    private static JMenuItem menuitemInspectClassLoader;
    private static JMenuItem menuitemDump;
    private static JMenuItem menuitemExpandAll;
    private static JMenuItem menuitemCollapseAll;
    private static JMenuItem menuitemSettings;
    private static final int MAKE_CURRENT_CMD_ID;
    private static final int SUSPEND_CMD_ID;
    private static final int RESUME_CMD_ID;
    private static final int INTERRUPT_CMD_ID;
    private static final int DEBUGGER_STOP_CMD_ID;
    private static final int WATCH_THREAD_CMD_ID;
    private static final int INSPECT_THREAD_CMD_ID;
    private static final int WATCH_CLASSLOADER_CMD_ID;
    private static final int INSPECT_CLASSLOADER_CMD_ID;
    private static final int GOTO_CMD_ID;
    private static final int DUMP_CMD_ID;
    private static final int EXPAND_ALL_CMD_ID;
    private static final int COLLAPSE_ALL_CMD_ID;
    private static final int SAVE_CMD_ID;
    private static final int SETTINGS_CMD_ID;
    static final String THREADS_WINDOW_ID = "Debugger.ThreadsWindow";
    private static Icon threadsTabIcon;

    ThreadsWindow() {
        super(THREADS_WINDOW_ID);
        this.title = DbgArb.getString(817);
        ThreadsWindow.makeActions();
        this.threadsPanel = new AllThreadsPanel();
        this.setControllerForActions();
    }

    void setStackWindow(StackWindow stackWindow) {
        this.threadsPanel.setStackWindow(stackWindow);
    }

    void threadsWindowSettingsChanged(boolean changed) {
        if (this.threadsPanel.treeTable == null) {
            return;
        }
        this.threadsPanel.treeTable.getTree().setShowsRootHandles(this.threadsWindowSettings.isShowThreadGroupStructure());
    }

    public DebuggerWindowProvider.DebuggerWindowPosition getPosition() {
        return DebuggerWindowProvider.DebuggerWindowPosition.WEST;
    }

    public void refresh() {
        this.everythingChanged();
    }

    public boolean installByDefault() {
        return true;
    }

    public void shutDown() {
        this.threadsPanel.saveSettings();
    }

    static void addContextMenuToMainMenu(Menubar menubar, JMenu subMenu) {
        ThreadsWindow.makeActions();
        float section = 1.0f;
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionMakeCurrent), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSuspend), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionResume), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionInterrupt), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebuggerStop), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionWatchThread), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionInspectThread), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionWatchClassLoader), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionInspectClassLoader), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGoTo), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDump), subMenu, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionExpandAll), subMenu, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionCollapseAll), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSave), subMenu, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSettings), subMenu, section);
    }

    private static void makeActions() {
        if (actionGoTo == null) {
            actionGoTo = IdeAction.get((int)GOTO_CMD_ID, null, (String)DbgArb.getString(66), null, (Integer)DbgArb.getInteger(483), null, (int)-1, null, (boolean)false);
            actionGoTo.setEnabled(false);
            actionMakeCurrent = IdeAction.get((int)MAKE_CURRENT_CMD_ID, null, (String)DbgArb.getString(818), null, (Integer)DbgArb.getInteger(34), null, (int)-1, null, (boolean)false);
            actionMakeCurrent.setEnabled(false);
            actionSuspend = IdeAction.get((int)SUSPEND_CMD_ID, null, (String)DbgArb.getString(264), null, (Integer)DbgArb.getInteger(498), null, (int)-1, null, (boolean)false);
            actionSuspend.setEnabled(false);
            actionResume = IdeAction.get((int)RESUME_CMD_ID, null, (String)DbgArb.getString(165), null, (Integer)DbgArb.getInteger(322), null, (int)-1, null, (boolean)false);
            actionResume.setEnabled(false);
            actionInterrupt = IdeAction.get((int)INTERRUPT_CMD_ID, null, (String)DbgArb.getString(840), null, (Integer)DbgArb.getInteger(837), null, (int)-1, null, (boolean)false);
            actionInterrupt.setEnabled(false);
            actionDebuggerStop = IdeAction.get((int)DEBUGGER_STOP_CMD_ID, null, (String)DbgArb.getString(142), null, (Integer)DbgArb.getInteger(417), null, (int)-1, null, (boolean)false);
            actionDebuggerStop.setEnabled(false);
            actionWatchThread = IdeAction.get((int)WATCH_THREAD_CMD_ID, null, (String)DbgArb.getString(954), null, (Integer)DbgArb.getInteger(782), null, (int)-1, null, (boolean)false);
            actionWatchThread.setEnabled(false);
            actionInspectThread = IdeAction.get((int)INSPECT_THREAD_CMD_ID, null, (String)DbgArb.getString(636), null, (Integer)DbgArb.getInteger(290), null, (int)-1, null, (boolean)false);
            actionInspectThread.setEnabled(false);
            actionWatchClassLoader = IdeAction.get((int)WATCH_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(739), null, (Integer)DbgArb.getInteger(811), null, (int)-1, null, (boolean)false);
            actionWatchClassLoader.setEnabled(false);
            actionInspectClassLoader = IdeAction.get((int)INSPECT_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(781), null, (Integer)DbgArb.getInteger(351), null, (int)-1, null, (boolean)false);
            actionInspectClassLoader.setEnabled(false);
            actionSettings = IdeAction.get((int)SETTINGS_CMD_ID, null, (String)RunMgrArb.getString(87), null, (Integer)RunMgrArb.getInteger(99), null, (int)-1, null, (boolean)false);
            actionSettings.setEnabled(false);
            actionExpandAll = IdeAction.get((int)EXPAND_ALL_CMD_ID, null, (String)RunMgrArb.getString(76), null, (Integer)RunMgrArb.getInteger(24), null, (int)-1, null, (boolean)false);
            actionExpandAll.setEnabled(false);
            actionCollapseAll = IdeAction.get((int)COLLAPSE_ALL_CMD_ID, null, (String)RunMgrArb.getString(0), null, (Integer)RunMgrArb.getInteger(7), null, (int)-1, null, (boolean)false);
            actionCollapseAll.setEnabled(false);
            actionSave = IdeAction.get((int)SAVE_CMD_ID, null, (String)RunMgrArb.getString(65), null, (Integer)RunMgrArb.getInteger(101), null, (int)-1, null, (boolean)false);
            actionSave.setEnabled(false);
            actionDump = IdeAction.get((int)DUMP_CMD_ID, null, (String)DbgArb.getString(651), null, (Integer)DbgArb.getInteger(948), null, (int)-1, null, (boolean)false);
            actionDump.setEnabled(false);
        }
    }

    private void setControllerForActions() {
        IdeAction[] actions = new IdeAction[]{actionGoTo, actionMakeCurrent, actionSuspend, actionResume, actionInterrupt, actionDebuggerStop, actionWatchThread, actionInspectThread, actionWatchClassLoader, actionInspectClassLoader, actionSettings, actionExpandAll, actionCollapseAll, actionSave, actionDump};
        JDebugger.setControllerForActions(actions, this.threadsPanel);
    }

    public Component getGUI() {
        if (this.gui == null) {
            this.gui = this.threadsPanel.getGUI();
            this.threadsPanel.loadSettings();
            this.threadsWindowSettingsChanged(false);
            this.threadsPanel.threadsPanelSettingsChanged(false);
            DebugDockableFactory.updateSiteGeometry((Dockable)this);
            this.everythingChanged();
            this.threadsWindowSettings.addStructureChangeListener(new 1());
        }
        return this.gui;
    }

    public ContextMenu getContextMenu() {
        return JDebugger.getInstance().getContextMenu();
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_deb_threadswindow_html");
    }

    public Controller getController() {
        return this.threadsPanel;
    }

    public Context getContext(EventObject event) {
        return this.threadsPanel.getContext(event);
    }

    public int getDefaultVisibility(Layout layout) {
        return 0;
    }

    public String getTabName() {
        return this.title;
    }

    public Icon getTabIcon() {
        if (threadsTabIcon == null) {
            threadsTabIcon = DbgArb.getIcon(63);
        }
        return threadsTabIcon;
    }

    public String getTitleName() {
        return this.title;
    }

    void everythingChanged() {
        this.threadsPanel.everythingChanged();
    }

    void updateThreads(DebuggingProcess debuggingProcess, DebugVirtualMachine vm, DebugThreadInfo currentThread) {
        this.threadsPanel.updateThreads(debuggingProcess, vm, currentThread);
    }

    void clearThreads() {
        this.threadsPanel.clearThreads();
    }

    void processFinished(DebuggingProcess debuggingProcess) {
        this.threadsPanel.processFinished(debuggingProcess);
    }

    static {
        MAKE_CURRENT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsMakeCurrent");
        SUSPEND_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsSuspend");
        RESUME_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsResume");
        INTERRUPT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsInterrupt");
        DEBUGGER_STOP_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsDebuggerStop");
        WATCH_THREAD_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsWatchThread");
        INSPECT_THREAD_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsInspectThread");
        WATCH_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsWatchClassLoader");
        INSPECT_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsInspectClassLoader");
        GOTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsGoTo");
        DUMP_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsDump");
        EXPAND_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsExpandAll");
        COLLAPSE_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsCollapseAll");
        SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsSave");
        SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsSettings");
        threadsTabIcon = null;
    }

    static ThreadsWindowSettings ra$threadsWindowSettings(ThreadsWindow threadsWindow) {
        return threadsWindow.threadsWindowSettings;
    }

    static int ra$SETTINGS_CMD_ID() {
        return SETTINGS_CMD_ID;
    }

    static int ra$MAKE_CURRENT_CMD_ID() {
        return MAKE_CURRENT_CMD_ID;
    }

    static int ra$SUSPEND_CMD_ID() {
        return SUSPEND_CMD_ID;
    }

    static int ra$RESUME_CMD_ID() {
        return RESUME_CMD_ID;
    }

    static int ra$WATCH_THREAD_CMD_ID() {
        return WATCH_THREAD_CMD_ID;
    }

    static int ra$INSPECT_THREAD_CMD_ID() {
        return INSPECT_THREAD_CMD_ID;
    }

    static int ra$WATCH_CLASSLOADER_CMD_ID() {
        return WATCH_CLASSLOADER_CMD_ID;
    }

    static int ra$INSPECT_CLASSLOADER_CMD_ID() {
        return INSPECT_CLASSLOADER_CMD_ID;
    }

    static int ra$EXPAND_ALL_CMD_ID() {
        return EXPAND_ALL_CMD_ID;
    }

    static int ra$COLLAPSE_ALL_CMD_ID() {
        return COLLAPSE_ALL_CMD_ID;
    }

    static int ra$DUMP_CMD_ID() {
        return DUMP_CMD_ID;
    }

    static int ra$INTERRUPT_CMD_ID() {
        return INTERRUPT_CMD_ID;
    }

    static int ra$DEBUGGER_STOP_CMD_ID() {
        return DEBUGGER_STOP_CMD_ID;
    }

    static IdeAction ra$actionSettings() {
        return actionSettings;
    }

    static JMenuItem ra$menuitemSettings() {
        return menuitemSettings;
    }

    static void wa$menuitemSettings(JMenuItem jMenuItem) {
        menuitemSettings = jMenuItem;
    }

    static IdeAction ra$actionExpandAll() {
        return actionExpandAll;
    }

    static JMenuItem ra$menuitemExpandAll() {
        return menuitemExpandAll;
    }

    static void wa$menuitemExpandAll(JMenuItem jMenuItem) {
        menuitemExpandAll = jMenuItem;
    }

    static IdeAction ra$actionCollapseAll() {
        return actionCollapseAll;
    }

    static JMenuItem ra$menuitemCollapseAll() {
        return menuitemCollapseAll;
    }

    static void wa$menuitemCollapseAll(JMenuItem jMenuItem) {
        menuitemCollapseAll = jMenuItem;
    }

    static IdeAction ra$actionDump() {
        return actionDump;
    }

    static JMenuItem ra$menuitemDump() {
        return menuitemDump;
    }

    static void wa$menuitemDump(JMenuItem jMenuItem) {
        menuitemDump = jMenuItem;
    }

    static IdeAction ra$actionMakeCurrent() {
        return actionMakeCurrent;
    }

    static JMenuItem ra$menuitemMakeCurrent() {
        return menuitemMakeCurrent;
    }

    static void wa$menuitemMakeCurrent(JMenuItem jMenuItem) {
        menuitemMakeCurrent = jMenuItem;
    }

    static IdeAction ra$actionSuspend() {
        return actionSuspend;
    }

    static JMenuItem ra$menuitemSuspend() {
        return menuitemSuspend;
    }

    static void wa$menuitemSuspend(JMenuItem jMenuItem) {
        menuitemSuspend = jMenuItem;
    }

    static IdeAction ra$actionResume() {
        return actionResume;
    }

    static JMenuItem ra$menuitemResume() {
        return menuitemResume;
    }

    static void wa$menuitemResume(JMenuItem jMenuItem) {
        menuitemResume = jMenuItem;
    }

    static IdeAction ra$actionInterrupt() {
        return actionInterrupt;
    }

    static JMenuItem ra$menuitemInterrupt() {
        return menuitemInterrupt;
    }

    static void wa$menuitemInterrupt(JMenuItem jMenuItem) {
        menuitemInterrupt = jMenuItem;
    }

    static IdeAction ra$actionDebuggerStop() {
        return actionDebuggerStop;
    }

    static JMenuItem ra$menuitemDebuggerStop() {
        return menuitemDebuggerStop;
    }

    static void wa$menuitemDebuggerStop(JMenuItem jMenuItem) {
        menuitemDebuggerStop = jMenuItem;
    }

    static IdeAction ra$actionWatchThread() {
        return actionWatchThread;
    }

    static JMenuItem ra$menuitemWatchThread() {
        return menuitemWatchThread;
    }

    static void wa$menuitemWatchThread(JMenuItem jMenuItem) {
        menuitemWatchThread = jMenuItem;
    }

    static IdeAction ra$actionInspectThread() {
        return actionInspectThread;
    }

    static JMenuItem ra$menuitemInspectThread() {
        return menuitemInspectThread;
    }

    static void wa$menuitemInspectThread(JMenuItem jMenuItem) {
        menuitemInspectThread = jMenuItem;
    }

    static IdeAction ra$actionWatchClassLoader() {
        return actionWatchClassLoader;
    }

    static JMenuItem ra$menuitemWatchClassLoader() {
        return menuitemWatchClassLoader;
    }

    static void wa$menuitemWatchClassLoader(JMenuItem jMenuItem) {
        menuitemWatchClassLoader = jMenuItem;
    }

    static IdeAction ra$actionInspectClassLoader() {
        return actionInspectClassLoader;
    }

    static JMenuItem ra$menuitemInspectClassLoader() {
        return menuitemInspectClassLoader;
    }

    static void wa$menuitemInspectClassLoader(JMenuItem jMenuItem) {
        menuitemInspectClassLoader = jMenuItem;
    }

    static IdeAction ra$actionGoTo() {
        return actionGoTo;
    }

    static IdeAction ra$actionSave() {
        return actionSave;
    }

    static int ra$GOTO_CMD_ID() {
        return GOTO_CMD_ID;
    }

    static int ra$SAVE_CMD_ID() {
        return SAVE_CMD_ID;
    }

    final class 1
    extends StructureChangeListener {
        public void structureValuesChanged(StructureChangeEvent e) {
            ThreadsWindow.this.threadsWindowSettingsChanged(true);
        }
    }

    final class AllThreadsPanel
    extends ThreadsPanel {
        private DebugThreadInfo highlightThread;
        private StackWindow stackWindow;

        AllThreadsPanel() {
            super(ThreadsWindow.this, ThreadsWindow.ra$threadsWindowSettings(ThreadsWindow.this).getThreadsPanelSettings());
            this._actionGoTo = ThreadsWindow.ra$actionGoTo();
            this._actionSave = ThreadsWindow.ra$actionSave();
            this._GOTO_CMD_ID = ThreadsWindow.ra$GOTO_CMD_ID();
            this._SAVE_CMD_ID = ThreadsWindow.ra$SAVE_CMD_ID();
        }

        void setStackWindow(StackWindow stackWindow) {
            this.stackWindow = stackWindow;
            this.updateStack();
        }

        protected void addPopupMenuItemsForThreadItem(ContextMenu popup, Context context) {
            this.update(ThreadsWindow.ra$actionMakeCurrent(), context);
            if (ThreadsWindow.ra$actionMakeCurrent().isEnabled()) {
                if (ThreadsWindow.ra$menuitemMakeCurrent() == null) {
                    ThreadsWindow.wa$menuitemMakeCurrent(popup.createMenuItem((ToggleAction)ThreadsWindow.ra$actionMakeCurrent()));
                }
                popup.add((Component)ThreadsWindow.ra$menuitemMakeCurrent(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            this.update(ThreadsWindow.ra$actionSuspend(), context);
            if (ThreadsWindow.ra$actionSuspend().isEnabled()) {
                if (ThreadsWindow.ra$menuitemSuspend() == null) {
                    ThreadsWindow.wa$menuitemSuspend(popup.createMenuItem((ToggleAction)ThreadsWindow.ra$actionSuspend()));
                }
                popup.add((Component)ThreadsWindow.ra$menuitemSuspend(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            this.update(ThreadsWindow.ra$actionResume(), context);
            if (ThreadsWindow.ra$actionResume().isEnabled()) {
                if (ThreadsWindow.ra$menuitemResume() == null) {
                    ThreadsWindow.wa$menuitemResume(popup.createMenuItem((ToggleAction)ThreadsWindow.ra$actionResume()));
                }
                popup.add((Component)ThreadsWindow.ra$menuitemResume(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            this.update(ThreadsWindow.ra$actionInterrupt(), context);
            if (ThreadsWindow.ra$actionInterrupt().isEnabled()) {
                if (ThreadsWindow.ra$menuitemInterrupt() == null) {
                    ThreadsWindow.wa$menuitemInterrupt(popup.createMenuItem((ToggleAction)ThreadsWindow.ra$actionInterrupt()));
                }
                popup.add((Component)ThreadsWindow.ra$menuitemInterrupt(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            this.update(ThreadsWindow.ra$actionDebuggerStop(), context);
            if (ThreadsWindow.ra$actionDebuggerStop().isEnabled()) {
                if (ThreadsWindow.ra$menuitemDebuggerStop() == null) {
                    ThreadsWindow.wa$menuitemDebuggerStop(popup.createMenuItem((ToggleAction)ThreadsWindow.ra$actionDebuggerStop()));
                }
                popup.add((Component)ThreadsWindow.ra$menuitemDebuggerStop(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            this.update(ThreadsWindow.ra$actionWatchThread(), context);
            if (ThreadsWindow.ra$actionWatchThread().isEnabled()) {
                if (ThreadsWindow.ra$menuitemWatchThread() == null) {
                    ThreadsWindow.wa$menuitemWatchThread(popup.createMenuItem((ToggleAction)ThreadsWindow.ra$actionWatchThread()));
                }
                popup.add((Component)ThreadsWindow.ra$menuitemWatchThread(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            this.update(ThreadsWindow.ra$actionInspectThread(), context);
            if (ThreadsWindow.ra$actionInspectThread().isEnabled()) {
                if (ThreadsWindow.ra$menuitemInspectThread() == null) {
                    ThreadsWindow.wa$menuitemInspectThread(popup.createMenuItem((ToggleAction)ThreadsWindow.ra$actionInspectThread()));
                }
                popup.add((Component)ThreadsWindow.ra$menuitemInspectThread(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            this.update(ThreadsWindow.ra$actionWatchClassLoader(), context);
            if (ThreadsWindow.ra$actionWatchClassLoader().isEnabled()) {
                if (ThreadsWindow.ra$menuitemWatchClassLoader() == null) {
                    ThreadsWindow.wa$menuitemWatchClassLoader(popup.createMenuItem((ToggleAction)ThreadsWindow.ra$actionWatchClassLoader()));
                }
                popup.add((Component)ThreadsWindow.ra$menuitemWatchClassLoader(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            this.update(ThreadsWindow.ra$actionInspectClassLoader(), context);
            if (ThreadsWindow.ra$actionInspectClassLoader().isEnabled()) {
                if (ThreadsWindow.ra$menuitemInspectClassLoader() == null) {
                    ThreadsWindow.wa$menuitemInspectClassLoader(popup.createMenuItem((ToggleAction)ThreadsWindow.ra$actionInspectClassLoader()));
                }
                popup.add((Component)ThreadsWindow.ra$menuitemInspectClassLoader(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            super.addPopupMenuItemsForThreadItem(popup, context);
        }

        protected void addPopupMenuItemsForThreads(ContextMenu popup, Context context) {
            this.update(ThreadsWindow.ra$actionDump(), context);
            if (ThreadsWindow.ra$actionDump().isEnabled()) {
                if (ThreadsWindow.ra$menuitemDump() == null) {
                    ThreadsWindow.wa$menuitemDump(popup.createMenuItem((ToggleAction)ThreadsWindow.ra$actionDump()));
                }
                popup.add((Component)ThreadsWindow.ra$menuitemDump(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_SPECIFIC_CTXT_MENU);
            }
            super.addPopupMenuItemsForThreads(popup, context);
        }

        protected void addPopupMenuItemsForTreeTable(ContextMenu popup, Context context) {
            this.update(ThreadsWindow.ra$actionExpandAll(), context);
            if (ThreadsWindow.ra$actionExpandAll().isEnabled()) {
                if (ThreadsWindow.ra$menuitemExpandAll() == null) {
                    ThreadsWindow.wa$menuitemExpandAll(popup.createMenuItem((ToggleAction)ThreadsWindow.ra$actionExpandAll()));
                }
                popup.add((Component)ThreadsWindow.ra$menuitemExpandAll(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_TREE_CTXT_MENU);
            }
            this.update(ThreadsWindow.ra$actionCollapseAll(), context);
            if (ThreadsWindow.ra$actionCollapseAll().isEnabled()) {
                if (ThreadsWindow.ra$menuitemCollapseAll() == null) {
                    ThreadsWindow.wa$menuitemCollapseAll(popup.createMenuItem((ToggleAction)ThreadsWindow.ra$actionCollapseAll()));
                }
                popup.add((Component)ThreadsWindow.ra$menuitemCollapseAll(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_TREE_CTXT_MENU);
            }
            super.addPopupMenuItemsForTreeTable(popup, context);
        }

        protected void addPopupMenuItemsForCommon(ContextMenu popup, Context context) {
            super.addPopupMenuItemsForCommon(popup, context);
            this.update(ThreadsWindow.ra$actionSettings(), context);
            if (ThreadsWindow.ra$actionSettings().isEnabled()) {
                if (ThreadsWindow.ra$menuitemSettings() == null) {
                    ThreadsWindow.wa$menuitemSettings(popup.createMenuItem((ToggleAction)ThreadsWindow.ra$actionSettings()));
                }
                popup.add((Component)ThreadsWindow.ra$menuitemSettings(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
            }
        }

        public boolean handleEvent(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (cmdId == ThreadsWindow.ra$MAKE_CURRENT_CMD_ID()) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    threadItem.makeCurrentThread();
                }
                return true;
            }
            if (cmdId == ThreadsWindow.ra$SUSPEND_CMD_ID()) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    threadItem.suspendThread();
                }
                return true;
            }
            if (cmdId == ThreadsWindow.ra$RESUME_CMD_ID()) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    threadItem.resumeThread();
                }
                return true;
            }
            if (cmdId == ThreadsWindow.ra$WATCH_THREAD_CMD_ID()) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    threadItem.watchThread();
                }
                return true;
            }
            if (cmdId == ThreadsWindow.ra$INSPECT_THREAD_CMD_ID()) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    threadItem.inspectThread();
                }
                return true;
            }
            if (cmdId == ThreadsWindow.ra$WATCH_CLASSLOADER_CMD_ID()) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    threadItem.watchClassLoader();
                }
                return true;
            }
            if (cmdId == ThreadsWindow.ra$INSPECT_CLASSLOADER_CMD_ID()) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    threadItem.inspectClassLoader();
                }
                return true;
            }
            if (cmdId == ThreadsWindow.ra$SETTINGS_CMD_ID()) {
                String[] path = new String[]{DbgArb.getString(16), DbgArb.getString(23)};
                Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), path);
                return true;
            }
            if (cmdId == ThreadsWindow.ra$EXPAND_ALL_CMD_ID()) {
                this.model.expandAll();
                return true;
            }
            if (cmdId == ThreadsWindow.ra$COLLAPSE_ALL_CMD_ID()) {
                this.model.collapseAll();
                return true;
            }
            if (cmdId == ThreadsWindow.ra$DUMP_CMD_ID()) {
                this.fullThreadDump();
                return true;
            }
            if (cmdId == ThreadsWindow.ra$INTERRUPT_CMD_ID()) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    threadItem.interruptThread();
                }
                return true;
            }
            if (cmdId == ThreadsWindow.ra$DEBUGGER_STOP_CMD_ID()) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    threadItem.stopThread();
                }
                return true;
            }
            return super.handleEvent(action, context);
        }

        public boolean update(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (action.getValue("Debugger.actionOwner") == this) {
                if (this.treeTable == null || !this.dockableWindow.isVisible()) {
                    action.setEnabled(false);
                    return true;
                }
                if (!(this.treeTable.isEnabled() && this.debuggingProcess != null && this.vm != null || cmdId == ThreadsWindow.ra$SETTINGS_CMD_ID())) {
                    action.setEnabled(false);
                    return true;
                }
            }
            if (cmdId == ThreadsWindow.ra$MAKE_CURRENT_CMD_ID()) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    action.setEnabled(threadItem.canMakeCurrentThread());
                } else {
                    action.setEnabled(false);
                }
                return true;
            }
            if (cmdId == ThreadsWindow.ra$SUSPEND_CMD_ID()) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    action.setEnabled(threadItem.canSuspendThread());
                } else {
                    action.setEnabled(false);
                }
                return true;
            }
            if (cmdId == ThreadsWindow.ra$RESUME_CMD_ID()) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    action.setEnabled(threadItem.canResumeThread());
                } else {
                    action.setEnabled(false);
                }
                return true;
            }
            if (cmdId == ThreadsWindow.ra$WATCH_THREAD_CMD_ID()) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    action.setEnabled(threadItem.canWatchInspectThread());
                } else {
                    action.setEnabled(false);
                }
                return true;
            }
            if (cmdId == ThreadsWindow.ra$INSPECT_THREAD_CMD_ID()) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    action.setEnabled(threadItem.canWatchInspectThread());
                } else {
                    action.setEnabled(false);
                }
                return true;
            }
            if (cmdId == ThreadsWindow.ra$WATCH_CLASSLOADER_CMD_ID() || cmdId == ThreadsWindow.ra$INSPECT_CLASSLOADER_CMD_ID()) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    action.setEnabled(threadItem.canWatchInspectClassLoader());
                } else {
                    action.setEnabled(false);
                }
                return true;
            }
            if (cmdId == ThreadsWindow.ra$SETTINGS_CMD_ID()) {
                action.setEnabled(true);
                return true;
            }
            if (cmdId == ThreadsWindow.ra$EXPAND_ALL_CMD_ID() || cmdId == ThreadsWindow.ra$COLLAPSE_ALL_CMD_ID()) {
                action.setEnabled(ThreadsWindow.ra$threadsWindowSettings(ThreadsWindow.this).isShowThreadGroupStructure());
                return true;
            }
            if (cmdId == ThreadsWindow.ra$DUMP_CMD_ID()) {
                action.setEnabled(true);
                return true;
            }
            if (cmdId == ThreadsWindow.ra$INTERRUPT_CMD_ID()) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    action.setEnabled(threadItem.canInterruptThread());
                } else {
                    action.setEnabled(false);
                }
                return true;
            }
            if (cmdId == ThreadsWindow.ra$DEBUGGER_STOP_CMD_ID()) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    action.setEnabled(threadItem.canDebuggerStopThread());
                } else {
                    action.setEnabled(false);
                }
                return true;
            }
            return super.update(action, context);
        }

        protected void addThreadItems() {
            List root = this.getRoot();
            if (ThreadsWindow.ra$threadsWindowSettings(ThreadsWindow.this).isShowThreadGroupStructure()) {
                DebugThreadGroupInfo[] groups = this.vm.listTopThreadGroups();
                Arrays.sort(groups, this);
                int i = 0;
                while (i < groups.length) {
                    root.add(new ThreadsPanel.ThreadItem(groups[i]));
                    ++i;
                }
            } else {
                DebugThreadInfo[] threads = this.vm.listThreads();
                Arrays.sort(threads, this);
                int i = 0;
                while (i < threads.length) {
                    root.add(new ThreadsPanel.ThreadItem(threads[i]));
                    ++i;
                }
            }
        }

        private void fullThreadDump() {
            URL url;
            String dlgTitle = DbgArb.getString(555);
            URLChooser chooser = DialogUtil.newURLChooser((Context)this.getContext());
            if (JDebugger.lastSavedFile != null) {
                chooser.setSelectedURL(JDebugger.lastSavedFile);
            }
            if (chooser.showSaveDialog((Component)Ide.getMainWindow(), dlgTitle) == 0 && (url = chooser.getSelectedURL()) != null) {
                JDebugger.lastSavedFile = url;
                WaitCursor wc = Ide.getWaitCursor();
                wc.show();
                Exception exceptionOccurred = null;
                try {
                    PrintWriter out;
                    String suffixUpper = URLFileSystem.getSuffix((URL)url).toUpperCase();
                    boolean html = suffixUpper.equals(".HTML") || suffixUpper.equals(".HTM");
                    PrintWriter printWriter = out = html ? JDebugger.printHtmlHeader(url, DbgArb.getString(675)) : new PrintWriter(new BufferedOutputStream(URLFileSystem.openOutputStream((URL)url)));
                    if (this.vm != null) {
                        String threadsHeader = this.getThreadsHeader(html);
                        String stackHeader = this.getStackHeader(html);
                        if (html) {
                            out.println("<table border=\"1\">");
                        }
                        out.println(threadsHeader);
                        StringBuffer sb = new StringBuffer();
                        DebugThreadInfo[] threads = this.vm.listThreads();
                        Arrays.sort(threads, this);
                        int threadsLength = threads.length;
                        int it = 0;
                        while (it < threadsLength) {
                            DebugThreadInfo thread = threads[it];
                            sb.setLength(0);
                            if (html) {
                                sb.append("<tr>");
                            }
                            int countThreadColumns = 0;
                            TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
                            Enumeration<TableColumn> e = tableColumnModel.getColumns();
                            while (e.hasMoreElements()) {
                                ++countThreadColumns;
                                TableColumn column = e.nextElement();
                                int ic = column.getModelIndex();
                                String columnValue = null;
                                String[] pd = null;
                                switch (ic) {
                                    case 0: {
                                        columnValue = thread.getName();
                                        break;
                                    }
                                    case 1: {
                                        columnValue = AllThreadsPanel.getThreadStatus(thread.getStatus());
                                        if (thread.isThreadSuspended()) {
                                            columnValue = columnValue + ' ' + DbgArb.getString(395);
                                        }
                                        if (!AllThreadsPanel.isDeadlocked(thread, this.debuggingProcess)) break;
                                        columnValue = columnValue + ' ' + DbgArb.getString(17);
                                        break;
                                    }
                                    case 2: {
                                        columnValue = thread.getGroupName();
                                        break;
                                    }
                                    case 3: {
                                        if (pd == null) {
                                            pd = AllThreadsPanel.getPriorityDaemon(thread);
                                        }
                                        columnValue = pd[0];
                                        break;
                                    }
                                    case 4: {
                                        if (pd == null) {
                                            pd = AllThreadsPanel.getPriorityDaemon(thread);
                                        }
                                        columnValue = pd[1];
                                        break;
                                    }
                                }
                                if (html) {
                                    sb.append("<td>");
                                    if (columnValue != null) {
                                        String columnValueString = IdeUtil.replaceHTMLReservedCharacters((String)columnValue);
                                        if (columnValueString.length() > 0) {
                                            sb.append(columnValueString);
                                        } else {
                                            sb.append("&nbsp;");
                                        }
                                    } else {
                                        sb.append("&nbsp;");
                                    }
                                    sb.append("</td>");
                                    continue;
                                }
                                if (columnValue != null) {
                                    sb.append(columnValue);
                                }
                                if (!e.hasMoreElements()) continue;
                                sb.append('\t');
                            }
                            if (html) {
                                sb.append("</tr>");
                            }
                            out.println(sb.toString());
                            DebugStackFrameInfo[] frames = thread.listStack();
                            int framesLength = frames.length;
                            if (framesLength > 0) {
                                if (html) {
                                    out.println("<tr><td></td><td colspan=" + (countThreadColumns - 1) + "><table border=\"1\">");
                                }
                                out.println(stackHeader);
                                int isf = 0;
                                while (isf < framesLength) {
                                    DebugMethodInfo method;
                                    DebugStackFrameInfo frame = frames[isf];
                                    DebugLocation location = frame.getLocation();
                                    if (location != null && (method = location.getMethod()) != null) {
                                        String methodName = DebugShared.makeCourtesyMethodName(method, true, true, frame);
                                        String filename = location.getFilename();
                                        int line = location.getLine();
                                        sb.setLength(0);
                                        if (html) {
                                            sb.append("<tr><td>");
                                            methodName = IdeUtil.replaceHTMLReservedCharacters((String)methodName);
                                            sb.append(methodName);
                                            sb.append("</td><td>");
                                            if (filename != null) {
                                                filename = IdeUtil.replaceHTMLReservedCharacters((String)filename);
                                                sb.append(filename);
                                            } else {
                                                sb.append("&nbsp;");
                                            }
                                            sb.append("</td><td>");
                                            if (line > 0) {
                                                sb.append(line);
                                            } else {
                                                sb.append("&nbsp;");
                                            }
                                            sb.append("</td></tr>");
                                        } else {
                                            sb.append('\t');
                                            sb.append(methodName);
                                            sb.append('\t');
                                            if (filename != null) {
                                                sb.append(filename);
                                            }
                                            sb.append('\t');
                                            if (line > 0) {
                                                sb.append(line);
                                            }
                                        }
                                        out.println(sb.toString());
                                    }
                                    ++isf;
                                }
                                if (html) {
                                    out.println("</table></td><tr>");
                                }
                            }
                            if (!html) {
                                out.println();
                            }
                            ++it;
                        }
                        if (html) {
                            out.println("</table>");
                        }
                    }
                    if (html) {
                        JDebugger.printHtmlFooter(out);
                    }
                    out.flush();
                    out.close();
                }
                catch (Exception e) {
                    exceptionOccurred = e;
                }
                wc.hide();
                if (exceptionOccurred != null) {
                    String message = DbgArb.format(932, URLFileSystem.getPlatformPathName((URL)url));
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exceptionOccurred, (String)dlgTitle, (String)message, null);
                }
            }
        }

        private String getThreadsHeader(boolean html) {
            StringBuffer sb = new StringBuffer();
            StringBuffer sb2 = new StringBuffer();
            if (html) {
                sb.append("<tr>");
            }
            TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
            Enumeration<TableColumn> e = tableColumnModel.getColumns();
            while (e.hasMoreElements()) {
                String columnName;
                TableColumn column = e.nextElement();
                int i = column.getModelIndex();
                String string = columnName = i == 0 ? DbgArb.getString(831) : this.model.getColumnName(i);
                if (html) {
                    sb.append("<th>");
                    columnName = IdeUtil.replaceHTMLReservedCharacters((String)columnName.toString());
                    sb.append(columnName);
                    sb.append("</th>");
                    continue;
                }
                sb.append(columnName);
                int ii = columnName.length();
                while (ii >= 0) {
                    sb2.append('-');
                    --ii;
                }
                if (!e.hasMoreElements()) continue;
                sb.append('\t');
                sb2.append('\t');
            }
            if (html) {
                sb.append("</tr>");
            }
            if (!html) {
                sb.append(System.getProperty("line.separator"));
                sb.append(sb2.toString());
            }
            return sb.toString();
        }

        private String getStackHeader(boolean html) {
            StringBuffer sb = new StringBuffer();
            StringBuffer sb2 = new StringBuffer();
            if (html) {
                sb.append("<tr><th colspan=3>");
                sb.append(DbgArb.getString(767));
                sb.append("</th></tr>");
                sb.append("<tr>");
            }
            int nColumns = 3;
            String[] columnNames = new String[]{DbgArb.getString(116), DbgArb.getString(595), DbgArb.getString(527)};
            int i = 0;
            while (i < 3) {
                String columnName = columnNames[i];
                if (html) {
                    sb.append("<th>");
                    columnName = IdeUtil.replaceHTMLReservedCharacters((String)columnName.toString());
                    sb.append(columnName);
                    sb.append("</th>");
                } else {
                    sb.append('\t');
                    sb.append(columnName);
                    sb2.append('\t');
                    int ii = columnName.length();
                    while (ii >= 0) {
                        sb2.append('-');
                        --ii;
                    }
                }
                ++i;
            }
            if (html) {
                sb.append("</tr>");
            }
            if (!html) {
                sb.append(System.getProperty("line.separator"));
                sb.append(sb2.toString());
            }
            return sb.toString();
        }

        public void valueChanged(TreeSelectionEvent e) {
            super.valueChanged(e);
            if (this.treeTable.isShowing()) {
                this.highlightThread = this.getSelectedThreadInfo();
                if (this.highlightThread != null) {
                    this.updateStack();
                }
            }
        }

        protected ThreadsPanel.ThreadInfoPath getCurrentHighlight() {
            if (this.debuggingProcess != null && this.highlightThread != null) {
                return new ThreadsPanel.ThreadInfoPath(this.debuggingProcess, this.highlightThread);
            }
            return super.getCurrentHighlight();
        }

        void updateThreads(DebuggingProcess debuggingProcess, DebugVirtualMachine vm, DebugThreadInfo highlightThread) {
            this.highlightThread = highlightThread;
            super.updateThreads(debuggingProcess, vm, highlightThread);
            if (!this.treeTable.isShowing() || highlightThread == null) {
                this.updateStack();
            }
        }

        void clearThreads() {
            super.clearThreads();
            this.updateStack();
        }

        void processFinished(DebuggingProcess debuggingProcess) {
            if (this.debuggingProcess == debuggingProcess) {
                this.highlightThread = null;
            }
            super.processFinished(debuggingProcess);
            if (this.stackWindow != null) {
                this.stackWindow.processFinished(debuggingProcess);
            }
        }

        void updateStack() {
            if (this.stackWindow != null) {
                if (this.treeTable != null && this.treeTable.isEnabled()) {
                    if (this.debuggingProcess != null && this.vm != null) {
                        this.stackWindow.updateStack(this.debuggingProcess, this.vm, this.highlightThread);
                    } else {
                        this.stackWindow.updateStack(null, null, null);
                    }
                } else {
                    this.stackWindow.clearStack();
                }
            }
        }
    }
}

