/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.model.Node;
import oracle.ide.runner.ToolTipExpressionProvider;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.Evaluator;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.StackWindow;

class ToolTipEvaluator {
    private JDebugger jdebugger;
    private Evaluator evaluator;

    ToolTipEvaluator(JDebugger jdebugger) {
        this.jdebugger = jdebugger;
        this.evaluator = new Evaluator(false);
    }

    String getToolTip(CodeEditor codeEditor, int offset) {
        try {
            Node node = codeEditor.getContext().getNode();
            ArrayList expressions = new ArrayList();
            this.getExpressions(codeEditor, node, offset, expressions);
            if (!expressions.isEmpty()) {
                int i = 0;
                while (i < expressions.size()) {
                    String evaluation;
                    String expression = JDebugger.trimExpression((String)expressions.get(i));
                    if (expression.length() > 0 && (evaluation = this.evaluate(expression)) != null && evaluation.length() > 0) {
                        String string = DbgArb.format(57, expression, evaluation);
                        return string;
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void getExpressions(CodeEditor codeEditor, Node node, int offset, List expressions) {
        String lineOfText;
        int selectionEnd;
        String selectedText = null;
        int selectionStart = codeEditor.getSelectionStart();
        if (selectionStart != (selectionEnd = codeEditor.getSelectionEnd()) && selectionStart <= offset && offset <= selectionEnd) {
            selectedText = codeEditor.getSelectedText();
        }
        int line = codeEditor.getLineFromOffset(offset);
        int lineStart = codeEditor.getLineStartOffset(line);
        int lineEnd = codeEditor.getLineEndOffset(line);
        int offsetWithinLine = offset - lineStart;
        try {
            lineOfText = codeEditor.getText(lineStart, lineEnd - lineStart);
        }
        catch (Exception e) {
            lineOfText = "";
        }
        int lineOfTextLength = lineOfText.length();
        List<ToolTipExpressionProvider> toolTipExpressionProviders = JDebugger.getToolTipExpressionProviders();
        int i = 0;
        while (i < toolTipExpressionProviders.size()) {
            ToolTipExpressionProvider toolTipExpressionProvider = toolTipExpressionProviders.get(i);
            try {
                if (toolTipExpressionProvider.canUnderstand(node)) {
                    String expression;
                    boolean caseInsensitive = toolTipExpressionProvider.isLanguageCaseInsensitive();
                    if (selectedText != null) {
                        String upper;
                        if (!expressions.contains(selectedText)) {
                            expressions.add(selectedText);
                        }
                        if (caseInsensitive && !(upper = selectedText.toUpperCase()).equals(selectedText) && !expressions.contains(upper)) {
                            expressions.add(upper);
                        }
                    }
                    if (lineOfTextLength > 0 && (expression = toolTipExpressionProvider.getExpression(lineOfText, offsetWithinLine)) != null) {
                        String upper;
                        if (!expressions.contains(expression)) {
                            expressions.add(expression);
                        }
                        if (caseInsensitive && !(upper = expression.toUpperCase()).equals(expression) && !expressions.contains(upper)) {
                            expressions.add(upper);
                        }
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            ++i;
        }
        if (expressions.isEmpty() && lineOfTextLength > 0 && 0 <= offsetWithinLine && offsetWithinLine < lineOfTextLength) {
            char[] ca = new char[lineOfTextLength];
            lineOfText.getChars(0, lineOfTextLength, ca, 0);
            int start = ToolTipEvaluator.findStartOfUnknownExpression(ca, lineOfTextLength, offsetWithinLine);
            int end = ToolTipEvaluator.findEndOfUnknownExpression(ca, lineOfTextLength, start);
            String expression = lineOfText.substring(start, end);
            if (expression.length() > 0 && !expressions.contains(expression)) {
                expressions.add(expression);
            }
        }
    }

    private static int findStartOfUnknownExpression(char[] ca, int length, int offset) {
        int i = offset;
        while (0 <= i && i < length) {
            if (!ToolTipEvaluator.isUnknownExpressionPart(ca[i])) {
                return i + 1;
            }
            --i;
        }
        return 0;
    }

    private static int findEndOfUnknownExpression(char[] ca, int length, int start) {
        int i = start;
        while (0 <= i && i < length) {
            if (!ToolTipEvaluator.isUnknownExpressionPart(ca[i])) {
                return i;
            }
            ++i;
        }
        return length;
    }

    private static boolean isUnknownExpressionPart(char c) {
        return Character.isJavaIdentifierPart(c) || c == '.' || c == '[' || c == ']';
    }

    private String evaluate(String expression) {
        StackWindow stackWindow = this.jdebugger.getStackWindow(true);
        stackWindow.updateEvaluator(this.evaluator);
        Object info = this.evaluator.evaluate(expression);
        if (info != null) {
            DebugDataInfo data = Evaluator.getDataInfo(info);
            String dataValue = DataPanel.makeDataValue(info, data);
            if ((dataValue == null || dataValue.length() == 0) && data instanceof DebugDataCompositeInfo && !((DebugDataCompositeInfo)data).isNull()) {
                DebugClassInfo clazz = data.getClassInfo();
                dataValue = "( " + DebugShared.makeCourtesyClassName(clazz, true) + " )";
            }
            return dataValue;
        }
        return null;
    }

    void clearEvaluator() {
        StackWindow stackWindow = this.jdebugger.getStackWindow(true);
        stackWindow.updateEvaluator(this.evaluator);
    }
}

