/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import oracle.ide.model.Node;
import oracle.ide.runner.ToolTipExpressionProvider;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;
import oracle.jdeveloper.model.JavaSourceNode;

class ToolTipJava
implements ToolTipExpressionProvider {
    public boolean canUnderstand(Node node) {
        return node instanceof JavaSourceNode;
    }

    public boolean isLanguageCaseInsensitive() {
        return false;
    }

    public String getExpression(String lineOfText, int mouseOffset) {
        int start;
        int token;
        int length = lineOfText.length();
        char[] ca = new char[length];
        lineOfText.getChars(0, length, ca, 0);
        ReadTextBuffer tb = TextBufferFactory.createReadTextBuffer((String)lineOfText);
        JavaLexer javaLexer = new JavaLexer();
        LexerToken lexerToken = javaLexer.createLexerToken();
        javaLexer.setTextBuffer(tb);
        javaLexer.setPosition(0);
        javaLexer.setSkipComments(true);
        while ((token = javaLexer.lex(lexerToken)) != 0 && (start = lexerToken.getStartOffset()) <= mouseOffset) {
            int end;
            if (token != 4 && token != 136 || (end = ToolTipJava.findEndOfJavaExpression(ca, length, start)) < mouseOffset) continue;
            return tb.getString(start, end - start);
        }
        return null;
    }

    private static int findEndOfJavaExpression(char[] ca, int length, int start) {
        int i = start;
        while (0 <= i && i < length) {
            if (!ToolTipJava.isJavaExpressionPart(ca[i])) {
                return i;
            }
            ++i;
        }
        return length;
    }

    private static boolean isJavaExpressionPart(char c) {
        return Character.isJavaIdentifierPart(c) || c == '.' || c == '[' || c == ']';
    }

    ToolTipJava() {
    }
}

