/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.HashMap;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableWindow;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.layout.ViewId;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogWindow;
import oracle.ide.runner.DebuggerEvaluator;
import oracle.ide.runner.DebuggerWindowProvider;
import oracle.ide.runner.DebuggerWindowProviderCallback;
import oracle.jdevimpl.runner.debug.DebugDockableFactory;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.Evaluator;
import oracle.jdevimpl.runner.debug.EvaluatorHandle;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.WindowProviderCallback;

class WindowManager {
    private Map<String, WindowProviderCallback> debuggerWindowProviders;

    private void $init$() {
        this.debuggerWindowProviders = new HashMap<String, WindowProviderCallback>();
    }

    WindowManager() {
        this.$init$();
    }

    DebuggerWindowProviderCallback addDebuggerWindowProvider(DebuggerWindowProvider provider, boolean customWindow) {
        WindowProviderCallback callback = new WindowProviderCallback(this, provider, customWindow);
        String ID = provider.getWindow().getId();
        this.debuggerWindowProviders.put(ID, callback);
        return callback;
    }

    void removeDebuggerWindowProvider(DebuggerWindowProvider provider) {
        String ID = provider.getWindow().getId();
        this.debuggerWindowProviders.remove(ID);
    }

    DockableWindow getDebuggerWindow(String windowID) {
        WindowProviderCallback callback = this.debuggerWindowProviders.get(windowID);
        if (callback != null) {
            return callback.getProvider().getWindow();
        }
        return null;
    }

    DebuggerWindowProvider getDebuggerWindowProvider(String windowID) {
        WindowProviderCallback callback = this.debuggerWindowProviders.get(windowID);
        if (callback != null) {
            return callback.getProvider();
        }
        return null;
    }

    private void markAsInstalled(String windowID) {
        WindowProviderCallback callback = this.debuggerWindowProviders.get(windowID);
        if (callback != null) {
            callback.setInstalled();
        }
    }

    private boolean isInstalled(String windowID) {
        WindowProviderCallback callback = this.debuggerWindowProviders.get(windowID);
        if (callback != null) {
            return callback.isInstalled();
        }
        return false;
    }

    void installWindow(String windowID) {
        JDebugger.getInstance().getOrCreateDebuggerWindow(windowID);
        if (this.isInstalled(windowID)) {
            return;
        }
        this.markAsInstalled(windowID);
        DebugDockableFactory factory = JDebugger.getInstance().getDebugDockableFactory();
        DebuggerWindowProvider provider = this.getDebuggerWindowProvider(windowID);
        if (provider != null) {
            ViewId viewId;
            DockStation ds = DockStation.getDockStation();
            if (ds.getDockable(viewId = new ViewId(windowID)) != null) {
                return;
            }
            LogWindow tabbedWith = null;
            int position = 0;
            switch (1.$sm$oracle$ide$runner$DebuggerWindowProvider$DebuggerWindowPosition[provider.getPosition().ordinal()]) {
                case 1: {
                    tabbedWith = LogManager.getIdeLogWindow();
                    position = 3;
                    break;
                }
                case 2: {
                    tabbedWith = ds.findDockable(ExplorerManager.getExplorerManager().getDefaultViewId());
                    position = 0;
                    break;
                }
                case 3: {
                    if (windowID != "Debugger.ClassesWindow") {
                        tabbedWith = ds.findDockable(new ViewId("Debugger.ClassesWindow"));
                    }
                    position = 1;
                    break;
                }
                case 4: {
                    factory.floatWindow(provider.getWindow(), provider.getFloatingPosition());
                    return;
                }
            }
            factory.installWindow(provider.getWindow(), (Dockable)tabbedWith, position);
        }
    }

    void installCustomWindows() {
        for (WindowProviderCallback callback : this.debuggerWindowProviders.values()) {
            if (!callback.isCustomWindow() || !callback.getProvider().installByDefault()) continue;
            this.installWindow(callback.getProvider().getWindow().getId());
        }
    }

    void setDebuggerWindowProvidersContext(Context context) {
        for (WindowProviderCallback callback : this.debuggerWindowProviders.values()) {
            try {
                callback.getProvider().setContext(context);
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"Custom Debugger Window Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
    }

    void refreshCustomWindows(Evaluator evaluator, DebuggingProcess process) {
        for (WindowProviderCallback callback : this.debuggerWindowProviders.values()) {
            if (!callback.isCustomWindow()) continue;
            try {
                if (evaluator != null && process != null) {
                    EvaluatorHandle handle = new EvaluatorHandle(evaluator, process, callback.getCustomDataProvider());
                    callback.getProvider().setEvaluator((DebuggerEvaluator)handle);
                }
                callback.getProvider().refresh();
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"Custom Debugger Window Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
    }

    void refreshCustomWindows() {
        this.refreshCustomWindows(null, null);
    }

    void shutdownWindows() {
        for (WindowProviderCallback callback : this.debuggerWindowProviders.values()) {
            try {
                callback.getProvider().shutDown();
            }
            catch (Exception ex) {
                FeedbackManager.reportException((String)"Custom Debugger Window Failure", (Throwable)ex);
                ex.printStackTrace();
            }
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $sm$oracle$ide$runner$DebuggerWindowProvider$DebuggerWindowPosition;

        static {
            int[] nArray = new int[DebuggerWindowProvider.DebuggerWindowPosition.values().length];
            $sm$oracle$ide$runner$DebuggerWindowProvider$DebuggerWindowPosition = nArray;
            try {
                nArray[DebuggerWindowProvider.DebuggerWindowPosition.SOUTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$ide$runner$DebuggerWindowProvider$DebuggerWindowPosition[DebuggerWindowProvider.DebuggerWindowPosition.WEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$ide$runner$DebuggerWindowProvider$DebuggerWindowPosition[DebuggerWindowProvider.DebuggerWindowPosition.EAST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$ide$runner$DebuggerWindowProvider$DebuggerWindowPosition[DebuggerWindowProvider.DebuggerWindowPosition.FLOATING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
        }
    }
}

