/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import oracle.ide.layout.Layout;
import oracle.ide.runner.DebuggerWindowProvider;
import oracle.ide.runner.DebuggerWindowProviderCallback;
import oracle.jdevimpl.runner.debug.CustomDataProvider;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.WindowManager;

class WindowProviderCallback
implements DebuggerWindowProviderCallback {
    private WindowManager windowManager;
    private DebuggerWindowProvider provider;
    private boolean installed;
    private boolean isCustomWindow;
    private CustomDataProvider customDataProvider;

    WindowProviderCallback(WindowManager windowManager, DebuggerWindowProvider provider, boolean isCustomWindow) {
        this.windowManager = windowManager;
        this.provider = provider;
        this.isCustomWindow = isCustomWindow;
    }

    DebuggerWindowProvider getProvider() {
        return this.provider;
    }

    CustomDataProvider getCustomDataProvider() {
        if (this.customDataProvider == null) {
            this.customDataProvider = new CustomDataProvider();
        }
        return this.customDataProvider;
    }

    public void install() {
        if (!this.installed) {
            this.windowManager.installWindow(this.getProvider().getWindow().getId());
        }
    }

    public int getDebuggerWindowDefaultVisibility(Layout layout) {
        boolean visible = JDebugger.getInstance().canShowDebuggingWindows(layout);
        return visible ? 1 : 0;
    }

    public void setDisplayShowPackages(boolean displaySetting) {
        this.getCustomDataProvider();
        this.customDataProvider.setDisplayShowPackages(displaySetting);
    }

    public void setDisplaySortFieldsByName(boolean displaySetting) {
        this.getCustomDataProvider();
        this.customDataProvider.setDisplaySortFieldsByName(displaySetting);
    }

    public void setDisplayHideStaticFields(boolean displaySetting) {
        this.getCustomDataProvider();
        this.customDataProvider.setDisplayHideStaticFields(displaySetting);
    }

    public void setDisplayHideFinalFields(boolean displaySetting) {
        this.getCustomDataProvider();
        this.customDataProvider.setDisplayHideFinalFields(displaySetting);
    }

    public void setDisplayHideSyntheticFields(boolean displaySetting) {
        this.getCustomDataProvider();
        this.customDataProvider.setDisplayHideSyntheticFields(displaySetting);
    }

    public void setDisplayHideNullArrayElements(boolean displaySetting) {
        this.getCustomDataProvider();
        this.customDataProvider.setDisplayHideNullArrayElements(displaySetting);
    }

    void setInstalled() {
        this.installed = true;
    }

    boolean isInstalled() {
        return this.installed;
    }

    boolean isCustomWindow() {
        return this.isCustomWindow;
    }
}

