/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.util.TriStateBoolean;
import oracle.jdevimpl.runner.profile.BaseSavable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BasicEvent
extends JMutableTreeNode
implements Transferable,
BaseSavable {
    public static final int DMS_ID = -99;
    static final DataFlavor eventFlavor = new DataFlavor("application/x-myobject; class=oracle.jdevimpl.runner.profile.BasicEvent", "Event");
    static final DataFlavor[] transferFlavors = new DataFlavor[]{eventFlavor, DataFlavor.stringFlavor};
    String _key;
    int _id;
    Color _color;
    private static char[] currentArr;
    private static int cpos;

    public BasicEvent(int id, String name, Color co, TriStateBoolean checkBoxState) {
        super(new JTreeCellData(null, name, true, checkBoxState));
        if (co != null) {
            JTreeCellData cd = (JTreeCellData)this.getUserObject();
            cd.setIcon((Icon)new ColorIcon());
            this._color = co;
        }
        this._id = id;
        this._key = name;
        this.updateText();
    }

    public BasicEvent(BasicEvent org) {
        this(org._id, org._key, org._color, org.getModel().getCheckBoxState());
        Enumeration childs = org.children();
        while (childs.hasMoreElements()) {
            this.add((MutableTreeNode)((Object)new BasicEvent((BasicEvent)childs.nextElement())));
        }
    }

    public BasicEvent(String name) {
        this(-1, name, null, TriStateBoolean.TRUE);
    }

    public BasicEvent(String name, TriStateBoolean st) {
        this(-1, name, null, st);
    }

    @Override
    public void saveToFile(DataOutputStream stream) throws IOException {
        stream.writeInt(this._id);
        stream.writeUTF(this._key);
        stream.writeInt(this._color.getRGB());
    }

    public static BasicEvent readFromFile(DataInputStream stream) throws IOException {
        int id = stream.readInt();
        String key = stream.readUTF();
        Color co = new Color(stream.readInt());
        return new BasicEvent(id, key, co, TriStateBoolean.TRUE);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return transferFlavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(eventFlavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (flavor.equals(eventFlavor)) {
            return this;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public static BasicEvent parseFromArray() {
        BasicEvent res;
        block7: {
            char[] arrc;
            block6: {
                res = null;
                arrc = currentArr;
                while (arrc[cpos] == '\n' || arrc[cpos] == ' ' || arrc[cpos] == '\r' || arrc[cpos] == '\t') {
                    ++cpos;
                }
                if (arrc[cpos] != 'G') break block6;
                int npo = cpos += 2;
                while (arrc[npo] != ';') {
                    ++npo;
                }
                String name = new String(arrc, cpos, npo - cpos);
                cpos = ++npo;
                res = new BasicEvent(name);
                ++cpos;
                while (arrc[cpos] != ')') {
                    res.add((MutableTreeNode)((Object)BasicEvent.parseFromArray()));
                }
                cpos += 3;
                break block7;
            }
            if (arrc[cpos] != 'E') break block7;
            int npo = cpos += 2;
            while (arrc[npo] != ';') {
                ++npo;
            }
            int id = Integer.parseInt(new String(arrc, cpos, npo - cpos));
            cpos = ++npo;
            while (arrc[npo] != ';') {
                ++npo;
            }
            String name = new String(arrc, cpos, npo - cpos);
            cpos = ++npo;
            while (arrc[npo] != ';') {
                ++npo;
            }
            Color co = new Color(Integer.parseInt(new String(arrc, cpos, npo - cpos)));
            cpos = ++npo;
            res = new BasicEvent(id, name, co, arrc[npo] == '1' ? TriStateBoolean.TRUE : TriStateBoolean.FALSE);
            cpos += 3;
        }
        return res;
    }

    static synchronized BasicEvent parseFromString(String s) {
        cpos = 0;
        currentArr = s.toCharArray();
        BasicEvent res = BasicEvent.parseFromArray();
        return res;
    }

    private void updateText() {
        if (this._color != null) {
            this.getModel().setText(Integer.toString(this._id) + " : " + this._key);
        } else {
            this.getModel().setText(this._key);
        }
    }

    public int getId() {
        return this._id;
    }

    public void setId(int id) {
        this._id = id;
        this.updateText();
    }

    public String getName() {
        return this._key;
    }

    public void setName(String key) {
        this._key = key;
        this.updateText();
    }

    public Color getColor() {
        return this._color;
    }

    public boolean getSelected() {
        return this.getModel().getCheckBoxState() == TriStateBoolean.TRUE;
    }

    public void setColor(Color color) {
        this._color = color;
    }

    public void checkSelected() {
        TriStateBoolean curselect = TriStateBoolean.UNDEF;
        Enumeration childs = this.children();
        while (childs.hasMoreElements()) {
            BasicEvent child = (BasicEvent)childs.nextElement();
            child.checkSelected();
            if (curselect == TriStateBoolean.UNDEF) {
                curselect = child.getModel().getCheckBoxState();
                continue;
            }
            if (curselect == TriStateBoolean.TRI_STATE || curselect == child.getModel().getCheckBoxState()) continue;
            curselect = TriStateBoolean.TRI_STATE;
        }
        if (curselect != TriStateBoolean.UNDEF) {
            this.getModel().setCheckBoxState(curselect);
        }
    }

    public void initSelected() {
        Enumeration childs;
        if (this.getModel().getCheckBoxState() == TriStateBoolean.TRUE) {
            childs = this.children();
            while (childs.hasMoreElements()) {
                BasicEvent child = (BasicEvent)childs.nextElement();
                child.getModel().setCheckBoxState(TriStateBoolean.TRUE);
            }
        }
        childs = this.children();
        while (childs.hasMoreElements()) {
            BasicEvent child = (BasicEvent)childs.nextElement();
            child.initSelected();
        }
    }

    public String getStringValue() {
        StringBuffer sb = new StringBuffer();
        if (this._color == null) {
            sb.append("G(");
            sb.append(this._key);
            sb.append(";(");
            Enumeration childs = this.children();
            while (childs.hasMoreElements()) {
                BasicEvent child = (BasicEvent)childs.nextElement();
                sb.append(child.getStringValue());
            }
            sb.append("));");
        } else {
            sb.append("E(");
            sb.append(this._id);
            sb.append(";");
            sb.append(this._key);
            sb.append(";");
            sb.append(this._color.getRGB());
            if (this.getModel().getCheckBoxState() == TriStateBoolean.TRUE) {
                sb.append(";1);");
            } else {
                sb.append(";0);");
            }
        }
        return sb.toString();
    }

    class ColorIcon
    implements Icon {
        private static final int SMALL_SIZE = 12;

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (BasicEvent.this._color != null) {
                Color oldColor = g.getColor();
                g.setColor(Color.black);
                g.drawRect(x, y, 11, 11);
                g.setColor(BasicEvent.this._color);
                g.fillRect(x + 1, y + 1, 10, 10);
                g.setColor(oldColor);
            }
        }

        public int getIconWidth() {
            return 12;
        }

        public int getIconHeight() {
            return 12;
        }

        ColorIcon() {
        }
    }
}

