/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import oracle.ide.util.IntHashMap;
import oracle.jdevimpl.runner.profile.FileSaver;
import oracle.jdevimpl.runner.profile.MethodCallCountItem;
import oracle.jdevimpl.runner.profile.RootCallCountItem;
import oracle.jdevimpl.runner.profile.SubCallCount;
import oracle.jdevimpl.runner.profile.ThreadCallCountItem;
import oracle.jdevimpl.runner.profile.VMTypes;

class CallCountItem
extends VMTypes {
    private static SubCallCountComparator sccComp = new SubCallCountComparator();
    int ref;
    ArrayList calledList;
    ArrayList callerList;
    boolean callSorted;
    int calledTotal;
    int callerTotal;

    CallCountItem(int rf) {
        this.ref = rf;
        this.calledTotal = 0;
        this.callerTotal = 0;
        this.callSorted = false;
        this.callerList = new ArrayList(5);
    }

    CallCountItem() {
        this.callerList = new ArrayList(5);
    }

    public void saveToFile(DataOutputStream stream) throws IOException {
        super.saveToFile(stream);
        stream.writeInt(this.ref);
        stream.writeInt(this.calledTotal);
        stream.writeInt(this.callerTotal);
        FileSaver.saveVMObjectToFile(this.calledList, stream);
    }

    public void initFromFile(DataInputStream stream) throws IOException {
        super.initFromFile(stream);
        this.ref = stream.readInt();
        this.calledTotal = stream.readInt();
        this.callerTotal = stream.readInt();
        int sz = stream.readInt();
        this.calledList = new ArrayList(sz);
        int i = 0;
        while (i < sz) {
            this.calledList.add(SubCallCount.readFromFile(stream));
            ++i;
        }
    }

    public static CallCountItem readFromFile(DataInputStream stream, IntHashMap methodMap) throws IOException {
        byte type = stream.readByte();
        CallCountItem res = null;
        switch (type) {
            case 0: {
                MethodCallCountItem mc = new MethodCallCountItem();
                mc.initFromFile(stream, methodMap);
                res = mc;
                break;
            }
            case 1: {
                ThreadCallCountItem tc = new ThreadCallCountItem();
                tc.initFromFile(stream);
                res = tc;
                break;
            }
            case 2: {
                RootCallCountItem rc = new RootCallCountItem();
                rc.initFromFile(stream);
                res = rc;
                break;
            }
        }
        return res;
    }

    private static ArrayList sortCallList(ArrayList lst) {
        Object[] olist = lst.toArray();
        Arrays.sort(olist, sccComp);
        ArrayList<Object> res = new ArrayList<Object>(olist.length);
        int i = 0;
        while (i < olist.length) {
            res.add(olist[i]);
            ++i;
        }
        return res;
    }

    void sortCalls() {
        if (this.callSorted) {
            return;
        }
        this.callSorted = true;
        this.callerList = CallCountItem.sortCallList(this.callerList);
        this.calledList = CallCountItem.sortCallList(this.calledList);
    }

    ArrayList getCalledList() {
        return this.calledList;
    }

    ArrayList getCallerList() {
        return this.callerList;
    }

    void setCalledList(ArrayList al) {
        this.calledList = al;
    }

    void setCallerList(ArrayList al) {
        this.callerList = al;
    }

    String getPseudoClass() {
        return "";
    }

    String getPseudoName() {
        return "";
    }

    String getNiceSignature() {
        return "";
    }

    String getFileName() {
        return null;
    }

    int getLine() {
        return -1;
    }

    String getPackage() {
        return null;
    }

    int getCallCount() {
        return 0;
    }

    int getOnStackCount() {
        return 0;
    }

    int getRef() {
        return this.ref;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SubCallCountComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            SubCallCount m1 = (SubCallCount)o1;
            SubCallCount m2 = (SubCallCount)o2;
            return m2.count - m1.count;
        }

        SubCallCountComparator() {
        }
    }
}

